/*
 * Copyright (c) 2018-2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//
//File Name: launch_j721e.js
//Description:
//   Launch the DMSC firmware and board configuration from R5F.
//
//Usage:
//
//From CCS Scripting console
//  1. loadJSFile "C:\\ti\\launch_j721e.js"
//
//Note:
//  1. Search for "edit this" to look at changes that need to be edited
//     for your usage.
//


//<!!!!!! EDIT THIS !!!!!>
// Set this to 1 to allow loading the GEL files directly from the ccxml file.
disableGelLoad = 0;
// Set to 1 to use the firmware with Firewalls.
if (disableGelLoad == 0)
{
    //Path to GEL files
    //设置CCS的路径
    gelFilePath = "C:\ti\ccs1000\ccs\ccs_base\emulation\pg1p1_hs_gel\J721E_DRA829_TDA4VMM";
}


//<!!!!!! EDIT THIS !!!!!>
//package FileHandling;

// Import the DSS packages into our namespace to save on typing
importPackage(Packages.com.ti.debug.engine.scripting)
importPackage(Packages.com.ti.ccstudio.scripting.environment)
importPackage(Packages.java.lang)
importPackage(Packages.java.io);
importPackage(Packages.java.lang);
//importPackage(java.io.File);
// Import this class to handle errors
//importPackage(Packages.java.io);

// Import the Scanner class to read text files
importPackage(Packages.java.util);

function updateScriptVars()
{
    debugServer.setConfig("config/NoGel_blackhawk_560.ccxml");
    //Open a debug session
    dsMCU1_0 = debugServer.openSession( ".*MCU_Cortex_R5_0" );
}

function printVars()
{
    updateScriptVars();
}

function connectTargets()
{
    /* Set timeout of 20 seconds */
    script.setScriptTimeout(200000);
    updateScriptVars();

    print("Connecting to MCU Cortex_R5_0!");

    // Connect the MCU R5F
    dsMCU1_0.target.connect();

    // Reset the R5F to be in clean state.
    dsMCU1_0.target.reset();

    dsMCU1_0.target.halt();
    //dsMCU1_0.expression.evaluate("J7ES_LPDDR4_4266MTs_Config()");
}

function flashOspi()
{
    var configFileObj = new File("Configuration.txt");

    print("Starting Flashing !");
    if (configFileObj.exists())
    {
        var scanner = new Scanner(configFileObj);

        var ospiOffset;
        var ospiFile;

        while (scanner.hasNextLine())
        {
            var data = scanner.nextLine();
            var parts = data.split(" ");
            ospiOffset = parseInt(parts[0], 16)
            ospiFile = parts[1];

            var file = new File(ospiFile);
            fileSize = file.length();

            dsMCU1_0.memory.writeWord(0x0, 0x80000000, ospiOffset);
            dsMCU1_0.memory.writeWord(0x0, 0x80000004, fileSize);

            dsMCU1_0.memory.loadRaw(0, 0x90000000, ospiFile, 32, false);

            print("Flashing "+ospiFile+" of size " + fileSize + " at offset " + ospiOffset);

            // Connect the MCU R5F
            dsMCU1_0.target.connect();
			dsMCU1_0.memory.readWord(0x0, 0x40F80018);

            print("Running the OSPI load program from R5!");
            // Load the board configuration init file.
            dsMCU1_0.memory.loadProgram("bin/uart_j721e_evm_flash_programmer_release.xer5f");
            // Halt the R5F and re-run.
            dsMCU1_0.target.halt();
            dsMCU1_0.target.reset();
            dsMCU1_0.target.restart();
            // Run Synchronously for the executable to finish
            dsMCU1_0.target.run();

            // Reset the R5F to be in clean state.
            dsMCU1_0.target.reset();
        }
        scanner.close();
    }
    else
    {
        print("File Does not exist!");
    }
}

function disconnectTargets()
{
    updateScriptVars();
    // Reset the R5F to be in clean state.
    dsMCU1_0.target.reset();
}

function doEverything()
{
    printVars();
    connectTargets();
    disconnectTargets();
    flashOspi();
    print("Burning is complete, happy to go !!!");
}

var ds;
var debugServer;
var script;

// Check to see if running from within CCSv4 Scripting Console
var withinCCS = (ds !== undefined);

// Create scripting environment and get debug server if running standalone
if (!withinCCS)
{
    // Import the DSS packages into our namespace to save on typing
    importPackage(Packages.com.ti.debug.engine.scripting);
    importPackage(Packages.com.ti.ccstudio.scripting.environment);
    importPackage(Packages.java.lang);

    importPackage(Packages.java.io);
    importPackage(Packages.java.lang);

    // Create our scripting environment object - which is the main entry point into any script and
    // the factory for creating other Scriptable ervers and Sessions
    script = ScriptingEnvironment.instance();

    // Get the Debug Server and start a Debug Session
    debugServer = script.getServer("DebugServer.1");
}
else // otherwise leverage existing scripting environment and debug server
{
    debugServer = ds;
    script = env;
}

doEverything();
