#
#  Copyright (c) 2021 Texas Instruments Incorporated - http://www.ti.com
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#
#  *  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
#  *  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
#  *  Neither the name of Texas Instruments Incorporated nor the names of
#     its contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
#  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
#  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
#  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
#  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#
#  ======== products.mak ========
#

.PHONY: .show

ifneq ($(OS),Windows_NT)
DEPOT = /home/frank/ti
else
DEPOT = R:
endif

#### Installation directories ####
ifneq ($(OS),Windows_NT)
export SDDF_DRV_ROOT    ?= $(DEPOT)/UserData/am64x_mc_demo/motor-drive-demo/interfaces/sddf/driver
else
export SDDF_DRV_ROOT    ?= C:/UserData/am64x_mc_demo/motor-drive-demo/interfaces/sddf/driver
endif

#### Dependencies ####
XDC_INSTALL_DIR         ?= $(DEPOT)/xdctools_3_61_03_29_core
PDK_INSTALL_DIR         ?= $(DEPOT)/pdk_am64x_07_02_01_09

#### Tool chains ####
ti_targets_elf_R5F      ?= $(DEPOT)/ti-cgt-arm_20.2.0.LTS

# Use this goal to print your product variables.
.show:
	@echo "DEPOT                = $(DEPOT)"
	@echo "XDC_INSTALL_DIR      = $(XDC_INSTALL_DIR)"
	@echo "ti_targets_elf_R5F   = $(ti_targets_elf_R5F)"
