;
; sddf_test.h
;
; Copyright (c) 2021, Texas Instruments Incorporated
; All rights reserved.
;
;  Redistribution and use in source and binary forms, with or without
;  modification, are permitted provided that the following conditions
;  are met:
;
;  *  Redistributions of source code must retain the above copyright
;     notice, this list of conditions and the following disclaimer.
;
;  *  Redistributions in binary form must reproduce the above copyright
;     notice, this list of conditions and the following disclaimer in the
;     documentation and/or other materials provided with the distribution.
;
;  *  Neither the name of Texas Instruments Incorporated nor the names of
;     its contributors may be used to endorse or promote products derived
;     from this software without specific prior written permission.
;
;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
;  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
;  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
;  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;

        .if !$defined("__sddf_dbg_h")
__sddf_dbg_h    .set    1

;
; For simulation Trigger, IEP0 Counter clears when CMP0 count is reached & CMP0 is set to EPWM period.
; For normal Trigger, external EPWM sync event causes clear of IEP0 CMP0.
; In either cases, subsequent CMP1 event causes Task Manager context switch to PRU code.
; Clear of external sync event handled in this PRU code.
;
;_DBG_TRIG_SIM               .set 1

; Capture SINC3 OC output samples to circular buffer in SHMEM
;_DBG_OC_OUT_SAMP_CB_SHMEM   .set 1

; PRU cycle count benchmarking
;_DBG_OC_BM_PRU_CYCLE        .set 1 ; OC benchmarking (OC task exclusive, must disable NC task in tm_init)
;_DBG_NC_BM_PRU_CYCLE        .set 1 ; NC benchmarking (NC task exclusive)

; SOC GPIO for timing measurements
;_DBG_SOC_GPIO               .set 1

; PRU GPO for framework timing measurements on Breakout Board, can't be enabled at same time as SD
;_DBG_PRU_GPO               .set 1

; PRU GPO proxy for timing measurements, PRU GPO driven on PRU1
_DBG_PRU_GPO_PROXY          .set 1

; Whether to exclude polling for shadow update flag from OC benchmarking (_DBG_OC_BM_PRU_CYCLE and _DBG_PRU_GPO_PROXY)
_DBG_NO_OC_POLL_SHDW_UPD    .set 1

    .if $defined("_DBG_OC_OUT_SAMP_CB_SHMEM") | $defined("_DBG_OC_BM_PRU_CYCLE") | $defined("_DBG_NC_BM_PRU_CYCLE")
_DBG_CB_SHMEM               .set 1
    .endif

    .if $isdefed("_DBG_CB_SHMEM")
        ; Debug, Shared Memory capture buffer
        .asg            R27, DBG_BUF_ADDR
        .asg            R29.w0, DBG_BUF_IDX
DBG_BUF_SZ              .set 4*128
    .endif

    .if $isdefed("_DBG_SOC_GPIO")
        .asg            R27, GPIO0_REG_ADDR ; GPIO0 register address
        .asg            R28, GPIO0_REG_VAL  ; GPIO0 register value
        .asg            R29.w0, GPIO_TGL    ; GPIO0 toggle
    .endif

    .if $isdefed("_DBG_OC_BM_PRU_CYCLE") | $isdefed("_DBG_NC_BM_PRU_CYCLE")
        ; Debug, Shared Memory capture buffer
        .asg            R25, BM_PRU_CYCLE_START
        .asg            R26, BM_PRU_CYCLE_END
    .endif

    .if $isdefed("_DBG_PRU_GPO_PROXY")
        .asg            R29, R30_PROXY      ; R30 proxy register
    .endif

    .endif  ; __sddf_dbg_h
