
/* make sure below retain is there in your linker command file, it keeps the vector table in the final binary */
--retain="*(.vectors)"
/* This is the stack that is used by code running within main()
 * In case of NORTOS,
 * - This means all the code outside of ISR uses this stack
 * In case of FreeRTOS
 * - This means all the code until vTaskStartScheduler() is called in main()
 *   uses this stack.
 * - After vTaskStartScheduler() each task created in FreeRTOS has its own stack   
 */
--stack_size=16384
/* This is the heap size for malloc() API in NORTOS and FreeRTOS
 * This is also the heap used by pvPortMalloc in FreeRTOS
 */
--heap_size=32768


SECTIONS
{
    /* This has the M4F entry point and vector table, this MUST be at 0x0 */
    .vectors:{} palign(8) > M4F_VECS
    .text:   {} palign(8) > M4F_RAM     /* This is where code resides */
    .bss:    {} palign(8) > M4F_RAM     /* This is where uninitialized globals go */
    .data:   {} palign(8) > M4F_RAM     /* This is where initialized globals and static go */
    .rodata: {} palign(8) > M4F_RAM     /* This is where const's go */
    .sysmem: {} palign(8) > M4F_RAM     /* This is where the malloc heap goes */
    .stack:  {} palign(8) > M4F_RAM     /* This is where the main() stack goes */

    /* General purpose user shared memory */
    .bss.user_shared_mem (NOLOAD) : {} > USER_SHM_MEM
    /* this is used when Debug log's to shared memory are enabled, else this is not used */
    .bss.log_shared_mem  (NOLOAD) : {} > LOG_SHM_MEM
    /* this is used only when IPC RPMessage is enabled, else this is not used */
    .bss.ipc_vring_mem   (NOLOAD) : {} > IPC_VRING_MEM
}

MEMORY
{
    M4F_VECS : ORIGIN = 0x00000000 , LENGTH = 0x00000200
    M4F_RAM  : ORIGIN = 0x00000200 , LENGTH = 0x0003FE00

    /* shared memories that are used by all cores */
    /* On M4F,
     * - By default MSMC RAM is not accessible to M4F, a RAT entry is needed to make it
     *   accessible on M4F
     * - So make sure there is a RAT entry which has a 1:1 mapping from 0x70000000 to 0x70200000
     */
    USER_SHM_MEM : ORIGIN = 0x701D0000, LENGTH = 0x00004000
    LOG_SHM_MEM  : ORIGIN = 0x701D4000, LENGTH = 0x00004000
    IPC_VRING_MEM: ORIGIN = 0x701D8000, LENGTH = 0x00008000
}
