;
; icssg_defs.h
;
; Copyright (c) 2021, Texas Instruments Incorporated
; All rights reserved.
;
;  Redistribution and use in source and binary forms, with or without
;  modification, are permitted provided that the following conditions
;  are met:
;
;  *  Redistributions of source code must retain the above copyright
;     notice, this list of conditions and the following disclaimer.
;
;  *  Redistributions in binary form must reproduce the above copyright
;     notice, this list of conditions and the following disclaimer in the
;     documentation and/or other materials provided with the distribution.
;
;  *  Neither the name of Texas Instruments Incorporated nor the names of
;     its contributors may be used to endorse or promote products derived
;     from this software without specific prior written permission.
;
;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
;  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
;  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
;  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;

        .if !$defined("__icssg_defs_h")
__icssg_defs_h    .set    1

;
; Substitution symbols
;
        .asg    C0, CT_PRU_ICSSG_INTC           ; Constant Table, PRU_ICSSG INTC
        .asg    C1, CT_PRU_ICSSG_IEP1           ; Constant Table, PRU_ICSSG IEP1
        .asg    C3, CT_PRU_ICSSG_ECAP           ; Constant Table, PRU_ICSSG ECAP0
        .asg    C4, CT_PRU_ICSSG_CFG            ; Constant Table, PRU_ICSSG CFG
        .asg    C10, CT_PRU_ICSSG_TM            ; Constant Table, PRU_ICSSG TM
        .asg    C11, CT_PRU_ICSSG_CTRL          ; Constant Table, PRU Control
        .asg    C24, CT_PRU_ICSSG_LOC_DMEM      ; Constant Table, local PRU DMEM
        .asg    C26, CT_PRU_ICSSG_IEP0          ; Constant Table, PRU_ICSSG IEP0

;
; Symbolic constants for ICSSG/PRU HW
;

; DMEM
PRUx_DSELF_BASE                 .set (0x00000000)   ;  Own Data RAM (8kB)

; SPAD Bank IDs for Xfer instructions
;
BANK0                           .set 10
BANK1                           .set 11
BANK2                           .set 12
BANK3                           .set 13

; PRU_ICSSG_INTC events
;
SYS_EVT_IEP_TIM_CAP_CMP_PEND    .set 7              ; IEP0 tim_cap_cmp_pend

; PRU_ICSSG_INTC
;
ICSSG_INTC_HIPIR1               .set 0x0904             ; Host Int 1 Prioritized Interrupt Register
ICSSG_INTC_HIPIR                .set ICSSG_INTC_HIPIR1  ; using Host Interrupt 1
ICSSG_INTC_SICR                 .set 0x0024             ; Sys Interrupt Indexed Deassert
NONE_HINT_BIT                   .set 31                 ; ICSSG_PRI_HINT_REG:NONE_HINT_0 bit number

; PRU_ICSSG_PRU_CTRL
;
ICSSG_CNTLSELF_BASE             .set 0
PRUx_CNTL_CONST_IDX0_OFFSET     .set 0x0020         ;  Constant Table Block Index Reg 0
PRUx_CNTLSELF_CONST_IDX0_REG    .set (ICSSG_CNTLSELF_BASE + PRUx_CNTL_CONST_IDX0_OFFSET)
; ICSSG_PRU_CTBIR0:C24_BLK_INDEX, PRU Constant Entry C24 Block Index
C24_BLK_INDEX_FW_REGS_VAL       .set 0
C24_BLK_INDEX_OUT_SAMP_BUF_VAL  .set 8

; PRU_ICSSG_CFG
;
PRUx_CFG_BASE                   .set (0x00026000)
ICSSG_CFG_GPCFG0                .set 0x0008 ;  GP IO Configuration Register 0
ICSSG_CFG_GPCFG1                .set 0x000C ;  GP IO Configuration Register 1
ICSSG_CFG_SPPC                  .set 0x0034 ;  Scratch PAD priority and config
ICSSG_CFG_PRU0_SD0_CLK          .set 0x48
ICSSG_CFG_PRU1_SD0_CLK          .set 0x94

;
; ICSSG_GPCFGn_REG:PR1_PRUn_GP_MUX_SEL, Controls the icss_wrap mux sel
;   n: {0,1}, PRU ID
PR1_PRUn_GP_MUX_SEL_SHIFT       .set 26
PR1_PRUn_GP_MUX_SEL_MASK        .set 0xF
PR1_PRUn_GP_MUX_SEL_VAL         .set 0011b

; ICSSG_SPP_REG:XFR_SHIFT_EN, Shift enable using R0[4:0] to define the number of 32-bit offset for XIN and XOUT operations
XFR_SHIFT_EN_BN                 .set 1

; ICSSG_PRUn_SD_CLK_SEL_REGi
;   n: {0,1}, PRU ID
;   i: {0...8}, SD Channel Number
; ICSSG_PRUn_SD_CLK_SEL_REGi:PRUn_SD_CLK_SELi, Selects the clock source
PRUn_SD_CLK_SELi_SHIFT          .set 0
PRUn_SD_CLK_SELi_MASK           .set 11b
PRUn_SD_CLK_SELi_VAL            .set 00b
; ICSSG_PRUn_SD_CLK_SEL_REGi:PRUn_SD_CLK_INVi, Optional clock inversion post clock selection mux
PRUn_SD_CLK_INVi_SHIFT          .set 2
PRUn_SD_CLK_INVi_MASK           .set 1b
; ICSSG_PRUn_SD_CLK_SEL_REGi:PRUn_SD_ACC_SELi, Selects to ACC source
PRUn_SD_ACC_SELi_SHIFT          .set 4
PRUn_SD_ACC_SELi_MASK           .set 11b
PRUn_SD_ACC_SELi_VAL            .set 00b
; ICSSG_PRUn_SD_CLK_SEL_REGi:PRUn_FD_ZERO_MIN_LIMIT_i
PRUn_FD_ZERO_MIN_LIMIT_i_SHIFT  .set 11
PRUn_FD_ZERO_MIN_LIMIT_i_MASK   .set 0x1F
; ICSSG_PRUn_SD_CLK_SEL_REGi:PRUn_FD_ZERO_MAX_LIMIT_i
PRUn_FD_ZERO_MAX_LIMIT_i_SHIFT  .set 17
PRUn_FD_ZERO_MAX_LIMIT_i_MASK   .set 0x1F

; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi
;   n: {0,1}, PRU ID
;   i: {0...8}, SD Channel Number
; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi:PRUn_SD_SAMPLE_SIZEi, Over Sample Rate
PRUn_SD_SAMPLE_SIZEi_SHIFT      .set 0
PRUn_SD_SAMPLE_SIZEi_MASK       .set 0xFF
; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi:PRUn_FD_WINDOW_SIZE_i
PRUn_FD_WINDOW_SIZE_i_SHIFT     .set 8
PRUn_FD_WINDOW_SIZE_i_MASK      .set 111b
; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi:PRUn_FD_ONE_MIN_LIMIT_i
PRUn_FD_ONE_MIN_LIMIT_i_SHIFT   .set 11
PRUn_FD_ONE_MIN_LIMIT_i_MASK    .set 0x1F
; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi:PRUn_FD_ONE_MAX_LIMIT_i
PRUn_FD_ONE_MAX_LIMIT_i_SHIFT   .set 17
PRUn_FD_ONE_MAX_LIMIT_i_MASK    .set 0x1F
; ICSSG_PRUn_SD_SAMPLE_SIZE_REGi:PRUn_FD_EN_i
PRUn_FD_EN_i_BN                 .set 23

; PRU_ICSSG_IEP
;
ICSSG_IEP_GLOBAL_CFG_REG        .set 0x0000 ; Global Configuration Register
ICSSG_IEP_COUNT_REG0            .set 0x0010 ; 64-bit Count Value Low Register
ICSSG_IEP_COUNT_REG1            .set 0x0014 ; 64-bit Count Value High Register
ICSSG_IEP_CMP_CFG_REG           .set 0x0070 ; Compare Configuration Register
ICSSG_IEP_CMP_STATUS_REG        .set 0x0074 ; Compare Status Register
ICSSG_IEP_CMP0_REG0             .set 0x0078 ; Compare 0 Low Register
ICSSG_IEP_CMP0_REG1             .set 0x007C ; Compare 0 High Register
ICSSG_IEP_CMP1_REG0             .set 0x0080 ; Compare 1 Low Register
ICSSG_IEP_CMP1_REG1             .set 0x0084 ; Compare 1 High Register
; ICSSG_IEP_GLOBAL_CFG_REG:CNT_ENABLE_BN
CNT_ENABLE_BN                   .set 0
; ICSSG_IEP_GLOBAL_CFG_REG:DEFAULT_INC
DEFAULT_INC_BN                  .set 4
; ICSSG_IEP_CMP_STATUS_REG:CMP_STATUS
CMP_STATUS_CMP1_BN              .set 1

; PRU_ICSSG_ECAP
;
ICSSG_eCAP_TSCNT                .set 0x0000 ; 32b time stamp counter
ICSSG_eCAP_CNTPHS               .set 0x0004 ; counter phase offset value
ICSSG_eCAP_CAP1                 .set 0x0008 ; 32b capture 1 reg
ICSSG_eCAP_CAP2                 .set 0x000C ; 32b capture 2 reg
ICSSG_eCAP_ECCTL1               .set 0x0028 ; capture control reg 1
; ICSSG_ECCTL2_ECCTL1
; ICSSG_ECCTL2_ECCTL1:APWMPOL
APWMPOL_SHIFT                   .set 26
APWMPOL_MASK                    .set 1b
APWMPOL_VAL                     .set 0b
; ICSSG_ECCTL2_ECCTL1:CAP_APWM   
CAP_APWM_SHIFT                  .set 25
CAP_APWM_MASK                   .set 1b
CAP_APWM_VAL                    .set 1b
; ICSSG_ECCTL2_ECCTL1:SYNCO_SEL  
SYNCO_SEL_SHIFT                 .set 22
SYNCO_SEL_MASK                  .set 11b
SYNCO_SEL_VAL                   .set 10b
; ICSSG_ECCTL2_ECCTL1:SYNCI_EN   
SYNCI_EN_SHIFT                  .set 21
SYNCI_EN_MASK                   .set 1b
SYNCI_EN_VAL                    .set 0b
; ICSSG_ECCTL2_ECCTL1:TSCNTSTP
TSCNTSTP_BN                     .set 20

; PRU_ICSSG Tasks Manager
;
TM_CFG_PRU0_BASE                .set 0x0002A000
TM_CFG_RTU0_BASE                .set 0x0002A100
TM_CFG_PRU1_BASE                .set 0x0002A200
TM_CFG_RTU1_BASE                .set 0x0002A300
TM_CFG_TX_PRU0_BASE             .set 0x0002A400
TM_CFG_TX_PRU1_BASE             .set 0x0002A500
TASKS_MGR_TS1_PC_S0             .set 0x08
TASKS_MGR_TS1_PC_S1             .set 0x0C
TASKS_MGR_TS1_GEN_CFG1          .set 0x38

TM_YIELD_XID                    .set 252

    .endif  ; __icssg_defs_h
