
;
; Copyright (C) 2021 Texas Instruments Incorporated
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in the
;   documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of Texas Instruments Incorporated nor the names of
;   its contributors may be used to endorse or promote products derived
;   from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPgResS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
; A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
; OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
; SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
; LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;

; EnDat command definitions
; EnDat 2.1 commands
ENDAT_CMD_SEND_POSITION_VALUES	.set	(0x1C >> 1)
ENDAT_CMD_SEL_MEM_AREA	.set			(0x38 >> 1)
ENDAT_CMD_RECEIVE_PARAMETERS	.set	(0x70 >> 1)
ENDAT_CMD_SEND_PARAMETERS	.set		(0x8C >> 1)
ENDAT_CMD_RECEIVE_RESET	.set			(0xA8 >> 1)
ENDAT_CMD_SEND_TEST_VALUES	.set		(0x54 >> 1)
ENDAT_CMD_RECEIVE_TEST_COMMAND	.set	(0xC4 >> 1)
; EnDat 2.2 commands
ENDAT_CMD_SEND_POSVAL_WITH_DATA	.set			(0xE0 >> 1)
ENDAT_CMD_SEND_POSVAL_RECEIVE_MEMSEL	.set	(0x24 >> 1)
ENDAT_CMD_SEND_POSVAL_RECEIVE_PARAM	.set		(0x6C >> 1)
ENDAT_CMD_SEND_POSVAL_SEND_PARAM	.set		(0x90 >> 1)
ENDAT_CMD_SEND_POSVAL_RECEIVE_TESTCMD	.set	(0xD8 >> 1)
ENDAT_CMD_SEND_POSVAL_RECEIVE_ERR_RST	.set	(0xB4 >> 1)
ENDAT_CMD_RECEIVE_COMMUNICATION_CMD	.set		(0x48 >> 1)


MRS_CODE_PARAM_ENCODER_MANUFACTURER_PAGE0	.set 	0xA1 ; 12 words
MRS_CODE_PARAM_ENCODER_MANUFACTURER_PAGE1	.set 	0xA3 ; 16 words
MRS_CODE_PARAM_ENCODER_MANUFACTURER_PAGE2	.set 	0xA5 ; 16 words
MRS_CODE_PARAM_OPERATING_PARAMS	.set				0xA7 ; 16 words
MRS_CODE_PARAM_OEM_PAGE0	.set					0xA9 ; 64 words
MRS_CODE_PARAM_OEM_PAGE1	.set					0xAB ; 128 words
MRS_CODE_PARAM_OEM_PAGE2	.set					0xAD ; 128 words

MRS_CODE_OPERATING_STATUS	.set					0xB9 ; 4 words
MRS_CODE_PARAM_ENCODER_MFG_ENDAT2_2	.set			0xBD ; 64 words
MRS_CODE_OEM_MEM_AREA_2_2	.set					0xBF ; 4 blocks with 256 words each

MRS_CODE_ADDITIONAL_INFO1_WITHOUT_DATA	.set		0x40
MRS_CODE_ADDITIONAL_INFO1_DIAGNOSTIC	.set		0x41
MRS_CODE_ADDITIONAL_INFO1_POSVAL2_WORD1_LSB	.set	0x42
MRS_CODE_ADDITIONAL_INFO1_POSVAL2_WORD2	.set		0x43
MRS_CODE_ADDITIONAL_INFO1_POSVAL2_WORD3_MSB	.set	0x44
MRS_CODE_ADDITIONAL_INFO1_ACK_MEM_LSB	.set		0x45
MRS_CODE_ADDITIONAL_INFO1_ACK_MEM_MSB	.set		0x46
MRS_CODE_ADDITIONAL_INFO1_ACK_MRS_CODE	.set		0x47
MRS_CODE_ADDITIONAL_INFO1_ACK_TEST_CMD	.set		0x48
MRS_CODE_ADDITIONAL_INFO1_TESTVAL_WORD1_LSB	.set	0x49
MRS_CODE_ADDITIONAL_INFO1_TESTVAL_WORD2	.set		0x4A
MRS_CODE_ADDITIONAL_INFO1_TESTVAL_WORD3_MSB	.set	0x4B
MRS_CODE_ADDITIONAL_INFO1_TEMPERATURE1	.set		0x4C
MRS_CODE_ADDITIONAL_INFO1_TEMPERATURE2	.set		0x4D
MRS_CODE_ADDITIONAL_INFO1_ADTL_SENSORS	.set		0x4E
MRS_CODE_ADDITIONAL_INFO1_STOP_DATA	.set			0x4F

MRS_CODE_ADDITIONAL_INFO2_WITHOUT_DATA	.set		0x50
MRS_CODE_ADDITIONAL_INFO2_COMMUNICATION	.set		0x51
MRS_CODE_ADDITIONAL_INFO2_ACCELERATION	.set		0x52
MRS_CODE_ADDITIONAL_INFO2_COMM_N_ACCLN	.set		0x53
MRS_CODE_ADDITIONAL_INFO2_LIMIT_POS_SIGNAL	.set	0x54
MRS_CODE_ADDITIONAL_INFO2_LPS_N_ACCLN	.set		0x55
MRS_CODE_ADDITIONAL_INFO2_ASYNCPOSVAL2_WORD1_LSB	.set	0x56
MRS_CODE_ADDITIONAL_INFO2_ASYNCPOSVAL2_WORD2	.set		0x57
MRS_CODE_ADDITIONAL_INFO2_ASYNCPOSVAL2_WORD3_MSB	.set	0x58
MRS_CODE_ADDITIONAL_INFO2_OPSTATUS_ERRSOURCE	.set		0x59
MRS_CODE_ADDITIONAL_INFO2_STOP_DATA	.set			0x5F



ENDAT_TX_30BITS	.set	30+1 ; Adjust 1-bit as we transmit early
ENDAT_TX_6BITS	.set	6+1 ; Adjust 1-bit as we transmit early
ENDAT_RX_29BITS	.set	29
ENDAT_CMDTYP_2_1	.set	1
ENDAT_CMDTYP_2_2	.set	0
; ROQ_1035	.set
	.if	$isdefed("ROQ_1035")
ENDAT21_RX_POS_BITS	.set	42 ;  For EnDat 2.1: 1+1+35+5 - 35-bit position value
ENDAT22_RX_POS_BITS	.set	43 ;  For EnDat 2.2: 1+2+35+5 - 35-bit position value
	.else
ENDAT21_RX_POS_BITS	.set	44 ;  For EnDat 2.1: 1+1+37+5 - 37-bit position value
ENDAT22_RX_POS_BITS	.set	45 ;  For EnDat 2.2: 1+2+37+5 - 37-bit position value
	.endif
ENDAT_RX_46BITS	.set	46 ;  For EnDat 2.1: encoder to send test values

WORD_0	.set	0
WORD_1	.set	1
WORD_2	.set	2
WORD_3	.set	3
WORD_4	.set	4
WORD_5	.set	5
WORD_6	.set	6
WORD_7	.set	7
WORD_8	.set	8
WORD_9	.set	9
WORD_10	.set	10
WORD_11	.set	11
WORD_12	.set	12
WORD_13	.set	13
WORD_14	.set	14
WORD_15	.set	15
WORD_16	.set	16
WORD_17	.set	17
WORD_18	.set	18
WORD_19	.set	19

ENDAT_TEST_PORT_D_V	.set	0
ENDAT_TEST_PORT_D_B	.set	1
ENDAT_TEST_PORT_D_C	.set	2
ENDAT_TEST_PORT_D_D	.set	13
ENDAT_TEST_PORT_D_E	.set	14


; Time units below in nano sec

ENDAT_RECOVERY_Tst	.set	2000 ;  2-10us with wire delay compensation - 200m x 10 ns/m => Max 2us
ENDAT_RECOVERY_Tm	.set	10000 ;  10-30us for EnDat2.1 Endat2.2 : 1.25us -3.75us for clock >= 1MHz
ENDAT_RECOVERY_Tr	.set	500 ;  Data shall be low during this period

ENDAT_CONFIG_CH0	.set	0x1
ENDAT_CONFIG_CH1	.set	(0x1 << 1)
ENDAT_CONFIG_CH2	.set	(0x1 << 2)

ENDAT_CMDTYP_NO_SUPPLEMENT	.set	0x1
ENDAT_CMDTYP_POSITION	.set		(0x1 << 1)
ENDAT_CMDTYP_ENDAT22	.set		(0x1 << 2)
ENDAT_CMDTYP_HAS_ADDINFO1	.set	(0x1 << 3)
ENDAT_CMDTYP_HAS_ADDINFO2	.set	(0x1 << 4)
