;
; Copyright (c) 2021, Texas Instruments Incorporated
; All rights reserved.
;
;  Redistribution and use in source and binary forms, with or without
;  modification, are permitted provided that the following conditions
;  are met:
;
;  *  Redistributions of source code must retain the above copyright
;     notice, this list of conditions and the following disclaimer.
;
;  *  Redistributions in binary form must reproduce the above copyright
;     notice, this list of conditions and the following disclaimer in the
;     documentation and/or other materials provided with the distribution.
;
;  *  Neither the name of Texas Instruments Incorporated nor the names of
;     its contributors may be used to endorse or promote products derived
;     from this software without specific prior written permission.
;
;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
;  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
;  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
;  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;

        .include "icssg_defs.h"

        .def    ENTRY  ; global entry point

;
; Substitution symbols
;
        .asg    R1, TREG0                       ; temporary register 0
        .asg    R2, TREG1                       ; temporary register 1
        .asg    R3, TREG2                       ; temporary register 2
        .asg    R4, TREG3                       ; temporary register 3
        
        .asg    R25.w0, RET_ADDR_REG            ; function return register
        
        .asg    R29, R30_PROXY                  ; R30 proxy register
        
        .sect   ".text"
        .retain ".text"
        .retainrefs ".text"
ENTRY:
        ; Clear registers R0-R30
        ZERO    &R0, 124

        ; Setup pinmux
        JAL     RET_ADDR_REG, setup_pinmux

        ; Drive GPU_GPO0
        SET     R30.b0, R30.b0, 0 ; GPU_GPO0=1
        CLR     R30.b0, R30.b0, 0 ; GPU_GPO0=0
        
        ; Drive GPU_GPO1
        SET     R30.b0, R30.b0, 1 ; GPU_GPO1=1
        CLR     R30.b0, R30.b0, 1 ; GPU_GPO1=0

        ; Drive GPU_GPO2
        SET     R30.b0, R30.b0, 2 ; GPU_GPO2=1
        CLR     R30.b0, R30.b0, 2 ; GPU_GPO2=0

        ; Enable XIN/XOUT shifting.
        LBCO    &TREG0.b0, CT_PRU_ICSSG_CFG, ICSSG_CFG_SPPC, 1
        SET     TREG0, TREG0, XFR_SHIFT_EN_BN   ; ICSSG_SPP_REG:XFR_SHIFT_EN=1
        SBCO    &TREG0.b0, CT_PRU_ICSSG_CFG, ICSSG_CFG_SPPC, 1

        ; Set SPAD BANK shift
        LDI     R0.b0, 0
        
pru_gpo_loop:
        XIN     BANK1, &R30_PROXY, 4
        MOV     R30, R30_PROXY
        QBA     pru_gpo_loop

        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY
        ;XIN     BANK1, &R30_PROXY, 4
        ;MOV     R30, R30_PROXY

;        LOOP    loop_end, 256
;        XIN     BANK1, &R30_PROXY, 4
;        MOV     R30, R30_PROXY
;loop_end:
        QBA     pru_gpo_loop

; Setup pinmux
;      
setup_pinmux:
        ; partition 1
        LDI32   TREG0, 0x000f5008  ; LOCK1 KICK0 register
        LDI32   TREG1, 0x000f500c  ; LOCK1 KICK1 register
        LDI32   TREG2, 0x68EF3490  ; Kick 0
        LDI32   TREG3, 0xD172BC5A  ; kick 1
        SBBO    &TREG2, TREG0, 0, 4
        SBBO    &TREG3, TREG1, 0, 4

        ; pin-mux configuration - PRG0_PRU1_GPO0 output
        ; 3-axis breakout board: J9A.35
        LDI32   TREG0, 0x000F41B0
        LDI32   TREG1, 0x00010000
        SBBO    &TREG1, TREG0, 0, 4

        ; pin-mux configuration - PRG0_PRU1_GPO1 output
        ; 3-axis breakout board: J9A.39
        LDI32   TREG0, 0x000F41B4
        LDI32   TREG1, 0x00010000
        SBBO    &TREG1, TREG0, 0, 4

        ; pin-mux configuration - PRG0_PRU1_GPO2 output
        ; 3-axis breakout board: J9A.33,pr0_pru0_endat0_out_en -> U55 -> RS485DIRP1 -> U43 -> J11.14
        LDI32   TREG0, 0x000F41B8
        LDI32   TREG1, 0x00010000
        SBBO    &TREG1, TREG0, 0, 4


        JMP     RET_ADDR_REG
