;
; Copyright (c) 2021, Texas Instruments Incorporated
; All rights reserved.
;
;  Redistribution and use in source and binary forms, with or without
;  modification, are permitted provided that the following conditions
;  are met:
;
;  *  Redistributions of source code must retain the above copyright
;     notice, this list of conditions and the following disclaimer.
;
;  *  Redistributions in binary form must reproduce the above copyright
;     notice, this list of conditions and the following disclaimer in the
;     documentation and/or other materials provided with the distribution.
;
;  *  Neither the name of Texas Instruments Incorporated nor the names of
;     its contributors may be used to endorse or promote products derived
;     from this software without specific prior written permission.
;
;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
;  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
;  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
;  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;

        .include "sddf.h"
        .include "sddf_dbg.h"

        .def dbg_setup_pinmux

    .if $isdefed("_DBG_CB_SHMEM")
        ; Debug, Shared Memory capture buffer
DBG_BUF .usect          ".dbgBuf", DBG_BUF_SZ, 4
        .retain         ".dbgBuf"
        .retainrefs     ".dbgBuf"
    .endif


; Debug, setup pinmux
;      
dbg_setup_pinmux:
        ; partition 1
        LDI32    TREG0, 0x000f5008  ; LOCK1 KICK0 register
        LDI32    TREG1, 0x000f500c  ; LOCK1 KICK1 register
        LDI32    TREG2, 0x68EF3490  ; Kick 0
        LDI32    TREG3, 0xD172BC5A  ; kick 1
        SBBO     &TREG2, TREG0, 0, 4
        SBBO     &TREG3, TREG1, 0, 4

        ; pin-mux configuration - PRU0_GPO0 output
        LDI32    TREG0, 0x000f4160
        LDI32    TREG1, 0x00010000
        SBBO     &TREG1, TREG0, 0, 4

        ; pin-mux configuration - PRU0_GPO1 output
        LDI32    TREG0, 0x000f4164
        LDI32    TREG1, 0x00010000
        SBBO     &TREG1, TREG0, 0, 4
    
        JMP     RET_ADDR_REG
