/**
 *   @file  mastertask.c
 *
 *  
 *  \par   CSL_SRIO_Open
 *  NOTE:
 *      (C) Copyright 2009 Texas Instruments, Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  beef
 *  \par
*/

#include "bioInclude.h"

/**********************************************************************
 ************************** LOCAL Definitions *************************
 **********************************************************************/


#pragma DATA_ALIGN   (fftBuffer, 128)
#pragma DATA_SECTION (fftBuffer, ".fftInput");

short fftBuffer[MAX_FFT_SIZE*2*NUM_FFT_BUFFER]  ;
bufferControl_t controlVector[NUM_FFT_BUFFER];

void initializeBufferControl(short * in1, bufferControl_t controlVector[], int numberBuffers)
{
	int  i   ;
	short *p    ;
	p = in1 ;
	for (i=0; i< numberBuffers; i++)
	{
		controlVector[i].status = (int) FREE_BUFFER    ;
		controlVector[i].pointer = p  ;
		p = p + MAX_FFT_SIZE*2   ;
	}
}

short   lastOne   =  0  ;
short * getNextfreeBuffer (bufferControl_t control[] )
{
	int  i   ;


	for (i=0; i<NUM_FFT_BUFFER; i++)
	{
		if (control[i].status == FREE_BUFFER)
		{
			control[i].status = USE_BUFFER    ;
			lastOne = i   ;
			return (control[i].pointer ) ;
		}
//		lastOne = lastOne + 1   ;
		if (lastOne == NUM_FFT_BUFFER)lastOne = 0  ;
		return (control[lastOne].pointer ) ;
	}

	System_printf("error in finding free buffer \n")  ;
	return (NULL);
}

short * prepareData(short *buffer , int *N )
{
	int   powerOfSize, size, numberOfSin   ;
	int   interval   ;
	interval = rand()  % (MAX_FFT_POWER-MIN_FFT_POWER + 1 );
	powerOfSize = interval + MIN_FFT_POWER    ;
	size = 1 << powerOfSize ;
	*N = size   ;
	numberOfSin = 1 + rand() % MAX_SIM     ;
//	System_printf(" generating input size %d #sin %d buffer %x \n",size, numberOfSin, buffer );
	ranDelay (5)  ;  //  Ran Katzur   Special Delay
	generateShortInput (size, numberOfSin, buffer)   ;
	return (buffer) ;
}


#if  1


 Int32 test_multicoreMaster (Srio_DrvHandle hSrioDrv)
{   //    1
      short *p_data   ;
      UInt8 *p_data1  ;
      int num   ;
      int  N = 38   ;
       srand( time( NULL ) );  //  using the time seed from srand explanation
       num = rand();

	  if ( masterTaskInitialization(hSrioDrv)  < 0 )
		  return  (-1) ;
      iterationCounter = ITERATIONS   ;
      initializeBufferControl(fftBuffer,  controlVector,NUM_FFT_BUFFER ) ; // lin1   OK

      p_data = getNextfreeBuffer (controlVector ) ;  //   line 2
 //     System_printf("p_data1 = %x \n", p_data) ;

      p_data = (short *) prepareData(p_data , &N)  ;
 //     System_printf("p_data and N are  %x  %d \n", p_data, N)  ;
      if (p_data == NULL)
      {
    	  exit(1)  ;
      }
      while (iterationCounter--)   //   always run
      {


    	   requestProcessingData( p_data, N)  ;
    	     p_data = getNextfreeBuffer (controlVector ) ;  //   line 2
 //   	      System_printf("p_data1 = %x \n", p_data) ;

    	      p_data = (short *) prepareData(p_data , &N)  ;
 //   	      System_printf("p_data and N are  %x  %d \n", p_data, N)  ;
    	      if (p_data == NULL)
    	      {
    	    	  exit(1)  ;
    	      }

     }

////    End of RUN

      //    while
          CACHE_invL1d ((void *) &runFlag, 128, CACHE_WAIT);
          runFlag = 0 ;
           CACHE_wbL1d ((void *) &runFlag, 128, CACHE_WAIT);
           System_printf("  core 0 DONE!!,runFlag = %d \n  ", runFlag) ;
////      Send END Message
           for (coreLoop=firstSendStart; coreLoop<NUM_CORES; coreLoop++)
               {
                    sendToCore   =  CORE_SYS_INIT + coreLoop ;
                    txData_int[0] = END_PROCESSING ;
                    to.type11.id       = coreDeviceID[sendToCore];
                  if (Srio_sockSend (srioSocket, hDrvBuffer, SEND_SIZE, &to) < 0)
                  {
                     System_printf ("Error: SRIO Socket send failed\n");
                     return -1;
                  }
                  System_printf(" master sent END_PROCESSING message\n") ;
                  ranDelay(30)  ;   //   Ran Katzur Special Delay
//                  System_printf("send request to core %d \n", coreNumberFromId(coreDeviceID,to.type11.id));
                   ranDelay(3)  ;
              }//



    /* Close the sockets */
    Srio_sockClose (srioSocket);

    /* We are done with the test. */
//    System_printf ("Debug(Core %d): Multicore Test Passed\n", coreNum);
    return 0;
}


#endif
