/**
 *   @file  mastertask.c
 *
 *  
 *  \par
 *  NOTE:
 *      (C) Copyright 2009 Texas Instruments, Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  beef
 *  \par     01
*/

#include "bioInclude.h"

/**********************************************************************
 ************************** LOCAL Definitions *************************
 **********************************************************************/






 Int32 test_multicoreUser (Srio_DrvHandle hSrioDrv)
{   //    1

	   short *ppp  = NULL ;
     short * processingBuffer  ;
     short processingSize    ;

     const short *restrict  pw  ;
     short *restrict ptr_x;
     short *restrict ptr_y;
     short *pointerToData   ;
     short nextFFTSize  ;
     short  firstTime  = READY ;



/*     The algorithm here is different
 *     The thread sends one message and goes to sleep
 */
       if ( slaveTaskInitialization( hSrioDrv, &pointerToData) < 0 )
    	   return (-1)  ;

       processingBuffer = NULL   ;
       while (messageValue != END_PROCESSING )
       {



          num_bytes = Srio_sockRecv (srioSocket, (Srio_DrvBuffer*)&ptr_rxDataPayload, &from);
          if (num_bytes > 0)
          {  //  3    num_bytes


            if (from.type11.id != coreDeviceID[recvFromCore])
            {
                System_printf ("Error: Invalid source id 0x%x Expected 0x%x\n", from.type11.id, coreDeviceID[recvFromCore]);
                return -1;
            }
            ppp = (short *)&ptr_rxDataPayload[0] ;
            messageValue = *ppp  ;
//    	     System_printf("core %d recieve message %x\n", coreNum, messageValue);
            Srio_freeRxDrvBuffer(srioSocket, (Srio_DrvBuffer)ptr_rxDataPayload);
            //   if messageValue is a request,  send a knowledgement
            //   if messageValue is TOKEN  -  start processing
            //   else - print I do not understand
            xx = coreNum * 17   ;
            if (messageValue == xx)
            {
                nextFFTSize = *(ppp+1)   ;

                txData_int[0] =  READY;
  //              txData_int[1] = (int) processingBuffer ;
 //               System_printf(" 11 processingBufrfer  %x \n", txData_int[0])  ;
                   /* Send the data out from the producer core to the consumer core. */
                 if (Srio_sockSend (srioSocket, hDrvBuffer, SEND_SIZE, &to) < 0)
                 {
                       System_printf ("Error: SRIO Socket send failed\n");
                       return -1;
                 }
             }
            else if (messageValue == TOKEN)
            {
              memcpy(xxx[coreNum], ppp, 4 * nextFFTSize) ;
              xxx[coreNum][0] = xxx[coreNum][1]   ;
              xxx[coreNum][1] = 0   ;
              processingSize = nextFFTSize   ;
  //                System_printf (" 12  processingBuffer %x \n", processingBuffer);


                   ptr_x = (short *restrict)processingBuffer ;
                    ptr_y = (short *restrict) z_short[coreNum];


                 if (processingSize == 32)   pw =  (const short *restrict)twiddle_32 ;
                 if (processingSize == 64)    pw =  (const short *restrict)twiddle_64 ;
                 if (processingSize == 128)    pw =  (const short *restrict)twiddle_128 ;
                 if (processingSize == 256)    pw =  (const short *restrict)twiddle_256 ;
                 if (processingSize == 512)    pw =  (const short *restrict)twiddle_512 ;
                 if (processingSize == 1024)    pw =  (const short *restrict)twiddle_1024 ;

 //                printStartEnd(xxx[coreNum], 2*processingSize);
                 DSP_fft16x16(pw, processingSize,xxx[coreNum] , ptr_y );

                 seperateRealImg (processingSize, ptr_y, x_short[coreNum] , y_short[coreNum]);
                 System_printf("fft size %d output %x real %x imag %x \n",
                		 processingSize	 ,ptr_y, x_short[coreNum] , y_short[coreNum] )  ;
///
///      If TOKEN is received, the core is going to do processing for a long but random time
//                  srand ( coreNum *12345 + time(NULL) );
//                  randomValue = PROCESSING_BASE + ( rand() % PROCESSING_INTERVAL )  ;
 //                 System_printf("core %d random Delay %d \n",coreNum, randomValue  );
                 ranDelay  (processingSize);
            }


        } // 3   num_bytes

        else if (messageValue == END_PROCESSING) break  ;
        else
        {//3
            /* Error: In receiving data */ 
            System_printf ("Error: Unable to receive data %d\n", num_bytes);
            System_printf ("Evalue read  %x\n", messageValue);
            return -1;
        }//   3
    }  //  2   coreNum

    System_printf(" code  %d  DONE   runFlag = %d \n", coreNum, runFlag);
    /* Close the sockets */
    Srio_sockClose (srioSocket);
 
    /* We are done with the test. */
//    System_printf ("Debug(Core %d): Multicore Test Passed\n", coreNum);
    return (0);
}


