//********************************************************************** 
//********************************** *********************************** 
//***********            MISTRAL SOLUTIONS PVT LTD           *********** 
//***********              #60, ADARSH REGENT                *********** 
//***********               100 ft RING ROAD                 *********** 
//***********              DOMLUR, BANGALORE-71              *********** 
//********************************************************************** 
//***********                -CONFIDENTIAL-                  *********** 
//********************************************************************** 
//********************************************************************** 
//Version =  0.6
//********************************************************************** 
//FILE NAME: top_cpld
//********************************************************************** 
//PACKAGE NAME: 
//********************************************************************** 
//DATE:      26 MAY 2021  
//********************************************************************** 
//AUTHOR:    Binupandian  
//********************************************************************** 
//ABSTRACT:  This module implements the bootmode and reset logic
//              for dummy implementation 
//********************************************************************** 
//MODULE INSTANTIATIONS: 
// Slno   Instance Name                  Module Name  
//
//**********************************************************************
// Revisions:
// Date             Version    Author           Description
// 01 FEB 2021       0.1       Binupandian      Created
// 12 May 2021       0.2       Binupandian      Boot Mode updated   
// 17 May 2021       0.3       Revathi G        i_jtag_resetz default
//                                              state is changed from
//				         	pull down to pull up.
// 26 May 2021       0.4       Revathi G        i_gpio_rgmii3_rstn
//                                              default state is changed
//                                              from pull down to pull up.
//                                              The open drain logic is
//                                              disabled for the output
//                                              pin o_rgmii3_rstn. 
// 01 June 2021      0.5       Revathi G        Boot Mode updated.
//                                              The open drain logic is
//                                              disabled for the output
//                                              pins o_pcie0_m2_rtsz &
//                                              o_pcie1_m2_rtsz.
//                                              The output logic for the
//                                              pin o_usbc_port_sel [0]
//                                              is changed.
// 15 June 2021      0.6       Revathi G        The OSPI bootmode is
//                                              removed and replaced 
//                                              with xSPI_1S bootmode.
//**********************************************************************
`timescale 1ns / 1ps

module top_cpld(
(* KEEP = "TRUE" *)    input [3:0] i_cpld_control_in,				
    output [5:3] o_mcu_bootmode,
    output [7:0] o_sys_bootmode,
    output [1:0] o_usbc_port_sel,
    output o_mcu_porz,					
    output o_mcu_resetz,
    //output o_reset_reqz,
    output o_pcie0_m2_rtsz,
    output o_pcie1_m2_rtsz,
    output o_rgmii3_rstn,
    output o_soc_porz,
    input i_sys_pwr_pg,
    input i_ta_mcu_porz,
    input i_jtag_resetz,
    input i_pb_mcu_resetz,
    input i_ta_resetz,
    input i_gpio_rgmii3_rstn,
    input i_soc_pcie0_m2_rstz,
    input i_soc_pcie1_m2_rstz,
    input i_soc_porz_out,
    input i_resetstatz
    );
localparam BOOT_SD        = 7'h9;	  // boot value = {mcu_bootmode[5:3], sys_bootmode[6:4],sys_bootmode[0]}
localparam BOOT_NB        = 7'h73;	  // sys bootmode[3:1] is using dummy logic
localparam BOOT_USB0      = 7'h21;	  // To be updated once final implementation is confirmed
localparam BOOT_USB1      = 7'h29;
localparam BOOT_xSPI_1S   = 7'h61;	  
localparam BOOT_UART      = 7'h70;	  
localparam BOOT_PCIE      = 7'h53;
localparam BOOT_xSPI_SFDP = 7'h69;


reg [6:0] bootmode;

wire [2:0] bt_sel;
wire usbc_sel;


assign bt_sel = i_cpld_control_in[2:0];

// assign usbc_sel = i_cpld_control_in[3];

	  
assign o_mcu_resetz = i_pb_mcu_resetz & i_ta_resetz;
assign o_mcu_porz 	= (i_sys_pwr_pg && i_ta_mcu_porz && i_jtag_resetz && i_pb_mcu_resetz)? 1'bZ:1'b0;
assign o_pcie0_m2_rtsz = i_soc_pcie0_m2_rstz & i_soc_porz_out;
assign o_pcie1_m2_rtsz = i_soc_pcie1_m2_rstz & i_soc_porz_out;
assign o_rgmii3_rstn = i_gpio_rgmii3_rstn & i_soc_porz_out;
//assign o_reset_reqz = ~(i_ta_resetz & i_jtag_resetz)?1'b0:1'bZ; // Dummy logic
assign o_soc_porz = 1'b1;// Dummy logic - TBC

assign o_mcu_bootmode[5] = bootmode[6]; 
assign o_mcu_bootmode[4] = bootmode[5]; 
assign o_mcu_bootmode[3] = bootmode[4]; 
assign o_sys_bootmode[7] = 1'b0; 
assign o_sys_bootmode[6] = bootmode[3]; 
assign o_sys_bootmode[5] = bootmode[2]; 
assign o_sys_bootmode[4] = bootmode[1]; 
assign o_sys_bootmode[3] = 1'b0; 
assign o_sys_bootmode[2] = 1'b0; 
assign o_sys_bootmode[1] = 1'b0; 
assign o_sys_bootmode[0] = bootmode[0];
 
assign o_usbc_port_sel[0] = i_cpld_control_in[3];
assign o_usbc_port_sel[1] = 1'b0;

always@(bt_sel)
begin
	case(bt_sel)
        'b000 : bootmode <= BOOT_SD;
        'b001 : bootmode <= BOOT_NB;
        'b010 : bootmode <= BOOT_USB0;
        'b011 : bootmode <= BOOT_USB1;
        'b100 : bootmode <= BOOT_xSPI_1S;
        'b101 : bootmode <= BOOT_UART;
        'b110 : bootmode <= BOOT_PCIE;
        'b111 : bootmode <= BOOT_xSPI_SFDP;
        
        endcase
end

endmodule
