//****************************************************************************** 
//********************************** ******************************************* 
//***********            MISTRAL SOLUTIONS PVT LTD           ******************* 
//***********              #60, ADARSH REGENT                ******************* 
//***********               100 ft RING ROAD                 ******************* 
//***********              DOMLUR, BANGALORE-71              ******************* 
//****************************************************************************** 
//***********                -CONFIDENTIAL-                  ******************* 
//****************************************************************************** 
//****************************************************************************** 
//Version =  0.2                                                        ********
//****************************************************************************** 
//FILE NAME: top_cpld                                                   ********
//****************************************************************************** 
//PACKAGE NAME:                                                         ********
//****************************************************************************** 
//DATE:      29 NOV 2021                                                ********
//****************************************************************************** 
//AUTHOR:    Binupandian                                                ********
//****************************************************************************** 
//ABSTRACT:  This module implements the bootmode and reset logic        ********
//           implementation of J7AEP SK(PROC125)                        ********
//******************************************************************************
//MODULE INSTANTIATIONS:                                                ********
// Slno   Instance Name                  Module Name                    ********
//                                                                      ********
//******************************************************************************
// Revisions:
// Date           Version   Author        Description
// 29 NOV 2021     0.1      Binupandian   Created. 
//                                        Changes from J7ES SK(PROC112):
//                                        1)i_soc_pcie0_m2_rstz is removed
//                                        2)o_pcie0_m2_rtsz is removed
//                                        3)i_soc_porz_out is removed
//                                        4)o_soc_porz_out is added.
//                                           * logic = soc_porz AND mcu_porz
//                                        5)o_mcu_porz_out is added
//                                           * logic = mcu_porz
//                                        6)o_soc_porz is changed to io_soc_porz
//                                            * implemented as Input 
//------------------------------------------------------------------------------
// 29-SEP-2022     0.2      Revathi G    Changes from previous implementation:
//                                        1)USB Bootmodes are removed 
//                                        2)Ethernet Bootmode is added 
//                                        3)Bootmode values updated for 
//                                          xSPI_1S and xSPI_SFDP.
//                                        4)o_mcu_porz &o_mcu_resetz
//                                          logic updated.
//                                        5)Signals Removed-o_mcu_porz_out,
//                                          o_soc_porz_out,io_soc_porz 
//                                          i_pb_mcu_resetz,i_ta_mcu_porz 
//                                        6)Signals Added-i_pb_porz,
//                                          i_ta_porz,o_rpi_gpio_buf_en.
//                                        7)Signals name and logic updated
//                                          for rgmii & pcie resets. 
//******************************************************************************
`timescale 1ns / 1ps

module top_cpld(
               
    output [5:3] o_mcu_bootmode,
    output [7:0] o_sys_bootmode,
    output o_mcu_rgmii_rst,
    output o_pcie1_m2_rtsz,
    output o_mcu_porz,
    output o_mcu_resetz,
    output o_rpi_gpio_buf_en,
    
    (* KEEP = "TRUE" *)  input [3:0] i_cpld_control_in,
    input i_soc_porz_out,
    input i_gpio_rgmii_rst,
    input i_gpio_pcie1_m2_rstz,
    input i_sys_pwr_pg,
    input i_pb_porz,
    input i_ta_porz,
    input i_jtag_resetz,
    input i_ta_resetz,
    input i_resetstatz
    );
 
// boot value = {mcu_bootmode[5:3], sys_bootmode[6:4],sys_bootmode[0]}
// sys bootmode[3:1] is using dummy logic 

//Bootmode Values
localparam BOOT_SD        = 7'h9;     
localparam BOOT_NB        = 7'h73;    
localparam BOOT_ETHERNET  = 7'h48; 
localparam BOOT_xSPI_1S   = 7'h6D;    
localparam BOOT_UART      = 7'h70;    
localparam BOOT_PCIE      = 7'h51;
localparam BOOT_xSPI_SFDP = 7'h6F;



reg  [6:0] bootmode;
wire [2:0] bt_sel;


assign bt_sel = i_cpld_control_in[2:0];


assign o_mcu_rgmii_rst = i_soc_porz_out & i_gpio_rgmii_rst;
assign o_pcie1_m2_rtsz = i_soc_porz_out & i_gpio_pcie1_m2_rstz;
assign o_mcu_porz = (i_sys_pwr_pg && i_pb_porz && i_ta_porz && i_jtag_resetz)?1'bz:1'b0;
assign o_mcu_resetz = i_pb_porz & i_ta_resetz;
assign o_rpi_gpio_buf_en = (i_cpld_control_in[3])?1'b0:1'b1;


// BOOTMODE SELECTION
assign o_mcu_bootmode[5] = bootmode[6]; 
assign o_mcu_bootmode[4] = bootmode[5]; 
assign o_mcu_bootmode[3] = bootmode[4]; 
assign o_sys_bootmode[7] = 1'b0; 
assign o_sys_bootmode[6] = bootmode[3]; 
assign o_sys_bootmode[5] = bootmode[2]; 
assign o_sys_bootmode[4] = bootmode[1]; 
assign o_sys_bootmode[3] = 1'b0; 
assign o_sys_bootmode[2] = 1'b0; 
assign o_sys_bootmode[1] = 1'b0; 
assign o_sys_bootmode[0] = bootmode[0];

 

always@(bt_sel)
begin
    case(bt_sel)
        'b000 : bootmode <= BOOT_SD;
        'b001 : bootmode <= BOOT_NB;
        'b010 : bootmode <= BOOT_ETHERNET;
        'b100 : bootmode <= BOOT_xSPI_1S;
        'b101 : bootmode <= BOOT_UART;
        'b110 : bootmode <= BOOT_PCIE;
        'b111 : bootmode <= BOOT_xSPI_SFDP;
        
       default: bootmode <= BOOT_NB;
        endcase
end

endmodule
