//=============================================================================
// Cheb Window 
//=============================================================================
#ifndef _FPU_FFT_CHEB_H_
#define _FPU_FFT_CHEB_H_

#define CHEB32 {\
0.00061649, 0.00268154, 0.00794911, 0.01901726, 0.03932829, \
0.07283747, 0.12338685, 0.19383474, 0.28508895, 0.39526429, \
0.51920759, 0.64859082, 0.77266446, 0.87961136, 0.95828507, \
1.00000000, } 

#define CHEB64 {\
0.00038075, 0.00087837, 0.00184330, 0.00344780, 0.00595625, \
0.00969134, 0.01503309, 0.02241386, 0.03230856, 0.04521994, \
0.06165887, 0.08212009, 0.10705419, 0.13683699, 0.17173791, \
0.21188912, 0.25725749, 0.30762133, 0.36255404, 0.42141624, \
0.48335776, 0.54733042, 0.61211172, 0.67633903, 0.73855320, \
0.79724977, 0.85093549, 0.89818729, 0.93771084, 0.96839524, \
0.98936127, 1.00000000, } 

#define CHEB128 {\
0.00042329, 0.00049354, 0.00077446, 0.00115489, 0.00165794, \
0.00230999, 0.00314084, 0.00418382, 0.00547589, 0.00705760, \
0.00897313, 0.01127012, 0.01399957, 0.01721556, 0.02097496, \
0.02533701, 0.03036292, 0.03611527, 0.04265740, 0.05005274, \
0.05836403, 0.06765253, 0.07797710, 0.08939332, 0.10195252, \
0.11570083, 0.13067816, 0.14691725, 0.16444273, 0.18327017, \
0.20340525, 0.22484290, 0.24756669, 0.27154811, 0.29674614, \
0.32310685, 0.35056318, 0.37903483, 0.40842835, 0.43863740, \
0.46954309, 0.50101462, 0.53290999, 0.56507692, 0.59735391, \
0.62957146, 0.66155341, 0.69311846, 0.72408173, 0.75425645, \
0.78345571, 0.81149426, 0.83819035, 0.86336754, 0.88685654, \
0.90849696, 0.92813898, 0.94564499, 0.96089108, 0.97376835, \
0.98418416, 0.99206311, 0.99734791, 1.00000000, } 

#define CHEB256 {\
0.00063276, 0.00036914, 0.00047554, 0.00060131, 0.00074880, \
0.00092055, 0.00111931, 0.00134799, 0.00160972, 0.00190786, \
0.00224593, 0.00262771, 0.00305718, 0.00353854, 0.00407621, \
0.00467485, 0.00533932, 0.00607473, 0.00688639, 0.00777986, \
0.00876088, 0.00983542, 0.01100967, 0.01229001, 0.01368302, \
0.01519544, 0.01683421, 0.01860643, 0.02051936, 0.02258036, \
0.02479697, 0.02717678, 0.02972752, 0.03245696, 0.03537293, \
0.03848330, 0.04179595, 0.04531874, 0.04905950, 0.05302600, \
0.05722591, 0.06166682, 0.06635615, 0.07130117, 0.07650894, \
0.08198630, 0.08773986, 0.09377592, 0.10010046, 0.10671913, \
0.11363721, 0.12085957, 0.12839064, 0.13623439, 0.14439429, \
0.15287330, 0.16167381, 0.17079766, 0.18024605, 0.19001957, \
0.20011816, 0.21054107, 0.22128685, 0.23235334, 0.24373763, \
0.25543607, 0.26744421, 0.27975684, 0.29236796, 0.30527075, \
0.31845758, 0.33192000, 0.34564876, 0.35963378, 0.37386416, \
0.38832821, 0.40301340, 0.41790645, 0.43299326, 0.44825901, \
0.46368809, 0.47926420, 0.49497032, 0.51078874, 0.52670114, \
0.54268854, 0.55873142, 0.57480967, 0.59090269, 0.60698942, \
0.62304834, 0.63905758, 0.65499490, 0.67083780, 0.68656352, \
0.70214910, 0.71757146, 0.73280743, 0.74783380, 0.76262739, \
0.77716510, 0.79142397, 0.80538121, 0.81901430, 0.83230102, \
0.84521951, 0.85774832, 0.86986648, 0.88155355, 0.89278966, \
0.90355558, 0.91383276, 0.92360338, 0.93285041, 0.94155764, \
0.94970972, 0.95729224, 0.96429171, 0.97069565, 0.97649259, \
0.98167212, 0.98622492, 0.99014275, 0.99341853, 0.99604632, \
0.99802136, 0.99934005, 1.00000000, } 

#define CHEB512 {\
0.00109510, 0.00031917, 0.00036540, 0.00041590, 0.00047092, \
0.00053073, 0.00059563, 0.00066592, 0.00074190, 0.00082389, \
0.00091223, 0.00100726, 0.00110934, 0.00121884, 0.00133614, \
0.00146163, 0.00159573, 0.00173884, 0.00189142, 0.00205389, \
0.00222672, 0.00241039, 0.00260538, 0.00281220, 0.00303135, \
0.00326336, 0.00350878, 0.00376816, 0.00404207, 0.00433109, \
0.00463583, 0.00495689, 0.00529490, 0.00565050, 0.00602434, \
0.00641708, 0.00682942, 0.00726204, 0.00771565, 0.00819097, \
0.00868873, 0.00920969, 0.00975460, 0.01032424, 0.01091940, \
0.01154086, 0.01218944, 0.01286597, 0.01357127, 0.01430619, \
0.01507159, 0.01586832, 0.01669728, 0.01755934, 0.01845540, \
0.01938636, 0.02035314, 0.02135666, 0.02239785, 0.02347764, \
0.02459698, 0.02575682, 0.02695811, 0.02820181, 0.02948889, \
0.03082032, 0.03219707, 0.03362011, 0.03509043, 0.03660900, \
0.03817680, 0.03979481, 0.04146401, 0.04318538, 0.04495989, \
0.04678852, 0.04867223, 0.05061200, 0.05260877, 0.05466351, \
0.05677717, 0.05895067, 0.06118496, 0.06348095, 0.06583955, \
0.06826167, 0.07074820, 0.07330001, 0.07591796, 0.07860290, \
0.08135566, 0.08417706, 0.08706789, 0.09002894, 0.09306096, \
0.09616470, 0.09934086, 0.10259016, 0.10591326, 0.10931082, \
0.11278345, 0.11633176, 0.11995632, 0.12365767, 0.12743634, \
0.13129279, 0.13522750, 0.13924089, 0.14333335, 0.14750523, \
0.15175687, 0.15608855, 0.16050052, 0.16499302, 0.16956621, \
0.17422024, 0.17895521, 0.18377119, 0.18866820, 0.19364623, \
0.19870520, 0.20384503, 0.20906556, 0.21436661, 0.21974794, \
0.22520927, 0.23075028, 0.23637059, 0.24206979, 0.24784742, \
0.25370295, 0.25963584, 0.26564546, 0.27173116, 0.27789224, \
0.28412793, 0.29043742, 0.29681987, 0.30327435, 0.30979992, \
0.31639557, 0.32306023, 0.32979279, 0.33659209, 0.34345692, \
0.35038602, 0.35737807, 0.36443172, 0.37154553, 0.37871806, \
0.38594778, 0.39323313, 0.40057249, 0.40796421, 0.41540657, \
0.42289782, 0.43043614, 0.43801968, 0.44564655, 0.45331478, \
0.46102241, 0.46876737, 0.47654761, 0.48436098, 0.49220534, \
0.50007846, 0.50797810, 0.51590198, 0.52384777, 0.53181310, \
0.53979558, 0.54779276, 0.55580218, 0.56382134, 0.57184769, \
0.57987868, 0.58791170, 0.59594413, 0.60397331, 0.61199658, \
0.62001122, 0.62801452, 0.63600372, 0.64397606, 0.65192875, \
0.65985899, 0.66776396, 0.67564083, 0.68348676, 0.69129888, \
0.69907434, 0.70681026, 0.71450376, 0.72215196, 0.72975197, \
0.73730091, 0.74479589, 0.75223403, 0.75961245, 0.76692827, \
0.77417863, 0.78136068, 0.78847157, 0.79550846, 0.80246855, \
0.80934902, 0.81614710, 0.82286003, 0.82948505, 0.83601947, \
0.84246058, 0.84880571, 0.85505224, 0.86119755, 0.86723908, \
0.87317427, 0.87900062, 0.88471567, 0.89031699, 0.89580218, \
0.90116890, 0.90641484, 0.91153774, 0.91653539, 0.92140563, \
0.92614633, 0.93075543, 0.93523092, 0.93957083, 0.94377327, \
0.94783637, 0.95175835, 0.95553748, 0.95917208, 0.96266054, \
0.96600131, 0.96919289, 0.97223387, 0.97512288, 0.97785864, \
0.98043991, 0.98286554, 0.98513443, 0.98724558, 0.98919801, \
0.99099086, 0.99262332, 0.99409464, 0.99540416, 0.99655130, \
0.99753552, 0.99835640, 0.99901354, 0.99950666, 0.99983553, \
1.00000000, } 

#define CHEB1024 {\
0.00203792, 0.00029677, 0.00031832, 0.00034086, 0.00036443, \
0.00038906, 0.00041479, 0.00044164, 0.00046966, 0.00049887, \
0.00052931, 0.00056102, 0.00059403, 0.00062838, 0.00066412, \
0.00070127, 0.00073988, 0.00077999, 0.00082163, 0.00086486, \
0.00090972, 0.00095624, 0.00100447, 0.00105446, 0.00110625, \
0.00115989, 0.00121542, 0.00127290, 0.00133237, 0.00139388, \
0.00145749, 0.00152323, 0.00159117, 0.00166136, 0.00173385, \
0.00180870, 0.00188595, 0.00196568, 0.00204792, 0.00213275, \
0.00222022, 0.00231039, 0.00240331, 0.00249906, 0.00259769, \
0.00269926, 0.00280384, 0.00291150, 0.00302229, 0.00313629, \
0.00325356, 0.00337417, 0.00349819, 0.00362569, 0.00375673, \
0.00389139, 0.00402975, 0.00417187, 0.00431783, 0.00446771, \
0.00462157, 0.00477950, 0.00494157, 0.00510787, 0.00527846, \
0.00545344, 0.00563288, 0.00581686, 0.00600547, 0.00619879, \
0.00639691, 0.00659990, 0.00680786, 0.00702087, 0.00723902, \
0.00746240, 0.00769110, 0.00792521, 0.00816481, 0.00841001, \
0.00866089, 0.00891755, 0.00918008, 0.00944857, 0.00972313, \
0.01000385, 0.01029082, 0.01058415, 0.01088394, 0.01119027, \
0.01150326, 0.01182301, 0.01214962, 0.01248318, 0.01282381, \
0.01317160, 0.01352667, 0.01388912, 0.01425905, 0.01463657, \
0.01502180, 0.01541482, 0.01581577, 0.01622474, 0.01664184, \
0.01706720, 0.01750091, 0.01794308, 0.01839384, 0.01885330, \
0.01932156, 0.01979875, 0.02028497, 0.02078034, 0.02128498, \
0.02179901, 0.02232253, 0.02285568, 0.02339855, 0.02395128, \
0.02451398, 0.02508676, 0.02566976, 0.02626308, 0.02686684, \
0.02748118, 0.02810620, 0.02874202, 0.02938877, 0.03004657, \
0.03071554, 0.03139580, 0.03208748, 0.03279068, 0.03350554, \
0.03423218, 0.03497072, 0.03572128, 0.03648398, 0.03725895, \
0.03804630, 0.03884617, 0.03965867, 0.04048392, 0.04132204, \
0.04217317, 0.04303741, 0.04391490, 0.04480575, 0.04571008, \
0.04662802, 0.04755968, 0.04850519, 0.04946466, 0.05043822, \
0.05142599, 0.05242808, 0.05344462, 0.05447571, 0.05552149, \
0.05658206, 0.05765755, 0.05874807, 0.05985374, 0.06097467, \
0.06211098, 0.06326277, 0.06443017, 0.06561329, 0.06681224, \
0.06802713, 0.06925807, 0.07050517, 0.07176854, 0.07304828, \
0.07434452, 0.07565734, 0.07698686, 0.07833318, 0.07969640, \
0.08107664, 0.08247398, 0.08388852, 0.08532038, 0.08676964, \
0.08823640, 0.08972076, 0.09122281, 0.09274265, 0.09428037, \
0.09583605, 0.09740979, 0.09900168, 0.10061179, 0.10224023, \
0.10388706, 0.10555237, 0.10723625, 0.10893877, 0.11066001, \
0.11240004, 0.11415895, 0.11593679, 0.11773365, 0.11954959, \
0.12138467, 0.12323898, 0.12511256, 0.12700548, 0.12891780, \
0.13084958, 0.13280088, 0.13477174, 0.13676223, 0.13877239, \
0.14080227, 0.14285192, 0.14492138, 0.14701069, 0.14911990, \
0.15124903, 0.15339814, 0.15556724, 0.15775638, 0.15996557, \
0.16219485, 0.16444425, 0.16671377, 0.16900345, 0.17131330, \
0.17364333, 0.17599356, 0.17836400, 0.18075465, 0.18316552, \
0.18559661, 0.18804792, 0.19051945, 0.19301119, 0.19552314, \
0.19805528, 0.20060760, 0.20318008, 0.20577271, 0.20838546, \
0.21101831, 0.21367124, 0.21634421, 0.21903718, 0.22175013, \
0.22448302, 0.22723581, 0.23000844, 0.23280088, 0.23561307, \
0.23844496, 0.24129650, 0.24416763, 0.24705828, 0.24996839, \
0.25289789, 0.25584672, 0.25881480, 0.26180204, 0.26480838, \
0.26783373, 0.27087801, 0.27394111, 0.27702296, 0.28012346, \
0.28324251, 0.28638000, 0.28953584, 0.29270991, 0.29590211, \
0.29911232, 0.30234043, 0.30558631, 0.30884984, 0.31213089, \
0.31542934, 0.31874505, 0.32207789, 0.32542771, 0.32879438, \
0.33217774, 0.33557766, 0.33899398, 0.34242654, 0.34587519, \
0.34933976, 0.35282009, 0.35631601, 0.35982736, 0.36335395, \
0.36689561, 0.37045217, 0.37402343, 0.37760922, 0.38120933, \
0.38482359, 0.38845179, 0.39209374, 0.39574923, 0.39941805, \
0.40310001, 0.40679489, 0.41050247, 0.41422255, 0.41795489, \
0.42169928, 0.42545549, 0.42922329, 0.43300245, 0.43679274, \
0.44059391, 0.44440574, 0.44822796, 0.45206035, 0.45590265, \
0.45975460, 0.46361596, 0.46748646, 0.47136586, 0.47525387, \
0.47915025, 0.48305472, 0.48696701, 0.49088684, 0.49481395, \
0.49874806, 0.50268887, 0.50663612, 0.51058951, 0.51454877, \
0.51851358, 0.52248367, 0.52645874, 0.53043850, 0.53442263, \
0.53841084, 0.54240283, 0.54639829, 0.55039692, 0.55439839, \
0.55840240, 0.56240864, 0.56641679, 0.57042652, 0.57443752, \
0.57844948, 0.58246205, 0.58647492, 0.59048776, 0.59450025, \
0.59851204, 0.60252281, 0.60653222, 0.61053994, 0.61454564, \
0.61854896, 0.62254958, 0.62654714, 0.63054132, 0.63453176, \
0.63851812, 0.64250005, 0.64647721, 0.65044925, 0.65441581, \
0.65837655, 0.66233112, 0.66627916, 0.67022032, 0.67415424, \
0.67808058, 0.68199897, 0.68590906, 0.68981050, 0.69370292, \
0.69758597, 0.70145929, 0.70532252, 0.70917530, 0.71301728, \
0.71684809, 0.72066737, 0.72447477, 0.72826993, 0.73205248, \
0.73582206, 0.73957832, 0.74332089, 0.74704942, 0.75076355, \
0.75446292, 0.75814716, 0.76181593, 0.76546886, 0.76910560, \
0.77272579, 0.77632907, 0.77991509, 0.78348349, 0.78703393, \
0.79056604, 0.79407948, 0.79757389, 0.80104893, 0.80450424, \
0.80793947, 0.81135429, 0.81474835, 0.81812129, 0.82147278, \
0.82480248, 0.82811004, 0.83139513, 0.83465741, 0.83789655, \
0.84111220, 0.84430405, 0.84747175, 0.85061498, 0.85373341, \
0.85682673, 0.85989459, 0.86293670, 0.86595272, 0.86894233, \
0.87190524, 0.87484111, 0.87774965, 0.88063054, 0.88348348, \
0.88630817, 0.88910431, 0.89187159, 0.89460973, 0.89731843, \
0.89999740, 0.90264636, 0.90526502, 0.90785309, 0.91041030, \
0.91293638, 0.91543105, 0.91789404, 0.92032508, 0.92272392, \
0.92509028, 0.92742392, 0.92972458, 0.93199200, 0.93422595, \
0.93642617, 0.93859242, 0.94072448, 0.94282209, 0.94488504, \
0.94691310, 0.94890604, 0.95086365, 0.95278570, 0.95467199, \
0.95652230, 0.95833644, 0.96011420, 0.96185538, 0.96355979, \
0.96522725, 0.96685756, 0.96845055, 0.97000603, 0.97152384, \
0.97300380, 0.97444575, 0.97584953, 0.97721498, 0.97854195, \
0.97983030, 0.98107986, 0.98229052, 0.98346212, 0.98459454, \
0.98568765, 0.98674133, 0.98775546, 0.98872993, 0.98966462, \
0.99055944, 0.99141427, 0.99222903, 0.99300362, 0.99373796, \
0.99443196, 0.99508554, 0.99569863, 0.99627116, 0.99680307, \
0.99729429, 0.99774478, 0.99815447, 0.99852332, 0.99885130, \
0.99913836, 0.99938447, 0.99958961, 0.99975375, 0.99987687, \
0.99995895, 1.00000000, } 

#define CHEB2048 {\
0.00393188, 0.00028617, 0.00029657, 0.00030721, 0.00031809, \
0.00032923, 0.00034062, 0.00035226, 0.00036417, 0.00037634, \
0.00038877, 0.00040149, 0.00041448, 0.00042775, 0.00044130, \
0.00045515, 0.00046929, 0.00048373, 0.00049847, 0.00051352, \
0.00052888, 0.00054455, 0.00056055, 0.00057688, 0.00059353, \
0.00061052, 0.00062785, 0.00064552, 0.00066354, 0.00068192, \
0.00070065, 0.00071975, 0.00073922, 0.00075906, 0.00077928, \
0.00079989, 0.00082089, 0.00084228, 0.00086407, 0.00088626, \
0.00090887, 0.00093189, 0.00095534, 0.00097921, 0.00100351, \
0.00102826, 0.00105344, 0.00107908, 0.00110517, 0.00113173, \
0.00115875, 0.00118624, 0.00121421, 0.00124267, 0.00127162, \
0.00130107, 0.00133102, 0.00136148, 0.00139245, 0.00142395, \
0.00145598, 0.00148854, 0.00152164, 0.00155529, 0.00158950, \
0.00162427, 0.00165960, 0.00169551, 0.00173200, 0.00176907, \
0.00180675, 0.00184502, 0.00188390, 0.00192340, 0.00196352, \
0.00200427, 0.00204566, 0.00208769, 0.00213038, 0.00217372, \
0.00221773, 0.00226241, 0.00230778, 0.00235383, 0.00240058, \
0.00244803, 0.00249620, 0.00254508, 0.00259470, 0.00264504, \
0.00269613, 0.00274797, 0.00280057, 0.00285394, 0.00290808, \
0.00296300, 0.00301872, 0.00307524, 0.00313256, 0.00319070, \
0.00324967, 0.00330947, 0.00337011, 0.00343160, 0.00349396, \
0.00355718, 0.00362127, 0.00368626, 0.00375213, 0.00381891, \
0.00388661, 0.00395522, 0.00402476, 0.00409525, 0.00416668, \
0.00423907, 0.00431243, 0.00438677, 0.00446209, 0.00453841, \
0.00461573, 0.00469407, 0.00477343, 0.00485383, 0.00493527, \
0.00501776, 0.00510132, 0.00518595, 0.00527167, 0.00535848, \
0.00544639, 0.00553541, 0.00562556, 0.00571685, 0.00580927, \
0.00590286, 0.00599760, 0.00609353, 0.00619064, 0.00628894, \
0.00638845, 0.00648918, 0.00659114, 0.00669434, 0.00679879, \
0.00690450, 0.00701148, 0.00711974, 0.00722930, 0.00734016, \
0.00745234, 0.00756585, 0.00768069, 0.00779689, 0.00791444, \
0.00803337, 0.00815368, 0.00827539, 0.00839850, 0.00852303, \
0.00864900, 0.00877640, 0.00890526, 0.00903558, 0.00916738, \
0.00930067, 0.00943546, 0.00957177, 0.00970959, 0.00984896, \
0.00998988, 0.01013235, 0.01027640, 0.01042204, 0.01056927, \
0.01071812, 0.01086859, 0.01102069, 0.01117445, 0.01132986, \
0.01148695, 0.01164572, 0.01180619, 0.01196837, 0.01213228, \
0.01229792, 0.01246532, 0.01263447, 0.01280541, 0.01297813, \
0.01315265, 0.01332899, 0.01350715, 0.01368716, 0.01386902, \
0.01405275, 0.01423837, 0.01442587, 0.01461529, 0.01480662, \
0.01499989, 0.01519511, 0.01539229, 0.01559145, 0.01579259, \
0.01599574, 0.01620090, 0.01640810, 0.01661734, 0.01682864, \
0.01704201, 0.01725746, 0.01747501, 0.01769468, 0.01791648, \
0.01814042, 0.01836651, 0.01859477, 0.01882522, 0.01905787, \
0.01929272, 0.01952981, 0.01976913, 0.02001071, 0.02025457, \
0.02050070, 0.02074913, 0.02099988, 0.02125295, 0.02150837, \
0.02176614, 0.02202628, 0.02228881, 0.02255374, 0.02282108, \
0.02309085, 0.02336307, 0.02363774, 0.02391489, 0.02419453, \
0.02447667, 0.02476132, 0.02504851, 0.02533825, 0.02563055, \
0.02592543, 0.02622290, 0.02652297, 0.02682567, 0.02713101, \
0.02743899, 0.02774965, 0.02806298, 0.02837902, 0.02869776, \
0.02901923, 0.02934345, 0.02967042, 0.03000016, 0.03033270, \
0.03066803, 0.03100618, 0.03134717, 0.03169100, 0.03203770, \
0.03238727, 0.03273974, 0.03309512, 0.03345342, 0.03381466, \
0.03417886, 0.03454602, 0.03491617, 0.03528933, 0.03566549, \
0.03604469, 0.03642693, 0.03681224, 0.03720062, 0.03759209, \
0.03798667, 0.03838437, 0.03878521, 0.03918920, 0.03959636, \
0.04000670, 0.04042024, 0.04083700, 0.04125698, 0.04168021, \
0.04210670, 0.04253646, 0.04296951, 0.04340587, 0.04384554, \
0.04428855, 0.04473491, 0.04518464, 0.04563775, 0.04609425, \
0.04655416, 0.04701750, 0.04748428, 0.04795452, 0.04842822, \
0.04890542, 0.04938611, 0.04987032, 0.05035806, 0.05084934, \
0.05134419, 0.05184261, 0.05234462, 0.05285024, 0.05335948, \
0.05387235, 0.05438887, 0.05490905, 0.05543292, 0.05596047, \
0.05649174, 0.05702672, 0.05756545, 0.05810793, 0.05865417, \
0.05920419, 0.05975801, 0.06031564, 0.06087709, 0.06144238, \
0.06201152, 0.06258453, 0.06316142, 0.06374221, 0.06432690, \
0.06491552, 0.06550807, 0.06610457, 0.06670504, 0.06730949, \
0.06791794, 0.06853038, 0.06914685, 0.06976735, 0.07039190, \
0.07102052, 0.07165320, 0.07228998, 0.07293085, 0.07357584, \
0.07422496, 0.07487822, 0.07553563, 0.07619722, 0.07686298, \
0.07753294, 0.07820710, 0.07888549, 0.07956810, 0.08025496, \
0.08094608, 0.08164147, 0.08234115, 0.08304512, 0.08375339, \
0.08446599, 0.08518292, 0.08590420, 0.08662983, 0.08735983, \
0.08809421, 0.08883299, 0.08957617, 0.09032376, 0.09107579, \
0.09183225, 0.09259317, 0.09335855, 0.09412841, 0.09490274, \
0.09568158, 0.09646492, 0.09725279, 0.09804518, 0.09884211, \
0.09964360, 0.10044964, 0.10126026, 0.10207547, 0.10289526, \
0.10371966, 0.10454868, 0.10538232, 0.10622059, 0.10706351, \
0.10791108, 0.10876331, 0.10962022, 0.11048181, 0.11134809, \
0.11221908, 0.11309478, 0.11397519, 0.11486034, 0.11575022, \
0.11664485, 0.11754424, 0.11844839, 0.11935731, 0.12027101, \
0.12118951, 0.12211280, 0.12304089, 0.12397380, 0.12491153, \
0.12585409, 0.12680149, 0.12775373, 0.12871082, 0.12967277, \
0.13063959, 0.13161128, 0.13258785, 0.13356930, 0.13455565, \
0.13554689, 0.13654305, 0.13754411, 0.13855010, 0.13956100, \
0.14057684, 0.14159762, 0.14262333, 0.14365399, 0.14468961, \
0.14573018, 0.14677571, 0.14782622, 0.14888169, 0.14994214, \
0.15100757, 0.15207799, 0.15315340, 0.15423381, 0.15531921, \
0.15640961, 0.15750503, 0.15860545, 0.15971088, 0.16082133, \
0.16193680, 0.16305729, 0.16418281, 0.16531335, 0.16644892, \
0.16758953, 0.16873518, 0.16988586, 0.17104158, 0.17220234, \
0.17336814, 0.17453899, 0.17571488, 0.17689582, 0.17808180, \
0.17927284, 0.18046892, 0.18167006, 0.18287624, 0.18408748, \
0.18530377, 0.18652510, 0.18775149, 0.18898293, 0.19021941, \
0.19146095, 0.19270753, 0.19395916, 0.19521583, 0.19647755, \
0.19774431, 0.19901611, 0.20029295, 0.20157483, 0.20286174, \
0.20415369, 0.20545066, 0.20675266, 0.20805968, 0.20937173, \
0.21068879, 0.21201087, 0.21333796, 0.21467005, 0.21600715, \
0.21734925, 0.21869634, 0.22004842, 0.22140549, 0.22276754, \
0.22413456, 0.22550656, 0.22688352, 0.22826543, 0.22965231, \
0.23104413, 0.23244089, 0.23384259, 0.23524921, 0.23666076, \
0.23807723, 0.23949860, 0.24092488, 0.24235604, 0.24379210, \
0.24523303, 0.24667884, 0.24812951, 0.24958503, 0.25104540, \
0.25251060, 0.25398064, 0.25545549, 0.25693515, 0.25841962, \
0.25990887, 0.26140291, 0.26290172, 0.26440529, 0.26591361, \
0.26742667, 0.26894446, 0.27046696, 0.27199418, 0.27352609, \
0.27506269, 0.27660395, 0.27814988, 0.27970046, 0.28125567, \
0.28281551, 0.28437996, 0.28594901, 0.28752264, 0.28910084, \
0.29068361, 0.29227091, 0.29386275, 0.29545911, 0.29705997, \
0.29866531, 0.30027513, 0.30188941, 0.30350813, 0.30513128, \
0.30675884, 0.30839080, 0.31002715, 0.31166785, 0.31331291, \
0.31496230, 0.31661600, 0.31827401, 0.31993629, 0.32160285, \
0.32327365, 0.32494868, 0.32662792, 0.32831136, 0.32999897, \
0.33169074, 0.33338665, 0.33508668, 0.33679081, 0.33849902, \
0.34021130, 0.34192762, 0.34364796, 0.34537231, 0.34710064, \
0.34883293, 0.35056917, 0.35230932, 0.35405338, 0.35580132, \
0.35755311, 0.35930875, 0.36106819, 0.36283143, 0.36459844, \
0.36636920, 0.36814369, 0.36992187, 0.37170374, 0.37348927, \
0.37527843, 0.37707120, 0.37886756, 0.38066748, 0.38247094, \
0.38427791, 0.38608837, 0.38790230, 0.38971967, 0.39154046, \
0.39336463, 0.39519217, 0.39702305, 0.39885725, 0.40069473, \
0.40253547, 0.40437945, 0.40622663, 0.40807700, 0.40993052, \
0.41178718, 0.41364693, 0.41550975, 0.41737562, 0.41924451, \
0.42111638, 0.42299122, 0.42486899, 0.42674966, 0.42863321, \
0.43051961, 0.43240882, 0.43430082, 0.43619558, 0.43809307, \
0.43999326, 0.44189612, 0.44380161, 0.44570972, 0.44762040, \
0.44953363, 0.45144937, 0.45336760, 0.45528829, 0.45721140, \
0.45913689, 0.46106475, 0.46299493, 0.46492741, 0.46686215, \
0.46879912, 0.47073829, 0.47267962, 0.47462309, 0.47656865, \
0.47851628, 0.48046594, 0.48241760, 0.48437123, 0.48632678, \
0.48828423, 0.49024354, 0.49220468, 0.49416762, 0.49613231, \
0.49809873, 0.50006683, 0.50203659, 0.50400796, 0.50598092, \
0.50795542, 0.50993144, 0.51190893, 0.51388786, 0.51586819, \
0.51784989, 0.51983291, 0.52181723, 0.52380281, 0.52578961, \
0.52777758, 0.52976670, 0.53175693, 0.53374823, 0.53574056, \
0.53773388, 0.53972816, 0.54172336, 0.54371944, 0.54571636, \
0.54771408, 0.54971257, 0.55171178, 0.55371168, 0.55571222, \
0.55771338, 0.55971510, 0.56171735, 0.56372010, 0.56572329, \
0.56772689, 0.56973087, 0.57173518, 0.57373977, 0.57574462, \
0.57774968, 0.57975491, 0.58176027, 0.58376571, 0.58577120, \
0.58777670, 0.58978217, 0.59178756, 0.59379284, 0.59579795, \
0.59780287, 0.59980755, 0.60181194, 0.60381601, 0.60581972, \
0.60782301, 0.60982586, 0.61182822, 0.61383004, 0.61583128, \
0.61783191, 0.61983187, 0.62183114, 0.62382965, 0.62582738, \
0.62782427, 0.62982029, 0.63181540, 0.63380954, 0.63580268, \
0.63779477, 0.63978577, 0.64177564, 0.64376433, 0.64575180, \
0.64773801, 0.64972291, 0.65170646, 0.65368862, 0.65566933, \
0.65764857, 0.65962628, 0.66160242, 0.66357694, 0.66554981, \
0.66752097, 0.66949039, 0.67145802, 0.67342382, 0.67538773, \
0.67734972, 0.67930975, 0.68126776, 0.68322371, 0.68517757, \
0.68712928, 0.68907880, 0.69102608, 0.69297108, 0.69491376, \
0.69685408, 0.69879198, 0.70072742, 0.70266035, 0.70459074, \
0.70651854, 0.70844370, 0.71036618, 0.71228593, 0.71420291, \
0.71611707, 0.71802837, 0.71993677, 0.72184221, 0.72374466, \
0.72564406, 0.72754038, 0.72943357, 0.73132358, 0.73321037, \
0.73509390, 0.73697411, 0.73885097, 0.74072443, 0.74259444, \
0.74446097, 0.74632396, 0.74818336, 0.75003915, 0.75189126, \
0.75373966, 0.75558430, 0.75742514, 0.75926212, 0.76109522, \
0.76292438, 0.76474955, 0.76657070, 0.76838777, 0.77020073, \
0.77200953, 0.77381413, 0.77561447, 0.77741052, 0.77920224, \
0.78098957, 0.78277247, 0.78455091, 0.78632482, 0.78809418, \
0.78985894, 0.79161905, 0.79337447, 0.79512516, 0.79687107, \
0.79861215, 0.80034837, 0.80207968, 0.80380604, 0.80552741, \
0.80724373, 0.80895497, 0.81066108, 0.81236203, 0.81405776, \
0.81574824, 0.81743342, 0.81911326, 0.82078772, 0.82245675, \
0.82412031, 0.82577837, 0.82743086, 0.82907777, 0.83071903, \
0.83235462, 0.83398448, 0.83560858, 0.83722687, 0.83883932, \
0.84044588, 0.84204650, 0.84364116, 0.84522980, 0.84681239, \
0.84838889, 0.84995925, 0.85152343, 0.85308140, 0.85463310, \
0.85617851, 0.85771759, 0.85925028, 0.86077655, 0.86229637, \
0.86380969, 0.86531647, 0.86681667, 0.86831025, 0.86979718, \
0.87127742, 0.87275092, 0.87421765, 0.87567756, 0.87713063, \
0.87857680, 0.88001606, 0.88144834, 0.88287362, 0.88429187, \
0.88570303, 0.88710708, 0.88850398, 0.88989368, 0.89127616, \
0.89265138, 0.89401929, 0.89537987, 0.89673307, 0.89807887, \
0.89941721, 0.90074808, 0.90207143, 0.90338723, 0.90469544, \
0.90599603, 0.90728895, 0.90857419, 0.90985170, 0.91112144, \
0.91238340, 0.91363752, 0.91488377, 0.91612213, 0.91735256, \
0.91857502, 0.91978949, 0.92099593, 0.92219430, 0.92338458, \
0.92456673, 0.92574072, 0.92690651, 0.92806409, 0.92921341, \
0.93035444, 0.93148715, 0.93261152, 0.93372751, 0.93483508, \
0.93593422, 0.93702489, 0.93810706, 0.93918070, 0.94024578, \
0.94130227, 0.94235015, 0.94338938, 0.94441993, 0.94544179, \
0.94645491, 0.94745927, 0.94845485, 0.94944162, 0.95041954, \
0.95138860, 0.95234876, 0.95330000, 0.95424230, 0.95517562, \
0.95609994, 0.95701524, 0.95792149, 0.95881866, 0.95970673, \
0.96058568, 0.96145549, 0.96231611, 0.96316755, 0.96400976, \
0.96484273, 0.96566643, 0.96648084, 0.96728594, 0.96808171, \
0.96886812, 0.96964515, 0.97041278, 0.97117099, 0.97191975, \
0.97265905, 0.97338887, 0.97410919, 0.97481998, 0.97552122, \
0.97621290, 0.97689500, 0.97756749, 0.97823037, 0.97888360, \
0.97952718, 0.98016108, 0.98078528, 0.98139978, 0.98200454, \
0.98259956, 0.98318482, 0.98376030, 0.98432599, 0.98488186, \
0.98542791, 0.98596412, 0.98649047, 0.98700695, 0.98751354, \
0.98801024, 0.98849701, 0.98897387, 0.98944078, 0.98989774, \
0.99034473, 0.99078174, 0.99120875, 0.99162577, 0.99203277, \
0.99242974, 0.99281667, 0.99319356, 0.99356038, 0.99391713, \
0.99426381, 0.99460039, 0.99492688, 0.99524325, 0.99554951, \
0.99584564, 0.99613164, 0.99640749, 0.99667320, 0.99692874, \
0.99717413, 0.99740933, 0.99763436, 0.99784921, 0.99805386, \
0.99824832, 0.99843257, 0.99860662, 0.99877046, 0.99892407, \
0.99906747, 0.99920064, 0.99932358, 0.99943629, 0.99953876, \
0.99963099, 0.99971298, 0.99978473, 0.99984623, 0.99989748, \
0.99993849, 0.99996924, 0.99998975, 1.00000000, } 

#define CHEB4096 {\
0.00772379, 0.00028101, 0.00028612, 0.00029129, 0.00029652, \
0.00030180, 0.00030715, 0.00031256, 0.00031803, 0.00032357, \
0.00032916, 0.00033482, 0.00034055, 0.00034633, 0.00035219, \
0.00035810, 0.00036409, 0.00037014, 0.00037625, 0.00038244, \
0.00038869, 0.00039501, 0.00040139, 0.00040785, 0.00041438, \
0.00042097, 0.00042764, 0.00043438, 0.00044119, 0.00044808, \
0.00045503, 0.00046206, 0.00046917, 0.00047635, 0.00048360, \
0.00049093, 0.00049833, 0.00050582, 0.00051338, 0.00052102, \
0.00052873, 0.00053653, 0.00054440, 0.00055236, 0.00056039, \
0.00056851, 0.00057671, 0.00058499, 0.00059336, 0.00060180, \
0.00061034, 0.00061895, 0.00062766, 0.00063645, 0.00064532, \
0.00065428, 0.00066334, 0.00067247, 0.00068170, 0.00069102, \
0.00070043, 0.00070993, 0.00071952, 0.00072920, 0.00073898, \
0.00074885, 0.00075881, 0.00076887, 0.00077902, 0.00078927, \
0.00079962, 0.00081006, 0.00082061, 0.00083125, 0.00084199, \
0.00085282, 0.00086376, 0.00087481, 0.00088595, 0.00089720, \
0.00090855, 0.00092000, 0.00093156, 0.00094322, 0.00095499, \
0.00096687, 0.00097885, 0.00099094, 0.00100314, 0.00101545, \
0.00102787, 0.00104040, 0.00105305, 0.00106580, 0.00107867, \
0.00109165, 0.00110475, 0.00111796, 0.00113129, 0.00114473, \
0.00115829, 0.00117198, 0.00118577, 0.00119969, 0.00121373, \
0.00122789, 0.00124218, 0.00125658, 0.00127111, 0.00128576, \
0.00130054, 0.00131544, 0.00133047, 0.00134563, 0.00136092, \
0.00137633, 0.00139188, 0.00140755, 0.00142336, 0.00143930, \
0.00145537, 0.00147157, 0.00148791, 0.00150438, 0.00152099, \
0.00153774, 0.00155463, 0.00157165, 0.00158881, 0.00160611, \
0.00162356, 0.00164114, 0.00165887, 0.00167674, 0.00169476, \
0.00171292, 0.00173123, 0.00174968, 0.00176828, 0.00178703, \
0.00180593, 0.00182499, 0.00184419, 0.00186354, 0.00188305, \
0.00190271, 0.00192252, 0.00194249, 0.00196262, 0.00198290, \
0.00200335, 0.00202395, 0.00204471, 0.00206563, 0.00208672, \
0.00210797, 0.00212938, 0.00215095, 0.00217269, 0.00219460, \
0.00221668, 0.00223892, 0.00226133, 0.00228392, 0.00230667, \
0.00232960, 0.00235270, 0.00237597, 0.00239942, 0.00242304, \
0.00244684, 0.00247082, 0.00249498, 0.00251931, 0.00254383, \
0.00256853, 0.00259341, 0.00261848, 0.00264373, 0.00266916, \
0.00269478, 0.00272059, 0.00274659, 0.00277278, 0.00279916, \
0.00282573, 0.00285249, 0.00287945, 0.00290660, 0.00293395, \
0.00296149, 0.00298923, 0.00301717, 0.00304531, 0.00307365, \
0.00310220, 0.00313094, 0.00315989, 0.00318905, 0.00321841, \
0.00324797, 0.00327775, 0.00330774, 0.00333793, 0.00336834, \
0.00339896, 0.00342979, 0.00346084, 0.00349210, 0.00352358, \
0.00355528, 0.00358720, 0.00361934, 0.00365169, 0.00368428, \
0.00371708, 0.00375011, 0.00378336, 0.00381685, 0.00385056, \
0.00388449, 0.00391866, 0.00395306, 0.00398770, 0.00402256, \
0.00405766, 0.00409300, 0.00412857, 0.00416439, 0.00420044, \
0.00423673, 0.00427326, 0.00431004, 0.00434706, 0.00438433, \
0.00442184, 0.00445960, 0.00449761, 0.00453586, 0.00457437, \
0.00461314, 0.00465215, 0.00469142, 0.00473095, 0.00477073, \
0.00481077, 0.00485107, 0.00489163, 0.00493246, 0.00497354, \
0.00501489, 0.00505651, 0.00509840, 0.00514055, 0.00518297, \
0.00522566, 0.00526862, 0.00531186, 0.00535537, 0.00539916, \
0.00544322, 0.00548757, 0.00553219, 0.00557709, 0.00562228, \
0.00566774, 0.00571350, 0.00575953, 0.00580586, 0.00585247, \
0.00589938, 0.00594657, 0.00599406, 0.00604184, 0.00608991, \
0.00613828, 0.00618695, 0.00623592, 0.00628519, 0.00633476, \
0.00638463, 0.00643481, 0.00648529, 0.00653608, 0.00658718, \
0.00663859, 0.00669030, 0.00674233, 0.00679468, 0.00684734, \
0.00690031, 0.00695360, 0.00700722, 0.00706115, 0.00711540, \
0.00716998, 0.00722488, 0.00728011, 0.00733567, 0.00739155, \
0.00744776, 0.00750431, 0.00756119, 0.00761840, 0.00767595, \
0.00773384, 0.00779206, 0.00785062, 0.00790953, 0.00796878, \
0.00802837, 0.00808831, 0.00814860, 0.00820923, 0.00827022, \
0.00833155, 0.00839324, 0.00845528, 0.00851768, 0.00858044, \
0.00864355, 0.00870703, 0.00877086, 0.00883506, 0.00889963, \
0.00896456, 0.00902986, 0.00909552, 0.00916156, 0.00922797, \
0.00929475, 0.00936191, 0.00942944, 0.00949736, 0.00956565, \
0.00963432, 0.00970337, 0.00977281, 0.00984264, 0.00991285, \
0.00998345, 0.01005444, 0.01012582, 0.01019759, 0.01026976, \
0.01034233, 0.01041529, 0.01048865, 0.01056242, 0.01063658, \
0.01071115, 0.01078613, 0.01086151, 0.01093730, 0.01101350, \
0.01109011, 0.01116714, 0.01124458, 0.01132243, 0.01140071, \
0.01147940, 0.01155852, 0.01163806, 0.01171802, 0.01179841, \
0.01187922, 0.01196047, 0.01204214, 0.01212425, 0.01220679, \
0.01228977, 0.01237318, 0.01245704, 0.01254133, 0.01262607, \
0.01271124, 0.01279687, 0.01288294, 0.01296946, 0.01305643, \
0.01314385, 0.01323172, 0.01332005, 0.01340884, 0.01349809, \
0.01358779, 0.01367796, 0.01376859, 0.01385968, 0.01395124, \
0.01404327, 0.01413577, 0.01422874, 0.01432218, 0.01441610, \
0.01451050, 0.01460537, 0.01470072, 0.01479656, 0.01489288, \
0.01498968, 0.01508697, 0.01518475, 0.01528302, 0.01538178, \
0.01548103, 0.01558078, 0.01568103, 0.01578177, 0.01588302, \
0.01598476, 0.01608702, 0.01618977, 0.01629303, 0.01639681, \
0.01650109, 0.01660588, 0.01671119, 0.01681702, 0.01692336, \
0.01703022, 0.01713760, 0.01724551, 0.01735394, 0.01746289, \
0.01757238, 0.01768239, 0.01779294, 0.01790402, 0.01801563, \
0.01812778, 0.01824047, 0.01835370, 0.01846747, 0.01858178, \
0.01869664, 0.01881205, 0.01892801, 0.01904451, 0.01916157, \
0.01927919, 0.01939736, 0.01951609, 0.01963538, 0.01975523, \
0.01987564, 0.01999662, 0.02011816, 0.02024028, 0.02036296, \
0.02048622, 0.02061005, 0.02073446, 0.02085944, 0.02098501, \
0.02111115, 0.02123788, 0.02136520, 0.02149310, 0.02162158, \
0.02175066, 0.02188034, 0.02201060, 0.02214146, 0.02227292, \
0.02240498, 0.02253764, 0.02267091, 0.02280477, 0.02293925, \
0.02307433, 0.02321003, 0.02334633, 0.02348325, 0.02362079, \
0.02375895, 0.02389772, 0.02403712, 0.02417714, 0.02431778, \
0.02445905, 0.02460095, 0.02474348, 0.02488665, 0.02503045, \
0.02517488, 0.02531995, 0.02546567, 0.02561202, 0.02575902, \
0.02590666, 0.02605495, 0.02620390, 0.02635349, 0.02650373, \
0.02665463, 0.02680619, 0.02695841, 0.02711128, 0.02726482, \
0.02741902, 0.02757389, 0.02772943, 0.02788564, 0.02804252, \
0.02820007, 0.02835830, 0.02851720, 0.02867679, 0.02883706, \
0.02899800, 0.02915964, 0.02932196, 0.02948497, 0.02964867, \
0.02981306, 0.02997815, 0.03014394, 0.03031042, 0.03047760, \
0.03064548, 0.03081407, 0.03098337, 0.03115337, 0.03132408, \
0.03149550, 0.03166764, 0.03184049, 0.03201405, 0.03218834, \
0.03236335, 0.03253908, 0.03271554, 0.03289272, 0.03307063, \
0.03324927, 0.03342864, 0.03360875, 0.03378959, 0.03397118, \
0.03415350, 0.03433656, 0.03452037, 0.03470492, 0.03489022, \
0.03507627, 0.03526307, 0.03545063, 0.03563894, 0.03582800, \
0.03601783, 0.03620841, 0.03639976, 0.03659188, 0.03678476, \
0.03697841, 0.03717283, 0.03736802, 0.03756398, 0.03776072, \
0.03795824, 0.03815654, 0.03835563, 0.03855549, 0.03875614, \
0.03895758, 0.03915981, 0.03936283, 0.03956664, 0.03977125, \
0.03997665, 0.04018285, 0.04038986, 0.04059767, 0.04080628, \
0.04101570, 0.04122592, 0.04143696, 0.04164881, 0.04186147, \
0.04207495, 0.04228925, 0.04250437, 0.04272030, 0.04293707, \
0.04315465, 0.04337307, 0.04359232, 0.04381239, 0.04403330, \
0.04425504, 0.04447763, 0.04470104, 0.04492531, 0.04515041, \
0.04537636, 0.04560315, 0.04583079, 0.04605928, 0.04628863, \
0.04651882, 0.04674988, 0.04698179, 0.04721456, 0.04744819, \
0.04768269, 0.04791805, 0.04815427, 0.04839137, 0.04862934, \
0.04886818, 0.04910789, 0.04934848, 0.04958995, 0.04983230, \
0.05007553, 0.05031965, 0.05056465, 0.05081053, 0.05105731, \
0.05130498, 0.05155354, 0.05180300, 0.05205335, 0.05230460, \
0.05255676, 0.05280981, 0.05306377, 0.05331864, 0.05357441, \
0.05383109, 0.05408869, 0.05434720, 0.05460662, 0.05486696, \
0.05512822, 0.05539040, 0.05565350, 0.05591753, 0.05618249, \
0.05644837, 0.05671518, 0.05698292, 0.05725160, 0.05752121, \
0.05779176, 0.05806325, 0.05833568, 0.05860905, 0.05888337, \
0.05915863, 0.05943484, 0.05971200, 0.05999011, 0.06026918, \
0.06054920, 0.06083018, 0.06111212, 0.06139501, 0.06167887, \
0.06196370, 0.06224948, 0.06253624, 0.06282397, 0.06311267, \
0.06340234, 0.06369298, 0.06398460, 0.06427720, 0.06457078, \
0.06486535, 0.06516089, 0.06545742, 0.06575494, 0.06605345, \
0.06635294, 0.06665343, 0.06695492, 0.06725739, 0.06756087, \
0.06786535, 0.06817082, 0.06847730, 0.06878478, 0.06909327, \
0.06940277, 0.06971328, 0.07002479, 0.07033732, 0.07065087, \
0.07096543, 0.07128101, 0.07159761, 0.07191523, 0.07223387, \
0.07255354, 0.07287423, 0.07319595, 0.07351870, 0.07384248, \
0.07416730, 0.07449315, 0.07482003, 0.07514796, 0.07547692, \
0.07580692, 0.07613797, 0.07647006, 0.07680320, 0.07713739, \
0.07747262, 0.07780891, 0.07814624, 0.07848464, 0.07882408, \
0.07916459, 0.07950615, 0.07984878, 0.08019247, 0.08053722, \
0.08088303, 0.08122992, 0.08157787, 0.08192689, 0.08227698, \
0.08262815, 0.08298039, 0.08333370, 0.08368810, 0.08404357, \
0.08440013, 0.08475776, 0.08511648, 0.08547629, 0.08583718, \
0.08619916, 0.08656224, 0.08692640, 0.08729166, 0.08765801, \
0.08802545, 0.08839400, 0.08876364, 0.08913438, 0.08950623, \
0.08987918, 0.09025323, 0.09062839, 0.09100466, 0.09138203, \
0.09176052, 0.09214012, 0.09252083, 0.09290266, 0.09328561, \
0.09366967, 0.09405485, 0.09444115, 0.09482857, 0.09521712, \
0.09560679, 0.09599759, 0.09638952, 0.09678257, 0.09717675, \
0.09757207, 0.09796852, 0.09836610, 0.09876482, 0.09916468, \
0.09956567, 0.09996781, 0.10037108, 0.10077550, 0.10118106, \
0.10158777, 0.10199562, 0.10240462, 0.10281477, 0.10322607, \
0.10363852, 0.10405213, 0.10446688, 0.10488280, 0.10529987, \
0.10571809, 0.10613748, 0.10655803, 0.10697974, 0.10740261, \
0.10782664, 0.10825184, 0.10867821, 0.10910574, 0.10953444, \
0.10996431, 0.11039536, 0.11082757, 0.11126096, 0.11169553, \
0.11213127, 0.11256818, 0.11300628, 0.11344555, 0.11388601, \
0.11432764, 0.11477046, 0.11521446, 0.11565965, 0.11610602, \
0.11655358, 0.11700233, 0.11745227, 0.11790340, 0.11835571, \
0.11880922, 0.11926393, 0.11971983, 0.12017692, 0.12063521, \
0.12109470, 0.12155539, 0.12201728, 0.12248036, 0.12294465, \
0.12341014, 0.12387684, 0.12434474, 0.12481384, 0.12528416, \
0.12575568, 0.12622840, 0.12670234, 0.12717749, 0.12765384, \
0.12813141, 0.12861020, 0.12909020, 0.12957141, 0.13005383, \
0.13053748, 0.13102234, 0.13150842, 0.13199572, 0.13248424, \
0.13297398, 0.13346494, 0.13395712, 0.13445053, 0.13494516, \
0.13544102, 0.13593810, 0.13643641, 0.13693594, 0.13743671, \
0.13793870, 0.13844192, 0.13894637, 0.13945206, 0.13995897, \
0.14046712, 0.14097650, 0.14148712, 0.14199897, 0.14251205, \
0.14302637, 0.14354193, 0.14405872, 0.14457676, 0.14509603, \
0.14561654, 0.14613829, 0.14666128, 0.14718551, 0.14771099, \
0.14823770, 0.14876566, 0.14929487, 0.14982531, 0.15035701, \
0.15088994, 0.15142413, 0.15195956, 0.15249623, 0.15303415, \
0.15357333, 0.15411375, 0.15465542, 0.15519833, 0.15574250, \
0.15628792, 0.15683459, 0.15738251, 0.15793168, 0.15848211, \
0.15903378, 0.15958671, 0.16014089, 0.16069633, 0.16125302, \
0.16181097, 0.16237017, 0.16293062, 0.16349234, 0.16405530, \
0.16461953, 0.16518501, 0.16575174, 0.16631974, 0.16688899, \
0.16745950, 0.16803127, 0.16860430, 0.16917858, 0.16975412, \
0.17033093, 0.17090899, 0.17148831, 0.17206889, 0.17265074, \
0.17323384, 0.17381820, 0.17440382, 0.17499071, 0.17557885, \
0.17616826, 0.17675892, 0.17735085, 0.17794404, 0.17853849, \
0.17913421, 0.17973118, 0.18032942, 0.18092891, 0.18152967, \
0.18213170, 0.18273498, 0.18333953, 0.18394533, 0.18455240, \
0.18516073, 0.18577033, 0.18638118, 0.18699330, 0.18760668, \
0.18822132, 0.18883723, 0.18945439, 0.19007282, 0.19069251, \
0.19131346, 0.19193567, 0.19255914, 0.19318388, 0.19380987, \
0.19443713, 0.19506564, 0.19569542, 0.19632646, 0.19695875, \
0.19759231, 0.19822712, 0.19886320, 0.19950054, 0.20013913, \
0.20077898, 0.20142009, 0.20206246, 0.20270609, 0.20335097, \
0.20399711, 0.20464451, 0.20529317, 0.20594308, 0.20659425, \
0.20724667, 0.20790035, 0.20855528, 0.20921147, 0.20986891, \
0.21052760, 0.21118755, 0.21184875, 0.21251120, 0.21317490, \
0.21383986, 0.21450607, 0.21517352, 0.21584223, 0.21651218, \
0.21718339, 0.21785584, 0.21852954, 0.21920449, 0.21988068, \
0.22055812, 0.22123680, 0.22191673, 0.22259790, 0.22328032, \
0.22396398, 0.22464888, 0.22533503, 0.22602241, 0.22671103, \
0.22740090, 0.22809200, 0.22878434, 0.22947792, 0.23017273, \
0.23086878, 0.23156607, 0.23226459, 0.23296434, 0.23366533, \
0.23436755, 0.23507099, 0.23577567, 0.23648158, 0.23718872, \
0.23789708, 0.23860667, 0.23931749, 0.24002953, 0.24074280, \
0.24145729, 0.24217300, 0.24288993, 0.24360809, 0.24432746, \
0.24504805, 0.24576986, 0.24649289, 0.24721713, 0.24794258, \
0.24866925, 0.24939713, 0.25012622, 0.25085652, 0.25158803, \
0.25232075, 0.25305468, 0.25378981, 0.25452614, 0.25526368, \
0.25600242, 0.25674237, 0.25748351, 0.25822585, 0.25896939, \
0.25971412, 0.26046005, 0.26120718, 0.26195549, 0.26270500, \
0.26345570, 0.26420758, 0.26496066, 0.26571492, 0.26647036, \
0.26722699, 0.26798480, 0.26874379, 0.26950396, 0.27026531, \
0.27102784, 0.27179154, 0.27255641, 0.27332246, 0.27408968, \
0.27485806, 0.27562762, 0.27639834, 0.27717023, 0.27794328, \
0.27871749, 0.27949286, 0.28026939, 0.28104708, 0.28182593, \
0.28260593, 0.28338708, 0.28416938, 0.28495283, 0.28573743, \
0.28652318, 0.28731007, 0.28809810, 0.28888728, 0.28967759, \
0.29046905, 0.29126163, 0.29205536, 0.29285021, 0.29364620, \
0.29444331, 0.29524156, 0.29604093, 0.29684142, 0.29764303, \
0.29844577, 0.29924962, 0.30005459, 0.30086067, 0.30166787, \
0.30247618, 0.30328559, 0.30409612, 0.30490775, 0.30572048, \
0.30653431, 0.30734924, 0.30816527, 0.30898240, 0.30980062, \
0.31061993, 0.31144033, 0.31226182, 0.31308439, 0.31390804, \
0.31473278, 0.31555860, 0.31638549, 0.31721346, 0.31804250, \
0.31887261, 0.31970379, 0.32053603, 0.32136934, 0.32220372, \
0.32303915, 0.32387564, 0.32471318, 0.32555178, 0.32639143, \
0.32723213, 0.32807388, 0.32891666, 0.32976049, 0.33060536, \
0.33145127, 0.33229822, 0.33314619, 0.33399520, 0.33484523, \
0.33569629, 0.33654837, 0.33740147, 0.33825559, 0.33911073, \
0.33996688, 0.34082404, 0.34168221, 0.34254139, 0.34340157, \
0.34426275, 0.34512493, 0.34598810, 0.34685227, 0.34771743, \
0.34858358, 0.34945072, 0.35031883, 0.35118793, 0.35205801, \
0.35292906, 0.35380109, 0.35467408, 0.35554804, 0.35642297, \
0.35729886, 0.35817571, 0.35905351, 0.35993227, 0.36081199, \
0.36169264, 0.36257425, 0.36345680, 0.36434029, 0.36522471, \
0.36611008, 0.36699637, 0.36788359, 0.36877174, 0.36966081, \
0.37055080, 0.37144171, 0.37233354, 0.37322627, 0.37411992, \
0.37501447, 0.37590992, 0.37680628, 0.37770353, 0.37860167, \
0.37950071, 0.38040064, 0.38130145, 0.38220314, 0.38310571, \
0.38400916, 0.38491348, 0.38581867, 0.38672473, 0.38763165, \
0.38853943, 0.38944807, 0.39035756, 0.39126791, 0.39217910, \
0.39309114, 0.39400402, 0.39491774, 0.39583229, 0.39674768, \
0.39766389, 0.39858093, 0.39949880, 0.40041748, 0.40133698, \
0.40225729, 0.40317841, 0.40410034, 0.40502307, 0.40594660, \
0.40687092, 0.40779604, 0.40872195, 0.40964864, 0.41057611, \
0.41150437, 0.41243340, 0.41336320, 0.41429377, 0.41522511, \
0.41615721, 0.41709007, 0.41802368, 0.41895805, 0.41989316, \
0.42082902, 0.42176561, 0.42270295, 0.42364102, 0.42457982, \
0.42551935, 0.42645960, 0.42740057, 0.42834225, 0.42928465, \
0.43022776, 0.43117157, 0.43211608, 0.43306129, 0.43400720, \
0.43495380, 0.43590108, 0.43684904, 0.43779769, 0.43874701, \
0.43969700, 0.44064766, 0.44159899, 0.44255097, 0.44350361, \
0.44445691, 0.44541085, 0.44636544, 0.44732067, 0.44827654, \
0.44923305, 0.45019018, 0.45114794, 0.45210632, 0.45306532, \
0.45402493, 0.45498516, 0.45594599, 0.45690742, 0.45786945, \
0.45883208, 0.45979529, 0.46075910, 0.46172349, 0.46268845, \
0.46365399, 0.46462010, 0.46558678, 0.46655402, 0.46752182, \
0.46849017, 0.46945908, 0.47042853, 0.47139852, 0.47236905, \
0.47334011, 0.47431171, 0.47528383, 0.47625647, 0.47722963, \
0.47820330, 0.47917748, 0.48015217, 0.48112736, 0.48210304, \
0.48307922, 0.48405588, 0.48503303, 0.48601065, 0.48698876, \
0.48796733, 0.48894637, 0.48992587, 0.49090583, 0.49188625, \
0.49286711, 0.49384842, 0.49483017, 0.49581236, 0.49679497, \
0.49777802, 0.49876149, 0.49974538, 0.50072968, 0.50171439, \
0.50269951, 0.50368503, 0.50467095, 0.50565726, 0.50664396, \
0.50763104, 0.50861850, 0.50960633, 0.51059454, 0.51158311, \
0.51257204, 0.51356132, 0.51455096, 0.51554095, 0.51653128, \
0.51752195, 0.51851295, 0.51950428, 0.52049594, 0.52148791, \
0.52248020, 0.52347280, 0.52446571, 0.52545892, 0.52645243, \
0.52744623, 0.52844031, 0.52943468, 0.53042933, 0.53142425, \
0.53241944, 0.53341489, 0.53441060, 0.53540657, 0.53640279, \
0.53739925, 0.53839595, 0.53939289, 0.54039006, 0.54138746, \
0.54238508, 0.54338291, 0.54438096, 0.54537921, 0.54637767, \
0.54737632, 0.54837516, 0.54937420, 0.55037341, 0.55137281, \
0.55237238, 0.55337211, 0.55437201, 0.55537207, 0.55637228, \
0.55737264, 0.55837315, 0.55937379, 0.56037457, 0.56137547, \
0.56237650, 0.56337765, 0.56437892, 0.56538029, 0.56638177, \
0.56738334, 0.56838502, 0.56938678, 0.57038862, 0.57139055, \
0.57239255, 0.57339461, 0.57439675, 0.57539894, 0.57640119, \
0.57740348, 0.57840582, 0.57940820, 0.58041061, 0.58141306, \
0.58241552, 0.58341801, 0.58442050, 0.58542301, 0.58642552, \
0.58742803, 0.58843053, 0.58943302, 0.59043550, 0.59143795, \
0.59244037, 0.59344276, 0.59444512, 0.59544743, 0.59644969, \
0.59745190, 0.59845405, 0.59945614, 0.60045816, 0.60146010, \
0.60246197, 0.60346375, 0.60446544, 0.60546704, 0.60646854, \
0.60746993, 0.60847121, 0.60947238, 0.61047342, 0.61147434, \
0.61247513, 0.61347578, 0.61447629, 0.61547665, 0.61647685, \
0.61747690, 0.61847679, 0.61947651, 0.62047605, 0.62147542, \
0.62247460, 0.62347359, 0.62447238, 0.62547098, 0.62646936, \
0.62746754, 0.62846550, 0.62946324, 0.63046075, 0.63145803, \
0.63245507, 0.63345187, 0.63444841, 0.63544471, 0.63644074, \
0.63743651, 0.63843201, 0.63942723, 0.64042217, 0.64141683, \
0.64241119, 0.64340526, 0.64439902, 0.64539247, 0.64638561, \
0.64737844, 0.64837093, 0.64936310, 0.65035493, 0.65134642, \
0.65233756, 0.65332835, 0.65431879, 0.65530886, 0.65629856, \
0.65728789, 0.65827684, 0.65926540, 0.66025358, 0.66124136, \
0.66222873, 0.66321570, 0.66420226, 0.66518840, 0.66617412, \
0.66715941, 0.66814426, 0.66912868, 0.67011265, 0.67109616, \
0.67207922, 0.67306182, 0.67404396, 0.67502562, 0.67600680, \
0.67698749, 0.67796770, 0.67894741, 0.67992662, 0.68090533, \
0.68188352, 0.68286119, 0.68383835, 0.68481497, 0.68579106, \
0.68676661, 0.68774162, 0.68871607, 0.68968997, 0.69066330, \
0.69163607, 0.69260827, 0.69357989, 0.69455092, 0.69552136, \
0.69649121, 0.69746045, 0.69842909, 0.69939712, 0.70036453, \
0.70133132, 0.70229748, 0.70326300, 0.70422788, 0.70519212, \
0.70615571, 0.70711864, 0.70808090, 0.70904250, 0.71000343, \
0.71096367, 0.71192323, 0.71288210, 0.71384028, 0.71479775, \
0.71575452, 0.71671057, 0.71766590, 0.71862051, 0.71957439, \
0.72052753, 0.72147994, 0.72243160, 0.72338250, 0.72433265, \
0.72528203, 0.72623064, 0.72717848, 0.72812554, 0.72907182, \
0.73001730, 0.73096198, 0.73190587, 0.73284894, 0.73379120, \
0.73473264, 0.73567326, 0.73661304, 0.73755199, 0.73849010, \
0.73942735, 0.74036376, 0.74129931, 0.74223399, 0.74316780, \
0.74410074, 0.74503279, 0.74596396, 0.74689424, 0.74782362, \
0.74875209, 0.74967966, 0.75060631, 0.75153204, 0.75245684, \
0.75338072, 0.75430365, 0.75522565, 0.75614669, 0.75706678, \
0.75798591, 0.75890408, 0.75982128, 0.76073750, 0.76165273, \
0.76256698, 0.76348024, 0.76439250, 0.76530375, 0.76621400, \
0.76712323, 0.76803144, 0.76893862, 0.76984477, 0.77074988, \
0.77165395, 0.77255698, 0.77345894, 0.77435985, 0.77525970, \
0.77615847, 0.77705616, 0.77795278, 0.77884830, 0.77974274, \
0.78063607, 0.78152830, 0.78241943, 0.78330943, 0.78419832, \
0.78508608, 0.78597271, 0.78685820, 0.78774255, 0.78862575, \
0.78950780, 0.79038869, 0.79126842, 0.79214697, 0.79302435, \
0.79390055, 0.79477556, 0.79564938, 0.79652201, 0.79739343, \
0.79826364, 0.79913264, 0.80000042, 0.80086698, 0.80173230, \
0.80259639, 0.80345924, 0.80432084, 0.80518120, 0.80604029, \
0.80689812, 0.80775469, 0.80860998, 0.80946399, 0.81031672, \
0.81116816, 0.81201830, 0.81286714, 0.81371468, 0.81456091, \
0.81540582, 0.81624941, 0.81709167, 0.81793260, 0.81877219, \
0.81961044, 0.82044734, 0.82128289, 0.82211708, 0.82294990, \
0.82378135, 0.82461143, 0.82544013, 0.82626745, 0.82709337, \
0.82791789, 0.82874102, 0.82956274, 0.83038304, 0.83120193, \
0.83201940, 0.83283544, 0.83365005, 0.83446321, 0.83527494, \
0.83608522, 0.83689404, 0.83770140, 0.83850730, 0.83931173, \
0.84011469, 0.84091617, 0.84171616, 0.84251466, 0.84331166, \
0.84410717, 0.84490117, 0.84569366, 0.84648463, 0.84727409, \
0.84806201, 0.84884841, 0.84963327, 0.85041659, 0.85119836, \
0.85197858, 0.85275725, 0.85353435, 0.85430989, 0.85508385, \
0.85585624, 0.85662704, 0.85739626, 0.85816389, 0.85892992, \
0.85969435, 0.86045717, 0.86121838, 0.86197798, 0.86273595, \
0.86349229, 0.86424701, 0.86500008, 0.86575152, 0.86650131, \
0.86724945, 0.86799593, 0.86874075, 0.86948390, 0.87022539, \
0.87096519, 0.87170332, 0.87243976, 0.87317451, 0.87390757, \
0.87463893, 0.87536858, 0.87609652, 0.87682275, 0.87754725, \
0.87827004, 0.87899109, 0.87971041, 0.88042800, 0.88114383, \
0.88185793, 0.88257027, 0.88328085, 0.88398967, 0.88469672, \
0.88540200, 0.88610551, 0.88680723, 0.88750717, 0.88820532, \
0.88890168, 0.88959624, 0.89028899, 0.89097993, 0.89166906, \
0.89235637, 0.89304186, 0.89372553, 0.89440736, 0.89508735, \
0.89576551, 0.89644182, 0.89711628, 0.89778889, 0.89845964, \
0.89912852, 0.89979554, 0.90046068, 0.90112395, 0.90178534, \
0.90244484, 0.90310246, 0.90375817, 0.90441199, 0.90506391, \
0.90571392, 0.90636202, 0.90700820, 0.90765246, 0.90829480, \
0.90893521, 0.90957368, 0.91021022, 0.91084482, 0.91147747, \
0.91210816, 0.91273691, 0.91336369, 0.91398851, 0.91461137, \
0.91523225, 0.91585116, 0.91646808, 0.91708303, 0.91769598, \
0.91830694, 0.91891591, 0.91952287, 0.92012783, 0.92073078, \
0.92133172, 0.92193064, 0.92252754, 0.92312242, 0.92371526, \
0.92430607, 0.92489485, 0.92548158, 0.92606627, 0.92664891, \
0.92722949, 0.92780802, 0.92838449, 0.92895889, 0.92953123, \
0.93010149, 0.93066967, 0.93123578, 0.93179980, 0.93236173, \
0.93292157, 0.93347931, 0.93403495, 0.93458849, 0.93513993, \
0.93568925, 0.93623645, 0.93678154, 0.93732451, 0.93786535, \
0.93840406, 0.93894064, 0.93947508, 0.94000738, 0.94053753, \
0.94106554, 0.94159139, 0.94211509, 0.94263664, 0.94315601, \
0.94367323, 0.94418827, 0.94470114, 0.94521184, 0.94572035, \
0.94622668, 0.94673083, 0.94723278, 0.94773254, 0.94823010, \
0.94872546, 0.94921862, 0.94970957, 0.95019831, 0.95068483, \
0.95116914, 0.95165123, 0.95213109, 0.95260872, 0.95308412, \
0.95355729, 0.95402822, 0.95449691, 0.95496336, 0.95542756, \
0.95588951, 0.95634920, 0.95680664, 0.95726182, 0.95771474, \
0.95816539, 0.95861377, 0.95905987, 0.95950371, 0.95994526, \
0.96038453, 0.96082152, 0.96125622, 0.96168863, 0.96211874, \
0.96254656, 0.96297208, 0.96339530, 0.96381621, 0.96423481, \
0.96465110, 0.96506508, 0.96547674, 0.96588608, 0.96629310, \
0.96669779, 0.96710015, 0.96750018, 0.96789788, 0.96829324, \
0.96868626, 0.96907694, 0.96946528, 0.96985126, 0.97023490, \
0.97061618, 0.97099511, 0.97137168, 0.97174589, 0.97211773, \
0.97248721, 0.97285432, 0.97321906, 0.97358142, 0.97394141, \
0.97429902, 0.97465425, 0.97500709, 0.97535755, 0.97570562, \
0.97605130, 0.97639458, 0.97673547, 0.97707396, 0.97741005, \
0.97774374, 0.97807502, 0.97840389, 0.97873036, 0.97905441, \
0.97937605, 0.97969526, 0.98001207, 0.98032644, 0.98063840, \
0.98094793, 0.98125503, 0.98155971, 0.98186195, 0.98216175, \
0.98245912, 0.98275405, 0.98304655, 0.98333659, 0.98362420, \
0.98390936, 0.98419207, 0.98447232, 0.98475013, 0.98502548, \
0.98529838, 0.98556881, 0.98583679, 0.98610231, 0.98636536, \
0.98662594, 0.98688406, 0.98713971, 0.98739288, 0.98764359, \
0.98789182, 0.98813757, 0.98838084, 0.98862164, 0.98885995, \
0.98909578, 0.98932913, 0.98955998, 0.98978835, 0.99001423, \
0.99023762, 0.99045852, 0.99067692, 0.99089283, 0.99110623, \
0.99131714, 0.99152555, 0.99173146, 0.99193486, 0.99213576, \
0.99233415, 0.99253003, 0.99272341, 0.99291427, 0.99310262, \
0.99328846, 0.99347179, 0.99365259, 0.99383089, 0.99400666, \
0.99417991, 0.99435065, 0.99451886, 0.99468455, 0.99484771, \
0.99500835, 0.99516646, 0.99532205, 0.99547510, 0.99562563, \
0.99577363, 0.99591909, 0.99606202, 0.99620242, 0.99634028, \
0.99647560, 0.99660839, 0.99673864, 0.99686635, 0.99699153, \
0.99711416, 0.99723425, 0.99735180, 0.99746680, 0.99757926, \
0.99768918, 0.99779655, 0.99790138, 0.99800365, 0.99810338, \
0.99820057, 0.99829520, 0.99838728, 0.99847681, 0.99856380, \
0.99864823, 0.99873010, 0.99880943, 0.99888620, 0.99896042, \
0.99903208, 0.99910119, 0.99916774, 0.99923174, 0.99929318, \
0.99935207, 0.99940839, 0.99946216, 0.99951337, 0.99956203, \
0.99960812, 0.99965166, 0.99969263, 0.99973105, 0.99976690, \
0.99980020, 0.99983094, 0.99985911, 0.99988473, 0.99990778, \
0.99992827, 0.99994620, 0.99996157, 0.99997438, 0.99998463, \
0.99999231, 0.99999744, 1.00000000, } 


 #endif // _FPU_FFT_CHEB_H_
//=============================================================================
// End of File
//=============================================================================

