//=============================================================================
// Gauss Window 
//=============================================================================
#ifndef _FPU_FFT_GAUSS_H_
#define _FPU_FFT_GAUSS_H_

#define GAUSS32 {\
0.04393693, 0.06490819, 0.09342675, 0.13102225, 0.17902795, \
0.23834095, 0.30915658, 0.39071524, 0.48110981, 0.57720502, \
0.67471133, 0.76843638, 0.85270705, 0.92192120, 0.97115772, \
0.99675346, } 

#define GAUSS64 {\
0.04393693, 0.05341110, 0.06452050, 0.07745125, 0.09238970, \
0.10951741, 0.12900521, 0.15100654, 0.17565024, 0.20303280, \
0.23321050, 0.26619167, 0.30192931, 0.34031458, 0.38117139, \
0.42425258, 0.46923797, 0.51573459, 0.56327935, 0.61134429, \
0.65934445, 0.70664828, 0.75259047, 0.79648680, 0.83765061, \
0.87541039, 0.90912781, 0.93821560, 0.96215449, 0.98050866, \
0.99293888, 0.99921296, } 

#define GAUSS128 {\
0.04393693, 0.04844385, 0.05333035, 0.05861882, 0.06433193, \
0.07049249, 0.07712337, 0.08424731, 0.09188674, 0.10006369, \
0.10879954, 0.11811483, 0.12802908, 0.13856057, 0.14972612, \
0.16154082, 0.17401788, 0.18716829, 0.20100069, 0.21552102, \
0.23073240, 0.24663481, 0.26322492, 0.28049587, 0.29843708, \
0.31703407, 0.33626830, 0.35611705, 0.37655329, 0.39754562, \
0.41905819, 0.44105073, 0.46347850, 0.48629240, 0.50943903, \
0.53286082, 0.55649621, 0.58027982, 0.60414276, 0.62801283, \
0.65181493, 0.67547135, 0.69890220, 0.72202580, 0.74475920, \
0.76701856, 0.78871974, 0.80977879, 0.83011244, 0.84963870, \
0.86827740, 0.88595068, 0.90258361, 0.91810463, 0.93244614, \
0.94554494, 0.95734272, 0.96778646, 0.97682887, 0.98442872, \
0.99055115, 0.99516795, 0.99825777, 0.99980627, } 

#define GAUSS256 {\
0.04393693, 0.04613550, 0.04842545, 0.05080953, 0.05329049, \
0.05587111, 0.05855418, 0.06134251, 0.06423892, 0.06724622, \
0.07036725, 0.07360483, 0.07696178, 0.08044089, 0.08404497, \
0.08777676, 0.09163902, 0.09563444, 0.09976570, 0.10403542, \
0.10844617, 0.11300047, 0.11770076, 0.12254945, 0.12754882, \
0.13270112, 0.13800847, 0.14347292, 0.14909639, 0.15488073, \
0.16082762, 0.16693867, 0.17321531, 0.17965885, 0.18627046, \
0.19305115, 0.20000177, 0.20712299, 0.21441531, 0.22187906, \
0.22951436, 0.23732114, 0.24529914, 0.25344788, 0.26176665, \
0.27025455, 0.27891041, 0.28773286, 0.29672028, 0.30587081, \
0.31518232, 0.32465247, 0.33427861, 0.34405787, 0.35398710, \
0.36406288, 0.37428153, 0.38463908, 0.39513132, 0.40575375, \
0.41650157, 0.42736974, 0.43835295, 0.44944559, 0.46064179, \
0.47193543, 0.48332009, 0.49478913, 0.50633562, 0.51795238, \
0.52963200, 0.54136681, 0.55314892, 0.56497019, 0.57682228, \
0.58869663, 0.60058447, 0.61247685, 0.62436462, 0.63623846, \
0.64808889, 0.65990629, 0.67168088, 0.68340276, 0.69506193, \
0.70664828, 0.71815160, 0.72956164, 0.74086807, 0.75206052, \
0.76312860, 0.77406191, 0.78485006, 0.79548266, 0.80594939, \
0.81623995, 0.82634415, 0.83625185, 0.84595304, 0.85543782, \
0.86469643, 0.87371927, 0.88249690, 0.89102008, 0.89927977, \
0.90726714, 0.91497361, 0.92239084, 0.92951077, 0.93632560, \
0.94282783, 0.94901029, 0.95486610, 0.96038873, 0.96557200, \
0.97041009, 0.97489753, 0.97902924, 0.98280053, 0.98620712, \
0.98924510, 0.99191102, 0.99420180, 0.99611483, 0.99764791, \
0.99879926, 0.99956757, 0.99995194, } 

#define GAUSS512 {\
0.04393693, 0.04502281, 0.04613111, 0.04726216, 0.04841631, \
0.04959389, 0.05079526, 0.05202074, 0.05327069, 0.05454545, \
0.05584537, 0.05717079, 0.05852207, 0.05989955, 0.06130359, \
0.06273453, 0.06419272, 0.06567852, 0.06719228, 0.06873434, \
0.07030507, 0.07190480, 0.07353389, 0.07519269, 0.07688156, \
0.07860082, 0.08035085, 0.08213197, 0.08394454, 0.08578889, \
0.08766537, 0.08957432, 0.09151608, 0.09349098, 0.09549935, \
0.09754153, 0.09961784, 0.10172861, 0.10387416, 0.10605480, \
0.10827086, 0.11052264, 0.11281044, 0.11513459, 0.11749536, \
0.11989307, 0.12232799, 0.12480041, 0.12731061, 0.12985887, \
0.13244546, 0.13507063, 0.13773465, 0.14043777, 0.14318023, \
0.14596226, 0.14878411, 0.15164599, 0.15454812, 0.15749072, \
0.16047397, 0.16349808, 0.16656323, 0.16966960, 0.17281736, \
0.17600667, 0.17923767, 0.18251050, 0.18582531, 0.18918221, \
0.19258131, 0.19602272, 0.19950652, 0.20303280, 0.20660162, \
0.21021305, 0.21386713, 0.21756389, 0.22130337, 0.22508557, \
0.22891049, 0.23277813, 0.23668844, 0.24064141, 0.24463697, \
0.24867506, 0.25275561, 0.25687852, 0.26104369, 0.26525100, \
0.26950032, 0.27379149, 0.27812437, 0.28249876, 0.28691449, \
0.29137134, 0.29586909, 0.30040751, 0.30498635, 0.30960533, \
0.31426418, 0.31896259, 0.32370025, 0.32847684, 0.33329199, \
0.33814536, 0.34303656, 0.34796519, 0.35293084, 0.35793308, \
0.36297147, 0.36804555, 0.37315482, 0.37829881, 0.38347699, \
0.38868883, 0.39393379, 0.39921130, 0.40452078, 0.40986164, \
0.41523326, 0.42063500, 0.42606622, 0.43152624, 0.43701440, \
0.44252999, 0.44807228, 0.45364056, 0.45923406, 0.46485203, \
0.47049367, 0.47615819, 0.48184478, 0.48755260, 0.49328080, \
0.49902852, 0.50479489, 0.51057899, 0.51637994, 0.52219679, \
0.52802861, 0.53387445, 0.53973333, 0.54560426, 0.55148625, \
0.55737829, 0.56327935, 0.56918839, 0.57510435, 0.58102616, \
0.58695276, 0.59288304, 0.59881591, 0.60475024, 0.61068491, \
0.61661879, 0.62255071, 0.62847953, 0.63440406, 0.64032314, \
0.64623557, 0.65214016, 0.65803568, 0.66392094, 0.66979471, \
0.67565574, 0.68150282, 0.68733468, 0.69315009, 0.69894777, \
0.70472648, 0.71048494, 0.71622187, 0.72193601, 0.72762606, \
0.73329076, 0.73892881, 0.74453892, 0.75011980, 0.75567016, \
0.76118871, 0.76667416, 0.77212521, 0.77754057, 0.78291895, \
0.78825906, 0.79355961, 0.79881933, 0.80403692, 0.80921111, \
0.81434063, 0.81942422, 0.82446059, 0.82944851, 0.83438671, \
0.83927396, 0.84410901, 0.84889064, 0.85361762, 0.85828876, \
0.86290283, 0.86745865, 0.87195504, 0.87639082, 0.88076485, \
0.88507596, 0.88932302, 0.89350491, 0.89762053, 0.90166877, \
0.90564855, 0.90955882, 0.91339851, 0.91716660, 0.92086207, \
0.92448391, 0.92803114, 0.93150279, 0.93489792, 0.93821560, \
0.94145490, 0.94461495, 0.94769487, 0.95069380, 0.95361092, \
0.95644542, 0.95919650, 0.96186340, 0.96444537, 0.96694170, \
0.96935167, 0.97167462, 0.97390989, 0.97605684, 0.97811488, \
0.98008342, 0.98196190, 0.98374979, 0.98544659, 0.98705181, \
0.98856499, 0.98998570, 0.99131354, 0.99254813, 0.99368912, \
0.99473618, 0.99568900, 0.99654733, 0.99731090, 0.99797951, \
0.99855296, 0.99903109, 0.99941376, 0.99970085, 0.99989230, \
0.99998803, } 

#define GAUSS1024 {\
0.04393693, 0.04447656, 0.04502174, 0.04557251, 0.04612892, \
0.04669100, 0.04725881, 0.04783238, 0.04841175, 0.04899697, \
0.04958808, 0.05018512, 0.05078814, 0.05139718, 0.05201227, \
0.05263347, 0.05326082, 0.05389436, 0.05453413, 0.05518017, \
0.05583254, 0.05649127, 0.05715641, 0.05782799, 0.05850607, \
0.05919069, 0.05988188, 0.06057971, 0.06128419, 0.06199540, \
0.06271335, 0.06343811, 0.06416970, 0.06490819, 0.06565360, \
0.06640599, 0.06716540, 0.06793187, 0.06870544, 0.06948617, \
0.07027408, 0.07106923, 0.07187167, 0.07268142, 0.07349855, \
0.07432308, 0.07515507, 0.07599456, 0.07684159, 0.07769620, \
0.07855844, 0.07942836, 0.08030599, 0.08119137, 0.08208456, \
0.08298559, 0.08389450, 0.08481135, 0.08573617, 0.08666900, \
0.08760988, 0.08855887, 0.08951600, 0.09048131, 0.09145484, \
0.09243664, 0.09342675, 0.09442521, 0.09543206, 0.09644735, \
0.09747110, 0.09850337, 0.09954419, 0.10059361, 0.10165166, \
0.10271839, 0.10379383, 0.10487803, 0.10597102, 0.10707284, \
0.10818354, 0.10930314, 0.11043170, 0.11156924, 0.11271580, \
0.11387143, 0.11503616, 0.11621003, 0.11739307, 0.11858532, \
0.11978682, 0.12099760, 0.12221770, 0.12344715, 0.12468599, \
0.12593426, 0.12719198, 0.12845920, 0.12973595, 0.13102225, \
0.13231814, 0.13362366, 0.13493884, 0.13626371, 0.13759830, \
0.13894264, 0.14029676, 0.14166070, 0.14303448, 0.14441813, \
0.14581168, 0.14721516, 0.14862860, 0.15005203, 0.15148547, \
0.15292895, 0.15438250, 0.15584614, 0.15731990, 0.15880380, \
0.16029787, 0.16180213, 0.16331661, 0.16484132, 0.16637630, \
0.16792155, 0.16947711, 0.17104299, 0.17261922, 0.17420581, \
0.17580278, 0.17741016, 0.17902795, 0.18065619, 0.18229487, \
0.18394403, 0.18560367, 0.18727381, 0.18895447, 0.19064565, \
0.19234738, 0.19405966, 0.19578250, 0.19751593, 0.19925994, \
0.20101454, 0.20277976, 0.20455558, 0.20634204, 0.20813912, \
0.20994683, 0.21176519, 0.21359419, 0.21543385, 0.21728415, \
0.21914512, 0.22101674, 0.22289903, 0.22479197, 0.22669558, \
0.22860984, 0.23053476, 0.23247033, 0.23441656, 0.23637343, \
0.23834095, 0.24031910, 0.24230788, 0.24430729, 0.24631730, \
0.24833792, 0.25036914, 0.25241094, 0.25446331, 0.25652625, \
0.25859973, 0.26068374, 0.26277827, 0.26488330, 0.26699881, \
0.26912479, 0.27126122, 0.27340808, 0.27556535, 0.27773300, \
0.27991102, 0.28209938, 0.28429805, 0.28650702, 0.28872626, \
0.29095573, 0.29319541, 0.29544528, 0.29770530, 0.29997544, \
0.30225568, 0.30454597, 0.30684628, 0.30915658, 0.31147684, \
0.31380702, 0.31614707, 0.31849697, 0.32085666, 0.32322612, \
0.32560530, 0.32799416, 0.33039265, 0.33280073, 0.33521835, \
0.33764547, 0.34008203, 0.34252800, 0.34498332, 0.34744794, \
0.34992181, 0.35240487, 0.35489708, 0.35739837, 0.35990869, \
0.36242799, 0.36495620, 0.36749328, 0.37003914, 0.37259375, \
0.37515703, 0.37772892, 0.38030935, 0.38289827, 0.38549560, \
0.38810128, 0.39071524, 0.39333741, 0.39596771, 0.39860608, \
0.40125245, 0.40390674, 0.40656887, 0.40923878, 0.41191637, \
0.41460158, 0.41729433, 0.41999453, 0.42270211, 0.42541698, \
0.42813906, 0.43086826, 0.43360450, 0.43634770, 0.43909776, \
0.44185459, 0.44461812, 0.44738824, 0.45016486, 0.45294790, \
0.45573726, 0.45853283, 0.46133454, 0.46414228, 0.46695595, \
0.46977546, 0.47260070, 0.47543157, 0.47826798, 0.48110981, \
0.48395697, 0.48680935, 0.48966685, 0.49252935, 0.49539675, \
0.49826894, 0.50114581, 0.50402725, 0.50691315, 0.50980339, \
0.51269787, 0.51559646, 0.51849905, 0.52140553, 0.52431577, \
0.52722967, 0.53014709, 0.53306792, 0.53599204, 0.53891933, \
0.54184966, 0.54478290, 0.54771895, 0.55065766, 0.55359891, \
0.55654258, 0.55948854, 0.56243665, 0.56538680, 0.56833884, \
0.57129264, 0.57424808, 0.57720502, 0.58016333, 0.58312287, \
0.58608350, 0.58904510, 0.59200751, 0.59497062, 0.59793427, \
0.60089833, 0.60386265, 0.60682711, 0.60979155, 0.61275583, \
0.61571981, 0.61868335, 0.62164631, 0.62460853, 0.62756988, \
0.63053020, 0.63348936, 0.63644720, 0.63940358, 0.64235834, \
0.64531134, 0.64826243, 0.65121146, 0.65415828, 0.65710273, \
0.66004468, 0.66298395, 0.66592041, 0.66885389, 0.67178425, \
0.67471133, 0.67763497, 0.68055503, 0.68347134, 0.68638375, \
0.68929211, 0.69219625, 0.69509602, 0.69799127, 0.70088183, \
0.70376756, 0.70664828, 0.70952384, 0.71239409, 0.71525886, \
0.71811800, 0.72097134, 0.72381873, 0.72666001, 0.72949501, \
0.73232358, 0.73514555, 0.73796077, 0.74076908, 0.74357031, \
0.74636430, 0.74915089, 0.75192993, 0.75470124, 0.75746468, \
0.76022007, 0.76296726, 0.76570608, 0.76843638, 0.77115799, \
0.77387076, 0.77657452, 0.77926910, 0.78195436, 0.78463013, \
0.78729624, 0.78995254, 0.79259888, 0.79523508, 0.79786098, \
0.80047644, 0.80308128, 0.80567536, 0.80825850, 0.81083056, \
0.81339137, 0.81594078, 0.81847863, 0.82100475, 0.82351900, \
0.82602122, 0.82851125, 0.83098893, 0.83345412, 0.83590664, \
0.83834636, 0.84077311, 0.84318674, 0.84558711, 0.84797405, \
0.85034741, 0.85270705, 0.85505280, 0.85738453, 0.85970208, \
0.86200530, 0.86429405, 0.86656817, 0.86882752, 0.87107195, \
0.87330132, 0.87551548, 0.87771428, 0.87989759, 0.88206526, \
0.88421714, 0.88635310, 0.88847300, 0.89057669, 0.89266403, \
0.89473490, 0.89678915, 0.89882664, 0.90084724, 0.90285081, \
0.90483722, 0.90680635, 0.90875804, 0.91069219, 0.91260865, \
0.91450729, 0.91638800, 0.91825063, 0.92009508, 0.92192120, \
0.92372888, 0.92551800, 0.92728843, 0.92904005, 0.93077275, \
0.93248640, 0.93418089, 0.93585610, 0.93751192, 0.93914824, \
0.94076494, 0.94236191, 0.94393904, 0.94549622, 0.94703335, \
0.94855032, 0.95004702, 0.95152335, 0.95297921, 0.95441450, \
0.95582912, 0.95722297, 0.95859595, 0.95994797, 0.96127893, \
0.96258874, 0.96387731, 0.96514455, 0.96639037, 0.96761468, \
0.96881740, 0.96999844, 0.97115772, 0.97229516, 0.97341068, \
0.97450420, 0.97557565, 0.97662494, 0.97765200, 0.97865677, \
0.97963916, 0.98059912, 0.98153657, 0.98245144, 0.98334368, \
0.98421322, 0.98505999, 0.98588394, 0.98668501, 0.98746314, \
0.98821828, 0.98895037, 0.98965936, 0.99034520, 0.99100784, \
0.99164723, 0.99226334, 0.99285611, 0.99342550, 0.99397147, \
0.99449399, 0.99499301, 0.99546850, 0.99592043, 0.99634876, \
0.99675346, 0.99713451, 0.99749187, 0.99782553, 0.99813545, \
0.99842162, 0.99868401, 0.99892261, 0.99913740, 0.99932836, \
0.99949548, 0.99963875, 0.99975816, 0.99985369, 0.99992535, \
0.99997313, 0.99999701, } 

#define GAUSS2048 {\
0.04393693, 0.04420592, 0.04447629, 0.04474805, 0.04502120, \
0.04529575, 0.04557170, 0.04584905, 0.04612782, 0.04640801, \
0.04668962, 0.04697266, 0.04725714, 0.04754305, 0.04783041, \
0.04811921, 0.04840947, 0.04870120, 0.04899438, 0.04928904, \
0.04958518, 0.04988280, 0.05018190, 0.05048249, 0.05078459, \
0.05108818, 0.05139329, 0.05169991, 0.05200805, 0.05231771, \
0.05262890, 0.05294163, 0.05325589, 0.05357171, 0.05388907, \
0.05420799, 0.05452847, 0.05485052, 0.05517415, 0.05549935, \
0.05582614, 0.05615451, 0.05648448, 0.05681605, 0.05714922, \
0.05748401, 0.05782041, 0.05815843, 0.05849808, 0.05883937, \
0.05918229, 0.05952685, 0.05987306, 0.06022093, 0.06057046, \
0.06092165, 0.06127451, 0.06162905, 0.06198527, 0.06234318, \
0.06270278, 0.06306408, 0.06342708, 0.06379179, 0.06415822, \
0.06452636, 0.06489623, 0.06526783, 0.06564117, 0.06601624, \
0.06639307, 0.06677165, 0.06715198, 0.06753408, 0.06791795, \
0.06830359, 0.06869102, 0.06908022, 0.06947122, 0.06986402, \
0.07025862, 0.07065502, 0.07105324, 0.07145327, 0.07185513, \
0.07225882, 0.07266434, 0.07307170, 0.07348090, 0.07389196, \
0.07430488, 0.07471965, 0.07513629, 0.07555481, 0.07597520, \
0.07639747, 0.07682164, 0.07724770, 0.07767566, 0.07810552, \
0.07853729, 0.07897098, 0.07940659, 0.07984413, 0.08028360, \
0.08072500, 0.08116835, 0.08161365, 0.08206089, 0.08251010, \
0.08296127, 0.08341442, 0.08386953, 0.08432663, 0.08478571, \
0.08524678, 0.08570985, 0.08617492, 0.08664200, 0.08711109, \
0.08758219, 0.08805532, 0.08853047, 0.08900766, 0.08948689, \
0.08996816, 0.09045148, 0.09093685, 0.09142428, 0.09191378, \
0.09240534, 0.09289898, 0.09339470, 0.09389251, 0.09439240, \
0.09489439, 0.09539848, 0.09590468, 0.09641299, 0.09692341, \
0.09743595, 0.09795062, 0.09846742, 0.09898636, 0.09950744, \
0.10003066, 0.10055604, 0.10108357, 0.10161326, 0.10214512, \
0.10267915, 0.10321536, 0.10375375, 0.10429432, 0.10483709, \
0.10538205, 0.10592921, 0.10647858, 0.10703016, 0.10758395, \
0.10813996, 0.10869820, 0.10925867, 0.10982137, 0.11038632, \
0.11095350, 0.11152294, 0.11209463, 0.11266858, 0.11324479, \
0.11382327, 0.11440402, 0.11498704, 0.11557235, 0.11615995, \
0.11674984, 0.11734202, 0.11793650, 0.11853329, 0.11913239, \
0.11973380, 0.12033752, 0.12094357, 0.12155195, 0.12216266, \
0.12277570, 0.12339109, 0.12400882, 0.12462890, 0.12525133, \
0.12587612, 0.12650327, 0.12713279, 0.12776468, 0.12839894, \
0.12903558, 0.12967460, 0.13031601, 0.13095982, 0.13160602, \
0.13225461, 0.13290561, 0.13355902, 0.13421484, 0.13487308, \
0.13553373, 0.13619681, 0.13686232, 0.13753026, 0.13820063, \
0.13887344, 0.13954870, 0.14022640, 0.14090655, 0.14158916, \
0.14227422, 0.14296175, 0.14365174, 0.14434420, 0.14503913, \
0.14573654, 0.14643643, 0.14713880, 0.14784366, 0.14855101, \
0.14926085, 0.14997319, 0.15068803, 0.15140538, 0.15212523, \
0.15284759, 0.15357247, 0.15429986, 0.15502978, 0.15576221, \
0.15649718, 0.15723467, 0.15797470, 0.15871726, 0.15946236, \
0.16021001, 0.16096020, 0.16171293, 0.16246822, 0.16322606, \
0.16398646, 0.16474942, 0.16551494, 0.16628302, 0.16705367, \
0.16782689, 0.16860269, 0.16938106, 0.17016201, 0.17094554, \
0.17173165, 0.17252035, 0.17331164, 0.17410552, 0.17490199, \
0.17570105, 0.17650272, 0.17730698, 0.17811385, 0.17892332, \
0.17973539, 0.18055008, 0.18136737, 0.18218728, 0.18300980, \
0.18383494, 0.18466270, 0.18549308, 0.18632608, 0.18716170, \
0.18799995, 0.18884083, 0.18968434, 0.19053048, 0.19137925, \
0.19223065, 0.19308470, 0.19394137, 0.19480069, 0.19566265, \
0.19652725, 0.19739449, 0.19826437, 0.19913690, 0.20001208, \
0.20088991, 0.20177038, 0.20265350, 0.20353928, 0.20442770, \
0.20531878, 0.20621252, 0.20710890, 0.20800795, 0.20890965, \
0.20981400, 0.21072102, 0.21163069, 0.21254302, 0.21345801, \
0.21437566, 0.21529598, 0.21621895, 0.21714458, 0.21807288, \
0.21900383, 0.21993745, 0.22087373, 0.22181268, 0.22275428, \
0.22369855, 0.22464548, 0.22559508, 0.22654733, 0.22750225, \
0.22845983, 0.22942007, 0.23038298, 0.23134854, 0.23231676, \
0.23328765, 0.23426120, 0.23523740, 0.23621626, 0.23719778, \
0.23818196, 0.23916880, 0.24015829, 0.24115043, 0.24214523, \
0.24314269, 0.24414279, 0.24514555, 0.24615095, 0.24715901, \
0.24816971, 0.24918306, 0.25019905, 0.25121769, 0.25223897, \
0.25326289, 0.25428945, 0.25531865, 0.25635048, 0.25738495, \
0.25842205, 0.25946178, 0.26050414, 0.26154913, 0.26259674, \
0.26364698, 0.26469984, 0.26575531, 0.26681340, 0.26787411, \
0.26893743, 0.27000336, 0.27107190, 0.27214304, 0.27321678, \
0.27429313, 0.27537207, 0.27645360, 0.27753773, 0.27862445, \
0.27971375, 0.28080564, 0.28190011, 0.28299715, 0.28409677, \
0.28519896, 0.28630372, 0.28741104, 0.28852092, 0.28963337, \
0.29074836, 0.29186591, 0.29298600, 0.29410864, 0.29523382, \
0.29636154, 0.29749178, 0.29862456, 0.29975986, 0.30089768, \
0.30203802, 0.30318088, 0.30432624, 0.30547410, 0.30662447, \
0.30777733, 0.30893268, 0.31009052, 0.31125084, 0.31241364, \
0.31357891, 0.31474665, 0.31591686, 0.31708952, 0.31826464, \
0.31944221, 0.32062222, 0.32180467, 0.32298955, 0.32417686, \
0.32536660, 0.32655875, 0.32775332, 0.32895029, 0.33014967, \
0.33135144, 0.33255560, 0.33376215, 0.33497107, 0.33618237, \
0.33739603, 0.33861206, 0.33983044, 0.34105117, 0.34227425, \
0.34349966, 0.34472740, 0.34595746, 0.34718985, 0.34842454, \
0.34966154, 0.35090084, 0.35214243, 0.35338630, 0.35463245, \
0.35588087, 0.35713156, 0.35838450, 0.35963969, 0.36089713, \
0.36215680, 0.36341870, 0.36468282, 0.36594916, 0.36721770, \
0.36848844, 0.36976137, 0.37103649, 0.37231378, 0.37359324, \
0.37487486, 0.37615863, 0.37744455, 0.37873260, 0.38002278, \
0.38131508, 0.38260949, 0.38390601, 0.38520462, 0.38650532, \
0.38780809, 0.38911294, 0.39041985, 0.39172881, 0.39303981, \
0.39435285, 0.39566791, 0.39698499, 0.39830408, 0.39962516, \
0.40094824, 0.40227330, 0.40360032, 0.40492931, 0.40626025, \
0.40759314, 0.40892796, 0.41026470, 0.41160335, 0.41294391, \
0.41428637, 0.41563070, 0.41697692, 0.41832499, 0.41967492, \
0.42102670, 0.42238031, 0.42373574, 0.42509299, 0.42645204, \
0.42781288, 0.42917551, 0.43053990, 0.43190606, 0.43327396, \
0.43464361, 0.43601498, 0.43738807, 0.43876287, 0.44013936, \
0.44151754, 0.44289739, 0.44427890, 0.44566206, 0.44704686, \
0.44843329, 0.44982133, 0.45121098, 0.45260222, 0.45399505, \
0.45538944, 0.45678539, 0.45818288, 0.45958191, 0.46098246, \
0.46238451, 0.46378807, 0.46519311, 0.46659962, 0.46800760, \
0.46941702, 0.47082788, 0.47224016, 0.47365385, 0.47506893, \
0.47648541, 0.47790325, 0.47932245, 0.48074300, 0.48216489, \
0.48358809, 0.48501260, 0.48643841, 0.48786549, 0.48929384, \
0.49072345, 0.49215430, 0.49358637, 0.49501966, 0.49645415, \
0.49788982, 0.49932667, 0.50076468, 0.50220383, 0.50364411, \
0.50508551, 0.50652801, 0.50797160, 0.50941627, 0.51086200, \
0.51230877, 0.51375658, 0.51520540, 0.51665523, 0.51810604, \
0.51955783, 0.52101058, 0.52246427, 0.52391890, 0.52537444, \
0.52683088, 0.52828820, 0.52974640, 0.53120545, 0.53266534, \
0.53412606, 0.53558759, 0.53704991, 0.53851301, 0.53997688, \
0.54144149, 0.54290684, 0.54437291, 0.54583968, 0.54730714, \
0.54877526, 0.55024404, 0.55171347, 0.55318351, 0.55465416, \
0.55612541, 0.55759723, 0.55906961, 0.56054253, 0.56201598, \
0.56348995, 0.56496440, 0.56643934, 0.56791474, 0.56939058, \
0.57086686, 0.57234354, 0.57382062, 0.57529809, 0.57677591, \
0.57825408, 0.57973258, 0.58121139, 0.58269050, 0.58416989, \
0.58564954, 0.58712943, 0.58860956, 0.59008989, 0.59157041, \
0.59305112, 0.59453198, 0.59601298, 0.59749411, 0.59897534, \
0.60045667, 0.60193806, 0.60341951, 0.60490100, 0.60638251, \
0.60786402, 0.60934551, 0.61082697, 0.61230838, 0.61378972, \
0.61527097, 0.61675211, 0.61823314, 0.61971402, 0.62119474, \
0.62267529, 0.62415564, 0.62563578, 0.62711569, 0.62859534, \
0.63007473, 0.63155383, 0.63303263, 0.63451111, 0.63598924, \
0.63746701, 0.63894441, 0.64042140, 0.64189799, 0.64337413, \
0.64484983, 0.64632505, 0.64779979, 0.64927401, 0.65074771, \
0.65222086, 0.65369345, 0.65516545, 0.65663685, 0.65810762, \
0.65957776, 0.66104724, 0.66251603, 0.66398413, 0.66545151, \
0.66691816, 0.66838405, 0.66984917, 0.67131349, 0.67277700, \
0.67423968, 0.67570150, 0.67716246, 0.67862252, 0.68008168, \
0.68153990, 0.68299718, 0.68445349, 0.68590882, 0.68736313, \
0.68881642, 0.69026867, 0.69171985, 0.69316995, 0.69461894, \
0.69606680, 0.69751353, 0.69895909, 0.70040346, 0.70184664, \
0.70328859, 0.70472930, 0.70616875, 0.70760691, 0.70904378, \
0.71047932, 0.71191352, 0.71334636, 0.71477782, 0.71620788, \
0.71763652, 0.71906372, 0.72048946, 0.72191372, 0.72333648, \
0.72475772, 0.72617742, 0.72759555, 0.72901211, 0.73042707, \
0.73184041, 0.73325211, 0.73466214, 0.73607050, 0.73747716, \
0.73888210, 0.74028529, 0.74168673, 0.74308639, 0.74448424, \
0.74588028, 0.74727447, 0.74866680, 0.75005726, 0.75144581, \
0.75283244, 0.75421713, 0.75559986, 0.75698061, 0.75835935, \
0.75973608, 0.76111076, 0.76248338, 0.76385392, 0.76522235, \
0.76658867, 0.76795284, 0.76931485, 0.77067468, 0.77203230, \
0.77338770, 0.77474086, 0.77609176, 0.77744037, 0.77878668, \
0.78013067, 0.78147231, 0.78281159, 0.78414849, 0.78548299, \
0.78681506, 0.78814468, 0.78947185, 0.79079653, 0.79211871, \
0.79343836, 0.79475547, 0.79607002, 0.79738199, 0.79869135, \
0.79999809, 0.80130219, 0.80260362, 0.80390237, 0.80519842, \
0.80649174, 0.80778233, 0.80907015, 0.81035519, 0.81163743, \
0.81291685, 0.81419343, 0.81546714, 0.81673798, 0.81800591, \
0.81927093, 0.82053301, 0.82179212, 0.82304826, 0.82430141, \
0.82555153, 0.82679862, 0.82804265, 0.82928360, 0.83052146, \
0.83175621, 0.83298782, 0.83421628, 0.83544156, 0.83666365, \
0.83788253, 0.83909818, 0.84031058, 0.84151971, 0.84272556, \
0.84392809, 0.84512730, 0.84632317, 0.84751567, 0.84870478, \
0.84989050, 0.85107279, 0.85225164, 0.85342704, 0.85459895, \
0.85576737, 0.85693228, 0.85809365, 0.85925147, 0.86040571, \
0.86155637, 0.86270342, 0.86384684, 0.86498662, 0.86612273, \
0.86725516, 0.86838389, 0.86950890, 0.87063018, 0.87174770, \
0.87286144, 0.87397140, 0.87507754, 0.87617986, 0.87727833, \
0.87837294, 0.87946367, 0.88055050, 0.88163341, 0.88271238, \
0.88378741, 0.88485846, 0.88592553, 0.88698859, 0.88804762, \
0.88910262, 0.89015356, 0.89120043, 0.89224320, 0.89328186, \
0.89431640, 0.89534679, 0.89637302, 0.89739508, 0.89841294, \
0.89942659, 0.90043601, 0.90144118, 0.90244209, 0.90343872, \
0.90443106, 0.90541909, 0.90640278, 0.90738213, 0.90835712, \
0.90932774, 0.91029395, 0.91125576, 0.91221315, 0.91316609, \
0.91411457, 0.91505857, 0.91599809, 0.91693310, 0.91786359, \
0.91878954, 0.91971094, 0.92062777, 0.92154001, 0.92244766, \
0.92335069, 0.92424909, 0.92514284, 0.92603194, 0.92691636, \
0.92779608, 0.92867110, 0.92954141, 0.93040697, 0.93126779, \
0.93212384, 0.93297511, 0.93382158, 0.93466325, 0.93550010, \
0.93633210, 0.93715926, 0.93798155, 0.93879896, 0.93961148, \
0.94041909, 0.94122178, 0.94201953, 0.94281234, 0.94360018, \
0.94438304, 0.94516092, 0.94593379, 0.94670165, 0.94746448, \
0.94822226, 0.94897499, 0.94972265, 0.95046523, 0.95120271, \
0.95193509, 0.95266234, 0.95338447, 0.95410145, 0.95481327, \
0.95551992, 0.95622139, 0.95691766, 0.95760873, 0.95829458, \
0.95897520, 0.95965058, 0.96032070, 0.96098556, 0.96164514, \
0.96229943, 0.96294842, 0.96359211, 0.96423046, 0.96486349, \
0.96549117, 0.96611349, 0.96673045, 0.96734203, 0.96794822, \
0.96854901, 0.96914439, 0.96973436, 0.97031889, 0.97089798, \
0.97147163, 0.97203981, 0.97260252, 0.97315975, 0.97371149, \
0.97425773, 0.97479846, 0.97533368, 0.97586336, 0.97638751, \
0.97690611, 0.97741915, 0.97792663, 0.97842853, 0.97892485, \
0.97941558, 0.97990071, 0.98038023, 0.98085413, 0.98132241, \
0.98178505, 0.98224205, 0.98269340, 0.98313909, 0.98357912, \
0.98401347, 0.98444214, 0.98486512, 0.98528240, 0.98569398, \
0.98609985, 0.98650000, 0.98689442, 0.98728311, 0.98766607, \
0.98804327, 0.98841472, 0.98878042, 0.98914034, 0.98949449, \
0.98984287, 0.99018546, 0.99052226, 0.99085326, 0.99117845, \
0.99149784, 0.99181142, 0.99211917, 0.99242110, 0.99271720, \
0.99300746, 0.99329188, 0.99357045, 0.99384318, 0.99411004, \
0.99437105, 0.99462619, 0.99487545, 0.99511885, 0.99535636, \
0.99558800, 0.99581374, 0.99603359, 0.99624755, 0.99645561, \
0.99665776, 0.99685401, 0.99704435, 0.99722878, 0.99740729, \
0.99757987, 0.99774654, 0.99790728, 0.99806209, 0.99821097, \
0.99835391, 0.99849092, 0.99862199, 0.99874712, 0.99886630, \
0.99897954, 0.99908683, 0.99918817, 0.99928356, 0.99937299, \
0.99945647, 0.99953399, 0.99960556, 0.99967116, 0.99973081, \
0.99978449, 0.99983221, 0.99987397, 0.99990976, 0.99993959, \
0.99996346, 0.99998136, 0.99999329, 0.99999925, } 

#define GAUSS4096 {\
0.04393693, 0.04407122, 0.04420586, 0.04434084, 0.04447616, \
0.04461183, 0.04474785, 0.04488422, 0.04502093, 0.04515800, \
0.04529541, 0.04543318, 0.04557129, 0.04570976, 0.04584858, \
0.04598775, 0.04612728, 0.04626716, 0.04640739, 0.04654799, \
0.04668893, 0.04683024, 0.04697190, 0.04711392, 0.04725630, \
0.04739904, 0.04754214, 0.04768560, 0.04782942, 0.04797361, \
0.04811815, 0.04826306, 0.04840834, 0.04855398, 0.04869998, \
0.04884635, 0.04899309, 0.04914020, 0.04928767, 0.04943552, \
0.04958373, 0.04973231, 0.04988127, 0.05003059, 0.05018029, \
0.05033036, 0.05048080, 0.05063162, 0.05078281, 0.05093438, \
0.05108633, 0.05123865, 0.05139135, 0.05154442, 0.05169788, \
0.05185172, 0.05200593, 0.05216053, 0.05231551, 0.05247087, \
0.05262661, 0.05278274, 0.05293925, 0.05309615, 0.05325343, \
0.05341110, 0.05356915, 0.05372760, 0.05388643, 0.05404565, \
0.05420526, 0.05436526, 0.05452565, 0.05468643, 0.05484761, \
0.05500918, 0.05517114, 0.05533349, 0.05549625, 0.05565939, \
0.05582294, 0.05598688, 0.05615121, 0.05631595, 0.05648109, \
0.05664662, 0.05681256, 0.05697890, 0.05714563, 0.05731278, \
0.05748032, 0.05764827, 0.05781662, 0.05798538, 0.05815454, \
0.05832411, 0.05849409, 0.05866448, 0.05883527, 0.05900648, \
0.05917809, 0.05935011, 0.05952255, 0.05969540, 0.05986866, \
0.06004233, 0.06021642, 0.06039092, 0.06056584, 0.06074117, \
0.06091692, 0.06109309, 0.06126968, 0.06144668, 0.06162411, \
0.06180195, 0.06198022, 0.06215890, 0.06233801, 0.06251754, \
0.06269750, 0.06287788, 0.06305868, 0.06323991, 0.06342157, \
0.06360366, 0.06378617, 0.06396911, 0.06415248, 0.06433627, \
0.06452050, 0.06470516, 0.06489025, 0.06507578, 0.06526174, \
0.06544813, 0.06563495, 0.06582221, 0.06600991, 0.06619804, \
0.06638661, 0.06657562, 0.06676507, 0.06695496, 0.06714528, \
0.06733605, 0.06752726, 0.06771891, 0.06791100, 0.06810353, \
0.06829652, 0.06848994, 0.06868381, 0.06887813, 0.06907289, \
0.06926810, 0.06946376, 0.06965987, 0.06985642, 0.07005343, \
0.07025089, 0.07044880, 0.07064716, 0.07084598, 0.07104524, \
0.07124497, 0.07144514, 0.07164578, 0.07184687, 0.07204841, \
0.07225042, 0.07245288, 0.07265580, 0.07285918, 0.07306302, \
0.07326733, 0.07347209, 0.07367732, 0.07388301, 0.07408916, \
0.07429578, 0.07450286, 0.07471041, 0.07491843, 0.07512691, \
0.07533586, 0.07554528, 0.07575517, 0.07596553, 0.07617636, \
0.07638766, 0.07659943, 0.07681167, 0.07702439, 0.07723758, \
0.07745125, 0.07766539, 0.07788001, 0.07809510, 0.07831068, \
0.07852672, 0.07874325, 0.07896026, 0.07917775, 0.07939572, \
0.07961417, 0.07983310, 0.08005251, 0.08027241, 0.08049279, \
0.08071366, 0.08093501, 0.08115685, 0.08137917, 0.08160198, \
0.08182529, 0.08204907, 0.08227335, 0.08249812, 0.08272338, \
0.08294913, 0.08317537, 0.08340211, 0.08362934, 0.08385706, \
0.08408528, 0.08431399, 0.08454320, 0.08477290, 0.08500311, \
0.08523381, 0.08546501, 0.08569671, 0.08592891, 0.08616161, \
0.08639481, 0.08662851, 0.08686272, 0.08709743, 0.08733264, \
0.08756836, 0.08780458, 0.08804131, 0.08827854, 0.08851629, \
0.08875454, 0.08899330, 0.08923257, 0.08947235, 0.08971264, \
0.08995344, 0.09019475, 0.09043657, 0.09067891, 0.09092176, \
0.09116513, 0.09140901, 0.09165341, 0.09189832, 0.09214376, \
0.09238970, 0.09263617, 0.09288316, 0.09313066, 0.09337869, \
0.09362724, 0.09387631, 0.09412590, 0.09437601, 0.09462665, \
0.09487781, 0.09512950, 0.09538171, 0.09563444, 0.09588771, \
0.09614150, 0.09639582, 0.09665067, 0.09690605, 0.09716196, \
0.09741839, 0.09767536, 0.09793287, 0.09819090, 0.09844947, \
0.09870857, 0.09896820, 0.09922837, 0.09948908, 0.09975032, \
0.10001210, 0.10027442, 0.10053727, 0.10080066, 0.10106460, \
0.10132907, 0.10159408, 0.10185964, 0.10212573, 0.10239237, \
0.10265955, 0.10292728, 0.10319555, 0.10346437, 0.10373373, \
0.10400363, 0.10427409, 0.10454509, 0.10481664, 0.10508873, \
0.10536138, 0.10563458, 0.10590833, 0.10618262, 0.10645748, \
0.10673288, 0.10700883, 0.10728534, 0.10756241, 0.10784002, \
0.10811820, 0.10839693, 0.10867621, 0.10895605, 0.10923646, \
0.10951741, 0.10979893, 0.11008101, 0.11036365, 0.11064685, \
0.11093061, 0.11121493, 0.11149981, 0.11178526, 0.11207127, \
0.11235784, 0.11264498, 0.11293269, 0.11322096, 0.11350980, \
0.11379920, 0.11408918, 0.11437972, 0.11467083, 0.11496251, \
0.11525476, 0.11554758, 0.11584097, 0.11613494, 0.11642947, \
0.11672458, 0.11702026, 0.11731652, 0.11761335, 0.11791076, \
0.11820874, 0.11850730, 0.11880644, 0.11910615, 0.11940644, \
0.11970731, 0.12000876, 0.12031079, 0.12061340, 0.12091659, \
0.12122036, 0.12152471, 0.12182965, 0.12213517, 0.12244127, \
0.12274796, 0.12305523, 0.12336309, 0.12367153, 0.12398056, \
0.12429018, 0.12460038, 0.12491117, 0.12522255, 0.12553452, \
0.12584708, 0.12616023, 0.12647397, 0.12678830, 0.12710322, \
0.12741873, 0.12773484, 0.12805154, 0.12836884, 0.12868673, \
0.12900521, 0.12932429, 0.12964396, 0.12996424, 0.13028510, \
0.13060657, 0.13092863, 0.13125130, 0.13157456, 0.13189842, \
0.13222288, 0.13254794, 0.13287360, 0.13319987, 0.13352673, \
0.13385420, 0.13418228, 0.13451095, 0.13484023, 0.13517011, \
0.13550060, 0.13583170, 0.13616340, 0.13649571, 0.13682862, \
0.13716214, 0.13749627, 0.13783101, 0.13816636, 0.13850231, \
0.13883888, 0.13917606, 0.13951384, 0.13985224, 0.14019125, \
0.14053088, 0.14087111, 0.14121196, 0.14155342, 0.14189550, \
0.14223819, 0.14258150, 0.14292542, 0.14326996, 0.14361511, \
0.14396088, 0.14430727, 0.14465428, 0.14500190, 0.14535015, \
0.14569901, 0.14604849, 0.14639860, 0.14674932, 0.14710066, \
0.14745263, 0.14780521, 0.14815842, 0.14851225, 0.14886671, \
0.14922179, 0.14957749, 0.14993382, 0.15029077, 0.15064834, \
0.15100654, 0.15136537, 0.15172483, 0.15208491, 0.15244562, \
0.15280695, 0.15316892, 0.15353151, 0.15389473, 0.15425859, \
0.15462307, 0.15498818, 0.15535392, 0.15572029, 0.15608730, \
0.15645493, 0.15682320, 0.15719210, 0.15756163, 0.15793180, \
0.15830260, 0.15867403, 0.15904610, 0.15941881, 0.15979214, \
0.16016612, 0.16054073, 0.16091597, 0.16129186, 0.16166838, \
0.16204553, 0.16242333, 0.16280176, 0.16318083, 0.16356054, \
0.16394089, 0.16432188, 0.16470351, 0.16508578, 0.16546869, \
0.16585224, 0.16623643, 0.16662126, 0.16700674, 0.16739286, \
0.16777962, 0.16816702, 0.16855506, 0.16894375, 0.16933309, \
0.16972306, 0.17011369, 0.17050495, 0.17089687, 0.17128942, \
0.17168263, 0.17207648, 0.17247097, 0.17286611, 0.17326190, \
0.17365834, 0.17405542, 0.17445316, 0.17485154, 0.17525057, \
0.17565024, 0.17605057, 0.17645155, 0.17685317, 0.17725545, \
0.17765837, 0.17806195, 0.17846617, 0.17887105, 0.17927658, \
0.17968276, 0.18008959, 0.18049708, 0.18090521, 0.18131400, \
0.18172345, 0.18213354, 0.18254429, 0.18295569, 0.18336775, \
0.18378046, 0.18419382, 0.18460784, 0.18502251, 0.18543784, \
0.18585382, 0.18627046, 0.18668776, 0.18710571, 0.18752432, \
0.18794358, 0.18836350, 0.18878408, 0.18920531, 0.18962720, \
0.19004975, 0.19047295, 0.19089682, 0.19132134, 0.19174652, \
0.19217236, 0.19259885, 0.19302601, 0.19345382, 0.19388229, \
0.19431143, 0.19474122, 0.19517167, 0.19560278, 0.19603456, \
0.19646699, 0.19690008, 0.19733383, 0.19776825, 0.19820332, \
0.19863906, 0.19907545, 0.19951251, 0.19995023, 0.20038861, \
0.20082765, 0.20126736, 0.20170772, 0.20214875, 0.20259044, \
0.20303280, 0.20347581, 0.20391949, 0.20436383, 0.20480884, \
0.20525450, 0.20570083, 0.20614783, 0.20659548, 0.20704380, \
0.20749279, 0.20794243, 0.20839274, 0.20884372, 0.20929536, \
0.20974766, 0.21020063, 0.21065426, 0.21110855, 0.21156351, \
0.21201914, 0.21247543, 0.21293238, 0.21339000, 0.21384828, \
0.21430723, 0.21476684, 0.21522711, 0.21568806, 0.21614966, \
0.21661193, 0.21707487, 0.21753847, 0.21800274, 0.21846767, \
0.21893327, 0.21939953, 0.21986645, 0.22033405, 0.22080230, \
0.22127123, 0.22174082, 0.22221107, 0.22268199, 0.22315357, \
0.22362582, 0.22409874, 0.22457232, 0.22504656, 0.22552147, \
0.22599705, 0.22647329, 0.22695019, 0.22742777, 0.22790600, \
0.22838490, 0.22886447, 0.22934470, 0.22982560, 0.23030716, \
0.23078939, 0.23127228, 0.23175584, 0.23224006, 0.23272495, \
0.23321050, 0.23369671, 0.23418359, 0.23467114, 0.23515935, \
0.23564822, 0.23613776, 0.23662796, 0.23711883, 0.23761036, \
0.23810255, 0.23859541, 0.23908893, 0.23958312, 0.24007797, \
0.24057348, 0.24106965, 0.24156649, 0.24206400, 0.24256216, \
0.24306099, 0.24356048, 0.24406063, 0.24456145, 0.24506293, \
0.24556507, 0.24606787, 0.24657133, 0.24707546, 0.24758024, \
0.24808569, 0.24859180, 0.24909858, 0.24960601, 0.25011410, \
0.25062285, 0.25113227, 0.25164234, 0.25215308, 0.25266447, \
0.25317653, 0.25368924, 0.25420261, 0.25471664, 0.25523134, \
0.25574669, 0.25626269, 0.25677936, 0.25729668, 0.25781467, \
0.25833331, 0.25885261, 0.25937256, 0.25989317, 0.26041444, \
0.26093637, 0.26145895, 0.26198218, 0.26250608, 0.26303063, \
0.26355583, 0.26408169, 0.26460820, 0.26513537, 0.26566319, \
0.26619167, 0.26672080, 0.26725058, 0.26778102, 0.26831211, \
0.26884385, 0.26937624, 0.26990929, 0.27044298, 0.27097733, \
0.27151233, 0.27204798, 0.27258428, 0.27312123, 0.27365883, \
0.27419708, 0.27473598, 0.27527553, 0.27581573, 0.27635657, \
0.27689806, 0.27744020, 0.27798299, 0.27852642, 0.27907050, \
0.27961522, 0.28016059, 0.28070661, 0.28125327, 0.28180058, \
0.28234853, 0.28289712, 0.28344635, 0.28399623, 0.28454676, \
0.28509792, 0.28564973, 0.28620217, 0.28675526, 0.28730899, \
0.28786336, 0.28841837, 0.28897401, 0.28953030, 0.29008722, \
0.29064479, 0.29120299, 0.29176182, 0.29232130, 0.29288141, \
0.29344215, 0.29400354, 0.29456555, 0.29512820, 0.29569149, \
0.29625540, 0.29681995, 0.29738514, 0.29795095, 0.29851740, \
0.29908448, 0.29965218, 0.30022052, 0.30078949, 0.30135909, \
0.30192931, 0.30250016, 0.30307164, 0.30364375, 0.30421649, \
0.30478985, 0.30536383, 0.30593844, 0.30651368, 0.30708953, \
0.30766601, 0.30824312, 0.30882084, 0.30939919, 0.30997816, \
0.31055775, 0.31113796, 0.31171879, 0.31230023, 0.31288230, \
0.31346498, 0.31404828, 0.31463219, 0.31521673, 0.31580187, \
0.31638763, 0.31697401, 0.31756100, 0.31814860, 0.31873681, \
0.31932564, 0.31991507, 0.32050512, 0.32109577, 0.32168704, \
0.32227891, 0.32287139, 0.32346448, 0.32405817, 0.32465247, \
0.32524737, 0.32584288, 0.32643899, 0.32703571, 0.32763302, \
0.32823094, 0.32882946, 0.32942858, 0.33002830, 0.33062862, \
0.33122954, 0.33183105, 0.33243316, 0.33303587, 0.33363917, \
0.33424307, 0.33484756, 0.33545264, 0.33605832, 0.33666459, \
0.33727145, 0.33787890, 0.33848693, 0.33909556, 0.33970478, \
0.34031458, 0.34092497, 0.34153594, 0.34214750, 0.34275964, \
0.34337237, 0.34398568, 0.34459957, 0.34521404, 0.34582909, \
0.34644472, 0.34706093, 0.34767772, 0.34829508, 0.34891302, \
0.34953154, 0.35015063, 0.35077029, 0.35139053, 0.35201134, \
0.35263272, 0.35325467, 0.35387718, 0.35450027, 0.35512393, \
0.35574815, 0.35637294, 0.35699829, 0.35762420, 0.35825068, \
0.35887773, 0.35950533, 0.36013350, 0.36076222, 0.36139150, \
0.36202135, 0.36265174, 0.36328270, 0.36391421, 0.36454627, \
0.36517889, 0.36581206, 0.36644578, 0.36708005, 0.36771487, \
0.36835024, 0.36898616, 0.36962263, 0.37025964, 0.37089719, \
0.37153529, 0.37217394, 0.37281312, 0.37345285, 0.37409311, \
0.37473391, 0.37537526, 0.37601714, 0.37665955, 0.37730250, \
0.37794599, 0.37859001, 0.37923455, 0.37987964, 0.38052525, \
0.38117139, 0.38181805, 0.38246525, 0.38311297, 0.38376121, \
0.38440998, 0.38505927, 0.38570909, 0.38635942, 0.38701027, \
0.38766165, 0.38831354, 0.38896594, 0.38961886, 0.39027230, \
0.39092625, 0.39158071, 0.39223568, 0.39289116, 0.39354715, \
0.39420364, 0.39486065, 0.39551816, 0.39617617, 0.39683469, \
0.39749370, 0.39815322, 0.39881324, 0.39947376, 0.40013477, \
0.40079628, 0.40145829, 0.40212079, 0.40278378, 0.40344727, \
0.40411124, 0.40477571, 0.40544066, 0.40610610, 0.40677202, \
0.40743843, 0.40810532, 0.40877270, 0.40944055, 0.41010889, \
0.41077770, 0.41144700, 0.41211676, 0.41278701, 0.41345772, \
0.41412891, 0.41480057, 0.41547270, 0.41614530, 0.41681836, \
0.41749190, 0.41816589, 0.41884035, 0.41951528, 0.42019066, \
0.42086650, 0.42154281, 0.42221957, 0.42289678, 0.42357445, \
0.42425258, 0.42493115, 0.42561018, 0.42628966, 0.42696958, \
0.42764995, 0.42833077, 0.42901203, 0.42969373, 0.43037588, \
0.43105847, 0.43174149, 0.43242495, 0.43310885, 0.43379319, \
0.43447796, 0.43516316, 0.43584879, 0.43653485, 0.43722133, \
0.43790825, 0.43859559, 0.43928335, 0.43997154, 0.44066015, \
0.44134917, 0.44203862, 0.44272848, 0.44341876, 0.44410945, \
0.44480056, 0.44549208, 0.44618400, 0.44687634, 0.44756908, \
0.44826223, 0.44895578, 0.44964973, 0.45034409, 0.45103884, \
0.45173400, 0.45242955, 0.45312549, 0.45382184, 0.45451857, \
0.45521569, 0.45591320, 0.45661111, 0.45730939, 0.45800807, \
0.45870712, 0.45940656, 0.46010638, 0.46080658, 0.46150715, \
0.46220810, 0.46290943, 0.46361113, 0.46431320, 0.46501564, \
0.46571845, 0.46642163, 0.46712517, 0.46782907, 0.46853334, \
0.46923797, 0.46994295, 0.47064830, 0.47135400, 0.47206005, \
0.47276646, 0.47347322, 0.47418032, 0.47488778, 0.47559558, \
0.47630373, 0.47701222, 0.47772105, 0.47843023, 0.47913974, \
0.47984958, 0.48055977, 0.48127028, 0.48198113, 0.48269231, \
0.48340382, 0.48411565, 0.48482781, 0.48554030, 0.48625310, \
0.48696623, 0.48767967, 0.48839343, 0.48910751, 0.48982190, \
0.49053661, 0.49125162, 0.49196694, 0.49268257, 0.49339851, \
0.49411475, 0.49483129, 0.49554813, 0.49626527, 0.49698271, \
0.49770044, 0.49841846, 0.49913678, 0.49985539, 0.50057428, \
0.50129346, 0.50201293, 0.50273268, 0.50345271, 0.50417302, \
0.50489361, 0.50561448, 0.50633562, 0.50705703, 0.50777871, \
0.50850066, 0.50922288, 0.50994537, 0.51066811, 0.51139112, \
0.51211439, 0.51283792, 0.51356171, 0.51428575, 0.51501004, \
0.51573459, 0.51645938, 0.51718442, 0.51790971, 0.51863524, \
0.51936101, 0.52008702, 0.52081328, 0.52153976, 0.52226649, \
0.52299344, 0.52372063, 0.52444805, 0.52517569, 0.52590356, \
0.52663165, 0.52735997, 0.52808850, 0.52881725, 0.52954622, \
0.53027541, 0.53100480, 0.53173441, 0.53246422, 0.53319424, \
0.53392447, 0.53465490, 0.53538553, 0.53611636, 0.53684739, \
0.53757861, 0.53831003, 0.53904163, 0.53977343, 0.54050541, \
0.54123758, 0.54196994, 0.54270247, 0.54343519, 0.54416808, \
0.54490115, 0.54563440, 0.54636781, 0.54710140, 0.54783515, \
0.54856908, 0.54930316, 0.55003741, 0.55077182, 0.55150638, \
0.55224110, 0.55297598, 0.55371101, 0.55444619, 0.55518152, \
0.55591699, 0.55665261, 0.55738837, 0.55812427, 0.55886032, \
0.55959649, 0.56033280, 0.56106925, 0.56180582, 0.56254252, \
0.56327935, 0.56401630, 0.56475338, 0.56549057, 0.56622789, \
0.56696532, 0.56770286, 0.56844051, 0.56917828, 0.56991615, \
0.57065413, 0.57139221, 0.57213040, 0.57286868, 0.57360706, \
0.57434554, 0.57508411, 0.57582277, 0.57656152, 0.57730036, \
0.57803928, 0.57877829, 0.57951738, 0.58025654, 0.58099578, \
0.58173510, 0.58247449, 0.58321395, 0.58395347, 0.58469307, \
0.58543273, 0.58617244, 0.58691222, 0.58765206, 0.58839195, \
0.58913190, 0.58987189, 0.59061194, 0.59135203, 0.59209217, \
0.59283235, 0.59357256, 0.59431282, 0.59505312, 0.59579344, \
0.59653380, 0.59727419, 0.59801461, 0.59875505, 0.59949551, \
0.60023600, 0.60097650, 0.60171703, 0.60245756, 0.60319811, \
0.60393866, 0.60467923, 0.60541980, 0.60616037, 0.60690095, \
0.60764152, 0.60838209, 0.60912266, 0.60986321, 0.61060376, \
0.61134429, 0.61208481, 0.61282532, 0.61356580, 0.61430627, \
0.61504671, 0.61578712, 0.61652751, 0.61726787, 0.61800819, \
0.61874848, 0.61948873, 0.62022895, 0.62096912, 0.62170925, \
0.62244933, 0.62318937, 0.62392935, 0.62466929, 0.62540916, \
0.62614899, 0.62688875, 0.62762845, 0.62836808, 0.62910765, \
0.62984715, 0.63058658, 0.63132594, 0.63206522, 0.63280442, \
0.63354355, 0.63428259, 0.63502154, 0.63576041, 0.63649919, \
0.63723788, 0.63797648, 0.63871498, 0.63945338, 0.64019168, \
0.64092987, 0.64166796, 0.64240595, 0.64314382, 0.64388158, \
0.64461923, 0.64535676, 0.64609417, 0.64683145, 0.64756862, \
0.64830565, 0.64904256, 0.64977934, 0.65051599, 0.65125249, \
0.65198886, 0.65272509, 0.65346118, 0.65419712, 0.65493292, \
0.65566856, 0.65640405, 0.65713939, 0.65787457, 0.65860959, \
0.65934445, 0.66007914, 0.66081367, 0.66154803, 0.66228222, \
0.66301623, 0.66375007, 0.66448373, 0.66521721, 0.66595051, \
0.66668362, 0.66741654, 0.66814927, 0.66888181, 0.66961416, \
0.67034630, 0.67107825, 0.67181000, 0.67254154, 0.67327287, \
0.67400399, 0.67473490, 0.67546560, 0.67619608, 0.67692634, \
0.67765638, 0.67838619, 0.67911578, 0.67984514, 0.68057427, \
0.68130316, 0.68203182, 0.68276024, 0.68348842, 0.68421635, \
0.68494404, 0.68567148, 0.68639867, 0.68712561, 0.68785229, \
0.68857872, 0.68930488, 0.69003078, 0.69075641, 0.69148178, \
0.69220688, 0.69293170, 0.69365625, 0.69438052, 0.69510451, \
0.69582822, 0.69655165, 0.69727478, 0.69799763, 0.69872018, \
0.69944244, 0.70016440, 0.70088606, 0.70160743, 0.70232848, \
0.70304923, 0.70376967, 0.70448979, 0.70520961, 0.70592910, \
0.70664828, 0.70736713, 0.70808566, 0.70880386, 0.70952174, \
0.71023928, 0.71095649, 0.71167336, 0.71238989, 0.71310608, \
0.71382192, 0.71453742, 0.71525257, 0.71596737, 0.71668181, \
0.71739590, 0.71810963, 0.71882300, 0.71953600, 0.72024863, \
0.72096090, 0.72167280, 0.72238432, 0.72309546, 0.72380623, \
0.72451661, 0.72522661, 0.72593623, 0.72664545, 0.72735429, \
0.72806273, 0.72877077, 0.72947841, 0.73018566, 0.73089250, \
0.73159893, 0.73230495, 0.73301056, 0.73371576, 0.73442054, \
0.73512490, 0.73582884, 0.73653236, 0.73723545, 0.73793811, \
0.73864034, 0.73934214, 0.74004350, 0.74074442, 0.74144490, \
0.74214493, 0.74284452, 0.74354366, 0.74424235, 0.74494058, \
0.74563836, 0.74633568, 0.74703254, 0.74772893, 0.74842485, \
0.74912031, 0.74981530, 0.75050981, 0.75120384, 0.75189740, \
0.75259047, 0.75328306, 0.75397516, 0.75466678, 0.75535790, \
0.75604852, 0.75673866, 0.75742829, 0.75811742, 0.75880604, \
0.75949416, 0.76018177, 0.76086887, 0.76155545, 0.76224152, \
0.76292707, 0.76361209, 0.76429659, 0.76498057, 0.76566401, \
0.76634692, 0.76702930, 0.76771114, 0.76839244, 0.76907320, \
0.76975342, 0.77043309, 0.77111221, 0.77179078, 0.77246879, \
0.77314624, 0.77382314, 0.77449947, 0.77517524, 0.77585045, \
0.77652508, 0.77719914, 0.77787263, 0.77854553, 0.77921786, \
0.77988961, 0.78056077, 0.78123135, 0.78190134, 0.78257073, \
0.78323953, 0.78390773, 0.78457534, 0.78524234, 0.78590873, \
0.78657452, 0.78723970, 0.78790427, 0.78856822, 0.78923156, \
0.78989427, 0.79055636, 0.79121783, 0.79187868, 0.79253889, \
0.79319847, 0.79385741, 0.79451572, 0.79517339, 0.79583042, \
0.79648680, 0.79714254, 0.79779762, 0.79845206, 0.79910583, \
0.79975896, 0.80041142, 0.80106322, 0.80171436, 0.80236483, \
0.80301463, 0.80366375, 0.80431221, 0.80495998, 0.80560708, \
0.80625350, 0.80689923, 0.80754427, 0.80818863, 0.80883229, \
0.80947526, 0.81011754, 0.81075911, 0.81139998, 0.81204015, \
0.81267961, 0.81331837, 0.81395641, 0.81459373, 0.81523034, \
0.81586624, 0.81650141, 0.81713586, 0.81776958, 0.81840257, \
0.81903483, 0.81966636, 0.82029715, 0.82092720, 0.82155652, \
0.82218509, 0.82281291, 0.82343998, 0.82406631, 0.82469188, \
0.82531670, 0.82594075, 0.82656405, 0.82718659, 0.82780836, \
0.82842936, 0.82904959, 0.82966905, 0.83028773, 0.83090564, \
0.83152277, 0.83213911, 0.83275467, 0.83336944, 0.83398343, \
0.83459662, 0.83520902, 0.83582062, 0.83643142, 0.83704142, \
0.83765061, 0.83825900, 0.83886658, 0.83947335, 0.84007931, \
0.84068445, 0.84128877, 0.84189227, 0.84249495, 0.84309680, \
0.84369783, 0.84429802, 0.84489738, 0.84549591, 0.84609360, \
0.84669045, 0.84728646, 0.84788162, 0.84847594, 0.84906940, \
0.84966202, 0.85025378, 0.85084468, 0.85143473, 0.85202391, \
0.85261224, 0.85319969, 0.85378628, 0.85437200, 0.85495684, \
0.85554081, 0.85612390, 0.85670612, 0.85728745, 0.85786789, \
0.85844745, 0.85902612, 0.85960390, 0.86018078, 0.86075677, \
0.86133186, 0.86190605, 0.86247934, 0.86305172, 0.86362319, \
0.86419375, 0.86476340, 0.86533214, 0.86589996, 0.86646686, \
0.86703284, 0.86759789, 0.86816202, 0.86872522, 0.86928749, \
0.86984883, 0.87040923, 0.87096870, 0.87152722, 0.87208480, \
0.87264144, 0.87319713, 0.87375188, 0.87430567, 0.87485851, \
0.87541039, 0.87596132, 0.87651128, 0.87706029, 0.87760832, \
0.87815540, 0.87870150, 0.87924663, 0.87979079, 0.88033397, \
0.88087618, 0.88141740, 0.88195764, 0.88249690, 0.88303517, \
0.88357246, 0.88410875, 0.88464404, 0.88517835, 0.88571165, \
0.88624396, 0.88677526, 0.88730556, 0.88783485, 0.88836313, \
0.88889040, 0.88941666, 0.88994190, 0.89046613, 0.89098934, \
0.89151152, 0.89203268, 0.89255282, 0.89307193, 0.89359000, \
0.89410705, 0.89462306, 0.89513803, 0.89565196, 0.89616486, \
0.89667671, 0.89718751, 0.89769727, 0.89820598, 0.89871364, \
0.89922024, 0.89972579, 0.90023028, 0.90073370, 0.90123607, \
0.90173737, 0.90223761, 0.90273678, 0.90323488, 0.90373190, \
0.90422785, 0.90472273, 0.90521652, 0.90570924, 0.90620087, \
0.90669142, 0.90718088, 0.90766925, 0.90815653, 0.90864272, \
0.90912781, 0.90961181, 0.91009470, 0.91057650, 0.91105719, \
0.91153677, 0.91201525, 0.91249262, 0.91296888, 0.91344403, \
0.91391806, 0.91439097, 0.91486276, 0.91533344, 0.91580299, \
0.91627141, 0.91673871, 0.91720488, 0.91766991, 0.91813382, \
0.91859659, 0.91905822, 0.91951871, 0.91997806, 0.92043627, \
0.92089334, 0.92134926, 0.92180403, 0.92225765, 0.92271011, \
0.92316143, 0.92361158, 0.92406058, 0.92450842, 0.92495510, \
0.92540061, 0.92584495, 0.92628813, 0.92673014, 0.92717098, \
0.92761065, 0.92804914, 0.92848645, 0.92892258, 0.92935754, \
0.92979131, 0.93022390, 0.93065530, 0.93108551, 0.93151453, \
0.93194236, 0.93236900, 0.93279444, 0.93321869, 0.93364173, \
0.93406358, 0.93448422, 0.93490366, 0.93532189, 0.93573892, \
0.93615473, 0.93656933, 0.93698272, 0.93739490, 0.93780586, \
0.93821560, 0.93862411, 0.93903141, 0.93943748, 0.93984233, \
0.94024595, 0.94064834, 0.94104950, 0.94144943, 0.94184813, \
0.94224558, 0.94264180, 0.94303679, 0.94343053, 0.94382302, \
0.94421428, 0.94460428, 0.94499304, 0.94538055, 0.94576681, \
0.94615182, 0.94653557, 0.94691806, 0.94729930, 0.94767928, \
0.94805800, 0.94843545, 0.94881164, 0.94918656, 0.94956022, \
0.94993261, 0.95030373, 0.95067357, 0.95104214, 0.95140944, \
0.95177546, 0.95214020, 0.95250366, 0.95286583, 0.95322673, \
0.95358634, 0.95394466, 0.95430169, 0.95465744, 0.95501189, \
0.95536505, 0.95571692, 0.95606749, 0.95641677, 0.95676474, \
0.95711142, 0.95745679, 0.95780086, 0.95814362, 0.95848508, \
0.95882523, 0.95916407, 0.95950161, 0.95983782, 0.96017273, \
0.96050632, 0.96083859, 0.96116955, 0.96149918, 0.96182750, \
0.96215449, 0.96248016, 0.96280450, 0.96312752, 0.96344921, \
0.96376957, 0.96408860, 0.96440630, 0.96472266, 0.96503769, \
0.96535138, 0.96566373, 0.96597475, 0.96628443, 0.96659276, \
0.96689975, 0.96720539, 0.96750969, 0.96781265, 0.96811425, \
0.96841451, 0.96871341, 0.96901096, 0.96930716, 0.96960200, \
0.96989549, 0.97018761, 0.97047838, 0.97076779, 0.97105584, \
0.97134253, 0.97162785, 0.97191180, 0.97219439, 0.97247562, \
0.97275547, 0.97303395, 0.97331107, 0.97358681, 0.97386117, \
0.97413416, 0.97440578, 0.97467601, 0.97494487, 0.97521235, \
0.97547845, 0.97574317, 0.97600650, 0.97626845, 0.97652901, \
0.97678819, 0.97704597, 0.97730237, 0.97755738, 0.97781100, \
0.97806323, 0.97831406, 0.97856350, 0.97881154, 0.97905818, \
0.97930343, 0.97954728, 0.97978973, 0.98003077, 0.98027042, \
0.98050866, 0.98074550, 0.98098093, 0.98121496, 0.98144758, \
0.98167879, 0.98190859, 0.98213698, 0.98236396, 0.98258953, \
0.98281368, 0.98303642, 0.98325774, 0.98347765, 0.98369614, \
0.98391321, 0.98412886, 0.98434309, 0.98455590, 0.98476729, \
0.98497726, 0.98518580, 0.98539292, 0.98559861, 0.98580287, \
0.98600571, 0.98620712, 0.98640710, 0.98660564, 0.98680276, \
0.98699845, 0.98719270, 0.98738552, 0.98757690, 0.98776685, \
0.98795536, 0.98814243, 0.98832807, 0.98851227, 0.98869502, \
0.98887634, 0.98905622, 0.98923465, 0.98941164, 0.98958719, \
0.98976129, 0.98993395, 0.99010516, 0.99027493, 0.99044325, \
0.99061012, 0.99077554, 0.99093951, 0.99110203, 0.99126310, \
0.99142271, 0.99158088, 0.99173759, 0.99189285, 0.99204665, \
0.99219900, 0.99234989, 0.99249932, 0.99264730, 0.99279382, \
0.99293888, 0.99308248, 0.99322462, 0.99336530, 0.99350452, \
0.99364228, 0.99377857, 0.99391341, 0.99404677, 0.99417868, \
0.99430912, 0.99443809, 0.99456560, 0.99469164, 0.99481621, \
0.99493932, 0.99506096, 0.99518113, 0.99529983, 0.99541706, \
0.99553282, 0.99564711, 0.99575992, 0.99587127, 0.99598114, \
0.99608954, 0.99619647, 0.99630192, 0.99640590, 0.99650840, \
0.99660943, 0.99670898, 0.99680706, 0.99690366, 0.99699878, \
0.99709243, 0.99718460, 0.99727529, 0.99736450, 0.99745223, \
0.99753848, 0.99762326, 0.99770655, 0.99778836, 0.99786869, \
0.99794754, 0.99802491, 0.99810079, 0.99817520, 0.99824812, \
0.99831956, 0.99838951, 0.99845798, 0.99852497, 0.99859047, \
0.99865449, 0.99871702, 0.99877807, 0.99883763, 0.99889571, \
0.99895230, 0.99900740, 0.99906102, 0.99911315, 0.99916380, \
0.99921296, 0.99926063, 0.99930681, 0.99935151, 0.99939471, \
0.99943643, 0.99947666, 0.99951541, 0.99955266, 0.99958843, \
0.99962270, 0.99965549, 0.99968679, 0.99971659, 0.99974491, \
0.99977174, 0.99979708, 0.99982093, 0.99984329, 0.99986416, \
0.99988353, 0.99990142, 0.99991782, 0.99993273, 0.99994614, \
0.99995807, 0.99996851, 0.99997745, 0.99998491, 0.99999087, \
0.99999534, 0.99999832, 0.99999981, } 


 #endif // _FPU_FFT_GAUSS_H_
//=============================================================================
// End of File
//=============================================================================

