//=============================================================================
// Hann Window 
//=============================================================================
#ifndef _FPU_FFT_HANN_H_
#define _FPU_FFT_HANN_H_

#define HANN32 {\
0.00000000, 0.01023503, 0.04052109, 0.08961828, 0.15551654, \
0.23551799, 0.32634737, 0.42428611, 0.52532458, 0.62532627, \
0.72019708, 0.80605299, 0.87937906, 0.93717331, 0.97706963, \
0.99743466, } 

#define HANN64 {\
0.00000000, 0.00248461, 0.00991376, 0.02221360, 0.03926189, \
0.06088921, 0.08688061, 0.11697778, 0.15088159, 0.18825510, \
0.22872687, 0.27189467, 0.31732949, 0.36457977, 0.41317591, \
0.46263495, 0.51246535, 0.56217185, 0.61126047, 0.65924333, \
0.70564355, 0.75000000, 0.79187184, 0.83084292, 0.86652594, \
0.89856625, 0.92664544, 0.95048443, 0.96984631, 0.98453864, \
0.99441541, 0.99937846, } 

#define HANN128 {\
0.00000000, 0.00061179, 0.00244567, 0.00549715, 0.00975876, \
0.01522007, 0.02186772, 0.02968544, 0.03865409, 0.04875174, \
0.05995367, 0.07223246, 0.08555808, 0.09989790, 0.11521684, \
0.13147741, 0.14863981, 0.16666206, 0.18550003, 0.20510764, \
0.22543690, 0.24643807, 0.26805974, 0.29024901, 0.31295157, \
0.33611188, 0.35967324, 0.38357801, 0.40776768, 0.43218306, \
0.45676440, 0.48145154, 0.50618408, 0.53090148, 0.55554326, \
0.58004912, 0.60435908, 0.62841366, 0.65215399, 0.67552198, \
0.69846043, 0.72091321, 0.74282539, 0.76414333, 0.78481486, \
0.80478941, 0.82401809, 0.84245384, 0.86005154, 0.87676814, \
0.89256273, 0.90739665, 0.92123360, 0.93403973, 0.94578368, \
0.95643673, 0.96597280, 0.97436855, 0.98160345, 0.98765978, \
0.99252273, 0.99618039, 0.99862382, 0.99984703, } 

#define HANN256 {\
0.00000000, 0.00015177, 0.00060700, 0.00136541, 0.00242654, \
0.00378975, 0.00545420, 0.00741888, 0.00968261, 0.01224402, \
0.01510153, 0.01825343, 0.02169779, 0.02543253, 0.02945537, \
0.03376389, 0.03835545, 0.04322727, 0.04837640, 0.05379971, \
0.05949390, 0.06545553, 0.07168096, 0.07816643, 0.08490798, \
0.09190154, 0.09914286, 0.10662753, 0.11435102, 0.12230863, \
0.13049554, 0.13890677, 0.14753723, 0.15638166, 0.16543470, \
0.17469085, 0.18414450, 0.19378990, 0.20362120, 0.21363243, \
0.22381751, 0.23417027, 0.24468440, 0.25535354, 0.26617120, \
0.27713082, 0.28822574, 0.29944923, 0.31079447, 0.32225458, \
0.33382260, 0.34549150, 0.35725421, 0.36910357, 0.38103240, \
0.39303346, 0.40509945, 0.41722306, 0.42939692, 0.44161365, \
0.45386582, 0.46614600, 0.47844673, 0.49076055, 0.50307997, \
0.51539753, 0.52770574, 0.53999713, 0.55226423, 0.56449961, \
0.57669583, 0.58884548, 0.60094120, 0.61297564, 0.62494149, \
0.63683150, 0.64863843, 0.66035512, 0.67197446, 0.68348940, \
0.69489294, 0.70617816, 0.71733821, 0.72836632, 0.73925578, \
0.75000000, 0.76059244, 0.77102668, 0.78129638, 0.79139530, \
0.80131732, 0.81105641, 0.82060666, 0.82996227, 0.83911756, \
0.84806697, 0.85680508, 0.86532657, 0.87362627, 0.88169914, \
0.88954029, 0.89714494, 0.90450850, 0.91162647, 0.91849455, \
0.92510857, 0.93146450, 0.93755849, 0.94338684, 0.94894602, \
0.95423264, 0.95924349, 0.96397554, 0.96842592, 0.97259191, \
0.97647100, 0.98006082, 0.98335920, 0.98636414, 0.98907380, \
0.99148655, 0.99360092, 0.99541563, 0.99692957, 0.99814183, \
0.99905166, 0.99965853, 0.99996206, } 

#define HANN512 {\
0.00000000, 0.00003780, 0.00015118, 0.00034013, 0.00060463, \
0.00094463, 0.00136008, 0.00185091, 0.00241706, 0.00305844, \
0.00377495, 0.00456648, 0.00543291, 0.00637411, 0.00738995, \
0.00848026, 0.00964488, 0.01088363, 0.01219634, 0.01358279, \
0.01504278, 0.01657609, 0.01818249, 0.01986173, 0.02161357, \
0.02343773, 0.02533393, 0.02730190, 0.02934134, 0.03145193, \
0.03363337, 0.03588531, 0.03820741, 0.04059934, 0.04306072, \
0.04559118, 0.04819034, 0.05085781, 0.05359319, 0.05639605, \
0.05926599, 0.06220255, 0.06520531, 0.06827379, 0.07140755, \
0.07460611, 0.07786898, 0.08119567, 0.08458568, 0.08803850, \
0.09155359, 0.09513044, 0.09876850, 0.10246722, 0.10622604, \
0.11004440, 0.11392171, 0.11785739, 0.12185084, 0.12590147, \
0.13000865, 0.13417178, 0.13839021, 0.14266331, 0.14699043, \
0.15137093, 0.15580413, 0.16028937, 0.16482597, 0.16941325, \
0.17405050, 0.17873704, 0.18347214, 0.18825510, 0.19308519, \
0.19796168, 0.20288384, 0.20785091, 0.21286216, 0.21791681, \
0.22301412, 0.22815330, 0.23333358, 0.23855417, 0.24381429, \
0.24911315, 0.25444993, 0.25982384, 0.26523406, 0.27067978, \
0.27616016, 0.28167438, 0.28722162, 0.29280102, 0.29841175, \
0.30405295, 0.30972378, 0.31542338, 0.32115088, 0.32690542, \
0.33268613, 0.33849214, 0.34432257, 0.35017653, 0.35605314, \
0.36195151, 0.36787076, 0.37380998, 0.37976828, 0.38574476, \
0.39173851, 0.39774863, 0.40377421, 0.40981434, 0.41586810, \
0.42193458, 0.42801286, 0.43410203, 0.44020116, 0.44630933, \
0.45242561, 0.45854909, 0.46467884, 0.47081393, 0.47695343, \
0.48309641, 0.48924195, 0.49538912, 0.50153698, 0.50768461, \
0.51383108, 0.51997546, 0.52611682, 0.53225422, 0.53838676, \
0.54451349, 0.55063349, 0.55674583, 0.56284960, 0.56894386, \
0.57502770, 0.58110020, 0.58716043, 0.59320749, 0.59924046, \
0.60525842, 0.61126047, 0.61724569, 0.62321320, 0.62916207, \
0.63509142, 0.64100034, 0.64688794, 0.65275334, 0.65859564, \
0.66441397, 0.67020744, 0.67597517, 0.68171630, 0.68742996, \
0.69311528, 0.69877141, 0.70439748, 0.70999265, 0.71555607, \
0.72108691, 0.72658431, 0.73204747, 0.73747554, 0.74286770, \
0.74822315, 0.75354107, 0.75882066, 0.76406112, 0.76926165, \
0.77442148, 0.77953982, 0.78461589, 0.78964894, 0.79463819, \
0.79958290, 0.80448232, 0.80933570, 0.81414232, 0.81890144, \
0.82361235, 0.82827433, 0.83288668, 0.83744870, 0.84195971, \
0.84641902, 0.85082595, 0.85517984, 0.85948004, 0.86372588, \
0.86791674, 0.87205197, 0.87613095, 0.88015307, 0.88411771, \
0.88802428, 0.89187219, 0.89566085, 0.89938969, 0.90305815, \
0.90666567, 0.91021171, 0.91369573, 0.91711720, 0.92047562, \
0.92377046, 0.92700124, 0.93016746, 0.93326864, 0.93630432, \
0.93927403, 0.94217734, 0.94501379, 0.94778296, 0.95048443, \
0.95311780, 0.95568266, 0.95817863, 0.96060533, 0.96296239, \
0.96524946, 0.96746618, 0.96961224, 0.97168729, 0.97369103, \
0.97562316, 0.97748338, 0.97927141, 0.98098698, 0.98262983, \
0.98419971, 0.98569639, 0.98711964, 0.98846925, 0.98974500, \
0.99094671, 0.99207420, 0.99312729, 0.99410583, 0.99500966, \
0.99583866, 0.99659269, 0.99727165, 0.99787542, 0.99840392, \
0.99885707, 0.99923480, 0.99953706, 0.99976379, 0.99991496, \
0.99999055, } 

#define HANN1024 {\
0.00000000, 0.00000943, 0.00003772, 0.00008487, 0.00015089, \
0.00023575, 0.00033947, 0.00046204, 0.00060345, 0.00076370, \
0.00094278, 0.00114069, 0.00135742, 0.00159296, 0.00184730, \
0.00212043, 0.00241234, 0.00272303, 0.00305247, 0.00340066, \
0.00376758, 0.00415322, 0.00455757, 0.00498060, 0.00542231, \
0.00588268, 0.00636168, 0.00685931, 0.00737554, 0.00791036, \
0.00846373, 0.00903565, 0.00962609, 0.01023503, 0.01086244, \
0.01150831, 0.01217260, 0.01285530, 0.01355637, 0.01427579, \
0.01501354, 0.01576958, 0.01654388, 0.01733643, 0.01814718, \
0.01897611, 0.01982318, 0.02068837, 0.02157164, 0.02247296, \
0.02339229, 0.02432960, 0.02528485, 0.02625801, 0.02724904, \
0.02825791, 0.02928457, 0.03032899, 0.03139113, 0.03247094, \
0.03356839, 0.03468344, 0.03581603, 0.03696614, 0.03813372, \
0.03931872, 0.04052109, 0.04174080, 0.04297780, 0.04423204, \
0.04550347, 0.04679204, 0.04809772, 0.04942044, 0.05076015, \
0.05211681, 0.05349037, 0.05488077, 0.05628797, 0.05771190, \
0.05915252, 0.06060976, 0.06208358, 0.06357392, 0.06508073, \
0.06660394, 0.06814350, 0.06969935, 0.07127143, 0.07285969, \
0.07446406, 0.07608448, 0.07772089, 0.07937323, 0.08104144, \
0.08272546, 0.08442521, 0.08614064, 0.08787169, 0.08961828, \
0.09138035, 0.09315784, 0.09495067, 0.09675878, 0.09858211, \
0.10042057, 0.10227412, 0.10414266, 0.10602614, 0.10792448, \
0.10983760, 0.11176545, 0.11370794, 0.11566501, 0.11763657, \
0.11962256, 0.12162290, 0.12363751, 0.12566631, 0.12770924, \
0.12976621, 0.13183715, 0.13392198, 0.13602061, 0.13813298, \
0.14025900, 0.14239859, 0.14455166, 0.14671815, 0.14889796, \
0.15109102, 0.15329724, 0.15551654, 0.15774883, 0.15999404, \
0.16225207, 0.16452284, 0.16680627, 0.16910226, 0.17141074, \
0.17373161, 0.17606480, 0.17841020, 0.18076773, 0.18313730, \
0.18551883, 0.18791222, 0.19031739, 0.19273423, 0.19516267, \
0.19760261, 0.20005395, 0.20251661, 0.20499049, 0.20747550, \
0.20997155, 0.21247853, 0.21499636, 0.21752494, 0.22006418, \
0.22261398, 0.22517424, 0.22774487, 0.23032577, 0.23291685, \
0.23551799, 0.23812912, 0.24075012, 0.24338091, 0.24602137, \
0.24867142, 0.25133094, 0.25399985, 0.25667803, 0.25936540, \
0.26206184, 0.26476726, 0.26748155, 0.27020461, 0.27293635, \
0.27567664, 0.27842540, 0.28118252, 0.28394789, 0.28672142, \
0.28950298, 0.29229249, 0.29508984, 0.29789491, 0.30070761, \
0.30352783, 0.30635545, 0.30919039, 0.31203252, 0.31488174, \
0.31773794, 0.32060102, 0.32347087, 0.32634737, 0.32923043, \
0.33211993, 0.33501576, 0.33791782, 0.34082599, 0.34374016, \
0.34666023, 0.34958608, 0.35251761, 0.35545470, 0.35839725, \
0.36134513, 0.36429825, 0.36725648, 0.37021973, 0.37318786, \
0.37616079, 0.37913838, 0.38212053, 0.38510713, 0.38809807, \
0.39109322, 0.39409248, 0.39709574, 0.40010288, 0.40311379, \
0.40612836, 0.40914646, 0.41216799, 0.41519284, 0.41822088, \
0.42125201, 0.42428611, 0.42732307, 0.43036277, 0.43340509, \
0.43644993, 0.43949716, 0.44254668, 0.44559836, 0.44865210, \
0.45170777, 0.45476527, 0.45782447, 0.46088526, 0.46394753, \
0.46701115, 0.47007603, 0.47314203, 0.47620904, 0.47927695, \
0.48234565, 0.48541501, 0.48848492, 0.49155526, 0.49462592, \
0.49769679, 0.50076774, 0.50383866, 0.50690944, 0.50997996, \
0.51305010, 0.51611975, 0.51918879, 0.52225711, 0.52532458, \
0.52839111, 0.53145656, 0.53452082, 0.53758378, 0.54064533, \
0.54370534, 0.54676370, 0.54982030, 0.55287502, 0.55592774, \
0.55897836, 0.56202675, 0.56507280, 0.56811639, 0.57115742, \
0.57419576, 0.57723130, 0.58026393, 0.58329353, 0.58631999, \
0.58934320, 0.59236303, 0.59537938, 0.59839213, 0.60140117, \
0.60440638, 0.60740765, 0.61040488, 0.61339794, 0.61638672, \
0.61937111, 0.62235099, 0.62532627, 0.62829681, 0.63126251, \
0.63422327, 0.63717896, 0.64012947, 0.64307470, 0.64601453, \
0.64894885, 0.65187756, 0.65480053, 0.65771767, 0.66062886, \
0.66353398, 0.66643294, 0.66932562, 0.67221191, 0.67509171, \
0.67796490, 0.68083137, 0.68369103, 0.68654375, 0.68938944, \
0.69222799, 0.69505928, 0.69788322, 0.70069969, 0.70350859, \
0.70630981, 0.70910325, 0.71188880, 0.71466636, 0.71743582, \
0.72019708, 0.72295003, 0.72569457, 0.72843060, 0.73115801, \
0.73387670, 0.73658657, 0.73928751, 0.74197942, 0.74466221, \
0.74733577, 0.75000000, 0.75265480, 0.75530006, 0.75793570, \
0.76056161, 0.76317768, 0.76578383, 0.76837996, 0.77096595, \
0.77354173, 0.77610719, 0.77866223, 0.78120676, 0.78374068, \
0.78626390, 0.78877632, 0.79127785, 0.79376839, 0.79624785, \
0.79871613, 0.80117314, 0.80361879, 0.80605299, 0.80847564, \
0.81088666, 0.81328595, 0.81567342, 0.81804898, 0.82041255, \
0.82276403, 0.82510333, 0.82743037, 0.82974505, 0.83204730, \
0.83433702, 0.83661413, 0.83887854, 0.84113017, 0.84336893, \
0.84559474, 0.84780751, 0.85000716, 0.85219360, 0.85436676, \
0.85652656, 0.85867290, 0.86080571, 0.86292491, 0.86503043, \
0.86712217, 0.86920006, 0.87126402, 0.87331398, 0.87534986, \
0.87737158, 0.87937906, 0.88137223, 0.88335102, 0.88531534, \
0.88726513, 0.88920031, 0.89112080, 0.89302655, 0.89491746, \
0.89679348, 0.89865453, 0.90050055, 0.90233145, 0.90414718, \
0.90594766, 0.90773283, 0.90950262, 0.91125696, 0.91299578, \
0.91471903, 0.91642663, 0.91811852, 0.91979464, 0.92145493, \
0.92309931, 0.92472774, 0.92634014, 0.92793646, 0.92951663, \
0.93108061, 0.93262832, 0.93415971, 0.93567473, 0.93717331, \
0.93865540, 0.94012094, 0.94156987, 0.94300216, 0.94441772, \
0.94581653, 0.94719852, 0.94856363, 0.94991183, 0.95124305, \
0.95255725, 0.95385438, 0.95513439, 0.95639723, 0.95764286, \
0.95887121, 0.96008226, 0.96127596, 0.96245225, 0.96361110, \
0.96475246, 0.96587628, 0.96698254, 0.96807117, 0.96914215, \
0.97019544, 0.97123098, 0.97224875, 0.97324870, 0.97423080, \
0.97519502, 0.97614130, 0.97706963, 0.97797996, 0.97887225, \
0.97974649, 0.98060262, 0.98144063, 0.98226047, 0.98306212, \
0.98384555, 0.98461073, 0.98535763, 0.98608621, 0.98679646, \
0.98748835, 0.98816185, 0.98881693, 0.98945357, 0.99007175, \
0.99067144, 0.99125262, 0.99181528, 0.99235937, 0.99288490, \
0.99339183, 0.99388015, 0.99434984, 0.99480088, 0.99523325, \
0.99564694, 0.99604194, 0.99641822, 0.99677578, 0.99711460, \
0.99743466, 0.99773596, 0.99801848, 0.99828222, 0.99852716, \
0.99875330, 0.99896061, 0.99914911, 0.99931878, 0.99946961, \
0.99960160, 0.99971475, 0.99980904, 0.99988448, 0.99994106, \
0.99997878, 0.99999764, } 

#define HANN2048 {\
0.00000000, 0.00000236, 0.00000942, 0.00002120, 0.00003769, \
0.00005888, 0.00008479, 0.00011541, 0.00015074, 0.00019077, \
0.00023552, 0.00028498, 0.00033914, 0.00039801, 0.00046159, \
0.00052987, 0.00060286, 0.00068056, 0.00076295, 0.00085006, \
0.00094186, 0.00103837, 0.00113958, 0.00124549, 0.00135610, \
0.00147140, 0.00159140, 0.00171610, 0.00184549, 0.00197958, \
0.00211836, 0.00226183, 0.00240999, 0.00256283, 0.00272037, \
0.00288259, 0.00304949, 0.00322107, 0.00339734, 0.00357828, \
0.00376390, 0.00395420, 0.00414917, 0.00434881, 0.00455312, \
0.00476210, 0.00497574, 0.00519405, 0.00541702, 0.00564465, \
0.00587694, 0.00611389, 0.00635548, 0.00660173, 0.00685263, \
0.00710817, 0.00736836, 0.00763318, 0.00790265, 0.00817675, \
0.00845549, 0.00873886, 0.00902685, 0.00931947, 0.00961672, \
0.00991858, 0.01022507, 0.01053616, 0.01085187, 0.01117219, \
0.01149711, 0.01182664, 0.01216076, 0.01249948, 0.01284279, \
0.01319070, 0.01354319, 0.01390026, 0.01426191, 0.01462814, \
0.01499894, 0.01537432, 0.01575425, 0.01613875, 0.01652781, \
0.01692143, 0.01731959, 0.01772230, 0.01812956, 0.01854136, \
0.01895769, 0.01937855, 0.01980395, 0.02023386, 0.02066830, \
0.02110725, 0.02155072, 0.02199869, 0.02245117, 0.02290815, \
0.02336962, 0.02383558, 0.02430603, 0.02478096, 0.02526036, \
0.02574424, 0.02623259, 0.02672540, 0.02722267, 0.02772440, \
0.02823057, 0.02874119, 0.02925625, 0.02977574, 0.03029967, \
0.03082802, 0.03136079, 0.03189797, 0.03243957, 0.03298557, \
0.03353597, 0.03409077, 0.03464995, 0.03521352, 0.03578147, \
0.03635379, 0.03693048, 0.03751154, 0.03809695, 0.03868671, \
0.03928082, 0.03987927, 0.04048206, 0.04108917, 0.04170061, \
0.04231636, 0.04293643, 0.04356081, 0.04418948, 0.04482245, \
0.04545971, 0.04610125, 0.04674706, 0.04739715, 0.04805150, \
0.04871011, 0.04937297, 0.05004008, 0.05071142, 0.05138700, \
0.05206681, 0.05275083, 0.05343907, 0.05413152, 0.05482817, \
0.05552901, 0.05623404, 0.05694325, 0.05765664, 0.05837419, \
0.05909590, 0.05982177, 0.06055178, 0.06128594, 0.06202423, \
0.06276664, 0.06351317, 0.06426382, 0.06501857, 0.06577742, \
0.06654036, 0.06730739, 0.06807849, 0.06885366, 0.06963289, \
0.07041618, 0.07120352, 0.07199489, 0.07279030, 0.07358973, \
0.07439318, 0.07520064, 0.07601210, 0.07682756, 0.07764700, \
0.07847042, 0.07929782, 0.08012918, 0.08096449, 0.08180375, \
0.08264695, 0.08349409, 0.08434515, 0.08520012, 0.08605900, \
0.08692179, 0.08778846, 0.08865902, 0.08953345, 0.09041175, \
0.09129391, 0.09217992, 0.09306977, 0.09396346, 0.09486097, \
0.09576230, 0.09666744, 0.09757638, 0.09848911, 0.09940562, \
0.10032590, 0.10124996, 0.10217776, 0.10310932, 0.10404462, \
0.10498364, 0.10592639, 0.10687285, 0.10782302, 0.10877688, \
0.10973442, 0.11069565, 0.11166054, 0.11262909, 0.11360129, \
0.11457712, 0.11555660, 0.11653969, 0.11752639, 0.11851670, \
0.11951061, 0.12050809, 0.12150916, 0.12251379, 0.12352197, \
0.12453371, 0.12554898, 0.12656778, 0.12759009, 0.12861592, \
0.12964524, 0.13067806, 0.13171435, 0.13275411, 0.13379734, \
0.13484401, 0.13589412, 0.13694767, 0.13800463, 0.13906501, \
0.14012878, 0.14119595, 0.14226650, 0.14334041, 0.14441769, \
0.14549832, 0.14658229, 0.14766959, 0.14876020, 0.14985413, \
0.15095135, 0.15205187, 0.15315566, 0.15426272, 0.15537304, \
0.15648660, 0.15760340, 0.15872343, 0.15984667, 0.16097312, \
0.16210276, 0.16323558, 0.16437158, 0.16551074, 0.16665305, \
0.16779850, 0.16894708, 0.17009878, 0.17125359, 0.17241150, \
0.17357249, 0.17473656, 0.17590369, 0.17707388, 0.17824710, \
0.17942336, 0.18060264, 0.18178493, 0.18297022, 0.18415849, \
0.18534974, 0.18654396, 0.18774113, 0.18894124, 0.19014428, \
0.19135024, 0.19255910, 0.19377087, 0.19498552, 0.19620304, \
0.19742343, 0.19864666, 0.19987274, 0.20110164, 0.20233336, \
0.20356788, 0.20480520, 0.20604530, 0.20728816, 0.20853379, \
0.20978216, 0.21103326, 0.21228709, 0.21354363, 0.21480287, \
0.21606479, 0.21732939, 0.21859666, 0.21986657, 0.22113912, \
0.22241430, 0.22369210, 0.22497250, 0.22625549, 0.22754106, \
0.22882919, 0.23011989, 0.23141312, 0.23270888, 0.23400717, \
0.23530796, 0.23661124, 0.23791700, 0.23922524, 0.24053593, \
0.24184906, 0.24316463, 0.24448262, 0.24580301, 0.24712580, \
0.24845097, 0.24977851, 0.25110841, 0.25244066, 0.25377523, \
0.25511213, 0.25645133, 0.25779283, 0.25913661, 0.26048266, \
0.26183097, 0.26318152, 0.26453430, 0.26588930, 0.26724650, \
0.26860590, 0.26996748, 0.27133123, 0.27269713, 0.27406517, \
0.27543534, 0.27680763, 0.27818201, 0.27955849, 0.28093705, \
0.28231767, 0.28370034, 0.28508505, 0.28647178, 0.28786053, \
0.28925127, 0.29064400, 0.29203870, 0.29343536, 0.29483397, \
0.29623451, 0.29763697, 0.29904134, 0.30044760, 0.30185574, \
0.30326574, 0.30467760, 0.30609130, 0.30750683, 0.30892417, \
0.31034331, 0.31176424, 0.31318694, 0.31461141, 0.31603761, \
0.31746556, 0.31889522, 0.32032659, 0.32175965, 0.32319439, \
0.32463079, 0.32606885, 0.32750855, 0.32894987, 0.33039280, \
0.33183733, 0.33328345, 0.33473114, 0.33618038, 0.33763117, \
0.33908348, 0.34053732, 0.34199265, 0.34344947, 0.34490777, \
0.34636753, 0.34782874, 0.34929138, 0.35075544, 0.35222091, \
0.35368777, 0.35515601, 0.35662561, 0.35809656, 0.35956885, \
0.36104247, 0.36251739, 0.36399361, 0.36547111, 0.36694988, \
0.36842990, 0.36991116, 0.37139364, 0.37287734, 0.37436223, \
0.37584831, 0.37733556, 0.37882397, 0.38031351, 0.38180419, \
0.38329597, 0.38478886, 0.38628283, 0.38777787, 0.38927398, \
0.39077112, 0.39226929, 0.39376848, 0.39526867, 0.39676985, \
0.39827199, 0.39977510, 0.40127915, 0.40278413, 0.40429003, \
0.40579683, 0.40730451, 0.40881307, 0.41032249, 0.41183276, \
0.41334385, 0.41485576, 0.41636847, 0.41788198, 0.41939625, \
0.42091128, 0.42242706, 0.42394357, 0.42546080, 0.42697873, \
0.42849735, 0.43001664, 0.43153659, 0.43305718, 0.43457841, \
0.43610025, 0.43762269, 0.43914572, 0.44066933, 0.44219349, \
0.44371820, 0.44524344, 0.44676920, 0.44829545, 0.44982220, \
0.45134941, 0.45287709, 0.45440521, 0.45593375, 0.45746272, \
0.45899208, 0.46052183, 0.46205195, 0.46358243, 0.46511326, \
0.46664441, 0.46817588, 0.46970764, 0.47123969, 0.47277201, \
0.47430459, 0.47583741, 0.47737046, 0.47890372, 0.48043718, \
0.48197083, 0.48350464, 0.48503861, 0.48657273, 0.48810696, \
0.48964131, 0.49117576, 0.49271029, 0.49424489, 0.49577954, \
0.49731424, 0.49884895, 0.50038368, 0.50191841, 0.50345312, \
0.50498779, 0.50652242, 0.50805698, 0.50959148, 0.51112588, \
0.51266017, 0.51419435, 0.51572839, 0.51726228, 0.51879601, \
0.52032957, 0.52186293, 0.52339609, 0.52492903, 0.52646173, \
0.52799418, 0.52952637, 0.53105828, 0.53258990, 0.53412121, \
0.53565220, 0.53718285, 0.53871315, 0.54024309, 0.54177265, \
0.54330182, 0.54483057, 0.54635891, 0.54788681, 0.54941425, \
0.55094124, 0.55246774, 0.55399374, 0.55551924, 0.55704422, \
0.55856866, 0.56009254, 0.56161586, 0.56313860, 0.56466075, \
0.56618228, 0.56770320, 0.56922347, 0.57074309, 0.57226205, \
0.57378032, 0.57529790, 0.57681477, 0.57833092, 0.57984633, \
0.58136098, 0.58287487, 0.58438798, 0.58590029, 0.58741180, \
0.58892248, 0.59043232, 0.59194131, 0.59344944, 0.59495668, \
0.59646303, 0.59796847, 0.59947299, 0.60097657, 0.60247920, \
0.60398087, 0.60548155, 0.60698124, 0.60847992, 0.60997758, \
0.61147421, 0.61296978, 0.61446429, 0.61595772, 0.61745006, \
0.61894129, 0.62043140, 0.62192038, 0.62340821, 0.62489487, \
0.62638036, 0.62786466, 0.62934775, 0.63082963, 0.63231027, \
0.63378967, 0.63526780, 0.63674466, 0.63822023, 0.63969450, \
0.64116746, 0.64263908, 0.64410936, 0.64557828, 0.64704583, \
0.64851200, 0.64997676, 0.65144012, 0.65290204, 0.65436253, \
0.65582156, 0.65727912, 0.65873520, 0.66018979, 0.66164287, \
0.66309442, 0.66454444, 0.66599290, 0.66743981, 0.66888513, \
0.67032887, 0.67177099, 0.67321151, 0.67465038, 0.67608762, \
0.67752319, 0.67895709, 0.68038931, 0.68181983, 0.68324863, \
0.68467571, 0.68610104, 0.68752463, 0.68894644, 0.69036648, \
0.69178472, 0.69320116, 0.69461578, 0.69602856, 0.69743949, \
0.69884857, 0.70025577, 0.70166109, 0.70306450, 0.70446600, \
0.70586558, 0.70726321, 0.70865890, 0.71005261, 0.71144435, \
0.71283410, 0.71422184, 0.71560756, 0.71699125, 0.71837290, \
0.71975249, 0.72113001, 0.72250544, 0.72387878, 0.72525001, \
0.72661912, 0.72798609, 0.72935092, 0.73071358, 0.73207407, \
0.73343237, 0.73478848, 0.73614237, 0.73749404, 0.73884347, \
0.74019065, 0.74153556, 0.74287820, 0.74421856, 0.74555661, \
0.74689235, 0.74822576, 0.74955683, 0.75088555, 0.75221191, \
0.75353589, 0.75485749, 0.75617668, 0.75749346, 0.75880781, \
0.76011972, 0.76142919, 0.76273619, 0.76404071, 0.76534275, \
0.76664229, 0.76793931, 0.76923381, 0.77052578, 0.77181519, \
0.77310205, 0.77438633, 0.77566803, 0.77694713, 0.77822361, \
0.77949748, 0.78076872, 0.78203731, 0.78330324, 0.78456650, \
0.78582709, 0.78708498, 0.78834016, 0.78959263, 0.79084237, \
0.79208937, 0.79333362, 0.79457510, 0.79581381, 0.79704973, \
0.79828285, 0.79951316, 0.80074066, 0.80196531, 0.80318712, \
0.80440608, 0.80562217, 0.80683538, 0.80804569, 0.80925311, \
0.81045761, 0.81165919, 0.81285783, 0.81405352, 0.81524625, \
0.81643602, 0.81762280, 0.81880659, 0.81998737, 0.82116514, \
0.82233989, 0.82351160, 0.82468026, 0.82584586, 0.82700839, \
0.82816784, 0.82932420, 0.83047746, 0.83162760, 0.83277462, \
0.83391850, 0.83505924, 0.83619682, 0.83733123, 0.83846246, \
0.83959051, 0.84071535, 0.84183699, 0.84295540, 0.84407059, \
0.84518253, 0.84629122, 0.84739665, 0.84849880, 0.84959767, \
0.85069325, 0.85178552, 0.85287448, 0.85396011, 0.85504241, \
0.85612137, 0.85719697, 0.85826920, 0.85933806, 0.86040353, \
0.86146561, 0.86252428, 0.86357953, 0.86463136, 0.86567976, \
0.86672471, 0.86776620, 0.86880423, 0.86983879, 0.87086986, \
0.87189743, 0.87292151, 0.87394206, 0.87495910, 0.87597260, \
0.87698256, 0.87798897, 0.87899182, 0.87999110, 0.88098679, \
0.88197890, 0.88296741, 0.88395231, 0.88493359, 0.88591125, \
0.88688527, 0.88785565, 0.88882237, 0.88978542, 0.89074481, \
0.89170051, 0.89265253, 0.89360084, 0.89454545, 0.89548634, \
0.89642350, 0.89735693, 0.89828661, 0.89921254, 0.90013471, \
0.90105311, 0.90196773, 0.90287857, 0.90378560, 0.90468884, \
0.90558826, 0.90648386, 0.90737563, 0.90826356, 0.90914765, \
0.91002788, 0.91090425, 0.91177675, 0.91264536, 0.91351009, \
0.91437093, 0.91522785, 0.91608087, 0.91692997, 0.91777514, \
0.91861637, 0.91945366, 0.92028700, 0.92111637, 0.92194178, \
0.92276322, 0.92358067, 0.92439413, 0.92520359, 0.92600905, \
0.92681049, 0.92760791, 0.92840130, 0.92919066, 0.92997597, \
0.93075723, 0.93153443, 0.93230757, 0.93307663, 0.93384162, \
0.93460251, 0.93535932, 0.93611202, 0.93686061, 0.93760508, \
0.93834543, 0.93908166, 0.93981374, 0.94054168, 0.94126547, \
0.94198511, 0.94270058, 0.94341188, 0.94411900, 0.94482193, \
0.94552068, 0.94621523, 0.94690557, 0.94759171, 0.94827362, \
0.94895131, 0.94962478, 0.95029401, 0.95095899, 0.95161973, \
0.95227621, 0.95292843, 0.95357638, 0.95422006, 0.95485946, \
0.95549457, 0.95612539, 0.95675192, 0.95737414, 0.95799205, \
0.95860565, 0.95921493, 0.95981988, 0.96042050, 0.96101678, \
0.96160871, 0.96219630, 0.96277953, 0.96335841, 0.96393291, \
0.96450305, 0.96506881, 0.96563019, 0.96618718, 0.96673978, \
0.96728798, 0.96783178, 0.96837117, 0.96890615, 0.96943671, \
0.96996285, 0.97048456, 0.97100183, 0.97151467, 0.97202307, \
0.97252702, 0.97302652, 0.97352156, 0.97401214, 0.97449826, \
0.97497990, 0.97545707, 0.97592976, 0.97639796, 0.97686168, \
0.97732090, 0.97777563, 0.97822586, 0.97867158, 0.97911279, \
0.97954948, 0.97998166, 0.98040932, 0.98083244, 0.98125104, \
0.98166511, 0.98207464, 0.98247962, 0.98288006, 0.98327595, \
0.98366729, 0.98405407, 0.98443629, 0.98481394, 0.98518703, \
0.98555554, 0.98591949, 0.98627885, 0.98663363, 0.98698383, \
0.98732944, 0.98767045, 0.98800688, 0.98833870, 0.98866593, \
0.98898855, 0.98930656, 0.98961996, 0.98992875, 0.99023293, \
0.99053248, 0.99082742, 0.99111772, 0.99140341, 0.99168446, \
0.99196088, 0.99223266, 0.99249981, 0.99276232, 0.99302018, \
0.99327340, 0.99352197, 0.99376590, 0.99400517, 0.99423978, \
0.99446974, 0.99469504, 0.99491568, 0.99513166, 0.99534297, \
0.99554962, 0.99575159, 0.99594890, 0.99614153, 0.99632949, \
0.99651277, 0.99669138, 0.99686530, 0.99703455, 0.99719911, \
0.99735898, 0.99751417, 0.99766468, 0.99781049, 0.99795162, \
0.99808805, 0.99821979, 0.99834683, 0.99846919, 0.99858684, \
0.99869980, 0.99880805, 0.99891161, 0.99901047, 0.99910463, \
0.99919408, 0.99927883, 0.99935888, 0.99943422, 0.99950486, \
0.99957079, 0.99963201, 0.99968853, 0.99974034, 0.99978744, \
0.99982983, 0.99986751, 0.99990049, 0.99992875, 0.99995230, \
0.99997115, 0.99998528, 0.99999470, 0.99999941, } 

#define HANN4096 {\
0.00000000, 0.00000059, 0.00000235, 0.00000530, 0.00000942, \
0.00001471, 0.00002119, 0.00002884, 0.00003767, 0.00004767, \
0.00005886, 0.00007121, 0.00008475, 0.00009946, 0.00011535, \
0.00013242, 0.00015066, 0.00017008, 0.00019068, 0.00021246, \
0.00023541, 0.00025953, 0.00028484, 0.00031132, 0.00033897, \
0.00036781, 0.00039781, 0.00042900, 0.00046136, 0.00049490, \
0.00052961, 0.00056550, 0.00060257, 0.00064081, 0.00068022, \
0.00072081, 0.00076258, 0.00080552, 0.00084964, 0.00089494, \
0.00094140, 0.00098905, 0.00103786, 0.00108786, 0.00113902, \
0.00119136, 0.00124488, 0.00129957, 0.00135543, 0.00141247, \
0.00147068, 0.00153007, 0.00159063, 0.00165236, 0.00171526, \
0.00177934, 0.00184459, 0.00191102, 0.00197861, 0.00204738, \
0.00211733, 0.00218844, 0.00226073, 0.00233418, 0.00240881, \
0.00248461, 0.00256158, 0.00263973, 0.00271904, 0.00279953, \
0.00288118, 0.00296401, 0.00304800, 0.00313317, 0.00321950, \
0.00330701, 0.00339568, 0.00348552, 0.00357654, 0.00366872, \
0.00376207, 0.00385658, 0.00395227, 0.00404912, 0.00414715, \
0.00424633, 0.00434669, 0.00444821, 0.00455090, 0.00465476, \
0.00475978, 0.00486597, 0.00497332, 0.00508184, 0.00519152, \
0.00530237, 0.00541438, 0.00552756, 0.00564190, 0.00575741, \
0.00587408, 0.00599191, 0.00611091, 0.00623106, 0.00635239, \
0.00647487, 0.00659851, 0.00672332, 0.00684929, 0.00697642, \
0.00710471, 0.00723416, 0.00736477, 0.00749654, 0.00762946, \
0.00776355, 0.00789880, 0.00803521, 0.00817277, 0.00831149, \
0.00845137, 0.00859241, 0.00873460, 0.00887795, 0.00902246, \
0.00916812, 0.00931494, 0.00946291, 0.00961204, 0.00976232, \
0.00991376, 0.01006635, 0.01022009, 0.01037499, 0.01053104, \
0.01068824, 0.01084659, 0.01100610, 0.01116675, 0.01132856, \
0.01149152, 0.01165563, 0.01182088, 0.01198729, 0.01215485, \
0.01232355, 0.01249340, 0.01266440, 0.01283655, 0.01300984, \
0.01318428, 0.01335987, 0.01353660, 0.01371448, 0.01389350, \
0.01407367, 0.01425498, 0.01443744, 0.01462103, 0.01480577, \
0.01499166, 0.01517868, 0.01536685, 0.01555615, 0.01574660, \
0.01593819, 0.01613091, 0.01632478, 0.01651979, 0.01671593, \
0.01691321, 0.01711163, 0.01731118, 0.01751187, 0.01771370, \
0.01791666, 0.01812076, 0.01832599, 0.01853236, 0.01873986, \
0.01894849, 0.01915826, 0.01936915, 0.01958118, 0.01979434, \
0.02000863, 0.02022405, 0.02044060, 0.02065828, 0.02087709, \
0.02109702, 0.02131808, 0.02154027, 0.02176359, 0.02198803, \
0.02221360, 0.02244029, 0.02266811, 0.02289705, 0.02312711, \
0.02335829, 0.02359060, 0.02382403, 0.02405858, 0.02429425, \
0.02453104, 0.02476895, 0.02500798, 0.02524813, 0.02548940, \
0.02573178, 0.02597528, 0.02621989, 0.02646562, 0.02671247, \
0.02696043, 0.02720950, 0.02745969, 0.02771098, 0.02796339, \
0.02821692, 0.02847155, 0.02872729, 0.02898414, 0.02924210, \
0.02950117, 0.02976135, 0.03002263, 0.03028502, 0.03054852, \
0.03081312, 0.03107883, 0.03134564, 0.03161355, 0.03188256, \
0.03215268, 0.03242390, 0.03269622, 0.03296964, 0.03324416, \
0.03351978, 0.03379650, 0.03407431, 0.03435322, 0.03463323, \
0.03491433, 0.03519653, 0.03547982, 0.03576421, 0.03604969, \
0.03633626, 0.03662392, 0.03691268, 0.03720252, 0.03749345, \
0.03778547, 0.03807859, 0.03837278, 0.03866807, 0.03896444, \
0.03926189, 0.03956043, 0.03986006, 0.04016077, 0.04046256, \
0.04076543, 0.04106938, 0.04137442, 0.04168053, 0.04198772, \
0.04229600, 0.04260534, 0.04291577, 0.04322727, 0.04353985, \
0.04385350, 0.04416822, 0.04448402, 0.04480089, 0.04511884, \
0.04543785, 0.04575793, 0.04607909, 0.04640131, 0.04672460, \
0.04704895, 0.04737438, 0.04770087, 0.04802842, 0.04835704, \
0.04868672, 0.04901746, 0.04934927, 0.04968213, 0.05001606, \
0.05035104, 0.05068709, 0.05102419, 0.05136235, 0.05170156, \
0.05204183, 0.05238316, 0.05272554, 0.05306897, 0.05341345, \
0.05375899, 0.05410557, 0.05445321, 0.05480189, 0.05515163, \
0.05550241, 0.05585423, 0.05620711, 0.05656102, 0.05691598, \
0.05727199, 0.05762903, 0.05798712, 0.05834625, 0.05870642, \
0.05906762, 0.05942987, 0.05979315, 0.06015747, 0.06052282, \
0.06088921, 0.06125664, 0.06162509, 0.06199458, 0.06236510, \
0.06273665, 0.06310922, 0.06348283, 0.06385747, 0.06423313, \
0.06460981, 0.06498753, 0.06536626, 0.06574602, 0.06612681, \
0.06650861, 0.06689143, 0.06727528, 0.06766014, 0.06804602, \
0.06843292, 0.06882083, 0.06920976, 0.06959970, 0.06999066, \
0.07038262, 0.07077560, 0.07116959, 0.07156459, 0.07196060, \
0.07235762, 0.07275564, 0.07315467, 0.07355470, 0.07395574, \
0.07435778, 0.07476082, 0.07516487, 0.07556991, 0.07597595, \
0.07638299, 0.07679103, 0.07720007, 0.07761010, 0.07802112, \
0.07843314, 0.07884615, 0.07926015, 0.07967514, 0.08009113, \
0.08050810, 0.08092606, 0.08134500, 0.08176493, 0.08218585, \
0.08260774, 0.08303063, 0.08345449, 0.08387933, 0.08430516, \
0.08473196, 0.08515974, 0.08558849, 0.08601823, 0.08644893, \
0.08688061, 0.08731327, 0.08774689, 0.08818148, 0.08861705, \
0.08905358, 0.08949108, 0.08992955, 0.09036898, 0.09080938, \
0.09125074, 0.09169306, 0.09213634, 0.09258059, 0.09302579, \
0.09347195, 0.09391907, 0.09436714, 0.09481617, 0.09526615, \
0.09571709, 0.09616898, 0.09662182, 0.09707560, 0.09753034, \
0.09798602, 0.09844265, 0.09890023, 0.09935875, 0.09981821, \
0.10027862, 0.10073996, 0.10120225, 0.10166548, 0.10212964, \
0.10259474, 0.10306077, 0.10352774, 0.10399565, 0.10446448, \
0.10493425, 0.10540495, 0.10587657, 0.10634913, 0.10682261, \
0.10729701, 0.10777234, 0.10824860, 0.10872577, 0.10920387, \
0.10968289, 0.11016282, 0.11064368, 0.11112545, 0.11160813, \
0.11209173, 0.11257625, 0.11306167, 0.11354801, 0.11403526, \
0.11452341, 0.11501248, 0.11550244, 0.11599332, 0.11648510, \
0.11697778, 0.11747136, 0.11796584, 0.11846123, 0.11895751, \
0.11945469, 0.11995276, 0.12045173, 0.12095159, 0.12145235, \
0.12195399, 0.12245653, 0.12295995, 0.12346427, 0.12396947, \
0.12447555, 0.12498252, 0.12549037, 0.12599910, 0.12650872, \
0.12701921, 0.12753058, 0.12804283, 0.12855595, 0.12906995, \
0.12958482, 0.13010056, 0.13061718, 0.13113466, 0.13165301, \
0.13217223, 0.13269232, 0.13321327, 0.13373508, 0.13425775, \
0.13478129, 0.13530569, 0.13583094, 0.13635705, 0.13688402, \
0.13741185, 0.13794052, 0.13847005, 0.13900043, 0.13953166, \
0.14006374, 0.14059667, 0.14113044, 0.14166506, 0.14220052, \
0.14273682, 0.14327397, 0.14381195, 0.14435077, 0.14489043, \
0.14543093, 0.14597226, 0.14651443, 0.14705742, 0.14760125, \
0.14814591, 0.14869139, 0.14923770, 0.14978484, 0.15033281, \
0.15088159, 0.15143120, 0.15198163, 0.15253287, 0.15308494, \
0.15363782, 0.15419152, 0.15474603, 0.15530136, 0.15585749, \
0.15641444, 0.15697220, 0.15753076, 0.15809013, 0.15865030, \
0.15921128, 0.15977306, 0.16033564, 0.16089902, 0.16146320, \
0.16202818, 0.16259395, 0.16316052, 0.16372787, 0.16429603, \
0.16486497, 0.16543470, 0.16600521, 0.16657652, 0.16714861, \
0.16772148, 0.16829514, 0.16886957, 0.16944479, 0.17002078, \
0.17059755, 0.17117510, 0.17175342, 0.17233251, 0.17291237, \
0.17349301, 0.17407441, 0.17465658, 0.17523952, 0.17582322, \
0.17640768, 0.17699291, 0.17757889, 0.17816564, 0.17875314, \
0.17934140, 0.17993042, 0.18052018, 0.18111070, 0.18170197, \
0.18229399, 0.18288676, 0.18348028, 0.18407454, 0.18466954, \
0.18526528, 0.18586177, 0.18645900, 0.18705696, 0.18765566, \
0.18825510, 0.18885527, 0.18945617, 0.19005781, 0.19066017, \
0.19126326, 0.19186708, 0.19247163, 0.19307689, 0.19368288, \
0.19428960, 0.19489703, 0.19550518, 0.19611404, 0.19672363, \
0.19733392, 0.19794493, 0.19855665, 0.19916908, 0.19978222, \
0.20039606, 0.20101061, 0.20162587, 0.20224182, 0.20285848, \
0.20347584, 0.20409389, 0.20471264, 0.20533209, 0.20595223, \
0.20657306, 0.20719459, 0.20781680, 0.20843970, 0.20906329, \
0.20968756, 0.21031251, 0.21093815, 0.21156447, 0.21219147, \
0.21281914, 0.21344749, 0.21407652, 0.21470622, 0.21533659, \
0.21596763, 0.21659934, 0.21723171, 0.21786475, 0.21849846, \
0.21913283, 0.21976786, 0.22040355, 0.22103990, 0.22167690, \
0.22231456, 0.22295287, 0.22359184, 0.22423146, 0.22487172, \
0.22551264, 0.22615420, 0.22679640, 0.22743925, 0.22808274, \
0.22872687, 0.22937164, 0.23001704, 0.23066308, 0.23130976, \
0.23195707, 0.23260500, 0.23325357, 0.23390277, 0.23455259, \
0.23520304, 0.23585411, 0.23650580, 0.23715812, 0.23781105, \
0.23846460, 0.23911876, 0.23977354, 0.24042893, 0.24108493, \
0.24174155, 0.24239877, 0.24305659, 0.24371503, 0.24437406, \
0.24503370, 0.24569393, 0.24635477, 0.24701620, 0.24767823, \
0.24834085, 0.24900407, 0.24966788, 0.25033227, 0.25099725, \
0.25166282, 0.25232898, 0.25299571, 0.25366303, 0.25433093, \
0.25499941, 0.25566846, 0.25633809, 0.25700829, 0.25767907, \
0.25835041, 0.25902233, 0.25969481, 0.26036786, 0.26104147, \
0.26171564, 0.26239037, 0.26306567, 0.26374152, 0.26441793, \
0.26509489, 0.26577241, 0.26645047, 0.26712909, 0.26780826, \
0.26848797, 0.26916823, 0.26984903, 0.27053037, 0.27121225, \
0.27189467, 0.27257763, 0.27326112, 0.27394515, 0.27462971, \
0.27531480, 0.27600042, 0.27668656, 0.27737324, 0.27806043, \
0.27874815, 0.27943639, 0.28012515, 0.28081443, 0.28150422, \
0.28219453, 0.28288535, 0.28357668, 0.28426852, 0.28496086, \
0.28565372, 0.28634708, 0.28704094, 0.28773530, 0.28843017, \
0.28912553, 0.28982139, 0.29051774, 0.29121458, 0.29191192, \
0.29260975, 0.29330806, 0.29400687, 0.29470615, 0.29540592, \
0.29610617, 0.29680691, 0.29750812, 0.29820980, 0.29891197, \
0.29961460, 0.30031771, 0.30102129, 0.30172533, 0.30242984, \
0.30313482, 0.30384026, 0.30454617, 0.30525253, 0.30595935, \
0.30666663, 0.30737436, 0.30808255, 0.30879119, 0.30950028, \
0.31020981, 0.31091980, 0.31163023, 0.31234110, 0.31305242, \
0.31376417, 0.31447636, 0.31518899, 0.31590206, 0.31661556, \
0.31732949, 0.31804385, 0.31875864, 0.31947385, 0.32018949, \
0.32090556, 0.32162204, 0.32233895, 0.32305627, 0.32377401, \
0.32449217, 0.32521073, 0.32592971, 0.32664910, 0.32736890, \
0.32808910, 0.32880971, 0.32953072, 0.33025214, 0.33097395, \
0.33169616, 0.33241877, 0.33314177, 0.33386516, 0.33458895, \
0.33531312, 0.33603769, 0.33676263, 0.33748797, 0.33821368, \
0.33893978, 0.33966625, 0.34039311, 0.34112034, 0.34184794, \
0.34257591, 0.34330426, 0.34403297, 0.34476206, 0.34549150, \
0.34622131, 0.34695149, 0.34768202, 0.34841291, 0.34914416, \
0.34987576, 0.35060772, 0.35134003, 0.35207269, 0.35280570, \
0.35353905, 0.35427275, 0.35500679, 0.35574117, 0.35647590, \
0.35721096, 0.35794635, 0.35868209, 0.35941815, 0.36015454, \
0.36089127, 0.36162832, 0.36236570, 0.36310340, 0.36384142, \
0.36457977, 0.36531843, 0.36605741, 0.36679670, 0.36753631, \
0.36827623, 0.36901647, 0.36975700, 0.37049785, 0.37123900, \
0.37198045, 0.37272221, 0.37346427, 0.37420662, 0.37494927, \
0.37569221, 0.37643545, 0.37717897, 0.37792279, 0.37866689, \
0.37941128, 0.38015596, 0.38090091, 0.38164615, 0.38239166, \
0.38313745, 0.38388352, 0.38462986, 0.38537647, 0.38612335, \
0.38687050, 0.38761791, 0.38836559, 0.38911354, 0.38986174, \
0.39061020, 0.39135893, 0.39210790, 0.39285713, 0.39360661, \
0.39435635, 0.39510633, 0.39585656, 0.39660703, 0.39735775, \
0.39810871, 0.39885991, 0.39961135, 0.40036302, 0.40111493, \
0.40186707, 0.40261944, 0.40337204, 0.40412487, 0.40487792, \
0.40563120, 0.40638470, 0.40713842, 0.40789236, 0.40864652, \
0.40940089, 0.41015548, 0.41091027, 0.41166528, 0.41242049, \
0.41317591, 0.41393154, 0.41468736, 0.41544339, 0.41619962, \
0.41695604, 0.41771266, 0.41846948, 0.41922648, 0.41998368, \
0.42074106, 0.42149863, 0.42225639, 0.42301432, 0.42377244, \
0.42453074, 0.42528922, 0.42604787, 0.42680670, 0.42756570, \
0.42832487, 0.42908421, 0.42984371, 0.43060338, 0.43136322, \
0.43212321, 0.43288337, 0.43364368, 0.43440415, 0.43516477, \
0.43592555, 0.43668648, 0.43744755, 0.43820878, 0.43897015, \
0.43973166, 0.44049331, 0.44125511, 0.44201704, 0.44277911, \
0.44354132, 0.44430365, 0.44506612, 0.44582872, 0.44659145, \
0.44735430, 0.44811727, 0.44888037, 0.44964359, 0.45040692, \
0.45117037, 0.45193394, 0.45269762, 0.45346142, 0.45422532, \
0.45498933, 0.45575344, 0.45651766, 0.45728198, 0.45804641, \
0.45881093, 0.45957555, 0.46034026, 0.46110507, 0.46186996, \
0.46263495, 0.46340003, 0.46416519, 0.46493044, 0.46569577, \
0.46646118, 0.46722667, 0.46799223, 0.46875787, 0.46952359, \
0.47028938, 0.47105523, 0.47182116, 0.47258715, 0.47335321, \
0.47411932, 0.47488550, 0.47565174, 0.47641804, 0.47718439, \
0.47795079, 0.47871725, 0.47948376, 0.48025031, 0.48101692, \
0.48178356, 0.48255025, 0.48331698, 0.48408375, 0.48485056, \
0.48561740, 0.48638428, 0.48715119, 0.48791813, 0.48868509, \
0.48945209, 0.49021911, 0.49098615, 0.49175321, 0.49252030, \
0.49328740, 0.49405451, 0.49482164, 0.49558879, 0.49635594, \
0.49712310, 0.49789027, 0.49865744, 0.49942462, 0.50019179, \
0.50095897, 0.50172615, 0.50249332, 0.50326048, 0.50402764, \
0.50479479, 0.50556192, 0.50632905, 0.50709616, 0.50786325, \
0.50863032, 0.50939737, 0.51016440, 0.51093141, 0.51169839, \
0.51246535, 0.51323227, 0.51399916, 0.51476602, 0.51553285, \
0.51629964, 0.51706639, 0.51783310, 0.51859977, 0.51936639, \
0.52013297, 0.52089950, 0.52166598, 0.52243242, 0.52319879, \
0.52396512, 0.52473138, 0.52549759, 0.52626374, 0.52702983, \
0.52779585, 0.52856181, 0.52932770, 0.53009353, 0.53085928, \
0.53162496, 0.53239056, 0.53315609, 0.53392154, 0.53468691, \
0.53545220, 0.53621740, 0.53698252, 0.53774755, 0.53851250, \
0.53927735, 0.54004211, 0.54080678, 0.54157135, 0.54233582, \
0.54310019, 0.54386446, 0.54462863, 0.54539269, 0.54615665, \
0.54692049, 0.54768423, 0.54844786, 0.54921137, 0.54997476, \
0.55073804, 0.55150120, 0.55226423, 0.55302714, 0.55378993, \
0.55455259, 0.55531513, 0.55607753, 0.55683980, 0.55760194, \
0.55836394, 0.55912581, 0.55988753, 0.56064911, 0.56141056, \
0.56217185, 0.56293300, 0.56369400, 0.56445486, 0.56521556, \
0.56597610, 0.56673650, 0.56749673, 0.56825681, 0.56901672, \
0.56977647, 0.57053606, 0.57129548, 0.57205474, 0.57281382, \
0.57357274, 0.57433148, 0.57509004, 0.57584843, 0.57660664, \
0.57736467, 0.57812251, 0.57888018, 0.57963766, 0.58039495, \
0.58115205, 0.58190896, 0.58266567, 0.58342219, 0.58417852, \
0.58493465, 0.58569058, 0.58644630, 0.58720182, 0.58795714, \
0.58871225, 0.58946715, 0.59022184, 0.59097632, 0.59173059, \
0.59248463, 0.59323846, 0.59399208, 0.59474546, 0.59549863, \
0.59625157, 0.59700429, 0.59775677, 0.59850903, 0.59926106, \
0.60001285, 0.60076440, 0.60151572, 0.60226680, 0.60301764, \
0.60376823, 0.60451859, 0.60526869, 0.60601855, 0.60676816, \
0.60751751, 0.60826662, 0.60901547, 0.60976406, 0.61051239, \
0.61126047, 0.61200828, 0.61275583, 0.61350311, 0.61425012, \
0.61499687, 0.61574335, 0.61648955, 0.61723548, 0.61798113, \
0.61872651, 0.61947160, 0.62021642, 0.62096095, 0.62170519, \
0.62244915, 0.62319283, 0.62393621, 0.62467930, 0.62542209, \
0.62616460, 0.62690680, 0.62764870, 0.62839031, 0.62913161, \
0.62987261, 0.63061330, 0.63135369, 0.63209377, 0.63283353, \
0.63357298, 0.63431212, 0.63505094, 0.63578945, 0.63652763, \
0.63726549, 0.63800303, 0.63874025, 0.63947714, 0.64021369, \
0.64094992, 0.64168582, 0.64242139, 0.64315661, 0.64389151, \
0.64462606, 0.64536027, 0.64609414, 0.64682767, 0.64756085, \
0.64829368, 0.64902617, 0.64975830, 0.65049008, 0.65122151, \
0.65195258, 0.65268329, 0.65341364, 0.65414364, 0.65487327, \
0.65560253, 0.65633143, 0.65705996, 0.65778812, 0.65851591, \
0.65924333, 0.65997037, 0.66069703, 0.66142332, 0.66214922, \
0.66287475, 0.66359989, 0.66432464, 0.66504901, 0.66577299, \
0.66649658, 0.66721978, 0.66794258, 0.66866499, 0.66938701, \
0.67010862, 0.67082983, 0.67155064, 0.67227105, 0.67299105, \
0.67371064, 0.67442983, 0.67514860, 0.67586696, 0.67658491, \
0.67730244, 0.67801956, 0.67873625, 0.67945253, 0.68016838, \
0.68088381, 0.68159881, 0.68231339, 0.68302753, 0.68374125, \
0.68445453, 0.68516738, 0.68587979, 0.68659176, 0.68730330, \
0.68801439, 0.68872504, 0.68943525, 0.69014501, 0.69085432, \
0.69156319, 0.69227160, 0.69297956, 0.69368707, 0.69439412, \
0.69510071, 0.69580684, 0.69651252, 0.69721773, 0.69792247, \
0.69862675, 0.69933056, 0.70003390, 0.70073678, 0.70143917, \
0.70214110, 0.70284255, 0.70354352, 0.70424401, 0.70494402, \
0.70564355, 0.70634260, 0.70704116, 0.70773923, 0.70843681, \
0.70913390, 0.70983050, 0.71052660, 0.71122221, 0.71191733, \
0.71261194, 0.71330605, 0.71399966, 0.71469277, 0.71538537, \
0.71607747, 0.71676905, 0.71746013, 0.71815069, 0.71884074, \
0.71953028, 0.72021929, 0.72090779, 0.72159577, 0.72228323, \
0.72297016, 0.72365657, 0.72434246, 0.72502781, 0.72571264, \
0.72639693, 0.72708069, 0.72776392, 0.72844661, 0.72912876, \
0.72981037, 0.73049144, 0.73117197, 0.73185196, 0.73253139, \
0.73321029, 0.73388863, 0.73456642, 0.73524366, 0.73592034, \
0.73659647, 0.73727205, 0.73794706, 0.73862152, 0.73929541, \
0.73996874, 0.74064150, 0.74131370, 0.74198533, 0.74265639, \
0.74332688, 0.74399680, 0.74466614, 0.74533490, 0.74600309, \
0.74667070, 0.74733773, 0.74800417, 0.74867003, 0.74933531, \
0.75000000, 0.75066410, 0.75132761, 0.75199053, 0.75265286, \
0.75331459, 0.75397572, 0.75463626, 0.75529620, 0.75595553, \
0.75661427, 0.75727239, 0.75792992, 0.75858684, 0.75924314, \
0.75989884, 0.76055393, 0.76120840, 0.76186226, 0.76251550, \
0.76316812, 0.76382012, 0.76447150, 0.76512226, 0.76577240, \
0.76642191, 0.76707079, 0.76771904, 0.76836667, 0.76901366, \
0.76966002, 0.77030574, 0.77095083, 0.77159528, 0.77223909, \
0.77288226, 0.77352478, 0.77416666, 0.77480790, 0.77544849, \
0.77608843, 0.77672772, 0.77736636, 0.77800435, 0.77864168, \
0.77927836, 0.77991438, 0.78054974, 0.78118444, 0.78181848, \
0.78245185, 0.78308456, 0.78371660, 0.78434798, 0.78497868, \
0.78560872, 0.78623808, 0.78686677, 0.78749478, 0.78812212, \
0.78874877, 0.78937475, 0.79000005, 0.79062466, 0.79124859, \
0.79187184, 0.79249439, 0.79311626, 0.79373744, 0.79435793, \
0.79497772, 0.79559682, 0.79621522, 0.79683293, 0.79744994, \
0.79806624, 0.79868185, 0.79929675, 0.79991095, 0.80052444, \
0.80113722, 0.80174930, 0.80236066, 0.80297131, 0.80358125, \
0.80419048, 0.80479899, 0.80540678, 0.80601385, 0.80662020, \
0.80722583, 0.80783074, 0.80843492, 0.80903837, 0.80964110, \
0.81024310, 0.81084437, 0.81144491, 0.81204471, 0.81264378, \
0.81324211, 0.81383971, 0.81443657, 0.81503268, 0.81562806, \
0.81622269, 0.81681657, 0.81740972, 0.81800211, 0.81859376, \
0.81918465, 0.81977480, 0.82036419, 0.82095282, 0.82154070, \
0.82212783, 0.82271419, 0.82329980, 0.82388465, 0.82446873, \
0.82505205, 0.82563460, 0.82621639, 0.82679741, 0.82737766, \
0.82795713, 0.82853584, 0.82911377, 0.82969093, 0.83026731, \
0.83084292, 0.83141774, 0.83199179, 0.83256505, 0.83313753, \
0.83370923, 0.83428014, 0.83485027, 0.83541960, 0.83598815, \
0.83655590, 0.83712287, 0.83768904, 0.83825441, 0.83881899, \
0.83938277, 0.83994575, 0.84050793, 0.84106931, 0.84162988, \
0.84218966, 0.84274862, 0.84330678, 0.84386413, 0.84442068, \
0.84497641, 0.84553132, 0.84608543, 0.84663872, 0.84719119, \
0.84774285, 0.84829369, 0.84884371, 0.84939290, 0.84994128, \
0.85048883, 0.85103556, 0.85158145, 0.85212653, 0.85267077, \
0.85321418, 0.85375676, 0.85429851, 0.85483942, 0.85537950, \
0.85591874, 0.85645715, 0.85699471, 0.85753143, 0.85806732, \
0.85860236, 0.85913655, 0.85966990, 0.86020240, 0.86073406, \
0.86126486, 0.86179482, 0.86232392, 0.86285217, 0.86337957, \
0.86390611, 0.86443179, 0.86495662, 0.86548059, 0.86600369, \
0.86652594, 0.86704732, 0.86756784, 0.86808749, 0.86860627, \
0.86912419, 0.86964124, 0.87015742, 0.87067273, 0.87118716, \
0.87170072, 0.87221341, 0.87272522, 0.87323615, 0.87374620, \
0.87425537, 0.87476367, 0.87527108, 0.87577760, 0.87628324, \
0.87678800, 0.87729187, 0.87779485, 0.87829694, 0.87879814, \
0.87929845, 0.87979787, 0.88029639, 0.88079401, 0.88129074, \
0.88178658, 0.88228151, 0.88277554, 0.88326867, 0.88376090, \
0.88425223, 0.88474265, 0.88523217, 0.88572078, 0.88620848, \
0.88669527, 0.88718115, 0.88766612, 0.88815018, 0.88863332, \
0.88911555, 0.88959686, 0.89007726, 0.89055674, 0.89103529, \
0.89151293, 0.89198965, 0.89246544, 0.89294031, 0.89341425, \
0.89388727, 0.89435936, 0.89483052, 0.89530075, 0.89577005, \
0.89623842, 0.89670586, 0.89717236, 0.89763793, 0.89810256, \
0.89856625, 0.89902901, 0.89949083, 0.89995170, 0.90041164, \
0.90087063, 0.90132868, 0.90178578, 0.90224194, 0.90269715, \
0.90315141, 0.90360472, 0.90405709, 0.90450850, 0.90495896, \
0.90540846, 0.90585701, 0.90630461, 0.90675125, 0.90719693, \
0.90764166, 0.90808542, 0.90852822, 0.90897006, 0.90941094, \
0.90985086, 0.91028981, 0.91072779, 0.91116481, 0.91160085, \
0.91203593, 0.91247004, 0.91290318, 0.91333535, 0.91376654, \
0.91419676, 0.91462601, 0.91505427, 0.91548156, 0.91590788, \
0.91633321, 0.91675756, 0.91718094, 0.91760333, 0.91802473, \
0.91844516, 0.91886460, 0.91928305, 0.91970051, 0.92011699, \
0.92053248, 0.92094697, 0.92136048, 0.92177299, 0.92218452, \
0.92259504, 0.92300458, 0.92341311, 0.92382065, 0.92422719, \
0.92463274, 0.92503728, 0.92544082, 0.92584337, 0.92624491, \
0.92664544, 0.92704497, 0.92744350, 0.92784102, 0.92823753, \
0.92863303, 0.92902753, 0.92942101, 0.92981349, 0.93020495, \
0.93059540, 0.93098483, 0.93137325, 0.93176066, 0.93214705, \
0.93253242, 0.93291677, 0.93330011, 0.93368242, 0.93406371, \
0.93444398, 0.93482323, 0.93520146, 0.93557866, 0.93595483, \
0.93632998, 0.93670410, 0.93707719, 0.93744926, 0.93782029, \
0.93819029, 0.93855927, 0.93892720, 0.93929411, 0.93965998, \
0.94002482, 0.94038862, 0.94075138, 0.94111311, 0.94147380, \
0.94183344, 0.94219205, 0.94254962, 0.94290615, 0.94326163, \
0.94361607, 0.94396946, 0.94432181, 0.94467311, 0.94502337, \
0.94537258, 0.94572074, 0.94606785, 0.94641391, 0.94675892, \
0.94710288, 0.94744578, 0.94778764, 0.94812843, 0.94846818, \
0.94880686, 0.94914449, 0.94948107, 0.94981658, 0.95015104, \
0.95048443, 0.95081677, 0.95114804, 0.95147826, 0.95180740, \
0.95213549, 0.95246251, 0.95278847, 0.95311336, 0.95343718, \
0.95375994, 0.95408162, 0.95440224, 0.95472179, 0.95504027, \
0.95535768, 0.95567401, 0.95598927, 0.95630346, 0.95661657, \
0.95692861, 0.95723958, 0.95754946, 0.95785827, 0.95816601, \
0.95847266, 0.95877823, 0.95908273, 0.95938614, 0.95968847, \
0.95998972, 0.96028989, 0.96058897, 0.96088697, 0.96118388, \
0.96147971, 0.96177445, 0.96206811, 0.96236067, 0.96265215, \
0.96294254, 0.96323184, 0.96352005, 0.96380716, 0.96409319, \
0.96437812, 0.96466196, 0.96494470, 0.96522636, 0.96550691, \
0.96578637, 0.96606473, 0.96634200, 0.96661817, 0.96689324, \
0.96716721, 0.96744008, 0.96771185, 0.96798251, 0.96825208, \
0.96852055, 0.96878791, 0.96905416, 0.96931932, 0.96958337, \
0.96984631, 0.97010815, 0.97036888, 0.97062850, 0.97088702, \
0.97114442, 0.97140072, 0.97165591, 0.97190998, 0.97216295, \
0.97241480, 0.97266555, 0.97291518, 0.97316369, 0.97341109, \
0.97365738, 0.97390255, 0.97414661, 0.97438955, 0.97463138, \
0.97487208, 0.97511167, 0.97535014, 0.97558749, 0.97582372, \
0.97605883, 0.97629282, 0.97652569, 0.97675744, 0.97698806, \
0.97721757, 0.97744594, 0.97767320, 0.97789933, 0.97812433, \
0.97834821, 0.97857096, 0.97879259, 0.97901309, 0.97923246, \
0.97945070, 0.97966782, 0.97988380, 0.98009866, 0.98031238, \
0.98052498, 0.98073644, 0.98094677, 0.98115597, 0.98136403, \
0.98157097, 0.98177677, 0.98198143, 0.98218496, 0.98238736, \
0.98258861, 0.98278874, 0.98298772, 0.98318557, 0.98338229, \
0.98357786, 0.98377230, 0.98396559, 0.98415775, 0.98434877, \
0.98453864, 0.98472738, 0.98491497, 0.98510143, 0.98528674, \
0.98547091, 0.98565393, 0.98583582, 0.98601656, 0.98619615, \
0.98637460, 0.98655191, 0.98672807, 0.98690308, 0.98707695, \
0.98724967, 0.98742124, 0.98759167, 0.98776095, 0.98792908, \
0.98809606, 0.98826189, 0.98842657, 0.98859011, 0.98875249, \
0.98891372, 0.98907380, 0.98923273, 0.98939051, 0.98954713, \
0.98970261, 0.98985693, 0.99001009, 0.99016211, 0.99031297, \
0.99046267, 0.99061122, 0.99075862, 0.99090486, 0.99104994, \
0.99119387, 0.99133664, 0.99147826, 0.99161871, 0.99175801, \
0.99189616, 0.99203314, 0.99216897, 0.99230364, 0.99243715, \
0.99256949, 0.99270068, 0.99283071, 0.99295958, 0.99308729, \
0.99321384, 0.99333923, 0.99346345, 0.99358652, 0.99370842, \
0.99382916, 0.99394874, 0.99406715, 0.99418440, 0.99430049, \
0.99441541, 0.99452917, 0.99464177, 0.99475320, 0.99486347, \
0.99497257, 0.99508050, 0.99518727, 0.99529288, 0.99539732, \
0.99550059, 0.99560270, 0.99570363, 0.99580341, 0.99590201, \
0.99599945, 0.99609572, 0.99619082, 0.99628475, 0.99637752, \
0.99646912, 0.99655954, 0.99664880, 0.99673689, 0.99682381, \
0.99690956, 0.99699414, 0.99707755, 0.99715979, 0.99724086, \
0.99732076, 0.99739949, 0.99747705, 0.99755343, 0.99762865, \
0.99770269, 0.99777556, 0.99784726, 0.99791779, 0.99798715, \
0.99805533, 0.99812234, 0.99818818, 0.99825284, 0.99831634, \
0.99837865, 0.99843980, 0.99849977, 0.99855857, 0.99861619, \
0.99867265, 0.99872792, 0.99878203, 0.99883495, 0.99888671, \
0.99893729, 0.99898669, 0.99903492, 0.99908198, 0.99912786, \
0.99917256, 0.99921609, 0.99925845, 0.99929963, 0.99933963, \
0.99937846, 0.99941611, 0.99945259, 0.99948789, 0.99952202, \
0.99955497, 0.99958674, 0.99961734, 0.99964676, 0.99967500, \
0.99970207, 0.99972796, 0.99975268, 0.99977622, 0.99979858, \
0.99981976, 0.99983977, 0.99985860, 0.99987626, 0.99989274, \
0.99990804, 0.99992216, 0.99993511, 0.99994688, 0.99995748, \
0.99996689, 0.99997513, 0.99998220, 0.99998808, 0.99999279, \
0.99999632, 0.99999868, 0.99999985, } 


 #endif // _FPU_FFT_HANN_H_
//=============================================================================
// End of File
//=============================================================================

