//=============================================================================
// Barthann Window 
//=============================================================================
#ifndef _FPU_FFT_BARTHANN_H_
#define _FPU_FFT_BARTHANN_H_

#define BARTHANN32 {\
0.00000000, 0.02326249, 0.06176377, 0.11456151, 0.18012805, \
0.25641303, 0.34092723, 0.43084454, 0.52311765, 0.61460280, \
0.70218849, 0.78292285, 0.85413454, 0.91354204, 0.95934711, \
0.99030841, } 

#define BARTHANN64 {\
0.00000000, 0.00950735, 0.02277255, 0.03973948, 0.06031523, \
0.08437104, 0.11174355, 0.14223644, 0.17562239, 0.21164530, \
0.25002290, 0.29044947, 0.33259898, 0.37612824, 0.42068036, \
0.46588828, 0.51137842, 0.55677442, 0.60170081, 0.64578683, \
0.68867005, 0.73000000, 0.76944164, 0.80667871, 0.84141685, \
0.87338654, 0.90234577, 0.92808246, 0.95041653, 0.96920175, \
0.98432714, 0.99571811, } 

#define BARTHANN128 {\
0.00000000, 0.00424449, 0.00941776, 0.01551641, 0.02253477, \
0.03046489, 0.03929663, 0.04901762, 0.05961333, 0.07106707, \
0.08336006, 0.09647148, 0.11037847, 0.12505626, 0.14047818, \
0.15661574, 0.17343870, 0.19091513, 0.20901152, 0.22769283, \
0.24692260, 0.26666301, 0.28687501, 0.30751838, 0.32855186, \
0.34993321, 0.37161938, 0.39356653, 0.41573021, 0.43806543, \
0.46052677, 0.48306853, 0.50564478, 0.52820954, 0.55071682, \
0.57312080, 0.59537590, 0.61743690, 0.63925908, 0.66079828, \
0.68201103, 0.70285467, 0.72328745, 0.74326861, 0.76275851, \
0.78171869, 0.80011201, 0.81790271, 0.83505650, 0.85154064, \
0.86732405, 0.88237736, 0.89667297, 0.91018515, 0.92289008, \
0.93476593, 0.94579287, 0.95595317, 0.96523122, 0.97361356, \
0.98108893, 0.98764828, 0.99328481, 0.99799398, } 

#define BARTHANN256 {\
0.00000000, 0.00199770, 0.00422603, 0.00668477, 0.00937358, \
0.01229197, 0.01543931, 0.01881482, 0.02241761, 0.02624663, \
0.03030069, 0.03457849, 0.03907856, 0.04379931, 0.04873903, \
0.05389585, 0.05926779, 0.06485273, 0.07064842, 0.07665248, \
0.08286242, 0.08927561, 0.09588930, 0.10270060, 0.10970654, \
0.11690400, 0.12428975, 0.13186045, 0.13961266, 0.14754280, \
0.15564720, 0.16392209, 0.17236359, 0.18096771, 0.18973037, \
0.19864740, 0.20771452, 0.21692738, 0.22628152, 0.23577241, \
0.24539543, 0.25514587, 0.26501897, 0.27500987, 0.28511364, \
0.29532531, 0.30563980, 0.31605200, 0.32655674, 0.33714878, \
0.34782282, 0.35857354, 0.36939555, 0.38028342, 0.39123168, \
0.40223484, 0.41328735, 0.42438364, 0.43551813, 0.44668520, \
0.45787920, 0.46909449, 0.48032540, 0.49156625, 0.50281137, \
0.51405506, 0.52529165, 0.53651546, 0.54772082, 0.55890206, \
0.57005353, 0.58116963, 0.59224473, 0.60327325, 0.61424965, \
0.62516841, 0.63602403, 0.64681107, 0.65752412, 0.66815782, \
0.67870687, 0.68916599, 0.69952998, 0.70979370, 0.71995204, \
0.73000000, 0.73993261, 0.74974498, 0.75943230, 0.76898984, \
0.77841293, 0.78769699, 0.79683753, 0.80583015, 0.81467052, \
0.82335443, 0.83187774, 0.84023643, 0.84842655, 0.85644429, \
0.86428591, 0.87194781, 0.87942646, 0.88671847, 0.89382057, \
0.90072957, 0.90744243, 0.91395622, 0.92026812, 0.92637544, \
0.93227563, 0.93796623, 0.94344494, 0.94870958, 0.95375809, \
0.95858855, 0.96319917, 0.96758829, 0.97175439, 0.97569609, \
0.97941213, 0.98290140, 0.98616293, 0.98919588, 0.99199955, \
0.99457338, 0.99691695, 0.99902999, } 

#define BARTHANN512 {\
0.00000000, 0.00096806, 0.00199357, 0.00307651, 0.00421686, \
0.00541459, 0.00666967, 0.00798204, 0.00935164, 0.01077842, \
0.01226231, 0.01380320, 0.01540103, 0.01705568, 0.01876704, \
0.02053501, 0.02235946, 0.02424025, 0.02617724, 0.02817028, \
0.03021921, 0.03232386, 0.03448406, 0.03669961, 0.03897034, \
0.04129604, 0.04367649, 0.04611148, 0.04860079, 0.05114418, \
0.05374140, 0.05639221, 0.05909634, 0.06185354, 0.06466352, \
0.06752601, 0.07044071, 0.07340732, 0.07642554, 0.07949505, \
0.08261554, 0.08578666, 0.08900809, 0.09227947, 0.09560047, \
0.09897070, 0.10238982, 0.10585744, 0.10937318, 0.11293666, \
0.11654746, 0.12020520, 0.12390946, 0.12765982, 0.13145586, \
0.13529715, 0.13918324, 0.14311369, 0.14708805, 0.15110586, \
0.15516665, 0.15926996, 0.16341530, 0.16760220, 0.17183015, \
0.17609866, 0.18040723, 0.18475534, 0.18914249, 0.19356816, \
0.19803181, 0.20253291, 0.20707092, 0.21164530, 0.21625551, \
0.22090098, 0.22558115, 0.23029546, 0.23504334, 0.23982422, \
0.24463750, 0.24948261, 0.25435896, 0.25926595, 0.26420297, \
0.26916944, 0.27416473, 0.27918823, 0.28423934, 0.28931741, \
0.29442184, 0.29955198, 0.30470722, 0.30988690, 0.31509038, \
0.32031703, 0.32556620, 0.33083723, 0.33612946, 0.34144225, \
0.34677493, 0.35212683, 0.35749728, 0.36288563, 0.36829119, \
0.37371329, 0.37915125, 0.38460439, 0.39007204, 0.39555349, \
0.40104808, 0.40655510, 0.41207388, 0.41760371, 0.42314390, \
0.42869376, 0.43425259, 0.43981969, 0.44539437, 0.45097591, \
0.45656362, 0.46215680, 0.46775475, 0.47335675, 0.47896210, \
0.48457010, 0.49018005, 0.49579123, 0.50140294, 0.50701447, \
0.51262512, 0.51823419, 0.52384095, 0.52944472, 0.53504478, \
0.54064043, 0.54623096, 0.55181568, 0.55739387, 0.56296485, \
0.56852790, 0.57408233, 0.57962745, 0.58516255, 0.59068693, \
0.59619992, 0.60170081, 0.60718892, 0.61266356, 0.61812403, \
0.62356967, 0.62899979, 0.63441370, 0.63981074, 0.64519022, \
0.65055149, 0.65589386, 0.66121667, 0.66651926, 0.67180098, \
0.67706116, 0.68229915, 0.68751430, 0.69270596, 0.69787350, \
0.70301626, 0.70813363, 0.71322496, 0.71828963, 0.72332701, \
0.72833648, 0.73331744, 0.73826926, 0.74319134, 0.74808308, \
0.75294389, 0.75777316, 0.76257031, 0.76733476, 0.77206593, \
0.77676324, 0.78142613, 0.78605404, 0.79064640, 0.79520267, \
0.79972229, 0.80420473, 0.80864945, 0.81305593, 0.81742363, \
0.82175203, 0.82604064, 0.83028893, 0.83449641, 0.83866259, \
0.84278698, 0.84686909, 0.85090845, 0.85490459, 0.85885705, \
0.86276538, 0.86662912, 0.87044784, 0.87422109, 0.87794846, \
0.88162951, 0.88526383, 0.88885102, 0.89239068, 0.89588241, \
0.89932582, 0.90272055, 0.90606621, 0.90936244, 0.91260889, \
0.91580521, 0.91895106, 0.92204610, 0.92509000, 0.92808246, \
0.93102315, 0.93391178, 0.93674805, 0.93953167, 0.94226237, \
0.94493988, 0.94756393, 0.95013426, 0.95265064, 0.95511282, \
0.95752057, 0.95987367, 0.96217191, 0.96441507, 0.96660298, \
0.96873542, 0.97081223, 0.97283324, 0.97479827, 0.97670718, \
0.97855981, 0.98035604, 0.98209572, 0.98377875, 0.98540500, \
0.98697437, 0.98848677, 0.98994211, 0.99134031, 0.99268131, \
0.99396504, 0.99519145, 0.99636049, 0.99747214, 0.99852637, \
0.99952315, } 

#define BARTHANN1024 {\
0.00000000, 0.00047638, 0.00096709, 0.00147213, 0.00199151, \
0.00252521, 0.00307325, 0.00363561, 0.00421229, 0.00480329, \
0.00540860, 0.00602822, 0.00666214, 0.00731036, 0.00797286, \
0.00864965, 0.00934071, 0.01004604, 0.01076562, 0.01149945, \
0.01224752, 0.01300982, 0.01378633, 0.01457705, 0.01538195, \
0.01620104, 0.01703429, 0.01788170, 0.01874324, 0.01961891, \
0.02050868, 0.02141255, 0.02233049, 0.02326249, 0.02420854, \
0.02516860, 0.02614267, 0.02713073, 0.02813275, 0.02914872, \
0.03017862, 0.03122241, 0.03228010, 0.03335164, 0.03443702, \
0.03553621, 0.03664920, 0.03777595, 0.03891644, 0.04007065, \
0.04123855, 0.04242011, 0.04361531, 0.04482412, 0.04604652, \
0.04728246, 0.04853193, 0.04979490, 0.05107133, 0.05236120, \
0.05366447, 0.05498111, 0.05631109, 0.05765439, 0.05901095, \
0.06038076, 0.06176377, 0.06315996, 0.06456929, 0.06599172, \
0.06742721, 0.06887574, 0.07033726, 0.07181173, 0.07329912, \
0.07479939, 0.07631251, 0.07783842, 0.07937710, 0.08092849, \
0.08249257, 0.08406928, 0.08565860, 0.08726046, 0.08887484, \
0.09050169, 0.09214096, 0.09379262, 0.09545661, 0.09713289, \
0.09882142, 0.10052215, 0.10223503, 0.10396002, 0.10569707, \
0.10744613, 0.10920715, 0.11098009, 0.11276489, 0.11456151, \
0.11636989, 0.11818999, 0.12002175, 0.12186512, 0.12372006, \
0.12558650, 0.12746440, 0.12935370, 0.13125435, 0.13316630, \
0.13508948, 0.13702385, 0.13896936, 0.14092593, 0.14289353, \
0.14487209, 0.14686155, 0.14886186, 0.15087297, 0.15289480, \
0.15492731, 0.15697043, 0.15902410, 0.16108828, 0.16316288, \
0.16524787, 0.16734316, 0.16944871, 0.17156445, 0.17369031, \
0.17582624, 0.17797218, 0.18012805, 0.18229381, 0.18446937, \
0.18665468, 0.18884968, 0.19105429, 0.19326845, 0.19549210, \
0.19772518, 0.19996760, 0.20221932, 0.20448025, 0.20675033, \
0.20902950, 0.21131769, 0.21361482, 0.21592083, 0.21823565, \
0.22055921, 0.22289144, 0.22523227, 0.22758163, 0.22993945, \
0.23230565, 0.23468016, 0.23706292, 0.23945386, 0.24185288, \
0.24425994, 0.24667495, 0.24909783, 0.25152853, 0.25396695, \
0.25641303, 0.25886669, 0.26132787, 0.26379647, 0.26627243, \
0.26875567, 0.27124612, 0.27374370, 0.27624833, 0.27875993, \
0.28127844, 0.28380376, 0.28633583, 0.28887457, 0.29141989, \
0.29397173, 0.29652999, 0.29909461, 0.30166550, 0.30424259, \
0.30682579, 0.30941502, 0.31201021, 0.31461128, 0.31721814, \
0.31983071, 0.32244891, 0.32507267, 0.32770190, 0.33033651, \
0.33297644, 0.33562158, 0.33827188, 0.34092723, 0.34358756, \
0.34625279, 0.34892283, 0.35159760, 0.35427702, 0.35696100, \
0.35964946, 0.36234232, 0.36503948, 0.36774088, 0.37044642, \
0.37315602, 0.37586960, 0.37858707, 0.38130834, 0.38403333, \
0.38676196, 0.38949414, 0.39222979, 0.39496881, 0.39771113, \
0.40045665, 0.40320530, 0.40595699, 0.40871162, 0.41146912, \
0.41422940, 0.41699237, 0.41975794, 0.42252603, 0.42529655, \
0.42806942, 0.43084454, 0.43362184, 0.43640121, 0.43918259, \
0.44196587, 0.44475098, 0.44753782, 0.45032631, 0.45311636, \
0.45590788, 0.45870078, 0.46149498, 0.46429039, 0.46708692, \
0.46988449, 0.47268300, 0.47548237, 0.47828251, 0.48108333, \
0.48388474, 0.48668667, 0.48948901, 0.49229168, 0.49509459, \
0.49789765, 0.50070078, 0.50350389, 0.50630689, 0.50910970, \
0.51191221, 0.51471435, 0.51751603, 0.52031716, 0.52311765, \
0.52591742, 0.52871637, 0.53151442, 0.53431148, 0.53710746, \
0.53990228, 0.54269584, 0.54548806, 0.54827886, 0.55106814, \
0.55385581, 0.55664180, 0.55942600, 0.56220834, 0.56498873, \
0.56776708, 0.57054330, 0.57331730, 0.57608901, 0.57885833, \
0.58162517, 0.58438945, 0.58715108, 0.58990998, 0.59266606, \
0.59541923, 0.59816941, 0.60091650, 0.60366044, 0.60640112, \
0.60913846, 0.61187239, 0.61460280, 0.61732962, 0.62005277, \
0.62277215, 0.62548768, 0.62819928, 0.63090686, 0.63361034, \
0.63630963, 0.63900466, 0.64169533, 0.64438156, 0.64706327, \
0.64974037, 0.65241279, 0.65508043, 0.65774322, 0.66040107, \
0.66305391, 0.66570164, 0.66834418, 0.67098146, 0.67361340, \
0.67623990, 0.67886089, 0.68147629, 0.68408601, 0.68668999, \
0.68928812, 0.69188034, 0.69446657, 0.69704672, 0.69962072, \
0.70218849, 0.70474994, 0.70730500, 0.70985359, 0.71239563, \
0.71493104, 0.71745975, 0.71998167, 0.72249674, 0.72500487, \
0.72750598, 0.73000000, 0.73248685, 0.73496647, 0.73743876, \
0.73990365, 0.74236108, 0.74481096, 0.74725322, 0.74968779, \
0.75211459, 0.75453355, 0.75694459, 0.75934764, 0.76174263, \
0.76412948, 0.76650813, 0.76887850, 0.77124052, 0.77359411, \
0.77593921, 0.77827575, 0.78060365, 0.78292285, 0.78523328, \
0.78753486, 0.78982753, 0.79211121, 0.79438585, 0.79665137, \
0.79890770, 0.80115478, 0.80339253, 0.80562090, 0.80783982, \
0.81004922, 0.81224903, 0.81443919, 0.81661963, 0.81879030, \
0.82095112, 0.82310203, 0.82524298, 0.82737388, 0.82949469, \
0.83160534, 0.83370577, 0.83579592, 0.83787572, 0.83994512, \
0.84200405, 0.84405246, 0.84609028, 0.84811745, 0.85013393, \
0.85213964, 0.85413454, 0.85611856, 0.85809164, 0.86005373, \
0.86200478, 0.86394473, 0.86587351, 0.86779109, 0.86969739, \
0.87159237, 0.87347598, 0.87534816, 0.87720885, 0.87905801, \
0.88089559, 0.88272152, 0.88453577, 0.88633828, 0.88812899, \
0.88990787, 0.89167485, 0.89342990, 0.89517296, 0.89690398, \
0.89862292, 0.90032974, 0.90202437, 0.90370678, 0.90537692, \
0.90703475, 0.90868022, 0.91031329, 0.91193391, 0.91354204, \
0.91513763, 0.91672065, 0.91829105, 0.91984879, 0.92139383, \
0.92292613, 0.92444565, 0.92595235, 0.92744619, 0.92892712, \
0.93039513, 0.93185015, 0.93329217, 0.93472113, 0.93613702, \
0.93753978, 0.93892938, 0.94030580, 0.94166899, 0.94301892, \
0.94435556, 0.94567888, 0.94698884, 0.94828541, 0.94956856, \
0.95083827, 0.95209449, 0.95333720, 0.95456638, 0.95578198, \
0.95698399, 0.95817238, 0.95934711, 0.96050817, 0.96165552, \
0.96278915, 0.96390902, 0.96501511, 0.96610740, 0.96718587, \
0.96825048, 0.96930122, 0.97033807, 0.97136101, 0.97237000, \
0.97336505, 0.97434611, 0.97531318, 0.97626624, 0.97720526, \
0.97813024, 0.97904114, 0.97993797, 0.98082069, 0.98168930, \
0.98254377, 0.98338410, 0.98421027, 0.98502227, 0.98582009, \
0.98660370, 0.98737311, 0.98812829, 0.98886924, 0.98959595, \
0.99030841, 0.99100660, 0.99169053, 0.99236018, 0.99301554, \
0.99365661, 0.99428338, 0.99489585, 0.99549400, 0.99607784, \
0.99664736, 0.99720256, 0.99774343, 0.99826997, 0.99878218, \
0.99928006, 0.99976360, } 

#define BARTHANN2048 {\
0.00000000, 0.00023628, 0.00047614, 0.00071958, 0.00096660, \
0.00121720, 0.00147138, 0.00172914, 0.00199048, 0.00225539, \
0.00252389, 0.00279597, 0.00307162, 0.00335085, 0.00363366, \
0.00392004, 0.00421001, 0.00450354, 0.00480066, 0.00510134, \
0.00540561, 0.00571344, 0.00602485, 0.00633983, 0.00665838, \
0.00698050, 0.00730619, 0.00763545, 0.00796828, 0.00830468, \
0.00864464, 0.00898816, 0.00933525, 0.00968591, 0.01004012, \
0.01039790, 0.01075923, 0.01112413, 0.01149258, 0.01186458, \
0.01224015, 0.01261926, 0.01300193, 0.01338814, 0.01377791, \
0.01417122, 0.01456808, 0.01496849, 0.01537243, 0.01577992, \
0.01619095, 0.01660552, 0.01702362, 0.01744526, 0.01787043, \
0.01829913, 0.01873136, 0.01916712, 0.01960640, 0.02004921, \
0.02049554, 0.02094539, 0.02139876, 0.02185564, 0.02231603, \
0.02277994, 0.02324736, 0.02371828, 0.02419271, 0.02467064, \
0.02515207, 0.02563700, 0.02612542, 0.02661734, 0.02711275, \
0.02761164, 0.02811402, 0.02861989, 0.02912923, 0.02964206, \
0.03015836, 0.03067813, 0.03120137, 0.03172808, 0.03225825, \
0.03279189, 0.03332899, 0.03386954, 0.03441354, 0.03496100, \
0.03551190, 0.03606625, 0.03662403, 0.03718526, 0.03774992, \
0.03831802, 0.03888954, 0.03946449, 0.04004286, 0.04062465, \
0.04120986, 0.04179848, 0.04239051, 0.04298594, 0.04358478, \
0.04418702, 0.04479265, 0.04540168, 0.04601410, 0.04662990, \
0.04724908, 0.04787164, 0.04849757, 0.04912688, 0.04975955, \
0.05039559, 0.05103498, 0.05167773, 0.05232383, 0.05297328, \
0.05362608, 0.05428221, 0.05494168, 0.05560449, 0.05627062, \
0.05694007, 0.05761285, 0.05828894, 0.05896834, 0.05965105, \
0.06033706, 0.06102637, 0.06171898, 0.06241487, 0.06311405, \
0.06381652, 0.06452226, 0.06523127, 0.06594356, 0.06665910, \
0.06737791, 0.06809997, 0.06882528, 0.06955383, 0.07028563, \
0.07102066, 0.07175893, 0.07250042, 0.07324513, 0.07399306, \
0.07474420, 0.07549855, 0.07625610, 0.07701685, 0.07778079, \
0.07854792, 0.07931823, 0.08009172, 0.08086838, 0.08164821, \
0.08243120, 0.08321735, 0.08400665, 0.08479910, 0.08559469, \
0.08639341, 0.08719527, 0.08800025, 0.08880835, 0.08961957, \
0.09043389, 0.09125132, 0.09207185, 0.09289546, 0.09372217, \
0.09455196, 0.09538482, 0.09622076, 0.09705976, 0.09790181, \
0.09874693, 0.09959509, 0.10044629, 0.10130052, 0.10215779, \
0.10301808, 0.10388139, 0.10474771, 0.10561704, 0.10648937, \
0.10736469, 0.10824300, 0.10912430, 0.11000857, 0.11089581, \
0.11178601, 0.11267917, 0.11357528, 0.11447434, 0.11537634, \
0.11628127, 0.11718913, 0.11809991, 0.11901360, 0.11993020, \
0.12084970, 0.12177209, 0.12269737, 0.12362554, 0.12455657, \
0.12549048, 0.12642725, 0.12736687, 0.12830935, 0.12925466, \
0.13020281, 0.13115379, 0.13210759, 0.13306420, 0.13402363, \
0.13498585, 0.13595087, 0.13691868, 0.13788926, 0.13886262, \
0.13983875, 0.14081764, 0.14179928, 0.14278366, 0.14377079, \
0.14476064, 0.14575323, 0.14674852, 0.14774653, 0.14874724, \
0.14975065, 0.15075674, 0.15176552, 0.15277697, 0.15379109, \
0.15480786, 0.15582729, 0.15684936, 0.15787407, 0.15890141, \
0.15993137, 0.16096395, 0.16199913, 0.16303692, 0.16407729, \
0.16512025, 0.16616579, 0.16721389, 0.16826456, 0.16931778, \
0.17037354, 0.17143185, 0.17249269, 0.17355604, 0.17462192, \
0.17569030, 0.17676118, 0.17783455, 0.17891040, 0.17998874, \
0.18106953, 0.18215279, 0.18323850, 0.18432665, 0.18541724, \
0.18651026, 0.18760570, 0.18870354, 0.18980379, 0.19090644, \
0.19201147, 0.19311888, 0.19422867, 0.19534081, 0.19645531, \
0.19757215, 0.19869133, 0.19981284, 0.20093667, 0.20206282, \
0.20319126, 0.20432200, 0.20545503, 0.20659034, 0.20772792, \
0.20886776, 0.21000985, 0.21115419, 0.21230076, 0.21344956, \
0.21460058, 0.21575381, 0.21690924, 0.21806686, 0.21922667, \
0.22038865, 0.22155280, 0.22271911, 0.22388756, 0.22505816, \
0.22623089, 0.22740574, 0.22858270, 0.22976177, 0.23094293, \
0.23212619, 0.23331151, 0.23449891, 0.23568837, 0.23687988, \
0.23807343, 0.23926902, 0.24046663, 0.24166625, 0.24286788, \
0.24407151, 0.24527712, 0.24648472, 0.24769428, 0.24890580, \
0.25011927, 0.25133469, 0.25255204, 0.25377131, 0.25499249, \
0.25621558, 0.25744057, 0.25866744, 0.25989618, 0.26112680, \
0.26235927, 0.26359359, 0.26482975, 0.26606774, 0.26730755, \
0.26854917, 0.26979259, 0.27103780, 0.27228480, 0.27353356, \
0.27478410, 0.27603638, 0.27729041, 0.27854617, 0.27980366, \
0.28106286, 0.28232377, 0.28358637, 0.28485066, 0.28611663, \
0.28738426, 0.28865355, 0.28992448, 0.29119706, 0.29247126, \
0.29374708, 0.29502450, 0.29630353, 0.29758414, 0.29886633, \
0.30015009, 0.30143541, 0.30272228, 0.30401069, 0.30530062, \
0.30659208, 0.30788504, 0.30917951, 0.31047546, 0.31177289, \
0.31307179, 0.31437215, 0.31567396, 0.31697720, 0.31828188, \
0.31958797, 0.32089548, 0.32220438, 0.32351467, 0.32482634, \
0.32613938, 0.32745377, 0.32876951, 0.33008659, 0.33140500, \
0.33272473, 0.33404576, 0.33536809, 0.33669170, 0.33801660, \
0.33934275, 0.34067017, 0.34199883, 0.34332872, 0.34465984, \
0.34599217, 0.34732571, 0.34866044, 0.34999636, 0.35133344, \
0.35267169, 0.35401110, 0.35535164, 0.35669332, 0.35803611, \
0.35938002, 0.36072503, 0.36207112, 0.36341830, 0.36476654, \
0.36611585, 0.36746620, 0.36881758, 0.37017000, 0.37152343, \
0.37287786, 0.37423330, 0.37558971, 0.37694710, 0.37830545, \
0.37966476, 0.38102500, 0.38238618, 0.38374828, 0.38511129, \
0.38647520, 0.38784000, 0.38920568, 0.39057222, 0.39193962, \
0.39330787, 0.39467695, 0.39604686, 0.39741758, 0.39878911, \
0.40016143, 0.40153453, 0.40290840, 0.40428304, 0.40565842, \
0.40703454, 0.40841139, 0.40978896, 0.41116724, 0.41254621, \
0.41392586, 0.41530619, 0.41668719, 0.41806884, 0.41945113, \
0.42083405, 0.42221759, 0.42360174, 0.42498649, 0.42637183, \
0.42775774, 0.42914423, 0.43053126, 0.43191885, 0.43330696, \
0.43469560, 0.43608475, 0.43747440, 0.43886454, 0.44025516, \
0.44164625, 0.44303780, 0.44442979, 0.44582222, 0.44721508, \
0.44860835, 0.45000202, 0.45139608, 0.45279052, 0.45418534, \
0.45558051, 0.45697603, 0.45837189, 0.45976808, 0.46116458, \
0.46256139, 0.46395849, 0.46535587, 0.46675352, 0.46815144, \
0.46954960, 0.47094801, 0.47234664, 0.47374549, 0.47514454, \
0.47654379, 0.47794323, 0.47934283, 0.48074260, 0.48214252, \
0.48354258, 0.48494277, 0.48634307, 0.48774349, 0.48914400, \
0.49054459, 0.49194526, 0.49334600, 0.49474678, 0.49614761, \
0.49754846, 0.49894934, 0.50035022, 0.50175110, 0.50315197, \
0.50455281, 0.50595362, 0.50735438, 0.50875508, 0.51015571, \
0.51155627, 0.51295673, 0.51435709, 0.51575734, 0.51715747, \
0.51855746, 0.51995730, 0.52135699, 0.52275651, 0.52415586, \
0.52555501, 0.52695396, 0.52835270, 0.52975122, 0.53114951, \
0.53254755, 0.53394534, 0.53534286, 0.53674010, 0.53813705, \
0.53953371, 0.54093005, 0.54232608, 0.54372177, 0.54511712, \
0.54651211, 0.54790675, 0.54930100, 0.55069487, 0.55208834, \
0.55348140, 0.55487405, 0.55626626, 0.55765803, 0.55904935, \
0.56044021, 0.56183059, 0.56322049, 0.56460989, 0.56599878, \
0.56738716, 0.56877501, 0.57016232, 0.57154908, 0.57293528, \
0.57432091, 0.57570596, 0.57709041, 0.57847426, 0.57985749, \
0.58124010, 0.58262207, 0.58400339, 0.58538406, 0.58676405, \
0.58814337, 0.58952199, 0.59089991, 0.59227712, 0.59365361, \
0.59502937, 0.59640438, 0.59777863, 0.59915212, 0.60052483, \
0.60189675, 0.60326788, 0.60463819, 0.60600769, 0.60737636, \
0.60874418, 0.61011116, 0.61147727, 0.61284251, 0.61420686, \
0.61557033, 0.61693288, 0.61829452, 0.61965524, 0.62101501, \
0.62237384, 0.62373172, 0.62508862, 0.62644454, 0.62779948, \
0.62915341, 0.63050634, 0.63185824, 0.63320911, 0.63455894, \
0.63590771, 0.63725542, 0.63860206, 0.63994761, 0.64129207, \
0.64263543, 0.64397766, 0.64531877, 0.64665875, 0.64799758, \
0.64933525, 0.65067175, 0.65200707, 0.65334121, 0.65467415, \
0.65600587, 0.65733638, 0.65866566, 0.65999370, 0.66132048, \
0.66264601, 0.66397026, 0.66529324, 0.66661492, 0.66793530, \
0.66925437, 0.67057211, 0.67188853, 0.67320360, 0.67451731, \
0.67582967, 0.67714065, 0.67845025, 0.67975845, 0.68106525, \
0.68237064, 0.68367460, 0.68497713, 0.68627821, 0.68757784, \
0.68887601, 0.69017270, 0.69146791, 0.69276163, 0.69405384, \
0.69534453, 0.69663371, 0.69792135, 0.69920744, 0.70049198, \
0.70177496, 0.70305636, 0.70433618, 0.70561441, 0.70689103, \
0.70816605, 0.70943943, 0.71071119, 0.71198130, 0.71324977, \
0.71451657, 0.71578170, 0.71704514, 0.71830690, 0.71956696, \
0.72082530, 0.72208193, 0.72333682, 0.72458998, 0.72584139, \
0.72709104, 0.72833892, 0.72958503, 0.73082935, 0.73207187, \
0.73331258, 0.73455148, 0.73578856, 0.73702380, 0.73825720, \
0.73948874, 0.74071843, 0.74194623, 0.74317216, 0.74439620, \
0.74561834, 0.74683857, 0.74805688, 0.74927326, 0.75048771, \
0.75170020, 0.75291075, 0.75411933, 0.75532593, 0.75653055, \
0.75773318, 0.75893381, 0.76013243, 0.76132903, 0.76252360, \
0.76371613, 0.76490661, 0.76609504, 0.76728141, 0.76846570, \
0.76964791, 0.77082803, 0.77200604, 0.77318195, 0.77435574, \
0.77552741, 0.77669693, 0.77786431, 0.77902954, 0.78019261, \
0.78135351, 0.78251222, 0.78366875, 0.78482308, 0.78597521, \
0.78712512, 0.78827280, 0.78941826, 0.79056148, 0.79170244, \
0.79284115, 0.79397760, 0.79511177, 0.79624365, 0.79737325, \
0.79850054, 0.79962553, 0.80074820, 0.80186855, 0.80298656, \
0.80410224, 0.80521556, 0.80632652, 0.80743512, 0.80854134, \
0.80964518, 0.81074663, 0.81184568, 0.81294232, 0.81403655, \
0.81512835, 0.81621773, 0.81730466, 0.81838914, 0.81947117, \
0.82055074, 0.82162783, 0.82270245, 0.82377457, 0.82484421, \
0.82591133, 0.82697595, 0.82803805, 0.82909762, 0.83015466, \
0.83120915, 0.83226110, 0.83331048, 0.83435730, 0.83540155, \
0.83644322, 0.83748230, 0.83851878, 0.83955266, 0.84058393, \
0.84161259, 0.84263861, 0.84366200, 0.84468275, 0.84570086, \
0.84671630, 0.84772909, 0.84873920, 0.84974664, 0.85075139, \
0.85175345, 0.85275281, 0.85374946, 0.85474340, 0.85573462, \
0.85672312, 0.85770887, 0.85869188, 0.85967215, 0.86064966, \
0.86162440, 0.86259638, 0.86356557, 0.86453199, 0.86549561, \
0.86645644, 0.86741445, 0.86836966, 0.86932205, 0.87027162, \
0.87121835, 0.87216225, 0.87310329, 0.87404149, 0.87497683, \
0.87590930, 0.87683891, 0.87776563, 0.87868947, 0.87961042, \
0.88052847, 0.88144361, 0.88235585, 0.88326516, 0.88417156, \
0.88507502, 0.88597555, 0.88687314, 0.88776778, 0.88865946, \
0.88954819, 0.89043394, 0.89131672, 0.89219653, 0.89307335, \
0.89394717, 0.89481800, 0.89568583, 0.89655064, 0.89741244, \
0.89827122, 0.89912698, 0.89997969, 0.90082937, 0.90167601, \
0.90251960, 0.90336013, 0.90419759, 0.90503199, 0.90586332, \
0.90669157, 0.90751673, 0.90833881, 0.90915778, 0.90997366, \
0.91078643, 0.91159609, 0.91240263, 0.91320605, 0.91400634, \
0.91480350, 0.91559752, 0.91638839, 0.91717612, 0.91796069, \
0.91874210, 0.91952034, 0.92029542, 0.92106732, 0.92183604, \
0.92260158, 0.92336392, 0.92412308, 0.92487903, 0.92563177, \
0.92638131, 0.92712763, 0.92787073, 0.92861061, 0.92934726, \
0.93008067, 0.93081085, 0.93153778, 0.93226147, 0.93298190, \
0.93369908, 0.93441299, 0.93512364, 0.93583102, 0.93653512, \
0.93723595, 0.93793349, 0.93862774, 0.93931870, 0.94000636, \
0.94069072, 0.94137178, 0.94204952, 0.94272396, 0.94339507, \
0.94406286, 0.94472733, 0.94538847, 0.94604627, 0.94670074, \
0.94735186, 0.94799964, 0.94864406, 0.94928514, 0.94992285, \
0.95055721, 0.95118820, 0.95181582, 0.95244006, 0.95306093, \
0.95367843, 0.95429253, 0.95490326, 0.95551059, 0.95611452, \
0.95671506, 0.95731220, 0.95790593, 0.95849626, 0.95908317, \
0.95966667, 0.96024675, 0.96082341, 0.96139665, 0.96196646, \
0.96253284, 0.96309578, 0.96365529, 0.96421136, 0.96476398, \
0.96531316, 0.96585889, 0.96640117, 0.96693999, 0.96747536, \
0.96800727, 0.96853571, 0.96906068, 0.96958219, 0.97010023, \
0.97061479, 0.97112587, 0.97163348, 0.97213760, 0.97263824, \
0.97313539, 0.97362906, 0.97411923, 0.97460590, 0.97508908, \
0.97556876, 0.97604494, 0.97651762, 0.97698679, 0.97745245, \
0.97791460, 0.97837324, 0.97882837, 0.97927997, 0.97972806, \
0.98017263, 0.98061368, 0.98105120, 0.98148519, 0.98191566, \
0.98234260, 0.98276600, 0.98318587, 0.98360221, 0.98401501, \
0.98442426, 0.98482998, 0.98523216, 0.98563079, 0.98602588, \
0.98641742, 0.98680541, 0.98718985, 0.98757074, 0.98794808, \
0.98832186, 0.98869209, 0.98905876, 0.98942188, 0.98978143, \
0.99013743, 0.99048986, 0.99083874, 0.99118404, 0.99152579, \
0.99186397, 0.99219858, 0.99252962, 0.99285710, 0.99318101, \
0.99350134, 0.99381811, 0.99413130, 0.99444092, 0.99474697, \
0.99504945, 0.99534835, 0.99564367, 0.99593542, 0.99622360, \
0.99650819, 0.99678921, 0.99706665, 0.99734052, 0.99761080, \
0.99787751, 0.99814064, 0.99840019, 0.99865616, 0.99890855, \
0.99915736, 0.99940259, 0.99964424, 0.99988231, } 

#define BARTHANN4096 {\
0.00000000, 0.00011766, 0.00023622, 0.00035567, 0.00047602, \
0.00059726, 0.00071940, 0.00084243, 0.00096636, 0.00109118, \
0.00121689, 0.00134350, 0.00147100, 0.00159940, 0.00172869, \
0.00185888, 0.00198996, 0.00212194, 0.00225481, 0.00238857, \
0.00252323, 0.00265878, 0.00279523, 0.00293257, 0.00307081, \
0.00320994, 0.00334996, 0.00349088, 0.00363269, 0.00377539, \
0.00391899, 0.00406348, 0.00420887, 0.00435514, 0.00450232, \
0.00465038, 0.00479934, 0.00494919, 0.00509994, 0.00525158, \
0.00540411, 0.00555754, 0.00571185, 0.00586706, 0.00602317, \
0.00618016, 0.00633805, 0.00649683, 0.00665650, 0.00681707, \
0.00697852, 0.00714087, 0.00730411, 0.00746825, 0.00763327, \
0.00779919, 0.00796599, 0.00813369, 0.00830228, 0.00847176, \
0.00864213, 0.00881340, 0.00898555, 0.00915859, 0.00933253, \
0.00950735, 0.00968307, 0.00985967, 0.01003717, 0.01021555, \
0.01039483, 0.01057499, 0.01075604, 0.01093798, 0.01112081, \
0.01130453, 0.01148914, 0.01167464, 0.01186103, 0.01204830, \
0.01223646, 0.01242551, 0.01261545, 0.01280627, 0.01299798, \
0.01319058, 0.01338407, 0.01357844, 0.01377370, 0.01396985, \
0.01416688, 0.01436480, 0.01456361, 0.01476330, 0.01496387, \
0.01516533, 0.01536768, 0.01557091, 0.01577503, 0.01598003, \
0.01618591, 0.01639268, 0.01660033, 0.01680887, 0.01701829, \
0.01722859, 0.01743978, 0.01765185, 0.01786480, 0.01807863, \
0.01829335, 0.01850895, 0.01872543, 0.01894279, 0.01916103, \
0.01938015, 0.01960016, 0.01982104, 0.02004281, 0.02026545, \
0.02048898, 0.02071338, 0.02093866, 0.02116483, 0.02139187, \
0.02161979, 0.02184858, 0.02207826, 0.02230881, 0.02254024, \
0.02277255, 0.02300573, 0.02323980, 0.02347473, 0.02371055, \
0.02394724, 0.02418480, 0.02442324, 0.02466256, 0.02490275, \
0.02514381, 0.02538575, 0.02562856, 0.02587224, 0.02611680, \
0.02636223, 0.02660854, 0.02685571, 0.02710376, 0.02735268, \
0.02760247, 0.02785314, 0.02810467, 0.02835707, 0.02861034, \
0.02886449, 0.02911950, 0.02937538, 0.02963213, 0.02988975, \
0.03014824, 0.03040759, 0.03066781, 0.03092890, 0.03119086, \
0.03145368, 0.03171737, 0.03198192, 0.03224734, 0.03251363, \
0.03278078, 0.03304879, 0.03331767, 0.03358741, 0.03385802, \
0.03412948, 0.03440181, 0.03467501, 0.03494906, 0.03522398, \
0.03549975, 0.03577639, 0.03605389, 0.03633225, 0.03661146, \
0.03689154, 0.03717248, 0.03745427, 0.03773692, 0.03802043, \
0.03830480, 0.03859002, 0.03887610, 0.03916304, 0.03945083, \
0.03973948, 0.04002898, 0.04031934, 0.04061055, 0.04090261, \
0.04119553, 0.04148930, 0.04178392, 0.04207939, 0.04237572, \
0.04267290, 0.04297093, 0.04326980, 0.04356953, 0.04387011, \
0.04417154, 0.04447381, 0.04477694, 0.04508091, 0.04538572, \
0.04569139, 0.04599790, 0.04630526, 0.04661346, 0.04692251, \
0.04723240, 0.04754314, 0.04785472, 0.04816714, 0.04848041, \
0.04879452, 0.04910947, 0.04942526, 0.04974189, 0.05005937, \
0.05037768, 0.05069683, 0.05101682, 0.05133765, 0.05165932, \
0.05198183, 0.05230517, 0.05262935, 0.05295436, 0.05328022, \
0.05360690, 0.05393442, 0.05426278, 0.05459197, 0.05492199, \
0.05525284, 0.05558453, 0.05591705, 0.05625040, 0.05658458, \
0.05691959, 0.05725543, 0.05759209, 0.05792959, 0.05826792, \
0.05860707, 0.05894705, 0.05928786, 0.05962949, 0.05997195, \
0.06031523, 0.06065934, 0.06100427, 0.06135002, 0.06169660, \
0.06204400, 0.06239222, 0.06274126, 0.06309112, 0.06344181, \
0.06379331, 0.06414563, 0.06449877, 0.06485273, 0.06520750, \
0.06556309, 0.06591950, 0.06627672, 0.06663476, 0.06699361, \
0.06735328, 0.06771376, 0.06807505, 0.06843716, 0.06880007, \
0.06916380, 0.06952834, 0.06989368, 0.07025984, 0.07062681, \
0.07099458, 0.07136316, 0.07173255, 0.07210274, 0.07247374, \
0.07284555, 0.07321816, 0.07359157, 0.07396579, 0.07434081, \
0.07471663, 0.07509325, 0.07547068, 0.07584890, 0.07622792, \
0.07660775, 0.07698837, 0.07736979, 0.07775200, 0.07813502, \
0.07851883, 0.07890343, 0.07928883, 0.07967502, 0.08006201, \
0.08044979, 0.08083836, 0.08122772, 0.08161787, 0.08200882, \
0.08240055, 0.08279307, 0.08318639, 0.08358048, 0.08397537, \
0.08437104, 0.08476750, 0.08516474, 0.08556277, 0.08596158, \
0.08636117, 0.08676155, 0.08716270, 0.08756464, 0.08796736, \
0.08837086, 0.08877514, 0.08918019, 0.08958603, 0.08999264, \
0.09040002, 0.09080818, 0.09121712, 0.09162683, 0.09203732, \
0.09244858, 0.09286061, 0.09327341, 0.09368698, 0.09410132, \
0.09451644, 0.09493232, 0.09534896, 0.09576638, 0.09618456, \
0.09660351, 0.09702322, 0.09744370, 0.09786494, 0.09828695, \
0.09870971, 0.09913324, 0.09955753, 0.09998258, 0.10040839, \
0.10083496, 0.10126228, 0.10169037, 0.10211920, 0.10254880, \
0.10297915, 0.10341025, 0.10384211, 0.10427472, 0.10470808, \
0.10514220, 0.10557706, 0.10601268, 0.10644904, 0.10688615, \
0.10732401, 0.10776262, 0.10820197, 0.10864207, 0.10908291, \
0.10952449, 0.10996682, 0.11040989, 0.11085371, 0.11129826, \
0.11174355, 0.11218958, 0.11263635, 0.11308386, 0.11353211, \
0.11398109, 0.11443080, 0.11488126, 0.11533244, 0.11578436, \
0.11623701, 0.11669039, 0.11714450, 0.11759934, 0.11805491, \
0.11851121, 0.11896824, 0.11942599, 0.11988447, 0.12034367, \
0.12080360, 0.12126425, 0.12172562, 0.12218771, 0.12265053, \
0.12311407, 0.12357832, 0.12404330, 0.12450899, 0.12497539, \
0.12544252, 0.12591036, 0.12637891, 0.12684818, 0.12731816, \
0.12778885, 0.12826025, 0.12873237, 0.12920519, 0.12967872, \
0.13015296, 0.13062791, 0.13110356, 0.13157991, 0.13205698, \
0.13253474, 0.13301321, 0.13349238, 0.13397225, 0.13445282, \
0.13493409, 0.13541605, 0.13589872, 0.13638208, 0.13686614, \
0.13735089, 0.13783634, 0.13832248, 0.13880931, 0.13929683, \
0.13978505, 0.14027395, 0.14076354, 0.14125382, 0.14174479, \
0.14223644, 0.14272878, 0.14322181, 0.14371551, 0.14420990, \
0.14470498, 0.14520073, 0.14569716, 0.14619427, 0.14669206, \
0.14719053, 0.14768967, 0.14818949, 0.14868999, 0.14919115, \
0.14969299, 0.15019551, 0.15069869, 0.15120254, 0.15170706, \
0.15221225, 0.15271811, 0.15322464, 0.15373183, 0.15423968, \
0.15474820, 0.15525738, 0.15576722, 0.15627773, 0.15678889, \
0.15730071, 0.15781319, 0.15832633, 0.15884012, 0.15935457, \
0.15986968, 0.16038544, 0.16090185, 0.16141891, 0.16193662, \
0.16245498, 0.16297399, 0.16349365, 0.16401396, 0.16453491, \
0.16505650, 0.16557874, 0.16610163, 0.16662515, 0.16714932, \
0.16767412, 0.16819957, 0.16872565, 0.16925238, 0.16977973, \
0.17030773, 0.17083635, 0.17136562, 0.17189551, 0.17242603, \
0.17295719, 0.17348897, 0.17402139, 0.17455443, 0.17508810, \
0.17562239, 0.17615731, 0.17669285, 0.17722901, 0.17776580, \
0.17830321, 0.17884123, 0.17937988, 0.17991914, 0.18045902, \
0.18099952, 0.18154063, 0.18208235, 0.18262469, 0.18316764, \
0.18371120, 0.18425537, 0.18480014, 0.18534553, 0.18589152, \
0.18643812, 0.18698532, 0.18753313, 0.18808154, 0.18863055, \
0.18918016, 0.18973037, 0.19028118, 0.19083259, 0.19138459, \
0.19193719, 0.19249038, 0.19304417, 0.19359855, 0.19415352, \
0.19470908, 0.19526523, 0.19582197, 0.19637930, 0.19693721, \
0.19749571, 0.19805479, 0.19861446, 0.19917471, 0.19973554, \
0.20029694, 0.20085893, 0.20142150, 0.20198464, 0.20254836, \
0.20311265, 0.20367752, 0.20424296, 0.20480897, 0.20537555, \
0.20594270, 0.20651042, 0.20707871, 0.20764756, 0.20821698, \
0.20878696, 0.20935751, 0.20992862, 0.21050029, 0.21107252, \
0.21164530, 0.21221865, 0.21279255, 0.21336701, 0.21394202, \
0.21451759, 0.21509371, 0.21567038, 0.21624760, 0.21682537, \
0.21740368, 0.21798255, 0.21856196, 0.21914191, 0.21972241, \
0.22030345, 0.22088503, 0.22146716, 0.22204982, 0.22263302, \
0.22321676, 0.22380103, 0.22438584, 0.22497118, 0.22555706, \
0.22614347, 0.22673041, 0.22731787, 0.22790587, 0.22849439, \
0.22908344, 0.22967301, 0.23026311, 0.23085373, 0.23144487, \
0.23203654, 0.23262872, 0.23322142, 0.23381464, 0.23440837, \
0.23500262, 0.23559738, 0.23619266, 0.23678845, 0.23738474, \
0.23798155, 0.23857887, 0.23917669, 0.23977501, 0.24037385, \
0.24097318, 0.24157302, 0.24217336, 0.24277420, 0.24337554, \
0.24397738, 0.24457972, 0.24518255, 0.24578587, 0.24638969, \
0.24699400, 0.24759880, 0.24820409, 0.24880987, 0.24941614, \
0.25002290, 0.25063014, 0.25123786, 0.25184607, 0.25245476, \
0.25306393, 0.25367358, 0.25428370, 0.25489431, 0.25550539, \
0.25611695, 0.25672898, 0.25734148, 0.25795445, 0.25856790, \
0.25918181, 0.25979619, 0.26041104, 0.26102635, 0.26164213, \
0.26225837, 0.26287508, 0.26349224, 0.26410987, 0.26472795, \
0.26534649, 0.26596549, 0.26658494, 0.26720484, 0.26782520, \
0.26844601, 0.26906727, 0.26968898, 0.27031113, 0.27093374, \
0.27155679, 0.27218028, 0.27280422, 0.27342859, 0.27405341, \
0.27467867, 0.27530437, 0.27593050, 0.27655707, 0.27718408, \
0.27781152, 0.27843939, 0.27906769, 0.27969642, 0.28032558, \
0.28095517, 0.28158518, 0.28221562, 0.28284649, 0.28347777, \
0.28410948, 0.28474161, 0.28537416, 0.28600712, 0.28664050, \
0.28727430, 0.28790851, 0.28854314, 0.28917817, 0.28981362, \
0.29044947, 0.29108574, 0.29172241, 0.29235949, 0.29299697, \
0.29363485, 0.29427314, 0.29491183, 0.29555091, 0.29619040, \
0.29683028, 0.29747056, 0.29811123, 0.29875230, 0.29939376, \
0.30003561, 0.30067784, 0.30132047, 0.30196349, 0.30260689, \
0.30325067, 0.30389484, 0.30453939, 0.30518433, 0.30582964, \
0.30647533, 0.30712140, 0.30776784, 0.30841466, 0.30906185, \
0.30970942, 0.31035735, 0.31100566, 0.31165433, 0.31230337, \
0.31295278, 0.31360255, 0.31425269, 0.31490319, 0.31555405, \
0.31620527, 0.31685684, 0.31750878, 0.31816107, 0.31881371, \
0.31946671, 0.32012006, 0.32077377, 0.32142782, 0.32208222, \
0.32273697, 0.32339206, 0.32404750, 0.32470328, 0.32535940, \
0.32601587, 0.32667267, 0.32732982, 0.32798730, 0.32864511, \
0.32930326, 0.32996174, 0.33062056, 0.33127970, 0.33193918, \
0.33259898, 0.33325911, 0.33391957, 0.33458035, 0.33524145, \
0.33590287, 0.33656462, 0.33722668, 0.33788907, 0.33855176, \
0.33921478, 0.33987811, 0.34054175, 0.34120570, 0.34186996, \
0.34253453, 0.34319941, 0.34386460, 0.34453009, 0.34519588, \
0.34586198, 0.34652837, 0.34719507, 0.34786207, 0.34852936, \
0.34919695, 0.34986483, 0.35053301, 0.35120148, 0.35187024, \
0.35253929, 0.35320862, 0.35387825, 0.35454816, 0.35521835, \
0.35588883, 0.35655959, 0.35723063, 0.35790195, 0.35857354, \
0.35924541, 0.35991756, 0.36058998, 0.36126268, 0.36193564, \
0.36260888, 0.36328238, 0.36395615, 0.36463019, 0.36530449, \
0.36597906, 0.36665388, 0.36732897, 0.36800432, 0.36867992, \
0.36935579, 0.37003190, 0.37070827, 0.37138490, 0.37206178, \
0.37273890, 0.37341628, 0.37409390, 0.37477177, 0.37544988, \
0.37612824, 0.37680684, 0.37748568, 0.37816476, 0.37884408, \
0.37952364, 0.38020343, 0.38088346, 0.38156371, 0.38224420, \
0.38292493, 0.38360588, 0.38428705, 0.38496846, 0.38565009, \
0.38633194, 0.38701402, 0.38769631, 0.38837883, 0.38906156, \
0.38974452, 0.39042768, 0.39111107, 0.39179466, 0.39247847, \
0.39316249, 0.39384671, 0.39453115, 0.39521579, 0.39590063, \
0.39658568, 0.39727093, 0.39795639, 0.39864204, 0.39932789, \
0.40001394, 0.40070018, 0.40138662, 0.40207325, 0.40276007, \
0.40344709, 0.40413429, 0.40482168, 0.40550926, 0.40619702, \
0.40688496, 0.40757309, 0.40826140, 0.40894989, 0.40963855, \
0.41032740, 0.41101642, 0.41170561, 0.41239497, 0.41308451, \
0.41377422, 0.41446410, 0.41515414, 0.41584435, 0.41653472, \
0.41722526, 0.41791596, 0.41860682, 0.41929785, 0.41998902, \
0.42068036, 0.42137185, 0.42206349, 0.42275529, 0.42344724, \
0.42413934, 0.42483159, 0.42552398, 0.42621652, 0.42690921, \
0.42760203, 0.42829500, 0.42898811, 0.42968136, 0.43037475, \
0.43106827, 0.43176193, 0.43245572, 0.43314965, 0.43384370, \
0.43453789, 0.43523220, 0.43592664, 0.43662121, 0.43731590, \
0.43801071, 0.43870564, 0.43940070, 0.44009587, 0.44079116, \
0.44148657, 0.44218209, 0.44287772, 0.44357347, 0.44426933, \
0.44496529, 0.44566137, 0.44635755, 0.44705383, 0.44775022, \
0.44844671, 0.44914330, 0.44984000, 0.45053679, 0.45123367, \
0.45193066, 0.45262773, 0.45332490, 0.45402217, 0.45471952, \
0.45541696, 0.45611448, 0.45681210, 0.45750980, 0.45820758, \
0.45890544, 0.45960339, 0.46030141, 0.46099951, 0.46169769, \
0.46239594, 0.46309426, 0.46379266, 0.46449113, 0.46518967, \
0.46588828, 0.46658695, 0.46728569, 0.46798450, 0.46868336, \
0.46938229, 0.47008128, 0.47078032, 0.47147943, 0.47217859, \
0.47287780, 0.47357707, 0.47427639, 0.47497576, 0.47567518, \
0.47637464, 0.47707415, 0.47777371, 0.47847331, 0.47917296, \
0.47987264, 0.48057236, 0.48127213, 0.48197192, 0.48267176, \
0.48337162, 0.48407152, 0.48477146, 0.48547142, 0.48617141, \
0.48687142, 0.48757147, 0.48827153, 0.48897162, 0.48967173, \
0.49037187, 0.49107202, 0.49177218, 0.49247237, 0.49317257, \
0.49387278, 0.49457300, 0.49527324, 0.49597348, 0.49667374, \
0.49737400, 0.49807426, 0.49877453, 0.49947480, 0.50017507, \
0.50087534, 0.50157561, 0.50227587, 0.50297613, 0.50367639, \
0.50437664, 0.50507688, 0.50577711, 0.50647733, 0.50717753, \
0.50787772, 0.50857790, 0.50927806, 0.50997820, 0.51067832, \
0.51137842, 0.51207850, 0.51277856, 0.51347859, 0.51417859, \
0.51487857, 0.51557851, 0.51627843, 0.51697831, 0.51767816, \
0.51837798, 0.51907776, 0.51977750, 0.52047721, 0.52117687, \
0.52187649, 0.52257607, 0.52327561, 0.52397510, 0.52467454, \
0.52537393, 0.52607328, 0.52677257, 0.52747181, 0.52817100, \
0.52887013, 0.52956921, 0.53026822, 0.53096718, 0.53166608, \
0.53236491, 0.53306369, 0.53376239, 0.53446103, 0.53515961, \
0.53585811, 0.53655654, 0.53725491, 0.53795320, 0.53865141, \
0.53934955, 0.54004761, 0.54074560, 0.54144350, 0.54214132, \
0.54283906, 0.54353672, 0.54423429, 0.54493177, 0.54562917, \
0.54632648, 0.54702369, 0.54772082, 0.54841785, 0.54911478, \
0.54981162, 0.55050836, 0.55120500, 0.55190155, 0.55259799, \
0.55329432, 0.55399056, 0.55468668, 0.55538270, 0.55607862, \
0.55677442, 0.55747011, 0.55816569, 0.55886115, 0.55955650, \
0.56025173, 0.56094684, 0.56164184, 0.56233671, 0.56303146, \
0.56372609, 0.56442059, 0.56511497, 0.56580922, 0.56650334, \
0.56719733, 0.56789119, 0.56858491, 0.56927851, 0.56997196, \
0.57066528, 0.57135846, 0.57205150, 0.57274440, 0.57343715, \
0.57412977, 0.57482223, 0.57551456, 0.57620673, 0.57689875, \
0.57759063, 0.57828235, 0.57897391, 0.57966533, 0.58035659, \
0.58104768, 0.58173863, 0.58242941, 0.58312003, 0.58381048, \
0.58450078, 0.58519090, 0.58588086, 0.58657066, 0.58726028, \
0.58794973, 0.58863901, 0.58932812, 0.59001705, 0.59070580, \
0.59139438, 0.59208278, 0.59277100, 0.59345903, 0.59414689, \
0.59483455, 0.59552204, 0.59620933, 0.59689644, 0.59758336, \
0.59827009, 0.59895662, 0.59964296, 0.60032911, 0.60101506, \
0.60170081, 0.60238637, 0.60307172, 0.60375687, 0.60444182, \
0.60512656, 0.60581110, 0.60649543, 0.60717955, 0.60786346, \
0.60854716, 0.60923065, 0.60991393, 0.61059699, 0.61127983, \
0.61196246, 0.61264486, 0.61332705, 0.61400901, 0.61469076, \
0.61537227, 0.61605356, 0.61673463, 0.61741546, 0.61809607, \
0.61877644, 0.61945659, 0.62013650, 0.62081617, 0.62149561, \
0.62217481, 0.62285377, 0.62353249, 0.62421097, 0.62488920, \
0.62556720, 0.62624494, 0.62692244, 0.62759969, 0.62827669, \
0.62895344, 0.62962994, 0.63030619, 0.63098218, 0.63165791, \
0.63233339, 0.63300861, 0.63368356, 0.63435826, 0.63503269, \
0.63570686, 0.63638077, 0.63705440, 0.63772777, 0.63840087, \
0.63907370, 0.63974626, 0.64041855, 0.64109056, 0.64176229, \
0.64243375, 0.64310493, 0.64377583, 0.64444644, 0.64511678, \
0.64578683, 0.64645660, 0.64712608, 0.64779527, 0.64846418, \
0.64913279, 0.64980112, 0.65046915, 0.65113688, 0.65180432, \
0.65247147, 0.65313832, 0.65380486, 0.65447111, 0.65513705, \
0.65580270, 0.65646803, 0.65713307, 0.65779779, 0.65846221, \
0.65912632, 0.65979011, 0.66045360, 0.66111677, 0.66177962, \
0.66244216, 0.66310439, 0.66376629, 0.66442788, 0.66508914, \
0.66575008, 0.66641070, 0.66707099, 0.66773096, 0.66839060, \
0.66904991, 0.66970889, 0.67036754, 0.67102586, 0.67168384, \
0.67234149, 0.67299880, 0.67365577, 0.67431241, 0.67496870, \
0.67562465, 0.67628026, 0.67693553, 0.67759045, 0.67824502, \
0.67889925, 0.67955313, 0.68020665, 0.68085983, 0.68151265, \
0.68216512, 0.68281723, 0.68346899, 0.68412039, 0.68477143, \
0.68542211, 0.68607242, 0.68672238, 0.68737197, 0.68802119, \
0.68867005, 0.68931854, 0.68996666, 0.69061441, 0.69126179, \
0.69190880, 0.69255543, 0.69320168, 0.69384756, 0.69449307, \
0.69513819, 0.69578293, 0.69642729, 0.69707127, 0.69771486, \
0.69835807, 0.69900089, 0.69964332, 0.70028537, 0.70092702, \
0.70156828, 0.70220915, 0.70284963, 0.70348971, 0.70412939, \
0.70476868, 0.70540757, 0.70604605, 0.70668414, 0.70732182, \
0.70795910, 0.70859598, 0.70923244, 0.70986851, 0.71050416, \
0.71113940, 0.71177423, 0.71240865, 0.71304265, 0.71367624, \
0.71430941, 0.71494217, 0.71557451, 0.71620643, 0.71683792, \
0.71746900, 0.71809965, 0.71872988, 0.71935968, 0.71998905, \
0.72061800, 0.72124652, 0.72187460, 0.72250226, 0.72312948, \
0.72375627, 0.72438262, 0.72500854, 0.72563401, 0.72625905, \
0.72688365, 0.72750781, 0.72813152, 0.72875479, 0.72937762, \
0.73000000, 0.73062193, 0.73124342, 0.73186445, 0.73248504, \
0.73310517, 0.73372485, 0.73434407, 0.73496284, 0.73558115, \
0.73619900, 0.73681640, 0.73743333, 0.73804980, 0.73866581, \
0.73928136, 0.73989644, 0.74051106, 0.74112520, 0.74173888, \
0.74235209, 0.74296483, 0.74357710, 0.74418889, 0.74480021, \
0.74541105, 0.74602142, 0.74663131, 0.74724072, 0.74784965, \
0.74845810, 0.74906606, 0.74967354, 0.75028054, 0.75088705, \
0.75149308, 0.75209861, 0.75270366, 0.75330822, 0.75391228, \
0.75451585, 0.75511893, 0.75572151, 0.75632360, 0.75692519, \
0.75752628, 0.75812687, 0.75872696, 0.75932655, 0.75992563, \
0.76052421, 0.76112229, 0.76171986, 0.76231692, 0.76291347, \
0.76350951, 0.76410504, 0.76470006, 0.76529457, 0.76588856, \
0.76648204, 0.76707499, 0.76766744, 0.76825936, 0.76885076, \
0.76944164, 0.77003200, 0.77062184, 0.77121115, 0.77179994, \
0.77238820, 0.77297593, 0.77356313, 0.77414980, 0.77473594, \
0.77532155, 0.77590663, 0.77649117, 0.77707518, 0.77765865, \
0.77824158, 0.77882397, 0.77940582, 0.77998714, 0.78056791, \
0.78114813, 0.78172782, 0.78230695, 0.78288554, 0.78346359, \
0.78404108, 0.78461803, 0.78519442, 0.78577026, 0.78634555, \
0.78692029, 0.78749447, 0.78806809, 0.78864116, 0.78921367, \
0.78978562, 0.79035701, 0.79092783, 0.79149810, 0.79206780, \
0.79263694, 0.79320551, 0.79377351, 0.79434094, 0.79490781, \
0.79547411, 0.79603983, 0.79660499, 0.79716957, 0.79773357, \
0.79829700, 0.79885986, 0.79942213, 0.79998383, 0.80054495, \
0.80110549, 0.80166545, 0.80222482, 0.80278361, 0.80334182, \
0.80389944, 0.80445647, 0.80501291, 0.80556877, 0.80612404, \
0.80667871, 0.80723280, 0.80778629, 0.80833918, 0.80889149, \
0.80944319, 0.80999430, 0.81054481, 0.81109472, 0.81164403, \
0.81219274, 0.81274085, 0.81328836, 0.81383526, 0.81438155, \
0.81492724, 0.81547232, 0.81601680, 0.81656066, 0.81710391, \
0.81764656, 0.81818859, 0.81873000, 0.81927081, 0.81981100, \
0.82035057, 0.82088952, 0.82142786, 0.82196557, 0.82250267, \
0.82303915, 0.82357500, 0.82411023, 0.82464483, 0.82517882, \
0.82571217, 0.82624490, 0.82677700, 0.82730847, 0.82783931, \
0.82836952, 0.82889909, 0.82942804, 0.82995635, 0.83048402, \
0.83101106, 0.83153747, 0.83206323, 0.83258836, 0.83311285, \
0.83363669, 0.83415990, 0.83468246, 0.83520438, 0.83572565, \
0.83624628, 0.83676626, 0.83728559, 0.83780428, 0.83832232, \
0.83883970, 0.83935644, 0.83987252, 0.84038796, 0.84090273, \
0.84141685, 0.84193032, 0.84244313, 0.84295528, 0.84346677, \
0.84397761, 0.84448778, 0.84499729, 0.84550614, 0.84601433, \
0.84652185, 0.84702871, 0.84753490, 0.84804042, 0.84854528, \
0.84904947, 0.84955299, 0.85005583, 0.85055801, 0.85105951, \
0.85156035, 0.85206050, 0.85255998, 0.85305879, 0.85355692, \
0.85405437, 0.85455114, 0.85504723, 0.85554264, 0.85603738, \
0.85653142, 0.85702479, 0.85751747, 0.85800947, 0.85850078, \
0.85899140, 0.85948134, 0.85997059, 0.86045915, 0.86094702, \
0.86143419, 0.86192068, 0.86240647, 0.86289157, 0.86337598, \
0.86385969, 0.86434270, 0.86482502, 0.86530664, 0.86578756, \
0.86626778, 0.86674730, 0.86722611, 0.86770423, 0.86818164, \
0.86865835, 0.86913436, 0.86960966, 0.87008425, 0.87055813, \
0.87103131, 0.87150378, 0.87197554, 0.87244658, 0.87291692, \
0.87338654, 0.87385545, 0.87432365, 0.87479113, 0.87525790, \
0.87572395, 0.87618928, 0.87665390, 0.87711779, 0.87758097, \
0.87804342, 0.87850516, 0.87896617, 0.87942646, 0.87988602, \
0.88034486, 0.88080298, 0.88126037, 0.88171703, 0.88217296, \
0.88262817, 0.88308265, 0.88353639, 0.88398941, 0.88444169, \
0.88489324, 0.88534406, 0.88579415, 0.88624349, 0.88669211, \
0.88713998, 0.88758712, 0.88803352, 0.88847919, 0.88892411, \
0.88936829, 0.88981174, 0.89025444, 0.89069639, 0.89113761, \
0.89157808, 0.89201780, 0.89245678, 0.89289501, 0.89333250, \
0.89376924, 0.89420522, 0.89464046, 0.89507495, 0.89550869, \
0.89594168, 0.89637391, 0.89680539, 0.89723612, 0.89766609, \
0.89809531, 0.89852377, 0.89895147, 0.89937842, 0.89980461, \
0.90023004, 0.90065471, 0.90107862, 0.90150176, 0.90192415, \
0.90234577, 0.90276663, 0.90318673, 0.90360606, 0.90402462, \
0.90444242, 0.90485946, 0.90527572, 0.90569122, 0.90610594, \
0.90651990, 0.90693309, 0.90734550, 0.90775715, 0.90816802, \
0.90857812, 0.90898744, 0.90939599, 0.90980377, 0.91021077, \
0.91061699, 0.91102243, 0.91142710, 0.91183099, 0.91223410, \
0.91263643, 0.91303797, 0.91343874, 0.91383872, 0.91423793, \
0.91463634, 0.91503398, 0.91543083, 0.91582689, 0.91622217, \
0.91661666, 0.91701037, 0.91740329, 0.91779541, 0.91818675, \
0.91857730, 0.91896706, 0.91935603, 0.91974420, 0.92013158, \
0.92051817, 0.92090397, 0.92128897, 0.92167318, 0.92205659, \
0.92243920, 0.92282102, 0.92320204, 0.92358226, 0.92396169, \
0.92434031, 0.92471814, 0.92509516, 0.92547138, 0.92584680, \
0.92622142, 0.92659524, 0.92696825, 0.92734046, 0.92771186, \
0.92808246, 0.92845225, 0.92882123, 0.92918941, 0.92955678, \
0.92992334, 0.93028909, 0.93065403, 0.93101817, 0.93138149, \
0.93174400, 0.93210570, 0.93246658, 0.93282666, 0.93318592, \
0.93354436, 0.93390199, 0.93425881, 0.93461481, 0.93496999, \
0.93532435, 0.93567790, 0.93603063, 0.93638255, 0.93673364, \
0.93708391, 0.93743336, 0.93778199, 0.93812980, 0.93847679, \
0.93882296, 0.93916830, 0.93951282, 0.93985651, 0.94019938, \
0.94054143, 0.94088265, 0.94122304, 0.94156261, 0.94190135, \
0.94223926, 0.94257634, 0.94291260, 0.94324802, 0.94358262, \
0.94391638, 0.94424932, 0.94458142, 0.94491269, 0.94524313, \
0.94557273, 0.94590150, 0.94622944, 0.94655655, 0.94688281, \
0.94720825, 0.94753285, 0.94785661, 0.94817953, 0.94850162, \
0.94882287, 0.94914328, 0.94946285, 0.94978158, 0.95009948, \
0.95041653, 0.95073274, 0.95104811, 0.95136264, 0.95167633, \
0.95198917, 0.95230118, 0.95261234, 0.95292265, 0.95323212, \
0.95354075, 0.95384853, 0.95415546, 0.95446155, 0.95476679, \
0.95507119, 0.95537473, 0.95567743, 0.95597928, 0.95628028, \
0.95658044, 0.95687974, 0.95717819, 0.95747580, 0.95777255, \
0.95806845, 0.95836350, 0.95865769, 0.95895104, 0.95924353, \
0.95953517, 0.95982595, 0.96011588, 0.96040495, 0.96069317, \
0.96098054, 0.96126705, 0.96155270, 0.96183749, 0.96212143, \
0.96240451, 0.96268673, 0.96296810, 0.96324861, 0.96352825, \
0.96380704, 0.96408497, 0.96436204, 0.96463824, 0.96491359, \
0.96518807, 0.96546170, 0.96573446, 0.96600636, 0.96627739, \
0.96654757, 0.96681688, 0.96708532, 0.96735290, 0.96761962, \
0.96788547, 0.96815046, 0.96841458, 0.96867784, 0.96894023, \
0.96920175, 0.96946241, 0.96972219, 0.96998111, 0.97023917, \
0.97049635, 0.97075267, 0.97100812, 0.97126269, 0.97151640, \
0.97176924, 0.97202121, 0.97227230, 0.97252253, 0.97277189, \
0.97302037, 0.97326798, 0.97351472, 0.97376059, 0.97400559, \
0.97424971, 0.97449296, 0.97473533, 0.97497683, 0.97521746, \
0.97545721, 0.97569609, 0.97593409, 0.97617122, 0.97640747, \
0.97664285, 0.97687734, 0.97711097, 0.97734371, 0.97757558, \
0.97780657, 0.97803669, 0.97826593, 0.97849428, 0.97872176, \
0.97894837, 0.97917409, 0.97939893, 0.97962290, 0.97984598, \
0.98006819, 0.98028951, 0.98050995, 0.98072952, 0.98094820, \
0.98116600, 0.98138292, 0.98159896, 0.98181412, 0.98202839, \
0.98224179, 0.98245430, 0.98266592, 0.98287667, 0.98308653, \
0.98329551, 0.98350360, 0.98371081, 0.98391714, 0.98412258, \
0.98432714, 0.98453082, 0.98473360, 0.98493551, 0.98513653, \
0.98533666, 0.98553591, 0.98573427, 0.98593175, 0.98612833, \
0.98632404, 0.98651885, 0.98671278, 0.98690583, 0.98709798, \
0.98728925, 0.98747963, 0.98766913, 0.98785773, 0.98804545, \
0.98823228, 0.98841822, 0.98860327, 0.98878744, 0.98897071, \
0.98915310, 0.98933460, 0.98951520, 0.98969492, 0.98987375, \
0.99005169, 0.99022874, 0.99040490, 0.99058017, 0.99075455, \
0.99092804, 0.99110064, 0.99127235, 0.99144316, 0.99161309, \
0.99178212, 0.99195027, 0.99211752, 0.99228388, 0.99244935, \
0.99261393, 0.99277762, 0.99294041, 0.99310232, 0.99326333, \
0.99342345, 0.99358267, 0.99374101, 0.99389845, 0.99405500, \
0.99421065, 0.99436542, 0.99451929, 0.99467227, 0.99482435, \
0.99497554, 0.99512584, 0.99527525, 0.99542376, 0.99557138, \
0.99571811, 0.99586394, 0.99600888, 0.99615292, 0.99629607, \
0.99643833, 0.99657969, 0.99672016, 0.99685974, 0.99699842, \
0.99713621, 0.99727310, 0.99740910, 0.99754421, 0.99767842, \
0.99781174, 0.99794416, 0.99807569, 0.99820632, 0.99833606, \
0.99846491, 0.99859286, 0.99871992, 0.99884608, 0.99897135, \
0.99909572, 0.99921920, 0.99934178, 0.99946347, 0.99958426, \
0.99970416, 0.99982317, 0.99994128, } 


 #endif // _FPU_FFT_BARTHANN_H_
//=============================================================================
// End of File
//=============================================================================

