//=============================================================================
// Bohman Window 
//=============================================================================
#ifndef _FPU_FFT_BOHMAN_H_
#define _FPU_FFT_BOHMAN_H_

#define BOHMAN32 {\
0.00000000, 0.00087983, 0.00695217, 0.02298288, 0.05291080, \
0.09949831, 0.16405503, 0.24625250, 0.34404284, 0.45368870, \
0.56990532, 0.68610953, 0.79476394, 0.88779938, 0.95709344, \
0.99497964, } 

#define BOHMAN64 {\
0.00000000, 0.00010515, 0.00083870, 0.00281655, 0.00662978, \
0.01283272, 0.02193153, 0.03437355, 0.05053751, 0.07072475, \
0.09515165, 0.12394334, 0.15712878, 0.19463738, 0.23629708, \
0.28183407, 0.33087416, 0.38294568, 0.43748401, 0.49383770, \
0.55127599, 0.60899778, 0.66614189, 0.72179846, 0.77502142, \
0.82484176, 0.87028157, 0.91036851, 0.94415072, 0.97071171, \
0.98918527, 0.99877007, } 

#define BOHMAN128 {\
0.00000000, 0.00001285, 0.00010269, 0.00034615, 0.00081910, \
0.00159627, 0.00275093, 0.00435445, 0.00647603, 0.00918227, \
0.01253689, 0.01660038, 0.02142969, 0.02707790, 0.03359399, \
0.04102250, 0.04940331, 0.05877140, 0.06915662, 0.08058348, \
0.09307100, 0.10663250, 0.12127551, 0.13700161, 0.15380635, \
0.17167921, 0.19060349, 0.21055633, 0.23150868, 0.25342536, \
0.27626507, 0.29998048, 0.32451831, 0.34981947, 0.37581918, \
0.40244716, 0.42962778, 0.45728033, 0.48531919, 0.51365412, \
0.54219052, 0.57082973, 0.59946935, 0.62800355, 0.65632342, \
0.68431734, 0.71187138, 0.73886963, 0.76519465, 0.79072788, \
0.81535004, 0.83894157, 0.86138310, 0.88255583, 0.90234203, \
0.92062546, 0.93729185, 0.95222931, 0.96532881, 0.97648461, \
0.98559470, 0.99256124, 0.99729098, 0.99969566, } 

#define BOHMAN256 {\
0.00000000, 0.00000159, 0.00001269, 0.00004283, 0.00010149, \
0.00019811, 0.00034210, 0.00054281, 0.00080952, 0.00115143, \
0.00157764, 0.00209716, 0.00271888, 0.00345156, 0.00430383, \
0.00528418, 0.00640093, 0.00766223, 0.00907608, 0.01065026, \
0.01239236, 0.01430978, 0.01640968, 0.01869901, 0.02118446, \
0.02387251, 0.02676936, 0.02988095, 0.03321296, 0.03677078, \
0.04055953, 0.04458402, 0.04884876, 0.05335796, 0.05811552, \
0.06312499, 0.06838963, 0.07391234, 0.07969570, 0.08574193, \
0.09205291, 0.09863017, 0.10547487, 0.11258783, 0.11996948, \
0.12761991, 0.13553881, 0.14372551, 0.15217899, 0.16089780, \
0.16988017, 0.17912389, 0.18862643, 0.19838484, 0.20839580, \
0.21865562, 0.22916021, 0.23990513, 0.25088553, 0.26209623, \
0.27353163, 0.28518579, 0.29705240, 0.30912478, 0.32139590, \
0.33385836, 0.34650442, 0.35932600, 0.37231467, 0.38546165, \
0.39875787, 0.41219389, 0.42576000, 0.43944614, 0.45324196, \
0.46713684, 0.48111984, 0.49517975, 0.50930509, 0.52348412, \
0.53770486, 0.55195506, 0.56622225, 0.58049374, 0.59475662, \
0.60899778, 0.62320391, 0.63736153, 0.65145697, 0.66547643, \
0.67940593, 0.69323137, 0.70693854, 0.72051309, 0.73394058, \
0.74720650, 0.76029624, 0.77319515, 0.78588852, 0.79836160, \
0.81059963, 0.82258784, 0.83431145, 0.84575572, 0.85690592, \
0.86774738, 0.87826548, 0.88844569, 0.89827354, 0.90773468, \
0.91681487, 0.92549999, 0.93377608, 0.94162931, 0.94904604, \
0.95601281, 0.96251634, 0.96854359, 0.97408171, 0.97911811, \
0.98364044, 0.98763662, 0.99109485, 0.99400360, 0.99635166, \
0.99812812, 0.99932242, 0.99992431, } 

#define BOHMAN512 {\
0.00000000, 0.00000020, 0.00000158, 0.00000532, 0.00001262, \
0.00002465, 0.00004258, 0.00006760, 0.00010089, 0.00014362, \
0.00019695, 0.00026205, 0.00034010, 0.00043224, 0.00053964, \
0.00066344, 0.00080479, 0.00096484, 0.00114471, 0.00134553, \
0.00156844, 0.00181453, 0.00208494, 0.00238074, 0.00270304, \
0.00305293, 0.00343147, 0.00383975, 0.00427881, 0.00474972, \
0.00525350, 0.00579119, 0.00636381, 0.00697237, 0.00761786, \
0.00830128, 0.00902360, 0.00978578, 0.01058877, 0.01143351, \
0.01232093, 0.01325194, 0.01422744, 0.01524831, 0.01631542, \
0.01742964, 0.01859180, 0.01980273, 0.02106325, 0.02237414, \
0.02373619, 0.02515017, 0.02661683, 0.02813689, 0.02971107, \
0.03134008, 0.03302458, 0.03476526, 0.03656274, 0.03841766, \
0.04033063, 0.04230225, 0.04433307, 0.04642367, 0.04857456, \
0.05078627, 0.05305930, 0.05539412, 0.05779118, 0.06025093, \
0.06277377, 0.06536011, 0.06801032, 0.07072475, 0.07350373, \
0.07634759, 0.07925660, 0.08223104, 0.08527116, 0.08837718, \
0.09154931, 0.09478772, 0.09809259, 0.10146403, 0.10490218, \
0.10840712, 0.11197893, 0.11561765, 0.11932330, 0.12309589, \
0.12693540, 0.13084178, 0.13481497, 0.13885487, 0.14296137, \
0.14713434, 0.15137361, 0.15567900, 0.16005030, 0.16448728, \
0.16898969, 0.17355725, 0.17818966, 0.18288659, 0.18764769, \
0.19247260, 0.19736092, 0.20231222, 0.20732606, 0.21240199, \
0.21753950, 0.22273809, 0.22799721, 0.23331632, 0.23869481, \
0.24413210, 0.24962754, 0.25518048, 0.26079026, 0.26645616, \
0.27217747, 0.27795343, 0.28378330, 0.28966626, 0.29560151, \
0.30158822, 0.30762552, 0.31371254, 0.31984837, 0.32603209, \
0.33226276, 0.33853940, 0.34486103, 0.35122664, 0.35763519, \
0.36408564, 0.37057691, 0.37710790, 0.38367750, 0.39028458, \
0.39692799, 0.40360654, 0.41031904, 0.41706428, 0.42384103, \
0.43064803, 0.43748401, 0.44434769, 0.45123775, 0.45815286, \
0.46509169, 0.47205288, 0.47903503, 0.48603676, 0.49305666, \
0.50009329, 0.50714520, 0.51421094, 0.52128903, 0.52837797, \
0.53547626, 0.54258237, 0.54969476, 0.55681189, 0.56393218, \
0.57105405, 0.57817592, 0.58529616, 0.59241318, 0.59952533, \
0.60663097, 0.61372844, 0.62081608, 0.62789221, 0.63495514, \
0.64200318, 0.64903461, 0.65604771, 0.66304076, 0.67001202, \
0.67695974, 0.68388217, 0.69077755, 0.69764412, 0.70448008, \
0.71128367, 0.71805309, 0.72478655, 0.73148225, 0.73813838, \
0.74475313, 0.75132468, 0.75785123, 0.76433094, 0.77076199, \
0.77714255, 0.78347079, 0.78974489, 0.79596299, 0.80212328, \
0.80822391, 0.81426305, 0.82023886, 0.82614951, 0.83199316, \
0.83776798, 0.84347214, 0.84910380, 0.85466115, 0.86014236, \
0.86554560, 0.87086907, 0.87611094, 0.88126942, 0.88634271, \
0.89132900, 0.89622650, 0.90103344, 0.90574803, 0.91036851, \
0.91489312, 0.91932009, 0.92364770, 0.92787419, 0.93199785, \
0.93601695, 0.93992980, 0.94373469, 0.94742995, 0.95101389, \
0.95448487, 0.95784122, 0.96108132, 0.96420355, 0.96720629, \
0.97008794, 0.97284694, 0.97548172, 0.97799072, 0.98037241, \
0.98262527, 0.98474781, 0.98673854, 0.98859599, 0.99031871, \
0.99190528, 0.99335427, 0.99466430, 0.99583399, 0.99686198, \
0.99774695, 0.99848758, 0.99908257, 0.99953066, 0.99983058, \
0.99998113, } 

#define BOHMAN1024 {\
0.00000000, 0.00000002, 0.00000020, 0.00000066, 0.00000157, \
0.00000307, 0.00000531, 0.00000843, 0.00001258, 0.00001792, \
0.00002457, 0.00003271, 0.00004246, 0.00005398, 0.00006741, \
0.00008290, 0.00010060, 0.00012065, 0.00014320, 0.00016839, \
0.00019637, 0.00022729, 0.00026129, 0.00029851, 0.00033910, \
0.00038321, 0.00043098, 0.00048255, 0.00053806, 0.00059766, \
0.00066150, 0.00072971, 0.00080244, 0.00087983, 0.00096202, \
0.00104915, 0.00114136, 0.00123880, 0.00134161, 0.00144991, \
0.00156386, 0.00168359, 0.00180924, 0.00194095, 0.00207886, \
0.00222309, 0.00237380, 0.00253111, 0.00269517, 0.00286610, \
0.00304404, 0.00322913, 0.00342149, 0.00362126, 0.00382858, \
0.00404358, 0.00426638, 0.00449711, 0.00473592, 0.00498292, \
0.00523825, 0.00550203, 0.00577439, 0.00605546, 0.00634536, \
0.00664422, 0.00695217, 0.00726932, 0.00759581, 0.00793175, \
0.00827726, 0.00863248, 0.00899751, 0.00937248, 0.00975750, \
0.01015271, 0.01055820, 0.01097410, 0.01140053, 0.01183760, \
0.01228542, 0.01274411, 0.01321378, 0.01369454, 0.01418650, \
0.01468978, 0.01520447, 0.01573070, 0.01626856, 0.01681817, \
0.01737963, 0.01795304, 0.01853850, 0.01913613, 0.01974602, \
0.02036827, 0.02100298, 0.02165026, 0.02231019, 0.02298288, \
0.02366842, 0.02436691, 0.02507844, 0.02580311, 0.02654100, \
0.02729220, 0.02805682, 0.02883492, 0.02962662, 0.03043198, \
0.03125109, 0.03208405, 0.03293093, 0.03379181, 0.03466678, \
0.03555592, 0.03645930, 0.03737700, 0.03830911, 0.03925569, \
0.04021682, 0.04119258, 0.04218303, 0.04318824, 0.04420830, \
0.04524325, 0.04629318, 0.04735815, 0.04843822, 0.04953346, \
0.05064393, 0.05176969, 0.05291080, 0.05406731, 0.05523930, \
0.05642681, 0.05762991, 0.05884863, 0.06008304, 0.06133319, \
0.06259912, 0.06388089, 0.06517855, 0.06649213, 0.06782169, \
0.06916727, 0.07052891, 0.07190666, 0.07330054, 0.07471060, \
0.07613688, 0.07757942, 0.07903824, 0.08051338, 0.08200488, \
0.08351276, 0.08503705, 0.08657778, 0.08813497, 0.08970866, \
0.09129886, 0.09290560, 0.09452889, 0.09616876, 0.09782523, \
0.09949831, 0.10118801, 0.10289436, 0.10461736, 0.10635702, \
0.10811336, 0.10988638, 0.11167609, 0.11348249, 0.11530559, \
0.11714540, 0.11900190, 0.12087511, 0.12276502, 0.12467163, \
0.12659493, 0.12853492, 0.13049159, 0.13246492, 0.13445492, \
0.13646157, 0.13848485, 0.14052476, 0.14258126, 0.14465436, \
0.14674402, 0.14885024, 0.15097297, 0.15311221, 0.15526793, \
0.15744010, 0.15962869, 0.16183368, 0.16405503, 0.16629271, \
0.16854669, 0.17081694, 0.17310341, 0.17540607, 0.17772487, \
0.18005979, 0.18241077, 0.18477777, 0.18716075, 0.18955966, \
0.19197445, 0.19440507, 0.19685147, 0.19931360, 0.20179140, \
0.20428482, 0.20679380, 0.20931829, 0.21185821, 0.21441352, \
0.21698414, 0.21957002, 0.22217108, 0.22478727, 0.22741850, \
0.23006472, 0.23272584, 0.23540180, 0.23809253, 0.24079794, \
0.24351795, 0.24625250, 0.24900150, 0.25176486, 0.25454251, \
0.25733435, 0.26014031, 0.26296029, 0.26579421, 0.26864198, \
0.27150350, 0.27437868, 0.27726743, 0.28016965, 0.28308524, \
0.28601410, 0.28895614, 0.29191125, 0.29487933, 0.29786027, \
0.30085397, 0.30386033, 0.30687922, 0.30991055, 0.31295419, \
0.31601005, 0.31907800, 0.32215793, 0.32524972, 0.32835325, \
0.33146841, 0.33459507, 0.33773311, 0.34088241, 0.34404284, \
0.34721428, 0.35039660, 0.35358966, 0.35679335, 0.36000752, \
0.36323205, 0.36646679, 0.36971163, 0.37296641, 0.37623101, \
0.37950527, 0.38278907, 0.38608226, 0.38938469, 0.39269623, \
0.39601672, 0.39934602, 0.40268399, 0.40603047, 0.40938531, \
0.41274836, 0.41611948, 0.41949849, 0.42288526, 0.42627962, \
0.42968141, 0.43309048, 0.43650667, 0.43992982, 0.44335976, \
0.44679633, 0.45023936, 0.45368870, 0.45714417, 0.46060560, \
0.46407284, 0.46754570, 0.47102402, 0.47450762, 0.47799633, \
0.48148998, 0.48498839, 0.48849139, 0.49199879, 0.49551043, \
0.49902611, 0.50254566, 0.50606891, 0.50959565, 0.51312572, \
0.51665893, 0.52019509, 0.52373402, 0.52727552, 0.53081942, \
0.53436551, 0.53791362, 0.54146355, 0.54501511, 0.54856811, \
0.55212234, 0.55567763, 0.55923376, 0.56279056, 0.56634781, \
0.56990532, 0.57346290, 0.57702033, 0.58057743, 0.58413400, \
0.58768982, 0.59124469, 0.59479842, 0.59835080, 0.60190163, \
0.60545069, 0.60899778, 0.61254270, 0.61608523, 0.61962517, \
0.62316232, 0.62669645, 0.63022735, 0.63375483, 0.63727866, \
0.64079863, 0.64431454, 0.64782616, 0.65133328, 0.65483568, \
0.65833316, 0.66182550, 0.66531247, 0.66879386, 0.67226946, \
0.67573905, 0.67920240, 0.68265930, 0.68610953, 0.68955287, \
0.69298909, 0.69641798, 0.69983932, 0.70325288, 0.70665844, \
0.71005579, 0.71344468, 0.71682491, 0.72019625, 0.72355847, \
0.72691136, 0.73025468, 0.73358820, 0.73691172, 0.74022499, \
0.74352779, 0.74681991, 0.75010110, 0.75337115, 0.75662982, \
0.75987689, 0.76311214, 0.76633533, 0.76954624, 0.77274464, \
0.77593029, 0.77910298, 0.78226248, 0.78540855, 0.78854097, \
0.79165951, 0.79476394, 0.79785404, 0.80092956, 0.80399029, \
0.80703600, 0.81006645, 0.81308142, 0.81608068, 0.81906399, \
0.82203114, 0.82498190, 0.82791602, 0.83083330, 0.83373348, \
0.83661636, 0.83948170, 0.84232927, 0.84515885, 0.84797020, \
0.85076310, 0.85353732, 0.85629263, 0.85902882, 0.86174564, \
0.86444288, 0.86712030, 0.86977769, 0.87241481, 0.87503144, \
0.87762736, 0.88020233, 0.88275615, 0.88528857, 0.88779938, \
0.89028836, 0.89275527, 0.89519991, 0.89762204, 0.90002144, \
0.90239790, 0.90475119, 0.90708109, 0.90938738, 0.91166985, \
0.91392826, 0.91616242, 0.91837208, 0.92055705, 0.92271710, \
0.92485201, 0.92696158, 0.92904558, 0.93110380, 0.93313602, \
0.93514204, 0.93712164, 0.93907461, 0.94100073, 0.94289981, \
0.94477162, 0.94661595, 0.94843261, 0.95022138, 0.95198205, \
0.95371442, 0.95541829, 0.95709344, 0.95873968, 0.96035680, \
0.96194460, 0.96350288, 0.96503143, 0.96653006, 0.96799858, \
0.96943677, 0.97084445, 0.97222142, 0.97356749, 0.97488245, \
0.97616612, 0.97741831, 0.97863882, 0.97982746, 0.98098404, \
0.98210839, 0.98320030, 0.98425959, 0.98528609, 0.98627960, \
0.98723993, 0.98816692, 0.98906038, 0.98992013, 0.99074599, \
0.99153778, 0.99229533, 0.99301847, 0.99370701, 0.99436079, \
0.99497964, 0.99556339, 0.99611186, 0.99662489, 0.99710231, \
0.99754396, 0.99794968, 0.99831929, 0.99865265, 0.99894959, \
0.99920995, 0.99943358, 0.99962032, 0.99977001, 0.99988250, \
0.99995764, 0.99999529, } 

#define BOHMAN2048 {\
0.00000000, 0.00000000, 0.00000002, 0.00000008, 0.00000020, \
0.00000038, 0.00000066, 0.00000105, 0.00000157, 0.00000224, \
0.00000307, 0.00000408, 0.00000530, 0.00000674, 0.00000842, \
0.00001035, 0.00001257, 0.00001507, 0.00001789, 0.00002104, \
0.00002454, 0.00002840, 0.00003266, 0.00003731, 0.00004239, \
0.00004792, 0.00005390, 0.00006035, 0.00006731, 0.00007478, \
0.00008278, 0.00009133, 0.00010045, 0.00011016, 0.00012047, \
0.00013141, 0.00014299, 0.00015522, 0.00016814, 0.00018175, \
0.00019608, 0.00021114, 0.00022696, 0.00024354, 0.00026090, \
0.00027908, 0.00029807, 0.00031791, 0.00033861, 0.00036018, \
0.00038265, 0.00040603, 0.00043035, 0.00045561, 0.00048184, \
0.00050906, 0.00053727, 0.00056651, 0.00059679, 0.00062812, \
0.00066053, 0.00069403, 0.00072865, 0.00076438, 0.00080127, \
0.00083932, 0.00087854, 0.00091897, 0.00096061, 0.00100349, \
0.00104762, 0.00109301, 0.00113970, 0.00118769, 0.00123699, \
0.00128764, 0.00133965, 0.00139303, 0.00144780, 0.00150397, \
0.00156158, 0.00162063, 0.00168114, 0.00174312, 0.00180660, \
0.00187160, 0.00193812, 0.00200619, 0.00207583, 0.00214704, \
0.00221985, 0.00229428, 0.00237034, 0.00244805, 0.00252743, \
0.00260849, 0.00269124, 0.00277572, 0.00286193, 0.00294988, \
0.00303961, 0.00313112, 0.00322443, 0.00331955, 0.00341651, \
0.00351532, 0.00361600, 0.00371856, 0.00382302, 0.00392939, \
0.00403770, 0.00414796, 0.00426018, 0.00437438, 0.00449058, \
0.00460880, 0.00472904, 0.00485133, 0.00497569, 0.00510212, \
0.00523064, 0.00536128, 0.00549404, 0.00562895, 0.00576601, \
0.00590525, 0.00604667, 0.00619031, 0.00633616, 0.00648425, \
0.00663459, 0.00678720, 0.00694209, 0.00709929, 0.00725879, \
0.00742063, 0.00758481, 0.00775135, 0.00792027, 0.00809157, \
0.00826529, 0.00844142, 0.00861999, 0.00880101, 0.00898450, \
0.00917047, 0.00935893, 0.00954991, 0.00974341, 0.00993945, \
0.01013805, 0.01033921, 0.01054296, 0.01074931, 0.01095827, \
0.01116986, 0.01138409, 0.01160097, 0.01182053, 0.01204277, \
0.01226772, 0.01249537, 0.01272575, 0.01295887, 0.01319475, \
0.01343340, 0.01367483, 0.01391905, 0.01416609, 0.01441595, \
0.01466865, 0.01492420, 0.01518262, 0.01544391, 0.01570810, \
0.01597519, 0.01624520, 0.01651814, 0.01679403, 0.01707287, \
0.01735469, 0.01763949, 0.01792729, 0.01821810, 0.01851193, \
0.01880880, 0.01910871, 0.01941169, 0.01971774, 0.02002688, \
0.02033912, 0.02065446, 0.02097294, 0.02129454, 0.02161930, \
0.02194722, 0.02227831, 0.02261258, 0.02295005, 0.02329073, \
0.02363463, 0.02398177, 0.02433214, 0.02468578, 0.02504268, \
0.02540286, 0.02576633, 0.02613310, 0.02650319, 0.02687660, \
0.02725334, 0.02763344, 0.02801689, 0.02840371, 0.02879392, \
0.02918751, 0.02958450, 0.02998491, 0.03038875, 0.03079601, \
0.03120672, 0.03162089, 0.03203852, 0.03245963, 0.03288423, \
0.03331232, 0.03374392, 0.03417904, 0.03461768, 0.03505986, \
0.03550559, 0.03595487, 0.03640772, 0.03686415, 0.03732416, \
0.03778777, 0.03825499, 0.03872581, 0.03920026, 0.03967835, \
0.04016008, 0.04064545, 0.04113449, 0.04162720, 0.04212358, \
0.04262366, 0.04312742, 0.04363490, 0.04414608, 0.04466099, \
0.04517962, 0.04570200, 0.04622812, 0.04675800, 0.04729164, \
0.04782905, 0.04837024, 0.04891522, 0.04946399, 0.05001656, \
0.05057295, 0.05113315, 0.05169718, 0.05226504, 0.05283675, \
0.05341230, 0.05399170, 0.05457497, 0.05516211, 0.05575312, \
0.05634802, 0.05694681, 0.05754949, 0.05815608, 0.05876658, \
0.05938099, 0.05999933, 0.06062160, 0.06124780, 0.06187794, \
0.06251204, 0.06315009, 0.06379210, 0.06443807, 0.06508802, \
0.06574194, 0.06639985, 0.06706175, 0.06772764, 0.06839753, \
0.06907143, 0.06974934, 0.07043126, 0.07111721, 0.07180718, \
0.07250118, 0.07319922, 0.07390130, 0.07460742, 0.07531759, \
0.07603182, 0.07675010, 0.07747245, 0.07819887, 0.07892936, \
0.07966392, 0.08040256, 0.08114529, 0.08189210, 0.08264301, \
0.08339801, 0.08415710, 0.08492030, 0.08568761, 0.08645902, \
0.08723455, 0.08801419, 0.08879795, 0.08958583, 0.09037784, \
0.09117397, 0.09197423, 0.09277862, 0.09358715, 0.09439982, \
0.09521662, 0.09603757, 0.09686266, 0.09769190, 0.09852529, \
0.09936283, 0.10020452, 0.10105037, 0.10190037, 0.10275452, \
0.10361284, 0.10447532, 0.10534196, 0.10621276, 0.10708773, \
0.10796686, 0.10885016, 0.10973763, 0.11062926, 0.11152506, \
0.11242504, 0.11332918, 0.11423749, 0.11514998, 0.11606663, \
0.11698746, 0.11791246, 0.11884163, 0.11977497, 0.12071248, \
0.12165417, 0.12260002, 0.12355005, 0.12450424, 0.12546261, \
0.12642514, 0.12739184, 0.12836271, 0.12933774, 0.13031694, \
0.13130031, 0.13228783, 0.13327952, 0.13427537, 0.13527537, \
0.13627953, 0.13728785, 0.13830032, 0.13931694, 0.14033771, \
0.14136263, 0.14239170, 0.14342491, 0.14446226, 0.14550374, \
0.14654937, 0.14759912, 0.14865301, 0.14971103, 0.15077317, \
0.15183943, 0.15290981, 0.15398431, 0.15506292, 0.15614564, \
0.15723247, 0.15832340, 0.15941843, 0.16051755, 0.16162076, \
0.16272807, 0.16383945, 0.16495492, 0.16607446, 0.16719807, \
0.16832575, 0.16945750, 0.17059330, 0.17173315, 0.17287706, \
0.17402500, 0.17517699, 0.17633301, 0.17749306, 0.17865714, \
0.17982523, 0.18099734, 0.18217345, 0.18335357, 0.18453769, \
0.18572579, 0.18691789, 0.18811396, 0.18931400, 0.19051802, \
0.19172599, 0.19293792, 0.19415380, 0.19537362, 0.19659738, \
0.19782506, 0.19905667, 0.20029220, 0.20153163, 0.20277497, \
0.20402220, 0.20527332, 0.20652832, 0.20778720, 0.20904994, \
0.21031654, 0.21158698, 0.21286128, 0.21413940, 0.21542136, \
0.21670713, 0.21799672, 0.21929011, 0.22058729, 0.22188826, \
0.22319301, 0.22450153, 0.22581381, 0.22712984, 0.22844961, \
0.22977312, 0.23110036, 0.23243131, 0.23376597, 0.23510433, \
0.23644637, 0.23779210, 0.23914150, 0.24049455, 0.24185126, \
0.24321161, 0.24457559, 0.24594319, 0.24731440, 0.24868921, \
0.25006761, 0.25144960, 0.25283515, 0.25422426, 0.25561692, \
0.25701312, 0.25841285, 0.25981609, 0.26122284, 0.26263308, \
0.26404681, 0.26546401, 0.26688467, 0.26830877, 0.26973632, \
0.27116729, 0.27260168, 0.27403947, 0.27548065, 0.27692521, \
0.27837314, 0.27982442, 0.28127905, 0.28273700, 0.28419828, \
0.28566286, 0.28713073, 0.28860189, 0.29007631, 0.29155398, \
0.29303490, 0.29451905, 0.29600642, 0.29749698, 0.29899074, \
0.30048767, 0.30198777, 0.30349101, 0.30499740, 0.30650690, \
0.30801951, 0.30953522, 0.31105401, 0.31257586, 0.31410077, \
0.31562871, 0.31715968, 0.31869366, 0.32023064, 0.32177059, \
0.32331351, 0.32485939, 0.32640820, 0.32795993, 0.32951457, \
0.33107210, 0.33263251, 0.33419578, 0.33576189, 0.33733084, \
0.33890260, 0.34047716, 0.34205451, 0.34363463, 0.34521749, \
0.34680310, 0.34839142, 0.34998246, 0.35157618, 0.35317257, \
0.35477162, 0.35637331, 0.35797762, 0.35958454, 0.36119406, \
0.36280614, 0.36442078, 0.36603797, 0.36765767, 0.36927989, \
0.37090459, 0.37253176, 0.37416139, 0.37579346, 0.37742795, \
0.37906484, 0.38070412, 0.38234576, 0.38398975, 0.38563608, \
0.38728472, 0.38893565, 0.39058887, 0.39224434, 0.39390206, \
0.39556200, 0.39722415, 0.39888848, 0.40055498, 0.40222363, \
0.40389442, 0.40556731, 0.40724230, 0.40891937, 0.41059849, \
0.41227965, 0.41396282, 0.41564800, 0.41733515, 0.41902427, \
0.42071532, 0.42240830, 0.42410318, 0.42579994, 0.42749857, \
0.42919903, 0.43090132, 0.43260542, 0.43431129, 0.43601893, \
0.43772832, 0.43943942, 0.44115223, 0.44286672, 0.44458287, \
0.44630067, 0.44802008, 0.44974110, 0.45146369, 0.45318785, \
0.45491354, 0.45664075, 0.45836945, 0.46009964, 0.46183127, \
0.46356434, 0.46529882, 0.46703469, 0.46877193, 0.47051051, \
0.47225043, 0.47399164, 0.47573414, 0.47747791, 0.47922291, \
0.48096913, 0.48271654, 0.48446513, 0.48621487, 0.48796574, \
0.48971772, 0.49147078, 0.49322491, 0.49498007, 0.49673626, \
0.49849344, 0.50025159, 0.50201070, 0.50377073, 0.50553167, \
0.50729349, 0.50905617, 0.51081969, 0.51258402, 0.51434914, \
0.51611503, 0.51788166, 0.51964902, 0.52141707, 0.52318580, \
0.52495518, 0.52672519, 0.52849580, 0.53026699, 0.53203874, \
0.53381103, 0.53558382, 0.53735710, 0.53913084, 0.54090502, \
0.54267962, 0.54445460, 0.54622995, 0.54800565, 0.54978166, \
0.55155796, 0.55333454, 0.55511136, 0.55688840, 0.55866564, \
0.56044304, 0.56222060, 0.56399828, 0.56577605, 0.56755390, \
0.56933180, 0.57110972, 0.57288764, 0.57466553, 0.57644337, \
0.57822114, 0.57999881, 0.58177634, 0.58355373, 0.58533094, \
0.58710795, 0.58888473, 0.59066126, 0.59243751, 0.59421346, \
0.59598907, 0.59776434, 0.59953922, 0.60131370, 0.60308774, \
0.60486133, 0.60663444, 0.60840703, 0.61017909, 0.61195060, \
0.61372151, 0.61549181, 0.61726148, 0.61903047, 0.62079878, \
0.62256637, 0.62433322, 0.62609930, 0.62786458, 0.62962904, \
0.63139266, 0.63315539, 0.63491723, 0.63667814, 0.63843809, \
0.64019706, 0.64195503, 0.64371196, 0.64546783, 0.64722262, \
0.64897628, 0.65072881, 0.65248017, 0.65423034, 0.65597928, \
0.65772698, 0.65947340, 0.66121851, 0.66296230, 0.66470473, \
0.66644578, 0.66818542, 0.66992361, 0.67166035, 0.67339559, \
0.67512931, 0.67686148, 0.67859208, 0.68032108, 0.68204845, \
0.68377416, 0.68549819, 0.68722050, 0.68894108, 0.69065989, \
0.69237691, 0.69409211, 0.69580545, 0.69751692, 0.69922649, \
0.70093412, 0.70263979, 0.70434348, 0.70604515, 0.70774477, \
0.70944233, 0.71113778, 0.71283111, 0.71452229, 0.71621128, \
0.71789806, 0.71958261, 0.72126488, 0.72294487, 0.72462253, \
0.72629783, 0.72797077, 0.72964129, 0.73130938, 0.73297501, \
0.73463814, 0.73629876, 0.73795683, 0.73961232, 0.74126521, \
0.74291547, 0.74456307, 0.74620798, 0.74785017, 0.74948962, \
0.75112630, 0.75276017, 0.75439121, 0.75601940, 0.75764470, \
0.75926708, 0.76088652, 0.76250299, 0.76411646, 0.76572690, \
0.76733428, 0.76893858, 0.77053976, 0.77213780, 0.77373267, \
0.77532435, 0.77691279, 0.77849798, 0.78007988, 0.78165847, \
0.78323372, 0.78480560, 0.78637408, 0.78793913, 0.78950072, \
0.79105884, 0.79261343, 0.79416449, 0.79571198, 0.79725587, \
0.79879613, 0.80033274, 0.80186566, 0.80339487, 0.80492034, \
0.80644203, 0.80795993, 0.80947401, 0.81098422, 0.81249056, \
0.81399298, 0.81549145, 0.81698596, 0.81847647, 0.81996296, \
0.82144539, 0.82292373, 0.82439796, 0.82586805, 0.82733397, \
0.82879570, 0.83025319, 0.83170643, 0.83315539, 0.83460003, \
0.83604034, 0.83747627, 0.83890781, 0.84033492, 0.84175758, \
0.84317575, 0.84458941, 0.84599854, 0.84740309, 0.84880305, \
0.85019838, 0.85158906, 0.85297505, 0.85435634, 0.85573288, \
0.85710467, 0.85847165, 0.85983381, 0.86119112, 0.86254355, \
0.86389107, 0.86523365, 0.86657127, 0.86790390, 0.86923150, \
0.87055406, 0.87187154, 0.87318391, 0.87449114, 0.87579322, \
0.87709011, 0.87838177, 0.87966819, 0.88094934, 0.88222518, \
0.88349570, 0.88476085, 0.88602062, 0.88727498, 0.88852389, \
0.88976734, 0.89100528, 0.89223770, 0.89346457, 0.89468586, \
0.89590153, 0.89711157, 0.89831595, 0.89951464, 0.90070760, \
0.90189482, 0.90307626, 0.90425191, 0.90542172, 0.90658567, \
0.90774374, 0.90889590, 0.91004212, 0.91118237, 0.91231663, \
0.91344486, 0.91456705, 0.91568316, 0.91679317, 0.91789704, \
0.91899476, 0.92008630, 0.92117162, 0.92225071, 0.92332352, \
0.92439005, 0.92545026, 0.92650412, 0.92755160, 0.92859269, \
0.92962735, 0.93065555, 0.93167728, 0.93269250, 0.93370118, \
0.93470331, 0.93569885, 0.93668777, 0.93767006, 0.93864567, \
0.93961460, 0.94057681, 0.94153227, 0.94248096, 0.94342285, \
0.94435792, 0.94528614, 0.94620749, 0.94712193, 0.94802945, \
0.94893001, 0.94982359, 0.95071016, 0.95158971, 0.95246220, \
0.95332760, 0.95418590, 0.95503706, 0.95588107, 0.95671788, \
0.95754749, 0.95836987, 0.95918498, 0.95999280, 0.96079332, \
0.96158649, 0.96237231, 0.96315074, 0.96392176, 0.96468534, \
0.96544145, 0.96619009, 0.96693121, 0.96766479, 0.96839081, \
0.96910925, 0.96982008, 0.97052327, 0.97121880, 0.97190665, \
0.97258680, 0.97325921, 0.97392386, 0.97458074, 0.97522981, \
0.97587105, 0.97650444, 0.97712995, 0.97774756, 0.97835725, \
0.97895899, 0.97955276, 0.98013853, 0.98071629, 0.98128600, \
0.98184764, 0.98240120, 0.98294665, 0.98348396, 0.98401311, \
0.98453408, 0.98504685, 0.98555139, 0.98604767, 0.98653569, \
0.98701541, 0.98748681, 0.98794987, 0.98840456, 0.98885087, \
0.98928877, 0.98971824, 0.99013925, 0.99055179, 0.99095583, \
0.99135136, 0.99173834, 0.99211676, 0.99248659, 0.99284781, \
0.99320041, 0.99354435, 0.99387963, 0.99420621, 0.99452408, \
0.99483321, 0.99513358, 0.99542517, 0.99570797, 0.99598194, \
0.99624707, 0.99650335, 0.99675073, 0.99698922, 0.99721878, \
0.99743939, 0.99765104, 0.99785371, 0.99804737, 0.99823200, \
0.99840759, 0.99857411, 0.99873154, 0.99887987, 0.99901907, \
0.99914913, 0.99927002, 0.99938173, 0.99948423, 0.99957751, \
0.99966155, 0.99973632, 0.99980182, 0.99985801, 0.99990489, \
0.99994242, 0.99997061, 0.99998941, 0.99999882, } 

#define BOHMAN4096 {\
0.00000000, 0.00000000, 0.00000000, 0.00000001, 0.00000002, \
0.00000005, 0.00000008, 0.00000013, 0.00000020, 0.00000028, \
0.00000038, 0.00000051, 0.00000066, 0.00000084, 0.00000105, \
0.00000129, 0.00000157, 0.00000188, 0.00000224, 0.00000263, \
0.00000307, 0.00000355, 0.00000408, 0.00000466, 0.00000530, \
0.00000599, 0.00000674, 0.00000754, 0.00000841, 0.00000935, \
0.00001035, 0.00001142, 0.00001256, 0.00001377, 0.00001506, \
0.00001643, 0.00001788, 0.00001941, 0.00002102, 0.00002273, \
0.00002452, 0.00002641, 0.00002838, 0.00003046, 0.00003263, \
0.00003491, 0.00003729, 0.00003977, 0.00004236, 0.00004507, \
0.00004788, 0.00005081, 0.00005386, 0.00005702, 0.00006031, \
0.00006372, 0.00006726, 0.00007092, 0.00007472, 0.00007865, \
0.00008272, 0.00008692, 0.00009126, 0.00009575, 0.00010038, \
0.00010515, 0.00011008, 0.00011515, 0.00012038, 0.00012577, \
0.00013131, 0.00013701, 0.00014288, 0.00014891, 0.00015511, \
0.00016148, 0.00016802, 0.00017473, 0.00018162, 0.00018869, \
0.00019594, 0.00020337, 0.00021099, 0.00021879, 0.00022679, \
0.00023498, 0.00024336, 0.00025194, 0.00026071, 0.00026969, \
0.00027887, 0.00028826, 0.00029785, 0.00030766, 0.00031768, \
0.00032791, 0.00033836, 0.00034903, 0.00035992, 0.00037103, \
0.00038237, 0.00039394, 0.00040574, 0.00041777, 0.00043003, \
0.00044253, 0.00045528, 0.00046826, 0.00048149, 0.00049496, \
0.00050868, 0.00052266, 0.00053688, 0.00055136, 0.00056610, \
0.00058110, 0.00059635, 0.00061188, 0.00062767, 0.00064372, \
0.00066005, 0.00067665, 0.00069353, 0.00071068, 0.00072811, \
0.00074583, 0.00076383, 0.00078211, 0.00080068, 0.00081955, \
0.00083870, 0.00085815, 0.00087790, 0.00089795, 0.00091830, \
0.00093895, 0.00095991, 0.00098118, 0.00100276, 0.00102465, \
0.00104685, 0.00106938, 0.00109222, 0.00111538, 0.00113887, \
0.00116268, 0.00118682, 0.00121129, 0.00123609, 0.00126123, \
0.00128670, 0.00131252, 0.00133867, 0.00136517, 0.00139201, \
0.00141920, 0.00144674, 0.00147463, 0.00150288, 0.00153148, \
0.00156044, 0.00158976, 0.00161944, 0.00164949, 0.00167991, \
0.00171069, 0.00174185, 0.00177338, 0.00180529, 0.00183757, \
0.00187023, 0.00190328, 0.00193671, 0.00197052, 0.00200473, \
0.00203933, 0.00207431, 0.00210970, 0.00214548, 0.00218166, \
0.00221824, 0.00225522, 0.00229261, 0.00233041, 0.00236862, \
0.00240724, 0.00244627, 0.00248572, 0.00252559, 0.00256588, \
0.00260659, 0.00264772, 0.00268928, 0.00273128, 0.00277370, \
0.00281655, 0.00285984, 0.00290357, 0.00294774, 0.00299234, \
0.00303740, 0.00308289, 0.00312884, 0.00317523, 0.00322208, \
0.00326938, 0.00331714, 0.00336535, 0.00341403, 0.00346316, \
0.00351276, 0.00356283, 0.00361337, 0.00366437, 0.00371585, \
0.00376781, 0.00382024, 0.00387315, 0.00392653, 0.00398041, \
0.00403476, 0.00408961, 0.00414494, 0.00420076, 0.00425708, \
0.00431389, 0.00437120, 0.00442901, 0.00448732, 0.00454613, \
0.00460545, 0.00466527, 0.00472561, 0.00478645, 0.00484781, \
0.00490968, 0.00497207, 0.00503498, 0.00509841, 0.00516237, \
0.00522685, 0.00529185, 0.00535739, 0.00542346, 0.00549006, \
0.00555719, 0.00562486, 0.00569308, 0.00576183, 0.00583112, \
0.00590097, 0.00597135, 0.00604229, 0.00611378, 0.00618582, \
0.00625841, 0.00633157, 0.00640528, 0.00647955, 0.00655438, \
0.00662978, 0.00670575, 0.00678228, 0.00685939, 0.00693707, \
0.00701532, 0.00709414, 0.00717355, 0.00725354, 0.00733410, \
0.00741526, 0.00749699, 0.00757932, 0.00766223, 0.00774574, \
0.00782984, 0.00791454, 0.00799983, 0.00808572, 0.00817221, \
0.00825931, 0.00834701, 0.00843532, 0.00852423, 0.00861376, \
0.00870390, 0.00879465, 0.00888602, 0.00897801, 0.00907061, \
0.00916384, 0.00925769, 0.00935217, 0.00944728, 0.00954301, \
0.00963937, 0.00973637, 0.00983400, 0.00993227, 0.01003118, \
0.01013073, 0.01023091, 0.01033175, 0.01043323, 0.01053535, \
0.01063813, 0.01074155, 0.01084563, 0.01095036, 0.01105575, \
0.01116180, 0.01126851, 0.01137588, 0.01148391, 0.01159261, \
0.01170198, 0.01181201, 0.01192272, 0.01203409, 0.01214615, \
0.01225888, 0.01237228, 0.01248637, 0.01260113, 0.01271658, \
0.01283272, 0.01294954, 0.01306705, 0.01318525, 0.01330414, \
0.01342373, 0.01354401, 0.01366499, 0.01378666, 0.01390904, \
0.01403212, 0.01415590, 0.01428039, 0.01440558, 0.01453149, \
0.01465810, 0.01478543, 0.01491347, 0.01504223, 0.01517171, \
0.01530190, 0.01543282, 0.01556445, 0.01569681, 0.01582990, \
0.01596372, 0.01609826, 0.01623354, 0.01636954, 0.01650628, \
0.01664376, 0.01678198, 0.01692093, 0.01706062, 0.01720106, \
0.01734224, 0.01748417, 0.01762684, 0.01777026, 0.01791443, \
0.01805936, 0.01820504, 0.01835147, 0.01849866, 0.01864661, \
0.01879532, 0.01894479, 0.01909502, 0.01924602, 0.01939779, \
0.01955032, 0.01970362, 0.01985770, 0.02001254, 0.02016816, \
0.02032456, 0.02048173, 0.02063969, 0.02079842, 0.02095793, \
0.02111823, 0.02127931, 0.02144118, 0.02160384, 0.02176729, \
0.02193153, 0.02209656, 0.02226239, 0.02242901, 0.02259643, \
0.02276464, 0.02293366, 0.02310348, 0.02327410, 0.02344553, \
0.02361776, 0.02379080, 0.02396465, 0.02413931, 0.02431478, \
0.02449107, 0.02466817, 0.02484609, 0.02502482, 0.02520437, \
0.02538475, 0.02556594, 0.02574796, 0.02593081, 0.02611448, \
0.02629898, 0.02648431, 0.02667047, 0.02685746, 0.02704528, \
0.02723394, 0.02742344, 0.02761377, 0.02780494, 0.02799696, \
0.02818981, 0.02838351, 0.02857805, 0.02877344, 0.02896968, \
0.02916676, 0.02936469, 0.02956348, 0.02976312, 0.02996361, \
0.03016496, 0.03036716, 0.03057022, 0.03077414, 0.03097893, \
0.03118457, 0.03139108, 0.03159845, 0.03180669, 0.03201579, \
0.03222577, 0.03243661, 0.03264832, 0.03286091, 0.03307437, \
0.03328871, 0.03350392, 0.03372001, 0.03393698, 0.03415482, \
0.03437355, 0.03459316, 0.03481366, 0.03503504, 0.03525731, \
0.03548046, 0.03570450, 0.03592943, 0.03615526, 0.03638197, \
0.03660958, 0.03683808, 0.03706748, 0.03729778, 0.03752898, \
0.03776107, 0.03799406, 0.03822796, 0.03846276, 0.03869847, \
0.03893507, 0.03917259, 0.03941101, 0.03965035, 0.03989059, \
0.04013174, 0.04037381, 0.04061679, 0.04086068, 0.04110549, \
0.04135121, 0.04159786, 0.04184542, 0.04209390, 0.04234331, \
0.04259363, 0.04284488, 0.04309706, 0.04335016, 0.04360418, \
0.04385913, 0.04411502, 0.04437183, 0.04462957, 0.04488825, \
0.04514785, 0.04540840, 0.04566987, 0.04593229, 0.04619564, \
0.04645992, 0.04672515, 0.04699132, 0.04725843, 0.04752648, \
0.04779547, 0.04806541, 0.04833630, 0.04860813, 0.04888090, \
0.04915463, 0.04942930, 0.04970493, 0.04998150, 0.05025903, \
0.05053751, 0.05081694, 0.05109733, 0.05137868, 0.05166098, \
0.05194424, 0.05222846, 0.05251364, 0.05279977, 0.05308687, \
0.05337494, 0.05366396, 0.05395395, 0.05424490, 0.05453682, \
0.05482971, 0.05512356, 0.05541839, 0.05571418, 0.05601094, \
0.05630867, 0.05660738, 0.05690706, 0.05720771, 0.05750934, \
0.05781194, 0.05811552, 0.05842007, 0.05872560, 0.05903212, \
0.05933961, 0.05964808, 0.05995753, 0.06026796, 0.06057938, \
0.06089178, 0.06120516, 0.06151953, 0.06183489, 0.06215123, \
0.06246856, 0.06278687, 0.06310618, 0.06342647, 0.06374776, \
0.06407003, 0.06439330, 0.06471756, 0.06504281, 0.06536906, \
0.06569630, 0.06602454, 0.06635377, 0.06668400, 0.06701523, \
0.06734745, 0.06768068, 0.06801490, 0.06835012, 0.06868635, \
0.06902357, 0.06936180, 0.06970103, 0.07004127, 0.07038250, \
0.07072475, 0.07106799, 0.07141225, 0.07175751, 0.07210378, \
0.07245105, 0.07279933, 0.07314863, 0.07349893, 0.07385024, \
0.07420256, 0.07455590, 0.07491024, 0.07526560, 0.07562197, \
0.07597936, 0.07633776, 0.07669717, 0.07705760, 0.07741904, \
0.07778150, 0.07814498, 0.07850947, 0.07887499, 0.07924152, \
0.07960907, 0.07997764, 0.08034723, 0.08071783, 0.08108946, \
0.08146212, 0.08183579, 0.08221048, 0.08258620, 0.08296294, \
0.08334071, 0.08371950, 0.08409931, 0.08448015, 0.08486201, \
0.08524490, 0.08562882, 0.08601376, 0.08639973, 0.08678672, \
0.08717475, 0.08756380, 0.08795388, 0.08834499, 0.08873713, \
0.08913030, 0.08952450, 0.08991973, 0.09031599, 0.09071328, \
0.09111161, 0.09151096, 0.09191135, 0.09231277, 0.09271522, \
0.09311871, 0.09352323, 0.09392878, 0.09433537, 0.09474299, \
0.09515165, 0.09556134, 0.09597207, 0.09638383, 0.09679663, \
0.09721046, 0.09762533, 0.09804124, 0.09845818, 0.09887616, \
0.09929518, 0.09971524, 0.10013633, 0.10055846, 0.10098163, \
0.10140584, 0.10183109, 0.10225738, 0.10268470, 0.10311306, \
0.10354247, 0.10397291, 0.10440439, 0.10483692, 0.10527048, \
0.10570508, 0.10614073, 0.10657741, 0.10701514, 0.10745390, \
0.10789371, 0.10833456, 0.10877645, 0.10921938, 0.10966335, \
0.11010836, 0.11055442, 0.11100151, 0.11144965, 0.11189883, \
0.11234905, 0.11280032, 0.11325262, 0.11370597, 0.11416036, \
0.11461579, 0.11507227, 0.11552979, 0.11598835, 0.11644795, \
0.11690859, 0.11737028, 0.11783301, 0.11829678, 0.11876159, \
0.11922745, 0.11969435, 0.12016229, 0.12063127, 0.12110130, \
0.12157237, 0.12204448, 0.12251763, 0.12299182, 0.12346706, \
0.12394334, 0.12442066, 0.12489902, 0.12537842, 0.12585887, \
0.12634035, 0.12682288, 0.12730645, 0.12779106, 0.12827672, \
0.12876341, 0.12925114, 0.12973992, 0.13022973, 0.13072059, \
0.13121249, 0.13170542, 0.13219940, 0.13269442, 0.13319047, \
0.13368757, 0.13418570, 0.13468488, 0.13518509, 0.13568634, \
0.13618863, 0.13669196, 0.13719633, 0.13770173, 0.13820817, \
0.13871565, 0.13922417, 0.13973372, 0.14024431, 0.14075594, \
0.14126860, 0.14178230, 0.14229704, 0.14281281, 0.14332961, \
0.14384745, 0.14436633, 0.14488624, 0.14540718, 0.14592915, \
0.14645216, 0.14697620, 0.14750128, 0.14802739, 0.14855452, \
0.14908270, 0.14961190, 0.15014213, 0.15067339, 0.15120568, \
0.15173901, 0.15227336, 0.15280874, 0.15334515, 0.15388259, \
0.15442105, 0.15496055, 0.15550107, 0.15604261, 0.15658519, \
0.15712878, 0.15767341, 0.15821906, 0.15876573, 0.15931342, \
0.15986214, 0.16041189, 0.16096265, 0.16151444, 0.16206725, \
0.16262108, 0.16317593, 0.16373180, 0.16428869, 0.16484660, \
0.16540553, 0.16596547, 0.16652644, 0.16708842, 0.16765141, \
0.16821542, 0.16878045, 0.16934649, 0.16991355, 0.17048162, \
0.17105070, 0.17162080, 0.17219190, 0.17276402, 0.17333715, \
0.17391129, 0.17448644, 0.17506260, 0.17563976, 0.17621794, \
0.17679712, 0.17737730, 0.17795850, 0.17854069, 0.17912389, \
0.17970810, 0.18029331, 0.18087952, 0.18146673, 0.18205494, \
0.18264416, 0.18323437, 0.18382558, 0.18441779, 0.18501100, \
0.18560521, 0.18620041, 0.18679660, 0.18739379, 0.18799198, \
0.18859115, 0.18919132, 0.18979249, 0.19039464, 0.19099778, \
0.19160191, 0.19220703, 0.19281314, 0.19342024, 0.19402832, \
0.19463738, 0.19524743, 0.19585847, 0.19647049, 0.19708349, \
0.19769747, 0.19831243, 0.19892837, 0.19954529, 0.20016318, \
0.20078206, 0.20140191, 0.20202273, 0.20264453, 0.20326731, \
0.20389105, 0.20451577, 0.20514146, 0.20576812, 0.20639575, \
0.20702434, 0.20765390, 0.20828443, 0.20891593, 0.20954838, \
0.21018181, 0.21081619, 0.21145153, 0.21208784, 0.21272511, \
0.21336333, 0.21400251, 0.21464265, 0.21528374, 0.21592579, \
0.21656880, 0.21721275, 0.21785766, 0.21850351, 0.21915032, \
0.21979807, 0.22044678, 0.22109643, 0.22174702, 0.22239856, \
0.22305104, 0.22370446, 0.22435883, 0.22501413, 0.22567038, \
0.22632756, 0.22698568, 0.22764473, 0.22830472, 0.22896564, \
0.22962750, 0.23029029, 0.23095400, 0.23161865, 0.23228422, \
0.23295072, 0.23361814, 0.23428649, 0.23495577, 0.23562596, \
0.23629708, 0.23696911, 0.23764206, 0.23831594, 0.23899072, \
0.23966643, 0.24034304, 0.24102057, 0.24169901, 0.24237836, \
0.24305862, 0.24373978, 0.24442186, 0.24510483, 0.24578871, \
0.24647350, 0.24715918, 0.24784577, 0.24853325, 0.24922163, \
0.24991091, 0.25060109, 0.25129215, 0.25198411, 0.25267696, \
0.25337070, 0.25406533, 0.25476084, 0.25545724, 0.25615453, \
0.25685270, 0.25755175, 0.25825168, 0.25895248, 0.25965417, \
0.26035673, 0.26106017, 0.26176448, 0.26246967, 0.26317572, \
0.26388265, 0.26459044, 0.26529910, 0.26600862, 0.26671901, \
0.26743025, 0.26814236, 0.26885533, 0.26956916, 0.27028384, \
0.27099938, 0.27171578, 0.27243302, 0.27315112, 0.27387006, \
0.27458985, 0.27531049, 0.27603197, 0.27675430, 0.27747747, \
0.27820148, 0.27892632, 0.27965201, 0.28037853, 0.28110588, \
0.28183407, 0.28256309, 0.28329293, 0.28402361, 0.28475511, \
0.28548744, 0.28622059, 0.28695456, 0.28768935, 0.28842496, \
0.28916139, 0.28989863, 0.29063668, 0.29137555, 0.29211523, \
0.29285572, 0.29359701, 0.29433911, 0.29508202, 0.29582573, \
0.29657023, 0.29731554, 0.29806165, 0.29880855, 0.29955624, \
0.30030473, 0.30105400, 0.30180407, 0.30255492, 0.30330656, \
0.30405899, 0.30481219, 0.30556618, 0.30632095, 0.30707649, \
0.30783281, 0.30858990, 0.30934776, 0.31010640, 0.31086580, \
0.31162597, 0.31238690, 0.31314860, 0.31391106, 0.31467428, \
0.31543825, 0.31620299, 0.31696847, 0.31773471, 0.31850170, \
0.31926944, 0.32003793, 0.32080716, 0.32157714, 0.32234785, \
0.32311931, 0.32389150, 0.32466443, 0.32543810, 0.32621250, \
0.32698762, 0.32776348, 0.32854007, 0.32931737, 0.33009541, \
0.33087416, 0.33165363, 0.33243382, 0.33321473, 0.33399634, \
0.33477867, 0.33556172, 0.33634546, 0.33712992, 0.33791508, \
0.33870094, 0.33948750, 0.34027476, 0.34106271, 0.34185136, \
0.34264070, 0.34343073, 0.34422145, 0.34501286, 0.34580495, \
0.34659773, 0.34739118, 0.34818531, 0.34898012, 0.34977561, \
0.35057176, 0.35136859, 0.35216608, 0.35296424, 0.35376307, \
0.35456256, 0.35536271, 0.35616351, 0.35696498, 0.35776709, \
0.35856986, 0.35937328, 0.36017735, 0.36098206, 0.36178741, \
0.36259341, 0.36340005, 0.36420732, 0.36501523, 0.36582378, \
0.36663295, 0.36744275, 0.36825319, 0.36906424, 0.36987592, \
0.37068822, 0.37150113, 0.37231467, 0.37312881, 0.37394357, \
0.37475894, 0.37557491, 0.37639150, 0.37720868, 0.37802647, \
0.37884485, 0.37966383, 0.38048341, 0.38130357, 0.38212433, \
0.38294568, 0.38376761, 0.38459012, 0.38541322, 0.38623689, \
0.38706114, 0.38788597, 0.38871136, 0.38953733, 0.39036387, \
0.39119097, 0.39201863, 0.39284685, 0.39367564, 0.39450498, \
0.39533487, 0.39616531, 0.39699631, 0.39782785, 0.39865994, \
0.39949257, 0.40032574, 0.40115944, 0.40199368, 0.40282846, \
0.40366377, 0.40449960, 0.40533596, 0.40617285, 0.40701026, \
0.40784818, 0.40868663, 0.40952558, 0.41036505, 0.41120503, \
0.41204552, 0.41288651, 0.41372800, 0.41457000, 0.41541249, \
0.41625548, 0.41709896, 0.41794293, 0.41878738, 0.41963233, \
0.42047776, 0.42132366, 0.42217005, 0.42301691, 0.42386425, \
0.42471206, 0.42556033, 0.42640908, 0.42725828, 0.42810795, \
0.42895807, 0.42980866, 0.43065969, 0.43151118, 0.43236311, \
0.43321550, 0.43406832, 0.43492159, 0.43577529, 0.43662944, \
0.43748401, 0.43833902, 0.43919446, 0.44005032, 0.44090660, \
0.44176331, 0.44262043, 0.44347798, 0.44433593, 0.44519430, \
0.44605307, 0.44691225, 0.44777183, 0.44863182, 0.44949220, \
0.45035298, 0.45121415, 0.45207571, 0.45293765, 0.45379999, \
0.45466270, 0.45552580, 0.45638927, 0.45725312, 0.45811734, \
0.45898193, 0.45984688, 0.46071220, 0.46157788, 0.46244392, \
0.46331032, 0.46417707, 0.46504417, 0.46591162, 0.46677941, \
0.46764755, 0.46851603, 0.46938484, 0.47025399, 0.47112348, \
0.47199329, 0.47286343, 0.47373389, 0.47460467, 0.47547577, \
0.47634719, 0.47721892, 0.47809097, 0.47896332, 0.47983597, \
0.48070893, 0.48158219, 0.48245574, 0.48332959, 0.48420373, \
0.48507816, 0.48595287, 0.48682787, 0.48770315, 0.48857870, \
0.48945453, 0.49033063, 0.49120700, 0.49208364, 0.49296054, \
0.49383770, 0.49471512, 0.49559280, 0.49647073, 0.49734891, \
0.49822733, 0.49910600, 0.49998491, 0.50086406, 0.50174344, \
0.50262306, 0.50350291, 0.50438298, 0.50526328, 0.50614380, \
0.50702454, 0.50790549, 0.50878666, 0.50966803, 0.51054962, \
0.51143140, 0.51231339, 0.51319558, 0.51407796, 0.51496054, \
0.51584331, 0.51672626, 0.51760940, 0.51849271, 0.51937621, \
0.52025988, 0.52114373, 0.52202774, 0.52291192, 0.52379626, \
0.52468077, 0.52556543, 0.52645025, 0.52733522, 0.52822033, \
0.52910560, 0.52999101, 0.53087655, 0.53176224, 0.53264806, \
0.53353401, 0.53442009, 0.53530629, 0.53619262, 0.53707906, \
0.53796562, 0.53885230, 0.53973909, 0.54062598, 0.54151298, \
0.54240008, 0.54328728, 0.54417457, 0.54506196, 0.54594943, \
0.54683699, 0.54772464, 0.54861236, 0.54950017, 0.55038804, \
0.55127599, 0.55216401, 0.55305209, 0.55394024, 0.55482844, \
0.55571670, 0.55660501, 0.55749338, 0.55838179, 0.55927024, \
0.56015873, 0.56104727, 0.56193583, 0.56282443, 0.56371306, \
0.56460171, 0.56549039, 0.56637908, 0.56726779, 0.56815652, \
0.56904525, 0.56993399, 0.57082273, 0.57171148, 0.57260022, \
0.57348896, 0.57437769, 0.57526640, 0.57615510, 0.57704379, \
0.57793245, 0.57882109, 0.57970970, 0.58059828, 0.58148683, \
0.58237534, 0.58326381, 0.58415223, 0.58504061, 0.58592894, \
0.58681722, 0.58770544, 0.58859361, 0.58948171, 0.59036975, \
0.59125771, 0.59214561, 0.59303343, 0.59392117, 0.59480884, \
0.59569641, 0.59658390, 0.59747130, 0.59835861, 0.59924582, \
0.60013293, 0.60101993, 0.60190683, 0.60279362, 0.60368029, \
0.60456685, 0.60545329, 0.60633960, 0.60722579, 0.60811185, \
0.60899778, 0.60988357, 0.61076923, 0.61165474, 0.61254010, \
0.61342532, 0.61431038, 0.61519529, 0.61608004, 0.61696463, \
0.61784906, 0.61873331, 0.61961740, 0.62050131, 0.62138504, \
0.62226859, 0.62315195, 0.62403513, 0.62491812, 0.62580091, \
0.62668351, 0.62756590, 0.62844809, 0.62933007, 0.63021184, \
0.63109340, 0.63197474, 0.63285585, 0.63373675, 0.63461742, \
0.63549785, 0.63637805, 0.63725802, 0.63813774, 0.63901722, \
0.63989646, 0.64077544, 0.64165417, 0.64253264, 0.64341085, \
0.64428879, 0.64516647, 0.64604388, 0.64692102, 0.64779787, \
0.64867445, 0.64955074, 0.65042675, 0.65130246, 0.65217789, \
0.65305301, 0.65392783, 0.65480235, 0.65567656, 0.65655046, \
0.65742405, 0.65829732, 0.65917026, 0.66004289, 0.66091518, \
0.66178715, 0.66265878, 0.66353007, 0.66440102, 0.66527163, \
0.66614189, 0.66701179, 0.66788135, 0.66875054, 0.66961937, \
0.67048784, 0.67135594, 0.67222367, 0.67309102, 0.67395800, \
0.67482459, 0.67569080, 0.67655661, 0.67742204, 0.67828707, \
0.67915170, 0.68001593, 0.68087975, 0.68174317, 0.68260617, \
0.68346875, 0.68433092, 0.68519266, 0.68605397, 0.68691486, \
0.68777531, 0.68863533, 0.68949490, 0.69035404, 0.69121272, \
0.69207096, 0.69292874, 0.69378606, 0.69464292, 0.69549932, \
0.69635525, 0.69721071, 0.69806569, 0.69892020, 0.69977422, \
0.70062776, 0.70148081, 0.70233337, 0.70318544, 0.70403700, \
0.70488806, 0.70573862, 0.70658867, 0.70743820, 0.70828722, \
0.70913572, 0.70998370, 0.71083114, 0.71167806, 0.71252445, \
0.71337029, 0.71421560, 0.71506036, 0.71590458, 0.71674824, \
0.71759135, 0.71843390, 0.71927589, 0.72011732, 0.72095818, \
0.72179846, 0.72263817, 0.72347730, 0.72431585, 0.72515381, \
0.72599118, 0.72682796, 0.72766414, 0.72849972, 0.72933470, \
0.73016907, 0.73100283, 0.73183598, 0.73266851, 0.73350041, \
0.73433170, 0.73516235, 0.73599237, 0.73682176, 0.73765051, \
0.73847862, 0.73930608, 0.74013289, 0.74095905, 0.74178455, \
0.74260940, 0.74343358, 0.74425709, 0.74507993, 0.74590210, \
0.74672359, 0.74754440, 0.74836452, 0.74918396, 0.75000271, \
0.75082076, 0.75163811, 0.75245476, 0.75327070, 0.75408593, \
0.75490045, 0.75571426, 0.75652734, 0.75733970, 0.75815134, \
0.75896224, 0.75977241, 0.76058184, 0.76139053, 0.76219848, \
0.76300567, 0.76381212, 0.76461781, 0.76542274, 0.76622691, \
0.76703031, 0.76783294, 0.76863480, 0.76943589, 0.77023619, \
0.77103571, 0.77183444, 0.77263238, 0.77342952, 0.77422587, \
0.77502142, 0.77581616, 0.77661009, 0.77740321, 0.77819552, \
0.77898700, 0.77977766, 0.78056750, 0.78135650, 0.78214467, \
0.78293201, 0.78371850, 0.78450415, 0.78528895, 0.78607290, \
0.78685600, 0.78763823, 0.78841961, 0.78920011, 0.78997975, \
0.79075852, 0.79153641, 0.79231342, 0.79308955, 0.79386478, \
0.79463913, 0.79541259, 0.79618514, 0.79695680, 0.79772755, \
0.79849739, 0.79926632, 0.80003433, 0.80080143, 0.80156760, \
0.80233284, 0.80309716, 0.80386054, 0.80462299, 0.80538449, \
0.80614505, 0.80690466, 0.80766333, 0.80842103, 0.80917778, \
0.80993357, 0.81068839, 0.81144224, 0.81219511, 0.81294702, \
0.81369794, 0.81444788, 0.81519683, 0.81594479, 0.81669176, \
0.81743773, 0.81818269, 0.81892666, 0.81966961, 0.82041155, \
0.82115248, 0.82189239, 0.82263128, 0.82336913, 0.82410596, \
0.82484176, 0.82557652, 0.82631024, 0.82704291, 0.82777454, \
0.82850512, 0.82923464, 0.82996310, 0.83069050, 0.83141684, \
0.83214210, 0.83286630, 0.83358941, 0.83431145, 0.83503241, \
0.83575228, 0.83647105, 0.83718874, 0.83790532, 0.83862081, \
0.83933519, 0.84004846, 0.84076062, 0.84147167, 0.84218160, \
0.84289040, 0.84359808, 0.84430463, 0.84501005, 0.84571433, \
0.84641747, 0.84711946, 0.84782031, 0.84852001, 0.84921855, \
0.84991594, 0.85061216, 0.85130722, 0.85200111, 0.85269383, \
0.85338538, 0.85407574, 0.85476492, 0.85545292, 0.85613972, \
0.85682534, 0.85750975, 0.85819297, 0.85887498, 0.85955578, \
0.86023538, 0.86091376, 0.86159092, 0.86226686, 0.86294157, \
0.86361506, 0.86428731, 0.86495833, 0.86562811, 0.86629664, \
0.86696393, 0.86762997, 0.86829476, 0.86895829, 0.86962056, \
0.87028157, 0.87094130, 0.87159977, 0.87225696, 0.87291288, \
0.87356751, 0.87422086, 0.87487292, 0.87552369, 0.87617316, \
0.87682134, 0.87746821, 0.87811378, 0.87875803, 0.87940098, \
0.88004260, 0.88068291, 0.88132189, 0.88195955, 0.88259588, \
0.88323087, 0.88386452, 0.88449684, 0.88512780, 0.88575743, \
0.88638570, 0.88701261, 0.88763817, 0.88826236, 0.88888519, \
0.88950665, 0.89012674, 0.89074545, 0.89136279, 0.89197874, \
0.89259330, 0.89320648, 0.89381826, 0.89442864, 0.89503763, \
0.89564521, 0.89625139, 0.89685615, 0.89745950, 0.89806143, \
0.89866194, 0.89926103, 0.89985869, 0.90045492, 0.90104972, \
0.90164307, 0.90223499, 0.90282546, 0.90341448, 0.90400205, \
0.90458816, 0.90517282, 0.90575601, 0.90633774, 0.90691800, \
0.90749679, 0.90807410, 0.90864993, 0.90922428, 0.90979714, \
0.91036851, 0.91093839, 0.91150678, 0.91207366, 0.91263904, \
0.91320292, 0.91376528, 0.91432613, 0.91488547, 0.91544328, \
0.91599957, 0.91655433, 0.91710757, 0.91765927, 0.91820943, \
0.91875805, 0.91930513, 0.91985066, 0.92039464, 0.92093706, \
0.92147793, 0.92201724, 0.92255498, 0.92309116, 0.92362576, \
0.92415879, 0.92469024, 0.92522011, 0.92574840, 0.92627510, \
0.92680021, 0.92732372, 0.92784564, 0.92836595, 0.92888466, \
0.92940176, 0.92991726, 0.93043113, 0.93094339, 0.93145403, \
0.93196304, 0.93247043, 0.93297618, 0.93348030, 0.93398278, \
0.93448362, 0.93498282, 0.93548037, 0.93597627, 0.93647051, \
0.93696310, 0.93745402, 0.93794328, 0.93843087, 0.93891680, \
0.93940104, 0.93988361, 0.94036450, 0.94084371, 0.94132123, \
0.94179706, 0.94227119, 0.94274363, 0.94321436, 0.94368340, \
0.94415072, 0.94461634, 0.94508024, 0.94554243, 0.94600289, \
0.94646164, 0.94691865, 0.94737394, 0.94782749, 0.94827931, \
0.94872939, 0.94917772, 0.94962431, 0.95006915, 0.95051224, \
0.95095358, 0.95139315, 0.95183096, 0.95226701, 0.95270129, \
0.95313379, 0.95356453, 0.95399348, 0.95442066, 0.95484604, \
0.95526965, 0.95569146, 0.95611147, 0.95652969, 0.95694611, \
0.95736073, 0.95777354, 0.95818454, 0.95859372, 0.95900110, \
0.95940665, 0.95981038, 0.96021228, 0.96061235, 0.96101060, \
0.96140700, 0.96180157, 0.96219430, 0.96258519, 0.96297422, \
0.96336141, 0.96374674, 0.96413022, 0.96451183, 0.96489158, \
0.96526947, 0.96564549, 0.96601963, 0.96639190, 0.96676229, \
0.96713080, 0.96749742, 0.96786216, 0.96822500, 0.96858595, \
0.96894501, 0.96930216, 0.96965741, 0.97001075, 0.97036219, \
0.97071171, 0.97105932, 0.97140500, 0.97174877, 0.97209061, \
0.97243053, 0.97276851, 0.97310456, 0.97343867, 0.97377085, \
0.97410108, 0.97442936, 0.97475570, 0.97508008, 0.97540251, \
0.97572299, 0.97604150, 0.97635804, 0.97667262, 0.97698523, \
0.97729587, 0.97760454, 0.97791122, 0.97821592, 0.97851864, \
0.97881937, 0.97911811, 0.97941485, 0.97970960, 0.98000235, \
0.98029310, 0.98058184, 0.98086858, 0.98115330, 0.98143601, \
0.98171670, 0.98199537, 0.98227202, 0.98254665, 0.98281924, \
0.98308981, 0.98335834, 0.98362483, 0.98388928, 0.98415169, \
0.98441205, 0.98467037, 0.98492663, 0.98518084, 0.98543299, \
0.98568308, 0.98593110, 0.98617707, 0.98642096, 0.98666278, \
0.98690253, 0.98714019, 0.98737578, 0.98760929, 0.98784071, \
0.98807004, 0.98829728, 0.98852243, 0.98874548, 0.98896642, \
0.98918527, 0.98940201, 0.98961664, 0.98982917, 0.99003957, \
0.99024787, 0.99045404, 0.99065809, 0.99086001, 0.99105981, \
0.99125748, 0.99145301, 0.99164641, 0.99183767, 0.99202679, \
0.99221377, 0.99239859, 0.99258127, 0.99276180, 0.99294017, \
0.99311639, 0.99329044, 0.99346233, 0.99363206, 0.99379961, \
0.99396500, 0.99412821, 0.99428925, 0.99444811, 0.99460478, \
0.99475927, 0.99491158, 0.99506169, 0.99520961, 0.99535534, \
0.99549887, 0.99564020, 0.99577933, 0.99591625, 0.99605096, \
0.99618347, 0.99631376, 0.99644183, 0.99656769, 0.99669132, \
0.99681273, 0.99693192, 0.99704887, 0.99716360, 0.99727609, \
0.99738635, 0.99749436, 0.99760014, 0.99770367, 0.99780495, \
0.99790398, 0.99800077, 0.99809530, 0.99818757, 0.99827758, \
0.99836533, 0.99845082, 0.99853404, 0.99861499, 0.99869367, \
0.99877007, 0.99884420, 0.99891605, 0.99898562, 0.99905290, \
0.99911790, 0.99918061, 0.99924103, 0.99929915, 0.99935498, \
0.99940851, 0.99945973, 0.99950866, 0.99955527, 0.99959958, \
0.99964158, 0.99968127, 0.99971864, 0.99975369, 0.99978642, \
0.99981683, 0.99984491, 0.99987067, 0.99989410, 0.99991519, \
0.99993395, 0.99995037, 0.99996446, 0.99997620, 0.99998560, \
0.99999265, 0.99999735, 0.99999971, } 


 #endif // _FPU_FFT_BOHMAN_H_
//=============================================================================
// End of File
//=============================================================================

