//=============================================================================
// Hamming Window 
//=============================================================================
#ifndef _FPU_FFT_HAMMING_H_
#define _FPU_FFT_HAMMING_H_

#define HAMMING32 {\
0.08000000, 0.08941623, 0.11727941, 0.16244882, 0.22307522, \
0.29667656, 0.38023958, 0.47034322, 0.56329862, 0.65530016, \
0.74258131, 0.82156875, 0.88902874, 0.94219944, 0.97890406, \
0.99763989, } 

#define HAMMING64 {\
0.08000000, 0.08228584, 0.08912066, 0.10043651, 0.11612094, \
0.13601808, 0.15993016, 0.18761956, 0.21881106, 0.25319469, \
0.29042872, 0.33014310, 0.37194313, 0.41541338, 0.46012184, \
0.50562416, 0.55146812, 0.59719810, 0.64235963, 0.68650386, \
0.72919207, 0.77000000, 0.80852209, 0.84437549, 0.87720386, \
0.90668095, 0.93251381, 0.95444568, 0.97225861, 0.98577555, \
0.99486218, 0.99942818, } 

#define HAMMING128 {\
0.08000000, 0.08056285, 0.08225002, 0.08505738, 0.08897806, \
0.09400246, 0.10011830, 0.10731060, 0.11556177, 0.12485160, \
0.13515738, 0.14645387, 0.15871343, 0.17190607, 0.18599949, \
0.20095922, 0.21674863, 0.23332909, 0.25066003, 0.26869903, \
0.28740195, 0.30672302, 0.32661496, 0.34702909, 0.36791545, \
0.38922293, 0.41089938, 0.43289177, 0.45514627, 0.47760842, \
0.50022325, 0.52293542, 0.54568935, 0.56842936, 0.59109980, \
0.61364519, 0.63601036, 0.65814057, 0.67998167, 0.70148022, \
0.72258359, 0.74324016, 0.76339936, 0.78301186, 0.80202967, \
0.82040626, 0.83809664, 0.85505753, 0.87124742, 0.88662669, \
0.90115771, 0.91480492, 0.92753491, 0.93931655, 0.95012099, \
0.95992179, 0.96869497, 0.97641907, 0.98307517, 0.98864700, \
0.99312091, 0.99648596, 0.99873391, 0.99985927, } 

#define HAMMING256 {\
0.08000000, 0.08013963, 0.08055844, 0.08125618, 0.08223242, \
0.08348657, 0.08501786, 0.08682537, 0.08890801, 0.09126449, \
0.09389341, 0.09679315, 0.09996197, 0.10339793, 0.10709894, \
0.11106277, 0.11528701, 0.11976909, 0.12450629, 0.12949573, \
0.13473439, 0.14021908, 0.14594648, 0.15191311, 0.15811535, \
0.16454942, 0.17121143, 0.17809733, 0.18520294, 0.19252394, \
0.20005590, 0.20779423, 0.21573425, 0.22387112, 0.23219992, \
0.24071558, 0.24941294, 0.25828671, 0.26733150, 0.27654184, \
0.28591211, 0.29543665, 0.30510965, 0.31492526, 0.32487751, \
0.33496036, 0.34516768, 0.35549329, 0.36593092, 0.37647422, \
0.38711679, 0.39785218, 0.40867387, 0.41957529, 0.43054981, \
0.44159078, 0.45269150, 0.46384522, 0.47504517, 0.48628456, \
0.49755655, 0.50885432, 0.52017099, 0.53149970, 0.54283358, \
0.55416573, 0.56548928, 0.57679736, 0.58808309, 0.59933964, \
0.61056016, 0.62173785, 0.63286591, 0.64393759, 0.65494618, \
0.66588498, 0.67674735, 0.68752671, 0.69821650, 0.70881024, \
0.71930150, 0.72968391, 0.73995115, 0.75009701, 0.76011532, \
0.77000000, 0.77974505, 0.78934454, 0.79879267, 0.80808368, \
0.81721193, 0.82617190, 0.83495812, 0.84356529, 0.85198815, \
0.86022162, 0.86826067, 0.87610044, 0.88373617, 0.89116321, \
0.89837706, 0.90537335, 0.91214782, 0.91869636, 0.92501499, \
0.93109988, 0.93694734, 0.94255381, 0.94791590, 0.95303033, \
0.95789403, 0.96250401, 0.96685750, 0.97095185, 0.97478456, \
0.97835332, 0.98165596, 0.98469047, 0.98745501, 0.98994790, \
0.99216763, 0.99411285, 0.99578238, 0.99717520, 0.99829048, \
0.99912753, 0.99968585, 0.99996509, } 

#define HAMMING512 {\
0.08000000, 0.08003477, 0.08013909, 0.08031292, 0.08055626, \
0.08086906, 0.08125127, 0.08170284, 0.08222370, 0.08281376, \
0.08347295, 0.08420116, 0.08499828, 0.08586418, 0.08679875, \
0.08780184, 0.08887329, 0.09001294, 0.09122063, 0.09249617, \
0.09383936, 0.09525001, 0.09672789, 0.09827280, 0.09988448, \
0.10156271, 0.10330722, 0.10511775, 0.10699403, 0.10893578, \
0.11094270, 0.11301448, 0.11515082, 0.11735139, 0.11961586, \
0.12194389, 0.12433512, 0.12678919, 0.12930573, 0.13188437, \
0.13452471, 0.13722635, 0.13998888, 0.14281189, 0.14569495, \
0.14863762, 0.15163946, 0.15470002, 0.15781883, 0.16099542, \
0.16422931, 0.16752001, 0.17086702, 0.17426984, 0.17772796, \
0.18124085, 0.18480797, 0.18842880, 0.19210278, 0.19582935, \
0.19960796, 0.20343803, 0.20731899, 0.21125024, 0.21523120, \
0.21926125, 0.22333980, 0.22746622, 0.23163990, 0.23586019, \
0.24012646, 0.24443807, 0.24879437, 0.25319469, 0.25763837, \
0.26212475, 0.26665313, 0.27122284, 0.27583319, 0.28048347, \
0.28517299, 0.28990103, 0.29466689, 0.29946984, 0.30430915, \
0.30918410, 0.31409394, 0.31903793, 0.32401534, 0.32902539, \
0.33406735, 0.33914043, 0.34424389, 0.34937694, 0.35453881, \
0.35972872, 0.36494588, 0.37018951, 0.37545881, 0.38075299, \
0.38607124, 0.39141277, 0.39677676, 0.40216240, 0.40756889, \
0.41299539, 0.41844110, 0.42390518, 0.42938682, 0.43488518, \
0.44039943, 0.44592874, 0.45147227, 0.45702919, 0.46259865, \
0.46817981, 0.47377183, 0.47937386, 0.48498506, 0.49060458, \
0.49623157, 0.50186517, 0.50750453, 0.51314881, 0.51879715, \
0.52444870, 0.53010260, 0.53575799, 0.54141402, 0.54706984, \
0.55272459, 0.55837742, 0.56402747, 0.56967389, 0.57531582, \
0.58095241, 0.58658281, 0.59220616, 0.59782163, 0.60342835, \
0.60902548, 0.61461218, 0.62018760, 0.62575089, 0.63130122, \
0.63683774, 0.64235963, 0.64786604, 0.65335614, 0.65882910, \
0.66428410, 0.66972031, 0.67513691, 0.68053307, 0.68590799, \
0.69126085, 0.69659084, 0.70189716, 0.70717900, 0.71243557, \
0.71766606, 0.72286969, 0.72804568, 0.73319324, 0.73831159, \
0.74339995, 0.74845757, 0.75348367, 0.75847749, 0.76343829, \
0.76836530, 0.77325778, 0.77811501, 0.78293623, 0.78772072, \
0.79246776, 0.79717663, 0.80184662, 0.80647702, 0.81106714, \
0.81561627, 0.82012373, 0.82458885, 0.82901093, 0.83338932, \
0.83772336, 0.84201238, 0.84625575, 0.85045281, 0.85460293, \
0.85870550, 0.86275987, 0.86676546, 0.87072163, 0.87462781, \
0.87848340, 0.88228781, 0.88604048, 0.88974082, 0.89338829, \
0.89698234, 0.90052241, 0.90400798, 0.90743851, 0.91081349, \
0.91413241, 0.91739477, 0.92060007, 0.92374783, 0.92683757, \
0.92986882, 0.93284114, 0.93575406, 0.93860715, 0.94139997, \
0.94413211, 0.94680315, 0.94941269, 0.95196032, 0.95444568, \
0.95686838, 0.95922805, 0.96152434, 0.96375690, 0.96592540, \
0.96802950, 0.97006889, 0.97204326, 0.97395231, 0.97579575, \
0.97757331, 0.97928471, 0.98092969, 0.98250802, 0.98401944, \
0.98546374, 0.98684068, 0.98815007, 0.98939171, 0.99056540, \
0.99167097, 0.99270826, 0.99367711, 0.99457736, 0.99540889, \
0.99617157, 0.99686528, 0.99748992, 0.99804539, 0.99853161, \
0.99894851, 0.99929602, 0.99957409, 0.99978268, 0.99992176, \
0.99999131, } 

#define HAMMING1024 {\
0.08000000, 0.08000868, 0.08003470, 0.08007808, 0.08013881, \
0.08021689, 0.08031231, 0.08042507, 0.08055517, 0.08070260, \
0.08086736, 0.08104944, 0.08124883, 0.08146552, 0.08169951, \
0.08195079, 0.08221935, 0.08250518, 0.08280827, 0.08312860, \
0.08346617, 0.08382096, 0.08419296, 0.08458215, 0.08498853, \
0.08541206, 0.08585275, 0.08631057, 0.08678550, 0.08727753, \
0.08778663, 0.08831280, 0.08885600, 0.08941623, 0.08999345, \
0.09058764, 0.09119879, 0.09182687, 0.09247186, 0.09313373, \
0.09381245, 0.09450801, 0.09522037, 0.09594951, 0.09669540, \
0.09745802, 0.09823733, 0.09903330, 0.09984591, 0.10067512, \
0.10152090, 0.10238323, 0.10326206, 0.10415737, 0.10506912, \
0.10599728, 0.10694181, 0.10790267, 0.10887984, 0.10987326, \
0.11088292, 0.11190876, 0.11295075, 0.11400885, 0.11508302, \
0.11617322, 0.11727941, 0.11840154, 0.11953958, 0.12069348, \
0.12186319, 0.12304868, 0.12424990, 0.12546680, 0.12669934, \
0.12794747, 0.12921114, 0.13049031, 0.13178493, 0.13309495, \
0.13442031, 0.13576098, 0.13711690, 0.13848801, 0.13987427, \
0.14127562, 0.14269202, 0.14412340, 0.14556972, 0.14703091, \
0.14850693, 0.14999772, 0.15150322, 0.15302337, 0.15455813, \
0.15610742, 0.15767120, 0.15924939, 0.16084195, 0.16244882, \
0.16406992, 0.16570521, 0.16735462, 0.16901808, 0.17069554, \
0.17238693, 0.17409219, 0.17581125, 0.17754405, 0.17929052, \
0.18105060, 0.18282422, 0.18461131, 0.18641181, 0.18822565, \
0.19005275, 0.19189306, 0.19374650, 0.19561301, 0.19749250, \
0.19938492, 0.20129018, 0.20320822, 0.20513897, 0.20708234, \
0.20903828, 0.21100670, 0.21298753, 0.21498070, 0.21698613, \
0.21900374, 0.22103346, 0.22307522, 0.22512893, 0.22719452, \
0.22927190, 0.23136101, 0.23346177, 0.23557408, 0.23769788, \
0.23983308, 0.24197961, 0.24413738, 0.24630631, 0.24848632, \
0.25067733, 0.25287925, 0.25509200, 0.25731549, 0.25954966, \
0.26179440, 0.26404964, 0.26631528, 0.26859125, 0.27087746, \
0.27317382, 0.27548025, 0.27779665, 0.28012295, 0.28245905, \
0.28480486, 0.28716030, 0.28952528, 0.29189971, 0.29428350, \
0.29667656, 0.29907879, 0.30149011, 0.30391043, 0.30633966, \
0.30877770, 0.31122447, 0.31367986, 0.31614379, 0.31861617, \
0.32109689, 0.32358588, 0.32608303, 0.32858825, 0.33110144, \
0.33362251, 0.33615137, 0.33868792, 0.34123206, 0.34378370, \
0.34634275, 0.34890909, 0.35148265, 0.35406332, 0.35665100, \
0.35924560, 0.36184702, 0.36445515, 0.36706991, 0.36969120, \
0.37231891, 0.37495294, 0.37759320, 0.38023958, 0.38289200, \
0.38555034, 0.38821450, 0.39088439, 0.39355991, 0.39624095, \
0.39892741, 0.40161920, 0.40431620, 0.40701833, 0.40972547, \
0.41243752, 0.41515439, 0.41787596, 0.42060215, 0.42333283, \
0.42606792, 0.42880731, 0.43155089, 0.43429856, 0.43705022, \
0.43980576, 0.44256509, 0.44532808, 0.44809465, 0.45086469, \
0.45363809, 0.45641474, 0.45919455, 0.46197741, 0.46476321, \
0.46755185, 0.47034322, 0.47313722, 0.47593374, 0.47873268, \
0.48153393, 0.48433739, 0.48714294, 0.48995049, 0.49275993, \
0.49557115, 0.49838404, 0.50119851, 0.50401444, 0.50683172, \
0.50965026, 0.51246994, 0.51529067, 0.51811232, 0.52093480, \
0.52375800, 0.52658181, 0.52940612, 0.53223084, 0.53505585, \
0.53788104, 0.54070632, 0.54353157, 0.54635669, 0.54918156, \
0.55200609, 0.55483017, 0.55765369, 0.56047654, 0.56329862, \
0.56611982, 0.56894003, 0.57175916, 0.57457708, 0.57739370, \
0.58020891, 0.58302261, 0.58583468, 0.58864502, 0.59145352, \
0.59426009, 0.59706461, 0.59986697, 0.60266708, 0.60546483, \
0.60826010, 0.61105280, 0.61384282, 0.61663005, 0.61941439, \
0.62219574, 0.62497399, 0.62774903, 0.63052076, 0.63328907, \
0.63605387, 0.63881504, 0.64157249, 0.64432610, 0.64707578, \
0.64982142, 0.65256291, 0.65530016, 0.65803307, 0.66076151, \
0.66348541, 0.66620464, 0.66891911, 0.67162872, 0.67433337, \
0.67703295, 0.67972735, 0.68241649, 0.68510026, 0.68777855, \
0.69045126, 0.69311830, 0.69577957, 0.69843496, 0.70108437, \
0.70372770, 0.70636486, 0.70899575, 0.71162025, 0.71423829, \
0.71684975, 0.71945454, 0.72205256, 0.72464371, 0.72722790, \
0.72980502, 0.73237499, 0.73493769, 0.73749305, 0.74004095, \
0.74258131, 0.74511403, 0.74763900, 0.75015615, 0.75266537, \
0.75516656, 0.75765964, 0.76014451, 0.76262107, 0.76508924, \
0.76754891, 0.77000000, 0.77244241, 0.77487606, 0.77730084, \
0.77971668, 0.78212347, 0.78452113, 0.78690956, 0.78928868, \
0.79165839, 0.79401861, 0.79636925, 0.79871022, 0.80104143, \
0.80336279, 0.80567422, 0.80797562, 0.81026692, 0.81254802, \
0.81481884, 0.81707929, 0.81932929, 0.82156875, 0.82379759, \
0.82601573, 0.82822307, 0.83041955, 0.83260506, 0.83477954, \
0.83694290, 0.83909506, 0.84123594, 0.84336545, 0.84548352, \
0.84759006, 0.84968500, 0.85176826, 0.85383976, 0.85589942, \
0.85794716, 0.85998291, 0.86200658, 0.86401812, 0.86601742, \
0.86800443, 0.86997907, 0.87194125, 0.87389092, 0.87582799, \
0.87775239, 0.87966405, 0.88156290, 0.88344887, 0.88532187, \
0.88718185, 0.88902874, 0.89086245, 0.89268294, 0.89449011, \
0.89628392, 0.89806428, 0.89983114, 0.90158442, 0.90332407, \
0.90505000, 0.90676217, 0.90846050, 0.91014494, 0.91181540, \
0.91347185, 0.91511420, 0.91674241, 0.91835640, 0.91995612, \
0.92154150, 0.92311250, 0.92466904, 0.92621107, 0.92773853, \
0.92925137, 0.93074952, 0.93223293, 0.93370154, 0.93515530, \
0.93659416, 0.93801806, 0.93942694, 0.94082075, 0.94219944, \
0.94356296, 0.94491126, 0.94624428, 0.94756198, 0.94886431, \
0.95015121, 0.95142263, 0.95267854, 0.95391888, 0.95514361, \
0.95635267, 0.95754603, 0.95872364, 0.95988545, 0.96103143, \
0.96216152, 0.96327568, 0.96437388, 0.96545607, 0.96652221, \
0.96757226, 0.96860618, 0.96962393, 0.97062548, 0.97161078, \
0.97257980, 0.97353250, 0.97446885, 0.97538881, 0.97629234, \
0.97717942, 0.97805000, 0.97890406, 0.97974156, 0.98056247, \
0.98136677, 0.98215441, 0.98292538, 0.98367963, 0.98441715, \
0.98513791, 0.98584187, 0.98652902, 0.98719932, 0.98785275, \
0.98848928, 0.98910890, 0.98971157, 0.99029729, 0.99086601, \
0.99141773, 0.99195241, 0.99247005, 0.99297062, 0.99345411, \
0.99392048, 0.99436974, 0.99480185, 0.99521681, 0.99561459, \
0.99599519, 0.99635858, 0.99670477, 0.99703372, 0.99734543, \
0.99763989, 0.99791708, 0.99817701, 0.99841964, 0.99864499, \
0.99885303, 0.99904377, 0.99921718, 0.99937328, 0.99951204, \
0.99963347, 0.99973757, 0.99982432, 0.99989372, 0.99994577, \
0.99998048, 0.99999783, } 

#define HAMMING2048 {\
0.08000000, 0.08000217, 0.08000867, 0.08001950, 0.08003467, \
0.08005417, 0.08007801, 0.08010618, 0.08013868, 0.08017551, \
0.08021668, 0.08026218, 0.08031201, 0.08036617, 0.08042466, \
0.08048748, 0.08055463, 0.08062611, 0.08070192, 0.08078205, \
0.08086651, 0.08095530, 0.08104841, 0.08114585, 0.08124761, \
0.08135369, 0.08146409, 0.08157881, 0.08169786, 0.08182121, \
0.08194889, 0.08208088, 0.08221719, 0.08235781, 0.08250274, \
0.08265198, 0.08280553, 0.08296339, 0.08312555, 0.08329202, \
0.08346279, 0.08363786, 0.08381724, 0.08400090, 0.08418887, \
0.08438113, 0.08457769, 0.08477853, 0.08498366, 0.08519308, \
0.08540679, 0.08562478, 0.08584704, 0.08607359, 0.08630442, \
0.08653952, 0.08677889, 0.08702253, 0.08727044, 0.08752261, \
0.08777905, 0.08803975, 0.08830470, 0.08857392, 0.08884738, \
0.08912510, 0.08940706, 0.08969327, 0.08998372, 0.09027841, \
0.09057734, 0.09088050, 0.09118790, 0.09149952, 0.09181537, \
0.09213544, 0.09245973, 0.09278824, 0.09312096, 0.09345789, \
0.09379903, 0.09414437, 0.09449391, 0.09484765, 0.09520559, \
0.09556771, 0.09593402, 0.09630452, 0.09667920, 0.09705805, \
0.09744107, 0.09782827, 0.09821963, 0.09861515, 0.09901484, \
0.09941867, 0.09982666, 0.10023880, 0.10065508, 0.10107549, \
0.10150005, 0.10192873, 0.10236154, 0.10279848, 0.10323953, \
0.10368470, 0.10413398, 0.10458737, 0.10504486, 0.10550644, \
0.10597213, 0.10644189, 0.10691575, 0.10739368, 0.10787569, \
0.10836178, 0.10885193, 0.10934614, 0.10984440, 0.11034673, \
0.11085309, 0.11136351, 0.11187796, 0.11239644, 0.11291895, \
0.11344549, 0.11397605, 0.11451062, 0.11504919, 0.11559178, \
0.11613836, 0.11668893, 0.11724349, 0.11780204, 0.11836456, \
0.11893106, 0.11950152, 0.12007594, 0.12065432, 0.12123665, \
0.12182293, 0.12241315, 0.12300730, 0.12360538, 0.12420738, \
0.12481330, 0.12542313, 0.12603687, 0.12665451, 0.12727604, \
0.12790146, 0.12853077, 0.12916395, 0.12980100, 0.13044192, \
0.13108669, 0.13173532, 0.13238779, 0.13304410, 0.13370425, \
0.13436823, 0.13503603, 0.13570764, 0.13638306, 0.13706229, \
0.13774531, 0.13843212, 0.13912271, 0.13981709, 0.14051523, \
0.14121713, 0.14192280, 0.14263221, 0.14334537, 0.14406226, \
0.14478289, 0.14550723, 0.14623530, 0.14696707, 0.14770255, \
0.14844173, 0.14918459, 0.14993113, 0.15068135, 0.15143524, \
0.15219279, 0.15295399, 0.15371884, 0.15448733, 0.15525945, \
0.15603520, 0.15681456, 0.15759754, 0.15838411, 0.15917428, \
0.15996804, 0.16076538, 0.16156630, 0.16237078, 0.16317881, \
0.16399040, 0.16480553, 0.16562419, 0.16644638, 0.16727209, \
0.16810132, 0.16893404, 0.16977027, 0.17060998, 0.17145317, \
0.17229983, 0.17314996, 0.17400354, 0.17486058, 0.17572105, \
0.17658495, 0.17745228, 0.17832302, 0.17919718, 0.18007473, \
0.18095567, 0.18183999, 0.18272769, 0.18361876, 0.18451318, \
0.18541095, 0.18631207, 0.18721651, 0.18812428, 0.18903537, \
0.18994976, 0.19086745, 0.19178843, 0.19271268, 0.19364022, \
0.19457101, 0.19550506, 0.19644235, 0.19738288, 0.19832664, \
0.19927362, 0.20022381, 0.20117720, 0.20213378, 0.20309355, \
0.20405649, 0.20502259, 0.20599185, 0.20696426, 0.20793981, \
0.20891848, 0.20990027, 0.21088518, 0.21187318, 0.21286428, \
0.21385845, 0.21485570, 0.21585602, 0.21685939, 0.21786580, \
0.21887525, 0.21988772, 0.22090321, 0.22192170, 0.22294319, \
0.22396767, 0.22499513, 0.22602555, 0.22705894, 0.22809527, \
0.22913454, 0.23017674, 0.23122185, 0.23226988, 0.23332081, \
0.23437462, 0.23543132, 0.23649088, 0.23755330, 0.23861858, \
0.23968669, 0.24075763, 0.24183139, 0.24290797, 0.24398734, \
0.24506949, 0.24615443, 0.24724214, 0.24833260, 0.24942581, \
0.25052176, 0.25162044, 0.25272184, 0.25382594, 0.25493273, \
0.25604222, 0.25715437, 0.25826920, 0.25938668, 0.26050680, \
0.26162955, 0.26275493, 0.26388292, 0.26501351, 0.26614669, \
0.26728245, 0.26842078, 0.26956167, 0.27070511, 0.27185109, \
0.27299959, 0.27415060, 0.27530413, 0.27646014, 0.27761864, \
0.27877961, 0.27994304, 0.28110892, 0.28227724, 0.28344799, \
0.28462116, 0.28579673, 0.28697470, 0.28815505, 0.28933777, \
0.29052286, 0.29171030, 0.29290007, 0.29409217, 0.29528659, \
0.29648332, 0.29768234, 0.29888364, 0.30008722, 0.30129305, \
0.30250114, 0.30371146, 0.30492401, 0.30613877, 0.30735574, \
0.30857489, 0.30979623, 0.31101974, 0.31224540, 0.31347321, \
0.31470316, 0.31593523, 0.31716941, 0.31840568, 0.31964405, \
0.32088449, 0.32212700, 0.32337156, 0.32461815, 0.32586678, \
0.32711743, 0.32837008, 0.32962473, 0.33088136, 0.33213996, \
0.33340051, 0.33466302, 0.33592745, 0.33719381, 0.33846208, \
0.33973225, 0.34100431, 0.34227824, 0.34355404, 0.34483168, \
0.34611117, 0.34739248, 0.34867560, 0.34996053, 0.35124725, \
0.35253575, 0.35382601, 0.35511803, 0.35641179, 0.35770728, \
0.35900448, 0.36030339, 0.36160400, 0.36290629, 0.36421024, \
0.36551585, 0.36682310, 0.36813199, 0.36944249, 0.37075461, \
0.37206831, 0.37338360, 0.37470046, 0.37601887, 0.37733884, \
0.37866033, 0.37998334, 0.38130786, 0.38263388, 0.38396138, \
0.38529035, 0.38662077, 0.38795264, 0.38928595, 0.39062067, \
0.39195680, 0.39329433, 0.39463324, 0.39597352, 0.39731515, \
0.39865813, 0.40000244, 0.40134807, 0.40269501, 0.40404324, \
0.40539275, 0.40674353, 0.40809556, 0.40944884, 0.41080335, \
0.41215907, 0.41351600, 0.41487412, 0.41623342, 0.41759389, \
0.41895550, 0.42031826, 0.42168215, 0.42304715, 0.42441326, \
0.42578045, 0.42714872, 0.42851805, 0.42988843, 0.43125985, \
0.43263229, 0.43400575, 0.43538020, 0.43675564, 0.43813206, \
0.43950943, 0.44088775, 0.44226700, 0.44364718, 0.44502826, \
0.44641023, 0.44779309, 0.44917682, 0.45056140, 0.45194683, \
0.45333308, 0.45472015, 0.45610803, 0.45749669, 0.45888614, \
0.46027634, 0.46166730, 0.46305900, 0.46445142, 0.46584455, \
0.46723838, 0.46863290, 0.47002809, 0.47142394, 0.47282043, \
0.47421756, 0.47561531, 0.47701366, 0.47841261, 0.47981213, \
0.48121223, 0.48261288, 0.48401407, 0.48541578, 0.48681801, \
0.48822075, 0.48962397, 0.49102766, 0.49243182, 0.49383642, \
0.49524146, 0.49664692, 0.49805279, 0.49945905, 0.50086570, \
0.50227272, 0.50368009, 0.50508780, 0.50649584, 0.50790420, \
0.50931286, 0.51072181, 0.51213103, 0.51354052, 0.51495025, \
0.51636023, 0.51777042, 0.51918083, 0.52059143, 0.52200221, \
0.52341316, 0.52482427, 0.52623553, 0.52764691, 0.52905841, \
0.53047001, 0.53188170, 0.53329347, 0.53470530, 0.53611718, \
0.53752910, 0.53894104, 0.54035299, 0.54176494, 0.54317687, \
0.54458877, 0.54600062, 0.54741243, 0.54882416, 0.55023581, \
0.55164736, 0.55305880, 0.55447012, 0.55588130, 0.55729233, \
0.55870320, 0.56011390, 0.56152440, 0.56293470, 0.56434479, \
0.56575465, 0.56716426, 0.56857362, 0.56998270, 0.57139151, \
0.57280002, 0.57420822, 0.57561610, 0.57702364, 0.57843084, \
0.57983767, 0.58124413, 0.58265020, 0.58405586, 0.58546111, \
0.58686594, 0.58827032, 0.58967424, 0.59107770, 0.59248068, \
0.59388316, 0.59528514, 0.59668659, 0.59808751, 0.59948789, \
0.60088770, 0.60228694, 0.60368559, 0.60508364, 0.60648108, \
0.60787790, 0.60927407, 0.61066959, 0.61206444, 0.61345862, \
0.61485210, 0.61624488, 0.61763694, 0.61902827, 0.62041886, \
0.62180868, 0.62319774, 0.62458601, 0.62597348, 0.62736015, \
0.62874599, 0.63013100, 0.63151515, 0.63289845, 0.63428087, \
0.63566240, 0.63704303, 0.63842274, 0.63980153, 0.64117938, \
0.64255627, 0.64393220, 0.64530715, 0.64668110, 0.64805405, \
0.64942599, 0.65079689, 0.65216675, 0.65353555, 0.65490328, \
0.65626993, 0.65763549, 0.65899993, 0.66036326, 0.66172545, \
0.66308649, 0.66444638, 0.66580509, 0.66716261, 0.66851894, \
0.66987406, 0.67122795, 0.67258061, 0.67393202, 0.67528217, \
0.67663104, 0.67797862, 0.67932491, 0.68066988, 0.68201353, \
0.68335583, 0.68469679, 0.68603639, 0.68737461, 0.68871144, \
0.69004687, 0.69138088, 0.69271347, 0.69404462, 0.69537432, \
0.69670256, 0.69802932, 0.69935459, 0.70067835, 0.70200061, \
0.70332134, 0.70464053, 0.70595817, 0.70727424, 0.70858874, \
0.70990165, 0.71121296, 0.71252266, 0.71383073, 0.71513716, \
0.71644195, 0.71774507, 0.71904651, 0.72034627, 0.72164433, \
0.72294068, 0.72423531, 0.72552820, 0.72681934, 0.72810872, \
0.72939633, 0.73068216, 0.73196618, 0.73324840, 0.73452880, \
0.73580737, 0.73708409, 0.73835896, 0.73963195, 0.74090307, \
0.74217229, 0.74343961, 0.74470501, 0.74596848, 0.74723001, \
0.74848959, 0.74974720, 0.75100284, 0.75225649, 0.75350814, \
0.75475778, 0.75600540, 0.75725098, 0.75849451, 0.75973599, \
0.76097539, 0.76221272, 0.76344795, 0.76468107, 0.76591208, \
0.76714096, 0.76836770, 0.76959228, 0.77081471, 0.77203496, \
0.77325302, 0.77446889, 0.77568254, 0.77689398, 0.77810319, \
0.77931015, 0.78051485, 0.78171729, 0.78291746, 0.78411533, \
0.78531091, 0.78650417, 0.78769511, 0.78888372, 0.79006998, \
0.79125388, 0.79243542, 0.79361458, 0.79479136, 0.79596573, \
0.79713768, 0.79830722, 0.79947432, 0.80063898, 0.80180118, \
0.80296092, 0.80411818, 0.80527295, 0.80642522, 0.80757498, \
0.80872222, 0.80986693, 0.81100909, 0.81214870, 0.81328575, \
0.81442022, 0.81555211, 0.81668140, 0.81780809, 0.81893215, \
0.82005359, 0.82117239, 0.82228855, 0.82340204, 0.82451286, \
0.82562100, 0.82672645, 0.82782920, 0.82892924, 0.83002655, \
0.83112113, 0.83221297, 0.83330206, 0.83438838, 0.83547193, \
0.83655270, 0.83763067, 0.83870584, 0.83977819, 0.84084772, \
0.84191441, 0.84297826, 0.84403926, 0.84509739, 0.84615265, \
0.84720502, 0.84825450, 0.84930107, 0.85034473, 0.85138546, \
0.85242327, 0.85345812, 0.85449003, 0.85551897, 0.85654494, \
0.85756793, 0.85858792, 0.85960491, 0.86061890, 0.86162986, \
0.86263779, 0.86364268, 0.86464452, 0.86564330, 0.86663902, \
0.86763166, 0.86862121, 0.86960766, 0.87059101, 0.87157125, \
0.87254836, 0.87352234, 0.87449317, 0.87546085, 0.87642538, \
0.87738673, 0.87834491, 0.87929989, 0.88025168, 0.88120027, \
0.88214564, 0.88308779, 0.88402670, 0.88496237, 0.88589479, \
0.88682396, 0.88774985, 0.88867247, 0.88959181, 0.89050785, \
0.89142059, 0.89233002, 0.89323613, 0.89413891, 0.89503835, \
0.89593445, 0.89682719, 0.89771658, 0.89860259, 0.89948522, \
0.90036447, 0.90124032, 0.90211277, 0.90298181, 0.90384743, \
0.90470962, 0.90556837, 0.90642368, 0.90727554, 0.90812393, \
0.90896886, 0.90981031, 0.91064828, 0.91148276, 0.91231373, \
0.91314120, 0.91396515, 0.91478558, 0.91560248, 0.91641584, \
0.91722565, 0.91803191, 0.91883461, 0.91963373, 0.92042928, \
0.92122125, 0.92200963, 0.92279440, 0.92357557, 0.92435313, \
0.92512706, 0.92589737, 0.92666404, 0.92742706, 0.92818644, \
0.92894216, 0.92969422, 0.93044260, 0.93118730, 0.93192832, \
0.93266565, 0.93339928, 0.93412920, 0.93485540, 0.93557789, \
0.93629665, 0.93701168, 0.93772297, 0.93843050, 0.93913429, \
0.93983431, 0.94053057, 0.94122306, 0.94191176, 0.94259668, \
0.94327780, 0.94395512, 0.94462864, 0.94529835, 0.94596424, \
0.94662630, 0.94728453, 0.94793893, 0.94858948, 0.94923618, \
0.94987903, 0.95051801, 0.95115313, 0.95178437, 0.95241173, \
0.95303521, 0.95365480, 0.95427048, 0.95488227, 0.95549015, \
0.95609411, 0.95669415, 0.95729027, 0.95788245, 0.95847070, \
0.95905501, 0.95963536, 0.96021177, 0.96078421, 0.96135269, \
0.96191720, 0.96247773, 0.96303429, 0.96358686, 0.96413543, \
0.96468002, 0.96522060, 0.96575717, 0.96628973, 0.96681828, \
0.96734281, 0.96786330, 0.96837977, 0.96889220, 0.96940060, \
0.96990494, 0.97040524, 0.97090148, 0.97139366, 0.97188177, \
0.97236582, 0.97284579, 0.97332169, 0.97379350, 0.97426123, \
0.97472486, 0.97518440, 0.97563984, 0.97609117, 0.97653840, \
0.97698151, 0.97742050, 0.97785538, 0.97828613, 0.97871275, \
0.97913523, 0.97955358, 0.97996779, 0.98037785, 0.98078376, \
0.98118552, 0.98158313, 0.98197657, 0.98236585, 0.98275096, \
0.98313190, 0.98350867, 0.98388125, 0.98424966, 0.98461387, \
0.98497390, 0.98532974, 0.98568138, 0.98602883, 0.98637207, \
0.98671110, 0.98704593, 0.98737654, 0.98770294, 0.98802512, \
0.98834308, 0.98865682, 0.98896633, 0.98927161, 0.98957265, \
0.98986946, 0.99016203, 0.99045037, 0.99073445, 0.99101429, \
0.99128988, 0.99156122, 0.99182831, 0.99209113, 0.99234970, \
0.99260401, 0.99285405, 0.99309983, 0.99334133, 0.99357857, \
0.99381153, 0.99404022, 0.99426463, 0.99448475, 0.99470060, \
0.99491216, 0.99511944, 0.99532243, 0.99552113, 0.99571554, \
0.99590565, 0.99609147, 0.99627299, 0.99645021, 0.99662313, \
0.99679175, 0.99695607, 0.99711608, 0.99727178, 0.99742318, \
0.99757027, 0.99771304, 0.99785150, 0.99798565, 0.99811549, \
0.99824100, 0.99836221, 0.99847909, 0.99859165, 0.99869989, \
0.99880381, 0.99890341, 0.99899868, 0.99908963, 0.99917626, \
0.99925856, 0.99933653, 0.99941017, 0.99947948, 0.99954447, \
0.99960513, 0.99966145, 0.99971345, 0.99976111, 0.99980445, \
0.99984345, 0.99987811, 0.99990845, 0.99993445, 0.99995612, \
0.99997345, 0.99998646, 0.99999512, 0.99999946, } 

#define HAMMING4096 {\
0.08000000, 0.08000054, 0.08000217, 0.08000487, 0.08000866, \
0.08001354, 0.08001949, 0.08002653, 0.08003465, 0.08004386, \
0.08005415, 0.08006552, 0.08007797, 0.08009151, 0.08010613, \
0.08012183, 0.08013861, 0.08015648, 0.08017543, 0.08019546, \
0.08021657, 0.08023877, 0.08026205, 0.08028641, 0.08031186, \
0.08033838, 0.08036599, 0.08039468, 0.08042445, 0.08045531, \
0.08048724, 0.08052026, 0.08055436, 0.08058954, 0.08062581, \
0.08066315, 0.08070158, 0.08074108, 0.08078167, 0.08082334, \
0.08086609, 0.08090992, 0.08095483, 0.08100083, 0.08104790, \
0.08109605, 0.08114529, 0.08119560, 0.08124700, 0.08129947, \
0.08135303, 0.08140766, 0.08146338, 0.08152017, 0.08157804, \
0.08163700, 0.08169703, 0.08175814, 0.08182033, 0.08188359, \
0.08194794, 0.08201336, 0.08207987, 0.08214745, 0.08221611, \
0.08228584, 0.08235666, 0.08242855, 0.08250152, 0.08257556, \
0.08265069, 0.08272689, 0.08280416, 0.08288251, 0.08296194, \
0.08304245, 0.08312403, 0.08320668, 0.08329041, 0.08337522, \
0.08346110, 0.08354806, 0.08363609, 0.08372519, 0.08381537, \
0.08390663, 0.08399895, 0.08409235, 0.08418683, 0.08428238, \
0.08437900, 0.08447669, 0.08457545, 0.08467529, 0.08477620, \
0.08487818, 0.08498123, 0.08508536, 0.08519055, 0.08529682, \
0.08540415, 0.08551256, 0.08562203, 0.08573258, 0.08584419, \
0.08595688, 0.08607063, 0.08618545, 0.08630134, 0.08641830, \
0.08653633, 0.08665542, 0.08677558, 0.08689681, 0.08701911, \
0.08714247, 0.08726690, 0.08739239, 0.08751895, 0.08764657, \
0.08777526, 0.08790501, 0.08803583, 0.08816771, 0.08830066, \
0.08843467, 0.08856974, 0.08870588, 0.08884307, 0.08898133, \
0.08912066, 0.08926104, 0.08940248, 0.08954499, 0.08968855, \
0.08983318, 0.08997886, 0.09012561, 0.09027341, 0.09042228, \
0.09057220, 0.09072318, 0.09087521, 0.09102831, 0.09118246, \
0.09133767, 0.09149393, 0.09165125, 0.09180962, 0.09196906, \
0.09212954, 0.09229108, 0.09245367, 0.09261732, 0.09278202, \
0.09294778, 0.09311458, 0.09328244, 0.09345135, 0.09362131, \
0.09379232, 0.09396439, 0.09413750, 0.09431166, 0.09448687, \
0.09466313, 0.09484044, 0.09501880, 0.09519820, 0.09537865, \
0.09556015, 0.09574270, 0.09592629, 0.09611092, 0.09629660, \
0.09648333, 0.09667110, 0.09685991, 0.09704977, 0.09724067, \
0.09743261, 0.09762559, 0.09781962, 0.09801469, 0.09821079, \
0.09840794, 0.09860613, 0.09880535, 0.09900562, 0.09920692, \
0.09940926, 0.09961264, 0.09981705, 0.10002250, 0.10022899, \
0.10043651, 0.10064507, 0.10085466, 0.10106528, 0.10127694, \
0.10148963, 0.10170335, 0.10191811, 0.10213390, 0.10235071, \
0.10256856, 0.10278744, 0.10300735, 0.10322828, 0.10345025, \
0.10367324, 0.10389726, 0.10412230, 0.10434837, 0.10457547, \
0.10480359, 0.10503274, 0.10526291, 0.10549411, 0.10572632, \
0.10595956, 0.10619382, 0.10642911, 0.10666541, 0.10690274, \
0.10714108, 0.10738044, 0.10762082, 0.10786222, 0.10810464, \
0.10834807, 0.10859252, 0.10883798, 0.10908446, 0.10933196, \
0.10958047, 0.10982999, 0.11008052, 0.11033207, 0.11058463, \
0.11083820, 0.11109278, 0.11134837, 0.11160496, 0.11186257, \
0.11212119, 0.11238081, 0.11264144, 0.11290307, 0.11316571, \
0.11342936, 0.11369401, 0.11395966, 0.11422632, 0.11449398, \
0.11476264, 0.11503230, 0.11530296, 0.11557462, 0.11584728, \
0.11612094, 0.11639560, 0.11667125, 0.11694791, 0.11722555, \
0.11750420, 0.11778383, 0.11806446, 0.11834609, 0.11862871, \
0.11891232, 0.11919692, 0.11948251, 0.11976909, 0.12005666, \
0.12034522, 0.12063477, 0.12092530, 0.12121682, 0.12150933, \
0.12180282, 0.12209730, 0.12239276, 0.12268920, 0.12298663, \
0.12328504, 0.12358443, 0.12388480, 0.12418615, 0.12448847, \
0.12479178, 0.12509606, 0.12540132, 0.12570756, 0.12601477, \
0.12632296, 0.12663212, 0.12694225, 0.12725336, 0.12756544, \
0.12787849, 0.12819251, 0.12850749, 0.12882345, 0.12914038, \
0.12945827, 0.12977713, 0.13009695, 0.13041774, 0.13073950, \
0.13106221, 0.13138589, 0.13171054, 0.13203614, 0.13236270, \
0.13269023, 0.13301871, 0.13334815, 0.13367855, 0.13400990, \
0.13434221, 0.13467548, 0.13500970, 0.13534487, 0.13568100, \
0.13601808, 0.13635610, 0.13669508, 0.13703501, 0.13737589, \
0.13771771, 0.13806049, 0.13840421, 0.13874887, 0.13909448, \
0.13944103, 0.13978853, 0.14013696, 0.14048634, 0.14083666, \
0.14118792, 0.14154012, 0.14189325, 0.14224733, 0.14260234, \
0.14295828, 0.14331516, 0.14367298, 0.14403172, 0.14439140, \
0.14475201, 0.14511355, 0.14547603, 0.14583943, 0.14620375, \
0.14656901, 0.14693519, 0.14730229, 0.14767033, 0.14803928, \
0.14840916, 0.14877996, 0.14915168, 0.14952432, 0.14989788, \
0.15027235, 0.15064775, 0.15102406, 0.15140129, 0.15177943, \
0.15215849, 0.15253846, 0.15291934, 0.15330113, 0.15368384, \
0.15406745, 0.15445197, 0.15483740, 0.15522374, 0.15561098, \
0.15599913, 0.15638818, 0.15677813, 0.15716899, 0.15756074, \
0.15795340, 0.15834696, 0.15874141, 0.15913677, 0.15953302, \
0.15993016, 0.16032820, 0.16072714, 0.16112697, 0.16152769, \
0.16192930, 0.16233180, 0.16273518, 0.16313946, 0.16354463, \
0.16395068, 0.16435761, 0.16476544, 0.16517414, 0.16558373, \
0.16599419, 0.16640554, 0.16681777, 0.16723088, 0.16764486, \
0.16805972, 0.16847546, 0.16889207, 0.16930955, 0.16972791, \
0.17014714, 0.17056724, 0.17098821, 0.17141005, 0.17183276, \
0.17225633, 0.17268077, 0.17310607, 0.17353224, 0.17395927, \
0.17438716, 0.17481591, 0.17524552, 0.17567600, 0.17610732, \
0.17653951, 0.17697255, 0.17740645, 0.17784120, 0.17827680, \
0.17871325, 0.17915055, 0.17958871, 0.18002771, 0.18046756, \
0.18090826, 0.18134980, 0.18179218, 0.18223541, 0.18267948, \
0.18312440, 0.18357015, 0.18401674, 0.18446417, 0.18491244, \
0.18536154, 0.18581148, 0.18626225, 0.18671385, 0.18716629, \
0.18761956, 0.18807365, 0.18852858, 0.18898433, 0.18944091, \
0.18989831, 0.19035654, 0.19081559, 0.19127547, 0.19173616, \
0.19219767, 0.19266001, 0.19312316, 0.19358713, 0.19405191, \
0.19451751, 0.19498392, 0.19545114, 0.19591917, 0.19638802, \
0.19685767, 0.19732813, 0.19779940, 0.19827147, 0.19874435, \
0.19921803, 0.19969252, 0.20016780, 0.20064389, 0.20112077, \
0.20159845, 0.20207693, 0.20255620, 0.20303627, 0.20351713, \
0.20399879, 0.20448123, 0.20496447, 0.20544849, 0.20593330, \
0.20641890, 0.20690528, 0.20739245, 0.20788040, 0.20836913, \
0.20885864, 0.20934894, 0.20984001, 0.21033185, 0.21082448, \
0.21131788, 0.21181205, 0.21230700, 0.21280271, 0.21329920, \
0.21379646, 0.21429448, 0.21479327, 0.21529283, 0.21579315, \
0.21629423, 0.21679608, 0.21729869, 0.21780205, 0.21830618, \
0.21881106, 0.21931670, 0.21982310, 0.22033024, 0.22083815, \
0.22134680, 0.22185620, 0.22236635, 0.22287725, 0.22338889, \
0.22390129, 0.22441442, 0.22492830, 0.22544292, 0.22595828, \
0.22647438, 0.22699122, 0.22750879, 0.22802710, 0.22854615, \
0.22906592, 0.22958643, 0.23010767, 0.23062964, 0.23115234, \
0.23167577, 0.23219992, 0.23272480, 0.23325040, 0.23377672, \
0.23430376, 0.23483152, 0.23536001, 0.23588920, 0.23641912, \
0.23694975, 0.23748109, 0.23801314, 0.23854591, 0.23907938, \
0.23961357, 0.24014846, 0.24068405, 0.24122036, 0.24175736, \
0.24229507, 0.24283347, 0.24337258, 0.24391239, 0.24445289, \
0.24499409, 0.24553598, 0.24607857, 0.24662185, 0.24716582, \
0.24771047, 0.24825582, 0.24880185, 0.24934857, 0.24989598, \
0.25044406, 0.25099283, 0.25154228, 0.25209240, 0.25264321, \
0.25319469, 0.25374685, 0.25429968, 0.25485318, 0.25540736, \
0.25596220, 0.25651771, 0.25707390, 0.25763074, 0.25818825, \
0.25874643, 0.25930527, 0.25986476, 0.26042492, 0.26098574, \
0.26154721, 0.26210934, 0.26267212, 0.26323555, 0.26379964, \
0.26436438, 0.26492976, 0.26549580, 0.26606248, 0.26662980, \
0.26719777, 0.26776638, 0.26833563, 0.26890552, 0.26947605, \
0.27004722, 0.27061902, 0.27119146, 0.27176452, 0.27233822, \
0.27291255, 0.27348751, 0.27406310, 0.27463931, 0.27521615, \
0.27579361, 0.27637169, 0.27695040, 0.27752972, 0.27810966, \
0.27869022, 0.27927139, 0.27985317, 0.28043557, 0.28101858, \
0.28160220, 0.28218643, 0.28277126, 0.28335670, 0.28394275, \
0.28452940, 0.28511664, 0.28570449, 0.28629294, 0.28688199, \
0.28747163, 0.28806186, 0.28865269, 0.28924411, 0.28983612, \
0.29042872, 0.29102191, 0.29161568, 0.29221004, 0.29280498, \
0.29340050, 0.29399660, 0.29459329, 0.29519055, 0.29578838, \
0.29638680, 0.29698578, 0.29758534, 0.29818547, 0.29878616, \
0.29938743, 0.29998926, 0.30059166, 0.30119462, 0.30179814, \
0.30240222, 0.30300687, 0.30361207, 0.30421782, 0.30482414, \
0.30543100, 0.30603842, 0.30664639, 0.30725491, 0.30786397, \
0.30847359, 0.30908374, 0.30969445, 0.31030569, 0.31091747, \
0.31152980, 0.31214266, 0.31275606, 0.31336999, 0.31398446, \
0.31459946, 0.31521499, 0.31583104, 0.31644763, 0.31706474, \
0.31768238, 0.31830054, 0.31891922, 0.31953843, 0.32015815, \
0.32077839, 0.32139914, 0.32202042, 0.32264220, 0.32326449, \
0.32388730, 0.32451061, 0.32513444, 0.32575876, 0.32638360, \
0.32700893, 0.32763477, 0.32826110, 0.32888794, 0.32951527, \
0.33014310, 0.33077142, 0.33140023, 0.33202954, 0.33265933, \
0.33328962, 0.33392039, 0.33455164, 0.33518338, 0.33581560, \
0.33644830, 0.33708148, 0.33771514, 0.33834927, 0.33898388, \
0.33961896, 0.34025452, 0.34089054, 0.34152704, 0.34216400, \
0.34280142, 0.34343931, 0.34407767, 0.34471648, 0.34535575, \
0.34599549, 0.34663567, 0.34727632, 0.34791742, 0.34855897, \
0.34920097, 0.34984342, 0.35048632, 0.35112966, 0.35177345, \
0.35241768, 0.35306235, 0.35370747, 0.35435302, 0.35499901, \
0.35564543, 0.35629229, 0.35693958, 0.35758730, 0.35823546, \
0.35888404, 0.35953304, 0.36018247, 0.36083233, 0.36148260, \
0.36213330, 0.36278441, 0.36343595, 0.36408789, 0.36474025, \
0.36539303, 0.36604621, 0.36669981, 0.36735381, 0.36800822, \
0.36866304, 0.36931825, 0.36997387, 0.37062989, 0.37128631, \
0.37194313, 0.37260034, 0.37325795, 0.37391594, 0.37457433, \
0.37523311, 0.37589228, 0.37655183, 0.37721177, 0.37787209, \
0.37853279, 0.37919387, 0.37985534, 0.38051717, 0.38117939, \
0.38184198, 0.38250494, 0.38316827, 0.38383197, 0.38449603, \
0.38516047, 0.38582527, 0.38649043, 0.38715595, 0.38782183, \
0.38848807, 0.38915467, 0.38982162, 0.39048893, 0.39115659, \
0.39182460, 0.39249295, 0.39316166, 0.39383071, 0.39450010, \
0.39516984, 0.39583992, 0.39651034, 0.39718109, 0.39785218, \
0.39852361, 0.39919537, 0.39986746, 0.40053988, 0.40121263, \
0.40188570, 0.40255910, 0.40323283, 0.40390687, 0.40458124, \
0.40525593, 0.40593093, 0.40660625, 0.40728188, 0.40795783, \
0.40863408, 0.40931065, 0.40998752, 0.41066470, 0.41134218, \
0.41201997, 0.41269805, 0.41337644, 0.41405513, 0.41473411, \
0.41541338, 0.41609295, 0.41677282, 0.41745297, 0.41813341, \
0.41881414, 0.41949515, 0.42017644, 0.42085802, 0.42153988, \
0.42222202, 0.42290443, 0.42358712, 0.42427009, 0.42495333, \
0.42563683, 0.42632061, 0.42700466, 0.42768897, 0.42837354, \
0.42905838, 0.42974348, 0.43042884, 0.43111445, 0.43180033, \
0.43248646, 0.43317284, 0.43385947, 0.43454635, 0.43523348, \
0.43592086, 0.43660848, 0.43729635, 0.43798445, 0.43867280, \
0.43936139, 0.44005021, 0.44073927, 0.44142856, 0.44211809, \
0.44280784, 0.44349782, 0.44418803, 0.44487847, 0.44556913, \
0.44626001, 0.44695112, 0.44764244, 0.44833398, 0.44902573, \
0.44971770, 0.45040988, 0.45110228, 0.45179488, 0.45248769, \
0.45318071, 0.45387393, 0.45456735, 0.45526097, 0.45595480, \
0.45664882, 0.45734304, 0.45803745, 0.45873206, 0.45942685, \
0.46012184, 0.46081701, 0.46151237, 0.46220792, 0.46290365, \
0.46359956, 0.46429565, 0.46499192, 0.46568836, 0.46638498, \
0.46708178, 0.46777874, 0.46847588, 0.46917318, 0.46987065, \
0.47056828, 0.47126608, 0.47196404, 0.47266216, 0.47336044, \
0.47405888, 0.47475747, 0.47545622, 0.47615511, 0.47685416, \
0.47755335, 0.47825270, 0.47895219, 0.47965182, 0.48035159, \
0.48105151, 0.48175156, 0.48245175, 0.48315208, 0.48385254, \
0.48455313, 0.48525385, 0.48595470, 0.48665568, 0.48735678, \
0.48805801, 0.48875936, 0.48946083, 0.49016242, 0.49086413, \
0.49156595, 0.49226789, 0.49296994, 0.49367210, 0.49437437, \
0.49507674, 0.49577923, 0.49648181, 0.49718450, 0.49788729, \
0.49859018, 0.49929317, 0.49999625, 0.50069943, 0.50140269, \
0.50210605, 0.50280950, 0.50351304, 0.50421666, 0.50492037, \
0.50562416, 0.50632803, 0.50703198, 0.50773600, 0.50844011, \
0.50914428, 0.50984853, 0.51055285, 0.51125724, 0.51196170, \
0.51266623, 0.51337081, 0.51407547, 0.51478018, 0.51548495, \
0.51618978, 0.51689466, 0.51759960, 0.51830459, 0.51900964, \
0.51971473, 0.52041987, 0.52112506, 0.52183029, 0.52253556, \
0.52324088, 0.52394623, 0.52465162, 0.52535705, 0.52606251, \
0.52676801, 0.52747354, 0.52817909, 0.52888468, 0.52959029, \
0.53029592, 0.53100158, 0.53170726, 0.53241296, 0.53311867, \
0.53382441, 0.53453015, 0.53523591, 0.53594168, 0.53664746, \
0.53735325, 0.53805905, 0.53876485, 0.53947065, 0.54017645, \
0.54088225, 0.54158805, 0.54229385, 0.54299964, 0.54370543, \
0.54441120, 0.54511697, 0.54582272, 0.54652846, 0.54723419, \
0.54793989, 0.54864558, 0.54935125, 0.55005690, 0.55076252, \
0.55146812, 0.55217369, 0.55287923, 0.55358474, 0.55429022, \
0.55499567, 0.55570108, 0.55640645, 0.55711179, 0.55781708, \
0.55852233, 0.55922754, 0.55993271, 0.56063782, 0.56134289, \
0.56204791, 0.56275287, 0.56345779, 0.56416264, 0.56486744, \
0.56557219, 0.56627687, 0.56698149, 0.56768604, 0.56839053, \
0.56909496, 0.56979931, 0.57050360, 0.57120781, 0.57191195, \
0.57261602, 0.57332001, 0.57402392, 0.57472775, 0.57543150, \
0.57613516, 0.57683874, 0.57754223, 0.57824564, 0.57894895, \
0.57965217, 0.58035530, 0.58105834, 0.58176128, 0.58246412, \
0.58316686, 0.58386949, 0.58457203, 0.58527446, 0.58597678, \
0.58667899, 0.58738110, 0.58808309, 0.58878497, 0.58948674, \
0.59018839, 0.59088992, 0.59159133, 0.59229262, 0.59299378, \
0.59369483, 0.59439574, 0.59509653, 0.59579719, 0.59649771, \
0.59719810, 0.59789836, 0.59859848, 0.59929847, 0.59999831, \
0.60069802, 0.60139758, 0.60209699, 0.60279626, 0.60349538, \
0.60419436, 0.60489318, 0.60559184, 0.60629036, 0.60698872, \
0.60768692, 0.60838496, 0.60908284, 0.60978055, 0.61047811, \
0.61117549, 0.61187271, 0.61256976, 0.61326664, 0.61396335, \
0.61465988, 0.61535624, 0.61605242, 0.61674842, 0.61744424, \
0.61813988, 0.61883533, 0.61953060, 0.62022568, 0.62092057, \
0.62161527, 0.62230978, 0.62300410, 0.62369822, 0.62439214, \
0.62508586, 0.62577939, 0.62647271, 0.62716583, 0.62785874, \
0.62855145, 0.62924394, 0.62993623, 0.63062831, 0.63132017, \
0.63201182, 0.63270325, 0.63339446, 0.63408546, 0.63477623, \
0.63546678, 0.63615710, 0.63684720, 0.63753707, 0.63822671, \
0.63891611, 0.63960529, 0.64029423, 0.64098293, 0.64167140, \
0.64235963, 0.64304762, 0.64373536, 0.64442286, 0.64511011, \
0.64579712, 0.64648388, 0.64717039, 0.64785664, 0.64854264, \
0.64922839, 0.64991387, 0.65059910, 0.65128407, 0.65196878, \
0.65265322, 0.65333740, 0.65402131, 0.65470495, 0.65538833, \
0.65607143, 0.65675426, 0.65743681, 0.65811908, 0.65880108, \
0.65948280, 0.66016424, 0.66084539, 0.66152626, 0.66220685, \
0.66288714, 0.66356715, 0.66424687, 0.66492629, 0.66560542, \
0.66628425, 0.66696279, 0.66764103, 0.66831896, 0.66899660, \
0.66967393, 0.67035096, 0.67102768, 0.67170409, 0.67238019, \
0.67305597, 0.67373145, 0.67440661, 0.67508146, 0.67575598, \
0.67643019, 0.67710407, 0.67777764, 0.67845088, 0.67912379, \
0.67979637, 0.68046863, 0.68114055, 0.68181215, 0.68248341, \
0.68315433, 0.68382492, 0.68449516, 0.68516507, 0.68583464, \
0.68650386, 0.68717274, 0.68784127, 0.68850945, 0.68917728, \
0.68984477, 0.69051190, 0.69117867, 0.69184509, 0.69251115, \
0.69317686, 0.69384220, 0.69450718, 0.69517179, 0.69583605, \
0.69649993, 0.69716344, 0.69782659, 0.69848936, 0.69915177, \
0.69981379, 0.70047544, 0.70113671, 0.70179761, 0.70245812, \
0.70311825, 0.70377799, 0.70443735, 0.70509633, 0.70575491, \
0.70641310, 0.70707091, 0.70772831, 0.70838533, 0.70904195, \
0.70969817, 0.71035399, 0.71100940, 0.71166442, 0.71231903, \
0.71297324, 0.71362704, 0.71428043, 0.71493341, 0.71558598, \
0.71623813, 0.71688987, 0.71754120, 0.71819210, 0.71884259, \
0.71949265, 0.72014230, 0.72079151, 0.72144031, 0.72208867, \
0.72273661, 0.72338412, 0.72403119, 0.72467783, 0.72532404, \
0.72596981, 0.72661514, 0.72726004, 0.72790449, 0.72854850, \
0.72919207, 0.72983519, 0.73047786, 0.73112009, 0.73176186, \
0.73240319, 0.73304406, 0.73368448, 0.73432444, 0.73496394, \
0.73560299, 0.73624157, 0.73687969, 0.73751735, 0.73815454, \
0.73879127, 0.73942753, 0.74006332, 0.74069864, 0.74133348, \
0.74196785, 0.74260175, 0.74323517, 0.74386811, 0.74450057, \
0.74513255, 0.74576405, 0.74639506, 0.74702559, 0.74765563, \
0.74828518, 0.74891424, 0.74954280, 0.75017088, 0.75079846, \
0.75142554, 0.75205213, 0.75267821, 0.75330380, 0.75392888, \
0.75455346, 0.75517754, 0.75580111, 0.75642417, 0.75704672, \
0.75766876, 0.75829028, 0.75891130, 0.75953180, 0.76015178, \
0.76077124, 0.76139018, 0.76200861, 0.76262650, 0.76324388, \
0.76386073, 0.76447705, 0.76509285, 0.76570811, 0.76632284, \
0.76693704, 0.76755071, 0.76816384, 0.76877643, 0.76938849, \
0.77000000, 0.77061097, 0.77122140, 0.77183129, 0.77244063, \
0.77304942, 0.77365766, 0.77426536, 0.77487250, 0.77547909, \
0.77608512, 0.77669060, 0.77729553, 0.77789989, 0.77850369, \
0.77910693, 0.77970961, 0.78031173, 0.78091328, 0.78151426, \
0.78211467, 0.78271451, 0.78331378, 0.78391248, 0.78451061, \
0.78510816, 0.78570513, 0.78630152, 0.78689733, 0.78749257, \
0.78808722, 0.78868128, 0.78927476, 0.78986765, 0.79045996, \
0.79105167, 0.79164280, 0.79223333, 0.79282327, 0.79341261, \
0.79400136, 0.79458951, 0.79517705, 0.79576400, 0.79635035, \
0.79693609, 0.79752123, 0.79810576, 0.79868968, 0.79927300, \
0.79985570, 0.80043779, 0.80101927, 0.80160014, 0.80218039, \
0.80276002, 0.80333903, 0.80391743, 0.80449520, 0.80507235, \
0.80564887, 0.80622477, 0.80680004, 0.80737469, 0.80794870, \
0.80852209, 0.80909484, 0.80966696, 0.81023844, 0.81080929, \
0.81137950, 0.81194907, 0.81251800, 0.81308629, 0.81365394, \
0.81422094, 0.81478730, 0.81535301, 0.81591807, 0.81648248, \
0.81704624, 0.81760935, 0.81817181, 0.81873361, 0.81929475, \
0.81985524, 0.82041507, 0.82097424, 0.82153274, 0.82209059, \
0.82264776, 0.82320428, 0.82376013, 0.82431530, 0.82486981, \
0.82542365, 0.82597682, 0.82652931, 0.82708113, 0.82763228, \
0.82818274, 0.82873253, 0.82928164, 0.82983007, 0.83037781, \
0.83092487, 0.83147125, 0.83201694, 0.83256194, 0.83310626, \
0.83364988, 0.83419281, 0.83473505, 0.83527660, 0.83581745, \
0.83635760, 0.83689706, 0.83743582, 0.83797387, 0.83851123, \
0.83904788, 0.83958383, 0.84011908, 0.84065361, 0.84118744, \
0.84172056, 0.84225297, 0.84278467, 0.84331566, 0.84384593, \
0.84437549, 0.84490432, 0.84543245, 0.84595985, 0.84648653, \
0.84701249, 0.84753773, 0.84806225, 0.84858603, 0.84910910, \
0.84963143, 0.85015304, 0.85067391, 0.85119406, 0.85171347, \
0.85223215, 0.85275009, 0.85326730, 0.85378376, 0.85429949, \
0.85481448, 0.85532873, 0.85584224, 0.85635500, 0.85686702, \
0.85737829, 0.85788882, 0.85839860, 0.85890762, 0.85941590, \
0.85992342, 0.86043019, 0.86093621, 0.86144147, 0.86194598, \
0.86244972, 0.86295271, 0.86345494, 0.86395640, 0.86445711, \
0.86495705, 0.86545622, 0.86595463, 0.86645227, 0.86694914, \
0.86744524, 0.86794057, 0.86843513, 0.86892892, 0.86942193, \
0.86991417, 0.87040563, 0.87089631, 0.87138621, 0.87187533, \
0.87236367, 0.87285123, 0.87333801, 0.87382400, 0.87430920, \
0.87479362, 0.87527725, 0.87576009, 0.87624214, 0.87672340, \
0.87720386, 0.87768353, 0.87816241, 0.87864049, 0.87911777, \
0.87959426, 0.88006994, 0.88054483, 0.88101891, 0.88149219, \
0.88196466, 0.88243633, 0.88290720, 0.88337726, 0.88384650, \
0.88431494, 0.88478257, 0.88524939, 0.88571539, 0.88618058, \
0.88664496, 0.88710852, 0.88757126, 0.88803319, 0.88849429, \
0.88895457, 0.88941404, 0.88987268, 0.89033049, 0.89078748, \
0.89124365, 0.89169899, 0.89215350, 0.89260718, 0.89306003, \
0.89351205, 0.89396324, 0.89441360, 0.89486312, 0.89531180, \
0.89575965, 0.89620666, 0.89665283, 0.89709817, 0.89754266, \
0.89798631, 0.89842912, 0.89887108, 0.89931220, 0.89975247, \
0.90019190, 0.90063047, 0.90106820, 0.90150508, 0.90194111, \
0.90237629, 0.90281061, 0.90324408, 0.90367669, 0.90410845, \
0.90453935, 0.90496939, 0.90539857, 0.90582689, 0.90625435, \
0.90668095, 0.90710669, 0.90753156, 0.90795557, 0.90837871, \
0.90880098, 0.90922238, 0.90964292, 0.91006258, 0.91048138, \
0.91089930, 0.91131634, 0.91173252, 0.91214782, 0.91256224, \
0.91297579, 0.91338845, 0.91380024, 0.91421115, 0.91462118, \
0.91503032, 0.91543859, 0.91584596, 0.91625246, 0.91665807, \
0.91706279, 0.91746662, 0.91786957, 0.91827162, 0.91867279, \
0.91907306, 0.91947244, 0.91987093, 0.92026852, 0.92066522, \
0.92106102, 0.92145593, 0.92184993, 0.92224304, 0.92263525, \
0.92302655, 0.92341696, 0.92380646, 0.92419506, 0.92458276, \
0.92496954, 0.92535543, 0.92574040, 0.92612447, 0.92650763, \
0.92688988, 0.92727122, 0.92765164, 0.92803115, 0.92840975, \
0.92878744, 0.92916421, 0.92954006, 0.92991500, 0.93028902, \
0.93066212, 0.93103430, 0.93140556, 0.93177590, 0.93214531, \
0.93251381, 0.93288137, 0.93324802, 0.93361374, 0.93397853, \
0.93434239, 0.93470533, 0.93506733, 0.93542841, 0.93578855, \
0.93614777, 0.93650605, 0.93686339, 0.93721981, 0.93757528, \
0.93792983, 0.93828343, 0.93863610, 0.93898783, 0.93933862, \
0.93968847, 0.94003737, 0.94038534, 0.94073236, 0.94107844, \
0.94142358, 0.94176777, 0.94211102, 0.94245332, 0.94279467, \
0.94313507, 0.94347452, 0.94381303, 0.94415058, 0.94448718, \
0.94482283, 0.94515753, 0.94549127, 0.94582406, 0.94615589, \
0.94648677, 0.94681669, 0.94714565, 0.94747365, 0.94780070, \
0.94812678, 0.94845190, 0.94877607, 0.94909926, 0.94942150, \
0.94974277, 0.95006308, 0.95038242, 0.95070080, 0.95101821, \
0.95133465, 0.95165012, 0.95196463, 0.95227816, 0.95259072, \
0.95290231, 0.95321293, 0.95352258, 0.95383126, 0.95413895, \
0.95444568, 0.95475143, 0.95505620, 0.95536000, 0.95566281, \
0.95596465, 0.95626551, 0.95656539, 0.95686429, 0.95716221, \
0.95745914, 0.95775509, 0.95805006, 0.95834405, 0.95863705, \
0.95892906, 0.95922009, 0.95951013, 0.95979918, 0.96008725, \
0.96037432, 0.96066041, 0.96094551, 0.96122961, 0.96151273, \
0.96179485, 0.96207598, 0.96235611, 0.96263525, 0.96291339, \
0.96319054, 0.96346670, 0.96374185, 0.96401601, 0.96428917, \
0.96456133, 0.96483250, 0.96510266, 0.96537182, 0.96563998, \
0.96590714, 0.96617329, 0.96643844, 0.96670259, 0.96696573, \
0.96722787, 0.96748900, 0.96774913, 0.96800825, 0.96826636, \
0.96852346, 0.96877955, 0.96903464, 0.96928871, 0.96954178, \
0.96979383, 0.97004487, 0.97029490, 0.97054391, 0.97079191, \
0.97103890, 0.97128487, 0.97152983, 0.97177377, 0.97201670, \
0.97225861, 0.97249950, 0.97273937, 0.97297822, 0.97321605, \
0.97345287, 0.97368866, 0.97392343, 0.97415718, 0.97438991, \
0.97462162, 0.97485230, 0.97508196, 0.97531060, 0.97553821, \
0.97576479, 0.97599035, 0.97621488, 0.97643839, 0.97666087, \
0.97688232, 0.97710274, 0.97732213, 0.97754049, 0.97775782, \
0.97797413, 0.97818940, 0.97840364, 0.97861684, 0.97882902, \
0.97904016, 0.97925027, 0.97945934, 0.97966738, 0.97987439, \
0.98008035, 0.98028529, 0.98048918, 0.98069204, 0.98089386, \
0.98109465, 0.98129439, 0.98149310, 0.98169076, 0.98188739, \
0.98208298, 0.98227752, 0.98247103, 0.98266349, 0.98285491, \
0.98304529, 0.98323462, 0.98342292, 0.98361016, 0.98379637, \
0.98398153, 0.98416564, 0.98434871, 0.98453073, 0.98471170, \
0.98489163, 0.98507051, 0.98524834, 0.98542513, 0.98560086, \
0.98577555, 0.98594919, 0.98612178, 0.98629331, 0.98646380, \
0.98663324, 0.98680162, 0.98696895, 0.98713523, 0.98730046, \
0.98746463, 0.98762775, 0.98778982, 0.98795083, 0.98811079, \
0.98826969, 0.98842754, 0.98858433, 0.98874007, 0.98889475, \
0.98904837, 0.98920094, 0.98935245, 0.98950290, 0.98965229, \
0.98980062, 0.98994790, 0.99009411, 0.99023927, 0.99038336, \
0.99052640, 0.99066837, 0.99080929, 0.99094914, 0.99108793, \
0.99122566, 0.99136232, 0.99149793, 0.99163247, 0.99176595, \
0.99189836, 0.99202971, 0.99216000, 0.99228922, 0.99241737, \
0.99254446, 0.99267049, 0.99279545, 0.99291935, 0.99304217, \
0.99316393, 0.99328463, 0.99340426, 0.99352282, 0.99364031, \
0.99375673, 0.99387209, 0.99398638, 0.99409960, 0.99421175, \
0.99432283, 0.99443284, 0.99454178, 0.99464965, 0.99475645, \
0.99486218, 0.99496684, 0.99507043, 0.99517294, 0.99527439, \
0.99537476, 0.99547406, 0.99557229, 0.99566945, 0.99576553, \
0.99586054, 0.99595448, 0.99604734, 0.99613913, 0.99622985, \
0.99631949, 0.99640806, 0.99649555, 0.99658197, 0.99666732, \
0.99675159, 0.99683478, 0.99691690, 0.99699794, 0.99707791, \
0.99715680, 0.99723461, 0.99731135, 0.99738701, 0.99746159, \
0.99753510, 0.99760753, 0.99767888, 0.99774916, 0.99781836, \
0.99788648, 0.99795352, 0.99801948, 0.99808437, 0.99814818, \
0.99821090, 0.99827255, 0.99833312, 0.99839262, 0.99845103, \
0.99850836, 0.99856462, 0.99861979, 0.99867388, 0.99872690, \
0.99877883, 0.99882969, 0.99887946, 0.99892816, 0.99897577, \
0.99902230, 0.99906776, 0.99911213, 0.99915542, 0.99919763, \
0.99923876, 0.99927881, 0.99931777, 0.99935566, 0.99939246, \
0.99942818, 0.99946282, 0.99949638, 0.99952886, 0.99956026, \
0.99959057, 0.99961980, 0.99964795, 0.99967502, 0.99970100, \
0.99972590, 0.99974973, 0.99977246, 0.99979412, 0.99981469, \
0.99983418, 0.99985259, 0.99986992, 0.99988616, 0.99990132, \
0.99991540, 0.99992839, 0.99994030, 0.99995113, 0.99996088, \
0.99996954, 0.99997712, 0.99998362, 0.99998904, 0.99999337, \
0.99999662, 0.99999878, 0.99999986, } 


 #endif // _FPU_FFT_HAMMING_H_
//=============================================================================
// End of File
//=============================================================================

