//=============================================================================
// Taylor Window 
//=============================================================================
#ifndef _FPU_FFT_TAYLOR_H_
#define _FPU_FFT_TAYLOR_H_

#define TAYLOR32 {\
0.38237123, 0.41087663, 0.46583536, 0.54344544, 0.63868751, \
0.74596486, 0.85971224, 0.97485657, 1.08706531, 1.19278260, \
1.28911107, 1.37362952, 1.44423753, 1.49908871, 1.53662854, \
1.55570689, } 

#define TAYLOR64 {\
0.37966265, 0.38687161, 0.40115691, 0.42225837, 0.44979809, \
0.48329435, 0.52217895, 0.56581673, 0.61352628, 0.66460069, \
0.71832712, 0.77400443, 0.83095781, 0.88855022, 0.94619013, \
1.00333565, 1.05949534, 1.11422630, 1.16712988, 1.21784621, \
1.26604799, 1.31143451, 1.35372644, 1.39266203, 1.42799496, \
1.45949392, 1.48694401, 1.51014949, 1.52893761, 1.54316299, \
1.55271196, 1.55750636, } 

#define TAYLOR128 {\
0.37898453, 0.38079199, 0.38439855, 0.38978757, 0.39693430, \
0.40580610, 0.41636277, 0.42855688, 0.44233430, 0.45763459, \
0.47439163, 0.49253417, 0.51198643, 0.53266878, 0.55449835, \
0.57738972, 0.60125558, 0.62600731, 0.65155569, 0.67781138, \
0.70468558, 0.73209047, 0.75993968, 0.78814874, 0.81663540, \
0.84531993, 0.87412539, 0.90297778, 0.93180621, 0.96054291, \
0.98912334, 1.01748610, 1.04557286, 1.07332832, 1.10070001, \
1.12763818, 1.15409558, 1.18002731, 1.20539058, 1.23014455, \
1.25425013, 1.27766980, 1.30036741, 1.32230811, 1.34345816, \
1.36378487, 1.38325651, 1.40184231, 1.41951239, 1.43623782, \
1.45199067, 1.46674403, 1.48047214, 1.49315049, 1.50475593, \
1.51526683, 1.52466317, 1.53292673, 1.54004120, 1.54599233, \
1.55076804, 1.55435853, 1.55675635, 1.55795652, } 

#define TAYLOR256 {\
0.37881493, 0.37926713, 0.38017099, 0.38152547, 0.38332901, \
0.38557953, 0.38827442, 0.39141061, 0.39498449, 0.39899197, \
0.40342850, 0.40828904, 0.41356812, 0.41925979, 0.42535769, \
0.43185506, 0.43874471, 0.44601909, 0.45367027, 0.46168998, \
0.47006962, 0.47880027, 0.48787272, 0.49727750, 0.50700487, \
0.51704488, 0.52738735, 0.53802191, 0.54893803, 0.56012503, \
0.57157208, 0.58326827, 0.59520259, 0.60736394, 0.61974120, \
0.63232321, 0.64509880, 0.65805678, 0.67118602, 0.68447540, \
0.69791387, 0.71149045, 0.72519424, 0.73901445, 0.75294038, \
0.76696146, 0.78106728, 0.79524754, 0.80949212, 0.82379104, \
0.83813450, 0.85251290, 0.86691679, 0.88133691, 0.89576421, \
0.91018984, 0.92460511, 0.93900156, 0.95337092, 0.96770512, \
0.98199630, 0.99623677, 1.01041906, 1.02453587, 1.03858012, \
1.05254488, 1.06642343, 1.08020921, 1.09389583, 1.10747708, \
1.12094691, 1.13429940, 1.14752880, 1.16062950, 1.17359603, \
1.18642305, 1.19910532, 1.21163775, 1.22401535, 1.23623323, \
1.24828660, 1.26017079, 1.27188118, 1.28341327, 1.29476263, \
1.30592488, 1.31689576, 1.32767104, 1.33824658, 1.34861828, \
1.35878213, 1.36873416, 1.37847046, 1.38798719, 1.39728056, \
1.40634682, 1.41518232, 1.42378342, 1.43214657, 1.44026829, \
1.44814513, 1.45577374, 1.46315082, 1.47027315, 1.47713759, \
1.48374107, 1.49008061, 1.49615331, 1.50195637, 1.50748708, \
1.51274284, 1.51772114, 1.52241960, 1.52683592, 1.53096796, \
1.53481366, 1.53837112, 1.54163856, 1.54461431, 1.54729688, \
1.54968489, 1.55177711, 1.55357247, 1.55507003, 1.55626902, \
1.55716882, 1.55776894, 1.55806908, } 

#define TAYLOR512 {\
0.37877253, 0.37888560, 0.37911170, 0.37945078, 0.37990273, \
0.38046741, 0.38114468, 0.38193433, 0.38283613, 0.38384983, \
0.38497513, 0.38621170, 0.38755920, 0.38901723, 0.39058538, \
0.39226320, 0.39405020, 0.39594588, 0.39794969, 0.40006107, \
0.40227941, 0.40460409, 0.40703445, 0.40956980, 0.41220943, \
0.41495260, 0.41779853, 0.42074644, 0.42379550, 0.42694486, \
0.43019365, 0.43354098, 0.43698593, 0.44052754, 0.44416485, \
0.44789688, 0.45172260, 0.45564098, 0.45965097, 0.46375149, \
0.46794145, 0.47221973, 0.47658520, 0.48103670, 0.48557308, \
0.49019313, 0.49489568, 0.49967948, 0.50454333, 0.50948596, \
0.51450612, 0.51960255, 0.52477394, 0.53001902, 0.53533646, \
0.54072496, 0.54618319, 0.55170981, 0.55730348, 0.56296284, \
0.56868654, 0.57447320, 0.58032147, 0.58622996, 0.59219729, \
0.59822207, 0.60430292, 0.61043845, 0.61662726, 0.62286795, \
0.62915913, 0.63549940, 0.64188737, 0.64832163, 0.65480079, \
0.66132347, 0.66788826, 0.67449378, 0.68113864, 0.68782147, \
0.69454088, 0.70129550, 0.70808396, 0.71490490, 0.72175696, \
0.72863880, 0.73554907, 0.74248643, 0.74944956, 0.75643714, \
0.76344784, 0.77048038, 0.77753345, 0.78460576, 0.79169605, \
0.79880305, 0.80592549, 0.81306214, 0.82021175, 0.82737311, \
0.83454499, 0.84172620, 0.84891555, 0.85611185, 0.86331393, \
0.87052065, 0.87773085, 0.88494341, 0.89215720, 0.89937112, \
0.90658407, 0.91379496, 0.92100273, 0.92820631, 0.93540466, \
0.94259676, 0.94978156, 0.95695808, 0.96412530, 0.97128226, \
0.97842796, 0.98556147, 0.99268182, 0.99978808, 1.00687934, \
1.01395468, 1.02101320, 1.02805401, 1.03507624, 1.04207902, \
1.04906151, 1.05602286, 1.06296224, 1.06987882, 1.07677181, \
1.08364041, 1.09048381, 1.09730126, 1.10409198, 1.11085522, \
1.11759022, 1.12429626, 1.13097259, 1.13761851, 1.14423330, \
1.15081626, 1.15736670, 1.16388393, 1.17036728, 1.17681607, \
1.18322966, 1.18960739, 1.19594860, 1.20225267, 1.20851896, \
1.21474686, 1.22093573, 1.22708498, 1.23319399, 1.23926218, \
1.24528894, 1.25127369, 1.25721586, 1.26311486, 1.26897013, \
1.27478110, 1.28054721, 1.28626792, 1.29194266, 1.29757090, \
1.30315210, 1.30868571, 1.31417121, 1.31960808, 1.32499579, \
1.33033381, 1.33562164, 1.34085877, 1.34604469, 1.35117889, \
1.35626087, 1.36129015, 1.36626623, 1.37118861, 1.37605682, \
1.38087038, 1.38562880, 1.39033162, 1.39497836, 1.39956856, \
1.40410175, 1.40857747, 1.41299528, 1.41735471, 1.42165531, \
1.42589665, 1.43007828, 1.43419977, 1.43826068, 1.44226059, \
1.44619906, 1.45007568, 1.45389004, 1.45764172, 1.46133031, \
1.46495541, 1.46851662, 1.47201356, 1.47544583, 1.47881304, \
1.48211483, 1.48535081, 1.48852063, 1.49162391, 1.49466030, \
1.49762946, 1.50053103, 1.50336468, 1.50613008, 1.50882690, \
1.51145482, 1.51401352, 1.51650271, 1.51892209, 1.52127135, \
1.52355022, 1.52575841, 1.52789567, 1.52996172, 1.53195631, \
1.53387919, 1.53573012, 1.53750888, 1.53921524, 1.54084898, \
1.54240990, 1.54389780, 1.54531250, 1.54665380, 1.54792155, \
1.54911557, 1.55023572, 1.55128185, 1.55225382, 1.55315151, \
1.55397481, 1.55472361, 1.55539780, 1.55599730, 1.55652204, \
1.55697195, 1.55734695, 1.55764702, 1.55787211, 1.55802218, \
1.55809722, } 

#define TAYLOR1024 {\
0.37876193, 0.37879020, 0.37884673, 0.37893153, 0.37904458, \
0.37918589, 0.37935542, 0.37955319, 0.37977916, 0.38003333, \
0.38031568, 0.38062618, 0.38096482, 0.38133156, 0.38172639, \
0.38214927, 0.38260018, 0.38307908, 0.38358593, 0.38412070, \
0.38468336, 0.38527385, 0.38589214, 0.38653819, 0.38721195, \
0.38791336, 0.38864238, 0.38939896, 0.39018304, 0.39099457, \
0.39183349, 0.39269973, 0.39359324, 0.39451395, 0.39546180, \
0.39643671, 0.39743863, 0.39846747, 0.39952317, 0.40060565, \
0.40171483, 0.40285064, 0.40401299, 0.40520180, 0.40641699, \
0.40765847, 0.40892616, 0.41021996, 0.41153979, 0.41288554, \
0.41425714, 0.41565447, 0.41707745, 0.41852598, 0.41999994, \
0.42149925, 0.42302379, 0.42457347, 0.42614816, 0.42774777, \
0.42937218, 0.43102128, 0.43269496, 0.43439311, 0.43611559, \
0.43786231, 0.43963313, 0.44142794, 0.44324661, 0.44508902, \
0.44695505, 0.44884456, 0.45075744, 0.45269355, 0.45465275, \
0.45663493, 0.45863994, 0.46066765, 0.46271793, 0.46479064, \
0.46688563, 0.46900278, 0.47114194, 0.47330296, 0.47548572, \
0.47769005, 0.47991582, 0.48216288, 0.48443109, 0.48672029, \
0.48903034, 0.49136108, 0.49371237, 0.49608406, 0.49847598, \
0.50088799, 0.50331993, 0.50577165, 0.50824299, 0.51073378, \
0.51324388, 0.51577313, 0.51832136, 0.52088842, 0.52347414, \
0.52607835, 0.52870091, 0.53134165, 0.53400039, 0.53667698, \
0.53937125, 0.54208303, 0.54481217, 0.54755849, 0.55032182, \
0.55310199, 0.55589885, 0.55871221, 0.56154191, 0.56438778, \
0.56724965, 0.57012735, 0.57302071, 0.57592955, 0.57885370, \
0.58179300, 0.58474727, 0.58771633, 0.59070002, 0.59369815, \
0.59671057, 0.59973708, 0.60277753, 0.60583173, 0.60889952, \
0.61198071, 0.61507514, 0.61818262, 0.62130299, 0.62443606, \
0.62758168, 0.63073965, 0.63390981, 0.63709197, 0.64028598, \
0.64349165, 0.64670880, 0.64993726, 0.65317687, 0.65642744, \
0.65968880, 0.66296077, 0.66624319, 0.66953588, 0.67283866, \
0.67615136, 0.67947382, 0.68280585, 0.68614728, 0.68949794, \
0.69285767, 0.69622628, 0.69960361, 0.70298949, 0.70638374, \
0.70978620, 0.71319669, 0.71661505, 0.72004110, 0.72347468, \
0.72691562, 0.73036376, 0.73381891, 0.73728092, 0.74074963, \
0.74422485, 0.74770644, 0.75119422, 0.75468802, 0.75818770, \
0.76169307, 0.76520398, 0.76872027, 0.77224177, 0.77576833, \
0.77929977, 0.78283595, 0.78637670, 0.78992187, 0.79347128, \
0.79702480, 0.80058226, 0.80414350, 0.80770837, 0.81127671, \
0.81484837, 0.81842320, 0.82200104, 0.82558173, 0.82916514, \
0.83275110, 0.83633946, 0.83993009, 0.84352282, 0.84711751, \
0.85071401, 0.85431218, 0.85791187, 0.86151293, 0.86511522, \
0.86871860, 0.87232292, 0.87592804, 0.87953382, 0.88314011, \
0.88674679, 0.89035370, 0.89396071, 0.89756769, 0.90117449, \
0.90478098, 0.90838702, 0.91199249, 0.91559723, 0.91920113, \
0.92280405, 0.92640586, 0.93000643, 0.93360562, 0.93720331, \
0.94079938, 0.94439368, 0.94798610, 0.95157651, 0.95516478, \
0.95875079, 0.96233442, 0.96591554, 0.96949403, 0.97306977, \
0.97664264, 0.98021252, 0.98377929, 0.98734282, 0.99090301, \
0.99445974, 0.99801289, 1.00156234, 1.00510798, 1.00864970, \
1.01218739, 1.01572092, 1.01925019, 1.02277509, 1.02629551, \
1.02981134, 1.03332247, 1.03682879, 1.04033020, 1.04382658, \
1.04731784, 1.05080386, 1.05428455, 1.05775979, 1.06122950, \
1.06469355, 1.06815186, 1.07160431, 1.07505082, 1.07849128, \
1.08192559, 1.08535365, 1.08877537, 1.09219064, 1.09559938, \
1.09900148, 1.10239685, 1.10578540, 1.10916703, 1.11254165, \
1.11590916, 1.11926948, 1.12262250, 1.12596815, 1.12930633, \
1.13263695, 1.13595992, 1.13927515, 1.14258256, 1.14588205, \
1.14917354, 1.15245694, 1.15573217, 1.15899914, 1.16225777, \
1.16550797, 1.16874965, 1.17198274, 1.17520715, 1.17842280, \
1.18162960, 1.18482748, 1.18801635, 1.19119614, 1.19436676, \
1.19752813, 1.20068017, 1.20382281, 1.20695597, 1.21007956, \
1.21319352, 1.21629776, 1.21939220, 1.22247678, 1.22555142, \
1.22861603, 1.23167054, 1.23471489, 1.23774899, 1.24077277, \
1.24378616, 1.24678909, 1.24978147, 1.25276325, 1.25573434, \
1.25869468, 1.26164419, 1.26458280, 1.26751044, 1.27042704, \
1.27333254, 1.27622685, 1.27910992, 1.28198167, 1.28484203, \
1.28769093, 1.29052831, 1.29335410, 1.29616823, 1.29897063, \
1.30176124, 1.30453998, 1.30730680, 1.31006162, 1.31280438, \
1.31553501, 1.31825345, 1.32095964, 1.32365350, 1.32633497, \
1.32900399, 1.33166050, 1.33430442, 1.33693570, 1.33955427, \
1.34216007, 1.34475304, 1.34733310, 1.34990021, 1.35245430, \
1.35499530, 1.35752315, 1.36003780, 1.36253918, 1.36502722, \
1.36750187, 1.36996308, 1.37241076, 1.37484488, 1.37726536, \
1.37967214, 1.38206517, 1.38444439, 1.38680974, 1.38916116, \
1.39149858, 1.39382196, 1.39613123, 1.39842634, 1.40070722, \
1.40297382, 1.40522609, 1.40746396, 1.40968737, 1.41189628, \
1.41409062, 1.41627035, 1.41843539, 1.42058570, 1.42272122, \
1.42484190, 1.42694767, 1.42903850, 1.43111431, 1.43317506, \
1.43522069, 1.43725116, 1.43926639, 1.44126635, 1.44325098, \
1.44522022, 1.44717403, 1.44911235, 1.45103513, 1.45294231, \
1.45483385, 1.45670970, 1.45856979, 1.46041410, 1.46224255, \
1.46405511, 1.46585172, 1.46763233, 1.46939690, 1.47114537, \
1.47287770, 1.47459384, 1.47629374, 1.47797736, 1.47964464, \
1.48129554, 1.48293001, 1.48454801, 1.48614948, 1.48773440, \
1.48930270, 1.49085434, 1.49238929, 1.49390749, 1.49540891, \
1.49689349, 1.49836120, 1.49981199, 1.50124582, 1.50266265, \
1.50406244, 1.50544515, 1.50681073, 1.50815914, 1.50949035, \
1.51080431, 1.51210099, 1.51338035, 1.51464235, 1.51588695, \
1.51711411, 1.51832380, 1.51951598, 1.52069062, 1.52184768, \
1.52298711, 1.52410890, 1.52521300, 1.52629939, 1.52736802, \
1.52841887, 1.52945189, 1.53046707, 1.53146437, 1.53244376, \
1.53340520, 1.53434868, 1.53527415, 1.53618159, 1.53707097, \
1.53794227, 1.53879545, 1.53963049, 1.54044736, 1.54124604, \
1.54202651, 1.54278873, 1.54353268, 1.54425835, 1.54496570, \
1.54565471, 1.54632536, 1.54697764, 1.54761152, 1.54822697, \
1.54882398, 1.54940254, 1.54996261, 1.55050420, 1.55102726, \
1.55153180, 1.55201779, 1.55248521, 1.55293406, 1.55336432, \
1.55377597, 1.55416900, 1.55454340, 1.55489915, 1.55523625, \
1.55555468, 1.55585443, 1.55613550, 1.55639787, 1.55664154, \
1.55686649, 1.55707272, 1.55726023, 1.55742900, 1.55757903, \
1.55771032, 1.55782287, 1.55791666, 1.55799169, 1.55804797, \
1.55808549, 1.55810425, } 

#define TAYLOR2048 {\
0.37875928, 0.37876635, 0.37878048, 0.37880168, 0.37882995, \
0.37886528, 0.37890768, 0.37895715, 0.37901367, 0.37907726, \
0.37914791, 0.37922562, 0.37931039, 0.37940222, 0.37950110, \
0.37960704, 0.37972003, 0.37984006, 0.37996715, 0.38010128, \
0.38024245, 0.38039067, 0.38054592, 0.38070821, 0.38087752, \
0.38105387, 0.38123724, 0.38142764, 0.38162505, 0.38182948, \
0.38204093, 0.38225937, 0.38248483, 0.38271728, 0.38295673, \
0.38320317, 0.38345660, 0.38371701, 0.38398439, 0.38425875, \
0.38454008, 0.38482837, 0.38512362, 0.38542582, 0.38573497, \
0.38605106, 0.38637408, 0.38670404, 0.38704091, 0.38738471, \
0.38773542, 0.38809303, 0.38845754, 0.38882895, 0.38920724, \
0.38959241, 0.38998445, 0.39038336, 0.39078912, 0.39120174, \
0.39162119, 0.39204749, 0.39248061, 0.39292055, 0.39336731, \
0.39382087, 0.39428123, 0.39474837, 0.39522230, 0.39570299, \
0.39619045, 0.39668466, 0.39718562, 0.39769332, 0.39820774, \
0.39872888, 0.39925673, 0.39979128, 0.40033252, 0.40088045, \
0.40143504, 0.40199629, 0.40256419, 0.40313874, 0.40371992, \
0.40430771, 0.40490212, 0.40550313, 0.40611072, 0.40672490, \
0.40734564, 0.40797294, 0.40860678, 0.40924716, 0.40989407, \
0.41054748, 0.41120739, 0.41187380, 0.41254668, 0.41322602, \
0.41391182, 0.41460406, 0.41530273, 0.41600782, 0.41671931, \
0.41743719, 0.41816146, 0.41889209, 0.41962907, 0.42037240, \
0.42112205, 0.42187802, 0.42264030, 0.42340886, 0.42418370, \
0.42496480, 0.42575215, 0.42654573, 0.42734554, 0.42815155, \
0.42896376, 0.42978215, 0.43060670, 0.43143740, 0.43227425, \
0.43311721, 0.43396628, 0.43482145, 0.43568269, 0.43655000, \
0.43742336, 0.43830276, 0.43918817, 0.44007959, 0.44097699, \
0.44188037, 0.44278971, 0.44370499, 0.44462620, 0.44555332, \
0.44648633, 0.44742523, 0.44836999, 0.44932060, 0.45027704, \
0.45123929, 0.45220735, 0.45318119, 0.45416079, 0.45514615, \
0.45613724, 0.45713405, 0.45813656, 0.45914475, 0.46015861, \
0.46117811, 0.46220326, 0.46323401, 0.46427037, 0.46531230, \
0.46635980, 0.46741285, 0.46847143, 0.46953551, 0.47060509, \
0.47168015, 0.47276067, 0.47384662, 0.47493800, 0.47603478, \
0.47713695, 0.47824449, 0.47935738, 0.48047560, 0.48159913, \
0.48272796, 0.48386206, 0.48500143, 0.48614603, 0.48729585, \
0.48845088, 0.48961109, 0.49077647, 0.49194699, 0.49312263, \
0.49430339, 0.49548923, 0.49668015, 0.49787611, 0.49907711, \
0.50028311, 0.50149411, 0.50271009, 0.50393101, 0.50515687, \
0.50638765, 0.50762332, 0.50886387, 0.51010927, 0.51135951, \
0.51261456, 0.51387441, 0.51513903, 0.51640842, 0.51768253, \
0.51896137, 0.52024490, 0.52153310, 0.52282597, 0.52412346, \
0.52542557, 0.52673228, 0.52804356, 0.52935940, 0.53067977, \
0.53200465, 0.53333402, 0.53466787, 0.53600617, 0.53734889, \
0.53869603, 0.54004756, 0.54140346, 0.54276370, 0.54412827, \
0.54549714, 0.54687031, 0.54824773, 0.54962940, 0.55101529, \
0.55240538, 0.55379965, 0.55519808, 0.55660065, 0.55800733, \
0.55941811, 0.56083296, 0.56225187, 0.56367481, 0.56510176, \
0.56653270, 0.56796760, 0.56940645, 0.57084923, 0.57229591, \
0.57374647, 0.57520090, 0.57665916, 0.57812124, 0.57958712, \
0.58105677, 0.58253017, 0.58400731, 0.58548815, 0.58697269, \
0.58846089, 0.58995273, 0.59144820, 0.59294727, 0.59444992, \
0.59595613, 0.59746588, 0.59897914, 0.60049590, 0.60201612, \
0.60353980, 0.60506690, 0.60659741, 0.60813131, 0.60966857, \
0.61120917, 0.61275308, 0.61430030, 0.61585079, 0.61740453, \
0.61896151, 0.62052170, 0.62208507, 0.62365161, 0.62522130, \
0.62679411, 0.62837002, 0.62994901, 0.63153105, 0.63311613, \
0.63470423, 0.63629532, 0.63788937, 0.63948638, 0.64108631, \
0.64268914, 0.64429486, 0.64590344, 0.64751486, 0.64912910, \
0.65074613, 0.65236593, 0.65398849, 0.65561378, 0.65724177, \
0.65887246, 0.66050580, 0.66214179, 0.66378040, 0.66542162, \
0.66706541, 0.66871175, 0.67036063, 0.67201203, 0.67366591, \
0.67532227, 0.67698107, 0.67864230, 0.68030593, 0.68197195, \
0.68364033, 0.68531105, 0.68698409, 0.68865942, 0.69033703, \
0.69201690, 0.69369900, 0.69538331, 0.69706981, 0.69875847, \
0.70044929, 0.70214223, 0.70383728, 0.70553440, 0.70723359, \
0.70893483, 0.71063808, 0.71234333, 0.71405055, 0.71575973, \
0.71747085, 0.71918388, 0.72089880, 0.72261559, 0.72433424, \
0.72605471, 0.72777699, 0.72950106, 0.73122689, 0.73295447, \
0.73468378, 0.73641479, 0.73814748, 0.73988183, 0.74161783, \
0.74335544, 0.74509466, 0.74683545, 0.74857781, 0.75032170, \
0.75206711, 0.75381402, 0.75556240, 0.75731224, 0.75906351, \
0.76081620, 0.76257028, 0.76432574, 0.76608256, 0.76784070, \
0.76960016, 0.77136092, 0.77312294, 0.77488622, 0.77665074, \
0.77841646, 0.78018338, 0.78195147, 0.78372072, 0.78549109, \
0.78726259, 0.78903517, 0.79080883, 0.79258354, 0.79435929, \
0.79613605, 0.79791380, 0.79969253, 0.80147222, 0.80325284, \
0.80503438, 0.80681682, 0.80860013, 0.81038431, 0.81216932, \
0.81395515, 0.81574179, 0.81752920, 0.81931738, 0.82110630, \
0.82289595, 0.82468630, 0.82647734, 0.82826904, 0.83006139, \
0.83185438, 0.83364797, 0.83544216, 0.83723692, 0.83903223, \
0.84082808, 0.84262445, 0.84442132, 0.84621866, 0.84801647, \
0.84981473, 0.85161341, 0.85341249, 0.85521197, 0.85701181, \
0.85881201, 0.86061255, 0.86241340, 0.86421454, 0.86601597, \
0.86781766, 0.86961960, 0.87142176, 0.87322413, 0.87502669, \
0.87682943, 0.87863232, 0.88043535, 0.88223850, 0.88404175, \
0.88584509, 0.88764850, 0.88945196, 0.89125545, 0.89305896, \
0.89486247, 0.89666596, 0.89846941, 0.90027281, 0.90207615, \
0.90387939, 0.90568254, 0.90748556, 0.90928845, 0.91109118, \
0.91289375, 0.91469612, 0.91649829, 0.91830025, 0.92010196, \
0.92190342, 0.92370462, 0.92550552, 0.92730613, 0.92910641, \
0.93090636, 0.93270596, 0.93450519, 0.93630404, 0.93810249, \
0.93990052, 0.94169812, 0.94349528, 0.94529197, 0.94708818, \
0.94888390, 0.95067910, 0.95247378, 0.95426792, 0.95606150, \
0.95785451, 0.95964693, 0.96143874, 0.96322994, 0.96502050, \
0.96681042, 0.96859966, 0.97038823, 0.97217610, 0.97396326, \
0.97574970, 0.97753540, 0.97932034, 0.98110451, 0.98288789, \
0.98467048, 0.98645225, 0.98823319, 0.99001329, 0.99179252, \
0.99357089, 0.99534837, 0.99712494, 0.99890060, 1.00067533, \
1.00244911, 1.00422194, 1.00599379, 1.00776465, 1.00953451, \
1.01130335, 1.01307116, 1.01483793, 1.01660364, 1.01836828, \
1.02013183, 1.02189428, 1.02365562, 1.02541583, 1.02717491, \
1.02893282, 1.03068957, 1.03244514, 1.03419951, 1.03595267, \
1.03770461, 1.03945531, 1.04120477, 1.04295296, 1.04469988, \
1.04644551, 1.04818984, 1.04993285, 1.05167454, 1.05341488, \
1.05515387, 1.05689150, 1.05862774, 1.06036260, 1.06209604, \
1.06382807, 1.06555867, 1.06728782, 1.06901552, 1.07074175, \
1.07246650, 1.07418976, 1.07591151, 1.07763174, 1.07935044, \
1.08106759, 1.08278319, 1.08449722, 1.08620968, 1.08792054, \
1.08962979, 1.09133743, 1.09304344, 1.09474781, 1.09645053, \
1.09815158, 1.09985096, 1.10154864, 1.10324463, 1.10493891, \
1.10663146, 1.10832228, 1.11001134, 1.11169865, 1.11338419, \
1.11506795, 1.11674992, 1.11843008, 1.12010842, 1.12178494, \
1.12345961, 1.12513244, 1.12680340, 1.12847249, 1.13013970, \
1.13180501, 1.13346841, 1.13512990, 1.13678946, 1.13844707, \
1.14010274, 1.14175644, 1.14340818, 1.14505792, 1.14670567, \
1.14835142, 1.14999515, 1.15163685, 1.15327652, 1.15491414, \
1.15654969, 1.15818318, 1.15981458, 1.16144390, 1.16307111, \
1.16469621, 1.16631919, 1.16794003, 1.16955873, 1.17117528, \
1.17278966, 1.17440187, 1.17601189, 1.17761971, 1.17922533, \
1.18082873, 1.18242991, 1.18402885, 1.18562555, 1.18721998, \
1.18881215, 1.19040205, 1.19198965, 1.19357496, 1.19515797, \
1.19673865, 1.19831701, 1.19989304, 1.20146672, 1.20303804, \
1.20460699, 1.20617357, 1.20773777, 1.20929956, 1.21085896, \
1.21241594, 1.21397049, 1.21552261, 1.21707229, 1.21861952, \
1.22016428, 1.22170657, 1.22324638, 1.22478369, 1.22631851, \
1.22785082, 1.22938061, 1.23090787, 1.23243259, 1.23395476, \
1.23547438, 1.23699143, 1.23850591, 1.24001780, 1.24152710, \
1.24303379, 1.24453788, 1.24603934, 1.24753818, 1.24903437, \
1.25052792, 1.25201880, 1.25350703, 1.25499257, 1.25647544, \
1.25795560, 1.25943307, 1.26090783, 1.26237986, 1.26384917, \
1.26531574, 1.26677956, 1.26824063, 1.26969893, 1.27115446, \
1.27260721, 1.27405717, 1.27550433, 1.27694868, 1.27839021, \
1.27982892, 1.28126479, 1.28269783, 1.28412801, 1.28555533, \
1.28697978, 1.28840136, 1.28982005, 1.29123585, 1.29264874, \
1.29405873, 1.29546579, 1.29686993, 1.29827113, 1.29966939, \
1.30106469, 1.30245704, 1.30384641, 1.30523281, 1.30661621, \
1.30799663, 1.30937404, 1.31074844, 1.31211982, 1.31348818, \
1.31485349, 1.31621577, 1.31757499, 1.31893115, 1.32028424, \
1.32163426, 1.32298119, 1.32432503, 1.32566577, 1.32700340, \
1.32833791, 1.32966929, 1.33099755, 1.33232266, 1.33364462, \
1.33496343, 1.33627907, 1.33759154, 1.33890082, 1.34020692, \
1.34150982, 1.34280952, 1.34410600, 1.34539926, 1.34668930, \
1.34797610, 1.34925965, 1.35053996, 1.35181700, 1.35309078, \
1.35436128, 1.35562850, 1.35689242, 1.35815306, 1.35941038, \
1.36066439, 1.36191508, 1.36316244, 1.36440646, 1.36564714, \
1.36688447, 1.36811844, 1.36934904, 1.37057627, 1.37180011, \
1.37302057, 1.37423762, 1.37545128, 1.37666152, 1.37786834, \
1.37907173, 1.38027169, 1.38146821, 1.38266128, 1.38385089, \
1.38503703, 1.38621971, 1.38739890, 1.38857461, 1.38974683, \
1.39091554, 1.39208075, 1.39324244, 1.39440060, 1.39555524, \
1.39670634, 1.39785389, 1.39899789, 1.40013834, 1.40127521, \
1.40240851, 1.40353823, 1.40466437, 1.40578691, 1.40690584, \
1.40802117, 1.40913288, 1.41024096, 1.41134542, 1.41244623, \
1.41354341, 1.41463693, 1.41572679, 1.41681298, 1.41789551, \
1.41897435, 1.42004951, 1.42112097, 1.42218873, 1.42325278, \
1.42431312, 1.42536974, 1.42642263, 1.42747178, 1.42851720, \
1.42955886, 1.43059677, 1.43163091, 1.43266129, 1.43368789, \
1.43471071, 1.43572973, 1.43674497, 1.43775639, 1.43876401, \
1.43976782, 1.44076780, 1.44176395, 1.44275626, 1.44374474, \
1.44472936, 1.44571012, 1.44668703, 1.44766006, 1.44862922, \
1.44959450, 1.45055589, 1.45151339, 1.45246698, 1.45341666, \
1.45436243, 1.45530428, 1.45624221, 1.45717620, 1.45810625, \
1.45903235, 1.45995450, 1.46087270, 1.46178692, 1.46269718, \
1.46360346, 1.46450576, 1.46540406, 1.46629837, 1.46718868, \
1.46807498, 1.46895726, 1.46983553, 1.47070977, 1.47157997, \
1.47244614, 1.47330826, 1.47416633, 1.47502034, 1.47587029, \
1.47671618, 1.47755798, 1.47839571, 1.47922935, 1.48005890, \
1.48088435, 1.48170570, 1.48252293, 1.48333605, 1.48414505, \
1.48494993, 1.48575066, 1.48654727, 1.48733972, 1.48812803, \
1.48891218, 1.48969217, 1.49046800, 1.49123965, 1.49200712, \
1.49277041, 1.49352951, 1.49428442, 1.49503513, 1.49578163, \
1.49652393, 1.49726200, 1.49799586, 1.49872549, 1.49945088, \
1.50017204, 1.50088896, 1.50160163, 1.50231004, 1.50301420, \
1.50371410, 1.50440972, 1.50510107, 1.50578815, 1.50647094, \
1.50714944, 1.50782365, 1.50849356, 1.50915916, 1.50982046, \
1.51047744, 1.51113011, 1.51177845, 1.51242246, 1.51306214, \
1.51369748, 1.51432848, 1.51495513, 1.51557743, 1.51619538, \
1.51680896, 1.51741818, 1.51802302, 1.51862349, 1.51921958, \
1.51981129, 1.52039861, 1.52098153, 1.52156006, 1.52213419, \
1.52270391, 1.52326922, 1.52383011, 1.52438659, 1.52493864, \
1.52548626, 1.52602946, 1.52656821, 1.52710253, 1.52763240, \
1.52815782, 1.52867879, 1.52919531, 1.52970736, 1.53021495, \
1.53071808, 1.53121672, 1.53171090, 1.53220059, 1.53268580, \
1.53316653, 1.53364276, 1.53411449, 1.53458173, 1.53504447, \
1.53550270, 1.53595642, 1.53640563, 1.53685032, 1.53729049, \
1.53772614, 1.53815726, 1.53858385, 1.53900591, 1.53942343, \
1.53983641, 1.54024485, 1.54064874, 1.54104808, 1.54144287, \
1.54183310, 1.54221877, 1.54259989, 1.54297643, 1.54334841, \
1.54371581, 1.54407865, 1.54443690, 1.54479058, 1.54513967, \
1.54548418, 1.54582409, 1.54615942, 1.54649016, 1.54681630, \
1.54713783, 1.54745477, 1.54776711, 1.54807483, 1.54837795, \
1.54867646, 1.54897035, 1.54925963, 1.54954429, 1.54982433, \
1.55009974, 1.55037053, 1.55063670, 1.55089823, 1.55115513, \
1.55140740, 1.55165503, 1.55189803, 1.55213638, 1.55237010, \
1.55259917, 1.55282359, 1.55304337, 1.55325850, 1.55346898, \
1.55367480, 1.55387597, 1.55407249, 1.55426435, 1.55445155, \
1.55463408, 1.55481196, 1.55498518, 1.55515373, 1.55531761, \
1.55547682, 1.55563137, 1.55578125, 1.55592645, 1.55606699, \
1.55620285, 1.55633403, 1.55646054, 1.55658237, 1.55669953, \
1.55681201, 1.55691980, 1.55702292, 1.55712135, 1.55721511, \
1.55730418, 1.55738856, 1.55746826, 1.55754328, 1.55761361, \
1.55767926, 1.55774022, 1.55779649, 1.55784807, 1.55789497, \
1.55793717, 1.55797469, 1.55800752, 1.55803566, 1.55805911, \
1.55807787, 1.55809194, 1.55810132, 1.55810601, } 

#define TAYLOR4096 {\
0.37875862, 0.37876039, 0.37876392, 0.37876922, 0.37877629, \
0.37878512, 0.37879572, 0.37880809, 0.37882222, 0.37883812, \
0.37885579, 0.37887522, 0.37889642, 0.37891939, 0.37894412, \
0.37897062, 0.37899888, 0.37902891, 0.37906070, 0.37909426, \
0.37912959, 0.37916668, 0.37920553, 0.37924615, 0.37928854, \
0.37933269, 0.37937860, 0.37942628, 0.37947572, 0.37952693, \
0.37957989, 0.37963462, 0.37969112, 0.37974937, 0.37980939, \
0.37987117, 0.37993472, 0.38000002, 0.38006709, 0.38013591, \
0.38020650, 0.38027885, 0.38035295, 0.38042882, 0.38050645, \
0.38058583, 0.38066697, 0.38074988, 0.38083454, 0.38092095, \
0.38100913, 0.38109906, 0.38119074, 0.38128419, 0.38137938, \
0.38147634, 0.38157504, 0.38167550, 0.38177772, 0.38188169, \
0.38198741, 0.38209488, 0.38220411, 0.38231508, 0.38242781, \
0.38254228, 0.38265851, 0.38277649, 0.38289621, 0.38301768, \
0.38314090, 0.38326587, 0.38339258, 0.38352104, 0.38365125, \
0.38378320, 0.38391689, 0.38405233, 0.38418951, 0.38432843, \
0.38446910, 0.38461150, 0.38475565, 0.38490153, 0.38504916, \
0.38519852, 0.38534962, 0.38550246, 0.38565703, 0.38581334, \
0.38597138, 0.38613116, 0.38629267, 0.38645592, 0.38662090, \
0.38678761, 0.38695605, 0.38712621, 0.38729811, 0.38747174, \
0.38764709, 0.38782417, 0.38800298, 0.38818351, 0.38836577, \
0.38854975, 0.38873545, 0.38892287, 0.38911202, 0.38930289, \
0.38949547, 0.38968977, 0.38988579, 0.39008353, 0.39028299, \
0.39048415, 0.39068704, 0.39089163, 0.39109794, 0.39130596, \
0.39151569, 0.39172713, 0.39194027, 0.39215513, 0.39237169, \
0.39258996, 0.39280993, 0.39303160, 0.39325498, 0.39348006, \
0.39370684, 0.39393532, 0.39416550, 0.39439738, 0.39463095, \
0.39486622, 0.39510318, 0.39534183, 0.39558218, 0.39582422, \
0.39606795, 0.39631337, 0.39656048, 0.39680927, 0.39705975, \
0.39731192, 0.39756576, 0.39782129, 0.39807851, 0.39833740, \
0.39859797, 0.39886022, 0.39912414, 0.39938974, 0.39965702, \
0.39992597, 0.40019659, 0.40046888, 0.40074284, 0.40101847, \
0.40129576, 0.40157473, 0.40185535, 0.40213764, 0.40242160, \
0.40270721, 0.40299448, 0.40328341, 0.40357400, 0.40386625, \
0.40416014, 0.40445570, 0.40475290, 0.40505175, 0.40535226, \
0.40565441, 0.40595821, 0.40626365, 0.40657074, 0.40687947, \
0.40718984, 0.40750185, 0.40781550, 0.40813079, 0.40844771, \
0.40876627, 0.40908646, 0.40940828, 0.40973173, 0.41005681, \
0.41038352, 0.41071185, 0.41104181, 0.41137339, 0.41170659, \
0.41204141, 0.41237785, 0.41271591, 0.41305558, 0.41339687, \
0.41373977, 0.41408428, 0.41443040, 0.41477813, 0.41512746, \
0.41547840, 0.41583095, 0.41618509, 0.41654084, 0.41689818, \
0.41725712, 0.41761766, 0.41797979, 0.41834352, 0.41870883, \
0.41907574, 0.41944423, 0.41981431, 0.42018597, 0.42055922, \
0.42093405, 0.42131046, 0.42168844, 0.42206800, 0.42244914, \
0.42283185, 0.42321613, 0.42360198, 0.42398940, 0.42437839, \
0.42476894, 0.42516105, 0.42555473, 0.42594996, 0.42634675, \
0.42674510, 0.42714500, 0.42754646, 0.42794947, 0.42835402, \
0.42876013, 0.42916778, 0.42957697, 0.42998771, 0.43039998, \
0.43081380, 0.43122915, 0.43164604, 0.43206446, 0.43248441, \
0.43290590, 0.43332891, 0.43375344, 0.43417950, 0.43460709, \
0.43503619, 0.43546681, 0.43589895, 0.43633261, 0.43676778, \
0.43720446, 0.43764265, 0.43808234, 0.43852355, 0.43896625, \
0.43941046, 0.43985617, 0.44030338, 0.44075208, 0.44120228, \
0.44165397, 0.44210715, 0.44256182, 0.44301797, 0.44347561, \
0.44393474, 0.44439534, 0.44485742, 0.44532098, 0.44578602, \
0.44625253, 0.44672051, 0.44718996, 0.44766087, 0.44813325, \
0.44860709, 0.44908240, 0.44955916, 0.45003738, 0.45051706, \
0.45099819, 0.45148076, 0.45196479, 0.45245027, 0.45293719, \
0.45342555, 0.45391535, 0.45440659, 0.45489927, 0.45539339, \
0.45588893, 0.45638591, 0.45688431, 0.45738414, 0.45788540, \
0.45838807, 0.45889217, 0.45939768, 0.45990461, 0.46041295, \
0.46092271, 0.46143387, 0.46194644, 0.46246042, 0.46297580, \
0.46349258, 0.46401075, 0.46453033, 0.46505130, 0.46557366, \
0.46609741, 0.46662255, 0.46714907, 0.46767698, 0.46820626, \
0.46873693, 0.46926898, 0.46980239, 0.47033718, 0.47087335, \
0.47141087, 0.47194977, 0.47249003, 0.47303165, 0.47357462, \
0.47411896, 0.47466465, 0.47521169, 0.47576008, 0.47630982, \
0.47686091, 0.47741333, 0.47796710, 0.47852221, 0.47907865, \
0.47963643, 0.48019554, 0.48075598, 0.48131775, 0.48188084, \
0.48244526, 0.48301099, 0.48357804, 0.48414641, 0.48471609, \
0.48528709, 0.48585939, 0.48643300, 0.48700791, 0.48758412, \
0.48816164, 0.48874045, 0.48932055, 0.48990195, 0.49048464, \
0.49106861, 0.49165387, 0.49224042, 0.49282824, 0.49341734, \
0.49400772, 0.49459937, 0.49519230, 0.49578649, 0.49638194, \
0.49697867, 0.49757665, 0.49817589, 0.49877639, 0.49937814, \
0.49998114, 0.50058540, 0.50119090, 0.50179764, 0.50240563, \
0.50301485, 0.50362532, 0.50423702, 0.50484995, 0.50546411, \
0.50607950, 0.50669611, 0.50731394, 0.50793300, 0.50855327, \
0.50917476, 0.50979746, 0.51042137, 0.51104649, 0.51167282, \
0.51230034, 0.51292907, 0.51355900, 0.51419012, 0.51482243, \
0.51545593, 0.51609062, 0.51672650, 0.51736356, 0.51800180, \
0.51864122, 0.51928181, 0.51992358, 0.52056651, 0.52121061, \
0.52185588, 0.52250231, 0.52314991, 0.52379865, 0.52444856, \
0.52509961, 0.52575182, 0.52640518, 0.52705967, 0.52771531, \
0.52837210, 0.52903001, 0.52968907, 0.53034925, 0.53101057, \
0.53167301, 0.53233657, 0.53300126, 0.53366707, 0.53433399, \
0.53500203, 0.53567118, 0.53634143, 0.53701280, 0.53768527, \
0.53835884, 0.53903350, 0.53970927, 0.54038613, 0.54106407, \
0.54174311, 0.54242323, 0.54310444, 0.54378672, 0.54447008, \
0.54515452, 0.54584003, 0.54652661, 0.54721426, 0.54790298, \
0.54859275, 0.54928358, 0.54997548, 0.55066842, 0.55136242, \
0.55205746, 0.55275356, 0.55345069, 0.55414887, 0.55484808, \
0.55554833, 0.55624962, 0.55695193, 0.55765528, 0.55835964, \
0.55906503, 0.55977144, 0.56047887, 0.56118731, 0.56189677, \
0.56260723, 0.56331870, 0.56403117, 0.56474465, 0.56545912, \
0.56617459, 0.56689105, 0.56760850, 0.56832695, 0.56904637, \
0.56976678, 0.57048817, 0.57121053, 0.57193388, 0.57265819, \
0.57338347, 0.57410972, 0.57483693, 0.57556510, 0.57629423, \
0.57702432, 0.57775536, 0.57848735, 0.57922029, 0.57995417, \
0.58068900, 0.58142477, 0.58216147, 0.58289911, 0.58363767, \
0.58437717, 0.58511759, 0.58585894, 0.58660121, 0.58734439, \
0.58808849, 0.58883351, 0.58957943, 0.59032626, 0.59107400, \
0.59182263, 0.59257217, 0.59332260, 0.59407393, 0.59482614, \
0.59557925, 0.59633324, 0.59708811, 0.59784387, 0.59860050, \
0.59935800, 0.60011638, 0.60087563, 0.60163574, 0.60239672, \
0.60315856, 0.60392126, 0.60468481, 0.60544921, 0.60621447, \
0.60698057, 0.60774752, 0.60851531, 0.60928394, 0.61005340, \
0.61082370, 0.61159484, 0.61236679, 0.61313958, 0.61391319, \
0.61468762, 0.61546286, 0.61623892, 0.61701579, 0.61779348, \
0.61857197, 0.61935126, 0.62013135, 0.62091224, 0.62169393, \
0.62247641, 0.62325968, 0.62404374, 0.62482858, 0.62561421, \
0.62640061, 0.62718780, 0.62797575, 0.62876448, 0.62955397, \
0.63034423, 0.63113526, 0.63192704, 0.63271958, 0.63351288, \
0.63430692, 0.63510172, 0.63589726, 0.63669355, 0.63749058, \
0.63828835, 0.63908685, 0.63988609, 0.64068605, 0.64148675, \
0.64228816, 0.64309031, 0.64389316, 0.64469674, 0.64550103, \
0.64630603, 0.64711174, 0.64791816, 0.64872528, 0.64953309, \
0.65034161, 0.65115082, 0.65196072, 0.65277132, 0.65358259, \
0.65439456, 0.65520720, 0.65602052, 0.65683452, 0.65764919, \
0.65846453, 0.65928054, 0.66009722, 0.66091455, 0.66173255, \
0.66255120, 0.66337051, 0.66419046, 0.66501107, 0.66583232, \
0.66665422, 0.66747675, 0.66829993, 0.66912373, 0.66994818, \
0.67077325, 0.67159894, 0.67242526, 0.67325221, 0.67407977, \
0.67490795, 0.67573674, 0.67656614, 0.67739615, 0.67822676, \
0.67905798, 0.67988980, 0.68072221, 0.68155522, 0.68238882, \
0.68322301, 0.68405779, 0.68489315, 0.68572909, 0.68656561, \
0.68740271, 0.68824037, 0.68907861, 0.68991742, 0.69075679, \
0.69159672, 0.69243722, 0.69327826, 0.69411987, 0.69496202, \
0.69580473, 0.69664798, 0.69749177, 0.69833611, 0.69918098, \
0.70002639, 0.70087233, 0.70171880, 0.70256580, 0.70341332, \
0.70426136, 0.70510993, 0.70595901, 0.70680861, 0.70765871, \
0.70850933, 0.70936045, 0.71021208, 0.71106420, 0.71191683, \
0.71276995, 0.71362356, 0.71447766, 0.71533225, 0.71618733, \
0.71704289, 0.71789893, 0.71875544, 0.71961243, 0.72046989, \
0.72132782, 0.72218622, 0.72304508, 0.72390440, 0.72476418, \
0.72562442, 0.72648511, 0.72734625, 0.72820784, 0.72906987, \
0.72993235, 0.73079527, 0.73165863, 0.73252242, 0.73338664, \
0.73425129, 0.73511637, 0.73598188, 0.73684780, 0.73771415, \
0.73858091, 0.73944809, 0.74031568, 0.74118368, 0.74205208, \
0.74292089, 0.74379010, 0.74465971, 0.74552971, 0.74640011, \
0.74727090, 0.74814207, 0.74901364, 0.74988558, 0.75075791, \
0.75163062, 0.75250370, 0.75337715, 0.75425097, 0.75512517, \
0.75599972, 0.75687464, 0.75774992, 0.75862556, 0.75950155, \
0.76037790, 0.76125459, 0.76213163, 0.76300902, 0.76388675, \
0.76476482, 0.76564323, 0.76652197, 0.76740104, 0.76828045, \
0.76916018, 0.77004023, 0.77092061, 0.77180130, 0.77268232, \
0.77356365, 0.77444529, 0.77532724, 0.77620949, 0.77709205, \
0.77797492, 0.77885808, 0.77974154, 0.78062529, 0.78150934, \
0.78239368, 0.78327830, 0.78416321, 0.78504839, 0.78593386, \
0.78681961, 0.78770563, 0.78859192, 0.78947848, 0.79036531, \
0.79125241, 0.79213976, 0.79302738, 0.79391525, 0.79480338, \
0.79569176, 0.79658039, 0.79746927, 0.79835839, 0.79924776, \
0.80013737, 0.80102721, 0.80191729, 0.80280760, 0.80369814, \
0.80458891, 0.80547991, 0.80637113, 0.80726257, 0.80815422, \
0.80904610, 0.80993819, 0.81083048, 0.81172299, 0.81261570, \
0.81350862, 0.81440174, 0.81529506, 0.81618857, 0.81708228, \
0.81797618, 0.81887027, 0.81976454, 0.82065900, 0.82155365, \
0.82244847, 0.82334347, 0.82423865, 0.82513399, 0.82602951, \
0.82692520, 0.82782105, 0.82871707, 0.82961324, 0.83050958, \
0.83140607, 0.83230272, 0.83319951, 0.83409646, 0.83499355, \
0.83589079, 0.83678817, 0.83768569, 0.83858335, 0.83948114, \
0.84037907, 0.84127712, 0.84217531, 0.84307362, 0.84397205, \
0.84487061, 0.84576928, 0.84666807, 0.84756698, 0.84846600, \
0.84936512, 0.85026436, 0.85116370, 0.85206314, 0.85296268, \
0.85386233, 0.85476206, 0.85566190, 0.85656182, 0.85746183, \
0.85836193, 0.85926212, 0.86016238, 0.86106273, 0.86196315, \
0.86286366, 0.86376423, 0.86466487, 0.86556559, 0.86646637, \
0.86736722, 0.86826812, 0.86916909, 0.87007012, 0.87097120, \
0.87187233, 0.87277352, 0.87367475, 0.87457603, 0.87547736, \
0.87637873, 0.87728014, 0.87818158, 0.87908306, 0.87998458, \
0.88088613, 0.88178770, 0.88268930, 0.88359093, 0.88449258, \
0.88539425, 0.88629594, 0.88719764, 0.88809936, 0.88900109, \
0.88990283, 0.89080457, 0.89170633, 0.89260808, 0.89350984, \
0.89441159, 0.89531334, 0.89621509, 0.89711682, 0.89801855, \
0.89892027, 0.89982197, 0.90072365, 0.90162532, 0.90252697, \
0.90342859, 0.90433019, 0.90523176, 0.90613331, 0.90703482, \
0.90793630, 0.90883774, 0.90973915, 0.91064051, 0.91154184, \
0.91244312, 0.91334436, 0.91424555, 0.91514668, 0.91604777, \
0.91694880, 0.91784978, 0.91875070, 0.91965156, 0.92055235, \
0.92145308, 0.92235375, 0.92325434, 0.92415487, 0.92505532, \
0.92595570, 0.92685600, 0.92775623, 0.92865637, 0.92955643, \
0.93045641, 0.93135629, 0.93225609, 0.93315580, 0.93405542, \
0.93495494, 0.93585436, 0.93675369, 0.93765291, 0.93855204, \
0.93945105, 0.94034996, 0.94124876, 0.94214745, 0.94304603, \
0.94394449, 0.94484284, 0.94574107, 0.94663917, 0.94753715, \
0.94843501, 0.94933275, 0.95023035, 0.95112782, 0.95202516, \
0.95292237, 0.95381944, 0.95471637, 0.95561316, 0.95650981, \
0.95740631, 0.95830267, 0.95919888, 0.96009494, 0.96099085, \
0.96188660, 0.96278220, 0.96367764, 0.96457292, 0.96546804, \
0.96636300, 0.96725779, 0.96815242, 0.96904687, 0.96994115, \
0.97083527, 0.97172920, 0.97262296, 0.97351654, 0.97440994, \
0.97530316, 0.97619619, 0.97708904, 0.97798170, 0.97887417, \
0.97976645, 0.98065854, 0.98155043, 0.98244212, 0.98333361, \
0.98422491, 0.98511600, 0.98600688, 0.98689756, 0.98778803, \
0.98867829, 0.98956834, 0.99045818, 0.99134780, 0.99223720, \
0.99312638, 0.99401534, 0.99490408, 0.99579260, 0.99668088, \
0.99756894, 0.99845677, 0.99934437, 1.00023174, 1.00111887, \
1.00200576, 1.00289241, 1.00377882, 1.00466499, 1.00555092, \
1.00643659, 1.00732202, 1.00820721, 1.00909214, 1.00997681, \
1.01086123, 1.01174540, 1.01262931, 1.01351295, 1.01439634, \
1.01527946, 1.01616231, 1.01704490, 1.01792722, 1.01880927, \
1.01969105, 1.02057255, 1.02145378, 1.02233472, 1.02321539, \
1.02409578, 1.02497589, 1.02585571, 1.02673525, 1.02761449, \
1.02849345, 1.02937212, 1.03025049, 1.03112857, 1.03200636, \
1.03288384, 1.03376103, 1.03463791, 1.03551449, 1.03639077, \
1.03726674, 1.03814240, 1.03901775, 1.03989280, 1.04076752, \
1.04164194, 1.04251603, 1.04338981, 1.04426327, 1.04513641, \
1.04600923, 1.04688172, 1.04775388, 1.04862572, 1.04949722, \
1.05036840, 1.05123924, 1.05210975, 1.05297992, 1.05384976, \
1.05471925, 1.05558841, 1.05645722, 1.05732569, 1.05819381, \
1.05906159, 1.05992901, 1.06079609, 1.06166281, 1.06252918, \
1.06339520, 1.06426086, 1.06512616, 1.06599109, 1.06685567, \
1.06771989, 1.06858374, 1.06944722, 1.07031033, 1.07117308, \
1.07203545, 1.07289746, 1.07375908, 1.07462034, 1.07548121, \
1.07634171, 1.07720182, 1.07806156, 1.07892091, 1.07977987, \
1.08063845, 1.08149664, 1.08235444, 1.08321185, 1.08406886, \
1.08492549, 1.08578171, 1.08663754, 1.08749297, 1.08834800, \
1.08920263, 1.09005685, 1.09091067, 1.09176409, 1.09261709, \
1.09346969, 1.09432187, 1.09517365, 1.09602500, 1.09687595, \
1.09772647, 1.09857658, 1.09942627, 1.10027554, 1.10112438, \
1.10197280, 1.10282079, 1.10366836, 1.10451550, 1.10536221, \
1.10620848, 1.10705433, 1.10789973, 1.10874471, 1.10958924, \
1.11043334, 1.11127699, 1.11212021, 1.11296298, 1.11380530, \
1.11464718, 1.11548861, 1.11632959, 1.11717013, 1.11801021, \
1.11884983, 1.11968901, 1.12052772, 1.12136598, 1.12220378, \
1.12304112, 1.12387799, 1.12471441, 1.12555035, 1.12638584, \
1.12722085, 1.12805540, 1.12888947, 1.12972307, 1.13055620, \
1.13138886, 1.13222104, 1.13305274, 1.13388397, 1.13471471, \
1.13554497, 1.13637475, 1.13720404, 1.13803285, 1.13886117, \
1.13968901, 1.14051635, 1.14134320, 1.14216956, 1.14299543, \
1.14382080, 1.14464567, 1.14547005, 1.14629392, 1.14711730, \
1.14794017, 1.14876254, 1.14958441, 1.15040577, 1.15122662, \
1.15204696, 1.15286680, 1.15368612, 1.15450492, 1.15532322, \
1.15614100, 1.15695826, 1.15777500, 1.15859123, 1.15940693, \
1.16022211, 1.16103677, 1.16185090, 1.16266451, 1.16347759, \
1.16429014, 1.16510216, 1.16591364, 1.16672460, 1.16753502, \
1.16834491, 1.16915426, 1.16996307, 1.17077134, 1.17157908, \
1.17238627, 1.17319291, 1.17399902, 1.17480458, 1.17560959, \
1.17641405, 1.17721796, 1.17802132, 1.17882413, 1.17962639, \
1.18042809, 1.18122924, 1.18202983, 1.18282986, 1.18362933, \
1.18442824, 1.18522658, 1.18602437, 1.18682159, 1.18761824, \
1.18841432, 1.18920984, 1.19000479, 1.19079916, 1.19159297, \
1.19238620, 1.19317885, 1.19397093, 1.19476243, 1.19555336, \
1.19634370, 1.19713346, 1.19792264, 1.19871124, 1.19949925, \
1.20028668, 1.20107352, 1.20185977, 1.20264543, 1.20343050, \
1.20421498, 1.20499886, 1.20578215, 1.20656484, 1.20734694, \
1.20812844, 1.20890934, 1.20968964, 1.21046934, 1.21124843, \
1.21202692, 1.21280480, 1.21358208, 1.21435875, 1.21513481, \
1.21591026, 1.21668510, 1.21745933, 1.21823294, 1.21900594, \
1.21977832, 1.22055008, 1.22132123, 1.22209175, 1.22286166, \
1.22363094, 1.22439960, 1.22516763, 1.22593504, 1.22670182, \
1.22746798, 1.22823350, 1.22899840, 1.22976266, 1.23052629, \
1.23128928, 1.23205165, 1.23281337, 1.23357446, 1.23433491, \
1.23509471, 1.23585388, 1.23661241, 1.23737029, 1.23812753, \
1.23888412, 1.23964007, 1.24039537, 1.24115002, 1.24190402, \
1.24265737, 1.24341006, 1.24416210, 1.24491349, 1.24566422, \
1.24641430, 1.24716371, 1.24791247, 1.24866057, 1.24940800, \
1.25015478, 1.25090089, 1.25164633, 1.25239111, 1.25313522, \
1.25387866, 1.25462144, 1.25536354, 1.25610497, 1.25684573, \
1.25758582, 1.25832523, 1.25906396, 1.25980202, 1.26053939, \
1.26127609, 1.26201211, 1.26274745, 1.26348210, 1.26421607, \
1.26494935, 1.26568195, 1.26641386, 1.26714509, 1.26787562, \
1.26860546, 1.26933462, 1.27006307, 1.27079084, 1.27151791, \
1.27224428, 1.27296996, 1.27369494, 1.27441922, 1.27514280, \
1.27586568, 1.27658785, 1.27730932, 1.27803009, 1.27875015, \
1.27946951, 1.28018815, 1.28090609, 1.28162332, 1.28233984, \
1.28305564, 1.28377073, 1.28448511, 1.28519877, 1.28591171, \
1.28662394, 1.28733545, 1.28804624, 1.28875630, 1.28946565, \
1.29017427, 1.29088217, 1.29158935, 1.29229579, 1.29300151, \
1.29370651, 1.29441077, 1.29511430, 1.29581710, 1.29651917, \
1.29722051, 1.29792111, 1.29862097, 1.29932010, 1.30001849, \
1.30071615, 1.30141306, 1.30210923, 1.30280466, 1.30349935, \
1.30419329, 1.30488649, 1.30557894, 1.30627064, 1.30696160, \
1.30765181, 1.30834126, 1.30902997, 1.30971792, 1.31040512, \
1.31109157, 1.31177726, 1.31246219, 1.31314637, 1.31382979, \
1.31451245, 1.31519435, 1.31587548, 1.31655586, 1.31723547, \
1.31791432, 1.31859240, 1.31926971, 1.31994626, 1.32062204, \
1.32129704, 1.32197128, 1.32264475, 1.32331744, 1.32398936, \
1.32466050, 1.32533087, 1.32600047, 1.32666928, 1.32733732, \
1.32800457, 1.32867105, 1.32933674, 1.33000165, 1.33066578, \
1.33132912, 1.33199168, 1.33265344, 1.33331443, 1.33397462, \
1.33463402, 1.33529263, 1.33595045, 1.33660748, 1.33726372, \
1.33791916, 1.33857380, 1.33922765, 1.33988069, 1.34053294, \
1.34118440, 1.34183505, 1.34248489, 1.34313394, 1.34378218, \
1.34442962, 1.34507625, 1.34572208, 1.34636709, 1.34701130, \
1.34765470, 1.34829729, 1.34893907, 1.34958003, 1.35022019, \
1.35085952, 1.35149805, 1.35213575, 1.35277264, 1.35340871, \
1.35404396, 1.35467839, 1.35531200, 1.35594479, 1.35657675, \
1.35720789, 1.35783821, 1.35846770, 1.35909636, 1.35972419, \
1.36035120, 1.36097737, 1.36160272, 1.36222723, 1.36285091, \
1.36347376, 1.36409577, 1.36471695, 1.36533729, 1.36595679, \
1.36657545, 1.36719328, 1.36781026, 1.36842640, 1.36904171, \
1.36965616, 1.37026978, 1.37088255, 1.37149447, 1.37210554, \
1.37271577, 1.37332515, 1.37393368, 1.37454136, 1.37514818, \
1.37575416, 1.37635928, 1.37696354, 1.37756695, 1.37816951, \
1.37877121, 1.37937204, 1.37997202, 1.38057114, 1.38116940, \
1.38176680, 1.38236333, 1.38295900, 1.38355381, 1.38414775, \
1.38474082, 1.38533303, 1.38592437, 1.38651483, 1.38710443, \
1.38769316, 1.38828101, 1.38886799, 1.38945410, 1.39003933, \
1.39062369, 1.39120717, 1.39178977, 1.39237150, 1.39295234, \
1.39353231, 1.39411139, 1.39468959, 1.39526691, 1.39584335, \
1.39641890, 1.39699356, 1.39756734, 1.39814023, 1.39871223, \
1.39928334, 1.39985356, 1.40042289, 1.40099133, 1.40155887, \
1.40212552, 1.40269128, 1.40325614, 1.40382010, 1.40438317, \
1.40494534, 1.40550661, 1.40606698, 1.40662645, 1.40718501, \
1.40774267, 1.40829943, 1.40885529, 1.40941024, 1.40996428, \
1.41051742, 1.41106964, 1.41162096, 1.41217137, 1.41272087, \
1.41326946, 1.41381713, 1.41436389, 1.41490974, 1.41545467, \
1.41599868, 1.41654178, 1.41708396, 1.41762522, 1.41816556, \
1.41870498, 1.41924349, 1.41978106, 1.42031772, 1.42085345, \
1.42138826, 1.42192214, 1.42245509, 1.42298712, 1.42351822, \
1.42404839, 1.42457763, 1.42510593, 1.42563331, 1.42615976, \
1.42668527, 1.42720985, 1.42773349, 1.42825619, 1.42877796, \
1.42929880, 1.42981869, 1.43033764, 1.43085566, 1.43137273, \
1.43188886, 1.43240405, 1.43291829, 1.43343159, 1.43394395, \
1.43445536, 1.43496582, 1.43547533, 1.43598390, 1.43649151, \
1.43699818, 1.43750389, 1.43800866, 1.43851247, 1.43901532, \
1.43951722, 1.44001817, 1.44051816, 1.44101719, 1.44151527, \
1.44201239, 1.44250854, 1.44300374, 1.44349798, 1.44399125, \
1.44448356, 1.44497491, 1.44546529, 1.44595471, 1.44644317, \
1.44693065, 1.44741717, 1.44790272, 1.44838730, 1.44887091, \
1.44935355, 1.44983521, 1.45031591, 1.45079563, 1.45127438, \
1.45175215, 1.45222895, 1.45270477, 1.45317961, 1.45365347, \
1.45412636, 1.45459826, 1.45506919, 1.45553913, 1.45600810, \
1.45647607, 1.45694307, 1.45740908, 1.45787411, 1.45833814, \
1.45880120, 1.45926326, 1.45972434, 1.46018442, 1.46064352, \
1.46110163, 1.46155874, 1.46201486, 1.46246999, 1.46292412, \
1.46337726, 1.46382941, 1.46428056, 1.46473071, 1.46517986, \
1.46562802, 1.46607517, 1.46652133, 1.46696648, 1.46741063, \
1.46785378, 1.46829593, 1.46873707, 1.46917721, 1.46961634, \
1.47005447, 1.47049159, 1.47092770, 1.47136280, 1.47179689, \
1.47222998, 1.47266205, 1.47309311, 1.47352316, 1.47395219, \
1.47438021, 1.47480722, 1.47523321, 1.47565819, 1.47608215, \
1.47650509, 1.47692701, 1.47734791, 1.47776780, 1.47818666, \
1.47860450, 1.47902132, 1.47943712, 1.47985190, 1.48026565, \
1.48067837, 1.48109007, 1.48150074, 1.48191039, 1.48231901, \
1.48272660, 1.48313316, 1.48353869, 1.48394319, 1.48434666, \
1.48474909, 1.48515050, 1.48555087, 1.48595020, 1.48634850, \
1.48674577, 1.48714200, 1.48753719, 1.48793134, 1.48832446, \
1.48871653, 1.48910757, 1.48949757, 1.48988652, 1.49027443, \
1.49066130, 1.49104713, 1.49143191, 1.49181565, 1.49219834, \
1.49257998, 1.49296058, 1.49334013, 1.49371864, 1.49409609, \
1.49447249, 1.49484785, 1.49522215, 1.49559540, 1.49596760, \
1.49633875, 1.49670884, 1.49707788, 1.49744586, 1.49781279, \
1.49817866, 1.49854347, 1.49890723, 1.49926993, 1.49963157, \
1.49999215, 1.50035167, 1.50071013, 1.50106752, 1.50142386, \
1.50177913, 1.50213334, 1.50248648, 1.50283856, 1.50318957, \
1.50353952, 1.50388840, 1.50423622, 1.50458296, 1.50492864, \
1.50527324, 1.50561678, 1.50595925, 1.50630064, 1.50664097, \
1.50698022, 1.50731839, 1.50765550, 1.50799153, 1.50832648, \
1.50866036, 1.50899316, 1.50932489, 1.50965554, 1.50998511, \
1.51031360, 1.51064101, 1.51096734, 1.51129260, 1.51161677, \
1.51193986, 1.51226186, 1.51258279, 1.51290263, 1.51322138, \
1.51353905, 1.51385564, 1.51417114, 1.51448555, 1.51479888, \
1.51511112, 1.51542227, 1.51573233, 1.51604130, 1.51634918, \
1.51665597, 1.51696167, 1.51726628, 1.51756980, 1.51787222, \
1.51817355, 1.51847378, 1.51877293, 1.51907097, 1.51936792, \
1.51966377, 1.51995853, 1.52025219, 1.52054475, 1.52083621, \
1.52112658, 1.52141584, 1.52170401, 1.52199107, 1.52227703, \
1.52256189, 1.52284565, 1.52312830, 1.52340986, 1.52369030, \
1.52396964, 1.52424788, 1.52452501, 1.52480104, 1.52507596, \
1.52534977, 1.52562248, 1.52589407, 1.52616456, 1.52643394, \
1.52670221, 1.52696936, 1.52723541, 1.52750035, 1.52776417, \
1.52802688, 1.52828848, 1.52854897, 1.52880834, 1.52906660, \
1.52932374, 1.52957977, 1.52983468, 1.53008847, 1.53034115, \
1.53059271, 1.53084316, 1.53109248, 1.53134069, 1.53158777, \
1.53183374, 1.53207859, 1.53232232, 1.53256492, 1.53280640, \
1.53304677, 1.53328600, 1.53352412, 1.53376111, 1.53399698, \
1.53423173, 1.53446534, 1.53469784, 1.53492921, 1.53515945, \
1.53538856, 1.53561655, 1.53584341, 1.53606914, 1.53629375, \
1.53651722, 1.53673957, 1.53696079, 1.53718087, 1.53739983, \
1.53761765, 1.53783434, 1.53804991, 1.53826433, 1.53847763, \
1.53868979, 1.53890082, 1.53911072, 1.53931948, 1.53952710, \
1.53973359, 1.53993895, 1.54014317, 1.54034625, 1.54054819, \
1.54074900, 1.54094867, 1.54114721, 1.54134460, 1.54154085, \
1.54173597, 1.54192995, 1.54212278, 1.54231448, 1.54250504, \
1.54269445, 1.54288272, 1.54306985, 1.54325584, 1.54344069, \
1.54362439, 1.54380695, 1.54398837, 1.54416864, 1.54434777, \
1.54452575, 1.54470259, 1.54487828, 1.54505283, 1.54522623, \
1.54539848, 1.54556959, 1.54573955, 1.54590836, 1.54607602, \
1.54624254, 1.54640790, 1.54657212, 1.54673519, 1.54689711, \
1.54705788, 1.54721750, 1.54737597, 1.54753329, 1.54768945, \
1.54784447, 1.54799833, 1.54815105, 1.54830261, 1.54845301, \
1.54860227, 1.54875037, 1.54889731, 1.54904311, 1.54918775, \
1.54933123, 1.54947356, 1.54961473, 1.54975475, 1.54989362, \
1.55003132, 1.55016788, 1.55030327, 1.55043751, 1.55057059, \
1.55070252, 1.55083328, 1.55096289, 1.55109134, 1.55121863, \
1.55134477, 1.55146974, 1.55159356, 1.55171622, 1.55183771, \
1.55195805, 1.55207723, 1.55219525, 1.55231210, 1.55242780, \
1.55254234, 1.55265571, 1.55276792, 1.55287897, 1.55298886, \
1.55309759, 1.55320515, 1.55331155, 1.55341679, 1.55352087, \
1.55362378, 1.55372553, 1.55382612, 1.55392554, 1.55402380, \
1.55412089, 1.55421682, 1.55431158, 1.55440518, 1.55449762, \
1.55458889, 1.55467899, 1.55476793, 1.55485570, 1.55494231, \
1.55502775, 1.55511203, 1.55519513, 1.55527707, 1.55535785, \
1.55543746, 1.55551590, 1.55559317, 1.55566928, 1.55574422, \
1.55581799, 1.55589059, 1.55596202, 1.55603229, 1.55610139, \
1.55616932, 1.55623608, 1.55630167, 1.55636610, 1.55642935, \
1.55649144, 1.55655235, 1.55661210, 1.55667068, 1.55672809, \
1.55678433, 1.55683939, 1.55689329, 1.55694602, 1.55699758, \
1.55704797, 1.55709718, 1.55714523, 1.55719211, 1.55723781, \
1.55728235, 1.55732571, 1.55736791, 1.55740893, 1.55744878, \
1.55748746, 1.55752497, 1.55756130, 1.55759647, 1.55763046, \
1.55766329, 1.55769494, 1.55772542, 1.55775472, 1.55778286, \
1.55780982, 1.55783562, 1.55786023, 1.55788368, 1.55790596, \
1.55792706, 1.55794699, 1.55796575, 1.55798334, 1.55799975, \
1.55801500, 1.55802907, 1.55804196, 1.55805369, 1.55806424, \
1.55807362, 1.55808183, 1.55808886, 1.55809473, 1.55809942, \
1.55810294, 1.55810528, 1.55810645, } 


 #endif // _FPU_FFT_TAYLOR_H_
//=============================================================================
// End of File
//=============================================================================

