//=============================================================================
// Tukey Window 
//=============================================================================
#ifndef _FPU_FFT_TUKEY_H_
#define _FPU_FFT_TUKEY_H_

#define TUKEY32 {\
0.00000000, 0.04052109, 0.15551654, 0.32634737, 0.52532458, \
0.72019708, 0.87937906, 0.97706963, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, } 

#define TUKEY64 {\
0.00000000, 0.00991376, 0.03926189, 0.08688061, 0.15088159, \
0.22872687, 0.31732949, 0.41317591, 0.51246535, 0.61126047, \
0.70564355, 0.79187184, 0.86652594, 0.92664544, 0.96984631, \
0.99441541, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, } 

#define TUKEY128 {\
0.00000000, 0.00244567, 0.00975876, 0.02186772, 0.03865409, \
0.05995367, 0.08555808, 0.11521684, 0.14863981, 0.18550003, \
0.22543690, 0.26805974, 0.31295157, 0.35967324, 0.40776768, \
0.45676440, 0.50618408, 0.55554326, 0.60435908, 0.65215399, \
0.69846043, 0.74282539, 0.78481486, 0.82401809, 0.86005154, \
0.89256273, 0.92123360, 0.94578368, 0.96597280, 0.98160345, \
0.99252273, 0.99862382, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, } 

#define TUKEY256 {\
0.00000000, 0.00060700, 0.00242654, 0.00545420, 0.00968261, \
0.01510153, 0.02169779, 0.02945537, 0.03835545, 0.04837640, \
0.05949390, 0.07168096, 0.08490798, 0.09914286, 0.11435102, \
0.13049554, 0.14753723, 0.16543470, 0.18414450, 0.20362120, \
0.22381751, 0.24468440, 0.26617120, 0.28822574, 0.31079447, \
0.33382260, 0.35725421, 0.38103240, 0.40509945, 0.42939692, \
0.45386582, 0.47844673, 0.50307997, 0.52770574, 0.55226423, \
0.57669583, 0.60094120, 0.62494149, 0.64863843, 0.67197446, \
0.69489294, 0.71733821, 0.73925578, 0.76059244, 0.78129638, \
0.80131732, 0.82060666, 0.83911756, 0.85680508, 0.87362627, \
0.88954029, 0.90450850, 0.91849455, 0.93146450, 0.94338684, \
0.95423264, 0.96397554, 0.97259191, 0.98006082, 0.98636414, \
0.99148655, 0.99541563, 0.99814183, 0.99965853, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, } 

#define TUKEY512 {\
0.00000000, 0.00015118, 0.00060463, 0.00136008, 0.00241706, \
0.00377495, 0.00543291, 0.00738995, 0.00964488, 0.01219634, \
0.01504278, 0.01818249, 0.02161357, 0.02533393, 0.02934134, \
0.03363337, 0.03820741, 0.04306072, 0.04819034, 0.05359319, \
0.05926599, 0.06520531, 0.07140755, 0.07786898, 0.08458568, \
0.09155359, 0.09876850, 0.10622604, 0.11392171, 0.12185084, \
0.13000865, 0.13839021, 0.14699043, 0.15580413, 0.16482597, \
0.17405050, 0.18347214, 0.19308519, 0.20288384, 0.21286216, \
0.22301412, 0.23333358, 0.24381429, 0.25444993, 0.26523406, \
0.27616016, 0.28722162, 0.29841175, 0.30972378, 0.32115088, \
0.33268613, 0.34432257, 0.35605314, 0.36787076, 0.37976828, \
0.39173851, 0.40377421, 0.41586810, 0.42801286, 0.44020116, \
0.45242561, 0.46467884, 0.47695343, 0.48924195, 0.50153698, \
0.51383108, 0.52611682, 0.53838676, 0.55063349, 0.56284960, \
0.57502770, 0.58716043, 0.59924046, 0.61126047, 0.62321320, \
0.63509142, 0.64688794, 0.65859564, 0.67020744, 0.68171630, \
0.69311528, 0.70439748, 0.71555607, 0.72658431, 0.73747554, \
0.74822315, 0.75882066, 0.76926165, 0.77953982, 0.78964894, \
0.79958290, 0.80933570, 0.81890144, 0.82827433, 0.83744870, \
0.84641902, 0.85517984, 0.86372588, 0.87205197, 0.88015307, \
0.88802428, 0.89566085, 0.90305815, 0.91021171, 0.91711720, \
0.92377046, 0.93016746, 0.93630432, 0.94217734, 0.94778296, \
0.95311780, 0.95817863, 0.96296239, 0.96746618, 0.97168729, \
0.97562316, 0.97927141, 0.98262983, 0.98569639, 0.98846925, \
0.99094671, 0.99312729, 0.99500966, 0.99659269, 0.99787542, \
0.99885707, 0.99953706, 0.99991496, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, } 

#define TUKEY1024 {\
0.00000000, 0.00003772, 0.00015089, 0.00033947, 0.00060345, \
0.00094278, 0.00135742, 0.00184730, 0.00241234, 0.00305247, \
0.00376758, 0.00455757, 0.00542231, 0.00636168, 0.00737554, \
0.00846373, 0.00962609, 0.01086244, 0.01217260, 0.01355637, \
0.01501354, 0.01654388, 0.01814718, 0.01982318, 0.02157164, \
0.02339229, 0.02528485, 0.02724904, 0.02928457, 0.03139113, \
0.03356839, 0.03581603, 0.03813372, 0.04052109, 0.04297780, \
0.04550347, 0.04809772, 0.05076015, 0.05349037, 0.05628797, \
0.05915252, 0.06208358, 0.06508073, 0.06814350, 0.07127143, \
0.07446406, 0.07772089, 0.08104144, 0.08442521, 0.08787169, \
0.09138035, 0.09495067, 0.09858211, 0.10227412, 0.10602614, \
0.10983760, 0.11370794, 0.11763657, 0.12162290, 0.12566631, \
0.12976621, 0.13392198, 0.13813298, 0.14239859, 0.14671815, \
0.15109102, 0.15551654, 0.15999404, 0.16452284, 0.16910226, \
0.17373161, 0.17841020, 0.18313730, 0.18791222, 0.19273423, \
0.19760261, 0.20251661, 0.20747550, 0.21247853, 0.21752494, \
0.22261398, 0.22774487, 0.23291685, 0.23812912, 0.24338091, \
0.24867142, 0.25399985, 0.25936540, 0.26476726, 0.27020461, \
0.27567664, 0.28118252, 0.28672142, 0.29229249, 0.29789491, \
0.30352783, 0.30919039, 0.31488174, 0.32060102, 0.32634737, \
0.33211993, 0.33791782, 0.34374016, 0.34958608, 0.35545470, \
0.36134513, 0.36725648, 0.37318786, 0.37913838, 0.38510713, \
0.39109322, 0.39709574, 0.40311379, 0.40914646, 0.41519284, \
0.42125201, 0.42732307, 0.43340509, 0.43949716, 0.44559836, \
0.45170777, 0.45782447, 0.46394753, 0.47007603, 0.47620904, \
0.48234565, 0.48848492, 0.49462592, 0.50076774, 0.50690944, \
0.51305010, 0.51918879, 0.52532458, 0.53145656, 0.53758378, \
0.54370534, 0.54982030, 0.55592774, 0.56202675, 0.56811639, \
0.57419576, 0.58026393, 0.58631999, 0.59236303, 0.59839213, \
0.60440638, 0.61040488, 0.61638672, 0.62235099, 0.62829681, \
0.63422327, 0.64012947, 0.64601453, 0.65187756, 0.65771767, \
0.66353398, 0.66932562, 0.67509171, 0.68083137, 0.68654375, \
0.69222799, 0.69788322, 0.70350859, 0.70910325, 0.71466636, \
0.72019708, 0.72569457, 0.73115801, 0.73658657, 0.74197942, \
0.74733577, 0.75265480, 0.75793570, 0.76317768, 0.76837996, \
0.77354173, 0.77866223, 0.78374068, 0.78877632, 0.79376839, \
0.79871613, 0.80361879, 0.80847564, 0.81328595, 0.81804898, \
0.82276403, 0.82743037, 0.83204730, 0.83661413, 0.84113017, \
0.84559474, 0.85000716, 0.85436676, 0.85867290, 0.86292491, \
0.86712217, 0.87126402, 0.87534986, 0.87937906, 0.88335102, \
0.88726513, 0.89112080, 0.89491746, 0.89865453, 0.90233145, \
0.90594766, 0.90950262, 0.91299578, 0.91642663, 0.91979464, \
0.92309931, 0.92634014, 0.92951663, 0.93262832, 0.93567473, \
0.93865540, 0.94156987, 0.94441772, 0.94719852, 0.94991183, \
0.95255725, 0.95513439, 0.95764286, 0.96008226, 0.96245225, \
0.96475246, 0.96698254, 0.96914215, 0.97123098, 0.97324870, \
0.97519502, 0.97706963, 0.97887225, 0.98060262, 0.98226047, \
0.98384555, 0.98535763, 0.98679646, 0.98816185, 0.98945357, \
0.99067144, 0.99181528, 0.99288490, 0.99388015, 0.99480088, \
0.99564694, 0.99641822, 0.99711460, 0.99773596, 0.99828222, \
0.99875330, 0.99914911, 0.99946961, 0.99971475, 0.99988448, \
0.99997878, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, } 

#define TUKEY2048 {\
0.00000000, 0.00000942, 0.00003769, 0.00008479, 0.00015074, \
0.00023552, 0.00033914, 0.00046159, 0.00060286, 0.00076295, \
0.00094186, 0.00113958, 0.00135610, 0.00159140, 0.00184549, \
0.00211836, 0.00240999, 0.00272037, 0.00304949, 0.00339734, \
0.00376390, 0.00414917, 0.00455312, 0.00497574, 0.00541702, \
0.00587694, 0.00635548, 0.00685263, 0.00736836, 0.00790265, \
0.00845549, 0.00902685, 0.00961672, 0.01022507, 0.01085187, \
0.01149711, 0.01216076, 0.01284279, 0.01354319, 0.01426191, \
0.01499894, 0.01575425, 0.01652781, 0.01731959, 0.01812956, \
0.01895769, 0.01980395, 0.02066830, 0.02155072, 0.02245117, \
0.02336962, 0.02430603, 0.02526036, 0.02623259, 0.02722267, \
0.02823057, 0.02925625, 0.03029967, 0.03136079, 0.03243957, \
0.03353597, 0.03464995, 0.03578147, 0.03693048, 0.03809695, \
0.03928082, 0.04048206, 0.04170061, 0.04293643, 0.04418948, \
0.04545971, 0.04674706, 0.04805150, 0.04937297, 0.05071142, \
0.05206681, 0.05343907, 0.05482817, 0.05623404, 0.05765664, \
0.05909590, 0.06055178, 0.06202423, 0.06351317, 0.06501857, \
0.06654036, 0.06807849, 0.06963289, 0.07120352, 0.07279030, \
0.07439318, 0.07601210, 0.07764700, 0.07929782, 0.08096449, \
0.08264695, 0.08434515, 0.08605900, 0.08778846, 0.08953345, \
0.09129391, 0.09306977, 0.09486097, 0.09666744, 0.09848911, \
0.10032590, 0.10217776, 0.10404462, 0.10592639, 0.10782302, \
0.10973442, 0.11166054, 0.11360129, 0.11555660, 0.11752639, \
0.11951061, 0.12150916, 0.12352197, 0.12554898, 0.12759009, \
0.12964524, 0.13171435, 0.13379734, 0.13589412, 0.13800463, \
0.14012878, 0.14226650, 0.14441769, 0.14658229, 0.14876020, \
0.15095135, 0.15315566, 0.15537304, 0.15760340, 0.15984667, \
0.16210276, 0.16437158, 0.16665305, 0.16894708, 0.17125359, \
0.17357249, 0.17590369, 0.17824710, 0.18060264, 0.18297022, \
0.18534974, 0.18774113, 0.19014428, 0.19255910, 0.19498552, \
0.19742343, 0.19987274, 0.20233336, 0.20480520, 0.20728816, \
0.20978216, 0.21228709, 0.21480287, 0.21732939, 0.21986657, \
0.22241430, 0.22497250, 0.22754106, 0.23011989, 0.23270888, \
0.23530796, 0.23791700, 0.24053593, 0.24316463, 0.24580301, \
0.24845097, 0.25110841, 0.25377523, 0.25645133, 0.25913661, \
0.26183097, 0.26453430, 0.26724650, 0.26996748, 0.27269713, \
0.27543534, 0.27818201, 0.28093705, 0.28370034, 0.28647178, \
0.28925127, 0.29203870, 0.29483397, 0.29763697, 0.30044760, \
0.30326574, 0.30609130, 0.30892417, 0.31176424, 0.31461141, \
0.31746556, 0.32032659, 0.32319439, 0.32606885, 0.32894987, \
0.33183733, 0.33473114, 0.33763117, 0.34053732, 0.34344947, \
0.34636753, 0.34929138, 0.35222091, 0.35515601, 0.35809656, \
0.36104247, 0.36399361, 0.36694988, 0.36991116, 0.37287734, \
0.37584831, 0.37882397, 0.38180419, 0.38478886, 0.38777787, \
0.39077112, 0.39376848, 0.39676985, 0.39977510, 0.40278413, \
0.40579683, 0.40881307, 0.41183276, 0.41485576, 0.41788198, \
0.42091128, 0.42394357, 0.42697873, 0.43001664, 0.43305718, \
0.43610025, 0.43914572, 0.44219349, 0.44524344, 0.44829545, \
0.45134941, 0.45440521, 0.45746272, 0.46052183, 0.46358243, \
0.46664441, 0.46970764, 0.47277201, 0.47583741, 0.47890372, \
0.48197083, 0.48503861, 0.48810696, 0.49117576, 0.49424489, \
0.49731424, 0.50038368, 0.50345312, 0.50652242, 0.50959148, \
0.51266017, 0.51572839, 0.51879601, 0.52186293, 0.52492903, \
0.52799418, 0.53105828, 0.53412121, 0.53718285, 0.54024309, \
0.54330182, 0.54635891, 0.54941425, 0.55246774, 0.55551924, \
0.55856866, 0.56161586, 0.56466075, 0.56770320, 0.57074309, \
0.57378032, 0.57681477, 0.57984633, 0.58287487, 0.58590029, \
0.58892248, 0.59194131, 0.59495668, 0.59796847, 0.60097657, \
0.60398087, 0.60698124, 0.60997758, 0.61296978, 0.61595772, \
0.61894129, 0.62192038, 0.62489487, 0.62786466, 0.63082963, \
0.63378967, 0.63674466, 0.63969450, 0.64263908, 0.64557828, \
0.64851200, 0.65144012, 0.65436253, 0.65727912, 0.66018979, \
0.66309442, 0.66599290, 0.66888513, 0.67177099, 0.67465038, \
0.67752319, 0.68038931, 0.68324863, 0.68610104, 0.68894644, \
0.69178472, 0.69461578, 0.69743949, 0.70025577, 0.70306450, \
0.70586558, 0.70865890, 0.71144435, 0.71422184, 0.71699125, \
0.71975249, 0.72250544, 0.72525001, 0.72798609, 0.73071358, \
0.73343237, 0.73614237, 0.73884347, 0.74153556, 0.74421856, \
0.74689235, 0.74955683, 0.75221191, 0.75485749, 0.75749346, \
0.76011972, 0.76273619, 0.76534275, 0.76793931, 0.77052578, \
0.77310205, 0.77566803, 0.77822361, 0.78076872, 0.78330324, \
0.78582709, 0.78834016, 0.79084237, 0.79333362, 0.79581381, \
0.79828285, 0.80074066, 0.80318712, 0.80562217, 0.80804569, \
0.81045761, 0.81285783, 0.81524625, 0.81762280, 0.81998737, \
0.82233989, 0.82468026, 0.82700839, 0.82932420, 0.83162760, \
0.83391850, 0.83619682, 0.83846246, 0.84071535, 0.84295540, \
0.84518253, 0.84739665, 0.84959767, 0.85178552, 0.85396011, \
0.85612137, 0.85826920, 0.86040353, 0.86252428, 0.86463136, \
0.86672471, 0.86880423, 0.87086986, 0.87292151, 0.87495910, \
0.87698256, 0.87899182, 0.88098679, 0.88296741, 0.88493359, \
0.88688527, 0.88882237, 0.89074481, 0.89265253, 0.89454545, \
0.89642350, 0.89828661, 0.90013471, 0.90196773, 0.90378560, \
0.90558826, 0.90737563, 0.90914765, 0.91090425, 0.91264536, \
0.91437093, 0.91608087, 0.91777514, 0.91945366, 0.92111637, \
0.92276322, 0.92439413, 0.92600905, 0.92760791, 0.92919066, \
0.93075723, 0.93230757, 0.93384162, 0.93535932, 0.93686061, \
0.93834543, 0.93981374, 0.94126547, 0.94270058, 0.94411900, \
0.94552068, 0.94690557, 0.94827362, 0.94962478, 0.95095899, \
0.95227621, 0.95357638, 0.95485946, 0.95612539, 0.95737414, \
0.95860565, 0.95981988, 0.96101678, 0.96219630, 0.96335841, \
0.96450305, 0.96563019, 0.96673978, 0.96783178, 0.96890615, \
0.96996285, 0.97100183, 0.97202307, 0.97302652, 0.97401214, \
0.97497990, 0.97592976, 0.97686168, 0.97777563, 0.97867158, \
0.97954948, 0.98040932, 0.98125104, 0.98207464, 0.98288006, \
0.98366729, 0.98443629, 0.98518703, 0.98591949, 0.98663363, \
0.98732944, 0.98800688, 0.98866593, 0.98930656, 0.98992875, \
0.99053248, 0.99111772, 0.99168446, 0.99223266, 0.99276232, \
0.99327340, 0.99376590, 0.99423978, 0.99469504, 0.99513166, \
0.99554962, 0.99594890, 0.99632949, 0.99669138, 0.99703455, \
0.99735898, 0.99766468, 0.99795162, 0.99821979, 0.99846919, \
0.99869980, 0.99891161, 0.99910463, 0.99927883, 0.99943422, \
0.99957079, 0.99968853, 0.99978744, 0.99986751, 0.99992875, \
0.99997115, 0.99999470, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, } 

#define TUKEY4096 {\
0.00000000, 0.00000235, 0.00000942, 0.00002119, 0.00003767, \
0.00005886, 0.00008475, 0.00011535, 0.00015066, 0.00019068, \
0.00023541, 0.00028484, 0.00033897, 0.00039781, 0.00046136, \
0.00052961, 0.00060257, 0.00068022, 0.00076258, 0.00084964, \
0.00094140, 0.00103786, 0.00113902, 0.00124488, 0.00135543, \
0.00147068, 0.00159063, 0.00171526, 0.00184459, 0.00197861, \
0.00211733, 0.00226073, 0.00240881, 0.00256158, 0.00271904, \
0.00288118, 0.00304800, 0.00321950, 0.00339568, 0.00357654, \
0.00376207, 0.00395227, 0.00414715, 0.00434669, 0.00455090, \
0.00475978, 0.00497332, 0.00519152, 0.00541438, 0.00564190, \
0.00587408, 0.00611091, 0.00635239, 0.00659851, 0.00684929, \
0.00710471, 0.00736477, 0.00762946, 0.00789880, 0.00817277, \
0.00845137, 0.00873460, 0.00902246, 0.00931494, 0.00961204, \
0.00991376, 0.01022009, 0.01053104, 0.01084659, 0.01116675, \
0.01149152, 0.01182088, 0.01215485, 0.01249340, 0.01283655, \
0.01318428, 0.01353660, 0.01389350, 0.01425498, 0.01462103, \
0.01499166, 0.01536685, 0.01574660, 0.01613091, 0.01651979, \
0.01691321, 0.01731118, 0.01771370, 0.01812076, 0.01853236, \
0.01894849, 0.01936915, 0.01979434, 0.02022405, 0.02065828, \
0.02109702, 0.02154027, 0.02198803, 0.02244029, 0.02289705, \
0.02335829, 0.02382403, 0.02429425, 0.02476895, 0.02524813, \
0.02573178, 0.02621989, 0.02671247, 0.02720950, 0.02771098, \
0.02821692, 0.02872729, 0.02924210, 0.02976135, 0.03028502, \
0.03081312, 0.03134564, 0.03188256, 0.03242390, 0.03296964, \
0.03351978, 0.03407431, 0.03463323, 0.03519653, 0.03576421, \
0.03633626, 0.03691268, 0.03749345, 0.03807859, 0.03866807, \
0.03926189, 0.03986006, 0.04046256, 0.04106938, 0.04168053, \
0.04229600, 0.04291577, 0.04353985, 0.04416822, 0.04480089, \
0.04543785, 0.04607909, 0.04672460, 0.04737438, 0.04802842, \
0.04868672, 0.04934927, 0.05001606, 0.05068709, 0.05136235, \
0.05204183, 0.05272554, 0.05341345, 0.05410557, 0.05480189, \
0.05550241, 0.05620711, 0.05691598, 0.05762903, 0.05834625, \
0.05906762, 0.05979315, 0.06052282, 0.06125664, 0.06199458, \
0.06273665, 0.06348283, 0.06423313, 0.06498753, 0.06574602, \
0.06650861, 0.06727528, 0.06804602, 0.06882083, 0.06959970, \
0.07038262, 0.07116959, 0.07196060, 0.07275564, 0.07355470, \
0.07435778, 0.07516487, 0.07597595, 0.07679103, 0.07761010, \
0.07843314, 0.07926015, 0.08009113, 0.08092606, 0.08176493, \
0.08260774, 0.08345449, 0.08430516, 0.08515974, 0.08601823, \
0.08688061, 0.08774689, 0.08861705, 0.08949108, 0.09036898, \
0.09125074, 0.09213634, 0.09302579, 0.09391907, 0.09481617, \
0.09571709, 0.09662182, 0.09753034, 0.09844265, 0.09935875, \
0.10027862, 0.10120225, 0.10212964, 0.10306077, 0.10399565, \
0.10493425, 0.10587657, 0.10682261, 0.10777234, 0.10872577, \
0.10968289, 0.11064368, 0.11160813, 0.11257625, 0.11354801, \
0.11452341, 0.11550244, 0.11648510, 0.11747136, 0.11846123, \
0.11945469, 0.12045173, 0.12145235, 0.12245653, 0.12346427, \
0.12447555, 0.12549037, 0.12650872, 0.12753058, 0.12855595, \
0.12958482, 0.13061718, 0.13165301, 0.13269232, 0.13373508, \
0.13478129, 0.13583094, 0.13688402, 0.13794052, 0.13900043, \
0.14006374, 0.14113044, 0.14220052, 0.14327397, 0.14435077, \
0.14543093, 0.14651443, 0.14760125, 0.14869139, 0.14978484, \
0.15088159, 0.15198163, 0.15308494, 0.15419152, 0.15530136, \
0.15641444, 0.15753076, 0.15865030, 0.15977306, 0.16089902, \
0.16202818, 0.16316052, 0.16429603, 0.16543470, 0.16657652, \
0.16772148, 0.16886957, 0.17002078, 0.17117510, 0.17233251, \
0.17349301, 0.17465658, 0.17582322, 0.17699291, 0.17816564, \
0.17934140, 0.18052018, 0.18170197, 0.18288676, 0.18407454, \
0.18526528, 0.18645900, 0.18765566, 0.18885527, 0.19005781, \
0.19126326, 0.19247163, 0.19368288, 0.19489703, 0.19611404, \
0.19733392, 0.19855665, 0.19978222, 0.20101061, 0.20224182, \
0.20347584, 0.20471264, 0.20595223, 0.20719459, 0.20843970, \
0.20968756, 0.21093815, 0.21219147, 0.21344749, 0.21470622, \
0.21596763, 0.21723171, 0.21849846, 0.21976786, 0.22103990, \
0.22231456, 0.22359184, 0.22487172, 0.22615420, 0.22743925, \
0.22872687, 0.23001704, 0.23130976, 0.23260500, 0.23390277, \
0.23520304, 0.23650580, 0.23781105, 0.23911876, 0.24042893, \
0.24174155, 0.24305659, 0.24437406, 0.24569393, 0.24701620, \
0.24834085, 0.24966788, 0.25099725, 0.25232898, 0.25366303, \
0.25499941, 0.25633809, 0.25767907, 0.25902233, 0.26036786, \
0.26171564, 0.26306567, 0.26441793, 0.26577241, 0.26712909, \
0.26848797, 0.26984903, 0.27121225, 0.27257763, 0.27394515, \
0.27531480, 0.27668656, 0.27806043, 0.27943639, 0.28081443, \
0.28219453, 0.28357668, 0.28496086, 0.28634708, 0.28773530, \
0.28912553, 0.29051774, 0.29191192, 0.29330806, 0.29470615, \
0.29610617, 0.29750812, 0.29891197, 0.30031771, 0.30172533, \
0.30313482, 0.30454617, 0.30595935, 0.30737436, 0.30879119, \
0.31020981, 0.31163023, 0.31305242, 0.31447636, 0.31590206, \
0.31732949, 0.31875864, 0.32018949, 0.32162204, 0.32305627, \
0.32449217, 0.32592971, 0.32736890, 0.32880971, 0.33025214, \
0.33169616, 0.33314177, 0.33458895, 0.33603769, 0.33748797, \
0.33893978, 0.34039311, 0.34184794, 0.34330426, 0.34476206, \
0.34622131, 0.34768202, 0.34914416, 0.35060772, 0.35207269, \
0.35353905, 0.35500679, 0.35647590, 0.35794635, 0.35941815, \
0.36089127, 0.36236570, 0.36384142, 0.36531843, 0.36679670, \
0.36827623, 0.36975700, 0.37123900, 0.37272221, 0.37420662, \
0.37569221, 0.37717897, 0.37866689, 0.38015596, 0.38164615, \
0.38313745, 0.38462986, 0.38612335, 0.38761791, 0.38911354, \
0.39061020, 0.39210790, 0.39360661, 0.39510633, 0.39660703, \
0.39810871, 0.39961135, 0.40111493, 0.40261944, 0.40412487, \
0.40563120, 0.40713842, 0.40864652, 0.41015548, 0.41166528, \
0.41317591, 0.41468736, 0.41619962, 0.41771266, 0.41922648, \
0.42074106, 0.42225639, 0.42377244, 0.42528922, 0.42680670, \
0.42832487, 0.42984371, 0.43136322, 0.43288337, 0.43440415, \
0.43592555, 0.43744755, 0.43897015, 0.44049331, 0.44201704, \
0.44354132, 0.44506612, 0.44659145, 0.44811727, 0.44964359, \
0.45117037, 0.45269762, 0.45422532, 0.45575344, 0.45728198, \
0.45881093, 0.46034026, 0.46186996, 0.46340003, 0.46493044, \
0.46646118, 0.46799223, 0.46952359, 0.47105523, 0.47258715, \
0.47411932, 0.47565174, 0.47718439, 0.47871725, 0.48025031, \
0.48178356, 0.48331698, 0.48485056, 0.48638428, 0.48791813, \
0.48945209, 0.49098615, 0.49252030, 0.49405451, 0.49558879, \
0.49712310, 0.49865744, 0.50019179, 0.50172615, 0.50326048, \
0.50479479, 0.50632905, 0.50786325, 0.50939737, 0.51093141, \
0.51246535, 0.51399916, 0.51553285, 0.51706639, 0.51859977, \
0.52013297, 0.52166598, 0.52319879, 0.52473138, 0.52626374, \
0.52779585, 0.52932770, 0.53085928, 0.53239056, 0.53392154, \
0.53545220, 0.53698252, 0.53851250, 0.54004211, 0.54157135, \
0.54310019, 0.54462863, 0.54615665, 0.54768423, 0.54921137, \
0.55073804, 0.55226423, 0.55378993, 0.55531513, 0.55683980, \
0.55836394, 0.55988753, 0.56141056, 0.56293300, 0.56445486, \
0.56597610, 0.56749673, 0.56901672, 0.57053606, 0.57205474, \
0.57357274, 0.57509004, 0.57660664, 0.57812251, 0.57963766, \
0.58115205, 0.58266567, 0.58417852, 0.58569058, 0.58720182, \
0.58871225, 0.59022184, 0.59173059, 0.59323846, 0.59474546, \
0.59625157, 0.59775677, 0.59926106, 0.60076440, 0.60226680, \
0.60376823, 0.60526869, 0.60676816, 0.60826662, 0.60976406, \
0.61126047, 0.61275583, 0.61425012, 0.61574335, 0.61723548, \
0.61872651, 0.62021642, 0.62170519, 0.62319283, 0.62467930, \
0.62616460, 0.62764870, 0.62913161, 0.63061330, 0.63209377, \
0.63357298, 0.63505094, 0.63652763, 0.63800303, 0.63947714, \
0.64094992, 0.64242139, 0.64389151, 0.64536027, 0.64682767, \
0.64829368, 0.64975830, 0.65122151, 0.65268329, 0.65414364, \
0.65560253, 0.65705996, 0.65851591, 0.65997037, 0.66142332, \
0.66287475, 0.66432464, 0.66577299, 0.66721978, 0.66866499, \
0.67010862, 0.67155064, 0.67299105, 0.67442983, 0.67586696, \
0.67730244, 0.67873625, 0.68016838, 0.68159881, 0.68302753, \
0.68445453, 0.68587979, 0.68730330, 0.68872504, 0.69014501, \
0.69156319, 0.69297956, 0.69439412, 0.69580684, 0.69721773, \
0.69862675, 0.70003390, 0.70143917, 0.70284255, 0.70424401, \
0.70564355, 0.70704116, 0.70843681, 0.70983050, 0.71122221, \
0.71261194, 0.71399966, 0.71538537, 0.71676905, 0.71815069, \
0.71953028, 0.72090779, 0.72228323, 0.72365657, 0.72502781, \
0.72639693, 0.72776392, 0.72912876, 0.73049144, 0.73185196, \
0.73321029, 0.73456642, 0.73592034, 0.73727205, 0.73862152, \
0.73996874, 0.74131370, 0.74265639, 0.74399680, 0.74533490, \
0.74667070, 0.74800417, 0.74933531, 0.75066410, 0.75199053, \
0.75331459, 0.75463626, 0.75595553, 0.75727239, 0.75858684, \
0.75989884, 0.76120840, 0.76251550, 0.76382012, 0.76512226, \
0.76642191, 0.76771904, 0.76901366, 0.77030574, 0.77159528, \
0.77288226, 0.77416666, 0.77544849, 0.77672772, 0.77800435, \
0.77927836, 0.78054974, 0.78181848, 0.78308456, 0.78434798, \
0.78560872, 0.78686677, 0.78812212, 0.78937475, 0.79062466, \
0.79187184, 0.79311626, 0.79435793, 0.79559682, 0.79683293, \
0.79806624, 0.79929675, 0.80052444, 0.80174930, 0.80297131, \
0.80419048, 0.80540678, 0.80662020, 0.80783074, 0.80903837, \
0.81024310, 0.81144491, 0.81264378, 0.81383971, 0.81503268, \
0.81622269, 0.81740972, 0.81859376, 0.81977480, 0.82095282, \
0.82212783, 0.82329980, 0.82446873, 0.82563460, 0.82679741, \
0.82795713, 0.82911377, 0.83026731, 0.83141774, 0.83256505, \
0.83370923, 0.83485027, 0.83598815, 0.83712287, 0.83825441, \
0.83938277, 0.84050793, 0.84162988, 0.84274862, 0.84386413, \
0.84497641, 0.84608543, 0.84719119, 0.84829369, 0.84939290, \
0.85048883, 0.85158145, 0.85267077, 0.85375676, 0.85483942, \
0.85591874, 0.85699471, 0.85806732, 0.85913655, 0.86020240, \
0.86126486, 0.86232392, 0.86337957, 0.86443179, 0.86548059, \
0.86652594, 0.86756784, 0.86860627, 0.86964124, 0.87067273, \
0.87170072, 0.87272522, 0.87374620, 0.87476367, 0.87577760, \
0.87678800, 0.87779485, 0.87879814, 0.87979787, 0.88079401, \
0.88178658, 0.88277554, 0.88376090, 0.88474265, 0.88572078, \
0.88669527, 0.88766612, 0.88863332, 0.88959686, 0.89055674, \
0.89151293, 0.89246544, 0.89341425, 0.89435936, 0.89530075, \
0.89623842, 0.89717236, 0.89810256, 0.89902901, 0.89995170, \
0.90087063, 0.90178578, 0.90269715, 0.90360472, 0.90450850, \
0.90540846, 0.90630461, 0.90719693, 0.90808542, 0.90897006, \
0.90985086, 0.91072779, 0.91160085, 0.91247004, 0.91333535, \
0.91419676, 0.91505427, 0.91590788, 0.91675756, 0.91760333, \
0.91844516, 0.91928305, 0.92011699, 0.92094697, 0.92177299, \
0.92259504, 0.92341311, 0.92422719, 0.92503728, 0.92584337, \
0.92664544, 0.92744350, 0.92823753, 0.92902753, 0.92981349, \
0.93059540, 0.93137325, 0.93214705, 0.93291677, 0.93368242, \
0.93444398, 0.93520146, 0.93595483, 0.93670410, 0.93744926, \
0.93819029, 0.93892720, 0.93965998, 0.94038862, 0.94111311, \
0.94183344, 0.94254962, 0.94326163, 0.94396946, 0.94467311, \
0.94537258, 0.94606785, 0.94675892, 0.94744578, 0.94812843, \
0.94880686, 0.94948107, 0.95015104, 0.95081677, 0.95147826, \
0.95213549, 0.95278847, 0.95343718, 0.95408162, 0.95472179, \
0.95535768, 0.95598927, 0.95661657, 0.95723958, 0.95785827, \
0.95847266, 0.95908273, 0.95968847, 0.96028989, 0.96088697, \
0.96147971, 0.96206811, 0.96265215, 0.96323184, 0.96380716, \
0.96437812, 0.96494470, 0.96550691, 0.96606473, 0.96661817, \
0.96716721, 0.96771185, 0.96825208, 0.96878791, 0.96931932, \
0.96984631, 0.97036888, 0.97088702, 0.97140072, 0.97190998, \
0.97241480, 0.97291518, 0.97341109, 0.97390255, 0.97438955, \
0.97487208, 0.97535014, 0.97582372, 0.97629282, 0.97675744, \
0.97721757, 0.97767320, 0.97812433, 0.97857096, 0.97901309, \
0.97945070, 0.97988380, 0.98031238, 0.98073644, 0.98115597, \
0.98157097, 0.98198143, 0.98238736, 0.98278874, 0.98318557, \
0.98357786, 0.98396559, 0.98434877, 0.98472738, 0.98510143, \
0.98547091, 0.98583582, 0.98619615, 0.98655191, 0.98690308, \
0.98724967, 0.98759167, 0.98792908, 0.98826189, 0.98859011, \
0.98891372, 0.98923273, 0.98954713, 0.98985693, 0.99016211, \
0.99046267, 0.99075862, 0.99104994, 0.99133664, 0.99161871, \
0.99189616, 0.99216897, 0.99243715, 0.99270068, 0.99295958, \
0.99321384, 0.99346345, 0.99370842, 0.99394874, 0.99418440, \
0.99441541, 0.99464177, 0.99486347, 0.99508050, 0.99529288, \
0.99550059, 0.99570363, 0.99590201, 0.99609572, 0.99628475, \
0.99646912, 0.99664880, 0.99682381, 0.99699414, 0.99715979, \
0.99732076, 0.99747705, 0.99762865, 0.99777556, 0.99791779, \
0.99805533, 0.99818818, 0.99831634, 0.99843980, 0.99855857, \
0.99867265, 0.99878203, 0.99888671, 0.99898669, 0.99908198, \
0.99917256, 0.99925845, 0.99933963, 0.99941611, 0.99948789, \
0.99955497, 0.99961734, 0.99967500, 0.99972796, 0.99977622, \
0.99981976, 0.99985860, 0.99989274, 0.99992216, 0.99994688, \
0.99996689, 0.99998220, 0.99999279, 0.99999868, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, \
1.00000000, 1.00000000, 1.00000000, } 


 #endif // _FPU_FFT_TUKEY_H_
//=============================================================================
// End of File
//=============================================================================

