% **************************************************************************************************
%   Filename:       CapSense.m
%   Revised:        $Date: 2011-07-23 $
%   Revision:       $Revision:  $
% 
%   Description:    Main file for CapSense Visualize GUI
% 
% 
%   Copyright 2009-2010 Texas Instruments Incorporated. All rights reserved.
% 
%   IMPORTANT: Your use of this Software is limited to those specific rights
%   granted under the terms of a software license agreement between the user
%   who downloaded the software, his/her employer (which must be your employer)
%   and Texas Instruments Incorporated (the "License").  You may not use this
%   Software unless you agree to abide by the terms of the License. The License
%   limits your use, and you acknowledge, that the Software may not be modified,
%   copied or distributed unless embedded on a Texas Instruments microcontroller
%   or used solely and exclusively in conjunction with a Texas Instruments radio
%   frequency transceiver, which is integrated into your product.  Other than for
%   the foregoing purpose, you may not use, reproduce, copy, prepare derivative
%   works of, modify, distribute, perform, display or sell this Software and/or
%   its documentation for any purpose.
% 
%   YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
%   PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
%   INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
%   NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
%   TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
%   NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
%   LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
%   INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
%   OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
%   OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
%   (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
% 
%   Should you have any questions regarding your right to use this Software,
%   contact Texas Instruments Incorporated at www.TI.com.
% **************************************************************************************************

function varargout = CapSense(varargin)
% CAPSENSE MATLAB code for CapSense.fig
%      CAPSENSE, by itself, creates a new CAPSENSE or raises the existing
%      singleton*.
%
%      H = CAPSENSE returns the handle to a new CAPSENSE or the handle to
%      the existing singleton*.
%
%      CAPSENSE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CAPSENSE.M with the given input arguments.
%
%      CAPSENSE('Property','Value',...) creates a new CAPSENSE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before CapSense_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to CapSense_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help CapSense

% Last Modified by GUIDE v2.5 23-Jul-2011 19:23:54

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @CapSense_OpeningFcn, ...
                   'gui_OutputFcn',  @CapSense_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT
end

% --- Executes just before CapSense is made visible.
function CapSense_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to CapSense (see VARARGIN)

addpath(genpath('GUI_callbacks'));
addpath(genpath('helpers'));
% Choose default command line output for CapSense
handles.output = hObject;

%Create data handler
handles.dh = dataHandler(handles);

axes_handles = {handles.axes1;...
                handles.axes2;...
                handles.axes3;...
                handles.axes4;...
                handles.axes5};

line_colors = {'b' 'g' 'r' 'k' 'm'};            
% loop over plots
handles.plots = cell(length(axes_handles),length(line_colors));
for( n = length(axes_handles):-1:1 )
    % Set tick direction
    set(axes_handles{n}, 'XDir', 'reverse');
    % Loop over lines
    for( m = 1:1:length(line_colors) )
        set( handles.figure1, 'CurrentAxes', axes_handles{n} );
        title(['Button ' num2str(n-1)]);
        handles.plots{n,m} = line([0 1],[0 0] , 'Color', line_colors{m});
    end
end
hLegend = legend('Raw data', 'Mean value', 'Stats threshold', 'Touch threshold', 'Variance', 'Location', 'NorthOutside');
set( hLegend, 'units', 'pixels' );
set( hLegend, 'position', [500 800 160 80] );
% Update handles structure
guidata(hObject, handles);
end

% --- Outputs from this function are returned to the command line.
function varargout = CapSense_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
end

% --- Executes during object creation, after setting all properties.
function edit_COMPort_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_COMPort (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end

% --------------------------------------------------------------------
function menu_data_Callback(hObject, eventdata, handles)
% hObject    handle to menu_data (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end



function edit_COMPort_Callback(hObject, eventdata, handles)
% hObject    handle to edit_COMPort (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_COMPort as text
%        str2double(get(hObject,'String')) returns contents of edit_COMPort as a double
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
deletePorts();
delete(hObject);
end

% --- Executes during object creation, after setting all properties.
function edit_history_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_history (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end

% --- Executes during object creation, after setting all properties.
function edit_statThres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_statThres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end

% --- Executes during object creation, after setting all properties.
function edit_touchThres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_touchThres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function edit_baudRate_Callback(hObject, eventdata, handles)
% hObject    handle to edit_baudRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_baudRate as text
%        str2double(get(hObject,'String')) returns contents of edit_baudRate as a double
end

% --- Executes during object creation, after setting all properties.
function edit_baudRate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_baudRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end

% --- Executes during object creation, after setting all properties.
function edit_varMultiplier_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_varMultiplier (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end
