/*
 * communicate.h
 *
 *  Created on: Mar 21, 2013
 *      Author: a0283087
 */

#ifndef COM_H_
#define COM_H_

#define CMD_CHK_STATE 0x83
#define CMD_RD_CARD	0x81

#define ACK_OK 0x90
#define ACK_CH_ALL  0x91

//min and max no. of characters in a card
//As some cards may only have some characters
//less than max number a track can physically has,
//but it should still be valid
#define T2_MIN_LEN 16
#define T3_MIN_LEN 16
#define T2_MAX_LEN 40
#define T3_MAX_LEN 108

void com_sendAck(unsigned char cmd, unsigned char len, unsigned char *buf);
void com_sendAck2(unsigned char cmd, unsigned char len1, unsigned char *buf1,
		unsigned char len2, unsigned char *buf2);
static void com_sendLength(unsigned char len);
static void com_sendCommand(unsigned char cmd);
static void com_sendData(unsigned char *buf, unsigned char len);
static void com_sendBit(unsigned int time);
void com_sendIdle(unsigned int bit_len);
void com_startSend(void);
//void com_init(unsigned char mclk,unsigned char smclk);
void com_init();
static void com_send_0(void);
static void com_send_1(void);
void com_parseCommand(unsigned char cmd, unsigned char len);
void com_recvCommand(void);
unsigned char com_detectCommand(void);
unsigned char com_readPinAdc(void);
static void com_get_baseline(void);
void com_init_baseline(void);



#endif /* COM_H_ */
