************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : JULY 1999
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
    .OPTIONS search='./'
***********************************************************************
* DEVICE NETLIST
***********************************************************************
X_DEVICE_SELECTOR  0 CBTLV16212INC


***********************************************************************
*ENCRYPTED PROCESS MODEL. PLEASE CHOOSE ONLY ONE 
*PROCESS MODEL FILE (NOMINAL, STRONG or WEAK)
***********************************************************************

        X_PROCESS_SELECTOR 0 ASL3C_BSIM3_NINC   $NOMINAL LEVEL 49 PROCESS MODEL 
*       X_PROCESS_SELECTOR 0 ASL3C_BSIM3_SINC   $STRONG  LEVEL 49 PROCESS MODEL
*       X_PROCESS_SELECTOR 0 ASL3C_BSIM3_WINC   $WEAK    LEVEL 49 PROCESS MODEL

*PACKAGE FILE. PLEASE CHOOSE ONLY ONE PACKAGE FILE and change the 
*corresponding subcircuit connection. For example change TSSOP56_01 to
* TVSOP56_01
***********************************************************************

.INCLUDE  'TSSOP56.PKG'
*.INCLUDE 'TVSOP56.PKG'
*.INCLUDE 'SSOP48.PKG'


***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************

xCBTLV16212 
+x_s0
+x_s1
+x_s2
+x_1A1
+x_1B1
+x_1A2
+x_1B2
+x_CGND
+x_CVCC

+CBTLV16212

***********************************************************************
******Supply Voltages
***********************************************************************
v_vcc     x_CVCC      0     DC     5
v_gnd     x_CGND      0     DC     0

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.subckt CBTLV16212 
+p_s0
+p_s1
+p_s2
+p_1A1
+p_1B1
+p_1A2
+p_1B2
+p_CGND
+p_CVCC

X_PIN_1		p_s0		s0	TSSOP56_01
X_PIN_2		p_1a1		s_1a1	TSSOP56_02
X_PIN_3		p_1a2		s_1a2	TSSOP56_03
X_PIN_8		p_CGND		CGND	TSSOP56_08
X_PIN_17	p_CVCC		CVCC	TSSOP56_17
X_PIN_53	p_1B2		s_1b2	TSSOP56_53
X_PIN_54 	p_1B1		s_1b1	TSSOP56_54
X_PIN_55 	p_s2		s2	TSSOP56_55
X_PIN_56 	p_s1		s1	TSSOP56_56


X_CBTLV16212_die s0 s1 s2 s_1a1 s_1b1 s_1a2 s_1b2 CVCC CGND cbtlv16212__bit

 
.ENDS CBTLV16212 

***********************************************************************

.TRAN         1NS 100NS

** 1A1--> 1B1,1A2-->1B2 DATA TRANSFER




R_LOAD_1B1   x_1B1    0   500
C_LOAD_1B1   x_1B1    0   50pF

R_LOAD_1B2   x_1B2    0   500
C_LOAD_1B2   x_1B2    0   50pF

    
V_1A1      	x_1A1      0 PULSE (0 5  5NS  1NS  1NS  30NS  60NS)
V_1A2      	x_1A2      0 PULSE (0 5  5NS  1NS  1NS  10NS  30NS)

V_S0 		x_s0 	   0 DC 0
V_S1 		x_s1 	   0 DC 5
V_S2 		x_s2 	   0 DC 5

 
.PRINT TRAN V(x_1B1)



.END
                                         




