************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 2003, (C) Copyright 2003, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : 10/22/2003


*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
    .OPTIONS search='./'
***********************************************************************
***********************************************************************
* DEVICE NETLIST
X_DEVICE  0 CBT3125CINC 


*PROCESS_MODELS

X_PROCESS  0 ASL3C5_RW_NOM_BSIM3INC   $NOMINAL PROCESS MODEL (BSIM3) 
*X_PROCESS 0 ASL3C5_RW_STRONG_BSIM3INC $STRONG  PROCESS MODEL (BSIM3) 
*X_PROCESS 0 ASL3C5_RW_WEAK_BSIM3INC    $WEAK    PROCESS MODEL (BSIM3) 



** RESISTOR MODELS*

.INCLUDE 'nominal_resistor.out'
*.INCLUDE 'strong_resistor.out'
*.INCLUDE 'weak_resistor.out'



***********************************************************************
*PACKAGE FILE. PLEASE CHOOSE ONLY ONE PACKAGE FILE
***********************************************************************



.INCLUDE 'TSSOP14.PKG'
*.INCLUDE 'TVSOP14.PKG'
*.INCLUDE 'SSOP16.PKG'
*.INCLUDE 'SOIC16.PKG'
*.INCLUDE 'SOP16.PKG'




***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xCBT3125c x_1A x_1B x_2A x_2B x_3A x_3B x_4A x_4B  x_1NOE x_2NOE x_3NOE x_4NOE CGND CVCC  CBT3125C

***********************************************************************
******Supply Voltages
***********************************************************************
v_vcc     cvcc      0     DC     5
v_gnd     cgnd      0     DC     0

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT CBT3125C 
+s_1A s_1B s_2A s_2B s_3A s_3B s_4A s_4B  s_1NOE s_2NOE s_3NOE s_4NOE s_CGND s_CVCC		
					
x_PIN1  s_1NOE 	p_1NOE	TSSOP14_01
x_PIN2  s_1A  	p_1A    TSSOP14_02
x_PIN3  s_1B   	p_1B	TSSOP14_03
x_PIN4  s_2NOE  p_2NOE	TSSOP14_04
x_PIN5  s_2A   	p_2A	TSSOP14_05
x_PIN6  s_2B  	p_2B    TSSOP14_06
x_PIN7  s_CGND 	CGND  TSSOP14_07
x_PIN8  s_3B   	p_3B	TSSOP14_08
x_PIN9  s_3A   	p_3A	TSSOP14_09
x_PIN10 s_3NOE 	p_3NOE  TSSOP14_10
x_PIN11 s_4B 	p_4B    TSSOP14_11
x_PIN12 s_4A	p_4A    TSSOP14_12
x_PIN13 s_4NOE  p_4NOE  TSSOP14_13
x_PIN14 s_CVCC  CVCC   TSSOP14_14



X_cbt3125c_die  
+p_1A p_1B p_2A p_2B p_3A p_3B p_4A p_4B  p_1NOE p_2NOE p_3NOE p_4NOE CGND CVCC cbt3125c__bit
.ENDS CBT3125C 

***********************************************************************

.TRAN         1NS 10NS

VNOE1     x_1NOE  CGND DC 0
VNOE2     x_2NOE  CGND DC 5
VNOE3     x_3NOE  CGND DC 5
VNOE4     x_4NOE  CGND DC 5

Vx_1A x_1A CGND PULSE (0  5  5NS  1NS  1NS  10NS  20NS)

Rx_2A x_2A CGND 10Meg
Rx_3A x_3A CGND 10Meg
Rx_4A x_4A CGND 10Meg


 

Rx_1B x_1B CGND 10Meg
Rx_2B x_2B CGND 10Meg
Rx_3B x_3B CGND 10Meg
Rx_4B x_4B CGND 10Meg




.PRINT TRAN V(B1)
.alter
VNOE1     x_1NOE  CGND DC 5
VNOE2     x_2NOE  CGND DC 5
VNOE3     x_3NOE  CGND DC 5
VNOE4     x_4NOE  CGND DC 5


.END
                                         




