
****************************************************************************
***************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized      * 
*          reproduction and/or distribution is strictly prohibited.       *
*                                                                         * 
*          This product is protected under copyright law.                 *  
*          Created 1999, (C) Copyright 1999, Texas Instruments Inc.,      *  
*          All Rights Reserved                                            *  
*                                                                         *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE             *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR          *
*          IMPLIED.  TI assumes no liability for:                         *
*          1) the accuracy of the SPICE models provided to your           *
*             company;                                                    *
*          2) the proper functioning of these SPICE models in your        *
*             design or for any resulting applications; or                *
*          3) infringement of patents, copyrights or intellectual         *
*             property rights resulting from your use of these            *
*             SPICE models.                                               *
*                                                                         *
*          TI provides SPICE Models as a service to our customers.        *
*          You and your company shall not distribute, sell or give        *
*          these models to anyone else without prior written              *
*          permission from TI.                                            *
*                                                                         *
*          TI reserves the right to make changes to our products or 	  *
*          to discontinue any semiconductor product or service            *
*          without notice, and advises our customers to obtain the 	  *
*          latest version of relevant information to verify, before       *
*          placing orders, that the information being relied on is 	  *
*          current.                                                       *
*                                                                         *
*          Please be aware that your receipt and use of the SPICE 	  *
*          information provided shall serve as acceptance of these 	  *
*          terms and conditions.  If you do not accept these terms,	  *
*          you should return or destroy the SPICE models and any          *
*          other accompanying information immediately.			  *
***************************************************************************
***************************************************************************



************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
*************************************************************************
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
***********************************************************************
	.OPTIONS search='./'


***ENCRYPTED DEVICE NETLIST*****


X_DEVICE_SELECTOR 0 GTLP1394INC


*PROCESS MODELS
*ASL3C5N37INC  ENCRYPTED  NOMINAL PROCESS MODEL
*ASL3C5S37INC  ENCRYPTED  STRONG PROCESS MODEL
*ASL3C5W37INC  ENCRYPTED  WEAK PROCESS MODEL

****PLEASE INCLUDE ONE OF THE FOLLOWING PROCESS**

X_PROCESS_MODELS  0   ASL3C5N37INC
*X_PROCESS_MODELS  0   ASL3C5S37INC
*X_PROCESS_MODELS  0   ASL3C5W37INC

*PKG MODEL****


.LIB  'PKGS.LIB'  TSSOP16



***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
****	    	A1  B1  Y1 NOEBY  NOEAB NERC TNC  BIASCVCC VREF  CVCC CGND

xgtlp1394  

+A1
+B1
+Y1  
+A2
+B2
+Y2 
+NOEBY
+NOEAB
+NERC  
+TNC  
+BIASCVCC  
+VREF  
+CVCC
+CGND13
+CGND15
+CGND11

+gtlp1394

*****SUBCKT for pkg connection*****
.subckt gtlp1394 
+p_A1
+p_B1
+p_Y1  
+p_A2
+p_B2
+p_Y2 
+p_NOEBY
+p_NOEAB
+p_NERC  
+p_TNC  
+p_BIASCVCC  
+p_REF  
+p_CVCC
+p_CGND13
+p_CGND15
+p_CGND11

  



X_PIN01  p_NOEBY	NOEBY  	TSSOP16_01
X_PIN02	 p_Y1		Y1		TSSOP16_02
X_PIN03	 p_Y2		Y2		TSSOP16_03

X_PIN04	 p_CVCC	        CVCC		TSSOP16_04
X_PIN05	 p_A1 	        A1		TSSOP16_05
X_PIN06	 p_A2 	        A2		TSSOP16_06

X_PIN07  p_NOEAB	NOEAB 		TSSOP16_07
X_PIN08  p_NERC	        NERC		TSSOP16_08
X_PIN09  p_TNC 		TNC		TSSOP16_09
X_PIN10  p_REF		VREF 		TSSOP16_10
X_PIN11  p_CGND11	CGND	        TSSOP16_11
X_PIN12  p_B2  	        B2 		TSSOP16_12
X_PIN13  p_CGND13	CGND	        TSSOP16_13
X_PIN14  p_B1  	        B1 		TSSOP16_14
X_PIN15  p_CGND15  	CGND 		TSSOP16_15

X_PIN16	 p_BIASCVCC	BIASVCC  	TSSOP16_16

xgtlp1394_bit

+A1 
+B1 
+Y1 
+A2 
+B2 
+Y2 
+NOEAB
+NOEBY
+TNC 
+VREF 
+NERC 
+BIASVCC 
+CVCC 
+CGND

 
+gtlp1394_bit

.ENDS gtlp1394


******************
**PARAMETER
*******************
.temp 40



**********************
**A  DATA TO B BUS*****
***********************


**UNUSED INPUT AND OUTPUT***

Va2  A2  0  DC 3.3 
Vb2  B2  0  DC 3.3
Vy2  Y2  0 DC  3.3
Vy1  Y1  0 DC 3.3



***CONTROL INPUT FOR A TO B DATA FLOW***

VTNC 	 	TNC 	  0  	dc 3.3v	
VNOEBY	 	NOEBY 	  0 	dc 3.3v		
VNERC		NERC	  0 	dc 3.3v
VNOEAB  	NOEAB 	  0	dc 0v
VBIASVCC 	BIASCVCC  0	dc 3.3v
VVREF   		VREF 	  0 	dc 1v
 
***********************************************************************
******Supply Voltages
***********************************************************************
Vcvcc	CVCC  		0  dc 3.3v  
Vcgnd13	CGND13		0  dc 0v
Vcgnd15	CGND15		0  dc 0v
Vcgnd11	CGND11		0  dc 0v


***********************************************************************
******Termination Voltages
***********************************************************************

V_tt        tt   0  dc 1.5v	

************************************************************************
***********************************************************************
.TRAN         0.05NS 30NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

v_a         A1    0   PULSE (0  3.3   5NS  1NS  1NS  10NS  20NS)


******LOAD CKT FOR B OUTPUT***
******


C_B_load  B1  0  30pF

R_tt  B1  tt  12.5 




.END


