******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74ALVC162835
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2006, (C) COPYRIGHT 2006, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74alvc162835.inc'
X__SN74ALVC162835 NC NC Y1 GND Y2 Y3 VCC Y4 Y5 Y6 GND Y7 Y8 Y9 Y10 Y11 Y12
+ GND Y13 Y14 Y15 VCC Y16 Y17 GND Y18 NOE LE GND CLK A18 GND A17 A16 VCC A15
+ A14 A13 GND A12 A11 A10 A9 A8 A7 GND A6 A5 A4 VCC A3 A2 GND A1 NC GND
+ SN74ALVC162835
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT='PVCC/2' $ input threshold voltage
.param PMAX=0ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+160ns' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 CLK 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 8ns 20ns
VI1 A1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 18ns 40ns
VI2 LE 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 38ns 80ns
VI3 NOE 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 78ns 160ns


* CHANGE TO THE OUTPUT NODE
VDATA Y1 DATA DC 0
RLOAD DATA VCC 500
CLOAD DATA VCC 50pF

* VOLTAGE SUPPLIES

.param PVCC=3.3
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 NC 0 1G
R1G_2 NC 0 1G
* R1G_3 Y1 0 1G
* R1G_4 GND 0 1G
R1G_5 Y2 0 1G
R1G_6 Y3 0 1G
* R1G_7 VCC 0 1G
R1G_8 Y4 0 1G
R1G_9 Y5 0 1G
R1G_10 Y6 0 1G
* R1G_11 GND 0 1G
R1G_12 Y7 0 1G
R1G_13 Y8 0 1G
R1G_14 Y9 0 1G
R1G_15 Y10 0 1G
R1G_16 Y11 0 1G
R1G_17 Y12 0 1G
* R1G_18 GND 0 1G
R1G_19 Y13 0 1G
R1G_20 Y14 0 1G
R1G_21 Y15 0 1G
* R1G_22 VCC 0 1G
R1G_23 Y16 0 1G
R1G_24 Y17 0 1G
* R1G_25 GND 0 1G
R1G_26 Y18 0 1G
* R1G_27 NOE 0 1G
* R1G_28 LE 0 1G
* R1G_29 GND 0 1G
R1G_30 CLK 0 1G
R1G_31 A18 0 1G
* R1G_32 GND 0 1G
R1G_33 A17 0 1G
R1G_34 A16 0 1G
* R1G_35 VCC 0 1G
R1G_36 A15 0 1G
R1G_37 A14 0 1G
R1G_38 A13 0 1G
* R1G_39 GND 0 1G
R1G_40 A12 0 1G
R1G_41 A11 0 1G
R1G_42 A10 0 1G
R1G_43 A9 0 1G
R1G_44 A8 0 1G
R1G_45 A7 0 1G
* R1G_46 GND 0 1G
R1G_47 A6 0 1G
R1G_48 A5 0 1G
R1G_49 A4 0 1G
* R1G_50 VCC 0 1G
R1G_51 A3 0 1G
R1G_52 A2 0 1G
* R1G_53 GND 0 1G
* R1G_54 A1 0 1G
R1G_55 NC 0 1G
* R1G_56 GND 0 1G

.END
