*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers makeno warranties, either expressed
** or implied, with respect to thismodel, including the warranties of
** merchantability or fitness fora particular purpose. The model is
** provided solely on an "as is" basis. The entirerisk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:        SN75DP126
*              
* Date:        2011-06-08
* Model Type:  HSPICE
* Simulator:   HSPICE_A-2008.03-SP1 Windows
* 
*****************************************************************************
* Model version 1.0:
*****************************************************************************
******** circuit definition
*subckt DP126_TOP_highspeed_model_schematic in0p in0n in1p in1n in2n in2p in3p in3n
*+      vddd gnd src sda_ctl_pre en_vrega_dnbond tmds_clkn tmds_clkp tmds_out0n
*+      tmds_out0p tmds_out1n tmds_out1p tmds_out2n tmds_out2p dp_out3n dp_out3p 
*+      dp_out2n dp_out2p dp_out1n dp_out1p dp_out0n dp_out0p vsadj tmds_hpd_sink
*+      cad_sink dp_hpd_sink vcc enable vdda
*.ends
****************************************************************************

* General information about this model:

* Only for DP and TMDS high speed path only.
* Schematic based with some parasitics estimations. 
* Does not have package parasitics. 
* Squelch is bypassed.
* All logic subchips are taken out; no link training possible; HPD/CAD input only.
* DP port TX in TMDS mode only offers a single VOD, no PE. Some more VOD/PE settings
* allowed in actual design.
* AUX path is taken out.


* DP126SS vs DS:

* For SS: Do not connect EN_VREGA(D)_DNBND pins (internal schematic pins)
* For DS: connect EN_VREGA(D)_DNBND pins to ground


* Following parameters to setup highspeed input differetial data:

* delay                 may be set to ~10nS
* Vid                   Input VID
* ER                    Edge rate
* UI                    Bit period

* Following parameters to setup DP126:

* en_lane0,1,2,3        Enables lanes
* eq2,1,0               RX Equalization: 000=0dB, 111:18dB at 2.7Ghz
* vod1,0                TX VOD in DP mode; 00 L0, 01 L1, 10 L2 11 L3
* pe1,0                 TX Pre-emphasis in DP mode; 00 L0, 01 L1, 10 L2 11 L3
*                       note certain PE/VOD combinations not allowed
* dr1,0                 Datarate in DP mode; 00 1.6G, 01 2.7G, 10 5.4Gbps

* TMDS TX can be programmed for VOD by changing resistor at VSADJ pin according
* datasheet. PE can be changed by SDA_CTL_PRE according to datasheet as well.
* There is option available in the actual device to change PE for TMDS TX through
* I2C, but not available in this model.

****************************************************************************
* The simulation takes 50 min to complete
****************************************************************************
.WIDTH OUT=80

.PARAM dp_en=1
.PARAM vid=1
.PARAM delay=5e-9
.PARAM vcc_3p3v=3.3
.PARAM vcc=1.05
.PARAM en_lane0=1
.PARAM en_lane1=1
.PARAM en_lane2=1
.PARAM en_lane3=1
***************
.PARAM ui=185e-12
.PARAM er=70e-12
****************

.PARAM dr0=0
.PARAM dr1=1
.PARAM pe0=0
.PARAM pe1=0
.PARAM vod0=0
.PARAM vod1=0
.PARAM eq0=0
.PARAM eq1=0
.PARAM eq2=0
.PARAM ohms=0


.PROBE TRAN
+    V(outn1)
+    V(outp1)
+    V(net0272)
+    V(net0274)
+    V(inn3)
+    V(inp3)
+    V(inn2)
+    V(inp2)
+    V(inn1)
+    V(inp1)
+    V(vcm)
+    V(inn0)
+    V(inp0)
+    V(out3)
+    V(out2)
+    V(out1)
+    V(out0)
.TRAN 50e-12 50e-9 START=10e-9

.OP

.TEMP 25
.OPTION ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTION METHOD=GEAR

.INCLUDE "DP126_nom_process_enc.lib"

.INCLUDE "DP126_subckts_enc.sp"


**********************************************************
.subckt source_for_AC_coupling_PRBS outn outp vcm
v1 net3 0 DC=0 AC 0 0 PULSE vid '-vid' delay 'er/600e-3' 'er/600e-3' 'ui-er/600e-3' '2*ui'
v2 net11 0 PWL 0 0 delay 0 'delay+100e-12' 1 1 1 TD=0
e3 net027 0 VCVS 0 net028 1
e1 outp vcm VCVS net028 0 1
e2 outn vcm VCVS net027 0 1
e0 net028 net027 VCVS POLY(2) net3 0 net11 0  0  0  0  0  1
.ends source_for_AC_coupling_PRBS
**********************************************************

xi107 net0212 net0411 vcm source_for_AC_coupling_PRBS
xi123 net0412 net0410 vcm source_for_AC_coupling_PRBS
xi122 net0209 net0413 vcm source_for_AC_coupling_PRBS
xi99  net0206 net0207 vcm source_for_AC_coupling_PRBS


xi131 inp0 inn0 inp1 inn1 inn2 inp2 inp3 inn3 vddd gnd gnd 0 _net0 tmds_clkn tmds_clkp tmds_out0n tmds_out0p tmds_out1n tmds_out1p tmds_out2n tmds_out2p outn3_pin outp3_pin outn2_pin outp2_pin outn1_pin outp1_pin outn0_pin outp0_pin net0121 tmds_en n1 dp_en v3p3 n1 vdda DP126_TOP_highspeed_model_schematic
r21   net0311	 net0410    50
r20   net0219	 net0412    50
r15   net0272	 net0206    50
r14   net0274	 net0207    50
r19   net0228	 net0209    50
r18   net0225	 net0413    50
r17   net0319	 net0411    50
r16   net0231	 net0212    50


c34   net0311	 inp3	    10e-9 IC=0
c33   net0219	 inn3	    10e-9 IC=0
c32   net0272	 inn1	    10e-9 IC=0
c31   net0274	 inp1	    10e-9 IC=0
c40   net0228	 inn2	    10e-9 IC=0
c39   net0225	 inp2	    10e-9 IC=0
c0    net0319	 inp0	    10e-9 IC=0
c11   net0231	 inn0	    10e-9 IC=0

e5    vcm  0 VCVS net0142 0     1
e2    out2 0 VCVS outp2   outn2 1
e3    out3 0 VCVS outp3   outn3 1
e0    out0 0 VCVS outp0   outn0 1
e1    out1 0 VCVS outp1   outn1 1
c1    vdda       net119     1e-9
c2    gnd        net117     1e-9
c47   tmds_out1n tmds_out1p 500e-15
c48   tmds_out0n tmds_out0p 500e-15
c49   tmds_clkn  tmds_clkp  500e-15
c30   tmds_out2n tmds_out2p 500e-15

c9    outp0_pin  outp0      100e-9
c8    outn0_pin  outn0      100e-9
c15   outp1_pin  outp1      100e-9
c14   outn1_pin  outn1      100e-9
c19   outp2_pin  outp2      100e-9
c18   outn2_pin  outn2      100e-9
c16   outp3_pin  outp3      100e-9
c17   outn3_pin  outn3      100e-9

c35   vddd       0          1e-6
c25   outn2_pin  gnd        1e-12
c24   outp2_pin  gnd        1e-12
c23   outp3_pin  gnd        1e-12
c22   outn3_pin  gnd        1e-12
c20   outp1_pin  gnd        1e-12
c21   outn1_pin  gnd        1e-12
c13   outp0_pin  gnd        1e-12
c12   outn0_pin  gnd        1e-12
r24   net0142    vddd       11e3
r46   tmds_out1p v3p3       50
r47   tmds_out1n v3p3       50
r30   net0121    gnd        4.7e3
r48   tmds_out0n v3p3       50
r49   tmds_out0p v3p3       50
r50   tmds_clkp  v3p3       50
r51   tmds_clkn  v3p3       50
r22   tmds_out2p v3p3       50
r23   tmds_out2n v3p3       50
r11   outn2      gnd        50
r5    outp3      gnd        50
r10   outp0      gnd        50
r9    outn0      gnd        50
r4    outn3      gnd        50
r3    outn1      gnd        50
r2    outp1      gnd        50
r8    outp2      gnd        50


r25   net0142    0          30e3
r13   net117     gnd        4e-3
r12   net119     vdda       4e-3
v18   dp_en      0          DC='3.3*dp_en'
v19   tmds_en    0          DC='3.3*(1-dp_en)'
v23   _net0      0          DC=0
v25   vddd       0          DC=vcc
v16   gnd        0          DC=0
v29   n1         0          DC=vcc
v17   v3p3       0          DC=vcc_3p3v
v1    net117     0          DC=0
v0    net119     0          DC=vcc
.END
