//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//***********************************************************************************
// App Extern Globals                                                               *
//***********************************************************************************
extern int Frequency[5];
extern int AccelRate, DesiredStepperSpeed;
extern int tmpAccelTimeBase, AccelTimeBase;
extern int AccelerateState;
extern int StepsToMove;
extern bool MoveSteps;
//***********************************************************************************
// Firmware Revision                                                                *
//***********************************************************************************
#define     FIRMWARE_REVISION   1
//***********************************************************************************
// Application Specific Hardware Definitions                                        *
//***********************************************************************************
#define     StatusLEDPin    0x20
#define     SPI_MISO    (0x04)      //PORT5.2 //DataIN
#define     SPI_MOSI    (0x02)      //PORT5.1 //Data_AB
#define     SPI_CLK     (0x08)      //PORT5.3
#define     SLAVE_SEL   (0x01)      //PORT5.0

#define     P1OUT_INIT  0
#define     P2OUT_INIT  0
#define     P3OUT_INIT  0
#define     P4OUT_INIT  0
#define     P5OUT_INIT  SLAVE_SEL
#define     P6OUT_INIT  0

//***********************************************************************************
// Application Specific Definitions                                                 *
//***********************************************************************************
#define     OPCODE      SerialBuffer[0]
#define     I2C_LENGTH  SerialBuffer[1]
#define     I2C_ADDR    SerialBuffer[2]
#define     I2C_SUBA    SerialBuffer[3]
#define     I2C_DATA    SerialBuffer[4]

#define     NOACC       0
#define     ACCEL       1
#define     DECEL       2
#define     STOP        3

//***********************************************************************************
// Application Specific Opcodes                                                     *
//***********************************************************************************
#define     GPIO_DIR        0x02
#define     WRITE_GPIO      0x03
#define     READ_GPIO       0x04
#define     DAC0_UPDATE     0x05
#define     DAC1_UPDATE     0x06
#define     TMP0            0x07
#define     READ_ADC        0x08
#define     TMP1            0x09
#define     TMP2            0x0A
#define     ENABLE_PWM      0x0B
#define     DISABLE_PWM     0x0C
#define     UPDATE_PWM      0x0D
#define     SET_TMR_OUT     0x0E
#define     PULSE_TMR       0x0F
#define     FREQ_TMR        0x10
#define     FREQ_TMR_STOP   0x11
#define     START_STEPPER   0x12
#define     STOP_STEPPER    0x13
#define     STEPPER_SPEED   0x14
#define     MOVE_STEPS      0x15

//Memory Access Opcodes
#define     READ_MEM        0xE0
#define     WRITE_WMEM      0xE1
#define     WRITE_BMEM      0xE2

// System Opcodes
#define     GET_FW_REV      0xF0
#define     RESET_MCU       0xF1
#define     SHOW_CLKS       0xF2

//***********************************************************************************
// Application Specific Externs                                                     *
//***********************************************************************************

extern char StatusLED;
