//***************************************************************************
//
// File:        buffman.h
//
// Description: This file contains definitions for buffer management.
//
// Author:      Anne Kelley
//
// Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
// Portions also copyright 1996, 1997, Alpha Omega Computer Systems, Inc.
// All rights reserved worldwide
//
//***************************************************************************

#ifndef BUFFMAN_H
#define BUFFMAN_H

#include "port.h"
#include "common.h"
#ifdef WIN31COMPAT
#include "intern31.h"
#else
#include "internal.h"
#endif

#define BufSize     (2048 + 4 + 2)      // Maximum packet size:  allow 4 for CRC and 2 for Irlap header
#define NumTxBlocks 8                   // Number of blocks for transmission
#define NumRxBlocks 8                   // Number of blocks for receive.
#define NumPool     (NumTxBlocks + NumRxBlocks + 1)   // Number of blocks in the data pool

typedef struct buffer {
  struct buffer *next;
  struct bufQueueStruct *ownedBy;   // Debug -- remembers who owns it for safety
  U8            *buf;       // Points to data
	int						lastFrame;  // Non-zero if the packet is the last packet in the set.
  U32           numbBytes;  // Number of data bytes
  U32           length;     // Length of buffer
  void          *dev;       // device owning buffer
	int						status;			// carries status
	unsigned long timerStart;      // !! Uses to time packets through system
	unsigned long timerEnd;        // !! more of same
} Buffer;

typedef struct bufQueueStruct{
  Buffer        * head;
  Buffer        * tail;
} BufQueue;


Buffer *   RemoveBuf(BufQueue *pQueue);
void       AppendBuf(BufQueue *pQueue, Buffer *buf);
void       InitBuf (BufQueue *pQueue, Buffer buf[], U8 *data, 
                    int nBuffers, void *dev);

#endif