//***************************************************************************
//
// File:        common.c
//
// Description: This file contains the code for functions that would normally 
// be in the standard C libraries which we're not supposed to use.
//
// Author:      Anne Kelley
//
// Copyright 1996, 1997 Counterpoint Systems Foundry, Inc.
// Portions also copyright 1996, 1997, Alpha Omega Computer Systems, Inc.
// All rights reserved worldwide
//
//***************************************************************************
#define WANTVXDWRAPS

#include <basedef.h>                             
#include <vmm.h>
#include <vcomm.h>
//#include "port.h"
#include "common.h"

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

//
// xstrtol
//
// This should be a library routine but "powers that be" don't want to use
// stdio/stdlib things inside a vxd.  Bleh and double bleh!
//
long
xstrtol(char *buf, char **nextp, int radix)
{
	long					value = 0;

	while ((*buf == ' ') || (*buf == '\t'))
		++buf;				// Skip over leading spaces

  if (radix == 0)
	{
		if ((buf[0] == '0') && ((buf[1] == 'x') || (buf[1] == 'X')))
		{
			radix = 16;
			buf += 2;
		}
		else
		if (buf[0] == '0')
		{
			radix = 8;
			++buf;
		}
		else
			radix = 10;
	}


	switch (radix)
	{
		case 16:	// extract a hex value
			{
				if ((buf[0] == '0') && ((buf[1] == 'x') || (buf[1] == 'X')))
				{
					radix = 16;
					buf += 2;
				}
				while (((*buf >= '0') && (*buf <= '9')) ||
							 ((*buf >= 'a') && (*buf <= 'f')) ||
							 ((*buf >= 'A') && (*buf <= 'F')))
				{
					value = value * 16;
					if (*buf <= '9')
						value += *buf - '0';
					else
					if (*buf <= 'F')
						value += *buf - 'A' + 10;
					else
						value += *buf - 'a' + 10;
					++buf;
				}

				break;
			}

		case 10:	// extract an decimal number
			{
				while ((*buf >= '0') && (*buf <= '9'))
				{
					value = value * 10 + *buf - '0';
					++buf;
				}
				break;
			}

		case 8:		// extract an octal number
			{
				while ((*buf >= '0') && (*buf <= '7'))
				{
					value = value * 8 + *buf - '0';
					++buf;
				}

				break;
			}
	}

	if (nextp != NULL)
		*nextp = buf;

	return (value);
}

int
xstrlen(char *str)
{
  int   len = 0;

  while (*str++ != 0)
    ++len;

  return (len);
}

char *
xstrchr(char *str, char ch)
{
  while ((*str != ch) && (*str != '\0'))
    ++str;

  return ((*str == ch) ? str : NULL);
}

void
xmemset(char *buf, char val, int len)
{
  while (len-- != 0)
    *buf++ = val;
}



//****************************************************************************
//  memCopy
//    This function will copy the number of bytes from the src to the 
//    destination.  If the number of bytes is 0 nothing will be copied.
//
//  Inputs:   The destination for the data to be copied.
//            The data source.
//            The number of bytes to copy.
//  Outputs:  The number of bytes copied.
//

UINT memCopy(PVOID dest, PVOID src, UINT numBytes)
{
  UINT i = numBytes;

  for (; i > 0; i--)
    *((PU8)dest)++ = *((PU8)src)++;

  return(numBytes);
}

//*********************************************************
//* atoI
//* Converts an ASCII string to a hexadecimal number
//*
//* Inputs:
//*   str:  string to convert
//* Outputs:
//*   number:  the result of the conversion
//*********************************************************

U32 atoI (char *string)
{
  U32 number;
  int count;

  number = 0;
  count = 0;
  while (string[count] != 0)
  {
    if ((string[count] >= '0') && (string[count] <= '9'))
      number = number * 16 + ((int)string[count] - 48);
    else if ((string[count] >= 'A') && (string[count] <= 'F'))
      number = number * 16 + ((int)string[count] - 55);
    else if ((string[count] >= 'a') && (string[count] <= 'f'))
      number = number * 16 + ((int)string[count] - 87);
    count++;
  }
  return (number);
}

