//***************************************************************************
//
// File:        common.h
//
// Description: This file contains the definitions for the standard functions.
//
// Author:      Anne Kelley
//
// Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
// Portions also copyright 1996, 1997, Alpha Omega Computer Systems, Inc.
// All rights reserved worldwide
//
//***************************************************************************
#ifndef common_h
#define common_h

#include "port.h"
#ifdef WIN31COMPAT
#include "intern31.h"
#else
#include "internal.h"
#endif

#define  LoU16(dw)         ((U16)(dw))
#define  HiU16(dw)         ((U16)((U32)(dw) >> 16) )
typedef S16           STATUS, *P_STATUS;


VOID vpicdPhysEOI                 ( void );
void outportb                     ( U32, U8 );
U8  inportb                       ( U32 );
void vpicdForceDefaultBehavior    ( void );
BOOL InitSpeedLo                  (PPortInformation hPort);
void DeInitSpeedLo                (PPortInformation hPort);

U32 atoI (char *string);
long xstrtol(char *buf, char **nextp, int radix);
int xstrlen(char *str);
char * xstrchr(char *str, char ch);
void xmemset(char *buf, char val, int len);

UINT memCopy(PVOID dest, PVOID src, UINT numBytes);

#endif