;***************************************************************************
;
; File:        dma.asm
;
; Description: This file contains the code for dma and other input/output functions.
;
; Author:      Anne Kelley
;
; Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
; Portions also copyright 1996, 1997, Alpha Omega Computer Systems, Inc.
; All rights reserved worldwide
;
;***************************************************************************

; Includes and equates


.386p

.XLIST

INCLUDE VMM.Inc
INCLUDE VPICD.INC
INCLUDE VDMAD.INC
INCLUDE Debug.Inc
INCLUDE vtd.inc
.LIST


;NonPageable Data

VxD_LOCKED_DATA_SEG
opFlags			dd    0
copyPageBuf     db 4 dup (0)
VxD_LOCKED_DATA_ENDS


VxD_LOCKED_CODE_SEG
; Nonpageable code
;   


;*************************************************************************
;  U16 vdmadGetVersion (void);
;  Gets the version number of the DMA virtual device.
;
;  Returns the DMA version in eax.
;*************************************************************************

BeginProc _vdmadGetVersion, PUBLIC, NO_LOG

push  ecx
    VxdCall VDMAD_Get_Version
    pop   ecx
    ret
EndProc _vdmadGetVersion




;******************************************************************************
; U32 vdmadVirtualizeChannel ( U32 );
; Virtualizes the DMA channel
;
; Inputs:   The DMA channel to virtualize.
; Outputs:  Returns -1 in eax if the channel is already owned, otherwise 
;	          returns the DMA handle in eax.
;******************************************************************************

BeginProc vdmadVirtualizeChannel, CCALL, PUBLIC

ArgVar	  channelNum, DWORD

    EnterProc
    push      esi
    push      edi
    push      ebx

    mov       eax,channelNum
    mov       esi, 0
    VxdCall   VDMAD_Virtualize_Channel
	
    jnc       short @F
    mov       eax, -1

@@:
    pop       ebx
    pop       edi
    pop       esi
    LeaveProc
    return

EndProc vdmadVirtualizeChannel


;************************************************************************
; BOOL UnVirtualizeDMAChannel ( U32 );
; Releases ownership of the DMA channel.
;
; Inputs:   The DMA channel to be released.
; Outputs:  Returns FALSE (0) if unsuccessful. 
;************************************************************************

BeginProc UnVirtualizeDMAChannel, CCALL, PUBLIC

ArgVar DMAHandle, DWORD

    EnterProc
    push      esi
    push      edi
    push      ebx

    mov       eax, DMAHandle
    mov       esi, 0
    VxdCall   VDMAD_Unvirtualize_Channel
		
    jc        short @F
    mov       eax, 1
	  jmp       ExitUnvirtualize
@@:
    xor       eax, eax

ExitUnvirtualize:

    pop       ebx
    pop       edi
    pop       esi
    LeaveProc
    return
EndProc UnVirtualizeDMAChannel





;************************************************************************
;   U8  inportb ( U32 );
;   Reads a byte of data from the port.
;
;   Inputs:   Address of port to read.
;   Outputs:  Byte of data read.
;************************************************************************

BeginProc _inportb, PUBLIC, NO_LOG
    port      equ [ebp+8]
    push      ebp
    mov       ebp,esp
    push      edx
    xor       eax, eax
    mov       edx, port
    in        al,dx
    pop       edx
    pop       ebp
    ret
EndProc _inportb






;************************************************************************
;   void outportb ( U32, U8 );
;   Writes a byte of data to a port
;
;   Inputs:   Address of port to write data.
;             Byte of data to write.
;   Outputs:  None
;************************************************************************

BeginProc _outportb, PUBLIC, NO_LOG
    port    equ [ebp +8]
    value   equ [ebp+12]
    push    ebp
    mov     ebp,esp
		push	  eax
		push	  edx
		mov     dx, word ptr port
		mov     al, value
		out     dx,al
		pop		  edx
		pop		  eax
    pop     ebp
    ret
EndProc _outportb




;************************************************************************
;   U32 LinToPhysAddress ( U32 );
;   Calculates the physical address from the linear address.
;
;   Inputs:   Linear address
;   Outputs:  Physical address
;************************************************************************

BeginProc _LinToPhysAddress , PUBLIC, NO_LOG
    linAddress equ [ebp+8]
    push    ebp
    mov     ebp, esp
    push    ebx


    mov     eax, linAddress
    shr     eax, 12

    VMMCall _CopyPageTable, <eax, 1, < OFFSET32 copyPageBuf> , 0>
    cmp     ax, 0
    jnz     short @F

IFDEF DEBUG
    mov     eax, linAddress
ENDIF
    jmp     short page_error

@@:
    mov     ebx, linAddress
    mov     eax, dword ptr copyPageBuf
    and     eax, 0FFFFF000h
    and     ebx, 0FFFh
    add     eax, ebx

page_error:
    pop     ebx
    pop     ebp
    ret
EndProc _LinToPhysAddress


IFDEF WIN31COMPAT

;*****************************************************************************
;
; PU8 _stdcall Get_Profile_String(PU8 section, PU8 keyName, PU8 default)

_section$ = 8
_keyName$ = 12
_default$ = 16

 public _Get_Profile_String@12

_Get_Profile_String@12 PROC NEAR 

    push    ebp
    mov     ebp, esp
    push    ebx
    push    esi
    push    edi

    mov     esi, DWORD PTR _section$[ebp]
    mov     edi, DWORD PTR _keyName$[ebp]
    mov     edx, DWORD PTR _default$[ebp]

    VMMcall Get_Profile_String

    jc      @f                      ; carry set if entry not found
    mov     eax, edx                ; address of profile string
    jmp     Get_Profile_String_End

@@:
    mov     eax, DWORD PTR _default$[ebp]

Get_Profile_String_End:
	cld
    pop     edi
    pop     esi
    pop     ebx
    leave
    ret     12					; 0000000cH

_Get_Profile_String@12  ENDP




;******************************************************************************
; U32 Page_Allocate ( U32, U32, U32, U32 );
; Virtualizes the DMA channel
;
; Inputs:   Number of pages to allocate
;			pointer to the 4byte buffer to receive the physical address
;			memory block handle
;			linear address
;******************************************************************************

BeginProc _Page_Allocate, CCALL, PUBLIC

ArgVar		numbPages, DWORD
ArgVar		physAddr, DWORD
ArgVar		handle, DWORD
ArgVar		linAddr, DWORD



    EnterProc
    push      esi
    push      edi
    push      ebx
	push	  edx
	push	  ecx

	mov		  eax, PAGECONTIG
	or		  eax, PAGELOCKED
	or		  eax, PAGEUSEALIGN
	or		  eax, PAGEFIXED
	or		  eax, PAGEZEROINIT
	mov		  opFlags, eax

ifdef debug
	Trace_Out "eax = #EAX"
	Trace_Out "edx = #EDX"
endif

	VMMcall _PageAllocate, <numbPages, PG_SYS, 0, 0FH, 0, 0FFFH, physAddr, opFlags>

ifdef debug
	Trace_Out "eax = #EAX"
	Trace_Out "edx = #EDX"
endif

	mov		ecx, eax
	or		ecx, edx
	jz		endalloc

ifdef debug
	Trace_Out "no error"
endif

	mov		ecx, handle
	mov		dword ptr [ecx], eax
	mov		ecx, linAddr
	mov		dword ptr [ecx], edx

endalloc:

	pop	      ecx
	pop		  edx
    pop       ebx
    pop       edi
    pop       esi
    LeaveProc
    return

EndProc _Page_Allocate
ENDIF



;*********************************************************
; U32 GetTimerValue (void)
; Returns the lower 32 bits of the timer value
;*********************************************************

BeginProc _GetTimerValue, PUBLIC, NO_LOG
    push    ebp
    mov     ebp, esp
    push    ebx

	VxDCall	VTD_Get_Real_Time

    pop     ebx
    pop     ebp
    ret
EndProc _GetTimerValue

;******************************************************************************
; U32 GetIrqStatus ( U32 );
; Gets status of IRQ
;
; Inputs:   IRQ 
; Outputs:  Status
;******************************************************************************

BeginProc GetIrqStatus, CCALL, PUBLIC

ArgVar		IRQ, DWORD

    EnterProc

    mov       eax, IRQ
    xor       ecx, ecx

	VxDcall  VPICD_Get_IRQ_Complete_Status

    mov     eax, ecx

    LeaveProc
    return

EndProc GetIrqStatus


VxD_LOCKED_CODE_ENDS

END
