//***************************************************************************
//
// File:        dma.h
//
// Description: This file contains the definitions for the DMA controller routines
//
// Author:      Anne Kelley
//
// Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
// Portions also copyright 1996, 1997, Alpha Omega Computer Systems, Inc.
// All rights reserved worldwide
//
//***************************************************************************
#ifndef _dma37_h
#define _dma37_h

#include "port.h"
#include "common.h"
#ifdef WIN31COMPAT
#include "intern31.h"
#else
#include "internal.h"
#endif
#include "hsdriver.h"

extern U8    *MemAddress;         // Base address of DMA memory space     

#define maxBufferLength (2048 + 2)  // Total frame size (info field size + 
                                    // Irlap header

// Constants used for allocating memory

#define PageSize            4096
#define MinPageSize         4095

// bit definitions.

#define  bit0               (0x01)
#define  bit1               (0x02)
#define  bit2               (0x04)
#define  bit3               (0x08)
#define  bit4               (0x10)
#define  bit5               (0x20)
#define  bit6               (0x40)
#define  bit7               (0x80)
#define  bit8		            (0x100)
#define  bit9		            (0x200)
#define  bit10		          (0x400)
#define	 bit11		          (0x800)
#define  bit12		          (0x1000)
#define  bit13		          (0x2000)
#define  bit14		          (0x4000)
#define  bit15		          (0x8000)

/* definition of registers */
/* all registers are write registers; some are read/write, as indicated */

#define RegIRPortLo         0x105
#define RegIRPortHi         0x106
#define RegDMASetup         0x107
#define CURR_ADDR_0         0x00		/* R/W */
#define CURR_ADDR_1         0x02		/* R/W */
#define CURR_ADDR_2         0x04		/* R/W */
#define CURR_ADDR_3         0x06		/* R/W */

#define WORD_COUNT_0        0x01		/* R/W */
#define WORD_COUNT_1        0x03		/* R/W */
#define WORD_COUNT_2        0x05		/* R/W */
#define WORD_COUNT_3        0x07		/* R/W */

// 8237A registers

#define CMD_REGISTER        0x08		/* R/W */   // write
#define STATUS_REGISTER     0x08		/* R/W */   // read

#define REQ_REGISTER        0x09
#define S_R_MASK_BITS       0x0A    // set/reset mask register.

#define SET_MASK_BIT        0x04
#define RESET_MASK_BIT      0x00

#define MODE_REGISTER       0x0B

#define SINGLE_WRITE        0x44  // Write transfer, Autoinitialization disable,
                                  // Address increment select, single mode select 
#define SINGLE_READ         0x48  // Write transfer, Autoinitialization disable,
                                  // Address increment select, single mode select
#define BLOCK_WRITE         0x84  // Write transfer, Autoinitialization disable,
                                  // Address increment select, block mode select
#define BLOCK_READ          0x88  // Write transfer, Autoinitialization disable,
                                  // Address increment select, block mode select
#define DEMAND_WRITE        0x04  // Write transfer, Autoinitialization disable,
                                  // Address increment select, demand mode select
#define DEMAND_READ         0x08  // Read transfer, Autoinitialization disable,
                                  // Address increment select, demand mode select

#define CLEAR_BYTE_FF       0x0C  // Clear byte pointer flip/flop
#define MASTER_CLEAR        0x0D		/* R/W */
						/* same as hard reset */
#define TEMP_REGISTER       0x0D		// R/W, read temporary register

#define CLEAR_MASK_BITS     0x0E  // Clear mask register
#define WRITE_MASK_BITS     0x0F  // write all mask register bits.

#define DMA_CH0             3
#define DMA_CH1             1

#define VPICD_Opt_Can_Share              0x02

// end 8237A registers

#define IN_RR0    ((U8)inportb(IrPortInfo.IR_Base + CHANNEL_A_ADDRESS + 1))
#define INTR_FLAG 0x200

#define  EnterCritical( s ) {         \
   _asm  push eax                     \
   _asm  pushfd                       \
   _asm  cli                          \
   _asm  pop    eax                   \
   _asm  mov    WORD PTR s,ax         \
   _asm  pop  eax}  
       

#define  ExitCritical( s )             \
         if (s & INTR_FLAG) { _asm {sti} }

#define  enableInterrupts( s ) {         \
   _asm  push eax                     \
   _asm  pushfd                       \
   _asm  sti                          \
   _asm  pop    eax                   \
   _asm  mov    WORD PTR s,ax         \
   _asm  pop  eax}  
       

#define  disableInterrupts( s )             \
         if (~(s&INTR_FLAG)){ _asm {cli} }


void DisableDMA(U32 ChannelNum);

void NotifyFramer(PPortInformation hPort, U32 eventMask);

U16 vdmadGetVersion (void);

U16 InitDMAXfer (U32  ChannelNum, U32 Mode, char *BufferAddr, U32  BufferSize);
void StartDMAXfer(U32 ChannelNum);
extern U32  LinToPhysAddress        ( U32  );
U32  vdmadVirtualizeChannel (U32);
BOOL UnVirtualizeDMAChannel (U32);
U16  Virtualize  (HSControl *HSControlData);
U16 NumbBytesRemaining (U32 ChannelNum);
U32 GetIrqStatus ( U32 );

#ifdef DEBUG
void DbgPrint(char *afmt, ...);
#define DebugPrint(arg) DbgPrint arg
#else
#define DebugPrint(arg)
#endif

#endif /* _dma37_h */
