#ifndef __INTERNAL_H
#define __INTERNAL_H


/***************************************************************************
 *
 * File:          intern31.h
 *
 * Description:   This file contains definitions used by the C
 *                portion of fastser (Fast version of serial)
 *
 * Author:        David W. Suvak
 *
 * Created:       December 27, 1995
 * Copyright 1996, Alpha Omega Computer Systems, Inc.
 * Copyright 1996, Counterpoint Systems Foundry, Inc.
 * All rights reserved worldwide
 *
 ****************************************************************************/

#include "port.h"

typedef struct
{
   PortData  pData;             // port data: has to be first
  _DCB      DCB;                // DCB : device control block

  DWORD     DEBId;
  DWORD     Port;               // Base I/O Address
  DWORD     NotifyHandle;
  DWORD     NotifyFlags;
  DWORD     ReadNotifyHandle;
  DWORD     ReadNotifyRefData;
  DWORD     WriteNotifyHandle;
  DWORD     WriteNotifyRefData;
  DWORD     RecvTrigger;        // -1 char count threshold for calling
  DWORD     SendTrigger;        // char count threshold for calling

  // The following fields are specific to com ports only

  DWORD     XOffPoint;          // Q count where XOff is sent
  DWORD     EvtMask;            // Mask of events to check for
  DWORD    *AddrEvtDWord;       // address of Event flags
  DWORD     AddrMSRShadow;      // addr of Modem Status Register Shadow
  U8        EFlags;             // Extended flags
  U8        ErrorMask;          // Default error-checking mask
  U8        RxMask;             // Character mask
  U8        ImmedChar;          // Char to be transmitted immediately
  U8        HSFlag;             // Handshake flag
  U8        HHSLines;           // 8250 DTR/RTS bits for handshaking
  U8        OutHHSLines;        // Lines that must be high to output
  U8        MSRMask;            // Mask of Modem Lines to check
  U8        MSRInfinite;        // Mask of MSR lines that must be high
  U8        IntVecNum;          // Interrupt vector number
  U8        LSRShadow;          // Line Status Register shadow
  DWORD     QOutMod;            // characters sent mod xOnLim ENQ/ETX 
  DWORD     VCD_data;
  U8        VCDflags;
  DWORD     IRQHandle;          // irq's handle
  DWORD     ReferenceData;      // reference data of enablenotification
  U8        MiscFlags;          // still more flags
  U8        IRQn;               // Which irq
  DWORD     MyIRQStruc;         // IRQ struc for me
  DWORD     OwnerVM;            // Owner for this port
  DWORD     OwnerThread;        // Owner thread
  U8        RxFifoTrigger;      // what is the RxTrigger ?
  U8        Filler;             // Filler

  U8        IR_Flags;           // Flags for Fast IR ** NEW **
  U8        IR_BOFs;            // Number of BOFs to send ** NEW **
  U8        IR_Pad1;            // Pad to make DWORD  ** NEW **
  U8        IR_Pad2;            // Pad to make DWORD  ** NEW **

#ifdef  DEBUG
  DWORD ArtificialErr;          // How many Due to Buffer full ETC.
  DWORD ParityErrors;           // parity error
  DWORD OverrunErrors;          // overrun errors
  DWORD FramingErrors;          // framing errors
  DWORD NumDataInts;            // How many data avail interrupts
#endif

  void     *HSControlBlock;    // High speed control block pointer.
  U8        FCRdata;            // data that gets written to the FIFO control register

} PortInformation, *PPortInformation;



// IR_Flags

#define IR_FLAGS_ENABLED 0x01 // Indicates if non transparency is enabled
#define IR_FLAGS_IR_PORT 0x02 // Indicates if this port is for IR


#ifdef DEBUG
void DbgPrint(char *afmt, ...);
#define DebugPrint(arg) DbgPrint arg
#else
#define DebugPrint(arg)
#endif

#endif // __INTERNAL_H
