;****************************************************************************
;
; File:        irasm.asm
;
; Description: This file contains code written in assembly for the fast IR
;              serial driver.
;
; Author:      David Suvak 
;
; Created:     December 29, 1995
;
; Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
; All rights reserved worldwide
;



PAGE 58,132
;******************************************************************************
TITLE CONTROL - ControlDispatch for IrLapFrm VxD in C
;******************************************************************************
;

   .386p


	.xlist
	include	VMM.INC
	include	VPICD.INC
	include	VCOMM.INC
	include	DEBUG.INC
	include	OPTTEST.INC
	include	INTERNAL.INC
	include	INS8250.INC
	include	vdmad.inc

	include vtd.inc        ; Get_Real_Time service comes from this
	.list


VxD_My_Pageable_Code_Seg

      EXTRN   Notify_Owner:NEAR
      EXTRN   StrCmp:Near

VxD_My_Pageable_Code_Ends



VxD_Locked_Data_Seg

      Serial_IRQ_Desc	VPICD_IRQ_Descriptor <0>
      EXTRN	  SysVMHandle:DWORD
      EXTRN	  Serial_IRQHandler:BYTE
      EXTRN	  PortInfoHandle:DWORD

VxD_Locked_Data_Ends



VxD_Locked_Code_Seg




;******************************************************************************
; BOOL StrCmpPort(PPortInformation hPort, char *portName)
; Determines if portName is the name of the port.
;
; Inputs:   Port information structure
;           Port name
; Outputs:  Returns TRUE if portName is name of the port.
;******************************************************************************

BeginProc StrCmpPort, CCALL, PUBLIC

ArgVar  hPort,DWORD
ArgVar  portName,DWORD

  EnterProc
  push	esi
  push	edi
  push	ebx

  mov   eax, hPort
  mov   esi, 1
  mov   edi, portName
  call  StrCmp
  jz    SCP_Success
  xor   eax,eax
  jmp   SCP_Done
SCP_Success:
  mov   eax,1
SCP_Done:
  pop	  ebx
  pop	  edi
  pop	  esi
  LeaveProc
  return

EndProc StrCmpPort


;******************************************************************************
; BOOL InitSpeedLo (PPortInformation hPort);
; Initializes the low speed port.
;
; Inputs:   The port information structure.
; Outputs:  Returns TRUE if initialization successful.
; Uses:     eax, flags, edx, cl
;******************************************************************************

BeginProc InitSpeedLo, CCALL, PUBLIC

ArgVar    hPort,DWORD

  EnterProc
  push	  esi
  push	  edi
  push	  ebx

  mov     esi,hPort
  mov	    edx, [esi.MyIRQStruc]	; IRQ Struc for this port
  movzx	  eax,[esi.IRQn]
  mov	    edi, OFFSET32 Serial_IRQ_Desc   ; fill out IRQ_Number etc.
  mov	    [edi.VID_IRQ_Number],ax
  mov	    [edi.VID_Hw_Int_Proc],OFFSET32 Serial_IRQHandler
  mov	    [edi.VID_Options],(VPICD_Opt_Can_Share OR VPICD_OPT_REF_DATA)
  mov	    [edi.VID_Hw_Int_Ref],edx        ; reference data
  VxDCall	VPICD_Virtualize_IRQ
  jc	    InitSpeedLoFail

  mov	    edx, [esi.MyIRQStruc]	          ; IRQ Struc for this port
  mov	    [edx.PIStruc], esi              ; save PortInfoStruc
  mov	    [esi.IRQHandle],eax	            ; save handle
  mov	    [edx.MyIRQHandle], eax          ; save for next virtualizer.
;  inc	    [edx.VirtCnt]                  ; increment the virt count
  mov	    ebx,[SysVMHandle]
  VxDCall	VPICD_Get_Complete_Status
  and	    cl,VPICD_STAT_PHYS_MASK	        ; just remember if physically masked
  mov	    [edx.OldMask],cl
  mov	    eax, 1
  jmp	    Exit_InitLo

InitSpeedLoFail:
  xor     eax, eax

Exit_InitLo:
  pop	    ebx
  pop	    edi
  pop	    esi
  LeaveProc
  return

EndProc InitSpeedLo


;******************************************************************************
; void DeInitSpeedLo (PPortInformation hPort);
; Turns off the low speed port.
;
; Inputs:   The port information structure.
; Outputs:  None
; Uses:     eax
;******************************************************************************

BeginProc DeInitSpeedLo, CCALL, PUBLIC

ArgVar    hPort,DWORD

  EnterProc
  push    esi
  push    edi
  push    ebx

  mov     esi, hPort
  mov     eax, [esi.IRQHandle]
IFDEF DEBUG
  Trace_Out "IRQ is #EAX"
ENDIF
  VxDCall VPICD_Force_Default_Behavior

  pop     ebx
  pop     edi
  pop     esi

  LeaveProc
  return

EndProc DeInitSpeedLo


;******************************************************************************
; void NotifyFramer(PPortInformation hPort, U32 eventMask)
; Notifies the framer of an event.
;
; Inputs:   The port information structure..
;           The event mask.
; Outputs:  None
; Uses:     eax  
;******************************************************************************

BeginProc NotifyFramer, CCALL, PUBLIC

ArgVar    hPort,DWORD
ArgVar    eventMask,DWORD

  EnterProc
  push    esi
  push    edi
  push    ebx
  push    eax           ; added, but probably don't need it.       

  mov     esi,hPort
  mov     eax,[esi.EvtMask]       ; Get the event mask
  mov     ebx,[esi.AddrEvtDWord]  ; Get address of the event dword
  and     eax,[ebx]               ; Get only user specified bits
IFDEF DEBUG
;  Trace_Out "notifyframer - evt = #EAX"
ENDIF
  mov     dword ptr [ebx],eax	    ; Set the event dword
  mov     ebx,eventMask           ; Get the original value of the event dword
IFDEF DEBUG
;  Trace_Out "notifyframer - original evt = #EBX"
ENDIF

IFDEF DEBUG
;  push      eax
;  Trace_Out "SERIAL:  NotifyFramer Old event = #ebx, New event = #eax"
;  pop       eax
ENDIF


  ; See if the Framer is ready to receive events.
  test    [esi.NotifyFlagsHI],CN_Notify   ; debugged
  jz      NotifyFramer_Exit               ; debugged

; Only call the framer if new events have occurred

  not     ebx   ; debugged
  and     eax,ebx             ; debugged      ; Bits set in ax are new events
  jz      NotifyFramer_Exit   ; debugged     ; No new event

  mov	    eax,CN_EVENT              
IFDEF DEBUG
;  push      eax
;  Trace_Out "SERIAL:  Just before notify_owner called"
;  pop       eax
ENDIF

  call    notify_owner            ; Call the Framer callback function

NotifyFramer_Exit:
  pop     eax             ; added, but probably don't need it.
  pop     ebx
  pop     edi
  pop     esi
  LeaveProc
  return

EndProc NotifyFramer



ifdef DEBUG

;************************************************************************
; DbgPrint is defined in DbgPrint.c in this case.
;************************************************************************

  
_VMM_Out_Debug_String PROC NEAR PUBLIC
  push    esi
  mov     esi, [esp].8
  VMMcall Out_Debug_String
  pop     esi
  ret
_VMM_Out_Debug_String ENDP



;************************************************************************
; VOID VMM_Out_Debug_Code_Label(PVOID Address)
; Outputs a flat pointer as a symbolic label
; Uses eax, dx
;
;************************************************************************

_VMM_Out_Debug_Code_Label PROC NEAR PUBLIC
  mov       eax, [esp].4
	mov	      dx, cs
	Trace_Out	"?DX:EAX", nocrlf
  ret
_VMM_Out_Debug_Code_Label ENDP



;************************************************************************
; VOID VMM_Out_Debug_Data_Label(PVOID Address)
; Outputs a flat pointer as a symbolic label
; Uses eax, dx
;************************************************************************

_VMM_Out_Debug_Data_Label PROC NEAR PUBLIC
  mov       eax, [esp].4
	mov	      dx, ds
	Trace_Out	"?DX:EAX", nocrlf
  ret
_VMM_Out_Debug_Data_Label ENDP

endif

;************************************************************************
; unsigned long GetRealTime()
;************************************************************************
BeginProc GetRealTime, CCALL, PUBLIC
  VxDcall VTD_Get_Real_Time
  ret
EndProc GetRealTime

VxD_Locked_Code_Ends

  end
