#define WANTVXDWRAPS

#include <vxdwraps.h>                                           
#include <basedef.h>
#include <vmm.h>
#include <vcomm.h>
#include <debug.h>
#include "port.h"
#ifdef WIN31COMPAT
#include "intern31.h"
#else
#include "internal.h"
#endif
#include <..\common.h>
#include "irdaprnt.h"
// #include "vardef.h"

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

#ifndef WIN31COMPAT
  #ifdef  DEBUG
    void    DebugPrintf(char *Format, ...);
    #define VPRINTF(args) DebugPrintf args
  #else   // Release
    #define VPRINTF(args)
  #endif  // Release
#else   // WIN31COMPAT
  #ifdef DEBUG
    void DbgPrint(char *afmt, ...);
    #define DebugPrint(arg) DbgPrint arg
    #define VPRINTF(arg) DbgPrint arg
  #else //release
    #define DebugPrint(arg)
    #define VPRINTF(arg)
  #endif //release
#endif  // WIN31COMPAT

//* used for printing debug info.

static char *
putNum(char *buf, int num)
{
  *buf++ = (num / 100) + '0';
  *buf++ = (num / 10) % 10 + '0';
  *buf++ = (num % 10) + '0';
  *buf   = '\0';
  return (buf);
}

static char
toHex(int val)
{
  if (val > 9)
    return (val - 10 + 'A');
  else
    return (val + '0');
}

static char *
putHex(char *buf, int num)
{
  *buf++ = toHex((num >> 4) & 0x0F);
  *buf++ = toHex(num & 0x0F);
  *buf   = '\0';
  return (buf);
}

static char *
catStr(char *buf, char *str)
{
  while (*str)
    *buf++ = *str++;

  *buf = '\0';

  return (buf);
}

char *
decodeIrda(char *buf)
{
	char				codev[10];
	static char msg[20];
	char *			code;
  char *      p;

	p = putNum(msg, (buf[0]> 1) & 0x7F);
  *p++ = ' ';
	*p++ = (buf[0] & 1) ? 'C' : 'R';
  *p++ = ',';
	*p++ = ' ';

	if ((buf[1] & 1) == 0)
	{
		// I frame
		p = catStr(p, "I, Ns=");
		*p++ = ((buf[1] >> 1) & 7) + '0';
		p = catStr(p, ", Nr=");
		*p++ = ((buf[1] >> 5) & 7) + '0';
	}
	else
	if (buf[1] & 0x2)
	{
		// U frame
		switch (buf[1] & 0xEF)
		{
		case 0x83:	code = (buf[0] & 1) ? "SNRM" : "RNRM";					break;
		case 0x43:	code = (buf[0] & 1) ? "DISC" : "RD";						break;
		case 0x03:	code = "UI";																		break;
		case 0x2F:	code = "XID";																		break;
		case 0xE3:	code = "TEST";																	break;
		case 0x63:	code = "UA";																		break;
		case 0x87:	code = "FRMR";																	break;
		case 0x0F:	code = "DM";																		break;
		case 0xAF:	code = "XID";																		break;

		default:		putHex(codev, buf[1]); code = codev;						break;
		}
	p = catStr(p, code);
	}
	else
	{
		// S frame
		switch (buf[1] & 0x0F)
		{
		case 0x01:	p = catStr(p, "RR");														break;
		case 0x04:	p = catStr(p, "RNR");														break;
		case 0x09:	p = catStr(p, "REJ");														break;
		case 0x0B:	p = catStr(p, "SREJ");													break;

		default:		p = putHex(p, buf[1]);													break;
		}
		p = catStr(p, ", Nr=");
		*p++ = ((buf[1] >> 5) & 7) + '0';
	}

	if (buf[1] & 0x10)
	{
		p = catStr(p, ", ");
		*p++ = (buf[0] & 1) ? 'P' : 'F';
	}
	*p = '\0';

	return (msg);
}

