;****************************************************************************
;
; File:        irq.asm
;
; Description: This file contains code written in assembly for the fast IR
;              serial driver.
;
; Author:      Anne Kelley 
;
; Created:     December 29, 1995
;
; Copyright 1996, 1997, Counterpoint Systems Foundry, Inc.
; All rights reserved worldwide
;


; Includes and equates


.386p

.XLIST

INCLUDE VMM.Inc
INCLUDE Debug.Inc
INCLUDE VPICD.Inc
.LIST

VxD_LOCKED_DATA_SEG
IrLAP_IRQ_Ini	      db "IrLAPIRQ",0
IrLAP_Grab_Irq      db "IrLAPGrabIrq",0
client_reg_struct   db (Client_Alt_GS + 4) DUP (0)
copyPageBuf         db 4 dup (0)
hspIntEnabled       dw 0
hIRQValue           dd 0
VxD_LOCKED_DATA_ENDS

;EXTRN ourInterruptEnabled:WORD
PUBLIC hspIntEnabled
PUBLIC hIRQValue

VxD_LOCKED_CODE_SEG

extrn _HSInterrupt:NEAR
extrn _TIIntProcPIO:NEAR


;****************************************************************************
; void  VIRLAPD_EoiProc ( void )
; Clears the interrupt request line.
;
; Inputs:   None
; Outputs:  None
;****************************************************************************

BeginProc _VIRLAPD_EoiProc, PUBLIC, NO_LOG
    push    eax
    push    ebx
    VxdCall VPICD_Clear_Int_Request
    pop     ebx
    pop     eax
    VxdCall VPICD_Phys_EOI

    ret
EndProc  _VIRLAPD_EoiProc



;****************************************************************************
; void  VIRLAPD_IretProc  ( void );
;****************************************************************************

BeginProc _VIRLAPD_IretProc, PUBLIC, NO_LOG
    push    eax
    push    ebx
    VxdCall VPICD_Test_Phys_Request
    pop     ebx
    pop     eax
    jnc     short @F

    VxdJmp  VPICD_Set_Int_Request
@@:
    ret
EndProc  _VIRLAPD_IretProc


IF 01
;****************************************************************************
;   void VIRLAPD_HwIntProcDMA ( void );
;   hardware interrupt  callback routine for DMA mode
;
;   carry flag cleared upon return
;****************************************************************************

BeginProc _VIRLAPD_HwIntProcDMA, PUBLIC, NO_LOG
;;    test word ptr ourInterruptEnabled, 1
;;    jz short passItToNextHandler
    cld
	  pushad
    cCall   _HSInterrupt
	  popad
    clc
    jmp     short doneWithThat


passIt:
    mov     eax, hIRQValue
    VxdCall VPICD_Set_Int_Request

    VxdCall VPICD_Phys_EOI
    jmp     short doneWithThat

passItToNextHandler:
    stc


doneWithThat:
    ret
EndProc  _VIRLAPD_HwIntProcDMA

ENDIF



;****************************************************************************
;   void VIRLAPD_HwIntProcPIO ( void );
;   hardware interrupt  callback routine for PIO (TI)
;
;   carry flag cleared upon return
;****************************************************************************

BeginProc _VIRLAPD_HwIntProcPIO, PUBLIC, NO_LOG
;;    test word ptr ourInterruptEnabled, 1
;;    jz short passItToNextHandler
    cld
	  pushad
    cCall   _TIIntProcPIO
	  popad
    clc
    jmp     short doneWithThatPIO


passIt1_152:
    mov     eax, hIRQValue
    VxdCall VPICD_Set_Int_Request

    VxdCall VPICD_Phys_EOI
    jmp     short doneWithThatPIO

passItToNextHandlerPIO:
    stc


doneWithThatPIO:
    ret
EndProc  _VIRLAPD_HwIntProcPIO




;****************************************************************************
; U16 vpicdVirtualizeIRQ (PCOMD_IRQ_Descriptor)
; DESCRIPTION: virtualizes the com port
;
; Inputs:   PDWORD PCOMD_IRQ_Descriptor
;           Pointer to the VCOMD_IRQ_Descriptor structure
; Outputs:  U16    1   for success
;           U16    0   for failure
;****************************************************************************

BeginProc _vpicdVirtualizeIRQ, PUBLIC, NO_LOG

    PVCOMD_IRQ_Descriptor equ [ebp+8]

    push    ebp
    mov     ebp,esp
    push    edi

    mov     eax, hIRQValue
    or      eax, eax
    jz      short @F

    cCall   _vpicdForceDefaultBehavior

@@:
    mov     edi,PVCOMD_IRQ_Descriptor
    VxDCall VPICD_Virtualize_IRQ
    jc      short di_com_exit


    mov     hIRQValue, eax

    mov     ax, 1
    jmp     short com_exit

di_com_exit:
    mov     dword ptr hIRQValue , 0
IFDEF DEBUG
;    Trace_Out "Cannot virtualize the IRQ for com, Handler Not Installed"
ENDIF
    mov     ax, 0

com_exit:

    pop     edi
    pop     ebp
    ret
EndProc _vpicdVirtualizeIRQ




;************************************************************************
;  VOID vpicdPhysEOI ( void )
;  Description:     This service ends a physical interrupt
;
;  Parameters:      NONE
;  Return Value:    nothing
;************************************************************************

BeginProc _vpicdPhysEOI, PUBLIC, NO_LOG
    mov     eax,hIRQValue
    VxDJmp  VPICD_Phys_EOI
    ret
EndProc _vpicdPhysEOI




;************************************************************************
; void vpicdForceDefaultBehavior  ( void );
; Removes the virtualization of the IRQ.
;
; Parameters:   None
; Return Value: Nothing
; Uses:         eax
;************************************************************************

BeginProc _vpicdForceDefaultBehavior, PUBLIC

    mov eax,hIrqValue
    cmp eax, 0                      ; SULU
    jz  short  alreadyDone

    VxDCall VPICD_Force_Default_Behavior
    mov hIRQValue , 0

alreadyDone:

    ret
EndProc _vpicdForceDefaultBehavior



VxD_LOCKED_CODE_ENDS

END


