/***************************************************************************
 *
 * File:          irq.h
 *
 * Description:   This file contains definitions used by the C
 *                portion of fastser (Fast version of serial)
 *
 * Author:        Anne Kelley
 *
 * Created:       December 27, 1995
 *
 * Copyright 1996, Counterpoint Systems Foundry, Inc.
 * All rights reserved worldwide
 *
 ****************************************************************************/
typedef struct tagVPICD_IRQ_DESCRIPTOR
{
    U16  vidIRQNumber;
    U16  vidOptions;
    U32  vidHwIntProc;
    U32  vidVirtIntProc;
    U32  vidEOIProc;
    U32  vidMaskChangeProc;
    U32  vidIRETProc;
    U32  vidIRETTimeOut;
}VPICD_IRQ_DESCRIPTOR, *P_VPICD_IRQ_DESCRIPTOR;

extern U16  vpicdVirtualizeIRQ      ( VPICD_IRQ_DESCRIPTOR * );
extern void VIRLAPD_HwIntProcDMA    ( void );
extern void VIRLAPD_HwIntProc4      ( void );
extern void VIRLAPD_HwIntProcPIO    ( void );
extern void VIRLAPD_EoiProc         ( void );
extern void VIRLAPD_IretProc        ( void );
