#****************************************************************************
#                                                                           *
# THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
# KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
# IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
# PURPOSE.                                                                  *
#                                                                           *
# Copyright (C) 1993-95  Microsoft Corporation.  All Rights Reserved.       *
#                                                                           *
#****************************************************************************
#                                                                          
#       Makefile for serial device
#
##########################################################################

DEVICE = TIR2000


########## Definitions ###############################

!include sertools.mk

MAKEFILE = makew311.mak

!if "$(CFG)" == ""
CFG= Win32 Debug
!message No configuration given. Defaulting to $(CFG)
!endif

!if "$(CFG)" == "Win32 Release"
TARGETDIR=retail31
!endif

!if "$(CFG)" == "Win32 Debug"
TARGETDIR=debug31
!endif

CVXDFLAGS  = -DBLD_COFF /I. /I.. -DWIN31COMPAT -Zp -Gs -W3 -c -DIS_32  -Zl -DDEBLEVEL=1 
AFLAGS  = -DBLD_COFF -DWIN31COMPAT -DIS_32 -nologo -W2 -Zd -c -Cx -DMASM6

LFLAGS  = /VXD /NOD /MAP /OUT:$(TARGETDIR)\$(DEVICE).386
INCLUDE    = $(inc31dir);$(DDKINC)
CINCLUDE   = $(inc31dir);$(DDKINC);$(SDKINC);$(CINC)

!if "$(CFG)" == "Win32 Debug"
TARGETDIR=debug31
DEBUGOBJS = $(TARGETDIR)\dbgprint.obj
CVXDFLAGS = -DDEBUG -Zd -Od $(CVXDFLAGS)
LFLAGS = -debug:notmapped,full -debugtype:cv $(LFLAGS)
AFLAGS = -Zd -DDEBLEVEL=1 -DDEBUG $(AFLAGS)
!endif

OBJS = $(TARGETDIR)\serutil.obj $(TARGETDIR)\serial.obj \
        $(TARGETDIR)\serfunc.obj $(TARGETDIR)\serinit.obj \
        $(TARGETDIR)\serdbg.obj $(TARGETDIR)\fastser.obj \
        $(TARGETDIR)\irqasm.obj $(TARGETDIR)\irasm.obj \
        $(TARGETDIR)\dma.obj $(TARGETDIR)\buffman.obj \
        $(TARGETDIR)\dmaasm.obj $(TARGETDIR)\hsdriver.obj \
        $(TARGETDIR)\sermsg.obj  $(TARGETDIR)\common.obj $(DEBUGOBJS)
		 
		 

ASMINCS = intern31.inc ins8250.inc

all: direxist $(TARGETDIR)\$(DEVICE).386

direxist:
        if not exist $(TARGETDIR)\nul    md $(TARGETDIR)
        if not exist $(TARGETDIR)\nul    md $(TARGETDIR)

############## VxD device link rule ###################

$(TARGETDIR)\serial.obj: ser31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serutil.obj: seruti31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serfunc.obj: serfun31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serinit.obj: serini31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serdbg.obj: serdbg31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\sermsg.obj: sermsg31.asm $(MAKEFILE) $(ASMINCS)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\irasm.obj: irasm31.asm $(MAKEFILE) intern31.inc
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\dmaasm.obj: dma.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\irqasm.obj: irq.asm $(MAKEFILE)
		set INCLUDE=$(INCLUDE)
		$(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\fastser.obj: fastser.c $(MAKEFILE) buffman.h
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\dbgprint.obj: dbgprint.c $(MAKEFILE)
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\dma.obj: dma.c $(MAKEFILE) dma.h hsdriver.h common.h 
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\common.obj: common.c $(MAKEFILE) common.h
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\hsdriver.obj:   hsdriver.c $(MAKEFILE)    hsdriver.h dma.h common.h buffman.h
				set INCLUDE = $(CINCLUDE)
				$(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\buffman.obj:   buffman.c $(MAKEFILE)    buffman.h hsdriver.h common.h
				set INCLUDE = $(CINCLUDE)
				$(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\VERSION.RES: version.rc 
        $(NEWRC) /ic:\msdev\mfc\include -r -fo$@ %s



$(TARGETDIR).def: $(MAKEFILE)
  rem <<$(TARGETDIR).def
VXD $(DEVICE).386
DESCRIPTION '$(DEVICE) Device'

SEGMENTS
	_LPTEXT  CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_LTEXT   CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_LDATA   CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_TEXT    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_DATA    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	CONST    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_BSS     CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_ITEXT   CLASS 'ICODE'   DISCARDABLE
	_IDATA   CLASS 'ICODE'   DISCARDABLE
	_PTEXT   CLASS 'PCODE'   NONDISCARDABLE
	_PDATA   CLASS 'PCODE'   NONDISCARDABLE
	_STEXT   CLASS 'SCODE'   RESIDENT
	_SDATA   CLASS 'SCODE'   RESIDENT
	_16ICODE CLASS '16ICODE' PRELOAD DISCARDABLE
	_RCODE   CLASS 'RCODE'
EXPORTS
	$(DEVICE)_DDB @1
<<keep

$(TARGETDIR).lnk: $(MAKEFILE)
  rem <<$(TARGETDIR).lnk
$(OBJS)
$(DDKLIB)\vxdwraps.clb
/DEF:$(TARGETDIR).def
<<keep

$(TARGETDIR)\$(DEVICE).SYM: $(DEVICE).MAP 
        $(MAP) -s -o $(TARGETDIR)\$(DEVICE).sym $(TARGETDIR)\$(DEVICE).map

$(TARGETDIR)\$(DEVICE).386: $(TARGETDIR).lnk $(TARGETDIR)\version.res $(TARGETDIR).def $(OBJS)
        $(LINK) $(LFLAGS) @$(TARGETDIR).lnk
        cd $(TARGETDIR)
        $(R2VXD) $(DEVICE).386 version.res
        $(MAP) $(DEVICE)
        cd ..
        copy $(TARGETDIR)\$(DEVICE).386 $(DEVICE).386
#        $(MAPSYM) $(TARGETDIR)\$(DEVICE)

