
#****************************************************************************
#                                                                           *
# THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
# KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
# IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
# PURPOSE.                                                                  *
#                                                                           *
# Copyright (C) 1993-95  Microsoft Corporation.  All Rights Reserved.       *
#                                                                           *
#****************************************************************************
#                                                                          
#       Makefile for serial device
#
##########################################################################

DEVICE = TIR2000


########## Definitions ###############################

!include sertools.mk

MAKEFILE = makew95.mak

!if "$(CFG)" == ""
CFG= Win32 Debug
!message No configuration given. Defaulting to $(CFG)
!endif

!if "$(CFG)" == "Win32 Release"
TARGETDIR=retail95
#COMMONDIR=..\retail95
!endif

!if "$(CFG)" == "Win32 Debug"
TARGETDIR=debug95
#COMMONDIR=..\debug95
!endif


CVXDFLAGS  = -DBLD_COFF  /I. /I.. -I$(INCS) -I$(DDKINC) -Zp -Gs -W3 -c -DIS_32  -Zl -DDEBLEVEL=1 $(MS_INTERNAL)
AFLAGS  = -DBLD_COFF -DIS_32 -I$(INCS) -I$(DDKINC) -nologo -W2 -Zd -c -Cx -DMASM6
ASMENV  = ML

LFLAGS  = /CO /VXD /NOD /MAP /OUT:$(TARGETDIR)\$(DEVICE).VXD
INCLUDE = $(INCDIR);$(DDKINC)
CINCLUDE = $(INCDIR);$(DDKINC);$(cincdir)

!if "$(CFG)" == "Win32 Debug"
TARGETDIR=debug95
#COMMONDIR=..\debug95
#DEBUGOBJS = $(COMMONDIR)\dbgprint.obj
DEBUGOBJS = $(TARGETDIR)\dbgprint.obj
CVXDFLAGS = -DDEBUG -Zd -Od $(CVXDFLAGS)
LFLAGS = -debug:notmapped,full -debugtype:cv $(LFLAGS)
AFLAGS = /Zi -Zd -DDEBUG $(AFLAGS)
!endif

OBJS =  $(TARGETDIR)\serial.obj $(TARGETDIR)\serutil.obj $(TARGETDIR)\irdaprnt.obj \
        $(TARGETDIR)\serfunc.obj $(TARGETDIR)\serinit.obj \
        $(TARGETDIR)\serdbg.obj $(TARGETDIR)\fastser.obj \
        $(TARGETDIR)\irqasm.obj $(TARGETDIR)\irasm.obj \
        $(TARGETDIR)\dma.obj $(TARGETDIR)\buffman.obj \
        $(TARGETDIR)\dmaasm.obj $(TARGETDIR)\hsdriver.obj \
        $(TARGETDIR)\common.obj $(DEBUGOBJS)
		 

all: direxist $(TARGETDIR)\$(DEVICE).VXD

direxist:
        if not exist $(TARGETDIR)\nul    md $(TARGETDIR)
#        if not exist $(COMMONDIR)\nul    md $(COMMONDIR)

############## VxD device link rule ###################

$(TARGETDIR)\serial.obj: serial.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serutil.obj: serutil.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serfunc.obj: serfunc.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serinit.obj: serinit.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\serdbg.obj: serdbg.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\irasm.obj: irasm.asm $(MAKEFILE)
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\irqasm.obj: irq.asm $(MAKEFILE)
		set INCLUDE=$(INCLUDE)
		$(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\dmaasm.obj: dma.asm $(MAKEFILE) 
        set INCLUDE=$(INCLUDE)
        $(ASM) $(AFLAGS) -Fo$@ %s

$(TARGETDIR)\fastser.obj: fastser.c $(MAKEFILE) hsdriver.h dma.h common.h 
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\dbgprint.obj: dbgprint.c $(MAKEFILE)
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\dma.obj: dma.c $(MAKEFILE) dma.h hsdriver.h common.h 
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\irdaprnt.obj: irdaprnt.c $(MAKEFILE) common.h 
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\common.obj: common.c $(MAKEFILE) common.h
        set INCLUDE=$(CINCLUDE)
        $(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\hsdriver.obj:   hsdriver.c $(MAKEFILE)    hsdriver.h dma.h common.h 
				set INCLUDE = $(CINCLUDE)
				$(CL) $(CVXDFLAGS) -Fo$@ %s

$(TARGETDIR)\buffman.obj:   buffman.c $(MAKEFILE)    buffman.h hsdriver.h common.h
				set INCLUDE = $(CINCLUDE)
				$(CL) $(CVXDFLAGS) -Fo$@ %s


$(TARGETDIR)\VERSION.RES: version.rc 
        $(NEWRC) /ic:\msdev\mfc\include -r -fo$@ %s


$(TARGETDIR).def: $(MAKEFILE)
  rem <<$(TARGETDIR).def
VXD $(DEVICE) DYNAMIC
DESCRIPTION '$(DEVICE) Device'

SEGMENTS
	_LPTEXT  CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_LTEXT   CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_LDATA   CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_TEXT    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_DATA    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	CONST    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_BSS     CLASS 'LCODE'   PRELOAD NONDISCARDABLE
	_ITEXT   CLASS 'ICODE'   DISCARDABLE
	_IDATA   CLASS 'ICODE'   DISCARDABLE
	_PTEXT   CLASS 'PCODE'   NONDISCARDABLE
	_PDATA   CLASS 'PCODE'   NONDISCARDABLE
	_STEXT   CLASS 'SCODE'   RESIDENT
	_SDATA   CLASS 'SCODE'   RESIDENT
	_16ICODE CLASS '16ICODE' PRELOAD DISCARDABLE
	_RCODE   CLASS 'RCODE'
EXPORTS
	$(DEVICE)_DDB @1
<<keep

$(TARGETDIR).lnk: $(MAKEFILE)
  rem <<$(TARGETDIR).lnk
$(OBJS)
$(DDKLIB)\vxdwraps.clb
/DEF:$(TARGETDIR).def
<<keep

$(TARGETDIR)\$(DEVICE).SYM: $(DEVICE).MAP 
	$(MAP) -s -o $(TARGETDIR)\$(DEVICE).sym $(TARGETDIR)\$(DEVICE).map

$(TARGETDIR)\$(DEVICE).VXD: $(TARGETDIR).lnk $(TARGETDIR)\version.res $(TARGETDIR).def $(OBJS)
        $(LINK) $(LFLAGS) @$(TARGETDIR).lnk
        cd $(TARGETDIR)
        $(R2VXD) $(DEVICE).VXD version.res
        $(MAP) $(DEVICE)
        cd ..
        copy $(TARGETDIR)\$(DEVICE).VXD $(DEVICE).VXD

