#ifndef PORTH
#define PORTH


/***************************************************************************
 *
 * File:          port.h
 *
 * Description:   This file contains declarations that are machine dependent.
 *                The file has MS-DOS dependent.
 *
 * 
 * Copyright Microsoft Corp. 1995
 *
 ****************************************************************************/


// Add basedefs here that do not clash with windows.h

#ifndef NOBASEDEFS
#define NOBASEDEFS

#define VOID void

typedef int INT;                        // i
typedef unsigned int UINT;              // u
typedef int BOOL;                       // f

typedef unsigned char BYTE;             // b
typedef unsigned short WORD;            // w
typedef unsigned long DWORD;            // dw

typedef char CHAR;                      // ch
typedef unsigned char UCHAR;            // uch
typedef short SHORT;                    // s
typedef unsigned short USHORT;          // us

#ifndef STRICT
#ifndef LONG
typedef long LONG;                      // l
#endif
#endif

typedef unsigned long ULONG;            // ul

typedef VOID *PVOID;                    // p
typedef PVOID *PPVOID;                  // pp

typedef INT *PINT;                      // pi
typedef UINT *PUINT;                    // pu
typedef BYTE *PBYTE;                    // pb
typedef WORD *PWORD;                    // pw
typedef DWORD *PDWORD;                  // pdw
typedef CHAR *PCHAR;                    // pch
typedef SHORT *PSHORT;                  // ps
typedef LONG *PLONG;                    // pl
typedef UCHAR *PUCHAR;                  // puch
typedef USHORT *PUSHORT;                // pus
typedef ULONG *PULONG;                  // pul
typedef BOOL *PBOOL;                    // pf

typedef UCHAR SZ[];                     // sz
typedef UCHAR SZZ[];                    // szz
typedef UCHAR *PSZZ;                    // pszz

typedef USHORT SEL;                     // sel
typedef SEL *PSEL;                      // psel

typedef ULONG PPHYS;                    // pphys

typedef (*PFN)();                       // pfn
typedef PFN *PPFN;                      // ppfn

//typedef PVOID HANDLE;                   // h
//typedef HANDLE *PHANDLE;                // ph

typedef ULONG HTIMEOUT;			// timeout handle
typedef ULONG CMS;			// count of milliseconds

#ifndef NOMINMAX

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#endif  // NOMINMAX

#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))

#ifndef MAKELONG
#define MAKELONG(a, b)      ((LONG)(((WORD)(a)) | ((DWORD)((WORD)(b))) << 16))
#endif

#ifndef LOWORD
#define LOWORD(l)           ((WORD)(l))
#endif

#ifndef HIWORD
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#endif

#define LOBYTE(w)           ((BYTE)(w))

#ifndef HIBYTE
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))
#endif
#endif  //NOBASDEFS

//  integer variables

typedef int BOOL;

#define UFAST32_TY 4
#define UFAST16_TY 4
#define UFAST8_TY  4

typedef unsigned long  UFAST32 ;
typedef unsigned int   UFAST16 ;
typedef unsigned int   UFAST8 ;

typedef         long   FAST32 ;
typedef          int   FAST16 ;
typedef          int   FAST8 ;

typedef unsigned char  UINT8 ;
typedef unsigned short UINT16 ;
typedef unsigned long  UINT32 ;

typedef          char  INT8 ;
typedef          short INT16 ;
typedef          long  INT32 ;

typedef unsigned long  U32, *PU32;
typedef unsigned short U16, *PU16;
typedef unsigned char  U8,  *PU8;

typedef          long  S32, *PS32;
typedef          short S16, *PS16;
typedef          char  S8,  *PS8;

//
// TYPE DEFINITIONS

#ifndef TRUE
#define TRUE  (1==1)
#endif
#ifndef FALSE
#define FALSE (0==1)  
#endif

typedef void (*PFV) ();
typedef int BOOL, *PBOOL;
typedef BOOL (*PFB) ();
typedef UINT IRDA_STATUS, *PIRDA_STATUS;

#endif /* PORTH */


