  PAGE	58,132
;******************************************************************************
; Serial.ASM	VxD to provide VxD level COMM services for NS8250/16550AFN.
;******************************************************************************
;
; TITLE:	SERIAL.ASM
;
; Version:	1.0
;
; Date:		11/19/92
;
; Author:	Sandeeps
;
;==============================================================================
;
; Change log:
;
;             Nov 2, 1994 by DWS added fix to support 115200 bps
;
;******************************************************************************

	.386p

;******************************************************************************
;			INCLUDE files
;******************************************************************************



Create_SERIAL_Service_Table	equ	TRUE

IFNDEF	WIN31COMPAT
SERIAL_Dynamic	equ	1
ENDIF

	.xlist
	include	VMM.INC
	include	VCOMM.INC       
    include ircomm31.inc    ; Added by DWS on Jan 12, 1995
	include	DEBUG.INC
	include	OPTTEST.INC
	include	VPICD.INC
	include	INTERN31.INC
	include	INS8250.INC
	include	VCD.INC
	.list

SERIAL31_Init_Order equ IRCOMM31_Init_Order + 1

;******************************************************************************
;			Virtual Device Declaration
;******************************************************************************

; Line below modified by DWS on Jan 12, 1996 to change the name from serial to serial31

Declare_Virtual_Device	TIR2000, SERIAL_Major_Version,SERIAL_Minor_Version, \
		SERIAL_Control, Undefined_Device_ID, SERIAL31_Init_Order,,,


;******************************************************************************
;			Locked Data
;******************************************************************************
VxD_Locked_Data_Seg

		EXTRN	IRQInfoArray:BYTE
		EXTRN	ActiveCOMs:DWORD
        EXTRN   VcommPresent:BYTE  ; Added by DWS on Feb 3, 1996
		EXTRN 	NoReflect:DWORD    ; Added by DWS on March 11, 1996

		PUBLIC	Serial_Functions

Serial_Functions	label	DWORD
	dd	OFFSET32 _PortSetState
	dd	OFFSET32 _PortGetState
	dd	OFFSET32 _PortSetup
	dd	OFFSET32 _PortTransmitChar
	dd	OFFSET32 _PortClose
	dd	OFFSET32 _PortGetQueueStatus
	dd	OFFSET32 _PortClearError
	dd	OFFSET32 _PortSetModemStatusShadow
	dd	OFFSET32 _PortGetProperties
	dd	OFFSET32 _PortEscapeFunction
	dd	OFFSET32 _PortPurge
	dd	OFFSET32 _PortSetEventMask
	dd	OFFSET32 _PortGetEventMask
	dd	OFFSET32 _PortWrite
	dd	OFFSET32 _PortRead
	dd	OFFSET32 _PortEnableNotification
	dd	OFFSET32 _PortSetReadCallBack
	dd	OFFSET32 _PortSetWriteCallBack
	dd	OFFSET32 _PortGetModemStatus

.errnz	($ - Serial_Functions - SIZE _PortFunctions)


;***
;
; Reserve data space for COM ports
;

	align	4

PUBLIC	PortInfoPtrs

PortInfoPtrs	dd MAXCOM+1 DUP (0)	; array of Ptrs to PortInformation

		PUBLIC	SysVMHandle

SysVMHandle		dd	0

	align	4

DD_OFFSET32_Serial_PortHandler MACRO num
	dd  OFFSET32 Serial_PortHandler_&num
ENDM

PUBLIC	Serial_PortHandlerArray
Serial_PortHandlerArray	label	dword
??portnum = 1
REPT MAXCOM+1
	DD_OFFSET32_Serial_PortHandler %??portnum
??portnum = ??portnum + 1
ENDM

PURGE DD_OFFSET32_Serial_PortHandler

characterCount  dw  0

SrvTab	label	dword
	dd	OFFSET32	ModemStatus	; [0] modem status interrupt
	dd	OFFSET32	XmitEmpty	; [4] Tx holding reg. interrupt
	dd	OFFSET32	DataAvail	; [8] Rx data avail or
						; [18] if 16550/16550A
	dd	OFFSET32	LineStat	; [C] receiver line status int

ExtTab	label	dword
	dd	OFFSET32 ExtComDummy	; function 0: never mind
	dd	OFFSET32 ExtCom_FN1	; Set X-Off
	dd	OFFSET32 ExtCom_FN2	; clear X-Off
	dd	OFFSET32 ExtCom_FN3	; Set RTS
	dd	OFFSET32 ExtCom_FN4	; Clear RTS
	dd	OFFSET32 ExtCom_FN5	; Set DSR
	dd	OFFSET32 ExtCom_FN6	; Clear DSR
	dd	OFFSET32 ExtCom_FN7	; Reset Printer
	dd	OFFSET32 ExtComDummy	; Get Max LPT port
	dd	OFFSET32 ExtComDummy	; Get Max COM Port
	dd	OFFSET32 ExtCom_FN10	; Get COM port base and IRQ
	dd	OFFSET32 ExtCom_FN10	; Get COM port base & IRQ
	dd	OFFSET32 ExtCom_FN12	; set break
	dd	OFFSET32 ExtCom_FN13	; clear break

BaudRateByIndexTable label word
	dw 1047     ; CBR_110
	dw 384	    ; CBR_300
	dw 192	    ; CBR_600
	dw 96	    ; CBR_1200
	dw 48	    ; CBR_2400
	dw 24	    ; CBR_4800
	dw 12	    ; CBR_9600
	dw 8	    ; CBR_14400
	dw 6	    ; CBR_19200
	dw 0	    ;	 0FF19h  (reserved)
	dw 0	    ;	 0FF1Ah  (reserved)
	dw 3	    ; CBR_38400
	dw 0	    ;	 0FF1Ch  (reserved)
	dw 0	    ;	 0FF1Dh  (reserved)
	dw 0	    ;	 0FF1Eh  (reserved)
	dw 2	    ; CBR_56000

VxD_Locked_Data_Ends

;******************************************************************************
;			Locked code
;******************************************************************************

VxD_Locked_Code_Seg

;******************************************************************************
;
; SERIAL_Control
;
; Description:		Dispatcher for system messages.
;
; Entry:
; Exit:
; Uses:
;******************************************************************************

BeginProc SERIAL_Control

	Control_Dispatch VM_Not_Executeable, Serial_Not_Executeable
	Control_Dispatch Device_Init,	Serial_Device_Init

IFDEF	DEBUG
	Control_Dispatch Debug_Query,	Serial_Debug_Query
ENDIF
	clc
	ret

EndProc SERIAL_Control

VxD_Locked_Code_Ends

VxD_My_PAGEABLE_DATA_Seg

    PUBLIC  COMIRName

COMIRName db  'IRC1',0

VxD_My_PAGEABLE_DATA_Ends

;******************************************************************************
;		PAGEABLE DATA
;==============================================================================

VxD_My_Pageable_Data_Seg


		PUBLIC	Serial_Name

Serial_Name	db	'SERIAL31',0

VxD_My_Pageable_Data_Ends

;******************************************************************************
;		PAGEABLE CODE
;==============================================================================

VxD_My_Pageable_Code_Seg

		EXTRN	GetCOMPort:NEAR
		EXTRN	ReleaseCOMPort:NEAR
		EXTRN	Serial_Device_Init:NEAR
		EXTRN	Terminate:NEAR
		EXTRN	MaskIRQ:NEAR
		EXTRN	UnMaskIRQ:NEAR
		EXTRN	KickTx:NEAR
		EXTRN	Notify_Owner:NEAR
IFDEF	DEBUG
		EXTRN	Serial_Debug_Query:NEAR
ENDIF
		EXTRN	ExtComDummy:NEAR
		EXTRN	ExtCom_FN1:NEAR
		EXTRN	ExtCom_FN2:NEAR
		EXTRN	ExtCom_FN3:NEAR
		EXTRN	ExtCom_FN4:NEAR
		EXTRN	ExtCom_FN5:NEAR
		EXTRN	ExtCom_FN6:NEAR
		EXTRN	ExtCom_FN7:NEAR
		EXTRN	ExtCom_FN10:NEAR

		EXTRN	_PortSetState:NEAR
		EXTRN	_PortGetState:NEAR
		EXTRN	_PortSetup:NEAR
		EXTRN	_PortTransmitChar:NEAR
		EXTRN	_PortClose:NEAR
		EXTRN	_PortGetQueueStatus:NEAR
		EXTRN	_PortClearError:NEAR
		EXTRN	_PortSetModemStatusShadow:NEAR
		EXTRN	_PortGetProperties:NEAR
		EXTRN	_PortEscapeFunction:NEAR
		EXTRN	_PortPurge:NEAR
		EXTRN	_PortSetEventMask:NEAR
		EXTRN	_PortGetEventMask:NEAR
		EXTRN	_PortWrite:NEAR
		EXTRN	_PortRead:NEAR
		EXTRN	_PortEnableNotification:NEAR
		EXTRN	_PortOpen:NEAR
		EXTRN	_PortSetReadCallBack:NEAR
		EXTRN	_PortSetWriteCallBack:NEAR
		EXTRN	_PortGetModemStatus:NEAR

VxD_My_Pageable_Code_Ends

VxD_Locked_Code_Seg

;***
; SetCom100
;
; Description:
;	Copy a given DCB into the appropriate DEB. 
;	This does it selectively.
;
; Entry:
;		EBX -> DCB
;		ESI -> PortInformation
;		ECX = mask of relevant fields.
;
; Exit:		ESI -> PortInformation
;
; Uses:
;		EAX,ECX,FLAGS
;
BeginProc SetCom100, PUBLIC

	push	esi			; save ESI
	lea	esi,[esi.ComDCB]	; to reduce code size

	mov	[esi._DCB.DCBLength], SIZE _DCB
	TestReg	ecx,fBaudRate		; is caller interested in baud rate?
	jz	@F
	mov	eax,[ebx._DCB.BaudRate]
	mov	[esi._DCB.BaudRate],eax
@@:
	TestReg	ecx,fBitMask
	jz	@F
	mov	eax,[ebx._DCB.Bitmask]
	mov	[esi._DCB.Bitmask],eax
@@:
	TestReg	ecx,fLCR
	jz	@F
	mov	al,[ebx._DCB.ByteSize]
	mov	[esi._DCB.ByteSize],al
	mov	al,[ebx._DCB.Parity]
	mov	[esi._DCB.Parity],al
	mov	al,[ebx._DCB.StopBits]
	mov	[esi._DCB.StopBits],al
@@:
	mov	ax,[ebx._DCB.wReserved]
	mov	[esi._DCB.wReserved],ax

	pop	esi
	ret

EndProc SetCom100

;***
; SetCom300
;
; Description:
;	Calculate the correct BAUDRATE divisor for the COMM chip
;
;	Note that the baudrate is allowed to be any integer in the
;	range 2-19200. The divisor is computed as 115,200/baudrate.
;
; Entry:
;	EBX -> DCB32
; Exit:
;	EBX -> DCB32
;	ECX = baudrate (0 if error AX = error code if invalid baud rate)
; Uses:
;	EAX,ECX, flags
;
BeginProc SetCom300, PUBLIC

	push	edx
	mov	ecx,[ebx._DCB.BaudRate]	; get requested baud rate
	xor	eax,eax			; assume error

; This code was added by DWS on Nov 2, 1994 for 115200 bps support.
        cmp     ecx,01C200h
        je      SetCom115200
;end of changes by DWS

	cmp	ecx,CBR_110		; Q: baudrate specified as an index?
	jae	by_index		;  Y:
	cmp	ecx,2			;  N: by value (range check it)
	jnae	SetCom310		; Below range

SetCom115200:    ;added by DWS on Nov 2, 1994
	xor	edx,edx			; EDX:EAX = 115,200
	mov	eax,01C200h
	div	ecx			; (EAX) = 115,200/baud

SetCom310:
	mov	ecx,eax			; (ECX) = baud rate, or error code (0)
	mov	eax,IE_BAUDRATE		; set error code incase bad baud
	pop	edx
	ret

by_index:
	cmp	ecx,CBR_56000		; Q: above supported?
	ja	SetCom310		;  Y: return error
	push	ebx
	mov	ebx,ecx
	sub	ebx,CBR_110
	shl	ebx,1
	movzx	eax,WORD PTR [ebx+BaudRateByIndexTable] ; get divisor
	pop	ebx
	jmp	SetCom310		; Y: return error

EndProc SetCom300

;***
; SetCom400
;
; Description:	Check the line config. (parity,stop,byte size)
;
; Entry:	EBX -> DCB32
; Exit:
;		EBX -> DCB32
;		NC -> OK, else error (AX = error code)
;		AL = LCR, AH = RxMask
;		EDI (Bits 15:8) = flags mask (to remove parity checking)
;		EDI (Bits 7:0) = Error mask (to remove parity error)
; Uses:
;		EAX,ECX,EDI,FLAGS
;
BeginProc SetCom400, PUBLIC

	movzx	eax,WORD PTR [ebx._DCB.ByteSize] ; al = byte size, ah = parity
	cmp	ah,SpaceParity		; parity out of range >
	ja	SetCom470		;  Yes, return error
	mov	edi,0FF00h+ACE_OR+ACE_PE+ACE_FE+ACE_BI
	or	ah,ah			; is parity 'NONE'?
	jnz	SetCom410		;  No, something is there for parity
	xor	edi,(fParity*256)+ACE_PE ; disable parity checking

SetCom410:
	cmp	al,8			; Byte size out of range?
	ja	SetCom460		;  Yes, return error

SetCom420:
	sub	al,5			; Shift byte size to bits 0,1
	.errnz	ACE_WLS-00000011b	; Word length must be these bits
	jc	SetCom460		; Byte size is illegal, return error
	add	ah,ah			; map parity to ACE bits
	jz	SetCom430		; 0=>0,1=>1,2+.3,3=>5,4=>7
	dec	ah

SetCom430:
	shl	ah,3			; align with 8250 parity bits
	or	al,ah			; add to byte size

	.errnz	NoParity-0
	.errnz	OddParity-1
	.errnz EvenParity-2
	.errnz MarkParity-3
	.errnz SpaceParity-4
	.errnz ACE_PEN-00001000b
	.errnz ACE_PSB-00110000b
	.errnz ACE_EPS-00010000b
	.errnz	ACE_SP-00100000b

	or	al,ACE_2SB		; Assume 2 stop bits
	mov	ah,[ebx._DCB.StopBits]	; get # of stop bits 0=1,1/2= .GT. 1
	or	ah,ah			; out of range ?
	js	SetCom470		;  Yes, return error
	jz	SetCom440		; One stop bit
	sub	ah,2
	jz	SetCom450		; 2 stop bits
	jns	SetCom470		; Not 1.5, return error
	test	al,ACE_WLS		; 1.5 stop bits, 5 bit words?
	jnz	SetCom470		;  No, illegal

	.errnz OneStopBit-0
	.errnz One5StopBits-1
	.errnz TwoStopBits-2
	.errnz ACE_5BW

SetCom440:
	and	al,NOT ACE_2SB		;Show 1 (or 1.5) stop bit(s)

 ;
 ; From the byte size, get a mask to be used for stripping
 ; off unused bits as the characters are received.
 ;
SetCom450:
	push	edx
	mov	cl,[ebx._DCB.ByteSize]	;Get data byte size
	mov	edx,00FFh		;Turn into mask by shifting bits
	shl	edx,cl
	mov	ah,dh			;Return mask in ah
	pop	edx
	clc				;Show all is fine
	ret

SetCom460:
	mov	eax,IE_ByteSize		;Show byte size is wrong
	stc				;Show error
	ret

SetCom470:
	mov	eax,IE_Default		;Show something is wrong
	stc				;Show error
	ret

EndProc SetCom400

VxD_Locked_Code_Ends

VxD_My_Pageable_Code_Seg

BeginDoc
;******************************************************************************
;
; RecCom:
;
; Description:
;		Receive a byte from channel (if available).
;
; Entry:
;	ESI -> PortInformation struct
; Exit:
;	'Z' clear if data available
;	AL = byte
;	Else if 'Z' set, no data/ error, AX = error code AX = 0 => no data
;
; Uses:
;	C standard
;
;==============================================================================
EndDoc
BeginProc RecCom, Public

	push	esi
	push	edi

 ;
 ; Now we can get down to the business at hand, and remove a character
 ; from the receive queue. If a communications error exists, we return
 ; that and nothing else.
 ;
RecCom60:
	xor	eax,eax
	or	eax,[esi.pData.dwCommError] ; any errors ?
	jnz	RecCom100		;  Yes, return error code
	or	eax,[esi.pData.QInCount] ; get current input char count
	jz	RecCom90		; No chars in q
	mov	edi,[esi.pData.QInAddr]	; get q pointer

	mov	ebx,[esi.pData.QInGet]	; also get the index to head
	mov	al,[ebx+edi]		; finally get the byte from queue
	inc	ebx			; update q index
	cmp	ebx,[esi.pData.QInSize]	; wrap-around ?
	jc	RecCom70		;  No wrap
	xor	ebx,ebx			; wrap by zeroing the index

RecCom70:
	mov	[esi.pData.QInGet],ebx	; save new head pointer
	dec	[esi.pData.QInCount]		; dec # of bytes in queue

	mov	ecx,[esi.pData.QInCount]; Q: have we read below trigger
	jae	RecCom80		;  N:
	and	[esi.NotifyFlagsHI], NOT CN_RECEIVE ;allow timeout notify again

RecCom80:
	or	esp,esp			; reset PSW.Z
	pop	edi
	pop	esi
	ret

;
; No characters in the input queue. Check to see if EOF was received, and
; return it if it was. Otherwise show no characters.
;
RecCom90:
RecCom95:
	xor	eax,eax			; Show no more characters

; Return with 'Z' to show error or no characters

RecCom100:
	xor	ecx,ecx			; set PSW.Z
	pop	edi
	pop	esi
	ret

EndProc RecCom

VxD_My_Pageable_Code_Ends

VxD_Locked_Code_Seg

;***
; TXI - xmit a char immediately.
;	Places the char in a location that guarantees it to be the next
;	char transmitted.
; Entry:
;	AH = char
;	ESI -> DEB
; Exit:
;	None
; Uses:
;	C standard
;
BeginProc TXI, PUBLIC, NO_PROLOG

	or	[esi.EFlags],fTxImmed	; show char to xmit
	mov	[esi.ImmedChar],ah	; set char
	jmp	KickTx			; kick transmit interrupt just in case

EndProc TXI

BeginDoc
;******************************************************************************
;
; StaCom:
;
; Description:
;		returns status of open channel.
;		Returns the number of bytes in both queues.
; Entry:
;		ESI = Portinformation struct
;		EBX -> Ptr to status structure to be updated.
; Exit:
;		AX = error word
;		status structure is updated.
; Uses:
;		C standard
;
;==============================================================================
EndDoc
BeginProc StaCom, Public

	or	ebx,ebx			; Null pointer ?
	jz	StaCom25		; yes, return error code
;
; Need to get the status for a com port.  Since not all the
; status is contained within EFlags, it has to be assembled.
; Also note that currently there is no way to specify RLSD
; as a handshaking line, so fRLSDHold is always returned false.
;
	mov	edx,[esi.AddrMSRShadow]
	mov	al,[edx]		;Get state of hardware lines
	and	al,[esi.OutHHSLines]	;Mask off required bits
	xor	al,[esi.OutHHSLines]	;1 = line low
	shr	al,4			;align bits, al = fCTSHold + fDSRHold
	.errnz	ACE_CTS-00010000b
	.errnz	ACE_DSR-00100000b
	.errnz	fCTSHold-00000001b
	.errnz	fDSRHold-00000010b

	mov	ah,[esi.HSFlag]		;Get fXOffHold+fXOffSent
	and	ah,XOffReceived+XOffSent
	or	al,ah

	.errnz	 XOffReceived-fXOFFHold
	.errnz	 XOffSent-fXOFFSent

	mov	ah,[esi.EFlags]		;Get fEOF+fTxImmed
	and	ah,fEOF+fTxImmed
	or	al,ah

	mov	ecx,[esi.pData.QInCount];Get input queue count
	mov	edx,[esi.pData.QOutCount] ;Get tx queue count

	movzx	eax,al
	mov	[ebx._COMSTAT.BitMask],eax
	mov	[ebx._COMSTAT.cbInQue],ecx
	mov	[ebx._COMSTAT.cbOutQue],edx

StaCom25:
	ret

EndProc StaCom

BeginDoc
;******************************************************************************
;
; ExtnFcn:
;
; Description:
;		some extended functions.
;		Functions currently implemented:
;
;	0: Dummy   - Ignored
;	1: SETXOFF - Exactly as if X-OFF character has been received.
;	2: SETXON  - Exactly as if X-ON character has been received.
;	3: SETRTS  - Set the RTS signal
;	4: CLRRTS  - Clear the RTS signal
;	5: SETDTR  - Set the DTR signal
;	6: CLRDTR  - Clear the DTR signal
;	7: RESETDEV- Yank on reset line if available (LPT devices)
;	8: GETLPTMAX - ignored
;	9: GETCOMMAX - ignored
;	10: GETCOMBASEIRQ - return base and IRQ of COMM port
;	11: GETCOMBASEIRQ1 - -do-
;	12: SETBREAK - set break condition
;	13: CLEARBREAK - clear break condition
;
; Entry:
;	ESI -> Port information EBX = function code.
; Exit:
;	EAX = Comm error word or return value of subfunction
; Uses:
;	C standard
;
;==============================================================================
EndDoc
BeginProc ExtnFcn, Public

	push	edi
	mov	edx,[esi.Port]		; get base address
	shl	ebx,2

	cli				; exclusive access.
	call	DWORD PTR [ebx+ExtTab]	; call function
	sti

	jc	ExtCom40		; jump if sub returns data in EAX
	mov	eax,[esi.pData.dwCommError]
ExtCom40:
	pop	edi
	ret

EndProc ExtnFcn

BeginDoc
;******************************************************************************
;
; ExtCom_FN12
;
; Description:
;		Sets break condition. Suspends character transmission, 
;		and places the transmission line in a break state until 
;		Clear break is called.
;		Clamps transmit data line low. Doesn't wait for the
;		transmitter holding register and shift registers to empty.
; Entry:
;		ESI -> Port data
;		EDX = port base
; Exit:
;		CLC
; Uses:
;		C standard.
;
;==============================================================================
EndDoc
BeginProc ExtCom_FN12, Public

	mov	ecx,0FF00h+ACE_SB	; will be setting break
	jmp	ClrBrk10
	.errnz	BreakSet-ACE_SB		; must be same

EndProc ExtCom_FN12

BeginDoc
;******************************************************************************
;
; ExtCom_FN13
;
; Description:
;		Clears break condition.
;		Releases any BREAK clamp on Tx data line
; Entry:
;		ESI -> port data
;		EDX -> Port base
; Exit:
;		CLC
; Uses:
;		C standard.
;
;==============================================================================
EndDoc
BeginProc ExtCom_FN13, Public

	mov	ecx,(NOT ACE_SB) SHL 8
	.errnz	BreakSet-ACE_SB		; must be same bits

ClrBrk10:
	and	[esi.HSFlag],ch		; Set or clear the BreakSet Bit
	or	[esi.HSFlag],cl
 ;
 ; CH = mask to remove bits in the line Control reg
 ; CL = mask to turn on the bits in the line control reg
 ;
	add	dl,ACE_LCR		; --> LCR
	in	al,dx			; old control value
	and	al,ch			; turn off undesired bits
	or	al,cl			; turn on desired bits
	IO_Delay
	out	dx,al			; new LCR value
	clc				; caller gets error dword
	ret

EndProc ExtCom_FN13

BeginDoc
;******************************************************************************
;
; ReadCommString
;
; Description:
;	Return immediately, read a max of n bytes.
;
; Entry:
;		ESI -> port information struct
;		EDI -> receive buffer
;		ECX = max bytes to read.
; Exit:
;		'Z' clear if data is available, AX = # bytes read.
;		'Z' set => error/no data. AX = 0 => no data.
; Uses:
;		C standard
;
;==============================================================================
EndDoc
BeginProc ReadCommString, Public

	push	esi
	push	edi

	xor	eax,eax
	or	eax,[esi.pData.dwCommError]	; any errors?
	jnz	RecStr100		; Yes, return error code
	or	eax,[esi.pData.QInCount] ; any chars in input queue
	jz	RecStr90		; no chars in queue

	cmp	ecx,eax			; Q:more chars available than can read?
	jbe	RecStr30		;   N:
	mov	ecx,eax			;   Y: adjust # of chars to read
RecStr30:
	push	ecx
	mov	edx,[esi.pData.QInSize]
	mov	eax,[esi.pData.QInGet]
	sub	edx,eax			; EDX = # of bytes before end of buf
	cmp	edx,ecx			; Q: more avail than can read?
	jbe	RecStr40		;   N:
	mov	edx,ecx			;   Y: adjust avail count
RecStr40:
	xchg	ecx,edx			; ECX = # bytes for 1st copy
	sub	edx,ecx			; EDX = # bytes for 2nd copy

	push	esi
	mov	ebx,[esi.pData.QInAddr]
	mov	esi,ebx
	add	esi,eax			; esi-> first char in buffer
	cld
	rep	movsb			; do first copy
	mov	ecx,edx
	jecxz	RecStr50		; jump if no 2nd copy needed
	mov	esi,ebx			; ESI -> start of buffer
	rep	movsb
RecStr50:
	sub	esi,ebx			; esi -> new QInGet
	mov	ebx,esi
	pop	esi
	pop	ecx

	cli
	mov	[esi.pData.QInGet],ebx	; update QInGet
	sub	[esi.pData.QInCount],ecx ; update count
	mov	eax,[esi.pData.QInCount]
	sti

	cmp	eax,[esi.RecvTrigger]	; Q: have we read below trigger?
	jae	@F			;    N:
	and	[esi.NotifyFlagsHI],NOT CN_RECEIVE ; allow TO notify again
@@:

RecStr80:
	mov	eax, ecx
	or	esp,esp			;Reset PSW.Z
	pop	edi
	pop	esi
	ret
 ;
 ; No characters in the input queue.  Check to see if EOF
 ; was received, and return it if it was.  Otherwise show
 ; no characters.
 ;
RecStr90:
RecStr95:
	xor	eax,eax			;Show no more characters

; Return with 'Z' to show error or no characters

RecStr100:
	xor	ecx,ecx			;Set PSW.Z
	pop	edi
	pop	esi
	ret

EndProc ReadCommString

BeginDoc
;******************************************************************************
;
; WriteCommString
;
; Description:
;		The given buffer is sent to the passed port if possible.
;	Once the output queue is detected as being full, a CE_TXFULL error
;	will be indicated and AX will be returned as the # of chars actually
;	queued.
;
; Entry:
;	ESI -> Portinformation struct
;	ECX = # bytes to write
;	EDI -> buffer.
; Exit:
;	EAX = # bytes queued.
; Uses:
;	ALL
;
;==============================================================================
EndDoc
BeginProc WriteCommString, Public

	push	ecx
	mov	edx,[esi.pData.QOutSize] ; see if queue is full
	sub	edx,[esi.pData.QOutCount] ; edx = # of chars free in queue
	jle	scs_full		;  There is no room in the queue

scs_loop:
	push	ecx			; save count left to send
	cmp	ecx,edx			; Q: room for buffer in queue
	jbe	@F			;   Y:
	mov	ecx,edx			;   N: adjust size to send
@@:
	push	ecx			; save # of chars which will be copied
	push	esi
	push	edi
	mov	ebx,[esi.pData.QOutAddr] ; --> output queue
	mov	edx,[esi.pData.QOutSize]
	mov	edi,[esi.pData.QOutPut]	; get index into queue
	sub	edx,edi			; EDX = # of free chars befor end of q
	cmp	edx,ecx
	jbe	@F
	mov	edx,ecx
@@:
	xchg	edx,ecx			; ECX = # of chars for 1st copy
	sub	edx,ecx			; EDX = # of chars for 2nd copy
	pop	esi			; ESI -> SRC buffer
	add	edi,ebx			; EDI -> current pos in q
	cld
	rep	movsb			; copy fist section
	mov	ecx,edx
	jecxz	@F
	mov	edi,ebx			; circle back to start of queue
	rep	movsb
@@:
	sub	edi,ebx			; EDI = last index into queue
	mov	edx,edi
	mov	edi,esi			; last location in src buffer
	pop	esi			; ESI --> COMDEB
	pop	ebx			; # of chars copied

	cli
	mov	[esi.pData.QOutPut],edx	; new index into queue
	add	[esi.pData.QOutCount],ebx
	mov	edx,[esi.pData.QOutCount] ; get new count
	cmp	edx,[esi.SendTrigger]	; Q: Have we overshot the trigger ?
	jb	scs_stillbelowtrigger	;    N: do not start looking
	and	[esi.NotifyFlagsHI], NOT CN_TRANSMIT ; start looking now

scs_stillbelowtrigger:
	call	KickTx
	sti
	pop	ecx
	sub	ecx,ebx			; # of chars left to send
	jnz	scs_full_2		;  jump if none
scs_exit:
	pop	eax
	sub	eax,ecx			; EAX = # transfered
	ret

scs_full:
	cli
	call	KickTx
	sti
scs_full_2:
	or	[esi.pData.dwCommError],CE_TXFULL
	jmp	scs_exit

cws_error:
	pop	eax
	sub	eax,ecx			; EAX = # transfered
cws_exit:
	ret

EndProc WriteCommString

VxD_Locked_Code_Ends

VxD_My_Pageable_Code_Seg

BeginDoc
;******************************************************************************
;
; TrmCom:
;
; Description:
;		terminates (closes) a channel.
;		Waits for any outbound data to be transmitted, drop the
;		hardware handshaking lines, and disable interrupts. If the
;		output queue contained data when it was closed, an error
;		will be returned.
; Entry:
;		ESI -> PortInformation struct
; Exit:
;		EAX = 0	=> no error
;		EAX = 8000h	=> invalid device ID
;		EAX = -2 => output queue timed out.
; Uses:
;		Everything
;
;==============================================================================
EndDoc
BeginProc TrmCom, Public

	push	eax			; save port #
	or	[esi.MiscFlags],Discard	; Show discarding serial data
	mov	[esi.pData.dwCommError],ecx	; Clear error flaggs.
	mov	[esi.pData.QInCount],ecx ; show no chars in input queue
	call	RecCom			; send XON if needed.

;
; We have to wait for the output queue to empty.   To do this,
; a timer will be created.  If no character has been transmitted
; when the timeout occurs, then an error will be indicated and
; the port closed anyway.  If the timer cannot be created, then
; just loop until the queue empties, which will be better than
; discarding charatcers if there are any
;
	test	[esi.HSFlag],HHSAlwaysDown ; Q: handshaking ever up ?
	jnz	TermCom17		;      N: skip wait loop

TermCom10:
	mov	ecx,[esi.pData.QOutCount] ; get current queue count
	jecxz	TermCom20		; no chars in queue

	VMMCall	Get_System_Time
	mov	edi,eax

TermCom15:
	cmp	[esi.pData.QOutCount],ecx ; queue count changed ?
	jne	TermCom10		; yes, restart timeout

	VMMCall	Get_System_Time
	sub	eax,edi
	cmp	eax, Timeout * 1000	; Q: timeout reached ?
	jb	TermCom15

TermCom17:
	mov	ecx,TimeoutError	; Yes, show timeout error

TermCom20:
	pop	eax			; restore CID

TermCom30:
	mov	edx,[esi.Port]		; get port base address
	call	Terminate		; the real work is done here
	mov	eax,ecx			; set return code

TermCom60:

	ret
EndProc TrmCom

BeginDoc
;******************************************************************************
;
; Flush
;
; Description:
;		Flush pending reads/writes. It does so before returning
;		to the caller.
;
; Entry:
;		ESI = PortInformation
;		EBX = 0 => transmit queue, 1=> receive queue
; Exit:
;		none.
; Uses:
;		C standard.
;
;==============================================================================
EndDoc
BeginProc Flush, Public

	push	edi

	mov	ecx,_PortData.QOutCount-_PortData.QInCount ; # of bytes to zero
	lea	edi,[esi.pData.QInCount] ; --> receive Queue data
	or	bl,bl			; xmit q ?
	jnz	Flush10			; No, input Q
	add	edi,ecx			; YES, --> xmit Q data
	mov	edx,[esi.pData.QOutCount] ; save for determining whether to
					; send Xmit notification.....
Flush10:
	cld
	shr	ecx,2			; convert to DWORDS.
	xor	eax,eax
	cli
	rep	stosd
	sti
	.errnz	_PortData.QInGet-_PortData.QInCount-4
	.errnz	_PortData.QInPut-_PortData.QInGet-4
	.errnz	_PortData.QOutCount-_PortData.QInPut-4
	.errnz	_PortData.QOutGet-_PortData.QOutCount-4
	.errnz	_Portdata.QOutPut-_PortData.QOutGet-4

        or      bl,bl                   ; Rx queue?
        jz      Flush30                 ;  No, xmit queue

;
; If the queue to be cleared is the receive queue, any
; hardware handshake must be cleared to prevent a possible
; deadlock situation.  Since we just zeroed the queue count,
; a quick call to $RecCom should do wonders to clear any
; receive handshake (i.e. send XON if needed).
;
Flush20:
	call	RecCom			;Take care of handshakes here
	jmp	Flush40

Flush30:
	or	edx,edx			; Q: Was there any data ?
	jz	Flush40			;  N: no need to inform anyone
	cmp	[esi.SendTrigger],0
	je	Flush40			; no need to call
	mov	eax, CN_TRANSMIT	; we have fallen below the trigger
	call	Notify_Owner		; notify the owner of the port

Flush40:
	pop	edi
	ret
EndProc Flush

VxD_My_Pageable_Code_Ends

;******************************************************************************
;
;		I N T E R R U P T	T I M E		C O D E
;==============================================================================

VxD_Locked_Code_Seg

Define_Serial_PortHandler MACRO num
	align	4

BeginProc Serial_PortHandler_&num, High_Freq, PUBLIC
	mov	esi, PortInfoPtrs[(num-1)*4]
	jmp	Serial_PortHandler
EndProc Serial_PortHandler_&num

ENDM
??portnum = 1
REPT MAXCOM+1
	Define_Serial_PortHandler %??portnum
??portnum = ??portnum+1
ENDM

PURGE Define_Serial_PortHandler

;******************************************************************************
;
; Serial_PortHandler
;
; Description:	This is the common portion of all COM port HW interrupt
;		handlers. We have generated using the macro
;		Define_Serial_PortHandler, maxcom interrupt handlers for maxcom
;		ports. Each of them sets esi to point to its IRQ struc and
;		jumps here.
;		Serial_PortHandler checks to see if the interrupt is for
;		us and processes it if so. Else, it lets it go.
;		The interrupts are prioritized in the following order
;
;		1. Line status
;		2. read data avail
;		3. xmit buffer empty
;		4. modem service interrupt
;
;		This handler continues to service till all interrupts have
;		been satisfied
; Entry:
;		ESI -> ComDEB for the port.
;		EAX = IRQ handle
;		EBX = VM handle.
;		Interrupt disabled.
; Exit:
;		CLC if for us, else STC.
; Uses:
;		ALL.
;******************************************************************************

BeginProc Serial_PortHandler, High_Freq, PUBLIC


	test	[esi.pData.LossByte],1	; Q: Do we own the IRQ ?
	jnz	IntReflect		;    N: get out

	mov	edx,[esi.Port]		; get COMM I/O port
	add	dl,ACE_IIDR		; --> interrupt ID register
	in	al,dx
	test	al,1			; Q: interrupts pending
	jnz	IntReflect		;   N:


	mov	ecx,[esi.AddrEvtDWord]	; get the address
	mov	ecx,[ecx]		; get the event dword
	push	ecx
	jmp	IntLoop10

InterruptLoop_ChkTx:


	cmp	[esi.pData.QOutCount],0	; output queue empty?
	je	InterruptLoop		;  Y: Don;t chk Tx


	pop	edx
	push	edx
	dec	edx			; to IER
	.errnz	ACE_IIDR-ACE_IER-1
	in	al,dx
	and	al,NOT ACE_ETBEI	; disable it
	IO_Delay
	IO_Delay
	out	dx,al
	or	al,ACE_ETBEI		; enable it again
	IO_Delay
	IO_Delay
	out	dx,al
	IO_Delay
	IO_Delay
	IO_Delay
	out	dx,al

InterruptLoop:


	pop	edx			; Get ID reg I/O address
	in	al,dx			; get interrupt ID
	test	al,1			; interrupts need servicing ?
	jnz	IntLoop20		; NO, all done


IntLoop10:


	and	eax,07h
	push	edx			; save ID register
	jmp	[SrvTab+eax*2]		; service the interrupt

IntLoop20:


	mov	eax,[esi.EvtMask]	; mask the event dword to only the
	mov	ebx,[esi.AddrEvtDWord]	; get address
	and	eax,[ebx]		; get only user specified bits
	mov	dword ptr [ebx],eax	; set the event dword
	pop	ebx
	test	[esi.NotifyFlagsHI],CN_Notify
	jz	ci_exit
	not	ebx
	and	eax,ebx			; bits set in ax are new events
	jz	ci_exit			; no new event

ci_new_events:

; code added by aek to reenable receive interrupts, 12/19/96
IF 0
IFDEF DEBUG
;    Trace_Out "ci_new_events"
ENDIF
    push    edx
    push    eax
    push    ecx
    mov     edx, [esi.Port]

IF  0
    mov     cx, characterCount
    or      cx, cx
    jz      continueNewEvents

clearDataLoop:
	add	    dl,ACE_LSR-ACE_THR  ;--> Line Status Register
	IO_Delay
	in	    al,dx
	sub	    dl,ACE_LSR-ACE_THR  ;--> Transmitter Holding Register
	test	al,ACE_DR           ; Is there data in the receive buffer register 
                                ; or the fifo?
	jz	    clearDataLoop       ; No data in the register, do not read
    in      al, dx              ; clear the Rx buffer register
    loop    clearDataLoop

    mov     characterCount, cx

continueNewEvents:
ENDIF
    inc     edx
    in      al, dx
    or      al, ACE_ERBFI + ACE_ELSI
    IO_Delay
    out     dx, al
    IO_Delay
    out     dx, al
    IO_Delay
    in      al, dx
    pop     ecx
    pop     eax
    pop     edx
ENDIF

    push    edx
    push    eax
    mov     edx,  [esi.Port]
    add     dl,   ACE_CCR
    xor     ax,   ax
    out     dx,   al
    add     dl,   ACE_ACREG-ACE_CCR
    mov     al,   ACE_RXEN or ACE_TXEN       ; enable receiver, disable transmitter
    out     dx, al                      ; see the TIR2000 data sheet.
    sub     edx, ACE_ACREG-ACE_IER
    mov     al, ACE_ERBFI or ACE_ELSI   ; enable only the receive interrupts (see the TIR2000
    out     dx, al                      ; data sheet.
    pop     eax
    pop     edx

; end of code added by aek.

	mov	eax,CN_EVENT
	call	notify_owner

ci_exit:


;
; We acquire the port by number (1-4). So if the port handle returned
; to us by VCOMM_Acquire_Port is > 4, then we assume that it is actually
; a valid VCD COM handle. In that case, we update the VCD_Last_Use for
; contention detection. If this appears dangerous, we must add a service
; to VCD which takes a handle, validates it and then updates the VCD_Last_Use
; entry.
;

; Modified by DWS

    cmp VcommPresent,0
    je  NP_NoVCD


	mov	edx,[esi.VCD_Data]
	or	dh,dh			; Q: is this a valid handle ?
	jz	NP_NoVCD		;    N:

	VMMCall	Get_Last_Updated_System_Time
	mov	[edx.VCD_Last_Use],eax

NP_NoVCD:


	mov	eax,[esi.IRQHandle]
	VxDCall	VPICD_Phys_EOI		; ack it
	clc				; we handled it
	ret

IntReflect:


	cmp NoReflect,1	     ;DWS
	je  NP_NoVCD		 ;DWS


	stc
	ret

EndProc Serial_PortHandler

;******************************************************************************
;
; ModemStatus
;
; Description:		modem status interrupt handler
;
; Entry:		ESI -> DEB
;			EDX = port.IIDR
;
; Returns:		none
; Uses:
;			EAX,EBX,ECX,EDI,FLAGS.
;
;==============================================================================
BeginProc ModemStatus,PUBLIC

; get the modem status value and shadow it for MSRWait

	add	dl,ACE_MSR-ACE_IIDR	; --> modem status register
	in	al,dx
	mov	ebx,[esi.AddrMSRShadow]
	mov	byte ptr [ebx],al	; save MSR data for others
	mov	ch,al			; save a local copy

; Create the event mask for the delta dignals

	movzx	eax,al
	mov	ah,al			; just a lot of shifting
	shr	eax,2
	shr	ah,1
	shr	eax,3
	and	eax,EV_CTS+EV_DSR+EV_RLSD+EV_Ring
	mov	ebx,[esi.AddrEvtDWord]
	or	dword ptr [ebx],eax

	mov	ah,ch
	shr	ah,2
	and	eax,EV_CTSS+EV_DSRS
	or	dword ptr [ebx],eax

	mov	ah,ch
	shr	ah,3
	and	eax,EV_RLSDS
	or	dword ptr [ebx],eax

	mov	ah,ch
	shl	ah,3
	and	eax,EV_RingTe
	or	dword ptr [ebx],eax

	.errnz	EV_CTS-0000000000001000b
	.errnz	EV_DSR-0000000000010000b
	.errnz	EV_RLSD-0000000000100000b
	.errnz	EV_Ring-0000000100000000b

	.errnz	EV_CTSS-0000010000000000b
	.errnz	EV_DSRS-0000100000000000b
	.errnz	EV_RLSDS-0001000000000000b
	.errnz	EV_RingTe-0010000000000000b

	.errnz	ACE_DCTS-00000001b
	.errnz	ACE_DDSR-00000010b
	.errnz	ACE_DRLSD-00001000b
	.errnz	ACE_RI-01000000b

	.errnz	ACE_TERI-00000100b
	.errnz	ACE_CTS-00010000b
	.errnz	ACE_DSR-00100000b
	.errnz	ACE_RLSD-10000000b

ModemStatus40:
	jmp	InterruptLoop_ChkTx

EndProc ModemStatus

;******************************************************************************
;
; LineStat
;
; Description:  Line Status Interrupt Handler
;		Break detection is handled and set in the event word if
;		enabled.  Other errors (overrun, parity, framing) are
;		saved for the data available interrupt.
;
;		This routine used to fall into DataAvail for the bulk of 
;		its processing. This is no longer the case...  
;		A very popular internal modem seems to operate differently 
;		than a real 8250 when parity errors occur.  Falling
;		into the DataAvail handler on a parity error caused the 
;		same character to be received twice.  Having this routine 
;		save the LSR status, and return to InterruptLoop fixes the
;		problem, and still works on real COMM ports.  The extra 
;		overhead isn't a big deal since this routine is only
;		entered when there is an exception like a parity error.
;
;		This routine is JUMPED to, and will perform a JUMP back into
;		the dispatch loop.
;
; Entry:
;		ESI --> DEB
;		EDX =  Port.IIDR
; Exit:
;		None
; Uses:
;		EAX,EBX,FLAGS
;==============================================================================

BeginProc LineStat,PUBLIC

	mov	ebx,[esi.AddrEvtDWord]
	or	BYTE PTR [ebx],EV_Err	;Show line status error

	add	dl,ACE_LSR-ACE_IIDR	;--> Line Status Register
	in	al,dx
	test	al,ACE_PE+ACE_FE+ACE_OR ;Parity, Framing, Overrun error?
	jz	@f

	mov	[esi.LSRShadow],al	;yes, save status for DataAvail
@@:
	test	al,ACE_BI		;Break detect?
	jz	InterruptLoop_ChkTx	;Not break detect interrupt

	or	BYTE PTR [ebx],EV_Break ;Show break

	jmp	InterruptLoop_ChkTx

LineStat   endp

IF 0
;******************************************************************************
;
; DataAvail
;
; Description:
;		The available character is read and stored in the input queue.
;		If the queue has reached the point that a handshake is needed,
;		one is issued (if enabled).  EOF detection, Line Status errors,
;		and lots of other stuff is checked.
;
;	This routine is jumped to, and will perform a jump back into
;	the dispatch loop.
; Entry:
;		ESI -> DEB
;		EDX = Port.IIDR
; Exit:
;		None.
; Uses:
;		EAX,EBX,ECX,EDI,FLAGS
;
;==============================================================================

BeginProc DataAvail,PUBLIC

	VMMCall	Get_Last_Updated_System_Time	; update this for VCOMM
	mov	[esi.pData.dwLastReceiveTime],eax

	sub	dl,ACE_IIDR-ACE_RBR	;--> receiver buffer register
	in	al,dx			;Read received character
IFDEF DEBUG
    Trace_Out "DataAvail start: character = #AL"
ENDIF

	and	[esi.NotifyFlagsHI], NOT CN_Idle ; flag as not idle

	mov	ah,[esi.LSRShadow]	;what did the last Line Status intrpt
	mov	bh,ah			;  have to say?
	or	ah,ah
	jz	DataAvailNoLSRErr

	and	ah,[esi.ErrorMask]	;there was an error, record it
	or	byte ptr [esi.pData.dwCommError],ah
	mov	[esi.LSRShadow],0
	.errnz	ACE_OR-CE_OVERRUN	;Must be the same bits
	.errnz	ACE_PE-CE_RXPARITY
	.errnz	ACE_FE-CE_FRAME
	.errnz	ACE_BI-CE_BREAK

DataAvailNoLSRErr:
 ;
 ; Regardless of the character received, flag the event in case
 ; the user wants to see it.
 ;
	mov	ecx,[esi.AddrEvtDWord]
	or	byte ptr [ecx],EV_RxChar ;Show a character received
	.errnz HIGH EV_RxChar
 ;
 ; Check the input queue, and see if there is room for another
 ; character.  If not, or if the end of file character has already
 ; been received, then go declare overflow.
 ;
DataAvail00:

	mov	ecx,[esi.pData.QInCount] ;Get queue count (used later too)
	cmp	ecx,[esi.pData.QInSize]	;Is queue full?
	jge	DataAvail20		;  Yes, comm overrun
    jmp DataAvail25 ;   Added by DWS

DataAvail20:

	or	[esi.pData.dwCommError],CE_RXOVER ;Show queue overrun
	jmp	DataAvail140

DataAvail25:
	and	al,[esi.RxMask]		;Remove any parity bits

 ; Finally, a valid character that we want to keep, and we have
 ; room in the queue. Place the character in the queue.
 ; If the discard flag is set, then discard the character
 ;
DataAvail90:
	test	[esi.MiscFlags],Discard	;Discarding characters ?
	jnz	DataAvail140		;  Yes

	mov	edi,[esi.pData.QInAddr]	;Get queue base pointer

	mov	ebx,[esi.pData.QInPut]	;Get index into queue
	mov	BYTE PTR [ebx+edi],al	;Store the character
	inc	ebx			;Update queue index
	cmp	ebx,[esi.pData.QInSize]	;See if time for wrap-around
	jc	DataAvail100		;Not time to wrap
	xor	ebx,ebx			;Wrap-around is a new zero pointer

DataAvail100:
	mov	[esi.pData.QInPut],ebx	;Store updated pointer
	inc	ecx			;And update queue population
	mov	[esi.pData.QInCount],ecx

DataAvail130:
	and	[esi.NotifyFlagsHI], NOT CN_RECEIVE

DataAvail140:
	pop	edx
	push	edx
	add	dl, ACE_LSR-ACE_IIDR
	in	al, dx
	test	al, ACE_DR		;Q: more data available?
	jz	@F			;   N:
	sub	dl, ACE_LSR		;   Y: go read it
	IO_Delay
	IO_Delay
	in	al, dx			;Read available character
	jmp	DataAvail00
@@:
	jmp	InterruptLoop_ChkTx

EndProc DataAvail
ENDIF

BeginProc DataAvail,PUBLIC

	VMMCall	Get_Last_Updated_System_Time	; update this for VCOMM
	mov	[esi.pData.dwLastReceiveTime],eax

	sub	dl,ACE_IIDR-ACE_RBR	;--> receiver buffer register
	in	al,dx			;Read received character

	and	[esi.NotifyFlagsHI], NOT CN_Idle ; flag as not idle

	mov	ah,[esi.LSRShadow]	;what did the last Line Status intrpt
	mov	bh,ah			;  have to say?
	or	ah,ah
	jz	DataAvailNoLSRErr

IF  0
	test	ah,ACE_OR
	jz	@F
	inc	[esi.OverrunErrors]
@@:
	test	ah,ACE_PE
	jz	@F
	inc	[esi.ParityErrors]
@@:
	test	ah,ACE_FE
	jz	@F
	inc	[esi.FramingErrors]
@@:
ENDIF

	and	ah,[esi.ErrorMask]	;there was an error, record it
	or	byte ptr [esi.pData.dwCommError],ah
	mov	[esi.LSRShadow],0
	.errnz	ACE_OR-CE_OVERRUN	;Must be the same bits
	.errnz	ACE_PE-CE_RXPARITY
	.errnz	ACE_FE-CE_FRAME
	.errnz	ACE_BI-CE_BREAK

DataAvailNoLSRErr:
 ;
 ; Regardless of the character received, flag the event in case
 ; the user wants to see it.
 ;
	mov	ecx,[esi.AddrEvtDWord]
	or	byte ptr [ecx],EV_RxChar ;Show a character received
	.errnz HIGH EV_RxChar
 ;
 ; Check the input queue, and see if there is room for another
 ; character.  If not, or if the end of file character has already
 ; been received, then go declare overflow.
 ;
DataAvail00:

	mov	ecx,[esi.pData.QInCount] ;Get queue count (used later too)
	cmp	ecx,[esi.pData.QInSize]	;Is queue full?
	jge	DataAvail20		;  Yes, comm overrun
    jmp DataAvail25 ;   Added by DWS

DataAvail20:

	or	[esi.pData.dwCommError],CE_RXOVER ;Show queue overrun
	jmp	DataAvail140

DataAvail25:
	and	al,[esi.RxMask]		;Remove any parity bits

 ; Finally, a valid character that we want to keep, and we have
 ; room in the queue. Place the character in the queue.
 ; If the discard flag is set, then discard the character
 ;
DataAvail90:
	test	[esi.MiscFlags],Discard	;Discarding characters ?
	jnz	DataAvail140		;  Yes

	mov	edi,[esi.pData.QInAddr]	;Get queue base pointer

	mov	ebx,[esi.pData.QInPut]	;Get index into queue
	mov	BYTE PTR [ebx+edi],al	;Store the character
	inc	ebx			;Update queue index
	cmp	ebx,[esi.pData.QInSize]	;See if time for wrap-around
	jc	DataAvail100		;Not time to wrap
	xor	ebx,ebx			;Wrap-around is a new zero pointer

DataAvail100:
	mov	[esi.pData.QInPut],ebx	;Store updated pointer
	inc	ecx			;And update queue population
	mov	[esi.pData.QInCount],ecx

DataAvail130:
	and	[esi.NotifyFlagsHI], NOT CN_RECEIVE

DataAvail140:
	pop	edx
	push	edx
	add	dl, ACE_LSR-ACE_IIDR
	in	al, dx
	test	al, ACE_DR		;Q: more data available?
	jz	@F			;   N:
	sub	dl, ACE_LSR		;   Y: go read it
	IO_Delay
	IO_Delay
	in	al, dx			;Read available character
	jmp	DataAvail00
@@:
	jmp	InterruptLoop_ChkTx

EndProc DataAvail

;******************************************************************************
;
; XmitEmpty
;
; Description:
;		handles the case whne transmitter empty interrupt occurs.
;		This is JUMPED TO AND OUT OF!!!!
;
; Entry:	EDX = Port.IIDR
;		ESI -> DEB
; Exit:		None
; Uses:		EAX,EBX,ECX,EDI,FLAGS
;
;==============================================================================
BeginProc XmitEmpty,PUBLIC

	add	dl,ACE_LSR-ACE_IIDR	;--> Line Status Register
	IO_Delay
	in	al,dx			;Is xmit really empty?
	sub	dl,ACE_LSR-ACE_THR	;--> Transmitter Holding Register
	test	al,ACE_THRE
	jz	XmitEmpty90		;Transmitter not empty, cannot send

XmitEmpty5:
	mov	    ah,[esi.HSFlag]		; Get handshaking flag
	test	ah,CannotXmit		; Anything preventing transmission?
	jnz	XmitEmpty100		    ; Yes, disarm and exit

XmitEmpty515:
	mov	ecx,[esi.pData.QOutCount] ;Output queue empty?
	jecxz	XmitEmpty90		    ;  Yes, go set an event

	test	[esi.EFlags],fNOFifo OR fNoTxFifo ; Q: Is FIFO present ?
	jz	    XmitEmptyOptimize	;  Y:  optimization

XmitEmptyNoOptimize:
	jmp XmitEmpty55

; no more characters to transmit. Flag this as an event.

XmitEmpty90:
; code added by aek, 12/19/96
IF 0
    push    edx
    push    eax
    mov     edx, [esi.Port]
    in      al, dx
    or      al, ACE_ERBFI + ACE_ELSI
    IO_Delay
    out     dx, al
    IO_Delay
    out     dx, al
    pop     eax
    pop     edx
ENDIF

    push    edx
    push    eax
    mov     edx, [esi.Port]
    add     dl, ACE_CCR
    xor     eax, eax
    out     dx, al
    add     dl, ACE_ACREG-ACE_CCR
;    mov     al, ACE_RXEN              ; Enable only the receiver.  See the TIR2000 data sheet
    mov     al, ACE_TXEN or ACE_RXEN
    out     dx, al
    sub     dl, ACE_ACREG-ACE_IER     ; Enable only the receive interrupts.  See the TIR2000
    mov     al, ACE_ERBFI or ACE_ELSI ; data sheet
    out     dx, al
    pop     eax
    pop     edx

; end of code added by aek.
	mov	ebx,[esi.AddrEvtDWord]
	or	byte ptr [ebx],EV_TxEmpty
 ;
 ; Cannot continue transmitting (for any of a number of reasons).
 ; Disable the transmit interrupt.  When it's time resume, the
 ; transmit interrupt will be reenabled, which will generate an
 ; interrupt.
 ;
XmitEmpty100:
	inc	edx			;--> Interrupt Enable Register
	.errnz	ACE_IER-ACE_THR-1
	in	al,dx			;I don't know why it has to be read
	and	al,NOT ACE_ETBEI	;  first, but it works this way
XmitEmpty110:
	IO_Delay
	IO_Delay
	out	dx,al
	jmp	InterruptLoop

XmitEmpty55:
XmitEmpty59:
	mov	edi,[esi.pData.QOutAddr] ; get queue base pointer
	mov	ebx,[esi.pData.QOutGet]	; get ptr into queue
	mov	al,[ebx+edi]		; get char

	inc	ebx			; update q pointer
	cmp	ebx,[esi.pData.QOutSize] ; time for wrap-around?
	jc	XmitEmpty60		;  Nope
	xor	ebx,ebx			; wrap by zeroing index

XmitEmpty60:
	mov	[esi.pData.QOutGet],ebx	; save queue index
	mov	ecx,[esi.pData.QOutCount] ; output queue empty?
	dec	ecx			; dec # of bytes in queue
	mov	[esi.pData.QOutCount],ecx ;  and save new population

	out	dx,al			; send char
IFDEF DEBUG
;    Trace_Out "XmitEmpty: character = #AL"
ENDIF

IF 0
    inc characterCount  ; keep track of the number of characters sent for cleanup later

	add	dl,ACE_LSR-ACE_THR	;--> Line Status Register
	IO_Delay
	in	al,dx
	sub	dl,ACE_LSR-ACE_THR	;--> Transmitter Holding Register
	test	al,ACE_DR       ; Is there data in the receive buffer register or the fifo?
	jz	XmitEmptyMerge      ; No data in the register, do not read
    mov ax, characterCount
    or  ax, ax              ; Is the data in the Rx buffer good data?
    jz  XmitEmptyMerge      ; Yes, do not read here.
    in  al, dx              ; clear the Rx buffer register
    dec characterCount
ENDIF

XmitEmptyMerge:

	mov	ebx,[esi.AddrEvtDWord]
	or	dword ptr [ebx],EV_TXCHAR ; set the flag so that user can see

	cmp	ecx,[esi.SendTrigger]	; Q: time to call owners' callback?
	jae	InterruptLoop		;  N:

	test	[esi.NotifyFlagsHI],CN_TRANSMIT
	jnz	InterruptLoop		; jump if notify has been sent and
					; data in buffer hasn't raised above
					; threshold
	push	OFFSET32 InterruptLoop
	mov	eax,CN_TRANSMIT
	jmp	notify_owner

EndProc XmitEmpty

PUBLIC XmitEmptyOptimize
XmitEmptyOptimize:

	mov	ecx,[esi.pData.QOutCount]
	cmp	ecx,16
	jbe	XEO_LessThanSizeOfFIFO
	mov	ecx,16

XEO_LessThanSizeOfFIFO:

	sub	[esi.pData.QOutCount],ecx ; final count of chars left
	mov	edi,[esi.pData.QOutAddr] ; Base of Xmit Queue
	mov	ebx,[esi.pData.QOutGet]	; offset into q to get data from

XEO_CharBlastLoop:

	mov	al,[ebx+edi]
	out	dx,al
IFDEF DEBUG
;    Trace_Out "XmitEmptyOptimize:  character = #AL"
ENDIF

IF 0
    inc characterCount      ; keep track of the number of characters transmitted so
                            ; that they can be cleared before getting the real data.

	add	dl,ACE_LSR-ACE_THR	;--> Line Status Register
	IO_Delay
	in	al,dx
	sub	dl,ACE_LSR-ACE_THR	;--> Transmitter Holding Register
	test	al,ACE_DR       ; Is there data in the receive buffer register or the fifo?
	jz	XEO_continue        ; No data in the register, do not read

    mov ax, characterCount
    or  ax, ax              ; Is the data in the Rx buffer good data?
    jz  XEO_continue        ; Yes, do not read here.
    in  al, dx              ; clear the Rx buffer register
    dec characterCount

XEO_continue:
ENDIF
	inc	ebx
	cmp	ebx,[esi.pData.QOutSize]
	jc	XEO_NoWrapYet
	xor	ebx,ebx

XEO_NoWrapYet:

	loop	XEO_CharBlastLoop

	mov	[esi.pData.QOutGet],ebx
	mov	ecx,[esi.pData.QOutCount]
	jmp	XmitEmptyMerge

;******************************************************************************
;
; Serial_Not_Executeable
;
;
; VPICD masks off the physical interrupt at VM_Not_Executeable time if no
; VM has the IRQ unmasked. Since VPICD does not keep track of how many
; times a VxD has unmasked an interrupt, it masks off the interrupt we are
; handling. So, we call VPICD_Physically_Unmask for the interrupts handled by
; us.
;
; Entry:
;	EBX = VM Handle to destroy
;
; Exit:
;	Carry set if error
; Uses:
;	ALL
;==============================================================================
BeginProc Serial_Not_Executeable,PUBLIC

	mov	ecx,[ActiveCOMs]		; Q: Are an COMM port active?

NNE_Loop:
	bsf	edi,ecx				; find the first active port
	jz	NNE_Done			; No active ports left
	btr	ecx,edi				; done with it
	mov	edi,[PortInfoPtrs+edi*4]	; get its handle
	mov	eax,[edi.IRQHandle]
	VxDCall	VPICD_Physically_Unmask
	jmp	NNE_Loop

NNE_Done:
	clc
	ret

EndProc Serial_Not_Executeable

VxD_Locked_Code_Ends

	end
