	PAGE	58,132
;******************************************************************************
; SERFUNC.ASM	- Port driver for 8250/16550AFN.
;******************************************************************************
;
; (C) Copyright Microsoft Corp. 1992-1995
;
; TITLE:	SERFUNC.ASM
;
; Version:	1.0
;
; Date:		01/02/93
;
; Author:	sandeeps
;
;==============================================================================
;
; Change log:
;
;==============================================================================

	.386p

;******************************************************************************
;			INCLUDE files
;******************************************************************************

	.xlist
    include VMM.INC
    include VCOMM.INC     
    include IRCOMM31.inc         ; Added by DWS  Jan 12, 1996
	include	DEBUG.INC
	include	OPTTEST.INC
	include	VPICD.INC
	include	INTERN31.INC
	include	INS8250.INC
	include	SHELL.INC
    INCLUDE MSGMACRO.INC
    INCLUDE SERMSG31.INC
   .list

;******************************************************************************
;			LOCKED DATA
;==============================================================================

VxD_Locked_Data_Seg

	EXTRN	Serial_PortHandlerArray:BYTE
	EXTRN	PortInfoPtrs:DWORD
	EXTRN	ActiveCOMs:DWORD
	EXTRN	SysVMHandle:DWORD

Serial_IRQ_Desc	VPICD_IRQ_Descriptor <0>

	PUBLIC	TimeOutHandle

TimeOutHandle	dd	0

PUBLIC	IRQInfoArray
IRQInfoArray	label	BYTE
??IrqNum = 1
REPT MAXCOM+1
	db	SIZE IRQStruc	DUP (0)
??IrqNum = ??IrqNum + 1
ENDM

VxD_Locked_Data_Ends

VxD_My_Pageable_Data_Seg

IFDEF WIN31COMPAT
       EXTRN   Serial_IRQ_Conflict_Msg:BYTE
ENDIF

myCommprop label	DWORD 
	dw	SIZE _COMMPROP			; length of struct
	dw      1				; version
	dd	SP_SERIALCOMM			; services provided
	dd	0				; dwReserved1
	dd	0				; dwMaxTxQueue
	dd	0				; dwmaxRxQueue
	dd	BAUD_128K			; dwMaxBaud
	dd	PST_RS232			; specific COMM provider type
	dd	01FFh				; flow control caps
	dd	007Fh				; dwSettable params
	dd	01FFFFh				; dwSettableBaud
	dw	0Fh				; wSettableDataBits
	dw	01F7h				; wSettableParityStop
	dd	0				; dwCurrentTxQueue
	dd	0				; dwCurrentRxQueue
	dd	0				; dwProvSpec1
	dd	0				; dwProvSpec2
	dw	0				; wcProvChar1
	dw	0
.errnz ($ - myCommProp - SIZE _COMMPROP)

VxD_My_Pageable_Data_Ends

; Added by DWS on June 16, 1996 for Fast IR
VxD_Locked_Code_Seg

  EXTRN _IR_PortOpen:NEAR
  EXTRN _IR_PortClose:NEAR
  EXTRN _IR_CheckSpeed:NEAR
  EXTRN _IR_PortWrite:NEAR
  EXTRN _IR_PortRead:NEAR

VxD_Locked_Code_Ends
; end of code added by DWS

;******************************************************************************
;			PAGEABLE CODE
;==============================================================================

VxD_My_Pageable_Code_Seg

	EXTRN	GetCOMPort:NEAR
	EXTRN	ReleaseCOMPort:NEAR
	EXTRN	TXI:NEAR
	EXTRN	FlagNotActive:NEAR
	EXTRN	SetCom100:NEAR
	EXTRN	SetCom300:NEAR
	EXTRN	SetCom400:NEAR
	EXTRN	TrmCom:NEAR
	EXTRN	StaCom:NEAR
	EXTRN	ExtnFcn:NEAR
	EXTRN	Flush:NEAR
	EXTRN	ReadCommString:NEAR
	EXTRN	WriteCommString:NEAR
	EXTRN	UnMaskIRQ:NEAR
; DWS	EXTRN	TimerProc:NEAR
	EXTRN	StealPort:NEAR
	EXTRN	Notify_Owner:NEAR

BeginDoc
;******************************************************************************
;
; PPortInformation
; PortOpen (char *PortName, ulong Mode, ulong VMId, ulong *lpError);
;
; Open a port. This assumes that VCOMM called here only
; when it knows that we can support the port. It does not validate 
; parameters because of this assumption.
;
; Parameters:
;		PortName	-> Non-null if open port using name
;		VMId		-> Id of the caller
;		lpError		-> location to update error in
;
; Returns:
;		PortHandle if successful, else 0
;		Updates to *lpError are
;		IE_OPEN		port already open
;		IE_HARDWARE	hardware error
;		IE_DEFAULT	generic error
;==============================================================================
EndDoc
BeginProc PortOpen, CCALL, PUBLIC

ArgVar	PortName,DWORD
ArgVar	VMId,DWORD
ArgVar	lpError,DWORD

	EnterProc
	push	esi
	push	edi
	push	ebx

IFDEF DEBUG
	Trace_Out "SERIAL31: PortOpen"
ENDIF

	mov	esi,PortName
	movzx	eax,BYTE PTR [esi+3]	; get x from COMx. Support only COM1-4.
	sub	al,'1'			; base starts from 0.
	mov	esi,PortInfoPtrs[eax*4] ; get pointer to correct struct
	or	esi,esi			; does port exist ?
	jz	InitCom27

	cmp	[esi.pData.ValidPortData],'SMTF' ; Q: Is port already open ?
	je	InitCom17		;  Y: say so

	mov	eax,VMId		; get port for this VM
	call	GetCOMPort		; ask Mr. VCOMM to asign the port
	jnz	InitCom35		; continue
	jz	InitCom17		; did not give us the port.

InitCom26:
	call	ReleaseCOMPort		; give it back to VCD

InitCom27:
	mov	eax,IE_HARDWARE		; report lack of hardware
	jmp	PO_Done

InitCom17:
	mov	eax,IE_OPEN
	cmp	[esi.Port],-1		; Q: Does port exist ?
	jne	PO_Done			;   Y: return IE_OPEN
	jmp	InitCom27		;   N: return IE_HARDWARE

InitCom35:

  ; Code added by DWS on June 16, 1996 for Fast IR
  cCall _IR_PortOpen, <esi>
  cmp eax,0
  je  InitCom26
  ; end of code added by DWS

	movzx	eax,[esi.IRQn]
	mov	edi, OFFSET32 Serial_IRQ_Desc ; fill out IRQ_Number etc.
	mov	[edi.VID_IRQ_Number],ax
	mov	eax,[esi.DEBId]
	dec	eax
	shl	eax,2
	add	eax, OFFSET32 Serial_PortHandlerArray
	mov	eax,[eax]
	mov	[edi.VID_Hw_Int_Proc],eax
	mov	[edi.VID_Options],VPICD_Opt_Can_Share
	VxDCall	VPICD_Virtualize_IRQ
	jnc	InitCom59
;
; message box here to state IRQ conflict
;
	pushad
IFDEF WIN31COMPAT
        mov     ecx,OFFSET32 Serial_IRQ_Conflict_Msg
ELSE
        PUSH_SPRINTF <MSG_Serial_IRQ_Conflict_Msg>
        xchg    eax,ecx                                ; ECX = MSG
ENDIF
        mov     eax,MB_OK+MB_ASAP+MB_ICONEXCLAMATION+MB_NOWINDOW+MB_SYSTEMMODAL
        xor     edi,edi                 ; Use VM name for caption
	xor	esi,esi			; no call back
	VMMCall	Get_Sys_VM_Handle	; use sys vm's handle
	VxDCall	SHELL_SysModal_Message	; send message to Windows
IFNDEF WIN31COMPAT
        POP_SPRINTF
ENDIF
	popad
	jmp	InitCom26

InitCom59:
	mov	[esi.IRQHandle],eax	; save handle
 ;
 ; We check if we have virtualized this IRQ before. If not, then
 ; we will remember whether it is physically masked
 ;
	mov	edx,[esi.MyIRQStruc]	; IRQ struct for this port
	inc	[edx.VirtCnt]		; increment the virt count
	cmp	[edx.VirtCnt],1		; Q: Have we virtualized it before ?
	ja	InitCom_SkipMaskCheck	;  Y: Depend on the 1st virtualization
	mov	eax,[esi.IRQHandle]
	mov	ebx,[SysVMHandle]
	VxDCall	VPICD_Get_Complete_Status
	and	cl,VPICD_STAT_PHYS_MASK	; just remember if physically masked
	mov	[edx.OldMask],cl

InitCom_SkipMaskCheck:
 ;
 ; Zero Queue counts and indices.
 ;
	lea	edi,[esi.pData.QInCount]
	xor	eax,eax
	mov	ecx,(_PortData.ValidPortData-_PortData.QInCount)/4
	cld
	rep	stosd

	.errnz	_PortData.QInGet-_PortData.QInCount-4
	.errnz	_PortData.QInPut-_PortData.QInGet-4
	.errnz	_PortData.QOutCount-_PortData.QInPut-4
	.errnz	_PortData.QOutGet-_PortData.QOutCount-4
	.errnz	_PortData.QOutPut-_PortData.QOutGet-4
	.errnz	_PortData.ValidPortData-_PortData.QOutPut-4

	mov	[esi.HSFlag],al		; show no handshaking yet
	mov	[esi.MiscFlags],al	; show no discarding
	mov	[esi.pData.LossByte],al	; reset who owns the port
	mov	[esi.SendTrigger],eax
	mov	[esi.NotifyFlags],eax	; reset all flags
	dec	eax
	mov	[esi.RecvTrigger],eax
	mov	[esi.ComDCB.BitMask],fBinary

	mov	edx,[esi.Port]
	add	dl,ACE_FCR		; EDX -> FCR
	in	al,dx
	test	al,ACE_FIFO_E2		; Q: FIFO already on ?
	jz	@F			;    N:
	or	[esi.EFlags],fFIFOpre	;    Y: flag it
@@:

	lea	edi,[esi.pData.dwDetectedEvents] ; initial AddrEvtDWord
	mov	[esi.AddrEvtDword],edi	; set it
	lea	edi,[esi.pData.bMSRShadow] ; initial AddrMSRShadow
	mov	[esi.AddrMSRShadow],edi	; set it

	and	[esi.EFlags],fEFlagsMask ; clear internal state
	xor	eax,eax			; no errors
	mov	[esi.pData.dwCommError],eax ; reset pending bogus error codes

PO_Done:
	mov	ebx,lpError
	mov	[ebx],eax		; save error for caller

;********************************************************
;
; The following code was changed by DWS on June 13, 1995
; This code fixes a contention bug.

;	or	esi,esi
;	jz	PO_Failure
	or	eax,eax
	jnz	PO_Failure

; end of changed by DWS
;
;********************************************************

	mov	ebx,VMId		; get owner of VM
	mov	[esi.OwnerVM],ebx	; save it
IFNDEF	WIN31COMPAT
	VMMCall	Get_Cur_Thread_Handle	; get owner thread
	mov	[esi.OwnerThread],edi	; save it
ENDIF
	mov	[esi.pData.dwLastError],eax ; save error code
	or	eax,eax			; is everything ok ?
	mov	eax,esi			; assume OK return handle!
	jz	PO_Success

PO_Failure:
	xor	eax,eax			; FALSE

PO_Success:
	pop	ebx
	pop	edi
	pop	esi
	LeaveProc
	return

EndProc PortOpen


BeginDoc
;******************************************************************************
;
; BOOL
; PortGetState(HPORT hPort, DCB *pDcb);
;
; Parameters:
;		hPort	=  port handle
;		pDcb	-> DCB to fill in
; Returns:
;		TRUE if OK, else false.
;==============================================================================
EndDoc
BeginProc PortGetState, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pDcb,DWORD

	EnterProc

	push	esi
	push	edi
	push	ebx

	xor	eax,eax				; access to 0
	mov	esi,hPort
	mov	[esi.pData.dwLastError],eax	; no error
	lea	esi,[esi.ComDCB]
	mov	edi,pDcb
	mov	ecx,(SIZE _DCB)/4
	cld
	rep	movsd

	inc	eax				; success

	pop	ebx
	pop	edi
	pop	esi

	LeaveProc
	return

EndProc PortGetState

BeginDoc
;******************************************************************************
;
; BOOL
; PortClose(HPORT hPort);
;
; Parameters:
;		hPort	= port handle
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortClose, CCALL, PUBLIC

ArgVar	hPort,DWORD

	EnterProc
	push	esi
	push	edi
	push	ebx

  ; Code added by DWS on June 16, 1996 for Fast IR
  cCall _IR_PortClose, <hPort>
  ; End of code added by DWS

	mov	esi,hPort		; esi -> port information
	mov	eax,[esi.DEBId]		; TrmCom expects this ?
	dec	eax
	call	TrmCom

PClose_Done:
	mov	[esi.pData.dwLastError],eax
	or	eax,eax			; Q: Errors ?
	jnz	PClose_Failed		;    Y:

	test	[esi.MiscFlags],RxQInternal	; N: free if we alloced them
	jz	PClose_RxFree
	VMMCall	_HeapFree,<[esi.pData.QInAddr],0>

PClose_RxFree:
	test	[esi.MiscFlags],TxQInternal
	jz	PClose_TxFree
	VMMCall	_HeapFree,<[esi.pData.QOutAddr],0>

PClose_TxFree:

;DWS	call	ManageTimer
	xor	eax,eax
	inc	eax
	jmp	PClose_Success

PClose_Failed:
	xor	eax,eax

PClose_Success:
	pop	ebx
	pop	edi
	pop	esi

	LeaveProc
	return

EndProc PortClose

BeginDoc
;******************************************************************************
;
; BOOL
; PortSetModemStatusShadow(HPORT hPort, ulong EventMask, BYTE *MSRShadow);
;
; Parameters:
;		hPort	= port handle
;		EventMask = event mask
;		MSRShadow = Addr to update WIN 3.1 style MSRShadow.
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortSetModemStatusShadow, esp, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	MSRShadow,DWORD

	EnterProc
	mov	edx,hPort
	mov	ecx,MSRShadow
	mov	[edx.AddrMSRShadow],ecx
	xor	eax,eax				; access to 0
	mov	[edx.pData.dwLastError],eax
	inc	eax
	LeaveProc
	return

EndProc PortSetModemStatusShadow

BeginDoc
;******************************************************************************
;
; BOOL
; PortGetProperties(HPORT hPort, COMMPROP *pCommprop);
;
; Parameters:
;		hPort	= port handle
;		pCommprop -> property structure to fill in
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortGetProperties, esp, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pCommprop,DWORD

	EnterProc

	SaveReg	<esi,edi>

	mov	esi,myCommProp
	mov	edi,pCommProp
	mov	ecx,SIZE _COMMPROP
	cld
	rep	movsb
	mov	edx,hPort			; edx -> hPort
	xor	eax,eax
	mov	[edx.pData.dwLastError],eax	; EAX is 0, no error
	inc	eax

	RestoreReg <edi,esi>
	LeaveProc
	return

EndProc PortGetProperties

BeginDoc
;******************************************************************************
;
; BOOL
; PortPurge(HPORT hPort, DWORD dwQueue);
;
; Parameters:
;		hPort	= port handle
;		dwQueue = queue type
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortPurge, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	dwQueue,DWORD

	EnterProc
	push	esi
	push	ebx

	mov	esi,hPort
	mov	ebx,dwQueue
	call	Flush
PP_Done:
	xor	eax,eax				; access to 0
	mov	[esi.pData.dwLastError],eax
	inc	eax				; success

	pop	ebx
	pop	esi
	LeaveProc
	return

EndProc PortPurge

BeginDoc
;******************************************************************************
;
; BOOL
; PortSetEventMask(HPORT hPort, long EventMask, WORD *EventMaskLocation);
;
; Parameters:
;		hPort			= port handle
;		EventMask		= event mask to set
;		EventMaskLocation	= location of event mask DWORD.
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortSetEventMask, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	EventMask,DWORD
ArgVar	EventMaskLoc,DWORD

	EnterProc

	mov	edx,hPort
	mov	eax,EventMask		; get event mask to set
	mov	[edx.EvtMask],eax	; set it
	mov	ecx,EventMaskLoc	; get new location of event dword
	jecxz	PSEM_NoNewLoc		; set it only if non-zero
	mov	[edx.AddrEvtDWord],ecx
PSEM_NoNewLoc:
	xor	eax,eax			; access to 0
	mov	[edx.pData.dwLastError],eax ; no error
	inc	eax

	LeaveProc
	return

EndProc PortSetEventMask

BeginDoc
;******************************************************************************
;
; BOOL
; PortEnableNotification(HPORT hPort, PFN lpFunc, ulong RefData);
;
; Parameters:
;		hPort	= port handle
;		lpFunc	-> pointer to function to call
;		RefData	= pass in this data while calling
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortEnableNotification, CCALL, esp, PUBLIC

ArgVar	hPort,DWORD
ArgVar	lpFunc,DWORD
ArgVar	RefData,DWORD

	EnterProc

	mov	edx,hPort
	mov	ecx,lpFunc
	mov	eax,RefData
	mov	[edx.ReferenceData],eax	; save reference data here
	mov	[edx.NotifyHandle],ecx	; save proc to call
	and	[edx.NotifyFlagsHI], NOT CN_Notify ; assume turning off notify
	jecxz	@F			; Q: Is assumption correct ?

	cli
	or	[edx.NotifyFlagsHI], CN_Notify	;    N: say so
	mov	ecx,[edx.AddrEvtDword]	; get accumulated events address
	mov	eax,[edx.EvtMask]	; detected events client is
	and	eax,[ecx]		; is interested in
	sti

	or	eax,eax			; Q: Any events seen yet ?
	jz	@F			;    N:
	SaveReg	<esi>
	mov	esi,edx
	mov	eax,CN_EVENT
	call	Notify_Owner
	RestoreReg <esi>
@@:
	xor	eax,eax			; access to 0
	mov	[edx.pData.dwLastError],eax ; no error for this function
	inc	eax

	LeaveProc
	return

EndProc PortEnableNotification

;******************************************************************************
;
; BOOL
; PortSetReadCallBack(HPORT hPort, ulong RxTrigger, ulong RxCallBack,
;		      ulong RxRefData);
;
; Parameters:
;		hPort	   = port handle of an open port
;		RxTrigger  = high watermask for receive queue
;		RxCallBack = when receive population becomes greater than
;			     the RxTrigger this procedure is called.
;		RxRefData  = RxCallBack is called with this reference data
;
; Returns:
;		TRUE if OK, else FALSE.
;
;==============================================================================

BeginProc PortSetReadCallBack,CCALL,PUBLIC

ArgVar	hPort,DWORD
ArgVar	RxTrigger,DWORD
ArgVar	RxCallBack,DWORD
ArgVar	RxRefData,DWORD

	EnterProc
	push	esi
	push	ebx


    xor	eax,eax	   ; Return Failure (IR never calls this)

	pop	ebx
	pop	esi

	LeaveProc
	return

EndProc PortSetReadCallBack


;******************************************************************************
;
; BOOL
; PortSetWriteCallBack(HPORT hPort, ulong TxTrigger, ulong TxCallBack,
;		      ulong TxRefData);
;
; Parameters:
;		hPort	   = port handle of an open port
;		TxTrigger  = low watermask for xmit queue
;		TxCallBack = when xmit population becomes less than
;			     the TxTrigger this procedure is called.
;		TxRefData  = TxCallBack is called with this reference data
;
; Returns:
;		TRUE if OK, else FALSE.
;
;==============================================================================

BeginProc PortSetWriteCallBack,CCALL,PUBLIC

ArgVar	hPort,DWORD
ArgVar	TxTrigger,DWORD
ArgVar	TxCallBack,DWORD
ArgVar	TxRefData,DWORD

	EnterProc

	push	esi
	push	ebx

	xor	eax,eax	 ; Return Failure (IR never calls this)

	pop	ebx
	pop	esi

	LeaveProc
	return

EndProc PortSetWriteCallBack

;******************************************************************************
;
; BOOL PortGetModemStatus(HPORT hPort, DWORD *pModemStatus);
;
; Parameters:
;		hPort -> port handle
;		pModemStatus -> return current modem status
;
; Exit:
;	if True, *pModemStatus contains the status
;
;==============================================================================
BeginProc PortGetModemStatus, CCALL, esp, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pModemStatus,DWORD

	EnterProc
	mov	edx,hPort
	mov	edx,[edx.Port]		; edx = base port
	add	dl,ACE_MSR		; edx = MSR register
	in	al,dx			; get current value
	and	eax,MS_Modem_Status	; isolate bits of interest
	mov	edx,pModemStatus	; edx -> fill data here
	mov	dword ptr [edx],eax	; fill it
	xor	eax,eax
	inc	eax			; success
	LeaveProc
	return

EndProc PortGetModemStatus

VxD_My_Pageable_Code_Ends

;******************************************************************************
;			LOCKED CODE
;==============================================================================

VxD_Locked_Code_Seg

BeginDoc
;******************************************************************************
;
; BOOL
; PortGetQueueStatus(HPORT hPort, COMSTAT *pComstat);
;
; Parameters:
;		hPort	= port handle
;		pComstat -> status structure of queue to fill in.
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortGetQueueStatus, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pComstat,DWORD

	EnterProc

	push	esi
	push	ebx
	mov	esi,hPort
	mov	ebx,pComstat
	call	StaCom

	xor	eax,eax
	mov	[esi.pData.dwLastError],eax
	inc	eax

	pop	ebx
	pop	esi
	LeaveProc
	return

EndProc PortGetQueueStatus

BeginDoc
;******************************************************************************
;
; BOOL
; PortSetState(HPORT hPort, DCB *pDcb, long ActionMask);
;
; Parameters:
;		hPort		-> Port handle
;		pDcb		-> DCB to set from
;		ActionMask	= dword specifying relevant DCB fields.
; Returns:
;		TRUE if OK, else false.
;==============================================================================
EndDoc
BeginProc PortSetState, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pDcb,DWORD
ArgVar	ActionMask,DWORD

	EnterProc
	push	esi
	push	edi
	push	ebx

; Added by DWS on June 16, 1996 for Fast IR

  cCall     _IR_CheckSpeed, <hPort,pDcb,ActionMask>
  cmp       eax,0
  jz        @f
  jmp       PSS_Success
@@:
; End of code added by DWS

	cld
	mov	esi,hPort		; ESI -> PortInformation

	test	[esi.pData.LossByte],1	; Q: Do we own the port
	jz	PSS_SerialOwnsPort	;    Y: continue
	call	StealPort		;    N: try to steal it
	mov	eax,IE_Default		; assume failure to steal
	jz	PSS_Done		; jump if failed

PSS_SerialOwnsPort:
	mov	ebx,pDcb		; EBX -> DCB
	TestMem	ActionMask,fBaudRate	; is client interested in setting baud?
	jz	PSS_NoBaudCheck
	call	SetCom300		; Baud rate valid ?
	jecxz	PSS_D0			;  No, return error

PSS_NoBaudCheck:
	TestMem	ActionMask,<fByteSize OR fbParity OR fStopBits>
	jz	PSS_NoLCRCheck
	call	SetCom400		; validate Byte size/parity/stop bits
	jnc	PSS_NoLCRCheck

PSS_D0:
	jmp	PSS_Done

PSS_NoLCRCheck:
 ;
 ; Parameters seem correct. Copy relevant DCB fields into our
 ; space and initialize ACE with relevant parameters.
 ;
	mov	edx,[esi.Port]		; disable interrupts first
	inc	edx
	.errnz	ACE_IER-1
	xor	eax,eax

	out	dx,al
	call	FlagNotActive

	mov	ecx,ActionMask
	call	SetCom100		; Copy DCB selectively!
	lea	ebx,[esi.ComDCB]	; set EBX -> DCB

PSS_NoTimeoutSet:

	add	dl,2			; --> LCR
	TestMem	ActionMask, <fByteSize OR fbParity OR fStopBits>
	jz	PSS_NoLCRSet
	call	SetCom400		; get line control byte
	push	eax			; and save LCR value
	.errnz	ACE_LCR-ACE_IER-2
IF 0
	or	al,ACE_DLAB		; access divisor latch
ENDIF
	out	dx,al
	mov	[esi.RxMask],ah		; save Receive char mask
	mov	eax,edi			; get flag mask, error mask
	and	byte ptr [esi.ComDCB.BitMask],ah ; disable parity checking
					; if no parity
	mov	[esi.ErrorMask],al	; save line status error mask
	pop	eax

PSS_NoLCRSet:
	TestMem	ActionMask,fBaudRate
	jz	PSS_NoBaudSet

	push	eax
	call	SetCom300		; get baud rate
IF 0
	sub	dl,ACE_LCR-ACE_DLL	; --> LSB of divisor latch
	mov	al,cl
	out	dx,al
	mov	al,ch
	inc	edx			; --> MSB of divisor latch
	.errnz ACE_DLM-ACE_DLL-1
	IO_Delay
	out	dx,al
	add	dl,2			; --> LCR and clear divisor bits
	.errnz ACE_LCR-ACE_DLM-2
ELSE
  pushad

  extrn _HSWriteDivisor:NEAR
  cCall _HSWriteDivisor <ecx>
  popad
ENDIF
	pop	eax
	out	dx,al

PSS_NoBaudSet:
	inc	dl			; --> MCR
	.errnz	ACE_MCR-ACE_LCR-1

	TestMem	ActionMask,fBitMask	; is caller interested in this ?
	jz	PSS_NoBitmaskWork

 ;
 ;	Compute initial state of DTR and RTS. If they have been disabled,
 ;	then do not raise them, and disallow being used as a handshaking
 ;	line. Also compute the bits to use as hardware handshake bits
 ;	(DTR and/or RTS as indicated, qualified with the disabled flags).
 ;
	mov	al,byte ptr [esi.ComDCB.Bitmask] ; align DTR/RTS disable 
					; flags for 8250
	and	al,fRTSDisable+fDTRDisable
	rol	al,1			;d0 = DTR, d2 = RTS  (1 = disabled)
	shr	al,1			;'C'= DTR, d1 = RTS
	adc	al,0			;d0 = DTR, d1 = RTS
	.errnz	fRTSDisable-00000010b
	.errnz	fDTRDisable-10000000b
	.errnz	ACE_DTR-00000001b
	.errnz	ACE_RTS-00000010b

	mov	ah,al			;Save disable mask
	xor	al,ACE_DTR+ACE_RTS+ACE_OUT2
	out	dx,al			;Set Modem Control Register

	mov	al,byte ptr [esi.ComDCB.BitMask+1] ;Get hardware 
					;handshake flags
	rol	al,1			;Align flags as needed
	rol	al,1
	rol	al,1
	and	al,ACE_DTR+ACE_RTS	;Mask bits of interest
	not	ah			;Want inverse of disable mask
	and	al,ah			;al = bits to handshake with
	mov	[esi.HHSLines],al 	;Save for interrupt code


	.errnz	fDTRFlow-2000h
	.errnz	fRTSFlow-4000h
	.errnz	ACE_DTR-00000001b
	.errnz	ACE_RTS-00000010b

	mov	al,byte ptr [esi.ComDCB.BitMask] ;Compute the mask 
					;  for the output
	shl	al,1			;  hardware handshake lines
	and	al,ACE_DSR+ACE_CTS
	mov	[esi.OutHHSLines],al

	.errnz	fOutXCTSFlow-00001000b
	.errnz	fOutXDSRFlow-00010000b
	.errnz	ACE_CTS-00010000b
	.errnz	ACE_DSR-00100000b

PSS_NoBitmaskWork:

; Compute the queue count where XOff should be issued (or hardware
; lines dropped).  This will prevent having to do it at interrupt
; time.

	mov	eax,[esi.pData.QInSize]	; get where they want it
	sub	eax,[esi.ComDCB.XoffLim];  and compute queue count
	mov	[esi.XoffPoint],eax

;
; Try to drain data from the UART.
;
	sub	dl,ACE_MCR-ACE_FCR	; EDX = FCR
	xor	al,al
	out	dx,al			; disable FIFO if present.
	mov	ah,16			; a max of 16 times
	add	dl,ACE_LSR-ACE_FCR	; EDX = LSR

PSS_Try_Drain_Data:
	in	al,dx
	test	al,ACE_DR		; Q: Is data in the buffer
	jz	PSS_Data_Drained	;    N:
	sub	dl,ACE_LSR-ACE_RBR	; EDX = data register
	in	al,dx			; read in one byte
	add	dl,ACE_LSR-ACE_RBR	; EDX = LSR
	dec	ah
	jnz	PSS_Try_Drain_Data

PSS_Data_Drained:

;
; Enable FIFO if possible
;
	sub	dl,ACE_LSR - ACE_FCR	; EDX = FCR
	test	[esi.EFlags], fNoFIFO	; Q: Can FIFO be enabled ?
	jnz	sc_nofifo		;   N:
	mov	al,ACE_EFIFO OR ACE_CRFIFO OR ACE_CTFIFO
	or	al,[esi.RxFifoTrigger]
	out	dx,al			; attempt to enable it
	test	[esi.EFlags], fFIFOchkd	; Q: FIFO detect been done ?
	jnz	sc_fifodone		;  Y: enabled FIFO
	IO_Delay
	.errnz	ACE_IIDR-ACE_FCR
	in	al,dx
	or	[esi.EFlags],fFIFOchkd
	test	al,ACE_FIFO_E2		; Q: FIFO enabled ?
	jz	@F
	test	al,ACE_FIFO_E1		; Q: 16550A detected?
	jnz	sc_fifodone		;  Y: enabled FIFO
@@:
	IO_Delay
	or	[esi.Eflags], fNoFIFO
sc_nofifo:
	xor	al,al
	out	dx,al
sc_fifodone:
	sub	dl,ACE_FCR-ACE_RBR	; dx -> RBR

;
; Delay for things to settle
;
	VMMCall	Get_System_Time
	mov	ecx,eax
delay_loop:
	in	al,dx			; read it once
	VMMCall	Get_System_Time
	sub	eax,ecx
	cmp	eax,DELAY_TIME		; Q: timeout reached ?
	jb	delay_loop		;  N:

	add	dl,ACE_MSR		;--> modem status reg
	in	al,dx			; Throw away 1st status read
	IO_Delay
	in	al,dx			; save 2nd for MSRWait (clear MSR int)
	push	esi
	mov	esi,[esi.AddrMSRShadow]
	mov	byte ptr [esi],al	; save it
	pop	esi

;
; Win 3.0 didn't check hardware handshaking until the line status changed.
; Allow some apps to keep that behavior.
;
	TestMem	[esi.ComDCB.BitMask], fWin30Compat
	jnz	sc_HHSup

;
; HACK FOR SOME MODEMS:  apparently some modems set CTS, but don't set DSR
; which means that COMM.DRV won't send if the app specifies that hardware
; handshaking is based on CTS & DSR being set.
;
	mov	eax,[esi.AddrMSRShadow]
	mov	al,[eax]		; get the shadow
	mov	ah,[esi.OutHHSLines]
	and	al,ah			;Only leave bits of interest
	cmp	al, ah			;Q: handshaking lines ok?
	je	sc_HHSup		;   Y:
	cmp	ah, ACE_CTS OR ACE_DSR	;Q: app looking for both high?
	jne	sc_HHSdown		;   N: skip hack
	test	[esi.EFlags], fUseDSR	;Q: DSR is always significant?
	jnz	sc_HHSdown		;   Y: skip hack
	cmp	al, ACE_CTS		;Q: DSR low & CTS high
	jne	sc_HHSdown		;   N: skip hack
	and	ah, NOT ACE_DSR 	;   Y: ignore DSR line
	mov	[esi.OutHHSLines], ah
	jmp	sc_HHSup

sc_HHSdown:
	or	[esi.HSFlag], HHSDown OR HHSAlwaysDown ; flag handshaking down
sc_HHSup:

 ;
 ; Now, at last, interrupts can be enabled.  Don't enable the
 ; transmitter empty interrupt.  It will be enabled by the first
 ; call to KickTx.
 ;

	sub	dl,ACE_MSR-ACE_IER	;--> Interrupt Enable Register

; flag port as being active
	mov	eax,[esi.DEBId]
	dec	eax
	bts	[ActiveCOMs], eax

	mov	al,ACE_ERBFI+ACE_ELSI+ACE_EDSSI       ; ##

	cli
	out	dx,al			;Enable interrupts.
	add	dl,ACE_LSR-ACE_IER	;--> Line Status Register
	IO_Delay
	in	al,dx			;Clear any Line Status interrupt
	sub	dl,ACE_LSR		;--> Receiver Buffer Register
	IO_Delay
	in	al,dx			;Clear any Received Data interrupt
	sti

	xor	eax,eax 		;All done

PSS_Done:
	mov	[esi.pData.dwLastError],eax ; save error
	or	eax,eax			; any errors ?
	jnz	PSS_Failed
	test	[esi.MiscFlags],unmasked_IRQ	; have we unmasked IRQ ?
	jnz	PSS_IRQUnmasked
	or	[esi.MiscFlags],unmasked_IRQ
	call	UnMaskIRQ

PSS_IRQUnmasked:
	xor	eax,eax
	inc	eax
	jmp	PSS_Success

PSS_Failed:
	xor	eax,eax

PSS_Success:

IFDEF DEBUG
;	int 3
ENDIF
	pop	ebx
	pop	edi
	pop	esi
	LeaveProc
	return

EndProc PortSetState

BeginDoc
;******************************************************************************
;
; BOOL
; PortSetup(HPORT hPort, BYTE *RxBase, ulong RxLength, BYTE *TxBase,
;	    ulong TxLength, QSB *pQsb);
;
; Parameters:
;		hPort	= port handle
;		RxBase	= receive queue base
;		RxLength = receive queue's length
;		TxBase	= base of transmit queue
;		TxLength = transmit queue length
;		pQsb	-> Queue status structure to fill in.
;
; Returns:
;		TRUE if OK, else false.
;==============================================================================
EndDoc
BeginProc PortSetup, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	RxBase,DWORD
ArgVar	RxLength,DWORD
ArgVar	TxBase,DWORD
ArgVar	TxLength,DWORD
ArgVar	pQsb,DWORD

	EnterProc
	push	edi

	mov	edx,hPort		; esi -> PortInformation struct
	lea	edi,[edx.pData.QInCount]
	mov	ecx, (_PortData.ValidPortData - _PortData.QInCount)/4
	xor	eax,eax
	mov	[edx.pData.dwLastError],eax	; no error

	cli
  cld
  rep	stosd			; reset all counts

	.errnz	_PortData.QInGet-_PortData.QInCount-4
	.errnz	_PortData.QInPut-_PortData.QInGet-4
	.errnz	_PortData.QOutCount-_PortData.QInPut-4
	.errnz	_PortData.QOutGet - _PortData.QOutCount -4
	.errnz	_PortData.QOutPut - _PortData.QOutGet - 4
	.errnz	_PortData.ValidPortData - _PortData.QOutPut - 4

	mov	edi,edx			; EDI -> port information structure

	mov	eax,RxBase		; get base of receive queue
	or	eax,eax			; Q: external buffer ?
	jnz	PS_NoAllocRxBuffer	;  Y:
	test	[edi.MiscFlags],RxQInternal ; Q: already alloced internal buf ?
	jz	PS_AllocRxBuffer
	VMMCall	_HeapReallocate,<[edi.pData.QInAddr],RxLength,0>
	or	eax,eax
	jz	PS_Done
	jnz	PS_NoAllocRxBuffer

PS_AllocRxBuffer:
	VMMCall	_HeapAllocate,<RxLength,0>
	or	eax,eax
	jz	PS_Fail
	or	[edi.MiscFlags],RxQInternal

PS_NoAllocRxBuffer:
	mov	[edi.pData.QInAddr],eax
	mov	eax,RxLength		; get length
	mov	[edi.pData.QInSize],eax

	mov	eax,TxBase		; get base of transmit q
	or	eax,eax			; Q: external buffer ?
	jnz	PS_NoAllocTxBuffer	;  Y:
	test	[edi.MiscFlags],TxQInternal
	jz	PS_AllocTxBuffer
	VMMCall	_HeapReallocate,<[edi.pData.QOutAddr],TxLength,0>
	or	eax,eax
	jz	PS_Done
	jnz	PS_NoAllocTxBuffer

PS_AllocTxBuffer:
	VMMCall	_HeapAllocate,<TxLength,0>
	or	eax,eax
	jz	PS_Fail
	or	[edi.MiscFlags],TxQInternal

PS_NoAllocTxBuffer:
	mov	[edi.pData.QOutAddr],eax
	mov	eax,TxLength		; get length
	mov	[edi.pData.QOutSize],eax
	mov	edx,pQsb		; get queue status block
	or	edx,edx
	jz	PS_NoQStatusReq
; Removed by DWS on Feb 10, 1996	TRAP
PS_NoQStatusReq:
	sti

PS_Success:
	xor	eax,eax
	inc	eax

PS_Done:
	pop	edi
	LeaveProc
	return

PS_Fail:
	test	[edi.MiscFlags],RxQInternal
	jz	PS_Fail1
	and	[edi.MiscFlags],NOT RxQInternal
	VMMCall	_HeapFree,<[edi.pData.QInAddr],0>

PS_Fail1:
	xor	eax,eax
	jmp	PS_Done

EndProc PortSetup

BeginDoc
;******************************************************************************
;
; BOOL
; PortTransmitChar(HPORT hPort, char cbyte);
;
; Parameters:
;		hPort	= port handle
;		cbyte	= char to transmit
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortTransmitChar, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	cbyte,BYTE

	EnterProc
	push	esi
	push	ebx

; Added by DWS on June 16, 1996

  mov       esi,hPort                           ; esi -> portInformation
  test      [esi.IR_Flags], IR_FLAGS_ENABLED
  jz        @f
 
  ; Store the byte into the BOFs field of the port information structure

  mov       al,cbyte 
  mov       [esi.IR_BOFs],al
  mov       eax,VMM_TRUE                        ; Return TRUE;
  jmp       PTC_Success
@@:

; End of code added by DWS

	mov	esi,hPort		; ESI -> Portinformation
	mov	eax,4000h		; in case we cannot send
	TestMem	[esi.EFlags],fTxImmed	; is another "Immediate" char waiting?
	jnz	PTC_Done		; yes, return error
	mov	ah,cbyte		; set char for TXI

	cli
	call	TXI			; set char to tx immediately
	sti

	xor	eax,eax			; ALL OK
PTC_Done:
	mov	[esi.pData.dwLastError],eax
	or	eax,eax			; all OK ?
	mov	eax,VMM_TRUE		; assume OK
	jz	PTC_Success
	xor	eax,eax			; NO

PTC_Success:
	pop	ebx
	pop	esi
	LeaveProc
	return

EndProc	PortTransmitChar

BeginDoc
;******************************************************************************
;
; BOOL
; PortClearError(HPORT hPort, COMSTAT *pComstat, ulong *pError);
;
; Parameters:
;		hPort	= port handle
;		pComstat -> status structure to fill in
;		pError	-> location to fill in error condition (reset)
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortClearError, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	pComstat,DWORD
ArgVar	pError,DWORD

	EnterProc
	push	esi
	push	ebx

	mov	esi,hPort
	mov	ebx,pComstat
	call	StaCom			; call worker

	xor	eax,eax
	mov	[esi.pData.dwLastError],eax
	xchg	eax,[esi.pData.dwCommError]	; return old error and clear
	mov	edx,pError
	mov	DWORD PTR [edx],eax		; return old error here
	xor	eax,eax
	inc	eax				; success

	pop	ebx
	pop	esi
	LeaveProc
	return

EndProc PortClearError

BeginDoc
;******************************************************************************
;
; BOOL
; PortEscapeFunction(HPORT hPort, long function, long Indata, long Outdata);
;
; Parameters:
;		hPort	= port handle
;		function = escape code
;		Indata	= optional data
;		Outdata	= optional data
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortEscapeFunction, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	function,DWORD
ArgVar	Indata,DWORD
ArgVar	Outdata,DWORD

	EnterProc

	push	esi
	push	ebx

	mov	ebx,function
	mov	esi,hPort		; esi -> portinformation
	xor	eax,eax			; assume error
	mov	[esi.pData.dwLastError],IE_EXTINVALID

	cmp	bl,CLEARBREAK
	ja	PEF_Done

	mov	[esi.pData.dwLastError],eax	; reset error
	call	ExtnFcn
	mov	ecx,OutData
	jecxz	PEF_NoOutData
	mov	[ecx],eax			; return this information

PEF_NoOutData:
	xor	eax,eax
	inc	eax				; success

PEF_Done:
	pop	ebx
	pop	esi
	LeaveProc
	return

EndProc PortEscapeFunction

BeginDoc
;******************************************************************************
;
; BOOL
; PortGetEventMask(HPORT hPort, long EventMask, long *OldEventMask);
;
; Parameters:
;		hPort	= port handle
;		EventMask = mask of events to clear
;		OldEventMask -> location where old mask should be returned.
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortGetEventMask, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	EventMask,DWORD
ArgVar	OldEventMask,DWORD

	EnterProc
	push	ebx

	mov	edx,hPort		; EDX -> PortInformation
	mov	[edx.pData.dwLastError],0 ; no errors here.
	mov	edx,[edx.AddrEvtDWord]	; edx -> event dword's location
	mov	ebx,EventMask		; get mask to clear
	not	ebx

	cli
	mov	eax,[edx]		; get current events
	and	ebx,eax			; clear them
	mov	dword ptr [edx],ebx	; save results
	sti

	mov	edx,OldEventMask
	mov	dword ptr [edx],eax	; return old accumulated events.

PGEM_Done:
	xor	eax,eax
	inc	eax			; success
	pop	ebx
	LeaveProc
	return

EndProc PortGetEventMask

BeginDoc
;******************************************************************************
;
; BOOL
; PortWrite(HPORT hPort, char *lpBuf, ulong NumBWrite, ulong *lpNumBWritten);
;
; Parameters:
;		hPort	= port handle
;		lpBuf	-> buffer to write from
;		NumBWrite = number of bytes to write
;		lpNumBWritten -> update location for number of bytes written
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortWrite, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	lpBuf,DWORD
ArgVar	NumBWrite,DWORD
ArgVar	lpNumBWritten,DWORD

	EnterProc
	push	esi
	push	edi
	push	ebx

  push  eax
  push  edx
  mov   dx, 0a0h
  mov   al, 0fh
  out   dx, al
	IO_Delay
  in    al, dx
  pop   edx
  pop   eax

; Added by DWS on June 16, 1996
  mov       esi,hPort                           ; esi -> portinformation
  test      [esi.IR_Flags], IR_FLAGS_ENABLED
  jz        @f

  cCall     _IR_PortWrite, <hPort, lpBuf, NumBWrite, lpNumBWritten>
  jmp       PW_Done
@@:

; End of code added by DWS

IFDEF DEBUG
  mov       eax, NumBWrite
  Trace_Out "PortWrite:  number bytes to write = #EAX"
ENDIF

;  mov       edx,[esi.Port]                      ; disable interrupts first
;  inc       edx
;  in        al, dx
;  and       al, 0FAh
;  out       dx, al 
;  IO_Delay
;  out       dx, al

  mov	esi,hPort
	mov	ecx,NumBWrite
	mov	edi,lpBuf
	push	esi
	call	WriteCommString
	pop	esi
	mov	edx,lpNumBWritten
	mov	dword ptr [edx],eax	; # bytes written
	xor	eax,eax			; access to 0
	mov	[esi.pData.dwLastError],eax
	inc	eax			; success

PW_Done: ; Added label by DWS on June 16, 1996

	pop	ebx
	pop	edi
	pop	esi
	LeaveProc
	return

EndProc PortWrite

BeginDoc
;******************************************************************************
;
; BOOL
; PortRead(HPORT hPort, char *lpBuf, ulong NumBToRead, ulong *lpNumBRead);
;
; Parameters:
;		hPort	= port handle
;		lpBuf	-> buffer to read into
;		NumBToRead = number of bytes to read
;		lpNumBRead -> update location for number of bytes read.
;
; Returns:
;		TRUE if OK, else FALSE.
;==============================================================================
EndDoc
BeginProc PortRead, CCALL, PUBLIC

ArgVar	hPort,DWORD
ArgVar	lpBuf,DWORD
ArgVar	NumBToRead,DWORD
ArgVar	lpNumBRead,DWORD

	EnterProc
	push	esi
	push	edi
	push	ebx

; Added by DWS on June 16, 1996
  mov       esi,hPort                           ; esi -> portinformation
  test      [esi.IR_Flags], IR_FLAGS_ENABLED
  jz        @f
   
  cCall     _IR_PortRead, <hPort, lpBuf, NumBToRead, lpNumBRead>
  jmp       PR_Done
@@:

; End of code added by DWS

	mov	esi,hPort		; esi -> portinformation
	mov	edi,lpBuf		; edi -> buffer
	mov	ecx,NumBToRead		; ecx = max bytes to read
	call	ReadCommString
	mov	ecx,0			; assume no error
	jnz	PR_DataRead
	mov	ecx,eax			; save error/no data here
	xor	eax,eax
PR_DataRead:
	mov	edx,lpNumBRead
	mov	dword ptr [edx],eax
	mov	[esi.pData.dwLastError],ecx ; set error
	mov	eax,VMM_TRUE		; assume success
	jecxz	PR_Done
	xor	eax,eax
PR_Done:
	pop	ebx
	pop	edi
	pop	esi
	LeaveProc
	return

EndProc PortRead


IF 0
;****
;
; ManageTimer
;
; If any COMM port is open and a receive trigger is set, then starts the
; timer is not already active, else stops it
;
; Entry:
;	NONE
; Exit:
;	NONE
; Uses:
;	Everything except EAX
;
BeginProc ManageTimer,PUBLIC

	push	eax
	mov	ebx,ActiveCOMs
	or	ebx,ebx
	jz	MT_Cancel_Timer		; cancel timer
	mov	ecx,MAXCOM+1
	mov	edi,OFFSET32 PortInfoPtrs

MT_Loop:
	mov	esi,[edi]
	shr	ebx,1
	jnc	MT_lpend
	cmp	[esi.RecvTrigger],-1	; Q: Owner wants notification?
	je	MT_lpend		;  N: skip this entry
	cmp	TimeOutHandle,0		; Q: Have we set a timer already?
	jnz	MT_Done			;  Y: get out
	mov	eax,100			;  N: set a 100 ms timer
	mov	edx,OFFSET32 ActiveCOMs	; reference data
	mov	esi,OFFSET32 TimerProc
	VMMCall	Set_Global_Time_Out
	mov	TimeOutHandle,esi
	jmp	MT_Done

MT_lpend:
	add	edi,4
	or	ebx,ebx
	loopnz	MT_Loop

MT_Cancel_Timer:
	xor	esi,esi
	xchg	esi,TimeOutHandle
	VMMCall	Cancel_Time_Out

MT_Done:
	pop	eax
	ret

EndProc ManageTimer

ENDIF

VxD_Locked_Code_Ends

	end
