	PAGE	58,132
;******************************************************************************
;
; (C) Copyright MICROSOFT CORP. 1992-1995
;
; Title:	SERINIT.ASM
;
; Version:	1.0
;
; Date:		08/16/93
;
; Author:	Sandeeps
;
;==============================================================================
; Change log:
;
;******************************************************************************

	.386p

	.xlist
	include	VMM.INC
	include	OPTTEST.INC
	include	VCOMM.INC
  include IRCOMM31.INC   ; Added by DWS on Jan 12, 1996
	include	DEBUG.INC
	include	INTERN31.INC
	include	INS8250.INC
	.list

VxD_Locked_Data_Seg

	EXTRN	IRQInfoArray:BYTE

  PUBLIC  VcommPresent
	PUBLIC  NoReflect
  PUBLIC  IrPortNum

VcommPresent db 1
IrPortNum    dd 1
NoReflect    dd 0

VxD_Locked_Data_Ends

VxD_My_Pageable_Code_Seg

	EXTRN	_PortOpen:NEAR

VxD_My_Pageable_Code_Ends

VxD_My_Pageable_Data_Seg

	EXTRN	PortInfoPtrs:DWORD
	EXTRN	Serial_Functions:BYTE
	EXTRN	SysVMHandle:DWORD
  EXTRN COMIRName:BYTE

VxD_My_Pageable_Data_Ends

VxD_Locked_Code_Seg

  EXTRN _IR_PortInit:NEAR

VxD_Locked_Code_Ends

VxD_ICODE_Seg

;******************************************************************************
;
; Serial_Device_Init
;
; Description:
;		On snowball, this gets called at Device_Init time
;		On Chicago, it gets called at Sys_Dynamic_Device_Init
;		time. If registers itself as a port driver with VCOMM
;		and loads if it can find the port(s) being configured.
;		On Snowball, it looks at BDA and add all ports while
;		on Chicago, it configures only the given port.
;
; Entry:
;		None.
; Exit:	
;		if port(s) could be configured then NC
;		else CY
;
; Uses: All
;
;******************************************************************************

BeginProc Serial_Device_Init,PUBLIC

IFDEF DEBUG
	Trace_Out "SERIAL31: Serial_Device_Init"
ENDIF

	cmp	[SysVMHandle],0
	jne	NDI_Load_Done

	VMMCall	Get_Sys_VM_Handle
	mov	[SysVMHandle],ebx		; save

	; Assume VCOMM is present and then check for it.

	mov  VcommPresent,1
	VxDCall VCOMM_Get_Version
	jnc @f

    mov  VcommPresent,0         ; Indicate that Vcomm is not present
IFDEF DEBUG
	Trace_Out "SERIAL31: VCOMM is not present"
ENDIF

@@:
	VxDCall	IRCOMM31_GetVersion
	jnc	NDI_VCOMM_Present
	ret					; no need to load

NDI_VCOMM_Present:
  call  ReadSysIni
	VxDCall	_VCOMM31_Register_Port_Driver,<OFFSET32 _S_DriverControl>

IFDEF DEBUG
	push	eax
	movzx	eax,[RegisteredPorts]
	Trace_Out "SERIAL31: RegisteredPorts = #EAX"
	pop	eax
ENDIF

	cmp	[RegisteredPorts],0
	je	NDI_NoLoad

NDI_Load_Done:
IFDEF DEBUG
	Trace_Out "SERIAL31: Serial_Device_Init Load success"
ENDIF
	clc
	ret

NDI_NoLoad:
IFDEF DEBUG
	Trace_Out "SERIAL31: Serial_Device_Init No Load"
ENDIF
	stc
	ret

EndProc Serial_Device_Init

VxD_ICODE_Ends

VxD_IData_Seg

RegisteredPorts	db	0

COMBase	db	'COM'
xBase	db	'1'
	db	'BASE',0

COMIrq	db	'COM'
xIrq	db	'1'
	db	'IRQ',0

COMTxFifo db	'COM'
xFifo	db	'1'
	db	'TxFifo',0

COMMDSR	db	'COM'
xDSR	db	'1'
	db	'FORCEDSR',0

COMMFifo db	'COM'
xcFifo	db	'1'
	db	'Fifo',0

COMRxFifo	db	'COM'
xcRx		db	'1'
		db	'RxTrigger',0

IrLapFrmName  db 'irlapfrm',0
NoReflectName db 'NoIsrReflect',0
IrPortName    db 'Port',0

VxD_IData_Ends

VxD_ICODE_Seg

;*****
;
; VOID S_DriverControl(DWORD FunctionCode);
;
; Description:
;	called by VCOMM to initialize all the ports.
;
; Entry:
;	none
;
; Exit:
;	None
; Uses:
;	C style
;	
BeginProc S_DriverControl,CCALL,esp,PUBLIC

ArgVar	FunctionCode,DWORD

	EnterProc

	SaveReg	<esi,edi,ebx>

	cmp	FunctionCode,0
	jne	IF_Add_Done

IFDEF DEBUG
	Trace_Out "SERIAL31: S_DriverControl"
ENDIF

 ;
 ; Find the com ports we can handle
 ;
	call	Serial_FindCOMPorts

IFDEF DEBUG
	Trace_Out "SERIAL31: Back from Serial_FindCOMPorts (#edx)"
ENDIF
  ;
  ; Now call VCOMM and let it know this.
  ;
	or	edx,edx			; Q: did we find a COMM port ?
	jz	IF_Add_Done		;    N: no ports to add

  ; Set the name correctly in ESI

  mov eax,IrPortNum
  cmp eax,4
  jg  IF_Add_Done

  add eax,'0'
  lea esi,[COMIRName]
  mov byte ptr [esi+3],al
	inc	[RegisteredPorts]
IFDEF DEBUG
  mov ebx,IrPortNum
  Trace_Out "SERIAL31: Calling Add Port for port #EBX"
ENDIF

  ; Add the IR port to VCOMM

	VxDCall	_VCOMM31_Add_Port,<0, OFFSET32 _PortOpen,esi>	; no refData

  ; Now Call Fast Ir Init with the port information structure

  mov ebx,IrPortNum
  dec ebx
	mov	ecx,PortInfoPtrs[ebx*4] ; get pointer to correct struct
  cCall _IR_PortInit, <ecx,esi>

IF_Add_Done:

	RestoreReg <ebx,edi,esi>

	LeaveProc
	return

EndProc S_DriverControl

;******************************************************************************
;
; Serial_FindCOMPorts
;
; Description:
;		Walks thru BIOS data are and compiles a list of COMM ports.
;		Then reads system.ini to read defaults.
;
; Entry:
;		None
; Exit:
;		EDX = 0 if no COMM ports, else NON-ZERO
; Uses:
;		ALL
;******************************************************************************
BeginProc Serial_FindCOMPorts,PUBLIC

IFDEF DEBUG
	Trace_Out "SERIAL31: Serial_FindCOMPorts"
ENDIF

	Begin_Touch_1st_Meg
	mov	eax,DS:[400h]		; get first two address
	End_Touch_1st_Meg

	call	AssignComPortInAX
	shr	eax,16
	call	AssignComPortInAX

	Begin_Touch_1st_Meg
	mov	eax,DS:[404h]		; get next two addresses
	End_Touch_1st_Meg

	call	AssignComPortInAX
	shr	eax,16
	call	AssignComPortInAX

	call	ReadSysIniValues

	mov	esi,OFFSET32 PortInfoPtrs
	mov	edx,[esi]		; get ptr to COM1 info
	mov	ecx,edx
	jecxz	SerialFCP_NoCom1
	call	InitIrqStructs
SerialFCP_NoCom1:
	mov	ecx,[esi+4]		; get ptr to COM2 info
	or	edx,ecx
	jecxz	SerialFCP_NoCom2
	call	InitIrqStructs
SerialFCP_NoCom2:
	mov	ecx,[esi+8]
	or	edx,ecx
	jecxz	SerialFCP_NoCom3
	call	InitIrqStructs
SerialFCP_NoCom3:
	mov	ecx,[esi+12]
	or	edx,ecx
	jecxz	SerialFCP_NoCom4
	call	InitIrqStructs
SerialFCP_NoCom4:
	ret

EndProc Serial_FindCOMPorts

;****
;
; AssignComPortInAX
;
; Description:
;	given a base address, assigns a port to it.
;	If a port is assigned to it, data is alloc'ed for it also.
;
; Entry:
;	AX = port base
;
; Exit:
;	none
; Uses:
;	ESI,ECX,EBX,FLAGS
BeginProc AssignComPortInAX, NO_PROLOG

IFDEF DEBUG
	Trace_Out "SERIAL31: AssignComPortInAX #(AX)"
ENDIF

	or	ax,ax
	jz	ACPI_Done		; NO com port

	xor	esi,esi			; assume found COM1
	mov	cl,4			; IRQ is 4
	cmp	ax,3F8h			; is this COM1 ?
	je	ACPI_Found
	inc	esi			; COM2
	dec	cl			; IRQ is 3
	cmp	ax,2F8h
	je	ACPI_Found
	inc	esi			; COM3
	inc	cl			; IRQ is 4
	cmp	ax,3E8h
	je	ACPI_Found
	dec	cl			; IRQ is 3
	cmp	ax,3320h		; COMMON on PS/2s.
	je	ACPI_Found
	inc	esi			; COM 4, IRQ is 3
	cmp	ax,2E8h
	je	ACPI_Found
ACPI_Done:
	ret

ACPI_Found:
	xor	ebx,ebx			; no data pointer yet.
	call	AllocPortInfo

	ret

EndProc AssignComPortInAX

;******************************************************************************
;
; ReadSysIniValues
;
; Description:
;		reads system.ini overrides. These are global overrides
;
; Entry:
;		None
; Exit:
;		None
; Uses:
;	ALL
;
;==============================================================================

BeginProc ReadSysIniValues

IFDEF DEBUG
	Trace_Out "SERIAL31: ReadSysIniValues"
ENDIF

	xor	ebx,ebx			; start at COM1

rsi_scan_lp:
	mov	edi,OFFSET32 COMBase	; COMxBase
	mov	XBase,'1'
	add	XBase,bl
	xor	eax,eax
	xor	esi,esi			; [386Enh] section
	VMMCall	Get_Profile_Hex_Int
	or	eax,eax
	jz	rsi_BaseIrqDone
	push	eax
	xor	esi,esi			; [386Enh] section
	mov	edi,OFFSET32 COMIrq	; COMxIRQ
	mov	xIrq,'1'
	add	xIrq,bl
	xor	eax,eax
	VMMCall	Get_Profile_Decimal_Int
	mov	ecx,eax
	pop	eax
	jecxz	rsi_invalid_irq
	mov	esi,PortInfoPtrs[ebx*4]	; esi -> Port info
	or	esi,esi			; Q: is it allocated ?
	jnz	rsi_override		;  Y: override old values
	xchg	esi,ebx			;  N: ESI = port#, EBX = 0 (alloc heap)
	call	AllocPortInfo
	mov	ebx,esi
	jmp	rsi_BaseIrqDone

rsi_invalid_irq:
IFDEF	DEBUG
	inc	ebx
	Debug_Out "Serial: invalid IRQ (##cl) specified for COM#bl"
	dec	ebx
ENDIF
	jmp	rsi_BaseIrqDone

rsi_override:
	xchg	esi,ebx
	call	FixPortInfo
	mov	ebx,esi

rsi_BaseIrqDone:
	cmp	PortInfoPtrs[ebx*4],0
	jz	rsi_next

	mov	edi,OFFSET32 COMTxFifo	; COMxTxFifo
	mov	xFifo,'1'
	add	xFifo,bl
	xor	eax,eax
	xor	esi,esi			; [386Enh] section
	VMMCall	Get_Profile_Hex_Int
	mov	esi,PortInfoPtrs[ebx*4]	; esi -> Port info
	or	eax,eax			; Q: Should we use Tx fifo if avail ?
	jnz	rsi_UseTxFifo		;    Y: get out
	or	[esi.EFlags],fNoTxFifo	;    N: say so

rsi_UseTxFifo:
	mov	edi,OFFSET32 COMMDsr	; COMxForceDSR
	mov	xDsr,'1'
	add	xDsr,bl
	xor	eax,eax
	xor	esi,esi			; [386Enh] section
	VMMCall	Get_Profile_Hex_Int
	or	eax,eax
	jz	rsi_NoUseDSR
	mov	esi,PortInfoPtrs[ebx*4]
	or	[esi.EFlags],fUseDSR	; force DSR

rsi_NoUseDSR:
	mov	edi,OFFSET32 COMMFifo	; COMxFifo
	mov	xcFifo,'1'
	add	xcFifo,bl
	mov	eax,2
	xor	esi,esi			; [386Enh] section
	VMMCall	Get_Profile_Hex_Int
	mov	esi,PortInfoPtrs[ebx*4]
	cmp	eax,1
	ja	rsi_FifoDone		; just check at open
	jb	rsi_NoFifo		; force OFF, if = 0
	or	[esi.EFlags],fFIFOchkd	; flag as checked, to force ON
	jmp	rsi_FifoDone

rsi_NoFifo:
	or	[esi.EFlags], fNoFifo OR fFIFOchkd	; force off

rsi_FifoDone:
	mov	edi,OFFSET32 COMRxFifo
	mov	xcRx,'1'
	add	xcRx,bl
	mov	eax,8
	xor	esi,esi
	VMMCall	Get_Profile_Decimal_Int
	mov	esi,PortInfoPtrs[ebx*4]
	cmp	eax,8
	jbe	@F
	mov	al,ACE_TRIG14
	jmp	rsi_RxTriggerFound
@@:
	cmp	eax,4
	jbe	@F
	mov	al,ACE_TRIG08
	jmp	rsi_RxTriggerFound
@@:
	cmp	eax,1
	jbe	@F
	mov	al,ACE_TRIG04
	jmp	rsi_RxTriggerFound
@@:
	mov	al,ACE_TRIG01

rsi_RxTriggerFound:
	mov	[esi.RxFifoTrigger],al
	
rsi_next:
	inc	ebx
	cmp	ebx,MAXCOM
	jbe	rsi_scan_lp
	ret

EndProc ReadSysIniValues

;************************************************************
;
; Read the system.ini file

BeginProc ReadSysIni
    xor     eax, eax                    ; default value
    mov     esi, OFFSET32 IrLapFrmName  ; points to section name
    mov     edi, OFFSET32 NoReflectName ; points to entry name
    VMMcall Get_Profile_Decimal_Int
    mov     NoReflect,eax

    mov     eax, 1                      ; default value
    mov     esi, OFFSET32 IrLapFrmName  ; points to section name
    mov     edi, OFFSET32 IrPortName    ; points to entry name
    VMMcall Get_Profile_Decimal_Int
    mov     IrPortNum,eax
    ret

EndProc ReadSysIni

;***
;
; AllocPortInfo:
;
; Allocates the port information structure for port X and fills in
; the required entries.
;
; Entry:
;	ESI = port # (BASE 0)
;	CL  = IRQ
;	AX  = Port BASE
;	EBX -> data ptr for port
;
; Exit:
;	None
; Uses:
;	EBX,ECX
;
BeginProc AllocPortInfo

IFDEF DEBUG
  push ecx
  mov  ecx,esi
	Trace_Out "SERIAL31: AllocPortInfo COM #ECX = #AX"
  pop  ecx
ENDIF

	or	ebx,ebx				; Q: allocated already ?
	jnz	UseOldBuffer			;    Y:

	push	eax
	push	ecx
	VMMCall	_HeapAllocate,<SIZE PortInformation,HEAPZEROINIT>
	mov	ebx,eax
	pop	ecx
	pop	eax

	or	ebx,ebx
	jz	API_Done

UseOldBuffer:
	mov	PortInfoPtrs[esi*4],ebx	; save pointer

	mov	[ebx._PortData.PDLength],SIZE _PortData
	mov	[ebx._PortData.PDVersion],100h
	mov	[ebx._PortData.PDFunctions], OFFSET32 Serial_Functions
	mov	[ebx._PortData.PDNumFunctions],16
	inc	esi
	mov	[ebx.DEBId],esi		; ID
	dec	esi
	mov	[ebx.RecvTrigger],-1

FixPortInfo:

	mov	[ebx.IRQn],cl		; save
	movzx	ecx,ax
	mov	[ebx.Port],ecx		; save

API_Done:
	ret

EndProc AllocPortInfo

;***
;
; InitIrqStructs
;
; Initializes an IRQ structure for an irq number
;
; Entry:
;	ECX -> PortInformation structure
;
; Exit:
;	None
; Uses:
;	EDI,EAX
;
BeginProc InitIrqStructs

IFDEF DEBUG
	Trace_Out "SERIAL31: InitIrqStructs"
ENDIF

	push	ecx
	movzx	eax,[ecx.IRQn]
	mov	ecx,MAXCOM+1
	mov	edi,OFFSET32 IRQInfoArray

IIS_Loop:
	cmp	[edi.IRQNumber],al		; Q: Have we found this IRQ ?
	jz	IIS_Done			;  Y: get out
	cmp	[edi.IRQNumber],0		; Q: Has this struct been init?
	jne	IIS_Next			;  Y: Yes
	mov	[edi.IRQNumber],al		;  N: Initialize it
	jmp	IIS_Done

IIS_Next:
	add	edi,SIZE IRQStruc
	loop	IIS_Loop
IIS_Done:
	pop	ecx
	mov	[ecx.MyIRQStruc],edi
	ret
EndProc InitIrqStructs

VxD_ICODE_Ends
	end
