	PAGE 58,132
;******************************************************************************
;
; (C) Copyright MICROSOFT CORP. 1992-1995
;
; Title:	SERUTIL.ASM
;
; Version:	1.0
;
; Date:		11/20/92
;
; Author:	sandeeps
;
;==============================================================================
; Change log:
;
;******************************************************************************

	.386p

	.xlist
	include	VMM.INC
	include	VPICD.INC
	include	VCOMM.INC
    include IRCOMM31.INC  ; Added by DWS on Jan 12, 1996
	include	DEBUG.INC
	include	OPTTEST.INC
	include	INTERN31.INC
	include	INS8250.INC
	.list

VxD_My_Pageable_Data_Seg

	EXTRN	Serial_Name:BYTE
	EXTRN	PortInfoPtrs:DWORD

VxD_My_Pageable_Data_Ends

VxD_Locked_Data_Seg

	EXTRN	SysVMHandle:DWORD
	EXTRN	TimeOutHandle:DWORD
  EXTRN VcommPresent:BYTE     ; Added by DWS Feb 3, 1996
	PUBLIC	ActiveCOMs

ActiveCOMs	dd	0

VxD_Locked_Data_Ends

VxD_My_Pageable_Code_Seg

;******************************************************************************
;
; GetCOMPort
;
; Description:
;		Calls VCOMM to acquire the port
; Entry:
;	ESI -> PortInformation struct
;	EAX = VM to acquire port for
;	      -1 if acquire it for a VxD
; Exit:
;	NC iff successful
; Uses:
;	Flags,EAX,ECX
;
;******************************************************************************
BeginProc GetCOMPort, PUBLIC
	cmp	eax,-1			; Q: Acquire it for a VxD ?
	jnz	GCP_ForVM
	VxDCall	_VCOMM31_Acquire_Port,<OFFSET32 Serial_Name, [esi.DEBId], eax, 0>
	jmp	GCP_VCOMM_Called

GCP_ForVM:
	VxDCall	_VCOMM31_Acquire_Port,<esi, [esi.DEBId], eax, 0>

GCP_VCOMM_Called:
	or	eax,eax
	jz	GCP_Done
	mov	[esi.VCD_Data],eax	; save handle
GCP_Done:
	ret
EndProc GetCOMPort

;******************************************************************************
;
; ReleaseCOMPort
;
; Description:
;		Calls VCOMM to release a com port
;
; Entry:
;	ESI -> PortInformation struct
; Exit:
;	NONE
; Uses:
;	EAX,FLAGS
;
;******************************************************************************
BeginProc ReleaseCOMPort,PUBLIC

	VxDCall	_VCOMM31_Release_Port,<[esi.VCD_Data],[esi.OwnerVM]>
	ret

EndProc ReleaseCOMPort

;******************************************************************************
;
; StealPort
;
; Description:
;	Calls VCOMM to see if we can get the port.
; Entry:
;	ESI -> DEB
; Exit:
;	NZ if success, else failure
; Uses:
;	C style
;******************************************************************************
BeginProc StealPort,PUBLIC

  VxDCall	_VCOMM31_Steal_Port,<[esi.VCD_Data],[esi.OwnerVM]>
	or	eax,eax
	jz	SP_No
	and	[esi.pData.LossByte],NOT 1
	or	eax,eax			; set NZ flag again
SP_No:
	ret

EndProc StealPort

;******************************************************************************
;
; FlagNotActive
;
; Description:
;		Flags the port as inactive
;		Is this ever used ? Use DEBId to do this.
; Entry:
;		ESI -> PortInformation struct
; Exit:
;		None
; Uses:
;		EAX,Flags
;******************************************************************************
BeginProc FlagNotActive, PUBLIC

	mov	eax,[esi.DEBId]
	dec	eax
	btr	[ActiveCOMs],eax
	ret

EndProc FlagNotActive

;******************************************************************************
;
; Terminate
;
; Description:	terminate device
;		Restore the port I/O address and make sure that interrupts
;		are off.
;
; Entry:
;		EDX = device port address
;		ESI -> PortInformation struct
;
; Exit:
;		EAX = 0 => success
;		EAX = -1 => error
; Uses:
;		EAX,EBX,EDX,FLAGS.
;==============================================================================
BeginProc Terminate, NO_PROLOG, PUBLIC

	call	FlagNotActive

	test	[esi.pData.LossByte],1		; Q: Do we have the port ?
	jz	Terminate_SerialOwnsPort	;    Y: Continue
	call	StealPort			;    N: Try to steal it
	jz	Terminate45			;       Couldn't steal it

Terminate_SerialOwnsPort:
;
; We delay for a bit while the last character finishes transmitting
; Then we drop DTR and RTS, and disable the interrupt generation at
; the 8250.  Even if fRTSDisable or fDTRDisable is set, those lines
; will be dropped when the port is closed.
;
; When the OUT2 bit is reset to 0 to disable interrupts, many ports
; generate an interrupt which can not be identified, because the the
; interrupt ID register will not be set.  To work around this hardware
; problem we first mask the IRQ, then set the port into loopback mode
; and output a NULL to generate a receive interrupt request.	Then we
; reset OUT2 and unmask the IRQ.  This will cause the interrupt to occur
; and the interrupt handler will be able to correctly identify the
; interrupt as coming from the com port.
;
	inc	edx			; disable chip interrupts
	.errnz	ACE_IER-ACE_RBR-1
	mov	al,ACE_ERBFI		;   except receive
	out	dx,al
	add	dl,ACE_LSR-ACE_IER	; --> line status register
	IO_Delay

	mov	ah,100

Terminate20:
	dec	ah			; sort of timeout
	jz	Terminate30		; On Rockwell modems, with RAS,
					; we don't get xmit empty (Why?)
	in	al,dx			; wait until xmit is empty
	and	al,ACE_THRE+ACE_TSRE
	cmp	al,ACE_THRE+ACE_TSRE
	jne	Terminate20		; not empty yet.

Terminate30:
	xor	al,al
	test	[esi.EFlags],fFIFOpre	; Q: leave FIFO enable?
	jz	@F
	mov	al,ACE_TRIG08 OR ACE_EFIFO OR ACE_CRFIFO OR ACE_CTFIFO
@@:
	sub	dl,ACE_LSR-ACE_FCR
	out	dx,al
	IO_Delay
	call	MaskIRQ
	add	dl,ACE_MCR-ACE_FCR	; --> Modem control reg
	in	al,dx
	IO_Delay
	mov	ah,al
	or	al,ACE_LOOP		; turn on loopback
	out	dx,al
	IO_Delay
	sub	dl,ACE_MCR-ACE_THR
	xor	al,al
;	out	dx,al			; output a NULL to generate an int
	IO_Delay
	add	dl,ACE_LSR-ACE_THR
	push	eax			; AH MUST be saved
	mov	ah,100			; sort of timeout

Terminate35:
	dec	ah			; Q: Have we loop'ed enough
	jz	Terminate36		;    Y: get out
	in	al,dx			; wait until xmit is empty
	and	al,ACE_THRE+ACE_TSRE
	cmp	al,ACE_THRE+ACE_TSRE
	jne	Terminate35		; not empty yet

Terminate36:
	pop	eax			; get back AH
	mov	al,ah
	dec	dl			; now clear OUT2 and loopback
	.errnz	ACE_LSR-ACE_MCR-1
	and	al,ACE_DTR+ACE_RTS	; leave DTR,RTS high if already so
	out	dx,al			; but tri-state IRQ line

	call	UnMaskIRQ		; this will cause the receive int
					; to occur and be processed.

	sub	dl,ACE_MCR-ACE_IER	; clear the receive int enable
	xor	al,al
	out	dx,al
	dec	dx
	.errnz	ACE_IER-ACE_RBR-1

	call	MaskIRQ

;******* DANGER! ***** NOTICE! ***** DANGER! ***** WARNING! ***** NOTICE!
;
; Terminate45 is a secondary entrypoint into this routine--it's called
; by the initialization code when that code is unable to properly init
; a com port and needs to clean-up the mess it's made.
;
;******* DANGER! ***** NOTICE! ***** DANGER! ***** WARNING! ***** NOTICE!

Terminate45:

	push	ecx			; save these
	push	ebx

	mov	eax,[esi.MyIRQStruc]	; get our IRQ struct
	dec	[eax.VirtCnt]		; Q: Have we virtualized it > once
	jnz	TerminateUnmask		;  Y: unmask it now
	cmp	[eax.OldMask],0		; Q: was IRQ originally masked ?
	jne	TerminateSkipUnmask	;  Y: do not unmask it now

TerminateUnmask:
	call	UnMaskIRQ		; Unmask it

TerminateSkipUnmask:
	xor	eax,eax
	xchg	eax,[esi.IRQHandle]
	VxDCall	VPICD_Force_Default_Behavior

Terminate47:
	pop	ebx			; original EBX
	call	ReleaseCOMPort
	pop	ecx			; original ECX

Terminate50:				; also called from IniCom ???
	xor	eax,eax			; port closed and deallocated.
	ret

EndProc Terminate

VxD_My_Pageable_Code_Ends

VxD_Locked_Code_Seg

;***
;
; MaskIRQ
;
; Description:		masks irq for the com port.
;
; Entry:		ESI -> Portinformation struct
; Exit:
;			AL = 0, if was unmasked, else -1 if already masked.
; Uses:
BeginProc MaskIRQ, NO_PROLOG, PUBLIC

	push	ebx
	push	ecx

	mov	eax,[esi.IRQHandle]
	or	eax,eax
	jz	MaskIRQ_Done			; handle doesn't exist
	mov	ebx,[SysVMHandle]
	VxDCall	VPICD_Get_Complete_Status	; get the status
	mov	al,-1				; assume masked
	test	cl,0100b			; is IRQ physically masked ?
	jnz	MaskIRQ_Done			; yes, get out
	mov	eax,[esi.IRQHandle]
	VxDCall	VPICD_Physically_Mask
	xor	al,al				; was not masked.
MaskIRQ_Done:
	pop	ecx
	pop	ebx
	ret

EndProc MaskIRQ

;***
;
; UnMaskIRQ
;
; Description:		Unmasks the irq of the port.
;
; Entry:		ESI -> PortInformation struct
; Exit:		None.
; Uses:
;
BeginProc UnMaskIRQ, NO_PROLOG, PUBLIC

	push	eax
	mov	eax,[esi.IRQHandle]
	or	eax,eax
	jz	UnMaskIRQ_Done
	VxDCall	VPICD_Physically_Unmask
UnMaskIRQ_Done:
	pop	eax
	ret

EndProc UnMaskIRQ

;***
;
; KickTx
;
; Descirption:	"Kick" the xmitter interrupt routine into operation.
;		If the transmitter holding register isn't empty, then
;		nothing needs to be done. If it is empty, then the xmit
;		interrupt needs to be enabled in the IER.
;
; Entry:	ESI-> PortInformation struct, 
;		interrupts are disabled.
;
; Exit:		None.
;
; Uses:		EAX,EDX,flags
;
BeginProc KickTx,Public

	test	[esi.pData.LossByte],1	; Q: Do we still own the port ?
	jnz	can_we_steal		;    N:

enable_int:
	mov	edx,[esi.Port]		; get device I/O address
; add dl,ACE_IER        ; --> interrupt enable register
; in	al,dx             ; get current IER state

; code added by aek for ti problem
    xor   al, al
    add   dl, ACE_CCR
    out   dx, al
    add   dl, ACE_ACREG - ACE_CCR
    mov   al, ACE_TXEN            ; Enable only transmitter.  See TIR2000 data sheet
    out   dx, al
IFDEF DEBUG
;    Trace_Out "Rx->Tx"
ENDIF
    sub   dl, ACE_ACREG - ACE_IER
    in    al, dx
IF 0
    and al, NOT ACE_ERBFI + ACE_ELSI
    out dx, al
;    IO_Delay
;    out dx, al
ENDIF
; end of code added.
	test	al,ACE_ETBEI		; interrupts already enabled?
	jnz	KickTx10		;  yes, don't re-enable it
	or	al,ACE_ETBEI		;  No, enable it
	out	dx,al			; 8250, 8250-B requires
	IO_Delay
	out	dx,al			; writing register twice.

KickTx10:
	ret

can_we_steal:
	call	StealPort		; call VCOMM to see if we can steal
					; the port back
	jnz	enable_int		; jump, if we got it
;
; flush out the queue
;
	xor	eax,eax
	mov	[esi.pData.QOutCount],eax
	mov	[esi.pData.QOutMod],eax
	mov	eax,[esi.pData.QOutGet]
	mov	[esi.pData.QOutPut],eax
	ret

EndProc KickTx

;******************************************************************************
;
; ExtCom_FN1
;
; Description:
;		similar to receiving an X-OFF char. Buffered xmission of
;		chars is halted until and X-ON char is received, or until
;		we fake that with a clear X-Off call.
; Entry:
;		ESI -> PortInformation struct
;		EDX = port base, interrupts off.
; Exit:
;		CLC.
; Uses:
;		Flags
;==============================================================================
BeginProc ExtCom_FN1, PUBLIC

	or	[esi.HSFlag],XOffReceived
PUBLIC	ExtComDummy
ExtComDummy:
	clc
	ret
EndProc ExtCom_FN1

;******************************************************************************
;
; ExtCom_FN2
;
; Description:
;		Similar to receiving X-Off char. Buffered xmission is
;		restarted.
; Entry:
;		ESI -> PortInformation struct
;		EDX = port base, interrupts disabled.
; Exit:
;		CLC
; Uses:
;		Same as KickTx + flags.
;==============================================================================
BeginProc ExtCom_FN2, PUBLIC

	and	[esi.HSFlag],NOT XoffReceived
	call	KickTx			; kick transmitter interrupts on
	clc
	ret
EndProc ExtCom_FN2

;******************************************************************************
;
; ExtCom_FN3
;
; Description:
;		Set the RTS signal active
; Entry:
;		ESI --> PortInformation struct
;		EDX = port base, interrupts OFF
; Exit:
;		CLC
; Uses:
;		EAX,EDX
;==============================================================================
BeginProc ExtCom_FN3, PUBLIC

	add	dl,ACE_MCR		; --> modem control reg
	in	al,dx			; get current settings
	or	al,ACE_RTS		; set RTS
	IO_Delay
	out	dx,al			; and update
	clc
	ret
EndProc ExtCom_FN3

;******************************************************************************
;
; ExtCom_FN4
;
; Description:
;		Set the RTS signal INACTIVE.
; Entry:
;		ESI --> PortInformation struct
;		EDX = port base, interrupts off
; Exit:
;		CLC
; Uses:
;		EDX,EAX
;==============================================================================
BeginProc ExtCom_FN4, PUBLIC

	add	dl,ACE_MCR		; --> modem control reg
	in	al,dx			; get current settings
	and	al,NOT ACE_RTS		; clear RTS
	IO_Delay
	out	dx,al			; update
	clc
	ret
EndProc ExtCom_FN4

;******************************************************************************
;
; ExtCom_FN5
;
; Description:
;		Set DTR
; Entry:
;		ESI -> PortInformation struct
;		EDX = port base, interrupts off
; Exit:
;		CLC
; Uses:
;		EAX,EDX
;==============================================================================
BeginProc ExtCom_FN5, PUBLIC

	add	dl,ACE_MCR		; --> modem control reg
	in	al,dx			; current settings
	or	al,ACE_DTR		; set DTR
	IO_Delay
	out	dx,al			; update
	clc
	ret
EndProc ExtCom_FN5

;******************************************************************************
;
; ExtCom_FN6
;
; Description:
;		Clear DTR signal
; Entry:
;		ESI -> PortInformation struct
;		EDX = port base, interrupts off
; Exit:
;		CLC
; Uses:
;		EAX,EDX
;==============================================================================
BeginProc ExtCom_FN6, PUBLIC

	add	dl,ACE_MCR		; --> Modem control reg
	in	al,dx			; current settings
	and	al,NOT ACE_DTR		; turn it off
	IO_delay
	out	dx,al			; update
	clc
	ret
EndProc ExtCom_FN6

;******************************************************************************
;
; ExtCom_FN7
;
; Description:
;		Assert the RESET line on an LPT port, useless for us.
; Entry:
;		ESI -> PortInformation struct
;		EDX = port base, interrupts off
; Exit:
;		CLC
; Uses:
;		None.
;==============================================================================
BeginProc ExtCom_FN7, PUBLIC
	sti
	clc
	ret
EndProc ExtCom_FN7

;******************************************************************************
;
; ExtCom_FN10
;
; Description:
;		Get COM port base and IRQ
; Entry:
;		EDX = port base
;		ESI -> PortInformation struct
; Exit:
;		EAX = (IRQ,base)
; Uses:
;		FLAGS,eax,edx
;==============================================================================
BeginProc ExtCom_FN10, PUBLIC

	movzx	eax,[esi.IRQn]
	shl	eax,16
	mov	ax,WORD PTR [esi.Port]
	stc
	ret
EndProc ExtCom_FN10

if 0

;******************************************************************************
;
; Notify_Owner:
;
; Description:	notifies owner of events
;
; Entry:	EAX = message ID
;		ESI -> PortInformation
; Exit:	
;		None
; Uses:
;		None.
;==============================================================================
BeginProc Notify_Owner, PUBLIC

	pushad

	or	[esi.NotifyFlagsHI],al	; AL has notifications to send
	mov	ebx,[esi.AddrEvtDWord]
	push	dword ptr [ebx]		; sub-event
	push	eax			; event
	cmp	eax,CN_EVENT
	jne	NO_NotEvent


	push	[esi.ReferenceData]	; reference data
	push	esi			; hPort
	call	[esi.NotifyHandle]
	jmp	NO_Done

NO_NotEvent:


	cmp	eax,CN_RECEIVE
	jne	NO_NotReceive


	push	[esi.ReadNotifyRefData]	; reference data
	push	esi			; hPort
	call	[esi.ReadNotifyHandle]
	jmp	NO_Done

NO_NotReceive:
	cmp	eax,CN_TRANSMIT
	jne	NO_Nothing


	push	[esi.WriteNotifyRefData]; reference data
	push	esi			; hPort
	call	[esi.WriteNotifyHandle]
	jmp NO_Done
	
NO_Nothing:			; Shouldn't be here.


	push	eax
	push	eax
NO_Done:
	add	esp,16			; clear stack
	popad
	ret
EndProc Notify_Owner

endif


IF 01
; original

;******************************************************************************
;
; Notify_Owner:
;
; Description:	notifies owner of events
;
; Entry:	EAX = message ID
;		ESI -> PortInformation
; Exit:	
;		None
; Uses:
;		None.
;==============================================================================
BeginProc Notify_Owner, PUBLIC

	pushad
	or	[esi.NotifyFlagsHI],al	; AL has notifications to send
	mov	ebx,[esi.AddrEvtDWord]
	push	dword ptr [ebx]		; sub-event
	push	eax			; event
	cmp	eax,CN_EVENT
	jne	NO_NotEvent
	push	[esi.ReferenceData]	; reference data
	push	esi			; hPort
	call	[esi.NotifyHandle]
	jmp	NO_Done

NO_NotEvent:
	cmp	eax,CN_RECEIVE
	jne	NO_NotReceive
	push	[esi.ReadNotifyRefData]	; reference data
	push	esi			; hPort
	call	[esi.ReadNotifyHandle]
	jmp	NO_Done

NO_NotReceive:
	cmp	eax,CN_TRANSMIT
	jne	NO_Done
	push	[esi.WriteNotifyRefData]; reference data
	push	esi			; hPort
	call	[esi.WriteNotifyHandle]

NO_Done:
	add	esp,16			; clear stack
	popad
	ret
EndProc Notify_Owner

ENDIF

IF 0
;******************************************************************************
;
; TimerProc
;
; Description:
;	Checks if any port is active. If a port owner wants a receive
;	notification and none has been sent and at least one byte is in the
;	queue, then it will call Notify_Owner for that port
;
; Entry:
;	EDX -> ActiveCOMs
; Exit:
;	None
; Uses:
;	ALL
;==============================================================================

BeginProc TimerProc, PUBLIC

	mov	[TimeOutHandle],0	; reset timer handle

	mov	ebx,[edx]		; get the active COMs
	or	ebx,ebx
	jz	TP_Done
	mov	edi,OFFSET32 PortInfoPtrs
	mov	ecx,MAXCOM+1

TP_Lp:
	mov	esi,[edi]		; ESI -> PortInformation
	shr	ebx,1
	jnc	TP_lpend

	cmp	[esi.RecvTrigger],-1	; Q: Owner wants notification?
	je	TP_lpend		;  N: skip notify
	cmp	[esi.pData.QInCount],0	; Q: anything in input queue ?
	je	TP_lpend		;  N: skip notify
	test	[esi.NotifyFlagsHI],CN_RECEIVE ;Q: timeout notify sent ?
	jnz	TP_lpend		;  N: skip notify
	xor	[esi.NotifyFlagsHI],CN_IDLE ; Q: first timer call ?
	js	TP_lpend		;  Y: skip notify

	mov	eax,CN_RECEIVE
	call	Notify_Owner

TP_lpend:
	add	edi,4			; next PortInformation
	or	ebx,ebx			; any more active ports ?
	loopnz	TP_lp

TP_NoActive:
	mov	eax,100
	mov	edx,OFFSET32 ActiveCOMs
	mov	esi,OFFSET32 TimerProc
	VMMCall	Set_Global_Time_Out
	mov	[TimeOutHandle],esi	; save timer handle

TP_Done:
	ret

EndProc TimerProc

ENDIF


VxD_Locked_Code_Ends

	end
