#include <stdio.h>
#include <stdlib.h>
#include <conio.h>   

unsigned int LocalPort = 0;
static int IrqArray [16] = 
    {0xFF, 0xFF, 0xFF, 0x1, 0x2, 0x3, 0x4, 0x5, 0xFF, 0x6, 0x7, 0x8, 0x9, 0xFF, 0xA, 0xB};

void Write (unsigned int reg, int data)
{
    _outp (LocalPort+reg, data);
}

int Read (unsigned int reg)
{
    return (_inp (LocalPort+reg));
}

void main (void)
{
    FILE *configFile;                     
    int irq;
    char str[80];
    
    if (!(configFile = fopen ("ti.cfg", "r")))
    {
        printf ("file does not exist\n");
        exit (1);
    }
    
    fscanf (configFile, "%s%d", str, &irq);
    printf ("%s %d\n", str, irq);
    if (IrqArray[irq] == 0xFF)
    {
        printf ("invalid interrupt request\n");
        exit (1);
    }
    fscanf (configFile, "%s%x", str, &LocalPort);
    printf ("%s %x\n", str, LocalPort);
    
    Write (9, 0x80);
    Write (0x0B, IrqArray[irq] | 0x40);
    printf ("TIR2000 initialized\n");   
}