*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.  
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers make no warranties, either expressed
** or implied, with respect to this model, including the warranties of 
** merchantability or fitness for a particular purpose.  The model is
** provided solely on an "as is" basis.  The entire risk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:               TS3USBA225
* Date:               3/04/11
* Model Type:         Transient  
* Simulator:          HSPICE
* Simulator Version:  HSPICE_A-2008.03-SP1 on Windows
* Datasheet:          Preliminary - Subject to Change. Last Updated on 1/11/2011
*
* Model Version:      1.0
*
*****************************************************************************
*
* Updates:
*
* Version 1.0 :       Original Netlist of the Device without Package Information
*
*****************************************************************************
*subckt TS3USBA225_CHIP_NOCP sel2 r d0p sel1 d1n dpl dnr l d0n vdd gnd d1p
*
*ends TS3USBA225_CHIP_NOCP
*****************************************************************************

.PARAM vdd=3.3
.PARAM tr=5e-9

.PROBE TRAN
+    V(r)
+    V(l)
+    V(d1n)
+    V(d1p)
+    V(don)
+    V(dop)
+    V(dpl)
+    V(dnr)
+    V(sel2)
+    V(sel1)
+    V(vdd)
.TRAN 500e-12 1.4e-3 START=0.0

.OP

.TEMP 25

.OPTION ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTION METHOD=GEAR

.INCLUDE "process_models_encrypt.sp"
.INCLUDE "TS3USBA225_subckt_encrypt.sp"
.INCLUDE "dc_sources_encrypt.sp"

************************************
c5 0   d1n 35e-12
c3 0   l   35e-12
c2 0   dop 35e-12
c1 r   0   35e-12
c0 don 0   35e-12
c4 0   d1p 35e-12
r4 0   l   50
r1 0   dop 50
r5 r   0   50
r0 don 0   50
r3 0   d1n 50
r2 0   d1p 50
vvdd vdd  0 DC=vdd PWL 0 0 tr vdd TD=0

vsl1  sel1 0 DC=0 PWL   0 0  320e-6 0  320.00001e-6 vdd   640e-6 vdd 
+ 640.00001e-6 0 960e-6 0 960.00001e-6 vdd 1280e-6 vdd 1280.00001e-6 0  TD=0
*
vsl2  sel2 0 DC=0 PWL   0 0  160e-6 0  160.00001e-6 vdd   320e-6 vdd 
+	       320.00001e-6 0  480e-6 0  480.00001e-6 vdd   640e-6 vdd 
+	       640.00001e-6 0  800e-6 0  800.00001e-6 vdd   960e-6 vdd
+	       960.00001e-6 0 1120e-6 0 1120.00001e-6 vdd  1280e-6 vdd  
+	      1280.00001e-6 0  TD=0


v4   dnr  0 DC=vdd
v3   dpl  0 DC=vdd
xchip sel2 r dop sel1 d1n dpl dnr l don vdd 0 d1p TS3USBA225_CHIP_NOCP
.END
