************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
* SLL APPLICATIONS
* DATE : May, 2002
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      SSTVF16857INC.INC   (netlist)
*      p25c21aninc.inc     (Nominal process models)
*      p25c21asinc.inc     (Strong  process models) 	
*      p25c21awinc.inc     (Weak    process models)
*      READ.ME             (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (p25c21asINC)
*				     the weak   (p25c21awINC)
*				     the nominal(p25c21anINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 SSTVF16857INC
	X_PROCESS_SELECTOR 0 p25c21anINC
*	X_PROCESS_SELECTOR 0 p25c21asINC
*	X_PROCESS_SELECTOR 0 p25c21awINC
	.include resistor_modn
*	.include resistor_mods
*	.include resistor_modw
	.include tssop48
***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xsstvf16857 x_RESET_ x_CLK x_CLK_ x_VREF x_D1 x_Q1 x_VDDQ x_CVCC x_CGND sstvf16857

***********************************************************************
******Supply Voltages
***********************************************************************
v_gnd	x_CGND	0	DC	biaslv
v_vcc	x_CVCC	0	DC	biashv
v_vddq	x_VDDQ	0	DC	biasqv
v_vref	x_vref	0	DC	biasrv
v_vtt	x_VTT	0	DC	biastv

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT sstvf16857 p_reset_ p_clk p_clk_ p_vref p_d1 p_q1 p_VDDQ p_CVCC p_CGND
 X_PIN1		p_q1		s_q1		tssop48_01
 X_PIN34	p_reset_	s_reset_	tssop48_34
 X_PIN35	p_vref		s_vref		tssop48_35
 X_PIN38	p_clk		s_clk		tssop48_38
 X_PIN39	p_clk_		s_clk_		tssop48_39
 X_PIN48	p_d1		s_d1		tssop48_48
 X_PIN4		p_VDDQ		s_VDDQ		tssop48_04
 X_PIN9		p_VDDQ		s_VDDQ		tssop48_09
 X_PIN12	p_VDDQ		s_VDDQ		tssop48_12
 X_PIN16	p_VDDQ		s_VDDQ		tssop48_16
 X_PIN21	p_VDDQ		s_VDDQ		tssop48_21
 X_PIN28	p_CVCC		s_CVCC		tssop48_28
 X_PIN37	p_CVCC		s_CVCC		tssop48_37
 X_PIN3		p_CGND		s_CGND		tssop48_03
 X_PIN8		p_CGND		s_CGND		tssop48_08
 X_PIN13	p_CGND		s_CGND		tssop48_13
 X_PIN17	p_CGND		s_CGND		tssop48_17
 X_PIN22	p_CGND		s_CGND		tssop48_22
 X_PIN27	p_CGND		s_CGND		tssop48_27
 X_PIN36	p_CGND		s_CGND		tssop48_36
 X_PIN46	p_CGND		s_CGND		tssop48_46
xsstvf16857 s_reset_ s_clk s_clk_ s_vref s_d1 s_q1 s_VDDQ s_CVCC s_CGND sstvf16857__bit
.ENDs sstvf16857

***********************************************************************
.temp 25
.param er=1ns			$signal generator output edge rate
.param freq=133xHz		$signal generator frequency x=Meg
.param perc='1/freq'		$period of clock generator output cycle
.param pwc='(perc/2)-er'	$width of clock high and low level portion of cycle
.param perd='2*perc'		$period of clock generator output cycle
.param pwd='(perd/2)-er'	$width of clock high and low level portion of cycle

.param rt=50
.param cl=30p

.param VCC=2.50			$min=2.300, typ=2.500, max=2.700 Volts power supply

.param biaslv=0.0
.param biashv=VCC
.param biasqv=VCC
.param biasrv='VCC/2'
.param biastv='VCC/2'
.param lowclk=1.05
.param higclk=1.45
.param lowdat=0.90
.param higdat=1.60

***********************************************************************
**** TRANSIENT ANALYSES <-------
**** Propagation test (LH/HL)
***********************************************************************
.TRAN         0.05NS 100NS

V_RESET_	x_RESET_	0	DC	biashv
V_CLK_		x_CLK_		0	PULSE	(lowclk higclk 'perc/2' er er pwc perc)
V_CLK		x_CLK		0	PULSE	(lowclk higclk  perc    er er pwc perc)
V_D1		x_D1		0	PULSE	(lowdat higdat '(2*perc)-er' er er pwd perd)

Cl1		x_Q1	0	cl
*Rt1		x_D1	x_VTT	rt

***********************************************************************

.END
