************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
* SLL APPLICATIONS
* DATE : December, 2003
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      SSTVF16859INC.INC   (netlist)
*      p25c21aninc.inc     (Nominal process models)
*      p25c21asinc.inc     (Strong  process models) 	
*      p25c21awinc.inc     (Weak    process models)
*      READ.ME             (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (p25c21asINC)
*				     the weak   (p25c21awINC)
*				     the nominal(p25c21anINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 SSTVF16859INC
*	X_PROCESS_SELECTOR 0 p25c21anINC
	X_PROCESS_SELECTOR 0 p25c21asINC
*	X_PROCESS_SELECTOR 0 p25c21awINC
*	.include resistor_modn
	.include resistor_mods
*	.include resistor_modw
	.include tssop64
	.include qfn64

***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xsstvf16859 x_RESET_ x_CLK x_CLK_ x_VREF x_D1 x_Q1A x_Q1B x_VDDQ x_CVCC x_CGND sstvf16859

***********************************************************************
******Supply Voltages
***********************************************************************
vv_gnd	x_CGND	0	DC	biaslv
v_vcc	x_CVCC	0	DC	biashv
v_vddq	x_VDDQ	0	DC	biasqv
v_vref	x_VREF	0	DC	biasrv

***********************************************************************
******Subcircuit for package connection
***********************************************************************
*.SUBCKT sstvf16859 p_RESET_ p_CLK p_CLK_ p_VREF p_D1 p_Q1A p_Q1B p_VDDQ p_CVCC p_CGND
* X_PIN16	p_Q1A		s_Q1A		tssop64_16
* X_PIN32	p_Q1B		s_Q1B		tssop64_32
* X_PIN35	p_D1		s_D1		tssop64_35
* X_PIN45	p_VREF		s_VREF		tssop64_45
* X_PIN48	p_CLK		s_CLK		tssop64_48
* X_PIN49	p_CLK_		s_CLK_		tssop64_49
* X_PIN51	p_RESET_	s_RESET_	tssop64_51
* X_PIN6	p_VDDQ		s_VDDQ		tssop64_06
* X_PIN18	p_VDDQ		s_VDDQ		tssop64_18
* X_PIN27	p_VDDQ		s_VDDQ		tssop64_27
* X_PIN33	p_VDDQ		s_VDDQ		tssop64_33
* X_PIN38	p_VDDQ		s_VDDQ		tssop64_38
* X_PIN47	p_VDDQ		s_VDDQ		tssop64_47
* X_PIN59	p_VDDQ		s_VDDQ		tssop64_59
* X_PIN64	p_VDDQ		s_VDDQ		tssop64_64
* X_PIN37	p_CVCC		s_CVCC		tssop64_37
* X_PIN60	p_CVCC		s_CVCC		tssop64_60
* X_PIN7	p_CGND		s_CGND		tssop64_07
* X_PIN15	p_CGND		s_CGND		tssop64_15
* X_PIN26	p_CGND		s_CGND		tssop64_26
* X_PIN34	p_CGND		s_CGND		tssop64_34
* X_PIN39	p_CGND		s_CGND		tssop64_39
* X_PIN43	p_CGND		s_CGND		tssop64_43
* X_PIN50	p_CGND		s_CGND		tssop64_50
* X_PIN54	p_CGND		s_CGND		tssop64_54
* X_PIN58	p_CGND		s_CGND		tssop64_58
* X_PIN63	p_CGND		s_CGND		tssop64_63
*xsstvf16859 s_RESET_ s_CLK s_CLK_ s_VREF s_D1 s_Q1A s_Q1B s_VDDQ s_CVCC s_CGND sstvf16859__bit
*.ENDs sstvf16859


.SUBCKT sstvf16859 p_RESET_ p_CLK p_CLK_ p_VREF p_D1 p_Q1A p_Q1B p_VDDQ p_CVCC p_CGND
 X_PIN7		p_Q1A		s_Q1A		qfn64_07
 X_PIN22	p_Q1B		s_Q1B		qfn64_22
 X_PIN24	p_D1		s_D1		qfn64_24
 X_PIN32	p_VREF		s_VREF		qfn64_32
 X_PIN35	p_CLK		s_CLK		qfn64_35
 X_PIN36	p_CLK_		s_CLK_		qfn64_36
 X_PIN38	p_RESET_	s_RESET_	qfn64_38
 X_PIN9		p_VDDQ		s_VDDQ		qfn64_09
 X_PIN17	p_VDDQ		s_VDDQ		qfn64_17
 X_PIN23	p_VDDQ		s_VDDQ		qfn64_23
 X_PIN27	p_VDDQ		s_VDDQ		qfn64_27
 X_PIN34	p_VDDQ		s_VDDQ		qfn64_34
 X_PIN44	p_VDDQ		s_VDDQ		qfn64_44
 X_PIN49	p_VDDQ		s_VDDQ		qfn64_49
 X_PIN55	p_VDDQ		s_VDDQ		qfn64_55
 X_PIN26	p_CVCC		s_CVCC		qfn64_26
 X_PIN45	p_CVCC		s_CVCC		qfn64_45
 X_PIN37	p_CGND		s_CGND		qfn64_37
 X_PIN48	p_CGND		s_CGND		qfn64_48
 X_PIN57	p_CGND		s_CGND		qfn64_57
 X_PIN58	p_CGND		s_CGND		qfn64_58
 X_PIN59	p_CGND		s_CGND		qfn64_59
 X_PIN60	p_CGND		s_CGND		qfn64_60
 X_PIN61	p_CGND		s_CGND		qfn64_61
 X_PIN62	p_CGND		s_CGND		qfn64_62
 X_PIN63	p_CGND		s_CGND		qfn64_63
 X_PIN64	p_CGND		s_CGND		qfn64_64
xsstvf16859 s_RESET_ s_CLK s_CLK_ s_VREF s_D1 s_Q1A s_Q1B s_VDDQ s_CVCC s_CGND sstvf16859__bit
.ENDs sstvf16859


***********************************************************************
.temp -40			$-40 deg. C (strong); 25 deg. C (nominal) 85 deg. C (weak)
.param er=0.8ns			$signal generator output edge rate
.param freq=200xHz		$signal generator frequency x=Meg
.param perc='1/freq'		$period of clock generator output cycle
.param pwc='(perc/2)-er'	$width of clock high and low level portion of cycle
.param perd='2*perc'		$period of clock generator output cycle
.param pwd='(perd/2)-er'	$width of clock high and low level portion of cycle

.param rl=500
.param cl=30p

.param VCC=2.70			$min=2.300, typ=2.500, max=2.700 Volts power supply

.param biaslv=0.0
.param biashv=VCC
.param biasqv=VCC
.param biasrv='VCC/2'
.param biastv='VCC/2'
.param lowclk=1.05
.param higclk=1.45
.param lowdat=0.90
.param higdat=1.60

***********************************************************************
**** TRANSIENT ANALYSES <-------
**** Propagation test (LH/HL)
***********************************************************************
.TRAN         0.05NS 50NS

V_RESET_	x_RESET_	0	DC	biashv
V_CLK_		x_CLK_		0	PULSE	(lowclk higclk 'perc/2'      er er pwc perc)
V_CLK		x_CLK		0	PULSE	(lowclk higclk 'perc/1'      er er pwc perc)
V_D1		x_D1		0	PULSE	(lowdat higdat '(perc/2)-er' er er pwd perd)

Cl1A		x_Q1A	0	cl
Rl1A		x_Q1A	0	rl
Cl1B		x_Q1B	0	cl
Rl1B		x_Q1B	0	rl

***********************************************************************

.END
