************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          ll Rights Reserved                                          *
*                                                                      *
*          UNLESS THERE IS  SIGNED, WRITTEN AGREEMENT TO THE           *
*          CONTRRY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE    *
*          MODELS "S IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR        *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL PPLICATIONS
* DTE : January, 2003
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS CCT OPTS       $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      ALVCH16973INC.INC    (netlist)
*      P33C21D3Ninc.inc     (Nominal process models)
*      P33C21D3Sinc.inc     (Strong process models) 	
*      P33C21D3Winc.inc     (Weak    process models)
*      READ.ME              (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (P33C21D3SINC)
*				     the weak   (P33C21D3WINC)
*				     the nominal(P33C21D3NINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*       .OPTIONS search='./'
	X_DEVICE_SELECTOR  0 ALVCH16973INC
*	X_PROCESS_SELECTOR 0 P33C21D3SINC
*	X_PROCESS_SELECTOR 0 P33C21D3NINC
	X_PROCESS_SELECTOR 0 P33C21D3WINC

	.include ssop48
*	.include tssop48

*	.include resistor_mods
*	.include resistor_modn
	.include resistor_modw

***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xALVCH16973 x_NTOE x_LE x_NLOE x_DIR x_A1 x_B1 x_Q1 x_D1 x_Y1 x_VCC 
+ x_GND ALVCH16973

***********************************************************************
******Supply Voltages
***********************************************************************
v_VCC		x_VCC		0	DC	3.3 
v_GND		x_GND		0	DC	0.0

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT ALVCH16973 p_NTOE p_LE p_NLOE p_DIR p_A1 p_B1 p_Q1 p_D1 p_Y1 
 + p_VCC p_GND
 X_PIN1		p_NTOE		s_NTOE		SSOP48_01
 X_PIN2		p_D1		s_D1		SSOP48_02
 X_PIN3		p_A1		s_A1		SSOP48_03
 X_PIN5		p_Y1		s_Y1		SSOP48_05
 X_PIN24	p_LE		s_LE		SSOP48_24
 X_PIN25	p_NLOE		s_NLOE		SSOP48_25
 X_PIN46	p_Q1		s_Q1		SSOP48_46
 X_PIN47	p_B1		s_B1		SSOP48_47
 X_PIN48	p_DIR		s_DIR		SSOP48_48
 X_PIN7		p_VCC		s_VCC		SSOP48_07
 X_PIN18	p_VCC		s_VCC		SSOP48_18
 X_PIN31	p_VCC		s_VCC		SSOP48_31
 X_PIN42	p_VCC		s_VCC		SSOP48_42
 X_PIN4		p_GND		s_GND		SSOP48_04
 X_PIN10	p_GND		s_GND		SSOP48_10
 X_PIN15	p_GND		s_GND		SSOP48_15
 X_PIN21	p_GND		s_GND		SSOP48_21
 X_PIN28	p_GND		s_GND		SSOP48_28
 X_PIN34	p_GND		s_GND		SSOP48_34
 X_PIN39	p_GND		s_GND		SSOP48_39
 X_PIN45	p_GND		s_GND		SSOP48_45
xALVCH16973bit s_NTOE s_LE s_NLOE s_DIR s_A1 s_B1 s_Q1 s_D1 s_Y1 s_VCC 
+ s_GND ALVCH16973__bit 
.ENDs ALVCH16973

***********************************************************************
.temp 25

.param er=0.5ns			$signal generator output edge rate

.param capload=50p
.param resload=500
.param biashv=3.3
.param biaslv=0.0

***********************************************************************
.TRAN         0.05NS 60NS
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)
V_DIR	x_DIR	0	DC	biashv
V_LE	x_LE	0	PULSE	(biashv biaslv 25ns  er er '3ns-er' 6ns)
V_A1	x_A1	0	PULSE	(biaslv biashv 0.5ns er er '6ns-er' 12ns)
V_D1	x_D1	0	PULSE	(biaslv biashv 0.5ns er er '6ns-er' 12ns)
V_NLOE	x_NLOE	0	PULSE	(biaslv biashv 1.5ns er er '12ns-er' 24ns)
V_NTOE	x_NTOE	0	PULSE	(biashv biaslv 1.5ns er er '12ns-er' 24ns)

R_B1	x_B1	0	resload
C_B1	x_B1	0	capload

R_Q1	x_Q1	0	resload
C_Q1	x_Q1	0	capload

R_Y1	x_Y1	0	resload
C_Y1	x_Y1	0	capload

***********************************************************************
.END

